/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sdb.layout2.index;

import org.apache.jena.sdb.layout2.index.TupleLoaderIndexBase;
import org.apache.jena.sdb.sql.SDBConnection;
import org.apache.jena.sdb.store.TableDesc;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TupleLoaderIndexOracle
extends TupleLoaderIndexBase {
    private static Logger log = LoggerFactory.getLogger(TupleLoaderIndexOracle.class);

    public TupleLoaderIndexOracle(SDBConnection connection, TableDesc tableDesc, int chunkSize) {
        super(connection, tableDesc, chunkSize);
    }

    @Override
    public String[] getNodeColTypes() {
        return new String[]{"NUMBER(20)", "NCLOB", "NVARCHAR2(10)", "NVARCHAR2(200)", "INT"};
    }

    @Override
    public String getTupleColType() {
        return "NUMBER(20)";
    }

    @Override
    public String[] getCreateTempTable() {
        return new String[]{"CREATE GLOBAL TEMPORARY TABLE", "ON COMMIT DELETE ROWS"};
    }

    @Override
    public boolean clearsOnCommit() {
        return true;
    }

    @Override
    public String getLoadTuples() {
        int i;
        StringBuilder stmt = new StringBuilder();
        stmt.append("INSERT INTO ").append(this.getTableName()).append(" \nSELECT DISTINCT ");
        for (i = 0; i < this.getTableWidth(); ++i) {
            if (i != 0) {
                stmt.append(" , ");
            }
            stmt.append("NI").append(i).append(".id");
        }
        stmt.append("\nFROM ").append(this.getTupleLoader()).append("\n");
        for (i = 0; i < this.getTableWidth(); ++i) {
            stmt.append("JOIN Nodes NI").append(i).append(" ON (");
            stmt.append(this.getTupleLoader()).append(".t").append(i).append("=NI").append(i).append(".hash)\n");
        }
        stmt.append("LEFT JOIN ").append(this.getTableName()).append(" ON (");
        for (i = 0; i < this.getTableWidth(); ++i) {
            if (i != 0) {
                stmt.append(" AND ");
            }
            stmt.append("NI").append(i).append(".id");
            stmt.append("=").append(this.getTableName()).append(".").append(this.getTableDesc().getColNames().get(i));
        }
        stmt.append(")\nWHERE\n");
        for (i = 0; i < this.getTableWidth(); ++i) {
            if (i != 0) {
                stmt.append(" OR\n");
            }
            stmt.append(this.getTableName()).append(".").append(this.getTableDesc().getColNames().get(i)).append(" IS NULL");
        }
        return stmt.toString();
    }

    @Override
    public String getLoadNodes() {
        StringBuilder stmt = new StringBuilder();
        stmt.append("BEGIN LOCK TABLE Nodes IN EXCLUSIVE MODE;\n");
        stmt.append("INSERT INTO Nodes \nSELECT nodeid.nextval , ");
        for (int i = 0; i < this.getNodeColTypes().length; ++i) {
            if (i != 0) {
                stmt.append(" , ");
            }
            stmt.append(this.getNodeLoader()).append(".").append("n").append(i);
        }
        stmt.append("\nFROM ").append(this.getNodeLoader()).append(" LEFT JOIN Nodes ON (");
        stmt.append(this.getNodeLoader()).append(".n0=Nodes.hash) \nWHERE Nodes.hash IS NULL");
        stmt.append(";\nEND;");
        return stmt.toString();
    }
}

