/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sdb.layout2.index;

import org.apache.jena.sdb.layout2.index.TupleLoaderIndexBase;
import org.apache.jena.sdb.sql.SDBConnection;
import org.apache.jena.sdb.store.TableDesc;

public class TupleLoaderIndexSAP
extends TupleLoaderIndexBase {
    public TupleLoaderIndexSAP(SDBConnection connection, TableDesc tableDesc, int chunkSize) {
        super(connection, tableDesc, chunkSize);
    }

    @Override
    public String[] getNodeColTypes() {
        return new String[]{"BIGINT", "NVARCHAR(5000)", "NVARCHAR(10)", "NVARCHAR(200)", "INT"};
    }

    @Override
    public String getTupleColType() {
        return "BIGINT";
    }

    @Override
    public String[] getCreateTempTable() {
        return new String[]{"CREATE GLOBAL TEMPORARY TABLE", ""};
    }

    @Override
    public boolean clearsOnCommit() {
        return true;
    }

    @Override
    public String getLoadNodes() {
        StringBuilder stmt = new StringBuilder();
        stmt.append("INSERT INTO Nodes \nSELECT nodeid.nextval , ");
        for (int i = 0; i < this.getNodeColTypes().length; ++i) {
            if (i != 0) {
                stmt.append(" , ");
            }
            stmt.append(this.getNodeLoader()).append(".").append("n").append(i);
        }
        stmt.append("\nFROM ").append(this.getNodeLoader()).append(" LEFT JOIN Nodes ON (");
        stmt.append(this.getNodeLoader()).append(".n0=Nodes.hash) \nWHERE Nodes.hash IS NULL");
        return stmt.toString();
    }
}

