/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sdb.store;

import org.apache.jena.sdb.Store;
import org.apache.jena.sdb.StoreDesc;
import org.apache.jena.sdb.compiler.QueryCompilerFactory;
import org.apache.jena.sdb.core.sqlnode.GenerateSQL;
import org.apache.jena.sdb.layout2.StoreBase;
import org.apache.jena.sdb.layout2.TableDescNodes;
import org.apache.jena.sdb.layout2.TableDescQuads;
import org.apache.jena.sdb.layout2.TableDescTriples;
import org.apache.jena.sdb.sql.SDBConnection;
import org.apache.jena.sdb.store.SQLBridgeFactory;
import org.apache.jena.sdb.store.StoreFormatter;
import org.apache.jena.sdb.store.StoreLoader;
import org.apache.jena.sdb.util.HSQLUtils;
import org.apache.jena.sdb.util.StoreUtils;

public abstract class StoreBaseHSQL
extends StoreBase {
    protected boolean currentlyOpen = true;

    public StoreBaseHSQL(SDBConnection connection, StoreDesc desc, StoreFormatter formatter, StoreLoader loader, QueryCompilerFactory compilerF, SQLBridgeFactory sqlBridgeF, TableDescTriples tripleTableDesc, TableDescQuads quadTableDesc, TableDescNodes nodeTableDesc) {
        super(connection, desc, formatter, loader, compilerF, sqlBridgeF, new GenerateSQL(), tripleTableDesc, quadTableDesc, nodeTableDesc);
    }

    @Override
    public void close() {
        if (this.currentlyOpen) {
            super.close();
            HSQLUtils.shutdown(this.getConnection());
        }
        this.currentlyOpen = false;
        super.close();
    }

    public static void close(Store store) {
        if (StoreUtils.isHSQL(store)) {
            ((StoreBaseHSQL)store).close();
        }
    }

    public static void checkpoint(Store store) {
        if (StoreUtils.isHSQL(store)) {
            ((StoreBaseHSQL)store).checkpoint();
        }
    }

    public void checkpoint() {
        if (this.currentlyOpen) {
            HSQLUtils.checkpoint(this.getConnection());
        }
    }
}

