/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sdb.store;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.jena.sdb.sql.RS;
import org.apache.jena.sdb.sql.ResultSetJDBC;
import org.apache.jena.sdb.sql.SDBConnection;
import org.apache.jena.sdb.sql.SDBConnectionHolder;
import org.apache.jena.sdb.sql.SDBExceptionSQL;
import org.apache.jena.sdb.sql.SQLUtils;
import org.apache.jena.sdb.sql.TableUtils;

class TaggedString
extends SDBConnectionHolder {
    static final String stringTableName = "Strings";
    static final String columnName = "tag";
    static final String columnData = "data";
    private boolean initialized = false;

    TaggedString(SDBConnection sdb) {
        super(sdb);
    }

    void reset() {
        String sqlStmt1 = SQLUtils.sqlStr("DROP TABLE Strings");
        String sqlStmt2 = SQLUtils.sqlStr("CREATE TABLE Strings", "( tag VARCHAR(200) NOT NULL,", "  data VARCHAR(20000) NOT NULL ,", "  PRIMARY KEY(tag)", ")");
        try {
            if (TableUtils.hasTable(this.connection().getSqlConnection(), stringTableName, new String[0])) {
                this.connection().execUpdate(sqlStmt1);
            }
            this.connection().execUpdate(sqlStmt2);
        }
        catch (SQLException ex) {
            throw new SDBExceptionSQL("NamedString.reset", ex);
        }
    }

    private void init() {
        if (this.initialized) {
            return;
        }
    }

    List<String> tags() {
        ArrayList<String> arrayList;
        ResultSetJDBC rs = null;
        try {
            String sqlStmt = SQLUtils.sqlStr("SELECT tag", "FROM Strings");
            rs = this.connection().execQuery(sqlStmt);
            ArrayList<String> tags = new ArrayList<String>();
            while (rs.get().next()) {
                String x = rs.get().getString(columnName);
                tags.add(x);
            }
            arrayList = tags;
        }
        catch (SQLException ex) {
            try {
                throw new SDBExceptionSQL("getString", ex);
            }
            catch (Throwable throwable) {
                RS.close(rs);
                throw throwable;
            }
        }
        RS.close(rs);
        return arrayList;
    }

    void remove(String tag) {
        try {
            this.connection().exec("DELETE FROM Strings WHERE tag=" + SQLUtils.quoteStr(tag));
        }
        catch (SQLException ex) {
            throw new SDBExceptionSQL(ex);
        }
    }

    void set(String tag, String value) {
        this.remove(tag);
        value = this.encode(value);
        try {
            this.connection().exec("INSERT INTO Strings VALUES (" + SQLUtils.quoteStr(tag) + ", " + SQLUtils.quoteStr(value) + ")");
        }
        catch (SQLException ex) {
            throw new SDBExceptionSQL("set", ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    String get(String tag) {
        String string;
        ResultSetJDBC rs;
        boolean b;
        block8: {
            String string2;
            block7: {
                b = this.connection().loggingSQLExceptions();
                this.connection().setLogSQLExceptions(false);
                rs = null;
                try {
                    String sqlStmt = SQLUtils.sqlStr("SELECT data", "FROM Strings", "WHERE tag = " + SQLUtils.quoteStr(tag));
                    rs = this.connection().execQuery(sqlStmt);
                    if (!rs.get().next()) {
                        string2 = null;
                        this.connection().setLogSQLExceptions(b);
                        break block7;
                    }
                    String x = rs.get().getString(columnData);
                    string = this.decode(x);
                    this.connection().setLogSQLExceptions(b);
                    break block8;
                }
                catch (SQLException ex) {
                    String string3 = null;
                    return string3;
                }
            }
            RS.close(rs);
            return string2;
        }
        RS.close(rs);
        return string;
        finally {
            this.connection().setLogSQLExceptions(b);
            RS.close(rs);
        }
    }

    private String encode(String s) {
        return s;
    }

    private String decode(String s) {
        return s;
    }
}

