/*
 * Decompiled with CFR 0.152.
 */
package sdb;

import java.util.List;
import jena.cmd.ArgDecl;
import jena.cmd.CmdException;
import org.apache.jena.atlas.lib.Lib;
import org.apache.jena.query.Dataset;
import org.apache.jena.query.Syntax;
import org.apache.jena.sdb.SDB;
import org.apache.jena.sdb.compiler.SDB_QC;
import org.apache.jena.update.UpdateExecutionFactory;
import org.apache.jena.update.UpdateFactory;
import org.apache.jena.update.UpdateRequest;
import sdb.cmd.CmdArgsDB;

public class sdbupdate
extends CmdArgsDB {
    static final ArgDecl updateArg = new ArgDecl(true, new String[]{"update", "file"});
    List<String> requestFiles = null;
    static final String divider = "- - - - - - - - - - - - - -";

    public static void main(String ... argv) {
        SDB.init();
        new sdbupdate(argv).mainRun();
    }

    protected sdbupdate(String ... args) {
        super(args);
        super.add(updateArg, "--update=FILE", "Update commands to execute");
    }

    protected String getCommandName() {
        return Lib.className((Object)((Object)this));
    }

    protected String getSummary() {
        return this.getCommandName() + " <SPEC> [ <update> |  --update=file ]";
    }

    protected void processModulesAndArgs() {
        super.processModulesAndArgs();
    }

    @Override
    protected void execCmd(List<String> positionalArgs) {
        if (this.isVerbose()) {
            SDB_QC.PrintSQL = true;
        }
        this.getStore();
        Dataset dataset = this.getModStore().getDataset();
        List requestFiles = this.getValues(updateArg);
        if (requestFiles.size() == 0 && this.getPositional().size() == 0) {
            throw new CmdException("Nothing to do");
        }
        for (String filename : requestFiles) {
            this.execOneFile(filename, dataset);
        }
        for (String requestString : super.getPositional()) {
            requestString = this.indirect(requestString);
            this.execOne(requestString, dataset);
        }
    }

    private void execOneFile(String filename, Dataset store) {
        UpdateRequest req = UpdateFactory.read((String)filename, (Syntax)Syntax.syntaxARQ);
        UpdateExecutionFactory.create((UpdateRequest)req, (Dataset)store).execute();
    }

    private void execOne(String requestString, Dataset store) {
        UpdateRequest req = UpdateFactory.create((String)requestString, (Syntax)Syntax.syntaxARQ);
        UpdateExecutionFactory.create((UpdateRequest)req, (Dataset)store).execute();
    }
}

