/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.cli.avalon;

import java.util.Arrays;
import org.apache.commons.cli.avalon.CLOptionDescriptor;

public final class CLOption {
    public static final int TEXT_ARGUMENT = 0;
    private static final CLOptionDescriptor TEXT_ARGUMENT_DESCRIPTOR = new CLOptionDescriptor(null, 4, 0, null);
    private String[] m_arguments;
    private CLOptionDescriptor m_descriptor = TEXT_ARGUMENT_DESCRIPTOR;

    public final String getArgument() {
        return this.getArgument(0);
    }

    public final String getArgument(int index) {
        if (null == this.m_arguments || index < 0 || index >= this.m_arguments.length) {
            return null;
        }
        return this.m_arguments[index];
    }

    public final CLOptionDescriptor getDescriptor() {
        return this.m_descriptor;
    }

    public CLOption(CLOptionDescriptor descriptor) {
        if (descriptor != null) {
            this.m_descriptor = descriptor;
        }
    }

    public CLOption(String argument) {
        this((CLOptionDescriptor)null);
        this.addArgument(argument);
    }

    public final void addArgument(String argument) {
        if (null == this.m_arguments) {
            this.m_arguments = new String[]{argument};
        } else {
            String[] arguments = new String[this.m_arguments.length + 1];
            System.arraycopy(this.m_arguments, 0, arguments, 0, this.m_arguments.length);
            arguments[this.m_arguments.length] = argument;
            this.m_arguments = arguments;
        }
    }

    public final int getArgumentCount() {
        if (null == this.m_arguments) {
            return 0;
        }
        return this.m_arguments.length;
    }

    public final String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        char id = (char)this.m_descriptor.getId();
        if (id == '\u0000') {
            sb.append("TEXT ");
        } else {
            sb.append("Option ");
            sb.append(id);
        }
        if (null != this.m_arguments) {
            sb.append(", ");
            sb.append(Arrays.asList(this.m_arguments));
        }
        sb.append(" ]");
        return sb.toString();
    }

    final String toShortString() {
        StringBuilder sb = new StringBuilder();
        char id = (char)this.m_descriptor.getId();
        if (id != '\u0000') {
            sb.append("-");
            sb.append(id);
        }
        if (null != this.m_arguments) {
            if (id != '\u0000') {
                sb.append("=");
            }
            sb.append(Arrays.asList(this.m_arguments));
        }
        return sb.toString();
    }
}

