/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jorphan.util;

import org.apache.commons.collections.ArrayStack;

public class XMLBuffer {
    private final StringBuilder sb = new StringBuilder();
    private final ArrayStack tags = new ArrayStack();

    private void startTag(String t) {
        this.sb.append("<");
        this.sb.append(t);
        this.sb.append(">");
    }

    private void endTag(String t) {
        this.sb.append("</");
        this.sb.append(t);
        this.sb.append(">");
        this.sb.append("\n");
    }

    private void emptyTag(String t) {
        this.sb.append("<");
        this.sb.append(t);
        this.sb.append("/>");
        this.sb.append("\n");
    }

    public XMLBuffer openTag(String tagname) {
        this.tags.push((Object)tagname);
        this.startTag(tagname);
        return this;
    }

    public XMLBuffer closeTag(String tagname) {
        String tag = (String)this.tags.pop();
        if (!tag.equals(tagname)) {
            throw new IllegalArgumentException("Trying to close tag: " + tagname + " ; should be " + tag);
        }
        this.endTag(tag);
        return this;
    }

    public XMLBuffer tag(String tagname, String content) {
        if (content.length() == 0) {
            this.emptyTag(tagname);
        } else {
            this.startTag(tagname);
            this.sb.append(content);
            this.endTag(tagname);
        }
        return this;
    }

    public XMLBuffer tag(String tagname, StringBuilder content) {
        if (content.length() == 0) {
            this.emptyTag(tagname);
        } else {
            this.startTag(tagname);
            this.sb.append((CharSequence)content);
            this.endTag(tagname);
        }
        return this;
    }

    public String toString() {
        while (!this.tags.isEmpty()) {
            this.endTag((String)this.tags.pop());
        }
        return this.sb.toString();
    }
}

