/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.admin;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.apache.kafka.clients.NodeApiVersions;
import org.apache.kafka.clients.admin.AdminClientConfig;
import org.apache.kafka.clients.admin.AdminClientUnitTestEnv;
import org.apache.kafka.clients.admin.CreateAclsResult;
import org.apache.kafka.clients.admin.CreatePartitionsResult;
import org.apache.kafka.clients.admin.CreateTopicsOptions;
import org.apache.kafka.clients.admin.DeleteAclsResult;
import org.apache.kafka.clients.admin.DeleteRecordsResult;
import org.apache.kafka.clients.admin.DeletedRecords;
import org.apache.kafka.clients.admin.DescribeConfigsResult;
import org.apache.kafka.clients.admin.KafkaAdminClient;
import org.apache.kafka.clients.admin.ListTopicsOptions;
import org.apache.kafka.clients.admin.ListTopicsResult;
import org.apache.kafka.clients.admin.NewPartitions;
import org.apache.kafka.clients.admin.NewTopic;
import org.apache.kafka.clients.admin.RecordsToDelete;
import org.apache.kafka.common.Cluster;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.PartitionInfo;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.acl.AccessControlEntry;
import org.apache.kafka.common.acl.AccessControlEntryFilter;
import org.apache.kafka.common.acl.AclBinding;
import org.apache.kafka.common.acl.AclBindingFilter;
import org.apache.kafka.common.acl.AclOperation;
import org.apache.kafka.common.acl.AclPermissionType;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.errors.InvalidTopicException;
import org.apache.kafka.common.errors.LeaderNotAvailableException;
import org.apache.kafka.common.errors.NotLeaderForPartitionException;
import org.apache.kafka.common.errors.OffsetOutOfRangeException;
import org.apache.kafka.common.errors.SecurityDisabledException;
import org.apache.kafka.common.errors.TimeoutException;
import org.apache.kafka.common.errors.UnknownTopicOrPartitionException;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.ApiError;
import org.apache.kafka.common.requests.CreateAclsResponse;
import org.apache.kafka.common.requests.CreatePartitionsResponse;
import org.apache.kafka.common.requests.CreateTopicsResponse;
import org.apache.kafka.common.requests.DeleteAclsResponse;
import org.apache.kafka.common.requests.DeleteRecordsResponse;
import org.apache.kafka.common.requests.DescribeAclsResponse;
import org.apache.kafka.common.requests.DescribeConfigsResponse;
import org.apache.kafka.common.requests.MetadataResponse;
import org.apache.kafka.common.requests.Resource;
import org.apache.kafka.common.requests.ResourceType;
import org.apache.kafka.common.resource.ResourceFilter;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.test.TestCondition;
import org.apache.kafka.test.TestUtils;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.Timeout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KafkaAdminClientTest {
    private static final Logger log = LoggerFactory.getLogger(KafkaAdminClientTest.class);
    @Rule
    public final Timeout globalTimeout = Timeout.millis((long)120000L);
    private static final AclBinding ACL1 = new AclBinding(new org.apache.kafka.common.resource.Resource(org.apache.kafka.common.resource.ResourceType.TOPIC, "mytopic3"), new AccessControlEntry("User:ANONYMOUS", "*", AclOperation.DESCRIBE, AclPermissionType.ALLOW));
    private static final AclBinding ACL2 = new AclBinding(new org.apache.kafka.common.resource.Resource(org.apache.kafka.common.resource.ResourceType.TOPIC, "mytopic4"), new AccessControlEntry("User:ANONYMOUS", "*", AclOperation.DESCRIBE, AclPermissionType.DENY));
    private static final AclBindingFilter FILTER1 = new AclBindingFilter(new ResourceFilter(org.apache.kafka.common.resource.ResourceType.ANY, null), new AccessControlEntryFilter("User:ANONYMOUS", null, AclOperation.ANY, AclPermissionType.ANY));
    private static final AclBindingFilter FILTER2 = new AclBindingFilter(new ResourceFilter(org.apache.kafka.common.resource.ResourceType.ANY, null), new AccessControlEntryFilter("User:bob", null, AclOperation.ANY, AclPermissionType.ANY));

    @Test
    public void testGetOrCreateListValue() {
        HashMap map = new HashMap();
        List fooList = KafkaAdminClient.getOrCreateListValue(map, (Object)"foo");
        Assert.assertNotNull((Object)fooList);
        fooList.add("a");
        fooList.add("b");
        List fooList2 = KafkaAdminClient.getOrCreateListValue(map, (Object)"foo");
        Assert.assertEquals((Object)fooList, (Object)fooList2);
        Assert.assertTrue((boolean)fooList2.contains("a"));
        Assert.assertTrue((boolean)fooList2.contains("b"));
        List barList = KafkaAdminClient.getOrCreateListValue(map, (Object)"bar");
        Assert.assertNotNull((Object)barList);
        Assert.assertTrue((boolean)barList.isEmpty());
    }

    @Test
    public void testCalcTimeoutMsRemainingAsInt() {
        Assert.assertEquals((long)0L, (long)KafkaAdminClient.calcTimeoutMsRemainingAsInt((long)1000L, (long)1000L));
        Assert.assertEquals((long)100L, (long)KafkaAdminClient.calcTimeoutMsRemainingAsInt((long)1000L, (long)1100L));
        Assert.assertEquals((long)Integer.MAX_VALUE, (long)KafkaAdminClient.calcTimeoutMsRemainingAsInt((long)0L, (long)Long.MAX_VALUE));
        Assert.assertEquals((long)Integer.MIN_VALUE, (long)KafkaAdminClient.calcTimeoutMsRemainingAsInt((long)Long.MAX_VALUE, (long)0L));
    }

    @Test
    public void testPrettyPrintException() {
        Assert.assertEquals((Object)"Null exception.", (Object)KafkaAdminClient.prettyPrintException(null));
        Assert.assertEquals((Object)"TimeoutException", (Object)KafkaAdminClient.prettyPrintException((Throwable)new TimeoutException()));
        Assert.assertEquals((Object)"TimeoutException: The foobar timed out.", (Object)KafkaAdminClient.prettyPrintException((Throwable)new TimeoutException("The foobar timed out.")));
    }

    private static Map<String, Object> newStrMap(String ... vals) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("bootstrap.servers", "localhost:8121");
        map.put("request.timeout.ms", "1000");
        if (vals.length % 2 != 0) {
            throw new IllegalStateException();
        }
        for (int i = 0; i < vals.length; i += 2) {
            map.put(vals[i], vals[i + 1]);
        }
        return map;
    }

    private static AdminClientConfig newConfMap(String ... vals) {
        return new AdminClientConfig(KafkaAdminClientTest.newStrMap(vals));
    }

    @Test
    public void testGenerateClientId() {
        HashSet<String> ids = new HashSet<String>();
        for (int i = 0; i < 10; ++i) {
            String id = KafkaAdminClient.generateClientId((AdminClientConfig)KafkaAdminClientTest.newConfMap("client.id", ""));
            Assert.assertTrue((String)("Got duplicate id " + id), (!ids.contains(id) ? 1 : 0) != 0);
            ids.add(id);
        }
        Assert.assertEquals((Object)"myCustomId", (Object)KafkaAdminClient.generateClientId((AdminClientConfig)KafkaAdminClientTest.newConfMap("client.id", "myCustomId")));
    }

    private static AdminClientUnitTestEnv mockClientEnv(String ... configVals) {
        HashMap<Integer, Node> nodes = new HashMap<Integer, Node>();
        nodes.put(0, new Node(0, "localhost", 8121));
        nodes.put(1, new Node(1, "localhost", 8122));
        nodes.put(2, new Node(2, "localhost", 8123));
        Cluster cluster = new Cluster("mockClusterId", nodes.values(), Collections.emptySet(), Collections.emptySet(), Collections.emptySet(), (Node)nodes.get(0));
        return new AdminClientUnitTestEnv(cluster, configVals);
    }

    @Test
    public void testCloseAdminClient() throws Exception {
        AdminClientUnitTestEnv env = KafkaAdminClientTest.mockClientEnv(new String[0]);
        Throwable throwable = null;
        if (env != null) {
            if (throwable != null) {
                try {
                    env.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
            } else {
                env.close();
            }
        }
    }

    private static void assertFutureError(Future<?> future, Class<? extends Throwable> exceptionClass) throws InterruptedException {
        try {
            future.get();
            Assert.fail((String)("Expected a " + exceptionClass.getSimpleName() + " exception, but got success."));
        }
        catch (ExecutionException ee) {
            Throwable cause = ee.getCause();
            Assert.assertEquals((String)("Expected a " + exceptionClass.getSimpleName() + " exception, but got " + cause.getClass().getSimpleName()), exceptionClass, cause.getClass());
        }
    }

    @Test
    public void testTimeoutWithoutMetadata() throws Exception {
        try (AdminClientUnitTestEnv env = KafkaAdminClientTest.mockClientEnv("request.timeout.ms", "10");){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            env.kafkaClient().setNode(new Node(0, "localhost", 8121));
            env.kafkaClient().prepareResponse((AbstractResponse)new CreateTopicsResponse(Collections.singletonMap("myTopic", new ApiError(Errors.NONE, ""))));
            KafkaFuture future = env.adminClient().createTopics(Collections.singleton(new NewTopic("myTopic", Collections.singletonMap(0, Arrays.asList(0, 1, 2)))), new CreateTopicsOptions().timeoutMs(Integer.valueOf(1000))).all();
            KafkaAdminClientTest.assertFutureError(future, TimeoutException.class);
        }
    }

    @Test
    public void testCreateTopics() throws Exception {
        try (AdminClientUnitTestEnv env = KafkaAdminClientTest.mockClientEnv(new String[0]);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            env.kafkaClient().prepareMetadataUpdate(env.cluster(), Collections.emptySet());
            env.kafkaClient().setNode(env.cluster().controller());
            env.kafkaClient().prepareResponse((AbstractResponse)new CreateTopicsResponse(Collections.singletonMap("myTopic", new ApiError(Errors.NONE, ""))));
            KafkaFuture future = env.adminClient().createTopics(Collections.singleton(new NewTopic("myTopic", Collections.singletonMap(0, Arrays.asList(0, 1, 2)))), new CreateTopicsOptions().timeoutMs(Integer.valueOf(10000))).all();
            future.get();
        }
    }

    @Test
    public void testInvalidTopicNames() throws Exception {
        try (AdminClientUnitTestEnv env = KafkaAdminClientTest.mockClientEnv(new String[0]);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            env.kafkaClient().prepareMetadataUpdate(env.cluster(), Collections.emptySet());
            env.kafkaClient().setNode(env.cluster().controller());
            List<String> sillyTopicNames = Arrays.asList("", null);
            Map deleteFutures = env.adminClient().deleteTopics(sillyTopicNames).values();
            for (String string : sillyTopicNames) {
                KafkaAdminClientTest.assertFutureError((Future)deleteFutures.get(string), InvalidTopicException.class);
            }
            Map describeFutures = env.adminClient().describeTopics(sillyTopicNames).values();
            for (String string : sillyTopicNames) {
                KafkaAdminClientTest.assertFutureError((Future)describeFutures.get(string), InvalidTopicException.class);
            }
            ArrayList<NewTopic> arrayList = new ArrayList<NewTopic>();
            for (String sillyTopicName : sillyTopicNames) {
                arrayList.add(new NewTopic(sillyTopicName, 1, 1));
            }
            Map map = env.adminClient().createTopics(arrayList).values();
            for (String sillyTopicName : sillyTopicNames) {
                KafkaAdminClientTest.assertFutureError((Future)map.get(sillyTopicName), InvalidTopicException.class);
            }
        }
    }

    @Test
    public void testDescribeAcls() throws Exception {
        try (AdminClientUnitTestEnv env = KafkaAdminClientTest.mockClientEnv(new String[0]);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            env.kafkaClient().prepareMetadataUpdate(env.cluster(), Collections.emptySet());
            env.kafkaClient().setNode(env.cluster().controller());
            env.kafkaClient().prepareResponse((AbstractResponse)new DescribeAclsResponse(0, ApiError.NONE, Arrays.asList(ACL1, ACL2)));
            KafkaAdminClientTest.assertCollectionIs((Collection)env.adminClient().describeAcls(FILTER1).values().get(), ACL1, ACL2);
            env.kafkaClient().prepareResponse((AbstractResponse)new DescribeAclsResponse(0, ApiError.NONE, Collections.emptySet()));
            Assert.assertTrue((boolean)((Collection)env.adminClient().describeAcls(FILTER2).values().get()).isEmpty());
            env.kafkaClient().prepareResponse((AbstractResponse)new DescribeAclsResponse(0, new ApiError(Errors.SECURITY_DISABLED, "Security is disabled"), Collections.emptySet()));
            KafkaAdminClientTest.assertFutureError(env.adminClient().describeAcls(FILTER2).values(), SecurityDisabledException.class);
        }
    }

    @Test
    public void testCreateAcls() throws Exception {
        try (AdminClientUnitTestEnv env = KafkaAdminClientTest.mockClientEnv(new String[0]);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            env.kafkaClient().prepareMetadataUpdate(env.cluster(), Collections.emptySet());
            env.kafkaClient().setNode(env.cluster().controller());
            env.kafkaClient().prepareResponse((AbstractResponse)new CreateAclsResponse(0, Arrays.asList(new CreateAclsResponse.AclCreationResponse(ApiError.NONE), new CreateAclsResponse.AclCreationResponse(ApiError.NONE))));
            CreateAclsResult results = env.adminClient().createAcls(Arrays.asList(ACL1, ACL2));
            KafkaAdminClientTest.assertCollectionIs(results.values().keySet(), ACL1, ACL2);
            for (KafkaFuture future : results.values().values()) {
                future.get();
            }
            results.all().get();
            env.kafkaClient().prepareResponse((AbstractResponse)new CreateAclsResponse(0, Arrays.asList(new CreateAclsResponse.AclCreationResponse(new ApiError(Errors.SECURITY_DISABLED, "Security is disabled")), new CreateAclsResponse.AclCreationResponse(ApiError.NONE))));
            results = env.adminClient().createAcls(Arrays.asList(ACL1, ACL2));
            KafkaAdminClientTest.assertCollectionIs(results.values().keySet(), ACL1, ACL2);
            KafkaAdminClientTest.assertFutureError((Future)results.values().get(ACL1), SecurityDisabledException.class);
            ((KafkaFuture)results.values().get(ACL2)).get();
            KafkaAdminClientTest.assertFutureError(results.all(), SecurityDisabledException.class);
        }
    }

    @Test
    public void testDeleteAcls() throws Exception {
        try (AdminClientUnitTestEnv env = KafkaAdminClientTest.mockClientEnv(new String[0]);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            env.kafkaClient().prepareMetadataUpdate(env.cluster(), Collections.emptySet());
            env.kafkaClient().setNode(env.cluster().controller());
            env.kafkaClient().prepareResponse((AbstractResponse)new DeleteAclsResponse(0, Arrays.asList(new DeleteAclsResponse.AclFilterResponse(Arrays.asList(new DeleteAclsResponse.AclDeletionResult(ACL1), new DeleteAclsResponse.AclDeletionResult(ACL2))), new DeleteAclsResponse.AclFilterResponse(new ApiError(Errors.SECURITY_DISABLED, "No security"), Collections.emptySet()))));
            DeleteAclsResult results = env.adminClient().deleteAcls(Arrays.asList(FILTER1, FILTER2));
            Map filterResults = results.values();
            DeleteAclsResult.FilterResults filter1Results = (DeleteAclsResult.FilterResults)((KafkaFuture)filterResults.get(FILTER1)).get();
            Assert.assertEquals(null, (Object)((DeleteAclsResult.FilterResult)filter1Results.values().get(0)).exception());
            Assert.assertEquals((Object)ACL1, (Object)((DeleteAclsResult.FilterResult)filter1Results.values().get(0)).binding());
            Assert.assertEquals(null, (Object)((DeleteAclsResult.FilterResult)filter1Results.values().get(1)).exception());
            Assert.assertEquals((Object)ACL2, (Object)((DeleteAclsResult.FilterResult)filter1Results.values().get(1)).binding());
            KafkaAdminClientTest.assertFutureError((Future)filterResults.get(FILTER2), SecurityDisabledException.class);
            KafkaAdminClientTest.assertFutureError(results.all(), SecurityDisabledException.class);
            env.kafkaClient().prepareResponse((AbstractResponse)new DeleteAclsResponse(0, Arrays.asList(new DeleteAclsResponse.AclFilterResponse(Arrays.asList(new DeleteAclsResponse.AclDeletionResult(ACL1), new DeleteAclsResponse.AclDeletionResult(new ApiError(Errors.SECURITY_DISABLED, "No security"), ACL2))), new DeleteAclsResponse.AclFilterResponse(Collections.emptySet()))));
            results = env.adminClient().deleteAcls(Arrays.asList(FILTER1, FILTER2));
            Assert.assertTrue((boolean)((DeleteAclsResult.FilterResults)((KafkaFuture)results.values().get(FILTER2)).get()).values().isEmpty());
            KafkaAdminClientTest.assertFutureError(results.all(), SecurityDisabledException.class);
            env.kafkaClient().prepareResponse((AbstractResponse)new DeleteAclsResponse(0, Arrays.asList(new DeleteAclsResponse.AclFilterResponse(Arrays.asList(new DeleteAclsResponse.AclDeletionResult(ACL1))), new DeleteAclsResponse.AclFilterResponse(Arrays.asList(new DeleteAclsResponse.AclDeletionResult(ACL2))))));
            results = env.adminClient().deleteAcls(Arrays.asList(FILTER1, FILTER2));
            Collection deleted = (Collection)results.all().get();
            KafkaAdminClientTest.assertCollectionIs(deleted, ACL1, ACL2);
        }
    }

    @Ignore
    @Test
    public void testHandleTimeout() throws Exception {
        HashMap<Integer, Node> nodes = new HashMap<Integer, Node>();
        MockTime time = new MockTime();
        nodes.put(0, new Node(0, "localhost", 8121));
        Cluster cluster = new Cluster("mockClusterId", nodes.values(), Collections.emptySet(), Collections.emptySet(), Collections.emptySet(), (Node)nodes.get(0));
        try (final AdminClientUnitTestEnv env = new AdminClientUnitTestEnv((Time)time, cluster, "reconnect.backoff.max.ms", "1", "reconnect.backoff.ms", "1");){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            env.kafkaClient().prepareMetadataUpdate(env.cluster(), Collections.emptySet());
            env.kafkaClient().setNode((Node)nodes.get(0));
            Assert.assertEquals((Object)time, (Object)env.time());
            Assert.assertEquals((Object)env.time(), (Object)((KafkaAdminClient)env.adminClient()).time());
            log.info("Starting AdminClient#listTopics...");
            final ListTopicsResult result = env.adminClient().listTopics(new ListTopicsOptions().timeoutMs(Integer.valueOf(1000)));
            TestUtils.waitForCondition(new TestCondition(){

                @Override
                public boolean conditionMet() {
                    return env.kafkaClient().hasInFlightRequests();
                }
            }, "Timed out waiting for inFlightRequests");
            time.sleep(5000L);
            TestUtils.waitForCondition(new TestCondition(){

                @Override
                public boolean conditionMet() {
                    return result.listings().isDone();
                }
            }, "Timed out waiting for listTopics to complete");
            KafkaAdminClientTest.assertFutureError(result.listings(), TimeoutException.class);
            log.info("Verified the error result of AdminClient#listTopics");
            time.sleep(5000L);
            env.kafkaClient().prepareResponse((AbstractResponse)new DescribeConfigsResponse(0, Collections.singletonMap(new Resource(ResourceType.TOPIC, "foo"), new DescribeConfigsResponse.Config(ApiError.NONE, Collections.emptySet()))));
            DescribeConfigsResult result2 = env.adminClient().describeConfigs(Collections.singleton(new ConfigResource(ConfigResource.Type.TOPIC, "foo")));
            time.sleep(5000L);
            ((KafkaFuture)result2.values().get(new ConfigResource(ConfigResource.Type.TOPIC, "foo"))).get();
        }
    }

    @Test
    public void testDescribeConfigs() throws Exception {
        try (AdminClientUnitTestEnv env = KafkaAdminClientTest.mockClientEnv(new String[0]);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            env.kafkaClient().prepareMetadataUpdate(env.cluster(), Collections.emptySet());
            env.kafkaClient().setNode(env.cluster().controller());
            env.kafkaClient().prepareResponse((AbstractResponse)new DescribeConfigsResponse(0, Collections.singletonMap(new Resource(ResourceType.BROKER, "0"), new DescribeConfigsResponse.Config(ApiError.NONE, Collections.emptySet()))));
            DescribeConfigsResult result2 = env.adminClient().describeConfigs(Collections.singleton(new ConfigResource(ConfigResource.Type.BROKER, "0")));
            result2.all().get();
        }
    }

    @Test
    public void testCreatePartitions() throws Exception {
        try (AdminClientUnitTestEnv env = KafkaAdminClientTest.mockClientEnv(new String[0]);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            env.kafkaClient().prepareMetadataUpdate(env.cluster(), Collections.emptySet());
            env.kafkaClient().setNode(env.cluster().controller());
            HashMap<String, ApiError> m = new HashMap<String, ApiError>();
            m.put("my_topic", ApiError.NONE);
            m.put("other_topic", ApiError.fromThrowable((Throwable)new InvalidTopicException("some detailed reason")));
            env.kafkaClient().prepareResponse((AbstractResponse)new CreatePartitionsResponse(0, m));
            HashMap<String, NewPartitions> counts = new HashMap<String, NewPartitions>();
            counts.put("my_topic", NewPartitions.increaseTo((int)3));
            counts.put("other_topic", NewPartitions.increaseTo((int)3, Arrays.asList(Arrays.asList(2), Arrays.asList(3))));
            CreatePartitionsResult results = env.adminClient().createPartitions(counts);
            Map values = results.values();
            KafkaFuture myTopicResult = (KafkaFuture)values.get("my_topic");
            myTopicResult.get();
            KafkaFuture otherTopicResult = (KafkaFuture)values.get("other_topic");
            try {
                otherTopicResult.get();
                Assert.fail((String)"get() should throw ExecutionException");
            }
            catch (ExecutionException e0) {
                Assert.assertTrue((boolean)(e0.getCause() instanceof InvalidTopicException));
                InvalidTopicException e = (InvalidTopicException)e0.getCause();
                Assert.assertEquals((Object)"some detailed reason", (Object)e.getMessage());
            }
        }
    }

    @Test
    public void testDeleteRecords() throws Exception {
        HashMap<Integer, Node> nodes = new HashMap<Integer, Node>();
        nodes.put(0, new Node(0, "localhost", 8121));
        ArrayList<PartitionInfo> partitionInfos = new ArrayList<PartitionInfo>();
        partitionInfos.add(new PartitionInfo("my_topic", 0, (Node)nodes.get(0), new Node[]{(Node)nodes.get(0)}, new Node[]{(Node)nodes.get(0)}));
        partitionInfos.add(new PartitionInfo("my_topic", 1, (Node)nodes.get(0), new Node[]{(Node)nodes.get(0)}, new Node[]{(Node)nodes.get(0)}));
        partitionInfos.add(new PartitionInfo("my_topic", 2, null, new Node[]{(Node)nodes.get(0)}, new Node[]{(Node)nodes.get(0)}));
        partitionInfos.add(new PartitionInfo("my_topic", 3, (Node)nodes.get(0), new Node[]{(Node)nodes.get(0)}, new Node[]{(Node)nodes.get(0)}));
        partitionInfos.add(new PartitionInfo("my_topic", 4, (Node)nodes.get(0), new Node[]{(Node)nodes.get(0)}, new Node[]{(Node)nodes.get(0)}));
        Cluster cluster = new Cluster("mockClusterId", nodes.values(), partitionInfos, Collections.emptySet(), Collections.emptySet(), (Node)nodes.get(0));
        TopicPartition myTopicPartition0 = new TopicPartition("my_topic", 0);
        TopicPartition myTopicPartition1 = new TopicPartition("my_topic", 1);
        TopicPartition myTopicPartition2 = new TopicPartition("my_topic", 2);
        TopicPartition myTopicPartition3 = new TopicPartition("my_topic", 3);
        TopicPartition myTopicPartition4 = new TopicPartition("my_topic", 4);
        try (AdminClientUnitTestEnv env = new AdminClientUnitTestEnv(cluster, new String[0]);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            env.kafkaClient().prepareMetadataUpdate(env.cluster(), Collections.emptySet());
            env.kafkaClient().setNode((Node)env.cluster().nodes().get(0));
            HashMap<TopicPartition, DeleteRecordsResponse.PartitionResponse> m = new HashMap<TopicPartition, DeleteRecordsResponse.PartitionResponse>();
            m.put(myTopicPartition0, new DeleteRecordsResponse.PartitionResponse(3L, Errors.NONE));
            m.put(myTopicPartition1, new DeleteRecordsResponse.PartitionResponse(-1L, Errors.OFFSET_OUT_OF_RANGE));
            m.put(myTopicPartition3, new DeleteRecordsResponse.PartitionResponse(-1L, Errors.NOT_LEADER_FOR_PARTITION));
            m.put(myTopicPartition4, new DeleteRecordsResponse.PartitionResponse(-1L, Errors.UNKNOWN_TOPIC_OR_PARTITION));
            ArrayList<MetadataResponse.TopicMetadata> t = new ArrayList<MetadataResponse.TopicMetadata>();
            ArrayList<MetadataResponse.PartitionMetadata> p = new ArrayList<MetadataResponse.PartitionMetadata>();
            p.add(new MetadataResponse.PartitionMetadata(Errors.NONE, 0, (Node)nodes.get(0), Collections.singletonList(nodes.get(0)), Collections.singletonList(nodes.get(0)), Collections.emptyList()));
            p.add(new MetadataResponse.PartitionMetadata(Errors.NONE, 1, (Node)nodes.get(0), Collections.singletonList(nodes.get(0)), Collections.singletonList(nodes.get(0)), Collections.emptyList()));
            p.add(new MetadataResponse.PartitionMetadata(Errors.LEADER_NOT_AVAILABLE, 2, null, Collections.singletonList(nodes.get(0)), Collections.singletonList(nodes.get(0)), Collections.emptyList()));
            p.add(new MetadataResponse.PartitionMetadata(Errors.NONE, 3, (Node)nodes.get(0), Collections.singletonList(nodes.get(0)), Collections.singletonList(nodes.get(0)), Collections.emptyList()));
            p.add(new MetadataResponse.PartitionMetadata(Errors.NONE, 4, (Node)nodes.get(0), Collections.singletonList(nodes.get(0)), Collections.singletonList(nodes.get(0)), Collections.emptyList()));
            t.add(new MetadataResponse.TopicMetadata(Errors.NONE, "my_topic", false, p));
            env.kafkaClient().prepareResponse((AbstractResponse)new MetadataResponse(cluster.nodes(), cluster.clusterResource().clusterId(), cluster.controller().id(), t));
            env.kafkaClient().prepareResponse((AbstractResponse)new DeleteRecordsResponse(0, m));
            HashMap<TopicPartition, RecordsToDelete> recordsToDelete = new HashMap<TopicPartition, RecordsToDelete>();
            recordsToDelete.put(myTopicPartition0, RecordsToDelete.beforeOffset((long)3L));
            recordsToDelete.put(myTopicPartition1, RecordsToDelete.beforeOffset((long)10L));
            recordsToDelete.put(myTopicPartition2, RecordsToDelete.beforeOffset((long)10L));
            recordsToDelete.put(myTopicPartition3, RecordsToDelete.beforeOffset((long)10L));
            recordsToDelete.put(myTopicPartition4, RecordsToDelete.beforeOffset((long)10L));
            DeleteRecordsResult results = env.adminClient().deleteRecords(recordsToDelete);
            Map values = results.lowWatermarks();
            KafkaFuture myTopicPartition0Result = (KafkaFuture)values.get(myTopicPartition0);
            long lowWatermark = ((DeletedRecords)myTopicPartition0Result.get()).lowWatermark();
            Assert.assertEquals((long)lowWatermark, (long)3L);
            KafkaFuture myTopicPartition1Result = (KafkaFuture)values.get(myTopicPartition1);
            try {
                myTopicPartition1Result.get();
                Assert.fail((String)"get() should throw ExecutionException");
            }
            catch (ExecutionException e0) {
                Assert.assertTrue((boolean)(e0.getCause() instanceof OffsetOutOfRangeException));
            }
            KafkaFuture myTopicPartition2Result = (KafkaFuture)values.get(myTopicPartition2);
            try {
                myTopicPartition2Result.get();
                Assert.fail((String)"get() should throw ExecutionException");
            }
            catch (ExecutionException e1) {
                Assert.assertTrue((boolean)(e1.getCause() instanceof LeaderNotAvailableException));
            }
            KafkaFuture myTopicPartition3Result = (KafkaFuture)values.get(myTopicPartition3);
            try {
                myTopicPartition3Result.get();
                Assert.fail((String)"get() should throw ExecutionException");
            }
            catch (ExecutionException e1) {
                Assert.assertTrue((boolean)(e1.getCause() instanceof NotLeaderForPartitionException));
            }
            KafkaFuture myTopicPartition4Result = (KafkaFuture)values.get(myTopicPartition4);
            try {
                myTopicPartition4Result.get();
                Assert.fail((String)"get() should throw ExecutionException");
            }
            catch (ExecutionException e1) {
                Assert.assertTrue((boolean)(e1.getCause() instanceof UnknownTopicOrPartitionException));
            }
        }
    }

    private static <T> void assertCollectionIs(Collection<T> collection, T ... elements) {
        for (T element : elements) {
            Assert.assertTrue((String)("Did not find " + element), (boolean)collection.contains(element));
        }
        Assert.assertEquals((String)"There are unexpected extra elements in the collection.", (long)elements.length, (long)collection.size());
    }

    public static KafkaAdminClient createInternal(AdminClientConfig config, KafkaAdminClient.TimeoutProcessorFactory timeoutProcessorFactory) {
        return KafkaAdminClient.createInternal((AdminClientConfig)config, (KafkaAdminClient.TimeoutProcessorFactory)timeoutProcessorFactory);
    }

    public static class FailureInjectingTimeoutProcessorFactory
    extends KafkaAdminClient.TimeoutProcessorFactory {
        private int numTries = 0;
        private int failuresInjected = 0;

        public KafkaAdminClient.TimeoutProcessor create(long now) {
            return new FailureInjectingTimeoutProcessor(now);
        }

        synchronized boolean shouldInjectFailure() {
            ++this.numTries;
            if (this.numTries == 1) {
                ++this.failuresInjected;
                return true;
            }
            return false;
        }

        public synchronized int failuresInjected() {
            return this.failuresInjected;
        }

        public final class FailureInjectingTimeoutProcessor
        extends KafkaAdminClient.TimeoutProcessor {
            public FailureInjectingTimeoutProcessor(long now) {
                super(now);
            }

            boolean callHasExpired(KafkaAdminClient.Call call) {
                if (FailureInjectingTimeoutProcessorFactory.this.shouldInjectFailure()) {
                    log.debug("Injecting timeout for {}.", (Object)call);
                    return true;
                }
                boolean ret = super.callHasExpired(call);
                log.debug("callHasExpired({}) = {}", (Object)call, (Object)ret);
                return ret;
            }
        }
    }
}

