/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.producer;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.kafka.clients.producer.internals.FutureRecordMetadata;
import org.apache.kafka.clients.producer.internals.ProduceRequestResult;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.CorruptRecordException;
import org.junit.Assert;
import org.junit.Test;

public class RecordSendTest {
    private final TopicPartition topicPartition = new TopicPartition("test", 0);
    private final long baseOffset = 45L;
    private final long relOffset = 5L;

    @Test
    public void testTimeout() throws Exception {
        ProduceRequestResult request = new ProduceRequestResult(this.topicPartition);
        FutureRecordMetadata future = new FutureRecordMetadata(request, 5L, -1L, Long.valueOf(0L), 0, 0);
        Assert.assertFalse((String)"Request is not completed", (boolean)future.isDone());
        try {
            future.get(5L, TimeUnit.MILLISECONDS);
            Assert.fail((String)"Should have thrown exception.");
        }
        catch (TimeoutException timeoutException) {
            // empty catch block
        }
        request.set(45L, -1L, null);
        request.done();
        Assert.assertTrue((boolean)future.isDone());
        Assert.assertEquals((long)50L, (long)future.get().offset());
    }

    @Test(expected=ExecutionException.class)
    public void testError() throws Exception {
        FutureRecordMetadata future = new FutureRecordMetadata(this.asyncRequest(45L, (RuntimeException)new CorruptRecordException(), 50L), 5L, -1L, Long.valueOf(0L), 0, 0);
        future.get();
    }

    @Test
    public void testBlocking() throws Exception {
        FutureRecordMetadata future = new FutureRecordMetadata(this.asyncRequest(45L, null, 50L), 5L, -1L, Long.valueOf(0L), 0, 0);
        Assert.assertEquals((long)50L, (long)future.get().offset());
    }

    public ProduceRequestResult asyncRequest(final long baseOffset, final RuntimeException error, final long timeout) {
        final ProduceRequestResult request = new ProduceRequestResult(this.topicPartition);
        Thread thread = new Thread(){

            @Override
            public void run() {
                try {
                    1.sleep(timeout);
                    request.set(baseOffset, -1L, error);
                    request.done();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        };
        thread.start();
        return request;
    }
}

