/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.metrics;

import java.util.ArrayList;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.apache.kafka.common.metrics.MeasurableStat;
import org.apache.kafka.common.metrics.MetricConfig;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.Quota;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.metrics.stats.Rate;
import org.apache.kafka.common.utils.SystemTime;
import org.apache.kafka.common.utils.Time;
import org.junit.Assert;
import org.junit.Test;

public class SensorTest {
    @Test
    public void testRecordLevelEnum() {
        Sensor.RecordingLevel configLevel = Sensor.RecordingLevel.INFO;
        Assert.assertTrue((boolean)Sensor.RecordingLevel.INFO.shouldRecord((int)configLevel.id));
        Assert.assertFalse((boolean)Sensor.RecordingLevel.DEBUG.shouldRecord((int)configLevel.id));
        configLevel = Sensor.RecordingLevel.DEBUG;
        Assert.assertTrue((boolean)Sensor.RecordingLevel.INFO.shouldRecord((int)configLevel.id));
        Assert.assertTrue((boolean)Sensor.RecordingLevel.DEBUG.shouldRecord((int)configLevel.id));
        Assert.assertEquals((Object)Sensor.RecordingLevel.valueOf((String)Sensor.RecordingLevel.DEBUG.toString()), (Object)Sensor.RecordingLevel.DEBUG);
        Assert.assertEquals((Object)Sensor.RecordingLevel.valueOf((String)Sensor.RecordingLevel.INFO.toString()), (Object)Sensor.RecordingLevel.INFO);
    }

    @Test
    public void testShouldRecord() {
        MetricConfig debugConfig = new MetricConfig().recordLevel(Sensor.RecordingLevel.DEBUG);
        MetricConfig infoConfig = new MetricConfig().recordLevel(Sensor.RecordingLevel.INFO);
        Sensor infoSensor = new Sensor(null, "infoSensor", null, debugConfig, (Time)new SystemTime(), 0L, Sensor.RecordingLevel.INFO);
        Assert.assertTrue((boolean)infoSensor.shouldRecord());
        infoSensor = new Sensor(null, "infoSensor", null, debugConfig, (Time)new SystemTime(), 0L, Sensor.RecordingLevel.DEBUG);
        Assert.assertTrue((boolean)infoSensor.shouldRecord());
        Sensor debugSensor = new Sensor(null, "debugSensor", null, infoConfig, (Time)new SystemTime(), 0L, Sensor.RecordingLevel.INFO);
        Assert.assertTrue((boolean)debugSensor.shouldRecord());
        debugSensor = new Sensor(null, "debugSensor", null, infoConfig, (Time)new SystemTime(), 0L, Sensor.RecordingLevel.DEBUG);
        Assert.assertFalse((boolean)debugSensor.shouldRecord());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCheckQuotasInMultiThreads() throws InterruptedException, ExecutionException {
        Metrics metrics = new Metrics(new MetricConfig().quota(Quota.upperBound((double)Double.MAX_VALUE)).timeWindow(1L, TimeUnit.MILLISECONDS).samples(100));
        final Sensor sensor = metrics.sensor("sensor");
        sensor.add(metrics.metricName("test-metric", "test-group"), (MeasurableStat)new Rate());
        int threadCount = 10;
        final CountDownLatch latch = new CountDownLatch(1);
        ExecutorService service = Executors.newFixedThreadPool(10);
        ArrayList<Future<Throwable>> workers = new ArrayList<Future<Throwable>>(10);
        boolean needShutdown = true;
        try {
            int i = 0;
            while (i != 10) {
                final int n = i++;
                workers.add(service.submit(new Callable<Throwable>(){

                    @Override
                    public Throwable call() {
                        try {
                            Assert.assertTrue((boolean)latch.await(5L, TimeUnit.SECONDS));
                            for (int j = 0; j != 20; ++j) {
                                sensor.record((double)(j * n), System.currentTimeMillis() + (long)j, false);
                                sensor.checkQuotas();
                            }
                            return null;
                        }
                        catch (Throwable e) {
                            return e;
                        }
                    }
                }));
            }
            latch.countDown();
            service.shutdown();
            Assert.assertTrue((boolean)service.awaitTermination(10L, TimeUnit.SECONDS));
            needShutdown = false;
            for (Future future : workers) {
                Assert.assertTrue((String)"If this failure happen frequently, we can try to increase the wait time", (boolean)future.isDone());
                Assert.assertNull((String)"Sensor#checkQuotas SHOULD be thread-safe!", future.get());
            }
        }
        finally {
            if (needShutdown) {
                service.shutdownNow();
            }
        }
    }
}

