/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.network;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.GatheringByteChannel;
import java.util.LinkedList;
import org.apache.kafka.common.network.ByteBufferSend;
import org.apache.kafka.common.network.MultiSend;
import org.apache.kafka.common.requests.ByteBufferChannel;
import org.apache.kafka.test.TestUtils;
import org.junit.Assert;
import org.junit.Test;

public class MultiSendTest {
    @Test
    public void testSendsFreedAfterWriting() throws IOException {
        String dest = "1";
        int numChunks = 4;
        int chunkSize = 32;
        int totalSize = numChunks * chunkSize;
        LinkedList<ByteBufferSend> sends = new LinkedList<ByteBufferSend>();
        ByteBuffer[] chunks = new ByteBuffer[numChunks];
        for (int i = 0; i < numChunks; ++i) {
            ByteBuffer buffer;
            chunks[i] = buffer = ByteBuffer.wrap(TestUtils.randomBytes(chunkSize));
            sends.add(new ByteBufferSend(dest, new ByteBuffer[]{buffer}));
        }
        MultiSend send = new MultiSend(dest, sends);
        Assert.assertEquals((long)totalSize, (long)send.size());
        for (int i = 0; i < numChunks; ++i) {
            Assert.assertEquals((long)(numChunks - i), (long)send.numResidentSends());
            NonOverflowingByteBufferChannel out = new NonOverflowingByteBufferChannel(chunkSize);
            send.writeTo((GatheringByteChannel)out);
            out.close();
            Assert.assertEquals((Object)chunks[i], (Object)out.buffer());
        }
        Assert.assertEquals((long)0L, (long)send.numResidentSends());
        Assert.assertTrue((boolean)send.completed());
    }

    private static class NonOverflowingByteBufferChannel
    extends ByteBufferChannel {
        private NonOverflowingByteBufferChannel(long size) {
            super(size);
        }

        @Override
        public long write(ByteBuffer[] srcs) throws IOException {
            if (!this.buffer().hasRemaining()) {
                return 0L;
            }
            return super.write(srcs);
        }
    }
}

