/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.nio.channels.GatheringByteChannel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.kafka.clients.admin.NewPartitions;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.acl.AccessControlEntry;
import org.apache.kafka.common.acl.AccessControlEntryFilter;
import org.apache.kafka.common.acl.AclBinding;
import org.apache.kafka.common.acl.AclBindingFilter;
import org.apache.kafka.common.acl.AclOperation;
import org.apache.kafka.common.acl.AclPermissionType;
import org.apache.kafka.common.errors.InvalidReplicaAssignmentException;
import org.apache.kafka.common.errors.InvalidTopicException;
import org.apache.kafka.common.errors.NotCoordinatorException;
import org.apache.kafka.common.errors.NotEnoughReplicasException;
import org.apache.kafka.common.errors.SecurityDisabledException;
import org.apache.kafka.common.errors.UnknownServerException;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.network.Send;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.protocol.types.Struct;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.Records;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.AbstractRequestResponse;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.AddOffsetsToTxnRequest;
import org.apache.kafka.common.requests.AddOffsetsToTxnResponse;
import org.apache.kafka.common.requests.AddPartitionsToTxnRequest;
import org.apache.kafka.common.requests.AddPartitionsToTxnResponse;
import org.apache.kafka.common.requests.AlterConfigsRequest;
import org.apache.kafka.common.requests.AlterConfigsResponse;
import org.apache.kafka.common.requests.ApiError;
import org.apache.kafka.common.requests.ApiVersionsRequest;
import org.apache.kafka.common.requests.ApiVersionsResponse;
import org.apache.kafka.common.requests.ByteBufferChannel;
import org.apache.kafka.common.requests.ControlledShutdownRequest;
import org.apache.kafka.common.requests.ControlledShutdownResponse;
import org.apache.kafka.common.requests.CreateAclsRequest;
import org.apache.kafka.common.requests.CreateAclsResponse;
import org.apache.kafka.common.requests.CreateDelegationTokenRequest;
import org.apache.kafka.common.requests.CreateDelegationTokenResponse;
import org.apache.kafka.common.requests.CreatePartitionsRequest;
import org.apache.kafka.common.requests.CreatePartitionsResponse;
import org.apache.kafka.common.requests.CreateTopicsRequest;
import org.apache.kafka.common.requests.CreateTopicsResponse;
import org.apache.kafka.common.requests.DeleteAclsRequest;
import org.apache.kafka.common.requests.DeleteAclsResponse;
import org.apache.kafka.common.requests.DeleteGroupsRequest;
import org.apache.kafka.common.requests.DeleteGroupsResponse;
import org.apache.kafka.common.requests.DeleteTopicsRequest;
import org.apache.kafka.common.requests.DeleteTopicsResponse;
import org.apache.kafka.common.requests.DescribeAclsRequest;
import org.apache.kafka.common.requests.DescribeAclsResponse;
import org.apache.kafka.common.requests.DescribeConfigsRequest;
import org.apache.kafka.common.requests.DescribeConfigsResponse;
import org.apache.kafka.common.requests.DescribeDelegationTokenRequest;
import org.apache.kafka.common.requests.DescribeDelegationTokenResponse;
import org.apache.kafka.common.requests.DescribeGroupsRequest;
import org.apache.kafka.common.requests.DescribeGroupsResponse;
import org.apache.kafka.common.requests.EndTxnRequest;
import org.apache.kafka.common.requests.EndTxnResponse;
import org.apache.kafka.common.requests.EpochEndOffset;
import org.apache.kafka.common.requests.ExpireDelegationTokenRequest;
import org.apache.kafka.common.requests.ExpireDelegationTokenResponse;
import org.apache.kafka.common.requests.FetchMetadata;
import org.apache.kafka.common.requests.FetchRequest;
import org.apache.kafka.common.requests.FetchResponse;
import org.apache.kafka.common.requests.FindCoordinatorRequest;
import org.apache.kafka.common.requests.FindCoordinatorResponse;
import org.apache.kafka.common.requests.HeartbeatRequest;
import org.apache.kafka.common.requests.HeartbeatResponse;
import org.apache.kafka.common.requests.InitProducerIdRequest;
import org.apache.kafka.common.requests.InitProducerIdResponse;
import org.apache.kafka.common.requests.IsolationLevel;
import org.apache.kafka.common.requests.JoinGroupRequest;
import org.apache.kafka.common.requests.JoinGroupResponse;
import org.apache.kafka.common.requests.LeaderAndIsrRequest;
import org.apache.kafka.common.requests.LeaderAndIsrResponse;
import org.apache.kafka.common.requests.LeaveGroupRequest;
import org.apache.kafka.common.requests.LeaveGroupResponse;
import org.apache.kafka.common.requests.ListGroupsRequest;
import org.apache.kafka.common.requests.ListGroupsResponse;
import org.apache.kafka.common.requests.ListOffsetRequest;
import org.apache.kafka.common.requests.ListOffsetResponse;
import org.apache.kafka.common.requests.MetadataRequest;
import org.apache.kafka.common.requests.MetadataResponse;
import org.apache.kafka.common.requests.OffsetCommitRequest;
import org.apache.kafka.common.requests.OffsetCommitResponse;
import org.apache.kafka.common.requests.OffsetFetchRequest;
import org.apache.kafka.common.requests.OffsetFetchResponse;
import org.apache.kafka.common.requests.OffsetsForLeaderEpochRequest;
import org.apache.kafka.common.requests.OffsetsForLeaderEpochResponse;
import org.apache.kafka.common.requests.ProduceRequest;
import org.apache.kafka.common.requests.ProduceResponse;
import org.apache.kafka.common.requests.RenewDelegationTokenRequest;
import org.apache.kafka.common.requests.RenewDelegationTokenResponse;
import org.apache.kafka.common.requests.Resource;
import org.apache.kafka.common.requests.ResourceType;
import org.apache.kafka.common.requests.ResponseHeader;
import org.apache.kafka.common.requests.SaslHandshakeRequest;
import org.apache.kafka.common.requests.SaslHandshakeResponse;
import org.apache.kafka.common.requests.StopReplicaRequest;
import org.apache.kafka.common.requests.StopReplicaResponse;
import org.apache.kafka.common.requests.TransactionResult;
import org.apache.kafka.common.requests.TxnOffsetCommitRequest;
import org.apache.kafka.common.requests.TxnOffsetCommitResponse;
import org.apache.kafka.common.requests.UpdateMetadataRequest;
import org.apache.kafka.common.requests.UpdateMetadataResponse;
import org.apache.kafka.common.requests.WriteTxnMarkersRequest;
import org.apache.kafka.common.requests.WriteTxnMarkersResponse;
import org.apache.kafka.common.resource.ResourceFilter;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.security.token.delegation.DelegationToken;
import org.apache.kafka.common.security.token.delegation.TokenInformation;
import org.apache.kafka.common.utils.SecurityUtils;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.test.TestUtils;
import org.junit.Assert;
import org.junit.Test;

public class RequestResponseTest {
    @Test
    public void testSerialization() throws Exception {
        this.checkRequest((AbstractRequest)this.createFindCoordinatorRequest(0));
        this.checkRequest((AbstractRequest)this.createFindCoordinatorRequest(1));
        this.checkErrorResponse((AbstractRequest)this.createFindCoordinatorRequest(0), (Throwable)new UnknownServerException());
        this.checkErrorResponse((AbstractRequest)this.createFindCoordinatorRequest(1), (Throwable)new UnknownServerException());
        this.checkResponse((AbstractResponse)this.createFindCoordinatorResponse(), 0);
        this.checkResponse((AbstractResponse)this.createFindCoordinatorResponse(), 1);
        this.checkRequest((AbstractRequest)this.createControlledShutdownRequest());
        this.checkResponse((AbstractResponse)this.createControlledShutdownResponse(), 1);
        this.checkErrorResponse((AbstractRequest)this.createControlledShutdownRequest(), (Throwable)new UnknownServerException());
        this.checkErrorResponse((AbstractRequest)this.createControlledShutdownRequest(0), (Throwable)new UnknownServerException());
        this.checkRequest((AbstractRequest)this.createFetchRequest(4));
        this.checkResponse((AbstractResponse)this.createFetchResponse(), 4);
        ArrayList<TopicPartition> toForgetTopics = new ArrayList<TopicPartition>();
        toForgetTopics.add(new TopicPartition("foo", 0));
        toForgetTopics.add(new TopicPartition("foo", 2));
        toForgetTopics.add(new TopicPartition("bar", 0));
        this.checkRequest((AbstractRequest)this.createFetchRequest(7, new FetchMetadata(123, 456), toForgetTopics));
        this.checkResponse((AbstractResponse)this.createFetchResponse(123), 7);
        this.checkResponse((AbstractResponse)this.createFetchResponse(Errors.FETCH_SESSION_ID_NOT_FOUND, 123), 7);
        this.checkErrorResponse((AbstractRequest)this.createFetchRequest(4), (Throwable)new UnknownServerException());
        this.checkRequest((AbstractRequest)this.createHeartBeatRequest());
        this.checkErrorResponse((AbstractRequest)this.createHeartBeatRequest(), (Throwable)new UnknownServerException());
        this.checkResponse((AbstractResponse)this.createHeartBeatResponse(), 0);
        this.checkRequest((AbstractRequest)this.createJoinGroupRequest(1));
        this.checkErrorResponse((AbstractRequest)this.createJoinGroupRequest(0), (Throwable)new UnknownServerException());
        this.checkErrorResponse((AbstractRequest)this.createJoinGroupRequest(1), (Throwable)new UnknownServerException());
        this.checkResponse((AbstractResponse)this.createJoinGroupResponse(), 0);
        this.checkRequest((AbstractRequest)this.createLeaveGroupRequest());
        this.checkErrorResponse((AbstractRequest)this.createLeaveGroupRequest(), (Throwable)new UnknownServerException());
        this.checkResponse((AbstractResponse)this.createLeaveGroupResponse(), 0);
        this.checkRequest((AbstractRequest)this.createListGroupsRequest());
        this.checkErrorResponse((AbstractRequest)this.createListGroupsRequest(), (Throwable)new UnknownServerException());
        this.checkResponse((AbstractResponse)this.createListGroupsResponse(), 0);
        this.checkRequest((AbstractRequest)this.createDescribeGroupRequest());
        this.checkErrorResponse((AbstractRequest)this.createDescribeGroupRequest(), (Throwable)new UnknownServerException());
        this.checkResponse((AbstractResponse)this.createDescribeGroupResponse(), 0);
        this.checkRequest((AbstractRequest)this.createDeleteGroupsRequest());
        this.checkErrorResponse((AbstractRequest)this.createDeleteGroupsRequest(), (Throwable)new UnknownServerException());
        this.checkResponse((AbstractResponse)this.createDeleteGroupsResponse(), 0);
        this.checkRequest((AbstractRequest)this.createListOffsetRequest(1));
        this.checkErrorResponse((AbstractRequest)this.createListOffsetRequest(1), (Throwable)new UnknownServerException());
        this.checkResponse((AbstractResponse)this.createListOffsetResponse(1), 1);
        this.checkRequest((AbstractRequest)this.createListOffsetRequest(2));
        this.checkErrorResponse((AbstractRequest)this.createListOffsetRequest(2), (Throwable)new UnknownServerException());
        this.checkResponse((AbstractResponse)this.createListOffsetResponse(2), 2);
        this.checkRequest((AbstractRequest)MetadataRequest.Builder.allTopics().build((short)2));
        this.checkRequest((AbstractRequest)this.createMetadataRequest(1, Collections.singletonList("topic1")));
        this.checkErrorResponse((AbstractRequest)this.createMetadataRequest(1, Collections.singletonList("topic1")), (Throwable)new UnknownServerException());
        this.checkResponse((AbstractResponse)this.createMetadataResponse(), 2);
        this.checkErrorResponse((AbstractRequest)this.createMetadataRequest(2, Collections.singletonList("topic1")), (Throwable)new UnknownServerException());
        this.checkResponse((AbstractResponse)this.createMetadataResponse(), 3);
        this.checkErrorResponse((AbstractRequest)this.createMetadataRequest(3, Collections.singletonList("topic1")), (Throwable)new UnknownServerException());
        this.checkResponse((AbstractResponse)this.createMetadataResponse(), 4);
        this.checkErrorResponse((AbstractRequest)this.createMetadataRequest(4, Collections.singletonList("topic1")), (Throwable)new UnknownServerException());
        this.checkRequest((AbstractRequest)this.createOffsetCommitRequest(2));
        this.checkErrorResponse((AbstractRequest)this.createOffsetCommitRequest(2), (Throwable)new UnknownServerException());
        this.checkResponse((AbstractResponse)this.createOffsetCommitResponse(), 0);
        this.checkRequest((AbstractRequest)OffsetFetchRequest.forAllPartitions((String)"group1"));
        this.checkErrorResponse((AbstractRequest)OffsetFetchRequest.forAllPartitions((String)"group1"), (Throwable)new NotCoordinatorException("Not Coordinator"));
        this.checkRequest((AbstractRequest)this.createOffsetFetchRequest(0));
        this.checkRequest((AbstractRequest)this.createOffsetFetchRequest(1));
        this.checkRequest((AbstractRequest)this.createOffsetFetchRequest(2));
        this.checkRequest((AbstractRequest)OffsetFetchRequest.forAllPartitions((String)"group1"));
        this.checkErrorResponse((AbstractRequest)this.createOffsetFetchRequest(0), (Throwable)new UnknownServerException());
        this.checkErrorResponse((AbstractRequest)this.createOffsetFetchRequest(1), (Throwable)new UnknownServerException());
        this.checkErrorResponse((AbstractRequest)this.createOffsetFetchRequest(2), (Throwable)new UnknownServerException());
        this.checkResponse((AbstractResponse)this.createOffsetFetchResponse(), 0);
        this.checkRequest((AbstractRequest)this.createProduceRequest(2));
        this.checkErrorResponse((AbstractRequest)this.createProduceRequest(2), (Throwable)new UnknownServerException());
        this.checkRequest((AbstractRequest)this.createProduceRequest(3));
        this.checkErrorResponse((AbstractRequest)this.createProduceRequest(3), (Throwable)new UnknownServerException());
        this.checkResponse((AbstractResponse)this.createProduceResponse(), 2);
        this.checkRequest((AbstractRequest)this.createStopReplicaRequest(true));
        this.checkRequest((AbstractRequest)this.createStopReplicaRequest(false));
        this.checkErrorResponse((AbstractRequest)this.createStopReplicaRequest(true), (Throwable)new UnknownServerException());
        this.checkResponse((AbstractResponse)this.createStopReplicaResponse(), 0);
        this.checkRequest((AbstractRequest)this.createLeaderAndIsrRequest());
        this.checkErrorResponse((AbstractRequest)this.createLeaderAndIsrRequest(), (Throwable)new UnknownServerException());
        this.checkResponse((AbstractResponse)this.createLeaderAndIsrResponse(), 0);
        this.checkRequest((AbstractRequest)this.createSaslHandshakeRequest());
        this.checkErrorResponse((AbstractRequest)this.createSaslHandshakeRequest(), (Throwable)new UnknownServerException());
        this.checkResponse((AbstractResponse)this.createSaslHandshakeResponse(), 0);
        this.checkRequest((AbstractRequest)this.createApiVersionRequest());
        this.checkErrorResponse((AbstractRequest)this.createApiVersionRequest(), (Throwable)new UnknownServerException());
        this.checkResponse((AbstractResponse)this.createApiVersionResponse(), 0);
        this.checkRequest((AbstractRequest)this.createCreateTopicRequest(0));
        this.checkErrorResponse((AbstractRequest)this.createCreateTopicRequest(0), (Throwable)new UnknownServerException());
        this.checkResponse((AbstractResponse)this.createCreateTopicResponse(), 0);
        this.checkRequest((AbstractRequest)this.createCreateTopicRequest(1));
        this.checkErrorResponse((AbstractRequest)this.createCreateTopicRequest(1), (Throwable)new UnknownServerException());
        this.checkResponse((AbstractResponse)this.createCreateTopicResponse(), 1);
        this.checkRequest((AbstractRequest)this.createDeleteTopicsRequest());
        this.checkErrorResponse((AbstractRequest)this.createDeleteTopicsRequest(), (Throwable)new UnknownServerException());
        this.checkResponse((AbstractResponse)this.createDeleteTopicsResponse(), 0);
        this.checkRequest((AbstractRequest)this.createInitPidRequest());
        this.checkErrorResponse((AbstractRequest)this.createInitPidRequest(), (Throwable)new UnknownServerException());
        this.checkResponse((AbstractResponse)this.createInitPidResponse(), 0);
        this.checkRequest((AbstractRequest)this.createAddPartitionsToTxnRequest());
        this.checkResponse((AbstractResponse)this.createAddPartitionsToTxnResponse(), 0);
        this.checkErrorResponse((AbstractRequest)this.createAddPartitionsToTxnRequest(), (Throwable)new UnknownServerException());
        this.checkRequest((AbstractRequest)this.createAddOffsetsToTxnRequest());
        this.checkResponse((AbstractResponse)this.createAddOffsetsToTxnResponse(), 0);
        this.checkErrorResponse((AbstractRequest)this.createAddOffsetsToTxnRequest(), (Throwable)new UnknownServerException());
        this.checkRequest((AbstractRequest)this.createEndTxnRequest());
        this.checkResponse((AbstractResponse)this.createEndTxnResponse(), 0);
        this.checkErrorResponse((AbstractRequest)this.createEndTxnRequest(), (Throwable)new UnknownServerException());
        this.checkRequest((AbstractRequest)this.createWriteTxnMarkersRequest());
        this.checkResponse((AbstractResponse)this.createWriteTxnMarkersResponse(), 0);
        this.checkErrorResponse((AbstractRequest)this.createWriteTxnMarkersRequest(), (Throwable)new UnknownServerException());
        this.checkRequest((AbstractRequest)this.createTxnOffsetCommitRequest());
        this.checkResponse((AbstractResponse)this.createTxnOffsetCommitResponse(), 0);
        this.checkErrorResponse((AbstractRequest)this.createTxnOffsetCommitRequest(), (Throwable)new UnknownServerException());
        this.checkOlderFetchVersions();
        this.checkResponse((AbstractResponse)this.createMetadataResponse(), 0);
        this.checkResponse((AbstractResponse)this.createMetadataResponse(), 1);
        this.checkErrorResponse((AbstractRequest)this.createMetadataRequest(1, Collections.singletonList("topic1")), (Throwable)new UnknownServerException());
        this.checkRequest((AbstractRequest)this.createOffsetCommitRequest(0));
        this.checkErrorResponse((AbstractRequest)this.createOffsetCommitRequest(0), (Throwable)new UnknownServerException());
        this.checkRequest((AbstractRequest)this.createOffsetCommitRequest(1));
        this.checkErrorResponse((AbstractRequest)this.createOffsetCommitRequest(1), (Throwable)new UnknownServerException());
        this.checkRequest((AbstractRequest)this.createJoinGroupRequest(0));
        this.checkRequest((AbstractRequest)this.createUpdateMetadataRequest(0, null));
        this.checkErrorResponse((AbstractRequest)this.createUpdateMetadataRequest(0, null), (Throwable)new UnknownServerException());
        this.checkRequest((AbstractRequest)this.createUpdateMetadataRequest(1, null));
        this.checkRequest((AbstractRequest)this.createUpdateMetadataRequest(1, "rack1"));
        this.checkErrorResponse((AbstractRequest)this.createUpdateMetadataRequest(1, null), (Throwable)new UnknownServerException());
        this.checkRequest((AbstractRequest)this.createUpdateMetadataRequest(2, "rack1"));
        this.checkRequest((AbstractRequest)this.createUpdateMetadataRequest(2, null));
        this.checkErrorResponse((AbstractRequest)this.createUpdateMetadataRequest(2, "rack1"), (Throwable)new UnknownServerException());
        this.checkRequest((AbstractRequest)this.createUpdateMetadataRequest(3, "rack1"));
        this.checkRequest((AbstractRequest)this.createUpdateMetadataRequest(3, null));
        this.checkErrorResponse((AbstractRequest)this.createUpdateMetadataRequest(3, "rack1"), (Throwable)new UnknownServerException());
        this.checkResponse((AbstractResponse)this.createUpdateMetadataResponse(), 0);
        this.checkRequest((AbstractRequest)this.createListOffsetRequest(0));
        this.checkErrorResponse((AbstractRequest)this.createListOffsetRequest(0), (Throwable)new UnknownServerException());
        this.checkResponse((AbstractResponse)this.createListOffsetResponse(0), 0);
        this.checkRequest((AbstractRequest)this.createLeaderEpochRequest());
        this.checkResponse((AbstractResponse)this.createLeaderEpochResponse(), 0);
        this.checkErrorResponse((AbstractRequest)this.createLeaderEpochRequest(), (Throwable)new UnknownServerException());
        this.checkRequest((AbstractRequest)this.createAddPartitionsToTxnRequest());
        this.checkErrorResponse((AbstractRequest)this.createAddPartitionsToTxnRequest(), (Throwable)new UnknownServerException());
        this.checkResponse((AbstractResponse)this.createAddPartitionsToTxnResponse(), 0);
        this.checkRequest((AbstractRequest)this.createAddOffsetsToTxnRequest());
        this.checkErrorResponse((AbstractRequest)this.createAddOffsetsToTxnRequest(), (Throwable)new UnknownServerException());
        this.checkResponse((AbstractResponse)this.createAddOffsetsToTxnResponse(), 0);
        this.checkRequest((AbstractRequest)this.createEndTxnRequest());
        this.checkErrorResponse((AbstractRequest)this.createEndTxnRequest(), (Throwable)new UnknownServerException());
        this.checkResponse((AbstractResponse)this.createEndTxnResponse(), 0);
        this.checkRequest((AbstractRequest)this.createWriteTxnMarkersRequest());
        this.checkErrorResponse((AbstractRequest)this.createWriteTxnMarkersRequest(), (Throwable)new UnknownServerException());
        this.checkResponse((AbstractResponse)this.createWriteTxnMarkersResponse(), 0);
        this.checkRequest((AbstractRequest)this.createTxnOffsetCommitRequest());
        this.checkErrorResponse((AbstractRequest)this.createTxnOffsetCommitRequest(), (Throwable)new UnknownServerException());
        this.checkResponse((AbstractResponse)this.createTxnOffsetCommitResponse(), 0);
        this.checkRequest((AbstractRequest)this.createListAclsRequest());
        this.checkErrorResponse((AbstractRequest)this.createListAclsRequest(), (Throwable)new SecurityDisabledException("Security is not enabled."));
        this.checkResponse((AbstractResponse)this.createDescribeAclsResponse(), ApiKeys.DESCRIBE_ACLS.latestVersion());
        this.checkRequest((AbstractRequest)this.createCreateAclsRequest());
        this.checkErrorResponse((AbstractRequest)this.createCreateAclsRequest(), (Throwable)new SecurityDisabledException("Security is not enabled."));
        this.checkResponse((AbstractResponse)this.createCreateAclsResponse(), ApiKeys.CREATE_ACLS.latestVersion());
        this.checkRequest((AbstractRequest)this.createDeleteAclsRequest());
        this.checkErrorResponse((AbstractRequest)this.createDeleteAclsRequest(), (Throwable)new SecurityDisabledException("Security is not enabled."));
        this.checkResponse((AbstractResponse)this.createDeleteAclsResponse(), ApiKeys.DELETE_ACLS.latestVersion());
        this.checkRequest((AbstractRequest)this.createAlterConfigsRequest());
        this.checkErrorResponse((AbstractRequest)this.createAlterConfigsRequest(), (Throwable)new UnknownServerException());
        this.checkResponse((AbstractResponse)this.createAlterConfigsResponse(), 0);
        this.checkRequest((AbstractRequest)this.createDescribeConfigsRequest(0));
        this.checkRequest((AbstractRequest)this.createDescribeConfigsRequestWithConfigEntries(0));
        this.checkErrorResponse((AbstractRequest)this.createDescribeConfigsRequest(0), (Throwable)new UnknownServerException());
        this.checkResponse((AbstractResponse)this.createDescribeConfigsResponse(), 0);
        this.checkRequest((AbstractRequest)this.createDescribeConfigsRequest(1));
        this.checkRequest((AbstractRequest)this.createDescribeConfigsRequestWithConfigEntries(1));
        this.checkErrorResponse((AbstractRequest)this.createDescribeConfigsRequest(1), (Throwable)new UnknownServerException());
        this.checkResponse((AbstractResponse)this.createDescribeConfigsResponse(), 1);
        this.checkDescribeConfigsResponseVersions();
        this.checkRequest((AbstractRequest)this.createCreatePartitionsRequest());
        this.checkRequest((AbstractRequest)this.createCreatePartitionsRequestWithAssignments());
        this.checkErrorResponse((AbstractRequest)this.createCreatePartitionsRequest(), (Throwable)new InvalidTopicException());
        this.checkResponse((AbstractResponse)this.createCreatePartitionsResponse(), 0);
        this.checkRequest((AbstractRequest)this.createCreateTokenRequest());
        this.checkErrorResponse((AbstractRequest)this.createCreateTokenRequest(), (Throwable)new UnknownServerException());
        this.checkResponse((AbstractResponse)this.createCreateTokenResponse(), 0);
        this.checkRequest((AbstractRequest)this.createDescribeTokenRequest());
        this.checkErrorResponse((AbstractRequest)this.createDescribeTokenRequest(), (Throwable)new UnknownServerException());
        this.checkResponse((AbstractResponse)this.createDescribeTokenResponse(), 0);
        this.checkRequest((AbstractRequest)this.createExpireTokenRequest());
        this.checkErrorResponse((AbstractRequest)this.createExpireTokenRequest(), (Throwable)new UnknownServerException());
        this.checkResponse((AbstractResponse)this.createExpireTokenResponse(), 0);
        this.checkRequest((AbstractRequest)this.createRenewTokenRequest());
        this.checkErrorResponse((AbstractRequest)this.createRenewTokenRequest(), (Throwable)new UnknownServerException());
        this.checkResponse((AbstractResponse)this.createRenewTokenResponse(), 0);
    }

    @Test
    public void testResponseHeader() {
        ResponseHeader header = this.createResponseHeader();
        ByteBuffer buffer = TestUtils.toBuffer(header.toStruct());
        ResponseHeader deserialized = ResponseHeader.parse((ByteBuffer)buffer);
        Assert.assertEquals((long)header.correlationId(), (long)deserialized.correlationId());
    }

    private void checkOlderFetchVersions() throws Exception {
        int latestVersion = ApiKeys.FETCH.latestVersion();
        for (int i = 0; i < latestVersion; ++i) {
            this.checkErrorResponse((AbstractRequest)this.createFetchRequest(i), (Throwable)new UnknownServerException());
            this.checkRequest((AbstractRequest)this.createFetchRequest(i));
            this.checkResponse((AbstractResponse)this.createFetchResponse(), i);
        }
    }

    private void verifyDescribeConfigsResponse(DescribeConfigsResponse expected, DescribeConfigsResponse actual, int version) throws Exception {
        for (Resource resource : expected.configs().keySet()) {
            Collection deserializedEntries1 = actual.config(resource).entries();
            Iterator expectedEntries = expected.config(resource).entries().iterator();
            for (DescribeConfigsResponse.ConfigEntry entry : deserializedEntries1) {
                DescribeConfigsResponse.ConfigEntry expectedEntry = (DescribeConfigsResponse.ConfigEntry)expectedEntries.next();
                Assert.assertEquals((Object)expectedEntry.name(), (Object)entry.name());
                Assert.assertEquals((Object)expectedEntry.value(), (Object)entry.value());
                Assert.assertEquals((Object)expectedEntry.isReadOnly(), (Object)entry.isReadOnly());
                Assert.assertEquals((Object)expectedEntry.isSensitive(), (Object)entry.isSensitive());
                if (version == 1 || expectedEntry.source() != DescribeConfigsResponse.ConfigSource.DYNAMIC_BROKER_CONFIG && expectedEntry.source() != DescribeConfigsResponse.ConfigSource.DYNAMIC_DEFAULT_BROKER_CONFIG) {
                    Assert.assertEquals((Object)expectedEntry.source(), (Object)entry.source());
                    continue;
                }
                Assert.assertEquals((Object)DescribeConfigsResponse.ConfigSource.STATIC_BROKER_CONFIG, (Object)entry.source());
            }
        }
    }

    private void checkDescribeConfigsResponseVersions() throws Exception {
        DescribeConfigsResponse response = this.createDescribeConfigsResponse();
        DescribeConfigsResponse deserialized0 = (DescribeConfigsResponse)this.deserialize((AbstractRequestResponse)response, response.toStruct((short)0), (short)0);
        this.verifyDescribeConfigsResponse(response, deserialized0, 0);
        DescribeConfigsResponse deserialized1 = (DescribeConfigsResponse)this.deserialize((AbstractRequestResponse)response, response.toStruct((short)1), (short)1);
        this.verifyDescribeConfigsResponse(response, deserialized1, 1);
    }

    private void checkErrorResponse(AbstractRequest req, Throwable e) throws Exception {
        this.checkResponse(req.getErrorResponse(e), req.version());
    }

    private void checkRequest(AbstractRequest req) throws Exception {
        Struct struct = req.toStruct();
        AbstractRequest deserialized = (AbstractRequest)this.deserialize((AbstractRequestResponse)req, struct, req.version());
        deserialized.toStruct();
    }

    private void checkResponse(AbstractResponse response, int version) throws Exception {
        Struct struct = response.toStruct((short)version);
        AbstractResponse deserialized = (AbstractResponse)this.deserialize((AbstractRequestResponse)response, struct, (short)version);
        deserialized.toStruct((short)version);
    }

    private AbstractRequestResponse deserialize(AbstractRequestResponse req, Struct struct, short version) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        ByteBuffer buffer = TestUtils.toBuffer(struct);
        Method deserializer = req.getClass().getDeclaredMethod("parse", ByteBuffer.class, Short.TYPE);
        return (AbstractRequestResponse)deserializer.invoke(null, buffer, version);
    }

    @Test(expected=UnsupportedVersionException.class)
    public void cannotUseFindCoordinatorV0ToFindTransactionCoordinator() {
        FindCoordinatorRequest.Builder builder = new FindCoordinatorRequest.Builder(FindCoordinatorRequest.CoordinatorType.TRANSACTION, "foobar");
        builder.build((short)0);
    }

    @Test
    public void produceRequestToStringTest() {
        ProduceRequest request = this.createProduceRequest(ApiKeys.PRODUCE.latestVersion());
        Assert.assertEquals((long)1L, (long)request.partitionRecordsOrFail().size());
        Assert.assertFalse((boolean)request.toString(false).contains("partitionSizes"));
        Assert.assertTrue((boolean)request.toString(false).contains("numPartitions=1"));
        Assert.assertTrue((boolean)request.toString(true).contains("partitionSizes"));
        Assert.assertFalse((boolean)request.toString(true).contains("numPartitions"));
        request.clearPartitionRecords();
        try {
            request.partitionRecordsOrFail();
            Assert.fail((String)"partitionRecordsOrFail should fail after clearPartitionRecords()");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        Assert.assertFalse((boolean)request.toString(false).contains("partitionSizes"));
        Assert.assertTrue((boolean)request.toString(false).contains("numPartitions=1"));
        Assert.assertTrue((boolean)request.toString(true).contains("partitionSizes"));
        Assert.assertFalse((boolean)request.toString(true).contains("numPartitions"));
    }

    @Test
    public void produceRequestGetErrorResponseTest() {
        ProduceRequest request = this.createProduceRequest(ApiKeys.PRODUCE.latestVersion());
        HashSet partitions = new HashSet(request.partitionRecordsOrFail().keySet());
        ProduceResponse errorResponse = (ProduceResponse)request.getErrorResponse((Throwable)new NotEnoughReplicasException());
        Assert.assertEquals(partitions, errorResponse.responses().keySet());
        ProduceResponse.PartitionResponse partitionResponse = (ProduceResponse.PartitionResponse)errorResponse.responses().values().iterator().next();
        Assert.assertEquals((Object)Errors.NOT_ENOUGH_REPLICAS, (Object)partitionResponse.error);
        Assert.assertEquals((long)-1L, (long)partitionResponse.baseOffset);
        Assert.assertEquals((long)-1L, (long)partitionResponse.logAppendTime);
        request.clearPartitionRecords();
        errorResponse = (ProduceResponse)request.getErrorResponse((Throwable)new NotEnoughReplicasException());
        Assert.assertEquals(partitions, errorResponse.responses().keySet());
        partitionResponse = (ProduceResponse.PartitionResponse)errorResponse.responses().values().iterator().next();
        Assert.assertEquals((Object)Errors.NOT_ENOUGH_REPLICAS, (Object)partitionResponse.error);
        Assert.assertEquals((long)-1L, (long)partitionResponse.baseOffset);
        Assert.assertEquals((long)-1L, (long)partitionResponse.logAppendTime);
    }

    @Test
    public void produceResponseV5Test() {
        HashMap<TopicPartition, ProduceResponse.PartitionResponse> responseData = new HashMap<TopicPartition, ProduceResponse.PartitionResponse>();
        TopicPartition tp0 = new TopicPartition("test", 0);
        responseData.put(tp0, new ProduceResponse.PartitionResponse(Errors.NONE, 10000L, -1L, 100L));
        ProduceResponse v5Response = new ProduceResponse(responseData, 10);
        short version = 5;
        ByteBuffer buffer = v5Response.serialize(version, new ResponseHeader(0));
        buffer.rewind();
        ResponseHeader.parse((ByteBuffer)buffer);
        Struct deserializedStruct = ApiKeys.PRODUCE.parseResponse(version, buffer);
        ProduceResponse v5FromBytes = (ProduceResponse)AbstractResponse.parseResponse((ApiKeys)ApiKeys.PRODUCE, (Struct)deserializedStruct);
        Assert.assertEquals((long)1L, (long)v5FromBytes.responses().size());
        Assert.assertTrue((boolean)v5FromBytes.responses().containsKey(tp0));
        ProduceResponse.PartitionResponse partitionResponse = (ProduceResponse.PartitionResponse)v5FromBytes.responses().get(tp0);
        Assert.assertEquals((long)100L, (long)partitionResponse.logStartOffset);
        Assert.assertEquals((long)10000L, (long)partitionResponse.baseOffset);
        Assert.assertEquals((long)10L, (long)v5FromBytes.getThrottleTime());
        Assert.assertEquals(responseData, (Object)v5Response.responses());
    }

    @Test
    public void produceResponseVersionTest() {
        HashMap<TopicPartition, ProduceResponse.PartitionResponse> responseData = new HashMap<TopicPartition, ProduceResponse.PartitionResponse>();
        responseData.put(new TopicPartition("test", 0), new ProduceResponse.PartitionResponse(Errors.NONE, 10000L, -1L, 100L));
        ProduceResponse v0Response = new ProduceResponse(responseData);
        ProduceResponse v1Response = new ProduceResponse(responseData, 10);
        ProduceResponse v2Response = new ProduceResponse(responseData, 10);
        Assert.assertEquals((String)"Throttle time must be zero", (long)0L, (long)v0Response.getThrottleTime());
        Assert.assertEquals((String)"Throttle time must be 10", (long)10L, (long)v1Response.getThrottleTime());
        Assert.assertEquals((String)"Throttle time must be 10", (long)10L, (long)v2Response.getThrottleTime());
        Assert.assertEquals((String)"Should use schema version 0", (Object)ApiKeys.PRODUCE.responseSchema((short)0), (Object)v0Response.toStruct((short)0).schema());
        Assert.assertEquals((String)"Should use schema version 1", (Object)ApiKeys.PRODUCE.responseSchema((short)1), (Object)v1Response.toStruct((short)1).schema());
        Assert.assertEquals((String)"Should use schema version 2", (Object)ApiKeys.PRODUCE.responseSchema((short)2), (Object)v2Response.toStruct((short)2).schema());
        Assert.assertEquals((String)"Response data does not match", responseData, (Object)v0Response.responses());
        Assert.assertEquals((String)"Response data does not match", responseData, (Object)v1Response.responses());
        Assert.assertEquals((String)"Response data does not match", responseData, (Object)v2Response.responses());
    }

    @Test
    public void fetchResponseVersionTest() {
        LinkedHashMap<TopicPartition, FetchResponse.PartitionData> responseData = new LinkedHashMap<TopicPartition, FetchResponse.PartitionData>();
        MemoryRecords records = MemoryRecords.readableRecords((ByteBuffer)ByteBuffer.allocate(10));
        responseData.put(new TopicPartition("test", 0), new FetchResponse.PartitionData(Errors.NONE, 1000000L, -1L, 0L, null, (Records)records));
        FetchResponse v0Response = new FetchResponse(Errors.NONE, responseData, 0, 0);
        FetchResponse v1Response = new FetchResponse(Errors.NONE, responseData, 10, 0);
        Assert.assertEquals((String)"Throttle time must be zero", (long)0L, (long)v0Response.throttleTimeMs());
        Assert.assertEquals((String)"Throttle time must be 10", (long)10L, (long)v1Response.throttleTimeMs());
        Assert.assertEquals((String)"Should use schema version 0", (Object)ApiKeys.FETCH.responseSchema((short)0), (Object)v0Response.toStruct((short)0).schema());
        Assert.assertEquals((String)"Should use schema version 1", (Object)ApiKeys.FETCH.responseSchema((short)1), (Object)v1Response.toStruct((short)1).schema());
        Assert.assertEquals((String)"Response data does not match", responseData, (Object)v0Response.responseData());
        Assert.assertEquals((String)"Response data does not match", responseData, (Object)v1Response.responseData());
    }

    @Test
    public void testFetchResponseV4() {
        LinkedHashMap<TopicPartition, FetchResponse.PartitionData> responseData = new LinkedHashMap<TopicPartition, FetchResponse.PartitionData>();
        MemoryRecords records = MemoryRecords.readableRecords((ByteBuffer)ByteBuffer.allocate(10));
        List<FetchResponse.AbortedTransaction> abortedTransactions = Arrays.asList(new FetchResponse.AbortedTransaction(10L, 100L), new FetchResponse.AbortedTransaction(15L, 50L));
        responseData.put(new TopicPartition("bar", 0), new FetchResponse.PartitionData(Errors.NONE, 100000L, -1L, -1L, abortedTransactions, (Records)records));
        responseData.put(new TopicPartition("bar", 1), new FetchResponse.PartitionData(Errors.NONE, 900000L, 5L, -1L, null, (Records)records));
        responseData.put(new TopicPartition("foo", 0), new FetchResponse.PartitionData(Errors.NONE, 70000L, 6L, -1L, Collections.emptyList(), (Records)records));
        FetchResponse response = new FetchResponse(Errors.NONE, responseData, 10, 0);
        FetchResponse deserialized = FetchResponse.parse((ByteBuffer)TestUtils.toBuffer(response.toStruct((short)4)), (short)4);
        Assert.assertEquals(responseData, (Object)deserialized.responseData());
    }

    @Test
    public void verifyFetchResponseFullWrites() throws Exception {
        this.verifyFetchResponseFullWrite(ApiKeys.FETCH.latestVersion(), this.createFetchResponse(123));
        this.verifyFetchResponseFullWrite(ApiKeys.FETCH.latestVersion(), this.createFetchResponse(Errors.FETCH_SESSION_ID_NOT_FOUND, 123));
        for (short version = 0; version <= ApiKeys.FETCH.latestVersion(); version = (short)(version + 1)) {
            this.verifyFetchResponseFullWrite(version, this.createFetchResponse());
        }
    }

    private void verifyFetchResponseFullWrite(short apiVersion, FetchResponse fetchResponse) throws Exception {
        int correlationId = 15;
        Send send = fetchResponse.toSend("1", new ResponseHeader(correlationId), apiVersion);
        ByteBufferChannel channel = new ByteBufferChannel(send.size());
        send.writeTo((GatheringByteChannel)channel);
        channel.close();
        ByteBuffer buf = channel.buffer();
        int size = buf.getInt();
        Assert.assertTrue((size > 0 ? 1 : 0) != 0);
        ResponseHeader responseHeader = ResponseHeader.parse((ByteBuffer)channel.buffer());
        Assert.assertEquals((long)correlationId, (long)responseHeader.correlationId());
        Struct responseBody = ApiKeys.FETCH.responseSchema(apiVersion).read(buf);
        Assert.assertEquals((Object)fetchResponse.toStruct(apiVersion), (Object)responseBody);
        Assert.assertEquals((long)size, (long)(responseHeader.sizeOf() + responseBody.sizeOf()));
    }

    @Test
    public void testControlledShutdownResponse() {
        ControlledShutdownResponse response = this.createControlledShutdownResponse();
        short version = ApiKeys.CONTROLLED_SHUTDOWN.latestVersion();
        Struct struct = response.toStruct(version);
        ByteBuffer buffer = TestUtils.toBuffer(struct);
        ControlledShutdownResponse deserialized = ControlledShutdownResponse.parse((ByteBuffer)buffer, (short)version);
        Assert.assertEquals((Object)response.error(), (Object)deserialized.error());
        Assert.assertEquals((Object)response.partitionsRemaining(), (Object)deserialized.partitionsRemaining());
    }

    @Test(expected=UnsupportedVersionException.class)
    public void testCreateTopicRequestV0FailsIfValidateOnly() {
        this.createCreateTopicRequest(0, true);
    }

    @Test
    public void testFetchRequestMaxBytesOldVersions() throws Exception {
        boolean version = true;
        FetchRequest fr = this.createFetchRequest(1);
        FetchRequest fr2 = new FetchRequest(fr.toStruct(), 1);
        Assert.assertEquals((long)fr2.maxBytes(), (long)fr.maxBytes());
    }

    @Test
    public void testFetchRequestIsolationLevel() throws Exception {
        FetchRequest request = this.createFetchRequest(4, IsolationLevel.READ_COMMITTED);
        Struct struct = request.toStruct();
        FetchRequest deserialized = (FetchRequest)this.deserialize((AbstractRequestResponse)request, struct, request.version());
        Assert.assertEquals((Object)request.isolationLevel(), (Object)deserialized.isolationLevel());
        request = this.createFetchRequest(4, IsolationLevel.READ_UNCOMMITTED);
        struct = request.toStruct();
        deserialized = (FetchRequest)this.deserialize((AbstractRequestResponse)request, struct, request.version());
        Assert.assertEquals((Object)request.isolationLevel(), (Object)deserialized.isolationLevel());
    }

    @Test
    public void testFetchRequestWithMetadata() throws Exception {
        FetchRequest request = this.createFetchRequest(4, IsolationLevel.READ_COMMITTED);
        Struct struct = request.toStruct();
        FetchRequest deserialized = (FetchRequest)this.deserialize((AbstractRequestResponse)request, struct, request.version());
        Assert.assertEquals((Object)request.isolationLevel(), (Object)deserialized.isolationLevel());
        request = this.createFetchRequest(4, IsolationLevel.READ_UNCOMMITTED);
        struct = request.toStruct();
        deserialized = (FetchRequest)this.deserialize((AbstractRequestResponse)request, struct, request.version());
        Assert.assertEquals((Object)request.isolationLevel(), (Object)deserialized.isolationLevel());
    }

    @Test
    public void testJoinGroupRequestVersion0RebalanceTimeout() throws Exception {
        boolean version = false;
        JoinGroupRequest jgr = this.createJoinGroupRequest(0);
        JoinGroupRequest jgr2 = new JoinGroupRequest(jgr.toStruct(), 0);
        Assert.assertEquals((long)jgr2.rebalanceTimeout(), (long)jgr.rebalanceTimeout());
    }

    @Test
    public void testOffsetFetchRequestBuilderToString() {
        String allTopicPartitionsString = OffsetFetchRequest.Builder.allTopicPartitions((String)"someGroup").toString();
        Assert.assertTrue((boolean)allTopicPartitionsString.contains("<ALL>"));
        String string = new OffsetFetchRequest.Builder("group1", Collections.singletonList(new TopicPartition("test11", 1))).toString();
        Assert.assertTrue((boolean)string.contains("test11"));
        Assert.assertTrue((boolean)string.contains("group1"));
    }

    private ResponseHeader createResponseHeader() {
        return new ResponseHeader(10);
    }

    private FindCoordinatorRequest createFindCoordinatorRequest(int version) {
        return new FindCoordinatorRequest.Builder(FindCoordinatorRequest.CoordinatorType.GROUP, "test-group").build((short)version);
    }

    private FindCoordinatorResponse createFindCoordinatorResponse() {
        return new FindCoordinatorResponse(Errors.NONE, new Node(10, "host1", 2014));
    }

    private FetchRequest createFetchRequest(int version, FetchMetadata metadata, List<TopicPartition> toForget) {
        LinkedHashMap<TopicPartition, FetchRequest.PartitionData> fetchData = new LinkedHashMap<TopicPartition, FetchRequest.PartitionData>();
        fetchData.put(new TopicPartition("test1", 0), new FetchRequest.PartitionData(100L, 0L, 1000000));
        fetchData.put(new TopicPartition("test2", 0), new FetchRequest.PartitionData(200L, 0L, 1000000));
        return FetchRequest.Builder.forConsumer((int)100, (int)100000, fetchData).metadata(metadata).setMaxBytes(1000).toForget(toForget).build((short)version);
    }

    private FetchRequest createFetchRequest(int version, IsolationLevel isolationLevel) {
        LinkedHashMap<TopicPartition, FetchRequest.PartitionData> fetchData = new LinkedHashMap<TopicPartition, FetchRequest.PartitionData>();
        fetchData.put(new TopicPartition("test1", 0), new FetchRequest.PartitionData(100L, 0L, 1000000));
        fetchData.put(new TopicPartition("test2", 0), new FetchRequest.PartitionData(200L, 0L, 1000000));
        return FetchRequest.Builder.forConsumer((int)100, (int)100000, fetchData).isolationLevel(isolationLevel).setMaxBytes(1000).build((short)version);
    }

    private FetchRequest createFetchRequest(int version) {
        LinkedHashMap<TopicPartition, FetchRequest.PartitionData> fetchData = new LinkedHashMap<TopicPartition, FetchRequest.PartitionData>();
        fetchData.put(new TopicPartition("test1", 0), new FetchRequest.PartitionData(100L, 0L, 1000000));
        fetchData.put(new TopicPartition("test2", 0), new FetchRequest.PartitionData(200L, 0L, 1000000));
        return FetchRequest.Builder.forConsumer((int)100, (int)100000, fetchData).setMaxBytes(1000).build((short)version);
    }

    private FetchResponse createFetchResponse(Errors error, int sessionId) {
        return new FetchResponse(error, new LinkedHashMap(), 25, sessionId);
    }

    private FetchResponse createFetchResponse(int sessionId) {
        LinkedHashMap<TopicPartition, FetchResponse.PartitionData> responseData = new LinkedHashMap<TopicPartition, FetchResponse.PartitionData>();
        MemoryRecords records = MemoryRecords.withRecords((CompressionType)CompressionType.NONE, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord("blah".getBytes())});
        responseData.put(new TopicPartition("test", 0), new FetchResponse.PartitionData(Errors.NONE, 1000000L, -1L, 0L, null, (Records)records));
        List<FetchResponse.AbortedTransaction> abortedTransactions = Collections.singletonList(new FetchResponse.AbortedTransaction(234L, 999L));
        responseData.put(new TopicPartition("test", 1), new FetchResponse.PartitionData(Errors.NONE, 1000000L, -1L, 0L, abortedTransactions, (Records)MemoryRecords.EMPTY));
        return new FetchResponse(Errors.NONE, responseData, 25, sessionId);
    }

    private FetchResponse createFetchResponse() {
        LinkedHashMap<TopicPartition, FetchResponse.PartitionData> responseData = new LinkedHashMap<TopicPartition, FetchResponse.PartitionData>();
        MemoryRecords records = MemoryRecords.withRecords((CompressionType)CompressionType.NONE, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord("blah".getBytes())});
        responseData.put(new TopicPartition("test", 0), new FetchResponse.PartitionData(Errors.NONE, 1000000L, -1L, 0L, null, (Records)records));
        List<FetchResponse.AbortedTransaction> abortedTransactions = Collections.singletonList(new FetchResponse.AbortedTransaction(234L, 999L));
        responseData.put(new TopicPartition("test", 1), new FetchResponse.PartitionData(Errors.NONE, 1000000L, -1L, 0L, abortedTransactions, (Records)MemoryRecords.EMPTY));
        return new FetchResponse(Errors.NONE, responseData, 25, 0);
    }

    private HeartbeatRequest createHeartBeatRequest() {
        return (HeartbeatRequest)new HeartbeatRequest.Builder("group1", 1, "consumer1").build();
    }

    private HeartbeatResponse createHeartBeatResponse() {
        return new HeartbeatResponse(Errors.NONE);
    }

    private JoinGroupRequest createJoinGroupRequest(int version) {
        ByteBuffer metadata = ByteBuffer.wrap(new byte[0]);
        ArrayList<JoinGroupRequest.ProtocolMetadata> protocols = new ArrayList<JoinGroupRequest.ProtocolMetadata>();
        protocols.add(new JoinGroupRequest.ProtocolMetadata("consumer-range", metadata));
        if (version == 0) {
            return new JoinGroupRequest.Builder("group1", 30000, "consumer1", "consumer", protocols).build((short)version);
        }
        return (JoinGroupRequest)new JoinGroupRequest.Builder("group1", 10000, "consumer1", "consumer", protocols).setRebalanceTimeout(60000).build();
    }

    private JoinGroupResponse createJoinGroupResponse() {
        HashMap<String, ByteBuffer> members = new HashMap<String, ByteBuffer>();
        members.put("consumer1", ByteBuffer.wrap(new byte[0]));
        members.put("consumer2", ByteBuffer.wrap(new byte[0]));
        return new JoinGroupResponse(Errors.NONE, 1, "range", "consumer1", "leader", members);
    }

    private ListGroupsRequest createListGroupsRequest() {
        return (ListGroupsRequest)new ListGroupsRequest.Builder().build();
    }

    private ListGroupsResponse createListGroupsResponse() {
        List<ListGroupsResponse.Group> groups = Collections.singletonList(new ListGroupsResponse.Group("test-group", "consumer"));
        return new ListGroupsResponse(Errors.NONE, groups);
    }

    private DescribeGroupsRequest createDescribeGroupRequest() {
        return (DescribeGroupsRequest)new DescribeGroupsRequest.Builder(Collections.singletonList("test-group")).build();
    }

    private DescribeGroupsResponse createDescribeGroupResponse() {
        String clientId = "consumer-1";
        String clientHost = "localhost";
        ByteBuffer empty = ByteBuffer.allocate(0);
        DescribeGroupsResponse.GroupMember member = new DescribeGroupsResponse.GroupMember("memberId", clientId, clientHost, empty, empty);
        DescribeGroupsResponse.GroupMetadata metadata = new DescribeGroupsResponse.GroupMetadata(Errors.NONE, "STABLE", "consumer", "roundrobin", Arrays.asList(member));
        return new DescribeGroupsResponse(Collections.singletonMap("test-group", metadata));
    }

    private LeaveGroupRequest createLeaveGroupRequest() {
        return (LeaveGroupRequest)new LeaveGroupRequest.Builder("group1", "consumer1").build();
    }

    private LeaveGroupResponse createLeaveGroupResponse() {
        return new LeaveGroupResponse(Errors.NONE);
    }

    private DeleteGroupsRequest createDeleteGroupsRequest() {
        return (DeleteGroupsRequest)new DeleteGroupsRequest.Builder(Collections.singleton("test-group")).build();
    }

    private DeleteGroupsResponse createDeleteGroupsResponse() {
        HashMap<String, Errors> result = new HashMap<String, Errors>();
        result.put("test-group", Errors.NONE);
        return new DeleteGroupsResponse(result);
    }

    private ListOffsetRequest createListOffsetRequest(int version) {
        if (version == 0) {
            Map<TopicPartition, ListOffsetRequest.PartitionData> offsetData = Collections.singletonMap(new TopicPartition("test", 0), new ListOffsetRequest.PartitionData(1000000L, 10));
            return ListOffsetRequest.Builder.forConsumer((boolean)false, (IsolationLevel)IsolationLevel.READ_UNCOMMITTED).setOffsetData(offsetData).build((short)version);
        }
        if (version == 1) {
            Map<TopicPartition, Long> offsetData = Collections.singletonMap(new TopicPartition("test", 0), 1000000L);
            return ListOffsetRequest.Builder.forConsumer((boolean)true, (IsolationLevel)IsolationLevel.READ_UNCOMMITTED).setTargetTimes(offsetData).build((short)version);
        }
        if (version == 2) {
            Map<TopicPartition, Long> offsetData = Collections.singletonMap(new TopicPartition("test", 0), 1000000L);
            return ListOffsetRequest.Builder.forConsumer((boolean)true, (IsolationLevel)IsolationLevel.READ_COMMITTED).setTargetTimes(offsetData).build((short)version);
        }
        throw new IllegalArgumentException("Illegal ListOffsetRequest version " + version);
    }

    private ListOffsetResponse createListOffsetResponse(int version) {
        if (version == 0) {
            HashMap<TopicPartition, ListOffsetResponse.PartitionData> responseData = new HashMap<TopicPartition, ListOffsetResponse.PartitionData>();
            responseData.put(new TopicPartition("test", 0), new ListOffsetResponse.PartitionData(Errors.NONE, Arrays.asList(100L)));
            return new ListOffsetResponse(responseData);
        }
        if (version == 1 || version == 2) {
            HashMap<TopicPartition, ListOffsetResponse.PartitionData> responseData = new HashMap<TopicPartition, ListOffsetResponse.PartitionData>();
            responseData.put(new TopicPartition("test", 0), new ListOffsetResponse.PartitionData(Errors.NONE, 10000L, 100L));
            return new ListOffsetResponse(responseData);
        }
        throw new IllegalArgumentException("Illegal ListOffsetResponse version " + version);
    }

    private MetadataRequest createMetadataRequest(int version, List<String> topics) {
        return new MetadataRequest.Builder(topics, true).build((short)version);
    }

    private MetadataResponse createMetadataResponse() {
        Node node = new Node(1, "host1", 1001);
        List<Node> replicas = Arrays.asList(node);
        List<Node> isr = Arrays.asList(node);
        List<Node> offlineReplicas = Arrays.asList(new Node[0]);
        ArrayList<MetadataResponse.TopicMetadata> allTopicMetadata = new ArrayList<MetadataResponse.TopicMetadata>();
        allTopicMetadata.add(new MetadataResponse.TopicMetadata(Errors.NONE, "__consumer_offsets", true, Arrays.asList(new MetadataResponse.PartitionMetadata(Errors.NONE, 1, node, replicas, isr, offlineReplicas))));
        allTopicMetadata.add(new MetadataResponse.TopicMetadata(Errors.LEADER_NOT_AVAILABLE, "topic2", false, Collections.emptyList()));
        allTopicMetadata.add(new MetadataResponse.TopicMetadata(Errors.NONE, "topic3", false, Arrays.asList(new MetadataResponse.PartitionMetadata(Errors.LEADER_NOT_AVAILABLE, 0, null, replicas, isr, offlineReplicas))));
        return new MetadataResponse(Arrays.asList(node), null, -1, allTopicMetadata);
    }

    private OffsetCommitRequest createOffsetCommitRequest(int version) {
        HashMap<TopicPartition, OffsetCommitRequest.PartitionData> commitData = new HashMap<TopicPartition, OffsetCommitRequest.PartitionData>();
        commitData.put(new TopicPartition("test", 0), new OffsetCommitRequest.PartitionData(100L, ""));
        commitData.put(new TopicPartition("test", 1), new OffsetCommitRequest.PartitionData(200L, null));
        return new OffsetCommitRequest.Builder("group1", commitData).setGenerationId(100).setMemberId("consumer1").setRetentionTime(1000000L).build((short)version);
    }

    private OffsetCommitResponse createOffsetCommitResponse() {
        HashMap<TopicPartition, Errors> responseData = new HashMap<TopicPartition, Errors>();
        responseData.put(new TopicPartition("test", 0), Errors.NONE);
        return new OffsetCommitResponse(responseData);
    }

    private OffsetFetchRequest createOffsetFetchRequest(int version) {
        return new OffsetFetchRequest.Builder("group1", Collections.singletonList(new TopicPartition("test11", 1))).build((short)version);
    }

    private OffsetFetchResponse createOffsetFetchResponse() {
        HashMap<TopicPartition, OffsetFetchResponse.PartitionData> responseData = new HashMap<TopicPartition, OffsetFetchResponse.PartitionData>();
        responseData.put(new TopicPartition("test", 0), new OffsetFetchResponse.PartitionData(100L, "", Errors.NONE));
        responseData.put(new TopicPartition("test", 1), new OffsetFetchResponse.PartitionData(100L, null, Errors.NONE));
        return new OffsetFetchResponse(Errors.NONE, responseData);
    }

    private ProduceRequest createProduceRequest(int version) {
        if (version < 2) {
            throw new IllegalArgumentException("Produce request version 2 is not supported");
        }
        byte magic = version == 2 ? (byte)1 : 2;
        MemoryRecords records = MemoryRecords.withRecords((byte)magic, (CompressionType)CompressionType.NONE, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord("woot".getBytes())});
        Map<TopicPartition, MemoryRecords> produceData = Collections.singletonMap(new TopicPartition("test", 0), records);
        return ProduceRequest.Builder.forMagic((byte)magic, (short)1, (int)5000, produceData, (String)"transactionalId").build((short)version);
    }

    private ProduceResponse createProduceResponse() {
        HashMap<TopicPartition, ProduceResponse.PartitionResponse> responseData = new HashMap<TopicPartition, ProduceResponse.PartitionResponse>();
        responseData.put(new TopicPartition("test", 0), new ProduceResponse.PartitionResponse(Errors.NONE, 10000L, -1L, 100L));
        return new ProduceResponse(responseData, 0);
    }

    private StopReplicaRequest createStopReplicaRequest(boolean deletePartitions) {
        Set partitions = Utils.mkSet((Object[])new TopicPartition[]{new TopicPartition("test", 0)});
        return (StopReplicaRequest)new StopReplicaRequest.Builder(0, 1, deletePartitions, partitions).build();
    }

    private StopReplicaResponse createStopReplicaResponse() {
        HashMap<TopicPartition, Errors> responses = new HashMap<TopicPartition, Errors>();
        responses.put(new TopicPartition("test", 0), Errors.NONE);
        return new StopReplicaResponse(Errors.NONE, responses);
    }

    private ControlledShutdownRequest createControlledShutdownRequest() {
        return (ControlledShutdownRequest)new ControlledShutdownRequest.Builder(10, ApiKeys.CONTROLLED_SHUTDOWN.latestVersion()).build();
    }

    private ControlledShutdownRequest createControlledShutdownRequest(int version) {
        return new ControlledShutdownRequest.Builder(10, ApiKeys.CONTROLLED_SHUTDOWN.latestVersion()).build((short)version);
    }

    private ControlledShutdownResponse createControlledShutdownResponse() {
        Set topicPartitions = Utils.mkSet((Object[])new TopicPartition[]{new TopicPartition("test2", 5), new TopicPartition("test1", 10)});
        return new ControlledShutdownResponse(Errors.NONE, topicPartitions);
    }

    private LeaderAndIsrRequest createLeaderAndIsrRequest() {
        HashMap<TopicPartition, LeaderAndIsrRequest.PartitionState> partitionStates = new HashMap<TopicPartition, LeaderAndIsrRequest.PartitionState>();
        List<Integer> isr = Arrays.asList(1, 2);
        List<Integer> replicas = Arrays.asList(1, 2, 3, 4);
        partitionStates.put(new TopicPartition("topic5", 105), new LeaderAndIsrRequest.PartitionState(0, 2, 1, new ArrayList<Integer>(isr), 2, replicas, false));
        partitionStates.put(new TopicPartition("topic5", 1), new LeaderAndIsrRequest.PartitionState(1, 1, 1, new ArrayList<Integer>(isr), 2, replicas, false));
        partitionStates.put(new TopicPartition("topic20", 1), new LeaderAndIsrRequest.PartitionState(1, 0, 1, new ArrayList<Integer>(isr), 2, replicas, false));
        Set leaders = Utils.mkSet((Object[])new Node[]{new Node(0, "test0", 1223), new Node(1, "test1", 1223)});
        return (LeaderAndIsrRequest)new LeaderAndIsrRequest.Builder(ApiKeys.LEADER_AND_ISR.latestVersion(), 1, 10, partitionStates, leaders).build();
    }

    private LeaderAndIsrResponse createLeaderAndIsrResponse() {
        HashMap<TopicPartition, Errors> responses = new HashMap<TopicPartition, Errors>();
        responses.put(new TopicPartition("test", 0), Errors.NONE);
        return new LeaderAndIsrResponse(Errors.NONE, responses);
    }

    private UpdateMetadataRequest createUpdateMetadataRequest(int version, String rack) {
        HashMap<TopicPartition, UpdateMetadataRequest.PartitionState> partitionStates = new HashMap<TopicPartition, UpdateMetadataRequest.PartitionState>();
        List<Integer> isr = Arrays.asList(1, 2);
        List<Integer> replicas = Arrays.asList(1, 2, 3, 4);
        List<Integer> offlineReplicas = Arrays.asList(new Integer[0]);
        partitionStates.put(new TopicPartition("topic5", 105), new UpdateMetadataRequest.PartitionState(0, 2, 1, isr, 2, replicas, offlineReplicas));
        partitionStates.put(new TopicPartition("topic5", 1), new UpdateMetadataRequest.PartitionState(1, 1, 1, isr, 2, replicas, offlineReplicas));
        partitionStates.put(new TopicPartition("topic20", 1), new UpdateMetadataRequest.PartitionState(1, 0, 1, isr, 2, replicas, offlineReplicas));
        SecurityProtocol plaintext = SecurityProtocol.PLAINTEXT;
        ArrayList<UpdateMetadataRequest.EndPoint> endPoints1 = new ArrayList<UpdateMetadataRequest.EndPoint>();
        endPoints1.add(new UpdateMetadataRequest.EndPoint("host1", 1223, plaintext, ListenerName.forSecurityProtocol((SecurityProtocol)plaintext)));
        ArrayList<UpdateMetadataRequest.EndPoint> endPoints2 = new ArrayList<UpdateMetadataRequest.EndPoint>();
        endPoints2.add(new UpdateMetadataRequest.EndPoint("host1", 1244, plaintext, ListenerName.forSecurityProtocol((SecurityProtocol)plaintext)));
        if (version > 0) {
            SecurityProtocol ssl = SecurityProtocol.SSL;
            endPoints2.add(new UpdateMetadataRequest.EndPoint("host2", 1234, ssl, ListenerName.forSecurityProtocol((SecurityProtocol)ssl)));
            endPoints2.add(new UpdateMetadataRequest.EndPoint("host2", 1334, ssl, new ListenerName("CLIENT")));
        }
        Set liveBrokers = Utils.mkSet((Object[])new UpdateMetadataRequest.Broker[]{new UpdateMetadataRequest.Broker(0, endPoints1, rack), new UpdateMetadataRequest.Broker(1, endPoints2, rack)});
        return (UpdateMetadataRequest)new UpdateMetadataRequest.Builder((short)version, 1, 10, partitionStates, liveBrokers).build();
    }

    private UpdateMetadataResponse createUpdateMetadataResponse() {
        return new UpdateMetadataResponse(Errors.NONE);
    }

    private SaslHandshakeRequest createSaslHandshakeRequest() {
        return new SaslHandshakeRequest("PLAIN");
    }

    private SaslHandshakeResponse createSaslHandshakeResponse() {
        return new SaslHandshakeResponse(Errors.NONE, Collections.singletonList("GSSAPI"));
    }

    private ApiVersionsRequest createApiVersionRequest() {
        return (ApiVersionsRequest)new ApiVersionsRequest.Builder().build();
    }

    private ApiVersionsResponse createApiVersionResponse() {
        List<ApiVersionsResponse.ApiVersion> apiVersions = Arrays.asList(new ApiVersionsResponse.ApiVersion(0, 0, 2));
        return new ApiVersionsResponse(Errors.NONE, apiVersions);
    }

    private CreateTopicsRequest createCreateTopicRequest(int version) {
        return this.createCreateTopicRequest(version, version >= 1);
    }

    private CreateTopicsRequest createCreateTopicRequest(int version, boolean validateOnly) {
        CreateTopicsRequest.TopicDetails request1 = new CreateTopicsRequest.TopicDetails(3, 5);
        HashMap<Integer, List<Integer>> replicaAssignments = new HashMap<Integer, List<Integer>>();
        replicaAssignments.put(1, Arrays.asList(1, 2, 3));
        replicaAssignments.put(2, Arrays.asList(2, 3, 4));
        HashMap<String, String> configs = new HashMap<String, String>();
        configs.put("config1", "value1");
        CreateTopicsRequest.TopicDetails request2 = new CreateTopicsRequest.TopicDetails(replicaAssignments, configs);
        HashMap<String, CreateTopicsRequest.TopicDetails> request = new HashMap<String, CreateTopicsRequest.TopicDetails>();
        request.put("my_t1", request1);
        request.put("my_t2", request2);
        return new CreateTopicsRequest.Builder(request, 0, validateOnly).build((short)version);
    }

    private CreateTopicsResponse createCreateTopicResponse() {
        HashMap<String, ApiError> errors = new HashMap<String, ApiError>();
        errors.put("t1", new ApiError(Errors.INVALID_TOPIC_EXCEPTION, null));
        errors.put("t2", new ApiError(Errors.LEADER_NOT_AVAILABLE, "Leader with id 5 is not available."));
        return new CreateTopicsResponse(errors);
    }

    private DeleteTopicsRequest createDeleteTopicsRequest() {
        return (DeleteTopicsRequest)new DeleteTopicsRequest.Builder(Utils.mkSet((Object[])new String[]{"my_t1", "my_t2"}), Integer.valueOf(10000)).build();
    }

    private DeleteTopicsResponse createDeleteTopicsResponse() {
        HashMap<String, Errors> errors = new HashMap<String, Errors>();
        errors.put("t1", Errors.INVALID_TOPIC_EXCEPTION);
        errors.put("t2", Errors.TOPIC_AUTHORIZATION_FAILED);
        return new DeleteTopicsResponse(errors);
    }

    private InitProducerIdRequest createInitPidRequest() {
        return (InitProducerIdRequest)new InitProducerIdRequest.Builder(null, 100).build();
    }

    private InitProducerIdResponse createInitPidResponse() {
        return new InitProducerIdResponse(0, Errors.NONE, 3332L, 3);
    }

    private OffsetsForLeaderEpochRequest createLeaderEpochRequest() {
        HashMap<TopicPartition, Integer> epochs = new HashMap<TopicPartition, Integer>();
        epochs.put(new TopicPartition("topic1", 0), 1);
        epochs.put(new TopicPartition("topic1", 1), 1);
        epochs.put(new TopicPartition("topic2", 2), 3);
        return (OffsetsForLeaderEpochRequest)new OffsetsForLeaderEpochRequest.Builder(epochs).build();
    }

    private OffsetsForLeaderEpochResponse createLeaderEpochResponse() {
        HashMap<TopicPartition, EpochEndOffset> epochs = new HashMap<TopicPartition, EpochEndOffset>();
        epochs.put(new TopicPartition("topic1", 0), new EpochEndOffset(Errors.NONE, 0L));
        epochs.put(new TopicPartition("topic1", 1), new EpochEndOffset(Errors.NONE, 1L));
        epochs.put(new TopicPartition("topic2", 2), new EpochEndOffset(Errors.NONE, 2L));
        return new OffsetsForLeaderEpochResponse(epochs);
    }

    private AddPartitionsToTxnRequest createAddPartitionsToTxnRequest() {
        return (AddPartitionsToTxnRequest)new AddPartitionsToTxnRequest.Builder("tid", 21L, 42, Collections.singletonList(new TopicPartition("topic", 73))).build();
    }

    private AddPartitionsToTxnResponse createAddPartitionsToTxnResponse() {
        return new AddPartitionsToTxnResponse(0, Collections.singletonMap(new TopicPartition("t", 0), Errors.NONE));
    }

    private AddOffsetsToTxnRequest createAddOffsetsToTxnRequest() {
        return (AddOffsetsToTxnRequest)new AddOffsetsToTxnRequest.Builder("tid", 21L, 42, "gid").build();
    }

    private AddOffsetsToTxnResponse createAddOffsetsToTxnResponse() {
        return new AddOffsetsToTxnResponse(0, Errors.NONE);
    }

    private EndTxnRequest createEndTxnRequest() {
        return (EndTxnRequest)new EndTxnRequest.Builder("tid", 21L, 42, TransactionResult.COMMIT).build();
    }

    private EndTxnResponse createEndTxnResponse() {
        return new EndTxnResponse(0, Errors.NONE);
    }

    private WriteTxnMarkersRequest createWriteTxnMarkersRequest() {
        return (WriteTxnMarkersRequest)new WriteTxnMarkersRequest.Builder(Collections.singletonList(new WriteTxnMarkersRequest.TxnMarkerEntry(21L, 42, 73, TransactionResult.ABORT, Collections.singletonList(new TopicPartition("topic", 73))))).build();
    }

    private WriteTxnMarkersResponse createWriteTxnMarkersResponse() {
        HashMap<TopicPartition, Errors> errorPerPartitions = new HashMap<TopicPartition, Errors>();
        errorPerPartitions.put(new TopicPartition("topic", 73), Errors.NONE);
        HashMap<Long, HashMap<TopicPartition, Errors>> response = new HashMap<Long, HashMap<TopicPartition, Errors>>();
        response.put(21L, errorPerPartitions);
        return new WriteTxnMarkersResponse(response);
    }

    private TxnOffsetCommitRequest createTxnOffsetCommitRequest() {
        HashMap<TopicPartition, TxnOffsetCommitRequest.CommittedOffset> offsets = new HashMap<TopicPartition, TxnOffsetCommitRequest.CommittedOffset>();
        offsets.put(new TopicPartition("topic", 73), new TxnOffsetCommitRequest.CommittedOffset(100L, null));
        return (TxnOffsetCommitRequest)new TxnOffsetCommitRequest.Builder("transactionalId", "groupId", 21L, 42, offsets).build();
    }

    private TxnOffsetCommitResponse createTxnOffsetCommitResponse() {
        HashMap<TopicPartition, Errors> errorPerPartitions = new HashMap<TopicPartition, Errors>();
        errorPerPartitions.put(new TopicPartition("topic", 73), Errors.NONE);
        return new TxnOffsetCommitResponse(0, errorPerPartitions);
    }

    private DescribeAclsRequest createListAclsRequest() {
        return (DescribeAclsRequest)new DescribeAclsRequest.Builder(new AclBindingFilter(new ResourceFilter(org.apache.kafka.common.resource.ResourceType.TOPIC, "mytopic"), new AccessControlEntryFilter(null, null, AclOperation.ANY, AclPermissionType.ANY))).build();
    }

    private DescribeAclsResponse createDescribeAclsResponse() {
        return new DescribeAclsResponse(0, ApiError.NONE, Collections.singleton(new AclBinding(new org.apache.kafka.common.resource.Resource(org.apache.kafka.common.resource.ResourceType.TOPIC, "mytopic"), new AccessControlEntry("User:ANONYMOUS", "*", AclOperation.WRITE, AclPermissionType.ALLOW))));
    }

    private CreateAclsRequest createCreateAclsRequest() {
        ArrayList<CreateAclsRequest.AclCreation> creations = new ArrayList<CreateAclsRequest.AclCreation>();
        creations.add(new CreateAclsRequest.AclCreation(new AclBinding(new org.apache.kafka.common.resource.Resource(org.apache.kafka.common.resource.ResourceType.TOPIC, "mytopic"), new AccessControlEntry("User:ANONYMOUS", "127.0.0.1", AclOperation.READ, AclPermissionType.ALLOW))));
        creations.add(new CreateAclsRequest.AclCreation(new AclBinding(new org.apache.kafka.common.resource.Resource(org.apache.kafka.common.resource.ResourceType.GROUP, "mygroup"), new AccessControlEntry("User:ANONYMOUS", "*", AclOperation.WRITE, AclPermissionType.DENY))));
        return (CreateAclsRequest)new CreateAclsRequest.Builder(creations).build();
    }

    private CreateAclsResponse createCreateAclsResponse() {
        return new CreateAclsResponse(0, Arrays.asList(new CreateAclsResponse.AclCreationResponse(ApiError.NONE), new CreateAclsResponse.AclCreationResponse(new ApiError(Errors.INVALID_REQUEST, "Foo bar"))));
    }

    private DeleteAclsRequest createDeleteAclsRequest() {
        ArrayList<AclBindingFilter> filters = new ArrayList<AclBindingFilter>();
        filters.add(new AclBindingFilter(new ResourceFilter(org.apache.kafka.common.resource.ResourceType.ANY, null), new AccessControlEntryFilter("User:ANONYMOUS", null, AclOperation.ANY, AclPermissionType.ANY)));
        filters.add(new AclBindingFilter(new ResourceFilter(org.apache.kafka.common.resource.ResourceType.ANY, null), new AccessControlEntryFilter("User:bob", null, AclOperation.ANY, AclPermissionType.ANY)));
        return (DeleteAclsRequest)new DeleteAclsRequest.Builder(filters).build();
    }

    private DeleteAclsResponse createDeleteAclsResponse() {
        ArrayList<DeleteAclsResponse.AclFilterResponse> responses = new ArrayList<DeleteAclsResponse.AclFilterResponse>();
        responses.add(new DeleteAclsResponse.AclFilterResponse((Collection)Utils.mkSet((Object[])new DeleteAclsResponse.AclDeletionResult[]{new DeleteAclsResponse.AclDeletionResult(new AclBinding(new org.apache.kafka.common.resource.Resource(org.apache.kafka.common.resource.ResourceType.TOPIC, "mytopic3"), new AccessControlEntry("User:ANONYMOUS", "*", AclOperation.DESCRIBE, AclPermissionType.ALLOW))), new DeleteAclsResponse.AclDeletionResult(new AclBinding(new org.apache.kafka.common.resource.Resource(org.apache.kafka.common.resource.ResourceType.TOPIC, "mytopic4"), new AccessControlEntry("User:ANONYMOUS", "*", AclOperation.DESCRIBE, AclPermissionType.DENY)))})));
        responses.add(new DeleteAclsResponse.AclFilterResponse(new ApiError(Errors.SECURITY_DISABLED, "No security"), Collections.emptySet()));
        return new DeleteAclsResponse(0, responses);
    }

    private DescribeConfigsRequest createDescribeConfigsRequest(int version) {
        return new DescribeConfigsRequest.Builder(Arrays.asList(new Resource(ResourceType.BROKER, "0"), new Resource(ResourceType.TOPIC, "topic"))).build((short)version);
    }

    private DescribeConfigsRequest createDescribeConfigsRequestWithConfigEntries(int version) {
        HashMap<Resource, List<String>> resources = new HashMap<Resource, List<String>>();
        resources.put(new Resource(ResourceType.BROKER, "0"), Arrays.asList("foo", "bar"));
        resources.put(new Resource(ResourceType.TOPIC, "topic"), null);
        resources.put(new Resource(ResourceType.TOPIC, "topic a"), Collections.emptyList());
        return new DescribeConfigsRequest.Builder(resources).build((short)version);
    }

    private DescribeConfigsResponse createDescribeConfigsResponse() {
        HashMap<Resource, DescribeConfigsResponse.Config> configs = new HashMap<Resource, DescribeConfigsResponse.Config>();
        List synonyms = Collections.emptyList();
        List<DescribeConfigsResponse.ConfigEntry> configEntries = Arrays.asList(new DescribeConfigsResponse.ConfigEntry("config_name", "config_value", DescribeConfigsResponse.ConfigSource.DYNAMIC_BROKER_CONFIG, true, false, synonyms), new DescribeConfigsResponse.ConfigEntry("another_name", "another value", DescribeConfigsResponse.ConfigSource.DEFAULT_CONFIG, false, true, synonyms));
        configs.put(new Resource(ResourceType.BROKER, "0"), new DescribeConfigsResponse.Config(ApiError.NONE, configEntries));
        configs.put(new Resource(ResourceType.TOPIC, "topic"), new DescribeConfigsResponse.Config(ApiError.NONE, Collections.emptyList()));
        return new DescribeConfigsResponse(200, configs);
    }

    private AlterConfigsRequest createAlterConfigsRequest() {
        HashMap<Resource, AlterConfigsRequest.Config> configs = new HashMap<Resource, AlterConfigsRequest.Config>();
        List<AlterConfigsRequest.ConfigEntry> configEntries = Arrays.asList(new AlterConfigsRequest.ConfigEntry("config_name", "config_value"), new AlterConfigsRequest.ConfigEntry("another_name", "another value"));
        configs.put(new Resource(ResourceType.BROKER, "0"), new AlterConfigsRequest.Config(configEntries));
        configs.put(new Resource(ResourceType.TOPIC, "topic"), new AlterConfigsRequest.Config(Collections.emptyList()));
        return new AlterConfigsRequest(0, configs, false);
    }

    private AlterConfigsResponse createAlterConfigsResponse() {
        HashMap<Resource, ApiError> errors = new HashMap<Resource, ApiError>();
        errors.put(new Resource(ResourceType.BROKER, "0"), ApiError.NONE);
        errors.put(new Resource(ResourceType.TOPIC, "topic"), new ApiError(Errors.INVALID_REQUEST, "This request is invalid"));
        return new AlterConfigsResponse(20, errors);
    }

    private CreatePartitionsRequest createCreatePartitionsRequest() {
        HashMap<String, NewPartitions> assignments = new HashMap<String, NewPartitions>();
        assignments.put("my_topic", NewPartitions.increaseTo((int)3));
        assignments.put("my_other_topic", NewPartitions.increaseTo((int)3));
        return new CreatePartitionsRequest(assignments, 0, false, 0);
    }

    private CreatePartitionsRequest createCreatePartitionsRequestWithAssignments() {
        HashMap<String, NewPartitions> assignments = new HashMap<String, NewPartitions>();
        assignments.put("my_topic", NewPartitions.increaseTo((int)3, Arrays.asList(Arrays.asList(2))));
        assignments.put("my_other_topic", NewPartitions.increaseTo((int)3, Arrays.asList(Arrays.asList(2, 3), Arrays.asList(3, 1))));
        return new CreatePartitionsRequest(assignments, 0, false, 0);
    }

    private CreatePartitionsResponse createCreatePartitionsResponse() {
        HashMap<String, ApiError> results = new HashMap<String, ApiError>();
        results.put("my_topic", ApiError.fromThrowable((Throwable)new InvalidReplicaAssignmentException("The assigned brokers included an unknown broker")));
        results.put("my_topic", ApiError.NONE);
        return new CreatePartitionsResponse(42, results);
    }

    private CreateDelegationTokenRequest createCreateTokenRequest() {
        ArrayList<KafkaPrincipal> renewers = new ArrayList<KafkaPrincipal>();
        renewers.add(SecurityUtils.parseKafkaPrincipal((String)"User:user1"));
        renewers.add(SecurityUtils.parseKafkaPrincipal((String)"User:user2"));
        return (CreateDelegationTokenRequest)new CreateDelegationTokenRequest.Builder(renewers, System.currentTimeMillis()).build();
    }

    private CreateDelegationTokenResponse createCreateTokenResponse() {
        return new CreateDelegationTokenResponse(20, Errors.NONE, SecurityUtils.parseKafkaPrincipal((String)"User:user1"), System.currentTimeMillis(), System.currentTimeMillis(), System.currentTimeMillis(), "token1", ByteBuffer.wrap("test".getBytes()));
    }

    private RenewDelegationTokenRequest createRenewTokenRequest() {
        return (RenewDelegationTokenRequest)new RenewDelegationTokenRequest.Builder(ByteBuffer.wrap("test".getBytes()), System.currentTimeMillis()).build();
    }

    private RenewDelegationTokenResponse createRenewTokenResponse() {
        return new RenewDelegationTokenResponse(20, Errors.NONE, System.currentTimeMillis());
    }

    private ExpireDelegationTokenRequest createExpireTokenRequest() {
        return (ExpireDelegationTokenRequest)new ExpireDelegationTokenRequest.Builder(ByteBuffer.wrap("test".getBytes()), System.currentTimeMillis()).build();
    }

    private ExpireDelegationTokenResponse createExpireTokenResponse() {
        return new ExpireDelegationTokenResponse(20, Errors.NONE, System.currentTimeMillis());
    }

    private DescribeDelegationTokenRequest createDescribeTokenRequest() {
        ArrayList<KafkaPrincipal> owners = new ArrayList<KafkaPrincipal>();
        owners.add(SecurityUtils.parseKafkaPrincipal((String)"User:user1"));
        owners.add(SecurityUtils.parseKafkaPrincipal((String)"User:user2"));
        return (DescribeDelegationTokenRequest)new DescribeDelegationTokenRequest.Builder(owners).build();
    }

    private DescribeDelegationTokenResponse createDescribeTokenResponse() {
        ArrayList<KafkaPrincipal> renewers = new ArrayList<KafkaPrincipal>();
        renewers.add(SecurityUtils.parseKafkaPrincipal((String)"User:user1"));
        renewers.add(SecurityUtils.parseKafkaPrincipal((String)"User:user2"));
        LinkedList<DelegationToken> tokenList = new LinkedList<DelegationToken>();
        TokenInformation tokenInfo1 = new TokenInformation("1", SecurityUtils.parseKafkaPrincipal((String)"User:owner"), renewers, System.currentTimeMillis(), System.currentTimeMillis(), System.currentTimeMillis());
        TokenInformation tokenInfo2 = new TokenInformation("2", SecurityUtils.parseKafkaPrincipal((String)"User:owner1"), renewers, System.currentTimeMillis(), System.currentTimeMillis(), System.currentTimeMillis());
        tokenList.add(new DelegationToken(tokenInfo1, "test".getBytes()));
        tokenList.add(new DelegationToken(tokenInfo2, "test".getBytes()));
        return new DescribeDelegationTokenResponse(20, Errors.NONE, tokenList);
    }
}

