/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.security.scram;

import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import org.apache.kafka.common.security.authenticator.CredentialCache;
import org.apache.kafka.common.security.scram.ScramCredential;
import org.apache.kafka.common.security.scram.ScramCredentialUtils;
import org.apache.kafka.common.security.scram.ScramFormatter;
import org.apache.kafka.common.security.scram.ScramMechanism;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ScramCredentialUtilsTest {
    private ScramFormatter formatter;

    @Before
    public void setUp() throws NoSuchAlgorithmException {
        this.formatter = new ScramFormatter(ScramMechanism.SCRAM_SHA_256);
    }

    @Test
    public void stringConversion() {
        ScramCredential credential = this.formatter.generateCredential("password", 1024);
        Assert.assertTrue((String)"Salt must not be empty", (credential.salt().length > 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"Stored key must not be empty", (credential.storedKey().length > 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"Server key must not be empty", (credential.serverKey().length > 0 ? 1 : 0) != 0);
        ScramCredential credential2 = ScramCredentialUtils.credentialFromString((String)ScramCredentialUtils.credentialToString((ScramCredential)credential));
        Assert.assertArrayEquals((byte[])credential.salt(), (byte[])credential2.salt());
        Assert.assertArrayEquals((byte[])credential.storedKey(), (byte[])credential2.storedKey());
        Assert.assertArrayEquals((byte[])credential.serverKey(), (byte[])credential2.serverKey());
        Assert.assertEquals((long)credential.iterations(), (long)credential2.iterations());
    }

    @Test
    public void generateCredential() {
        ScramCredential credential1 = this.formatter.generateCredential("password", 4096);
        ScramCredential credential2 = this.formatter.generateCredential("password", 4096);
        Assert.assertNotEquals((Object)ScramCredentialUtils.credentialToString((ScramCredential)credential1), (Object)ScramCredentialUtils.credentialToString((ScramCredential)credential2));
    }

    @Test(expected=IllegalArgumentException.class)
    public void invalidCredential() {
        ScramCredentialUtils.credentialFromString((String)"abc");
    }

    @Test(expected=IllegalArgumentException.class)
    public void missingFields() {
        String cred = ScramCredentialUtils.credentialToString((ScramCredential)this.formatter.generateCredential("password", 2048));
        ScramCredentialUtils.credentialFromString((String)cred.substring(cred.indexOf(44)));
    }

    @Test(expected=IllegalArgumentException.class)
    public void extraneousFields() {
        String cred = ScramCredentialUtils.credentialToString((ScramCredential)this.formatter.generateCredential("password", 2048));
        ScramCredentialUtils.credentialFromString((String)(cred + ",a=test"));
    }

    @Test
    public void scramCredentialCache() throws Exception {
        CredentialCache cache = new CredentialCache();
        ScramCredentialUtils.createCache((CredentialCache)cache, Arrays.asList("SCRAM-SHA-512", "PLAIN"));
        Assert.assertNotNull((String)"Cache not created for enabled mechanism", (Object)cache.cache(ScramMechanism.SCRAM_SHA_512.mechanismName(), ScramCredential.class));
        Assert.assertNull((String)"Cache created for disabled mechanism", (Object)cache.cache(ScramMechanism.SCRAM_SHA_256.mechanismName(), ScramCredential.class));
        CredentialCache.Cache sha512Cache = cache.cache(ScramMechanism.SCRAM_SHA_512.mechanismName(), ScramCredential.class);
        ScramFormatter formatter = new ScramFormatter(ScramMechanism.SCRAM_SHA_512);
        ScramCredential credentialA = formatter.generateCredential("password", 4096);
        sha512Cache.put("userA", (Object)credentialA);
        Assert.assertEquals((Object)credentialA, (Object)sha512Cache.get("userA"));
        Assert.assertNull((String)"Invalid user credential", (Object)sha512Cache.get("userB"));
    }
}

