/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.utils;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Random;
import org.apache.kafka.common.utils.ImplicitLinkedHashSet;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.Timeout;

public class ImplicitLinkedHashSetTest {
    @Rule
    public final Timeout globalTimeout = Timeout.millis((long)120000L);

    @Test
    public void testInsertDelete() throws Exception {
        ImplicitLinkedHashSet set = new ImplicitLinkedHashSet(100);
        Assert.assertTrue((boolean)set.add((ImplicitLinkedHashSet.Element)new TestElement(1)));
        TestElement second = new TestElement(2);
        Assert.assertTrue((boolean)set.add((ImplicitLinkedHashSet.Element)second));
        Assert.assertTrue((boolean)set.add((ImplicitLinkedHashSet.Element)new TestElement(3)));
        Assert.assertFalse((boolean)set.add((ImplicitLinkedHashSet.Element)new TestElement(3)));
        Assert.assertEquals((long)3L, (long)set.size());
        Assert.assertTrue((boolean)set.contains((Object)new TestElement(1)));
        Assert.assertFalse((boolean)set.contains((Object)new TestElement(4)));
        TestElement secondAgain = (TestElement)set.find((ImplicitLinkedHashSet.Element)new TestElement(2));
        Assert.assertTrue((second == secondAgain ? 1 : 0) != 0);
        Assert.assertTrue((boolean)set.remove((Object)new TestElement(1)));
        Assert.assertFalse((boolean)set.remove((Object)new TestElement(1)));
        Assert.assertEquals((long)2L, (long)set.size());
        set.clear();
        Assert.assertEquals((long)0L, (long)set.size());
    }

    private static void expectTraversal(Iterator<TestElement> iterator, Integer ... sequence) {
        int i = 0;
        while (iterator.hasNext()) {
            TestElement element = iterator.next();
            Assert.assertTrue((String)("Iterator yieled " + (i + 1) + " elements, but only " + sequence.length + " were expected."), (i < sequence.length ? 1 : 0) != 0);
            Assert.assertEquals((String)("Iterator value number " + (i + 1) + " was incorrect."), (long)sequence[i].intValue(), (long)element.val);
            ++i;
        }
        Assert.assertTrue((String)("Iterator yieled " + (i + 1) + " elements, but " + sequence.length + " were expected."), (i == sequence.length ? 1 : 0) != 0);
    }

    private static void expectTraversal(Iterator<TestElement> iter, Iterator<Integer> expectedIter) {
        int i = 0;
        while (iter.hasNext()) {
            TestElement element = iter.next();
            Assert.assertTrue((String)("Iterator yieled " + (i + 1) + " elements, but only " + i + " were expected."), (boolean)expectedIter.hasNext());
            Integer expected = expectedIter.next();
            Assert.assertEquals((String)("Iterator value number " + (i + 1) + " was incorrect."), (long)expected.intValue(), (long)element.val);
            ++i;
        }
        Assert.assertFalse((String)("Iterator yieled " + i + " elements, but at least " + (i + 1) + " were expected."), (boolean)expectedIter.hasNext());
    }

    @Test
    public void testTraversal() throws Exception {
        ImplicitLinkedHashSet set = new ImplicitLinkedHashSet(100);
        ImplicitLinkedHashSetTest.expectTraversal((Iterator<TestElement>)set.iterator(), new Integer[0]);
        Assert.assertTrue((boolean)set.add((ImplicitLinkedHashSet.Element)new TestElement(2)));
        ImplicitLinkedHashSetTest.expectTraversal((Iterator<TestElement>)set.iterator(), 2);
        Assert.assertTrue((boolean)set.add((ImplicitLinkedHashSet.Element)new TestElement(1)));
        ImplicitLinkedHashSetTest.expectTraversal((Iterator<TestElement>)set.iterator(), 2, 1);
        Assert.assertTrue((boolean)set.add((ImplicitLinkedHashSet.Element)new TestElement(100)));
        ImplicitLinkedHashSetTest.expectTraversal((Iterator<TestElement>)set.iterator(), 2, 1, 100);
        Assert.assertTrue((boolean)set.remove((Object)new TestElement(1)));
        ImplicitLinkedHashSetTest.expectTraversal((Iterator<TestElement>)set.iterator(), 2, 100);
        Assert.assertTrue((boolean)set.add((ImplicitLinkedHashSet.Element)new TestElement(1)));
        ImplicitLinkedHashSetTest.expectTraversal((Iterator<TestElement>)set.iterator(), 2, 100, 1);
        Iterator iter = set.iterator();
        iter.next();
        iter.next();
        iter.remove();
        iter.next();
        Assert.assertFalse((boolean)iter.hasNext());
        ImplicitLinkedHashSetTest.expectTraversal((Iterator<TestElement>)set.iterator(), 2, 1);
        ArrayList<TestElement> list = new ArrayList<TestElement>();
        list.add(new TestElement(1));
        list.add(new TestElement(2));
        Assert.assertTrue((boolean)set.removeAll(list));
        Assert.assertFalse((boolean)set.removeAll(list));
        ImplicitLinkedHashSetTest.expectTraversal((Iterator<TestElement>)set.iterator(), new Integer[0]);
        Assert.assertEquals((long)0L, (long)set.size());
        Assert.assertTrue((boolean)set.isEmpty());
    }

    @Test
    public void testCollisions() throws Exception {
        ImplicitLinkedHashSet set = new ImplicitLinkedHashSet(5);
        Assert.assertEquals((long)11L, (long)set.numSlots());
        Assert.assertTrue((boolean)set.add((ImplicitLinkedHashSet.Element)new TestElement(11)));
        Assert.assertTrue((boolean)set.add((ImplicitLinkedHashSet.Element)new TestElement(0)));
        Assert.assertTrue((boolean)set.add((ImplicitLinkedHashSet.Element)new TestElement(22)));
        Assert.assertTrue((boolean)set.add((ImplicitLinkedHashSet.Element)new TestElement(33)));
        Assert.assertEquals((long)11L, (long)set.numSlots());
        ImplicitLinkedHashSetTest.expectTraversal((Iterator<TestElement>)set.iterator(), 11, 0, 22, 33);
        Assert.assertTrue((boolean)set.remove((Object)new TestElement(22)));
        ImplicitLinkedHashSetTest.expectTraversal((Iterator<TestElement>)set.iterator(), 11, 0, 33);
        Assert.assertEquals((long)3L, (long)set.size());
        Assert.assertFalse((boolean)set.isEmpty());
    }

    @Test
    public void testEnlargement() throws Exception {
        int i;
        ImplicitLinkedHashSet set = new ImplicitLinkedHashSet(5);
        Assert.assertEquals((long)11L, (long)set.numSlots());
        for (i = 0; i < 6; ++i) {
            Assert.assertTrue((boolean)set.add((ImplicitLinkedHashSet.Element)new TestElement(i)));
        }
        Assert.assertEquals((long)23L, (long)set.numSlots());
        Assert.assertEquals((long)6L, (long)set.size());
        ImplicitLinkedHashSetTest.expectTraversal((Iterator<TestElement>)set.iterator(), 0, 1, 2, 3, 4, 5);
        for (i = 0; i < 6; ++i) {
            Assert.assertTrue((String)("Failed to find element " + i), (boolean)set.contains((Object)new TestElement(i)));
        }
        set.remove((Object)new TestElement(3));
        Assert.assertEquals((long)23L, (long)set.numSlots());
        Assert.assertEquals((long)5L, (long)set.size());
        ImplicitLinkedHashSetTest.expectTraversal((Iterator<TestElement>)set.iterator(), 0, 1, 2, 4, 5);
    }

    @Test
    public void testManyInsertsAndDeletes() throws Exception {
        Random random = new Random(123L);
        LinkedHashSet<Integer> existing = new LinkedHashSet<Integer>();
        ImplicitLinkedHashSet set = new ImplicitLinkedHashSet();
        for (int i = 0; i < 100; ++i) {
            this.addRandomElement(random, existing, (ImplicitLinkedHashSet<TestElement>)set);
            this.addRandomElement(random, existing, (ImplicitLinkedHashSet<TestElement>)set);
            this.addRandomElement(random, existing, (ImplicitLinkedHashSet<TestElement>)set);
            this.removeRandomElement(random, existing, (ImplicitLinkedHashSet<TestElement>)set);
            ImplicitLinkedHashSetTest.expectTraversal((Iterator<TestElement>)set.iterator(), existing.iterator());
        }
    }

    private void addRandomElement(Random random, LinkedHashSet<Integer> existing, ImplicitLinkedHashSet<TestElement> set) {
        int next;
        while (existing.contains(next = random.nextInt())) {
        }
        existing.add(next);
        set.add((ImplicitLinkedHashSet.Element)new TestElement(next));
    }

    private void removeRandomElement(Random random, LinkedHashSet<Integer> existing, ImplicitLinkedHashSet<TestElement> set) {
        int removeIdx = random.nextInt(existing.size());
        Iterator iter = existing.iterator();
        Integer element = null;
        for (int i = 0; i <= removeIdx; ++i) {
            element = (Integer)iter.next();
        }
        existing.remove(new TestElement(element));
    }

    private static final class TestElement
    implements ImplicitLinkedHashSet.Element {
        private int prev = -2;
        private int next = -2;
        private final int val;

        TestElement(int val) {
            this.val = val;
        }

        public int prev() {
            return this.prev;
        }

        public void setPrev(int prev) {
            this.prev = prev;
        }

        public int next() {
            return this.next;
        }

        public void setNext(int next) {
            this.next = next;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || o.getClass() != TestElement.class) {
                return false;
            }
            TestElement that = (TestElement)o;
            return this.val == that.val;
        }

        public String toString() {
            return "TestElement(" + this.val + ")";
        }

        public int hashCode() {
            return this.val;
        }
    }
}

