/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.storage.internals.log;

import org.apache.kafka.storage.internals.log.IndexEntry;

public class TimestampOffset
implements IndexEntry {
    public static final TimestampOffset UNKNOWN = new TimestampOffset(-1L, -1L);
    public final long timestamp;
    public final long offset;

    public TimestampOffset(long timestamp, long offset) {
        this.timestamp = timestamp;
        this.offset = offset;
    }

    @Override
    public long indexKey() {
        return this.timestamp;
    }

    @Override
    public long indexValue() {
        return this.offset;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TimestampOffset that = (TimestampOffset)o;
        return this.timestamp == that.timestamp && this.offset == that.offset;
    }

    public int hashCode() {
        int result = Long.hashCode(this.timestamp);
        result = 31 * result + Long.hashCode(this.offset);
        return result;
    }

    public String toString() {
        return String.format("TimestampOffset(offset = %d, timestamp = %d)", this.offset, this.timestamp);
    }
}

