/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import java.io.DataOutputStream;
import java.io.File;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Date;
import kafka.common.LogCleaningAbortedException;
import kafka.common.TopicAndPartition;
import kafka.log.Cleaner$;
import kafka.log.CleanerStats;
import kafka.log.FileMessageSet;
import kafka.log.Log;
import kafka.log.Log$;
import kafka.log.LogCleaner;
import kafka.log.LogSegment;
import kafka.log.LogToClean;
import kafka.log.OffsetIndex;
import kafka.log.OffsetMap;
import kafka.log.TimeIndex;
import kafka.message.ByteBufferMessageSet;
import kafka.message.ByteBufferMessageSet$;
import kafka.message.CompressionCodec;
import kafka.message.CompressionFactory$;
import kafka.message.MagicAndTimestamp;
import kafka.message.Message;
import kafka.message.Message$;
import kafka.message.MessageAndOffset;
import kafka.message.MessageSet$;
import kafka.message.MessageWriter;
import kafka.message.NoCompressionCodec$;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.Logging$class;
import kafka.utils.Throttler;
import kafka.utils.Time;
import org.apache.kafka.common.record.TimestampType;
import org.apache.log4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.StringBuilder;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LongRef;
import scala.runtime.NonLocalReturnControl;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@ScalaSignature(bytes="\u0006\u0001\t\u0015a!B\u0001\u0003\u0001\t1!aB\"mK\u0006tWM\u001d\u0006\u0003\u0007\u0011\t1\u0001\\8h\u0015\u0005)\u0011!B6bM.\f7c\u0001\u0001\b\u001bA\u0011\u0001bC\u0007\u0002\u0013)\t!\"A\u0003tG\u0006d\u0017-\u0003\u0002\r\u0013\t1\u0011I\\=SK\u001a\u0004\"AD\t\u000e\u0003=Q!\u0001\u0005\u0003\u0002\u000bU$\u0018\u000e\\:\n\u0005Iy!a\u0002'pO\u001eLgn\u001a\u0005\t)\u0001\u0011)\u0019!C\u0001-\u0005\u0011\u0011\u000eZ\u0002\u0001+\u00059\u0002C\u0001\u0005\u0019\u0013\tI\u0012BA\u0002J]RD\u0001b\u0007\u0001\u0003\u0002\u0003\u0006IaF\u0001\u0004S\u0012\u0004\u0003\u0002C\u000f\u0001\u0005\u000b\u0007I\u0011\u0001\u0010\u0002\u0013=4gm]3u\u001b\u0006\u0004X#A\u0010\u0011\u0005\u0001\nS\"\u0001\u0002\n\u0005\t\u0012!!C(gMN,G/T1q\u0011!!\u0003A!A!\u0002\u0013y\u0012AC8gMN,G/T1qA!Aa\u0005\u0001B\u0001B\u0003%q#\u0001\u0007j_\n+hMZ3s'&TX\r\u0003\u0005)\u0001\t\u0005\t\u0015!\u0003\u0018\u0003=i\u0017\r_%p\u0005V4g-\u001a:TSj,\u0007\u0002\u0003\u0016\u0001\u0005\u0003\u0005\u000b\u0011B\u0016\u0002'\u0011,\bOQ;gM\u0016\u0014Hj\\1e\r\u0006\u001cGo\u001c:\u0011\u0005!a\u0013BA\u0017\n\u0005\u0019!u.\u001e2mK\"Aq\u0006\u0001B\u0001B\u0003%\u0001'A\u0005uQJ|G\u000f\u001e7feB\u0011a\"M\u0005\u0003e=\u0011\u0011\u0002\u00165s_R$H.\u001a:\t\u0011Q\u0002!\u0011!Q\u0001\nU\nA\u0001^5nKB\u0011aBN\u0005\u0003o=\u0011A\u0001V5nK\"A\u0011\b\u0001B\u0001B\u0003%!(A\u0005dQ\u0016\u001c7\u000eR8oKB!\u0001bO\u001fD\u0013\ta\u0014BA\u0005Gk:\u001cG/[8ocA\u0011a(Q\u0007\u0002\u007f)\u0011\u0001\tB\u0001\u0007G>lWn\u001c8\n\u0005\t{$!\u0005+pa&\u001c\u0017I\u001c3QCJ$\u0018\u000e^5p]B\u0011\u0001\u0002R\u0005\u0003\u000b&\u0011A!\u00168ji\")q\t\u0001C\u0001\u0011\u00061A(\u001b8jiz\"\u0012\"\u0013&L\u00196su\nU)\u0011\u0005\u0001\u0002\u0001\"\u0002\u000bG\u0001\u00049\u0002\"B\u000fG\u0001\u0004y\u0002\"\u0002\u0014G\u0001\u00049\u0002\"\u0002\u0015G\u0001\u00049\u0002\"\u0002\u0016G\u0001\u0004Y\u0003\"B\u0018G\u0001\u0004\u0001\u0004\"\u0002\u001bG\u0001\u0004)\u0004\"B\u001dG\u0001\u0004Q\u0004bB*\u0001\u0005\u0004%\t\u0005V\u0001\u000bY><w-\u001a:OC6,W#A+\u0011\u0005Y[V\"A,\u000b\u0005aK\u0016\u0001\u00027b]\u001eT\u0011AW\u0001\u0005U\u00064\u0018-\u0003\u0002]/\n11\u000b\u001e:j]\u001eDaA\u0018\u0001!\u0002\u0013)\u0016a\u00037pO\u001e,'OT1nK\u0002Bq\u0001\u0019\u0001C\u0002\u0013\u0005\u0011-A\bti\u0006$8/\u00168eKJd\u00170\u001b8h+\u0005\u0011\u0007\u0003\u0002\u0005dK\u0016L!\u0001Z\u0005\u0003\rQ+\b\u000f\\33!\t\u0001c-\u0003\u0002h\u0005\ta1\t\\3b]\u0016\u00148\u000b^1ug\"1\u0011\u000e\u0001Q\u0001\n\t\f\u0001c\u001d;biN,f\u000eZ3sYfLgn\u001a\u0011\t\u000b-\u0004A\u0011\u00017\u0002\u000bM$\u0018\r^:\u0016\u0003\u0015DqA\u001c\u0001A\u0002\u0013%q.\u0001\u0006sK\u0006$')\u001e4gKJ,\u0012\u0001\u001d\t\u0003cRl\u0011A\u001d\u0006\u0003gf\u000b1A\\5p\u0013\t)(O\u0001\u0006CsR,')\u001e4gKJDqa\u001e\u0001A\u0002\u0013%\u00010\u0001\bsK\u0006$')\u001e4gKJ|F%Z9\u0015\u0005\rK\bb\u0002>w\u0003\u0003\u0005\r\u0001]\u0001\u0004q\u0012\n\u0004B\u0002?\u0001A\u0003&\u0001/A\u0006sK\u0006$')\u001e4gKJ\u0004\u0003b\u0002@\u0001\u0001\u0004%Ia\\\u0001\foJLG/\u001a\"vM\u001a,'\u000fC\u0005\u0002\u0002\u0001\u0001\r\u0011\"\u0003\u0002\u0004\u0005yqO]5uK\n+hMZ3s?\u0012*\u0017\u000fF\u0002D\u0003\u000bAqA_@\u0002\u0002\u0003\u0007\u0001\u000fC\u0004\u0002\n\u0001\u0001\u000b\u0015\u00029\u0002\u0019]\u0014\u0018\u000e^3Ck\u001a4WM\u001d\u0011\t\u0011\u00055\u0001\u0001\"\u0001\u0003\u0003\u001f\tQa\u00197fC:$B!!\u0005\u0002\u0018A\u0019\u0001\"a\u0005\n\u0007\u0005U\u0011B\u0001\u0003M_:<\u0007\u0002CA\r\u0003\u0017\u0001\r!a\u0007\u0002\u0013\rdW-\u00198bE2,\u0007c\u0001\u0011\u0002\u001e%\u0019\u0011q\u0004\u0002\u0003\u00151{w\rV8DY\u0016\fg\u000e\u0003\u0005\u0002$\u0001!\tAAA\u0013\u00035\u0019G.Z1o'\u0016<W.\u001a8ugRI1)a\n\u00020\u0005\u0015\u0013\u0011\n\u0005\b\u0007\u0005\u0005\u0002\u0019AA\u0015!\r\u0001\u00131F\u0005\u0004\u0003[\u0011!a\u0001'pO\"A\u0011\u0011GA\u0011\u0001\u0004\t\u0019$\u0001\u0005tK\u001elWM\u001c;t!\u0019\t)$a\u000f\u0002@5\u0011\u0011q\u0007\u0006\u0004\u0003sI\u0011AC2pY2,7\r^5p]&!\u0011QHA\u001c\u0005\r\u0019V-\u001d\t\u0004A\u0005\u0005\u0013bAA\"\u0005\tQAj\\4TK\u001elWM\u001c;\t\u000f\u0005\u001d\u0013\u0011\u0005a\u0001?\u0005\u0019Q.\u00199\t\u0011\u0005-\u0013\u0011\u0005a\u0001\u0003#\tq\u0002Z3mKR,\u0007j\u001c:ju>tWj\u001d\u0005\t\u0003\u001f\u0002A\u0011\u0001\u0002\u0002R\u0005I1\r\\3b]&sGo\u001c\u000b\u000e\u0007\u0006M\u0013qKA.\u0003?\n\t'a\u001b\t\u000f\u0005U\u0013Q\na\u0001{\u0005\tBo\u001c9jG\u0006sG\rU1si&$\u0018n\u001c8\t\u0011\u0005e\u0013Q\na\u0001\u0003\u007f\taa]8ve\u000e,\u0007\u0002CA/\u0003\u001b\u0002\r!a\u0010\u0002\t\u0011,7\u000f\u001e\u0005\b\u0003\u000f\ni\u00051\u0001 \u0011!\t\u0019'!\u0014A\u0002\u0005\u0015\u0014!\u0004:fi\u0006Lg\u000eR3mKR,7\u000fE\u0002\t\u0003OJ1!!\u001b\n\u0005\u001d\u0011un\u001c7fC:Dq!!\u001c\u0002N\u0001\u0007q#A\tnCbdunZ'fgN\fw-Z*ju\u0016Dq!!\u001d\u0001\t\u0013\t\u0019(\u0001\td_6\u0004(/Z:t\u001b\u0016\u001c8/Y4fgR91)!\u001e\u0002z\u0005%\u0005bBA<\u0003_\u0002\r\u0001]\u0001\u0007EV4g-\u001a:\t\u0011\u0005m\u0014q\u000ea\u0001\u0003{\n\u0001cY8naJ,7o]5p]\u000e{G-Z2\u0011\t\u0005}\u0014QQ\u0007\u0003\u0003\u0003S1!a!\u0005\u0003\u001diWm]:bO\u0016LA!a\"\u0002\u0002\n\u00012i\\7qe\u0016\u001c8/[8o\u0007>$Wm\u0019\u0005\t\u0003\u0017\u000by\u00071\u0001\u0002\u000e\u0006\tR.Z:tC\u001e,\u0017I\u001c3PM\u001a\u001cX\r^:\u0011\r\u0005U\u00121HAH!\u0011\ty(!%\n\t\u0005M\u0015\u0011\u0011\u0002\u0011\u001b\u0016\u001c8/Y4f\u0003:$wJ\u001a4tKRDq!a&\u0001\t\u0013\tI*A\ntQ>,H\u000e\u001a*fi\u0006Lg.T3tg\u0006<W\r\u0006\u0006\u0002f\u0005m\u0015QTAP\u0003CC\u0001\"!\u0017\u0002\u0016\u0002\u0007\u0011q\b\u0005\b\u0003\u000f\n)\n1\u0001 \u0011!\t\u0019'!&A\u0002\u0005\u0015\u0004\u0002CAR\u0003+\u0003\r!a$\u0002\u000b\u0015tGO]=\t\u000f\u0005\u001d\u0006\u0001\"\u0001\u0002*\u0006YqM]8x\u0005V4g-\u001a:t)\r\u0019\u00151\u0016\u0005\b\u0003[\n)\u000b1\u0001\u0018\u0011\u001d\ty\u000b\u0001C\u0001\u0003c\u000baB]3ti>\u0014XMQ;gM\u0016\u00148\u000fF\u0001D\u0011!\t)\f\u0001C\u0001\u0005\u0005]\u0016aE4s_V\u00048+Z4nK:$8OQ=TSj,G\u0003CA]\u0003#\fI.!8\u0011\r\u0005m\u00161ZA\u001a\u001d\u0011\ti,a2\u000f\t\u0005}\u0016QY\u0007\u0003\u0003\u0003T1!a1\u0016\u0003\u0019a$o\\8u}%\t!\"C\u0002\u0002J&\tq\u0001]1dW\u0006<W-\u0003\u0003\u0002N\u0006='\u0001\u0002'jgRT1!!3\n\u0011!\t\t$a-A\u0002\u0005M\u0007CBA^\u0003+\fy$\u0003\u0003\u0002X\u0006='\u0001C%uKJ\f'\r\\3\t\u000f\u0005m\u00171\u0017a\u0001/\u00059Q.\u0019=TSj,\u0007bBAp\u0003g\u0003\raF\u0001\r[\u0006D\u0018J\u001c3fqNK'0\u001a\u0005\t\u0003G\u0004A\u0011\u0001\u0002\u0002f\u0006q!-^5mI>3gm]3u\u001b\u0006\u0004H#C\"\u0002h\u0006%\u0018Q^Ay\u0011\u001d\u0019\u0011\u0011\u001da\u0001\u0003SA\u0001\"a;\u0002b\u0002\u0007\u0011\u0011C\u0001\u0006gR\f'\u000f\u001e\u0005\t\u0003_\f\t\u000f1\u0001\u0002\u0012\u0005\u0019QM\u001c3\t\u000f\u0005\u001d\u0013\u0011\u001da\u0001?!9\u0011Q\u001f\u0001\u0005\n\u0005]\u0018\u0001\u00072vS2$wJ\u001a4tKRl\u0015\r\u001d$peN+w-\\3oiRa\u0011QMA}\u0003w\fyP!\u0001\u0003\u0004!9\u0011QKAz\u0001\u0004i\u0004\u0002CA\u007f\u0003g\u0004\r!a\u0010\u0002\u000fM,w-\\3oi\"9\u0011qIAz\u0001\u0004y\u0002\u0002CAv\u0003g\u0004\r!!\u0005\t\u000f\u00055\u00141\u001fa\u0001/\u0001")
public class Cleaner
implements Logging {
    private final int id;
    private final OffsetMap offsetMap;
    private final int ioBufferSize;
    private final int maxIoBufferSize;
    private final double dupBufferLoadFactor;
    private final Throttler throttler;
    private final Time time;
    public final Function1<TopicAndPartition, BoxedUnit> kafka$log$Cleaner$$checkDone;
    private final String loggerName;
    private final Tuple2<CleanerStats, CleanerStats> statsUnderlying;
    private ByteBuffer kafka$log$Cleaner$$readBuffer;
    private ByteBuffer kafka$log$Cleaner$$writeBuffer;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    private volatile boolean bitmap$0;

    private Logger logger$lzycompute() {
        Cleaner cleaner = this;
        synchronized (cleaner) {
            if (!this.bitmap$0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    @Override
    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    @Override
    public Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    @Override
    public void kafka$utils$Logging$_setter_$loggerName_$eq(String x$1) {
    }

    @Override
    public void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ x$1) {
        this.kafka$utils$Logging$$log4jController = x$1;
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging$class.trace(this, msg);
    }

    @Override
    public Object trace(Function0<Throwable> e) {
        return Logging$class.trace(this, e);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.trace(this, msg, e);
    }

    @Override
    public void swallowTrace(Function0<BoxedUnit> action) {
        Logging$class.swallowTrace(this, action);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging$class.isDebugEnabled(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging$class.debug(this, msg);
    }

    @Override
    public Object debug(Function0<Throwable> e) {
        return Logging$class.debug(this, e);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.debug(this, msg, e);
    }

    @Override
    public void swallowDebug(Function0<BoxedUnit> action) {
        Logging$class.swallowDebug(this, action);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging$class.info(this, msg);
    }

    @Override
    public Object info(Function0<Throwable> e) {
        return Logging$class.info(this, e);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.info(this, msg, e);
    }

    @Override
    public void swallowInfo(Function0<BoxedUnit> action) {
        Logging$class.swallowInfo(this, action);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging$class.warn(this, msg);
    }

    @Override
    public Object warn(Function0<Throwable> e) {
        return Logging$class.warn(this, e);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.warn(this, msg, e);
    }

    @Override
    public void swallowWarn(Function0<BoxedUnit> action) {
        Logging$class.swallowWarn(this, action);
    }

    @Override
    public void swallow(Function0<BoxedUnit> action) {
        Logging$class.swallow(this, action);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging$class.error(this, msg);
    }

    @Override
    public Object error(Function0<Throwable> e) {
        return Logging$class.error(this, e);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.error(this, msg, e);
    }

    @Override
    public void swallowError(Function0<BoxedUnit> action) {
        Logging$class.swallowError(this, action);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging$class.fatal(this, msg);
    }

    @Override
    public Object fatal(Function0<Throwable> e) {
        return Logging$class.fatal(this, e);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.fatal(this, msg, e);
    }

    public int id() {
        return this.id;
    }

    public OffsetMap offsetMap() {
        return this.offsetMap;
    }

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    public Tuple2<CleanerStats, CleanerStats> statsUnderlying() {
        return this.statsUnderlying;
    }

    public CleanerStats stats() {
        return (CleanerStats)this.statsUnderlying()._1();
    }

    public ByteBuffer kafka$log$Cleaner$$readBuffer() {
        return this.kafka$log$Cleaner$$readBuffer;
    }

    private void kafka$log$Cleaner$$readBuffer_$eq(ByteBuffer x$1) {
        this.kafka$log$Cleaner$$readBuffer = x$1;
    }

    public ByteBuffer kafka$log$Cleaner$$writeBuffer() {
        return this.kafka$log$Cleaner$$writeBuffer;
    }

    private void kafka$log$Cleaner$$writeBuffer_$eq(ByteBuffer x$1) {
        this.kafka$log$Cleaner$$writeBuffer = x$1;
    }

    public long clean(LogToClean cleanable) {
        Option option;
        block4: {
            long l;
            long endOffset;
            Log log;
            block3: {
                block2: {
                    this.stats().clear();
                    this.info((Function0<String>)new Serializable(this, cleanable){
                        public static final long serialVersionUID = 0L;
                        private final LogToClean cleanable$1;

                        public final String apply() {
                            return new StringOps(Predef$.MODULE$.augmentString("Beginning cleaning of log %s.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.cleanable$1.log().name()}));
                        }
                        {
                            this.cleanable$1 = cleanable$1;
                        }
                    });
                    log = cleanable.log();
                    this.info((Function0<String>)new Serializable(this, cleanable){
                        public static final long serialVersionUID = 0L;
                        private final LogToClean cleanable$1;

                        public final String apply() {
                            return new StringOps(Predef$.MODULE$.augmentString("Building offset map for %s...")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.cleanable$1.log().name()}));
                        }
                        {
                            this.cleanable$1 = cleanable$1;
                        }
                    });
                    long upperBoundOffset = cleanable.firstUncleanableOffset();
                    this.buildOffsetMap(log, cleanable.firstDirtyOffset(), upperBoundOffset, this.offsetMap());
                    endOffset = this.offsetMap().latestOffset() + 1L;
                    this.stats().indexDone();
                    option = log.logSegments(0L, cleanable.firstDirtyOffset()).lastOption();
                    if (!None$.MODULE$.equals(option)) break block2;
                    l = 0L;
                    break block3;
                }
                if (!(option instanceof Some)) break block4;
                Some some = (Some)option;
                LogSegment seg = (LogSegment)some.x();
                l = seg.lastModified() - Predef$.MODULE$.Long2long(log.config().deleteRetentionMs());
            }
            long deleteHorizonMs = l;
            long cleanableHorizionMs = BoxesRunTime.unboxToLong((Object)log.logSegments(0L, cleanable.firstUncleanableOffset()).lastOption().map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final long apply(LogSegment x$12) {
                    return x$12.lastModified();
                }
            }).getOrElse((Function0)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final long apply() {
                    return this.apply$mcJ$sp();
                }

                public long apply$mcJ$sp() {
                    return 0L;
                }
            }));
            this.info((Function0<String>)new Serializable(this, log, deleteHorizonMs, cleanableHorizionMs){
                public static final long serialVersionUID = 0L;
                private final Log log$1;
                private final long deleteHorizonMs$1;
                private final long cleanableHorizionMs$1;

                public final String apply() {
                    return new StringOps(Predef$.MODULE$.augmentString("Cleaning log %s (cleaning prior to %s, discarding tombstones prior to %s)...")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.log$1.name(), new Date(this.cleanableHorizionMs$1), new Date(this.deleteHorizonMs$1)}));
                }
                {
                    this.log$1 = log$1;
                    this.deleteHorizonMs$1 = deleteHorizonMs$1;
                    this.cleanableHorizionMs$1 = cleanableHorizionMs$1;
                }
            });
            this.groupSegmentsBySize(log.logSegments(0L, endOffset), Predef$.MODULE$.Integer2int(log.config().segmentSize()), Predef$.MODULE$.Integer2int(log.config().maxIndexSize())).foreach((Function1)new Serializable(this, log, deleteHorizonMs){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ Cleaner $outer;
                private final Log log$1;
                private final long deleteHorizonMs$1;

                public final void apply(Seq<LogSegment> group) {
                    this.$outer.cleanSegments(this.log$1, group, this.$outer.offsetMap(), this.deleteHorizonMs$1);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.log$1 = log$1;
                    this.deleteHorizonMs$1 = deleteHorizonMs$1;
                }
            });
            this.stats().bufferUtilization_$eq(this.offsetMap().utilization());
            this.stats().allDone();
            return endOffset;
        }
        throw new MatchError((Object)option);
    }

    public void cleanSegments(Log log, Seq<LogSegment> segments, OffsetMap map, long deleteHorizonMs) {
        File logFile = new File(new StringBuilder().append((Object)((LogSegment)segments.head()).log().file().getPath()).append((Object)Log$.MODULE$.CleanedFileSuffix()).toString());
        logFile.delete();
        File indexFile = new File(new StringBuilder().append((Object)((LogSegment)segments.head()).index().file().getPath()).append((Object)Log$.MODULE$.CleanedFileSuffix()).toString());
        File timeIndexFile = new File(new StringBuilder().append((Object)((LogSegment)segments.head()).timeIndex().file().getPath()).append((Object)Log$.MODULE$.CleanedFileSuffix()).toString());
        indexFile.delete();
        timeIndexFile.delete();
        FileMessageSet messages = new FileMessageSet(logFile, false, log.initFileSize(), Predef$.MODULE$.Boolean2boolean(log.config().preallocate()));
        OffsetIndex index = new OffsetIndex(indexFile, ((LogSegment)segments.head()).baseOffset(), ((LogSegment)segments.head()).index().maxIndexSize());
        TimeIndex timeIndex = new TimeIndex(timeIndexFile, ((LogSegment)segments.head()).baseOffset(), ((LogSegment)segments.head()).timeIndex().maxIndexSize());
        LogSegment cleaned = new LogSegment(messages, index, timeIndex, ((LogSegment)segments.head()).baseOffset(), ((LogSegment)segments.head()).indexIntervalBytes(), log.config().randomSegmentJitter(), this.time);
        try {
            segments.foreach((Function1)new Serializable(this, log, map, deleteHorizonMs, cleaned){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ Cleaner $outer;
                public final Log log$3;
                private final OffsetMap map$2;
                private final long deleteHorizonMs$2;
                public final LogSegment cleaned$1;

                public final void apply(LogSegment old) {
                    boolean retainDeletes = old.lastModified() > this.deleteHorizonMs$2;
                    this.$outer.info((Function0<String>)new Serializable(this, retainDeletes, old){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$cleanSegments$1 $outer;
                        private final boolean retainDeletes$1;
                        private final LogSegment old$1;

                        public final String apply() {
                            return new StringOps(Predef$.MODULE$.augmentString("Cleaning segment %s in log %s (largest timestamp %s) into %s, %s deletes.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.old$1.baseOffset()), this.$outer.log$3.name(), new Date(this.old$1.largestTimestamp()), BoxesRunTime.boxToLong((long)this.$outer.cleaned$1.baseOffset()), this.retainDeletes$1 ? "retaining" : "discarding"}));
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.retainDeletes$1 = retainDeletes$1;
                            this.old$1 = old$1;
                        }
                    });
                    this.$outer.cleanInto(this.log$3.topicAndPartition(), old, this.cleaned$1, this.map$2, retainDeletes, Predef$.MODULE$.Integer2int(this.log$3.config().maxMessageSize()));
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.log$3 = log$3;
                    this.map$2 = map$2;
                    this.deleteHorizonMs$2 = deleteHorizonMs$2;
                    this.cleaned$1 = cleaned$1;
                }
            });
            index.trimToValidSize();
            cleaned.onBecomeInactiveSegment();
            timeIndex.trimToValidSize();
            cleaned.flush();
            long modified = ((LogSegment)segments.last()).lastModified();
            cleaned.lastModified_$eq(modified);
            this.info((Function0<String>)new Serializable(this, log, segments, cleaned){
                public static final long serialVersionUID = 0L;
                private final Log log$3;
                private final Seq segments$1;
                private final LogSegment cleaned$1;

                public final String apply() {
                    return new StringOps(Predef$.MODULE$.augmentString("Swapping in cleaned segment %d for segment(s) %s in log %s.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.cleaned$1.baseOffset()), ((TraversableOnce)this.segments$1.map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final long apply(LogSegment x$13) {
                            return x$13.baseOffset();
                        }
                    }, Seq$.MODULE$.canBuildFrom())).mkString(","), this.log$3.name()}));
                }
                {
                    this.log$3 = log$3;
                    this.segments$1 = segments$1;
                    this.cleaned$1 = cleaned$1;
                }
            });
            log.replaceSegments(cleaned, segments, log.replaceSegments$default$3());
            return;
        }
        catch (LogCleaningAbortedException logCleaningAbortedException) {
            cleaned.delete();
            throw logCleaningAbortedException;
        }
    }

    public void cleanInto(TopicAndPartition topicAndPartition, LogSegment source, LogSegment dest, OffsetMap map, boolean retainDeletes, int maxLogMessageSize) {
        int position = 0;
        while (position < source.log().sizeInBytes()) {
            this.kafka$log$Cleaner$$checkDone.apply((Object)topicAndPartition);
            this.kafka$log$Cleaner$$readBuffer().clear();
            this.kafka$log$Cleaner$$writeBuffer().clear();
            LongRef maxTimestamp = LongRef.create((long)Message$.MODULE$.NoTimestamp());
            LongRef offsetOfMaxTimestamp = LongRef.create((long)-1L);
            ByteBufferMessageSet messages = new ByteBufferMessageSet(source.log().readInto(this.kafka$log$Cleaner$$readBuffer(), position));
            this.throttler.maybeThrottle(messages.sizeInBytes());
            IntRef messagesRead = IntRef.create((int)0);
            messages.shallowIterator().foreach((Function1)new Serializable(this, source, map, retainDeletes, maxTimestamp, offsetOfMaxTimestamp, messagesRead){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ Cleaner $outer;
                public final LogSegment source$1;
                public final OffsetMap map$3;
                public final boolean retainDeletes$2;
                public final LongRef maxTimestamp$1;
                public final LongRef offsetOfMaxTimestamp$1;
                public final IntRef messagesRead$1;

                public final void apply(MessageAndOffset shallowMessageAndOffset) {
                    Message shallowMessage = shallowMessageAndOffset.message();
                    long shallowOffset = shallowMessageAndOffset.offset();
                    int size2 = MessageSet$.MODULE$.entrySize(shallowMessageAndOffset.message());
                    this.$outer.stats().readMessage(size2);
                    CompressionCodec compressionCodec = shallowMessage.compressionCodec();
                    NoCompressionCodec$ noCompressionCodec$ = NoCompressionCodec$.MODULE$;
                    if (!(compressionCodec != null ? !compressionCodec.equals(noCompressionCodec$) : noCompressionCodec$ != null)) {
                        if (this.$outer.kafka$log$Cleaner$$shouldRetainMessage(this.source$1, this.map$3, this.retainDeletes$2, shallowMessageAndOffset)) {
                            ByteBufferMessageSet$.MODULE$.writeMessage(this.$outer.kafka$log$Cleaner$$writeBuffer(), shallowMessage, shallowOffset);
                            this.$outer.stats().recopyMessage(size2);
                            if (shallowMessage.timestamp() > this.maxTimestamp$1.elem) {
                                this.maxTimestamp$1.elem = shallowMessage.timestamp();
                                this.offsetOfMaxTimestamp$1.elem = shallowOffset;
                            }
                        }
                        ++this.messagesRead$1.elem;
                    } else {
                        BooleanRef writeOriginalMessageSet = BooleanRef.create((boolean)true);
                        ArrayBuffer retainedMessages = new ArrayBuffer();
                        byte shallowMagic = shallowMessage.magic();
                        ByteBufferMessageSet$.MODULE$.deepIterator(shallowMessageAndOffset, ByteBufferMessageSet$.MODULE$.deepIterator$default$2()).foreach((Function1)new Serializable(this, writeOriginalMessageSet, retainedMessages, shallowMagic){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ $anonfun$cleanInto$1 $outer;
                            private final BooleanRef writeOriginalMessageSet$1;
                            private final ArrayBuffer retainedMessages$1;
                            private final byte shallowMagic$1;

                            public final void apply(MessageAndOffset deepMessageAndOffset) {
                                ++this.$outer.messagesRead$1.elem;
                                if (this.$outer.kafka$log$Cleaner$$anonfun$$$outer().kafka$log$Cleaner$$shouldRetainMessage(this.$outer.source$1, this.$outer.map$3, this.$outer.retainDeletes$2, deepMessageAndOffset)) {
                                    if (this.shallowMagic$1 != deepMessageAndOffset.message().magic()) {
                                        this.writeOriginalMessageSet$1.elem = false;
                                    }
                                    this.retainedMessages$1.$plus$eq((Object)deepMessageAndOffset);
                                    if (deepMessageAndOffset.message().timestamp() > this.$outer.maxTimestamp$1.elem) {
                                        this.$outer.maxTimestamp$1.elem = deepMessageAndOffset.message().timestamp();
                                        this.$outer.offsetOfMaxTimestamp$1.elem = deepMessageAndOffset.offset();
                                    }
                                } else {
                                    this.writeOriginalMessageSet$1.elem = false;
                                }
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                                this.writeOriginalMessageSet$1 = writeOriginalMessageSet$1;
                                this.retainedMessages$1 = retainedMessages$1;
                                this.shallowMagic$1 = shallowMagic$1;
                            }
                        });
                        if (writeOriginalMessageSet.elem) {
                            ByteBufferMessageSet$.MODULE$.writeMessage(this.$outer.kafka$log$Cleaner$$writeBuffer(), shallowMessage, shallowOffset);
                        } else {
                            this.$outer.kafka$log$Cleaner$$compressMessages(this.$outer.kafka$log$Cleaner$$writeBuffer(), shallowMessage.compressionCodec(), (Seq<MessageAndOffset>)retainedMessages);
                        }
                    }
                }

                public /* synthetic */ Cleaner kafka$log$Cleaner$$anonfun$$$outer() {
                    return this.$outer;
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.source$1 = source$1;
                    this.map$3 = map$3;
                    this.retainDeletes$2 = retainDeletes$2;
                    this.maxTimestamp$1 = maxTimestamp$1;
                    this.offsetOfMaxTimestamp$1 = offsetOfMaxTimestamp$1;
                    this.messagesRead$1 = messagesRead$1;
                }
            });
            position += messages.validBytes();
            if (this.kafka$log$Cleaner$$writeBuffer().position() > 0) {
                this.kafka$log$Cleaner$$writeBuffer().flip();
                ByteBufferMessageSet retained = new ByteBufferMessageSet(this.kafka$log$Cleaner$$writeBuffer());
                dest.append(((MessageAndOffset)retained.head()).offset(), maxTimestamp.elem, offsetOfMaxTimestamp.elem, retained);
                this.throttler.maybeThrottle(this.kafka$log$Cleaner$$writeBuffer().limit());
            }
            if (this.kafka$log$Cleaner$$readBuffer().limit() <= 0 || messagesRead.elem != 0) continue;
            this.growBuffers(maxLogMessageSize);
        }
        this.restoreBuffers();
    }

    public void kafka$log$Cleaner$$compressMessages(ByteBuffer buffer, CompressionCodec compressionCodec, Seq<MessageAndOffset> messageAndOffsets) {
        CompressionCodec compressionCodec2 = compressionCodec;
        NoCompressionCodec$ noCompressionCodec$ = NoCompressionCodec$.MODULE$;
        Predef$.MODULE$.require(compressionCodec2 != null ? !compressionCodec2.equals(noCompressionCodec$) : noCompressionCodec$ != null, (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"compressionCodec must not be ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{NoCompressionCodec$.MODULE$}));
            }
        });
        if (messageAndOffsets.nonEmpty()) {
            Seq messages = (Seq)messageAndOffsets.map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final Message apply(MessageAndOffset x$14) {
                    return x$14.message();
                }
            }, Seq$.MODULE$.canBuildFrom());
            MagicAndTimestamp magicAndTimestamp = MessageSet$.MODULE$.magicAndLargestTimestamp((Seq<Message>)messages);
            byte magic = magicAndTimestamp.magic();
            MessageAndOffset firstMessageOffset = (MessageAndOffset)messageAndOffsets.head();
            long firstAbsoluteOffset = firstMessageOffset.offset();
            LongRef offset = LongRef.create((long)-1L);
            TimestampType timestampType2 = firstMessageOffset.message().timestampType();
            MessageWriter messageWriter = new MessageWriter(package$.MODULE$.min(package$.MODULE$.max(MessageSet$.MODULE$.messageSetSize((Iterable<Message>)messages) / 2, 1024), 65536));
            CompressionCodec x$18 = compressionCodec;
            long x$19 = magicAndTimestamp.timestamp();
            TimestampType x$20 = timestampType2;
            byte x$21 = magic;
            byte[] x$22 = messageWriter.write$default$1();
            Serializable x$23 = new Serializable(this, compressionCodec, messageAndOffsets, magic, firstAbsoluteOffset, offset){
                public static final long serialVersionUID = 0L;
                private final CompressionCodec compressionCodec$1;
                private final Seq messageAndOffsets$1;
                public final byte magic$1;
                public final long firstAbsoluteOffset$1;
                public final LongRef offset$2;

                /*
                 * WARNING - void declaration
                 */
                public final void apply(OutputStream outputStream) {
                    DataOutputStream output = new DataOutputStream(CompressionFactory$.MODULE$.apply(this.compressionCodec$1, this.magic$1, outputStream));
                    try {
                        this.messageAndOffsets$1.foreach((Function1)new Serializable(this, output){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ $anonfun$11 $outer;
                            private final DataOutputStream output$1;

                            public final void apply(MessageAndOffset messageAndOffset) {
                                this.$outer.offset$2.elem = messageAndOffset.offset();
                                long innerOffset = this.$outer.magic$1 > Message$.MODULE$.MagicValue_V0() ? messageAndOffset.offset() - this.$outer.firstAbsoluteOffset$1 : this.$outer.offset$2.elem;
                                Message message = messageAndOffset.message();
                                this.output$1.writeLong(innerOffset);
                                this.output$1.writeInt(message.size());
                                this.output$1.write(message.buffer().array(), message.buffer().arrayOffset(), message.buffer().limit());
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                                this.output$1 = output$1;
                            }
                        });
                    }
                    catch (Throwable throwable) {
                        void var2_2;
                        var2_2.close();
                        throw throwable;
                    }
                    output.close();
                }
                {
                    this.compressionCodec$1 = compressionCodec$1;
                    this.messageAndOffsets$1 = messageAndOffsets$1;
                    this.magic$1 = magic$1;
                    this.firstAbsoluteOffset$1 = firstAbsoluteOffset$1;
                    this.offset$2 = offset$2;
                }
            };
            messageWriter.write(x$22, x$18, x$19, x$20, x$21, (Function1<OutputStream, BoxedUnit>)x$23);
            ByteBufferMessageSet$.MODULE$.writeMessage(buffer, messageWriter, offset.elem);
            this.stats().recopyMessage(messageWriter.size() + MessageSet$.MODULE$.LogOverhead());
        }
    }

    public boolean kafka$log$Cleaner$$shouldRetainMessage(LogSegment source, OffsetMap map, boolean retainDeletes, MessageAndOffset entry2) {
        boolean bl;
        boolean pastLatestOffset;
        boolean bl2 = pastLatestOffset = entry2.offset() > map.latestOffset();
        if (pastLatestOffset) {
            return true;
        }
        ByteBuffer key = entry2.message().key();
        if (key == null) {
            this.stats().invalidMessage();
            bl = false;
        } else {
            long foundOffset = map.get(key);
            boolean redundant = foundOffset >= 0L && entry2.offset() < foundOffset;
            boolean obsoleteDelete = !retainDeletes && entry2.message().isNull();
            bl = !redundant && !obsoleteDelete;
        }
        return bl;
    }

    public void growBuffers(int maxLogMessageSize) {
        int maxBufferSize = package$.MODULE$.max(maxLogMessageSize, this.maxIoBufferSize);
        if (this.kafka$log$Cleaner$$readBuffer().capacity() >= maxBufferSize || this.kafka$log$Cleaner$$writeBuffer().capacity() >= maxBufferSize) {
            throw new IllegalStateException(new StringOps(Predef$.MODULE$.augmentString("This log contains a message larger than maximum allowable size of %s.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)maxBufferSize)})));
        }
        int newSize = package$.MODULE$.min(this.kafka$log$Cleaner$$readBuffer().capacity() * 2, maxBufferSize);
        this.info((Function0<String>)new Serializable(this, newSize){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Cleaner $outer;
            private final int newSize$1;

            public final String apply() {
                return new StringBuilder().append((Object)"Growing cleaner I/O buffers from ").append((Object)BoxesRunTime.boxToInteger((int)this.$outer.kafka$log$Cleaner$$readBuffer().capacity())).append((Object)"bytes to ").append((Object)BoxesRunTime.boxToInteger((int)this.newSize$1)).append((Object)" bytes.").toString();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.newSize$1 = newSize$1;
            }
        });
        this.kafka$log$Cleaner$$readBuffer_$eq(ByteBuffer.allocate(newSize));
        this.kafka$log$Cleaner$$writeBuffer_$eq(ByteBuffer.allocate(newSize));
    }

    public void restoreBuffers() {
        if (this.kafka$log$Cleaner$$readBuffer().capacity() > this.ioBufferSize) {
            this.kafka$log$Cleaner$$readBuffer_$eq(ByteBuffer.allocate(this.ioBufferSize));
        }
        if (this.kafka$log$Cleaner$$writeBuffer().capacity() > this.ioBufferSize) {
            this.kafka$log$Cleaner$$writeBuffer_$eq(ByteBuffer.allocate(this.ioBufferSize));
        }
    }

    public List<Seq<LogSegment>> groupSegmentsBySize(Iterable<LogSegment> segments, int maxSize, int maxIndexSize) {
        Nil$ grouped = Nil$.MODULE$;
        List segs = segments.toList();
        while (segs.nonEmpty()) {
            List group = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new LogSegment[]{(LogSegment)segs.head()}));
            long logSize = ((LogSegment)segs.head()).size();
            int indexSize = ((LogSegment)segs.head()).index().sizeInBytes();
            int timeIndexSize = ((LogSegment)segs.head()).timeIndex().sizeInBytes();
            segs = (List)segs.tail();
            while (segs.nonEmpty() && logSize + ((LogSegment)segs.head()).size() <= (long)maxSize && indexSize + ((LogSegment)segs.head()).index().sizeInBytes() <= maxIndexSize && timeIndexSize + ((LogSegment)segs.head()).timeIndex().sizeInBytes() <= maxIndexSize && ((LogSegment)segs.head()).index().lastOffset() - ((LogSegment)group.last()).index().baseOffset() <= Integer.MAX_VALUE) {
                LogSegment logSegment = (LogSegment)segs.head();
                group = group.$colon$colon((Object)logSegment);
                logSize += ((LogSegment)segs.head()).size();
                indexSize += ((LogSegment)segs.head()).index().sizeInBytes();
                timeIndexSize += ((LogSegment)segs.head()).timeIndex().sizeInBytes();
                segs = (List)segs.tail();
            }
            grouped = grouped.$colon$colon((Object)group.reverse());
        }
        return grouped.reverse();
    }

    public void buildOffsetMap(Log log, long start, long end, OffsetMap map) {
        map.clear();
        Buffer dirty = log.logSegments(start, end).toBuffer();
        this.info((Function0<String>)new Serializable(this, log, start, end, dirty){
            public static final long serialVersionUID = 0L;
            private final Log log$2;
            private final long start$1;
            private final long end$1;
            private final Buffer dirty$1;

            public final String apply() {
                return new StringOps(Predef$.MODULE$.augmentString("Building offset map for log %s for %d segments in offset range [%d, %d).")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.log$2.name(), BoxesRunTime.boxToInteger((int)this.dirty$1.size()), BoxesRunTime.boxToLong((long)this.start$1), BoxesRunTime.boxToLong((long)this.end$1)}));
            }
            {
                this.log$2 = log$2;
                this.start$1 = start$1;
                this.end$1 = end$1;
                this.dirty$1 = dirty$1;
            }
        });
        BooleanRef full = BooleanRef.create((boolean)false);
        dirty.withFilter((Function1)new Serializable(this, full){
            public static final long serialVersionUID = 0L;
            private final BooleanRef full$1;

            public final boolean apply(LogSegment segment) {
                return !this.full$1.elem;
            }
            {
                this.full$1 = full$1;
            }
        }).foreach((Function1)new Serializable(this, log, start, map, dirty, full){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Cleaner $outer;
            private final Log log$2;
            private final long start$1;
            private final OffsetMap map$1;
            public final Buffer dirty$1;
            private final BooleanRef full$1;

            public final void apply(LogSegment segment) {
                this.$outer.kafka$log$Cleaner$$checkDone.apply((Object)this.log$2.topicAndPartition());
                this.full$1.elem = this.$outer.kafka$log$Cleaner$$buildOffsetMapForSegment(this.log$2.topicAndPartition(), segment, this.map$1, this.start$1, Predef$.MODULE$.Integer2int(this.log$2.config().maxMessageSize()));
                if (this.full$1.elem) {
                    this.$outer.debug((Function0<String>)new Serializable(this, segment){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$buildOffsetMap$3 $outer;
                        private final LogSegment segment$1;

                        public final String apply() {
                            return new StringOps(Predef$.MODULE$.augmentString("Offset map is full, %d segments fully mapped, segment with base offset %d is partially mapped")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.$outer.dirty$1.indexOf((Object)this.segment$1)), BoxesRunTime.boxToLong((long)this.segment$1.baseOffset())}));
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.segment$1 = segment$1;
                        }
                    });
                }
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.log$2 = log$2;
                this.start$1 = start$1;
                this.map$1 = map$1;
                this.dirty$1 = dirty$1;
                this.full$1 = full$1;
            }
        });
        this.info((Function0<String>)new Serializable(this, log){
            public static final long serialVersionUID = 0L;
            private final Log log$2;

            public final String apply() {
                return new StringOps(Predef$.MODULE$.augmentString("Offset map for log %s complete.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.log$2.name()}));
            }
            {
                this.log$2 = log$2;
            }
        });
    }

    public boolean kafka$log$Cleaner$$buildOffsetMapForSegment(TopicAndPartition topicAndPartition, LogSegment segment, OffsetMap map, long start, int maxLogMessageSize) {
        Object object = new Object();
        try {
            int position = segment.index().lookup(start).position();
            int maxDesiredMapSize = (int)((double)map.slots() * this.dupBufferLoadFactor);
            while (position < segment.log().sizeInBytes()) {
                this.kafka$log$Cleaner$$checkDone.apply((Object)topicAndPartition);
                this.kafka$log$Cleaner$$readBuffer().clear();
                ByteBufferMessageSet messages = new ByteBufferMessageSet(segment.log().readInto(this.kafka$log$Cleaner$$readBuffer(), position));
                this.throttler.maybeThrottle(messages.sizeInBytes());
                int startPosition = position;
                messages.foreach(new Serializable(this, map, start, maxDesiredMapSize, object){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ Cleaner $outer;
                    private final OffsetMap map$4;
                    private final long start$2;
                    private final int maxDesiredMapSize$1;
                    private final Object nonLocalReturnKey1$1;

                    public final void apply(MessageAndOffset entry2) {
                        Message message = entry2.message();
                        if (message.hasKey() && entry2.offset() >= this.start$2) {
                            if (this.map$4.size() < this.maxDesiredMapSize$1) {
                                this.map$4.put(message.key(), entry2.offset());
                            } else {
                                throw new NonLocalReturnControl.mcZ.sp(this.nonLocalReturnKey1$1, true);
                            }
                        }
                        this.$outer.stats().indexMessagesRead(1);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.map$4 = map$4;
                        this.start$2 = start$2;
                        this.maxDesiredMapSize$1 = maxDesiredMapSize$1;
                        this.nonLocalReturnKey1$1 = nonLocalReturnKey1$1;
                    }
                });
                this.stats().indexBytesRead(messages.validBytes());
                if ((position += messages.validBytes()) != startPosition) continue;
                this.growBuffers(maxLogMessageSize);
            }
            this.restoreBuffers();
            return false;
        }
        catch (NonLocalReturnControl nonLocalReturnControl) {
            if (nonLocalReturnControl.key() == object) {
                return nonLocalReturnControl.value$mcZ$sp();
            }
            throw nonLocalReturnControl;
        }
    }

    public Cleaner(int id, OffsetMap offsetMap, int ioBufferSize, int maxIoBufferSize, double dupBufferLoadFactor, Throttler throttler, Time time, Function1<TopicAndPartition, BoxedUnit> checkDone) {
        this.id = id;
        this.offsetMap = offsetMap;
        this.ioBufferSize = ioBufferSize;
        this.maxIoBufferSize = maxIoBufferSize;
        this.dupBufferLoadFactor = dupBufferLoadFactor;
        this.throttler = throttler;
        this.time = time;
        this.kafka$log$Cleaner$$checkDone = checkDone;
        Logging$class.$init$(this);
        this.loggerName = LogCleaner.class.getName();
        this.logIdent_$eq(new StringBuilder().append((Object)"Cleaner ").append((Object)BoxesRunTime.boxToInteger((int)id)).append((Object)": ").toString());
        this.statsUnderlying = new Tuple2((Object)new CleanerStats(time), (Object)new CleanerStats(time));
        this.kafka$log$Cleaner$$readBuffer = ByteBuffer.allocate(ioBufferSize);
        this.kafka$log$Cleaner$$writeBuffer = ByteBuffer.allocate(ioBufferSize);
        Predef$.MODULE$.require((double)offsetMap.slots() * dupBufferLoadFactor > 1.0, (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "offset map is too small to fit in even a single message, so log cleaning will never make progress. You can increase log.cleaner.dedupe.buffer.size or decrease log.cleaner.threads";
            }
        });
    }
}

