/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.Histogram;
import com.yammer.metrics.core.Meter;
import com.yammer.metrics.core.Timer;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import kafka.admin.AdminUtils$;
import kafka.admin.BrokerMetadata;
import kafka.cluster.Broker;
import kafka.common.TopicAlreadyMarkedForDeletionException;
import kafka.log.LogConfig$;
import kafka.metrics.KafkaMetricsGroup;
import kafka.metrics.KafkaMetricsGroup$class;
import kafka.server.CreateTopicMetadata;
import kafka.server.DelayedCreateTopics;
import kafka.server.DelayedDeleteTopics;
import kafka.server.DelayedOperation;
import kafka.server.DelayedOperationPurgatory;
import kafka.server.DelayedOperationPurgatory$;
import kafka.server.DeleteTopicMetadata;
import kafka.server.KafkaConfig;
import kafka.server.MetadataCache;
import kafka.server.TopicKey;
import kafka.utils.Log4jController$;
import kafka.utils.Logging$class;
import kafka.utils.ZkUtils;
import org.apache.kafka.common.errors.InvalidRequestException;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.CreateTopicsRequest;
import org.apache.log4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.Set$;
import scala.collection.SetLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.Map$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@ScalaSignature(bytes="\u0006\u0001\u0005Uc\u0001B\u0001\u0003\u0001\u001d\u0011A\"\u00113nS:l\u0015M\\1hKJT!a\u0001\u0003\u0002\rM,'O^3s\u0015\u0005)\u0011!B6bM.\f7\u0001A\n\u0005\u0001!qA\u0003\u0005\u0002\n\u00195\t!BC\u0001\f\u0003\u0015\u00198-\u00197b\u0013\ti!B\u0001\u0004B]f\u0014VM\u001a\t\u0003\u001fIi\u0011\u0001\u0005\u0006\u0003#\u0011\tQ!\u001e;jYNL!a\u0005\t\u0003\u000f1{wmZ5oOB\u0011Q\u0003G\u0007\u0002-)\u0011q\u0003B\u0001\b[\u0016$(/[2t\u0013\tIbCA\tLC\u001a\\\u0017-T3ue&\u001c7o\u0012:pkBD\u0001b\u0007\u0001\u0003\u0006\u0004%\t\u0001H\u0001\u0007G>tg-[4\u0016\u0003u\u0001\"AH\u0010\u000e\u0003\tI!\u0001\t\u0002\u0003\u0017-\u000bgm[1D_:4\u0017n\u001a\u0005\tE\u0001\u0011\t\u0011)A\u0005;\u000591m\u001c8gS\u001e\u0004\u0003\u0002C\f\u0001\u0005\u000b\u0007I\u0011\u0001\u0013\u0016\u0003\u0015\u0002\"AJ\u0018\u000e\u0003\u001dR!a\u0006\u0015\u000b\u0005%R\u0013AB2p[6|gN\u0003\u0002\u0006W)\u0011A&L\u0001\u0007CB\f7\r[3\u000b\u00039\n1a\u001c:h\u0013\t\u0001tEA\u0004NKR\u0014\u0018nY:\t\u0011I\u0002!\u0011!Q\u0001\n\u0015\n\u0001\"\\3ue&\u001c7\u000f\t\u0005\ti\u0001\u0011)\u0019!C\u0001k\u0005iQ.\u001a;bI\u0006$\u0018mQ1dQ\u0016,\u0012A\u000e\t\u0003=]J!\u0001\u000f\u0002\u0003\u001b5+G/\u00193bi\u0006\u001c\u0015m\u00195f\u0011!Q\u0004A!A!\u0002\u00131\u0014AD7fi\u0006$\u0017\r^1DC\u000eDW\r\t\u0005\ty\u0001\u0011)\u0019!C\u0001{\u00059!p[+uS2\u001cX#\u0001 \u0011\u0005=y\u0014B\u0001!\u0011\u0005\u001dQ6.\u0016;jYND\u0001B\u0011\u0001\u0003\u0002\u0003\u0006IAP\u0001\tu.,F/\u001b7tA!)A\t\u0001C\u0001\u000b\u00061A(\u001b8jiz\"RAR$I\u0013*\u0003\"A\b\u0001\t\u000bm\u0019\u0005\u0019A\u000f\t\u000b]\u0019\u0005\u0019A\u0013\t\u000bQ\u001a\u0005\u0019\u0001\u001c\t\u000bq\u001a\u0005\u0019\u0001 \t\u000f1\u0003!\u0019!C\u0001\u001b\u0006qAo\u001c9jGB+(oZ1u_JLX#\u0001(\u0011\u0007yy\u0015+\u0003\u0002Q\u0005\tIB)\u001a7bs\u0016$w\n]3sCRLwN\u001c)ve\u001e\fGo\u001c:z!\tq\"+\u0003\u0002T\u0005\t\u0001B)\u001a7bs\u0016$w\n]3sCRLwN\u001c\u0005\u0007+\u0002\u0001\u000b\u0011\u0002(\u0002\u001fQ|\u0007/[2QkJ<\u0017\r^8ss\u0002BQa\u0016\u0001\u0005\u0002a\u000b\u0011\u0004[1t\t\u0016d\u0017-_3e)>\u0004\u0018nY(qKJ\fG/[8ogV\t\u0011\f\u0005\u0002\n5&\u00111L\u0003\u0002\b\u0005>|G.Z1o\u0011\u0015i\u0006\u0001\"\u0001_\u0003\u0005\"(/_\"p[BdW\r^3EK2\f\u00170\u001a3U_BL7m\u00149fe\u0006$\u0018n\u001c8t)\ty&\r\u0005\u0002\nA&\u0011\u0011M\u0003\u0002\u0005+:LG\u000fC\u0003d9\u0002\u0007A-A\u0003u_BL7\r\u0005\u0002fQ:\u0011\u0011BZ\u0005\u0003O*\ta\u0001\u0015:fI\u00164\u0017BA5k\u0005\u0019\u0019FO]5oO*\u0011qM\u0003\u0005\u0006Y\u0002!\t!\\\u0001\rGJ,\u0017\r^3U_BL7m\u001d\u000b\u0006?:\u001c\u00181\u0005\u0005\u0006_.\u0004\r\u0001]\u0001\bi&lWm\\;u!\tI\u0011/\u0003\u0002s\u0015\t\u0019\u0011J\u001c;\t\u000bQ\\\u0007\u0019A;\u0002\u0015\r\u0014X-\u0019;f\u0013:4w\u000e\u0005\u0003ws\u0012\\X\"A<\u000b\u0005aT\u0011AC2pY2,7\r^5p]&\u0011!p\u001e\u0002\u0004\u001b\u0006\u0004\bc\u0001?\u0002\u001e9\u0019Q0a\u0006\u000f\u0007y\f\u0019BD\u0002\u0000\u0003#qA!!\u0001\u0002\u00109!\u00111AA\u0007\u001d\u0011\t)!a\u0003\u000e\u0005\u0005\u001d!bAA\u0005\r\u00051AH]8pizJ\u0011AL\u0005\u0003Y5J!!B\u0016\n\u0005%R\u0013bAA\u000bQ\u0005A!/Z9vKN$8/\u0003\u0003\u0002\u001a\u0005m\u0011aE\"sK\u0006$X\rV8qS\u000e\u001c(+Z9vKN$(bAA\u000bQ%!\u0011qDA\u0011\u00051!v\u000e]5d\t\u0016$\u0018-\u001b7t\u0015\u0011\tI\"a\u0007\t\u000f\u0005\u00152\u000e1\u0001\u0002(\u0005\u0001\"/Z:q_:\u001cXmQ1mY\n\f7m\u001b\t\u0007\u0013\u0005%\u0012QF0\n\u0007\u0005-\"BA\u0005Gk:\u001cG/[8ocA)a/\u001f3\u00020A!\u0011\u0011GA\u001c\u001b\t\t\u0019DC\u0002\u00026!\n\u0001\u0002\u001d:pi>\u001cw\u000e\\\u0005\u0005\u0003s\t\u0019D\u0001\u0004FeJ|'o\u001d\u0005\b\u0003{\u0001A\u0011AA \u00031!W\r\\3uKR{\u0007/[2t)\u001dy\u0016\u0011IA\"\u0003\u001bBaa\\A\u001e\u0001\u0004\u0001\b\u0002CA#\u0003w\u0001\r!a\u0012\u0002\rQ|\u0007/[2t!\u00111\u0018\u0011\n3\n\u0007\u0005-sOA\u0002TKRD\u0001\"!\n\u0002<\u0001\u0007\u0011q\u0005\u0005\b\u0003#\u0002A\u0011AA*\u0003!\u0019\b.\u001e;e_^tG#A0")
public class AdminManager
implements KafkaMetricsGroup {
    private final KafkaConfig config;
    private final Metrics metrics;
    private final MetadataCache metadataCache;
    private final ZkUtils zkUtils;
    private final DelayedOperationPurgatory<DelayedOperation> topicPurgatory;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    private volatile boolean bitmap$0;

    @Override
    public <T> Gauge<T> newGauge(String name, Gauge<T> metric, Map<String, String> tags) {
        return KafkaMetricsGroup$class.newGauge(this, name, metric, tags);
    }

    @Override
    public Meter newMeter(String name, String eventType, TimeUnit timeUnit, Map<String, String> tags) {
        return KafkaMetricsGroup$class.newMeter(this, name, eventType, timeUnit, tags);
    }

    @Override
    public Histogram newHistogram(String name, boolean biased, Map<String, String> tags) {
        return KafkaMetricsGroup$class.newHistogram(this, name, biased, tags);
    }

    @Override
    public Timer newTimer(String name, TimeUnit durationUnit, TimeUnit rateUnit, Map<String, String> tags) {
        return KafkaMetricsGroup$class.newTimer(this, name, durationUnit, rateUnit, tags);
    }

    @Override
    public void removeMetric(String name, Map<String, String> tags) {
        KafkaMetricsGroup$class.removeMetric(this, name, tags);
    }

    @Override
    public <T> Map<String, String> newGauge$default$3() {
        return KafkaMetricsGroup$class.newGauge$default$3(this);
    }

    @Override
    public Map<String, String> newMeter$default$4() {
        return KafkaMetricsGroup$class.newMeter$default$4(this);
    }

    @Override
    public Map<String, String> removeMetric$default$2() {
        return KafkaMetricsGroup$class.removeMetric$default$2(this);
    }

    @Override
    public Map<String, String> newTimer$default$4() {
        return KafkaMetricsGroup$class.newTimer$default$4(this);
    }

    @Override
    public boolean newHistogram$default$2() {
        return KafkaMetricsGroup$class.newHistogram$default$2(this);
    }

    @Override
    public Map<String, String> newHistogram$default$3() {
        return KafkaMetricsGroup$class.newHistogram$default$3(this);
    }

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    private Logger logger$lzycompute() {
        AdminManager adminManager = this;
        synchronized (adminManager) {
            if (!this.bitmap$0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    @Override
    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    @Override
    public Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    @Override
    public void kafka$utils$Logging$_setter_$loggerName_$eq(String x$1) {
        this.loggerName = x$1;
    }

    @Override
    public void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ x$1) {
        this.kafka$utils$Logging$$log4jController = x$1;
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging$class.trace(this, msg);
    }

    @Override
    public Object trace(Function0<Throwable> e) {
        return Logging$class.trace(this, e);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.trace(this, msg, e);
    }

    @Override
    public void swallowTrace(Function0<BoxedUnit> action) {
        Logging$class.swallowTrace(this, action);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging$class.isDebugEnabled(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging$class.debug(this, msg);
    }

    @Override
    public Object debug(Function0<Throwable> e) {
        return Logging$class.debug(this, e);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.debug(this, msg, e);
    }

    @Override
    public void swallowDebug(Function0<BoxedUnit> action) {
        Logging$class.swallowDebug(this, action);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging$class.info(this, msg);
    }

    @Override
    public Object info(Function0<Throwable> e) {
        return Logging$class.info(this, e);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.info(this, msg, e);
    }

    @Override
    public void swallowInfo(Function0<BoxedUnit> action) {
        Logging$class.swallowInfo(this, action);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging$class.warn(this, msg);
    }

    @Override
    public Object warn(Function0<Throwable> e) {
        return Logging$class.warn(this, e);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.warn(this, msg, e);
    }

    @Override
    public void swallowWarn(Function0<BoxedUnit> action) {
        Logging$class.swallowWarn(this, action);
    }

    @Override
    public void swallow(Function0<BoxedUnit> action) {
        Logging$class.swallow(this, action);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging$class.error(this, msg);
    }

    @Override
    public Object error(Function0<Throwable> e) {
        return Logging$class.error(this, e);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.error(this, msg, e);
    }

    @Override
    public void swallowError(Function0<BoxedUnit> action) {
        Logging$class.swallowError(this, action);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging$class.fatal(this, msg);
    }

    @Override
    public Object fatal(Function0<Throwable> e) {
        return Logging$class.fatal(this, e);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.fatal(this, msg, e);
    }

    public KafkaConfig config() {
        return this.config;
    }

    public Metrics metrics() {
        return this.metrics;
    }

    public MetadataCache metadataCache() {
        return this.metadataCache;
    }

    public ZkUtils zkUtils() {
        return this.zkUtils;
    }

    public DelayedOperationPurgatory<DelayedOperation> topicPurgatory() {
        return this.topicPurgatory;
    }

    public boolean hasDelayedTopicOperations() {
        return this.topicPurgatory().delayed() != 0;
    }

    public void tryCompleteDelayedTopicOperations(String topic) {
        TopicKey key = new TopicKey(topic);
        int completed = this.topicPurgatory().checkAndComplete(key);
        this.debug((Function0<String>)new Serializable(this, key, completed){
            public static final long serialVersionUID = 0L;
            private final TopicKey key$1;
            private final int completed$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Request key ", " unblocked ", " topic requests."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.key$1.keyLabel(), BoxesRunTime.boxToInteger((int)this.completed$1)}));
            }
            {
                this.key$1 = key$1;
                this.completed$1 = completed$1;
            }
        });
    }

    public void createTopics(int timeout, Map<String, CreateTopicsRequest.TopicDetails> createInfo, Function1<Map<String, Errors>, BoxedUnit> responseCallback) {
        Seq brokers = (Seq)this.metadataCache().getAliveBrokers().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final BrokerMetadata apply(Broker b) {
                return new BrokerMetadata(b.id(), b.rack());
            }
        }, Seq$.MODULE$.canBuildFrom());
        Iterable metadata = (Iterable)createInfo.map((Function1)new Serializable(this, brokers){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AdminManager $outer;
            private final Seq brokers$1;

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final CreateTopicMetadata apply(Tuple2<String, CreateTopicsRequest.TopicDetails> x0$1) {
                CreateTopicMetadata createTopicMetadata;
                Tuple2<String, CreateTopicsRequest.TopicDetails> tuple2 = x0$1;
                if (tuple2 == null) throw new MatchError(tuple2);
                String topic = (String)tuple2._1();
                CreateTopicsRequest.TopicDetails arguments = (CreateTopicsRequest.TopicDetails)tuple2._2();
                try {
                    Properties configs = new Properties();
                    ((IterableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(arguments.configs).asScala()).foreach((Function1)new Serializable(this, configs){
                        public static final long serialVersionUID = 0L;
                        private final Properties configs$1;

                        public final Object apply(Tuple2<String, String> x0$2) {
                            Tuple2<String, String> tuple2 = x0$2;
                            if (tuple2 != null) {
                                String key = (String)tuple2._1();
                                String value2 = (String)tuple2._2();
                                Object object = this.configs$1.setProperty(key, value2);
                                return object;
                            }
                            throw new MatchError(tuple2);
                        }
                        {
                            this.configs$1 = configs$1;
                        }
                    });
                    LogConfig$.MODULE$.validate(configs);
                    if (!(arguments.numPartitions == -1 && arguments.replicationFactor == -1 || arguments.replicasAssignments.isEmpty())) {
                        throw new InvalidRequestException("Both numPartitions or replicationFactor and replicasAssignments were set. Both cannot be used at the same time.");
                    }
                    Map assignments = arguments.replicasAssignments.isEmpty() ? AdminUtils$.MODULE$.assignReplicasToBrokers((Seq<BrokerMetadata>)this.brokers$1, arguments.numPartitions, arguments.replicationFactor, AdminUtils$.MODULE$.assignReplicasToBrokers$default$4(), AdminUtils$.MODULE$.assignReplicasToBrokers$default$5()) : (Map)((TraversableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(arguments.replicasAssignments).asScala()).map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final Tuple2<Object, Buffer<Object>> apply(Tuple2<Integer, List<Integer>> x0$3) {
                            Tuple2<Integer, List<Integer>> tuple2 = x0$3;
                            if (tuple2 != null) {
                                Integer partitionId = (Integer)tuple2._1();
                                List replicas = (List)tuple2._2();
                                Tuple2 tuple22 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)partitionId), ((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(replicas).asScala()).map((Function1)new Serializable(this){
                                    public static final long serialVersionUID = 0L;

                                    public final int apply(Integer x$1) {
                                        return x$1;
                                    }
                                }, Buffer$.MODULE$.canBuildFrom()));
                                return tuple22;
                            }
                            throw new MatchError(tuple2);
                        }
                    }, Map$.MODULE$.canBuildFrom());
                    this.$outer.trace((Function0<String>)new Serializable(this, topic, assignments){
                        public static final long serialVersionUID = 0L;
                        private final String topic$1;
                        private final Map assignments$1;

                        public final String apply() {
                            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Assignments for topic ", " are ", " "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topic$1, this.assignments$1}));
                        }
                        {
                            this.topic$1 = topic$1;
                            this.assignments$1 = assignments$1;
                        }
                    });
                    AdminUtils$.MODULE$.createOrUpdateTopicPartitionAssignmentPathInZK(this.$outer.zkUtils(), topic, (Map<Object, Seq<Object>>)assignments, configs, false);
                    createTopicMetadata = new CreateTopicMetadata(topic, (Map<Object, Seq<Object>>)assignments, Errors.NONE);
                    return createTopicMetadata;
                }
                catch (Throwable throwable) {
                    this.$outer.warn((Function0<String>)new Serializable(this, topic, arguments){
                        public static final long serialVersionUID = 0L;
                        private final String topic$1;
                        private final CreateTopicsRequest.TopicDetails arguments$1;

                        public final String apply() {
                            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Error processing create topic request for topic ", " with arguments ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topic$1, this.arguments$1}));
                        }
                        {
                            this.topic$1 = topic$1;
                            this.arguments$1 = arguments$1;
                        }
                    }, (Function0<Throwable>)new Serializable(this, throwable){
                        public static final long serialVersionUID = 0L;
                        private final Throwable e$1;

                        public final Throwable apply() {
                            return this.e$1;
                        }
                        {
                            this.e$1 = e$1;
                        }
                    });
                    createTopicMetadata = new CreateTopicMetadata(topic, (Map<Object, Seq<Object>>)((Map)scala.collection.Map$.MODULE$.apply((Seq)Nil$.MODULE$)), Errors.forException((Throwable)throwable));
                }
                return createTopicMetadata;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.brokers$1 = brokers$1;
            }
        }, Iterable$.MODULE$.canBuildFrom());
        if (timeout > 0 && metadata.exists((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(CreateTopicMetadata x$2) {
                Errors errors = x$2.error();
                Errors errors2 = Errors.NONE;
                return !(errors != null ? !errors.equals(errors2) : errors2 != null);
            }
        })) {
            DelayedCreateTopics delayedCreate = new DelayedCreateTopics(timeout, (Seq<CreateTopicMetadata>)metadata.toSeq(), this, responseCallback);
            Seq delayedCreateKeys = ((TraversableOnce)createInfo.keys().map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final TopicKey apply(String x$3) {
                    return new TopicKey(x$3);
                }
            }, Iterable$.MODULE$.canBuildFrom())).toSeq();
            this.topicPurgatory().tryCompleteElseWatch(delayedCreate, (Seq<Object>)delayedCreateKeys);
        } else {
            scala.collection.immutable.Map results = ((TraversableOnce)metadata.map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final Tuple2<String, Errors> apply(CreateTopicMetadata createTopicMetadata) {
                    Errors errors = createTopicMetadata.error();
                    Errors errors2 = Errors.NONE;
                    return !(errors != null ? !errors.equals(errors2) : errors2 != null) ? new Tuple2((Object)createTopicMetadata.topic(), (Object)Errors.REQUEST_TIMED_OUT) : new Tuple2((Object)createTopicMetadata.topic(), (Object)createTopicMetadata.error());
                }
            }, Iterable$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
            responseCallback.apply((Object)results);
        }
    }

    public void deleteTopics(int timeout, Set<String> topics, Function1<Map<String, Errors>, BoxedUnit> responseCallback) {
        Set metadata = (Set)topics.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AdminManager $outer;

            public final DeleteTopicMetadata apply(String topic) {
                DeleteTopicMetadata deleteTopicMetadata;
                try {
                    AdminUtils$.MODULE$.deleteTopic(this.$outer.zkUtils(), topic);
                    deleteTopicMetadata = new DeleteTopicMetadata(topic, Errors.NONE);
                }
                catch (Throwable throwable) {
                    this.$outer.error((Function0<String>)new Serializable(this, topic){
                        public static final long serialVersionUID = 0L;
                        private final String topic$2;

                        public final String apply() {
                            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Error processing delete topic request for topic ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topic$2}));
                        }
                        {
                            this.topic$2 = topic$2;
                        }
                    }, (Function0<Throwable>)new Serializable(this, throwable){
                        public static final long serialVersionUID = 0L;
                        private final Throwable e$2;

                        public final Throwable apply() {
                            return this.e$2;
                        }
                        {
                            this.e$2 = e$2;
                        }
                    });
                    deleteTopicMetadata = new DeleteTopicMetadata(topic, Errors.forException((Throwable)throwable));
                }
                catch (TopicAlreadyMarkedForDeletionException topicAlreadyMarkedForDeletionException) {
                    deleteTopicMetadata = new DeleteTopicMetadata(topic, Errors.NONE);
                }
                return deleteTopicMetadata;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, Set$.MODULE$.canBuildFrom());
        if (timeout > 0 && metadata.exists((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(DeleteTopicMetadata x$4) {
                Errors errors = x$4.error();
                Errors errors2 = Errors.NONE;
                return !(errors != null ? !errors.equals(errors2) : errors2 != null);
            }
        })) {
            DelayedDeleteTopics delayedDelete = new DelayedDeleteTopics(timeout, (Seq<DeleteTopicMetadata>)metadata.toSeq(), this, responseCallback);
            Seq delayedDeleteKeys = ((SetLike)topics.map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final TopicKey apply(String x$5) {
                    return new TopicKey(x$5);
                }
            }, Set$.MODULE$.canBuildFrom())).toSeq();
            this.topicPurgatory().tryCompleteElseWatch(delayedDelete, (Seq<Object>)delayedDeleteKeys);
        } else {
            scala.collection.immutable.Map results = ((TraversableOnce)metadata.map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final Tuple2<String, Errors> apply(DeleteTopicMetadata deleteTopicMetadata) {
                    Errors errors = deleteTopicMetadata.error();
                    Errors errors2 = Errors.NONE;
                    return !(errors != null ? !errors.equals(errors2) : errors2 != null) ? new Tuple2((Object)deleteTopicMetadata.topic(), (Object)Errors.REQUEST_TIMED_OUT) : new Tuple2((Object)deleteTopicMetadata.topic(), (Object)deleteTopicMetadata.error());
                }
            }, Set$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
            responseCallback.apply((Object)results);
        }
    }

    public void shutdown() {
        this.topicPurgatory().shutdown();
    }

    public AdminManager(KafkaConfig config, Metrics metrics, MetadataCache metadataCache, ZkUtils zkUtils) {
        this.config = config;
        this.metrics = metrics;
        this.metadataCache = metadataCache;
        this.zkUtils = zkUtils;
        Logging$class.$init$(this);
        KafkaMetricsGroup$class.$init$(this);
        this.logIdent_$eq(new StringBuilder().append((Object)"[Admin Manager on Broker ").append((Object)BoxesRunTime.boxToInteger((int)config.brokerId())).append((Object)"]: ").toString());
        this.topicPurgatory = DelayedOperationPurgatory$.MODULE$.apply("topic", config.brokerId(), DelayedOperationPurgatory$.MODULE$.apply$default$3());
    }
}

