/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import java.io.File;
import java.text.NumberFormat;
import java.util.UUID;
import java.util.regex.Pattern;
import kafka.common.KafkaException;
import kafka.log.Log;
import kafka.log.LogConfig;
import kafka.log.ProducerStateManager;
import kafka.server.BrokerTopicStats;
import kafka.utils.Scheduler;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.utils.Time;
import scala.Predef$;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxesRunTime;

public final class Log$ {
    public static final Log$ MODULE$;
    private final String LogFileSuffix;
    private final String IndexFileSuffix;
    private final String TimeIndexFileSuffix;
    private final String PidSnapshotFileSuffix;
    private final String TxnIndexFileSuffix;
    private final String DeletedFileSuffix;
    private final String CleanedFileSuffix;
    private final String SwapFileSuffix;
    private final String CleanShutdownFile;
    private final String DeleteDirSuffix;
    private final Pattern DeleteDirPattern;
    private final long UnknownLogStartOffset;

    static {
        new Log$();
    }

    public String LogFileSuffix() {
        return this.LogFileSuffix;
    }

    public String IndexFileSuffix() {
        return this.IndexFileSuffix;
    }

    public String TimeIndexFileSuffix() {
        return this.TimeIndexFileSuffix;
    }

    public String PidSnapshotFileSuffix() {
        return this.PidSnapshotFileSuffix;
    }

    public String TxnIndexFileSuffix() {
        return this.TxnIndexFileSuffix;
    }

    public String DeletedFileSuffix() {
        return this.DeletedFileSuffix;
    }

    public String CleanedFileSuffix() {
        return this.CleanedFileSuffix;
    }

    public String SwapFileSuffix() {
        return this.SwapFileSuffix;
    }

    public String CleanShutdownFile() {
        return this.CleanShutdownFile;
    }

    public String DeleteDirSuffix() {
        return this.DeleteDirSuffix;
    }

    private Pattern DeleteDirPattern() {
        return this.DeleteDirPattern;
    }

    public long UnknownLogStartOffset() {
        return this.UnknownLogStartOffset;
    }

    public Log apply(File dir, LogConfig config, long logStartOffset, long recoveryPoint, Scheduler scheduler, BrokerTopicStats brokerTopicStats, Time time, int maxProducerIdExpirationMs, int producerIdExpirationCheckIntervalMs) {
        TopicPartition topicPartition = this.parseTopicPartitionName(dir);
        ProducerStateManager producerStateManager = new ProducerStateManager(topicPartition, dir, maxProducerIdExpirationMs);
        return new Log(dir, config, logStartOffset, recoveryPoint, scheduler, brokerTopicStats, time, maxProducerIdExpirationMs, producerIdExpirationCheckIntervalMs, topicPartition, producerStateManager);
    }

    public long apply$default$3() {
        return 0L;
    }

    public long apply$default$4() {
        return 0L;
    }

    public Time apply$default$7() {
        return Time.SYSTEM;
    }

    public int apply$default$8() {
        return 3600000;
    }

    public int apply$default$9() {
        return 600000;
    }

    public String filenamePrefixFromOffset(long offset2) {
        NumberFormat nf = NumberFormat.getInstance();
        nf.setMinimumIntegerDigits(20);
        nf.setMaximumFractionDigits(0);
        nf.setGroupingUsed(false);
        return nf.format(offset2);
    }

    public File logFile(File dir, long offset2) {
        return new File(dir, new StringBuilder().append((Object)this.filenamePrefixFromOffset(offset2)).append((Object)this.LogFileSuffix()).toString());
    }

    public String logDeleteDirName(String logName) {
        String uniqueId = UUID.randomUUID().toString().replaceAll("-", "");
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".", "", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{logName, uniqueId, this.DeleteDirSuffix()}));
    }

    public File offsetIndexFile(File dir, long offset2) {
        return new File(dir, new StringBuilder().append((Object)this.filenamePrefixFromOffset(offset2)).append((Object)this.IndexFileSuffix()).toString());
    }

    public File timeIndexFile(File dir, long offset2) {
        return new File(dir, new StringBuilder().append((Object)this.filenamePrefixFromOffset(offset2)).append((Object)this.TimeIndexFileSuffix()).toString());
    }

    public File producerSnapshotFile(File dir, long offset2) {
        return new File(dir, new StringBuilder().append((Object)this.filenamePrefixFromOffset(offset2)).append((Object)this.PidSnapshotFileSuffix()).toString());
    }

    public File transactionIndexFile(File dir, long offset2) {
        return new File(dir, new StringBuilder().append((Object)this.filenamePrefixFromOffset(offset2)).append((Object)this.TxnIndexFileSuffix()).toString());
    }

    public long offsetFromFilename(String filename) {
        return new StringOps(Predef$.MODULE$.augmentString(filename.substring(0, filename.indexOf(46)))).toLong();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public TopicPartition parseTopicPartitionName(File dir) {
        int partition;
        if (dir == null) {
            throw new KafkaException("dir should not be null");
        }
        String dirName = dir.getName();
        if (dirName == null || dirName.isEmpty() || !new StringOps(Predef$.MODULE$.augmentString(dirName)).contains((Object)BoxesRunTime.boxToCharacter((char)'-'))) throw this.exception$1(dir);
        if (dirName.endsWith(this.DeleteDirSuffix()) && !this.DeleteDirPattern().matcher(dirName).matches()) {
            throw this.exception$1(dir);
        }
        String name = dirName.endsWith(this.DeleteDirSuffix()) ? dirName.substring(0, dirName.lastIndexOf(46)) : dirName;
        int index = name.lastIndexOf(45);
        String topic = name.substring(0, index);
        String partitionString = name.substring(index + 1);
        if (topic.isEmpty() || partitionString.isEmpty()) {
            throw this.exception$1(dir);
        }
        try {
            partition = new StringOps(Predef$.MODULE$.augmentString(partitionString)).toInt();
        }
        catch (NumberFormatException numberFormatException) {
            throw this.exception$1(dir);
        }
        return new TopicPartition(topic, partition);
    }

    public boolean kafka$log$Log$$isIndexFile(File file) {
        String filename = file.getName();
        return filename.endsWith(this.IndexFileSuffix()) || filename.endsWith(this.TimeIndexFileSuffix()) || filename.endsWith(this.TxnIndexFileSuffix());
    }

    public boolean kafka$log$Log$$isLogFile(File file) {
        return file.getPath().endsWith(this.LogFileSuffix());
    }

    private final KafkaException exception$1(File dir) {
        return new KafkaException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Found directory ", ", '", "' is not in the form of "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{dir.getCanonicalPath(), dir.getName()}))).append((Object)"topic-partition or topic-partition.uniqueId-delete (if marked for deletion).\n").append((Object)"Kafka's log directories (and children) should only contain Kafka topic data.").toString());
    }

    private Log$() {
        MODULE$ = this;
        this.LogFileSuffix = ".log";
        this.IndexFileSuffix = ".index";
        this.TimeIndexFileSuffix = ".timeindex";
        this.PidSnapshotFileSuffix = ".snapshot";
        this.TxnIndexFileSuffix = ".txnindex";
        this.DeletedFileSuffix = ".deleted";
        this.CleanedFileSuffix = ".cleaned";
        this.SwapFileSuffix = ".swap";
        this.CleanShutdownFile = ".kafka_cleanshutdown";
        this.DeleteDirSuffix = "-delete";
        this.DeleteDirPattern = Pattern.compile(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"^(\\\\S+)-(\\\\S+)\\\\.(\\\\S+)", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.DeleteDirSuffix()})));
        this.UnknownLogStartOffset = -1L;
    }
}

