/*
 * Decompiled with CFR 0.152.
 */
package kafka.controller;

import kafka.api.LeaderAndIsr;
import kafka.api.LeaderAndIsr$;
import kafka.common.LeaderElectionNotNeededException;
import kafka.common.NoReplicaOnlineException;
import kafka.common.StateChangeFailedException;
import kafka.common.TopicAndPartition;
import kafka.controller.Callbacks;
import kafka.controller.ControllerBrokerRequestBatch;
import kafka.controller.ControllerContext;
import kafka.controller.KafkaController;
import kafka.controller.KafkaController$;
import kafka.controller.LeaderIsrAndControllerEpoch;
import kafka.controller.NewPartition$;
import kafka.controller.NoOpLeaderSelector;
import kafka.controller.NonExistentPartition$;
import kafka.controller.OfflinePartition$;
import kafka.controller.OnlinePartition$;
import kafka.controller.PartitionLeaderSelector;
import kafka.controller.PartitionState;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.Logging$class;
import kafka.utils.ReplicationUtils$;
import kafka.utils.ZkUtils;
import kafka.utils.ZkUtils$;
import org.I0Itec.zkclient.exception.ZkNodeExistsException;
import org.apache.log4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@ScalaSignature(bytes="\u0006\u0001\u0005Ee\u0001B\u0001\u0003\u0001\u001d\u0011Q\u0003U1si&$\u0018n\u001c8Ti\u0006$X-T1dQ&tWM\u0003\u0002\u0004\t\u0005Q1m\u001c8ue>dG.\u001a:\u000b\u0003\u0015\tQa[1gW\u0006\u001c\u0001aE\u0002\u0001\u00119\u0001\"!\u0003\u0007\u000e\u0003)Q\u0011aC\u0001\u0006g\u000e\fG.Y\u0005\u0003\u001b)\u0011a!\u00118z%\u00164\u0007CA\b\u0013\u001b\u0005\u0001\"BA\t\u0005\u0003\u0015)H/\u001b7t\u0013\t\u0019\u0002CA\u0004M_\u001e<\u0017N\\4\t\u0011\r\u0001!\u0011!Q\u0001\nU\u0001\"AF\f\u000e\u0003\tI!\u0001\u0007\u0002\u0003\u001f-\u000bgm[1D_:$(o\u001c7mKJDQA\u0007\u0001\u0005\u0002m\ta\u0001P5oSRtDC\u0001\u000f\u001e!\t1\u0002\u0001C\u0003\u00043\u0001\u0007Q\u0003C\u0004 \u0001\t\u0007I\u0011\u0002\u0011\u0002#\r|g\u000e\u001e:pY2,'oQ8oi\u0016DH/F\u0001\"!\t1\"%\u0003\u0002$\u0005\t\t2i\u001c8ue>dG.\u001a:D_:$X\r\u001f;\t\r\u0015\u0002\u0001\u0015!\u0003\"\u0003I\u0019wN\u001c;s_2dWM]\"p]R,\u0007\u0010\u001e\u0011\t\u000f\u001d\u0002!\u0019!C\u0005Q\u0005a1m\u001c8ue>dG.\u001a:JIV\t\u0011\u0006\u0005\u0002\nU%\u00111F\u0003\u0002\u0004\u0013:$\bBB\u0017\u0001A\u0003%\u0011&A\u0007d_:$(o\u001c7mKJLE\r\t\u0005\b_\u0001\u0011\r\u0011\"\u00031\u0003\u001dQ8.\u0016;jYN,\u0012!\r\t\u0003\u001fIJ!a\r\t\u0003\u000fi[W\u000b^5mg\"1Q\u0007\u0001Q\u0001\nE\n\u0001B_6Vi&d7\u000f\t\u0005\bo\u0001\u0011\r\u0011\"\u00039\u00039\u0001\u0018M\u001d;ji&|gn\u0015;bi\u0016,\u0012!\u000f\t\u0005u}\nu)D\u0001<\u0015\taT(A\u0004nkR\f'\r\\3\u000b\u0005yR\u0011AC2pY2,7\r^5p]&\u0011\u0001i\u000f\u0002\u0004\u001b\u0006\u0004\bC\u0001\"F\u001b\u0005\u0019%B\u0001#\u0005\u0003\u0019\u0019w.\\7p]&\u0011ai\u0011\u0002\u0012)>\u0004\u0018nY!oIB\u000b'\u000f^5uS>t\u0007C\u0001\fI\u0013\tI%A\u0001\bQCJ$\u0018\u000e^5p]N#\u0018\r^3\t\r-\u0003\u0001\u0015!\u0003:\u0003=\u0001\u0018M\u001d;ji&|gn\u0015;bi\u0016\u0004\u0003bB'\u0001\u0005\u0004%IAT\u0001\u0013EJ|7.\u001a:SKF,Xm\u001d;CCR\u001c\u0007.F\u0001P!\t1\u0002+\u0003\u0002R\u0005\ta2i\u001c8ue>dG.\u001a:Ce>\\WM\u001d*fcV,7\u000f\u001e\"bi\u000eD\u0007BB*\u0001A\u0003%q*A\nce>\\WM\u001d*fcV,7\u000f\u001e\"bi\u000eD\u0007\u0005C\u0004V\u0001\t\u0007I\u0011\u0002,\u000279|w\n\u001d)beRLG/[8o\u0019\u0016\fG-\u001a:TK2,7\r^8s+\u00059\u0006C\u0001\fY\u0013\tI&A\u0001\nO_>\u0003H*Z1eKJ\u001cV\r\\3di>\u0014\bBB.\u0001A\u0003%q+\u0001\u000fo_>\u0003\b+\u0019:uSRLwN\u001c'fC\u0012,'oU3mK\u000e$xN\u001d\u0011\t\u000fu\u0003!\u0019!C\u0005=\u0006\t2\u000f^1uK\u000eC\u0017M\\4f\u0019><w-\u001a:\u0016\u0003}\u0003\"\u0001Y2\u000f\u0005Y\t\u0017B\u00012\u0003\u0003=Y\u0015MZ6b\u0007>tGO]8mY\u0016\u0014\u0018B\u00013f\u0005E\u0019F/\u0019;f\u0007\"\fgnZ3M_\u001e<WM\u001d\u0006\u0003E\nAaa\u001a\u0001!\u0002\u0013y\u0016AE:uCR,7\t[1oO\u0016dunZ4fe\u0002BQ!\u001b\u0001\u0005\u0002)\fqa\u001d;beR,\b\u000fF\u0001l!\tIA.\u0003\u0002n\u0015\t!QK\\5u\u0011\u0015y\u0007\u0001\"\u0001k\u0003!\u0019\b.\u001e;e_^t\u0007\"B9\u0001\t\u0003Q\u0017!\t;sS\u001e<WM](oY&tW\rU1si&$\u0018n\u001c8Ti\u0006$Xm\u00115b]\u001e,\u0007\"B:\u0001\t\u0003!\u0018!\u00059beRLG/[8og&s7\u000b^1uKR\u0011Q/\u001f\t\u0004m^\fU\"A\u001f\n\u0005al$aA*fi\")!P\u001da\u0001\u000f\u0006)1\u000f^1uK\")A\u0010\u0001C\u0001{\u0006\u0011\u0002.\u00198eY\u0016\u001cF/\u0019;f\u0007\"\fgnZ3t)!Yg0!\u0001\u0002\u0006\u0005=\u0001\"B@|\u0001\u0004)\u0018A\u00039beRLG/[8og\"1\u00111A>A\u0002\u001d\u000b1\u0002^1sO\u0016$8\u000b^1uK\"I\u0011qA>\u0011\u0002\u0003\u0007\u0011\u0011B\u0001\u000fY\u0016\fG-\u001a:TK2,7\r^8s!\r1\u00121B\u0005\u0004\u0003\u001b\u0011!a\u0006)beRLG/[8o\u0019\u0016\fG-\u001a:TK2,7\r^8s\u0011%\t\tb\u001fI\u0001\u0002\u0004\t\u0019\"A\u0005dC2d'-Y2lgB\u0019a#!\u0006\n\u0007\u0005]!AA\u0005DC2d'-Y2lg\"9\u00111\u0004\u0001\u0005\n\u0005u\u0011!\u00055b]\u0012dWm\u0015;bi\u0016\u001c\u0005.\u00198hKRY1.a\b\u00022\u0005U\u0012qGA\u001d\u0011!\t\t#!\u0007A\u0002\u0005\r\u0012!\u0002;pa&\u001c\u0007\u0003BA\u0013\u0003Wq1!CA\u0014\u0013\r\tICC\u0001\u0007!J,G-\u001a4\n\t\u00055\u0012q\u0006\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\u0005%\"\u0002C\u0004\u00024\u0005e\u0001\u0019A\u0015\u0002\u0013A\f'\u000f^5uS>t\u0007bBA\u0002\u00033\u0001\ra\u0012\u0005\t\u0003\u000f\tI\u00021\u0001\u0002\n!A\u0011\u0011CA\r\u0001\u0004\t\u0019\u0002\u0003\u0004\u0002>\u0001!IA[\u0001\u0019S:LG/[1mSj,\u0007+\u0019:uSRLwN\\*uCR,\u0007bBA!\u0001\u0011%\u00111I\u0001\u0016CN\u001cXM\u001d;WC2LG\r\u0016:b]NLG/[8o)\u0015Y\u0017QIA%\u0011\u001d\t9%a\u0010A\u0002\u0005\u000b\u0011\u0003^8qS\u000e\fe\u000e\u001a)beRLG/[8o\u0011\u001d\t\u0019!a\u0010A\u0002\u001dCq!!\u0014\u0001\t\u0013\ty%\u0001\u0012j]&$\u0018.\u00197ju\u0016dU-\u00193fe\u0006sG-S:s\r>\u0014\b+\u0019:uSRLwN\u001c\u000b\u0004W\u0006E\u0003bBA$\u0003\u0017\u0002\r!\u0011\u0005\b\u0003+\u0002A\u0011AA,\u0003])G.Z2u\u0019\u0016\fG-\u001a:G_J\u0004\u0016M\u001d;ji&|g\u000eF\u0004l\u00033\nY&!\u0018\t\u0011\u0005\u0005\u00121\u000ba\u0001\u0003GAq!a\r\u0002T\u0001\u0007\u0011\u0006\u0003\u0005\u0002\b\u0005M\u0003\u0019AA\u0005\u0011\u001d\t\t\u0007\u0001C\u0005\u0003G\nAeZ3u\u0019\u0016\fG-\u001a:JgJ\fe\u000eZ#q_\u000eDwJ\u001d+ie><X\t_2faRLwN\u001c\u000b\u0007\u0003K\nY'!\u001c\u0011\u0007Y\t9'C\u0002\u0002j\t\u00111\u0004T3bI\u0016\u0014\u0018j\u001d:B]\u0012\u001cuN\u001c;s_2dWM]#q_\u000eD\u0007\u0002CA\u0011\u0003?\u0002\r!a\t\t\u000f\u0005M\u0012q\fa\u0001S!I\u0011\u0011\u000f\u0001\u0012\u0002\u0013\u0005\u00111O\u0001\u001dQ\u0006tG\r\\3Ti\u0006$Xm\u00115b]\u001e,7\u000f\n3fM\u0006,H\u000e\u001e\u00134+\t\t)H\u000b\u0003\u0002\n\u0005]4FAA=!\u0011\tY(!\"\u000e\u0005\u0005u$\u0002BA@\u0003\u0003\u000b\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005\r%\"\u0001\u0006b]:|G/\u0019;j_:LA!a\"\u0002~\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\t\u0013\u0005-\u0005!%A\u0005\u0002\u00055\u0015\u0001\b5b]\u0012dWm\u0015;bi\u0016\u001c\u0005.\u00198hKN$C-\u001a4bk2$H\u0005N\u000b\u0003\u0003\u001fSC!a\u0005\u0002x\u0001")
public class PartitionStateMachine
implements Logging {
    public final KafkaController kafka$controller$PartitionStateMachine$$controller;
    private final ControllerContext kafka$controller$PartitionStateMachine$$controllerContext;
    private final int kafka$controller$PartitionStateMachine$$controllerId;
    private final ZkUtils zkUtils;
    private final Map<TopicAndPartition, PartitionState> kafka$controller$PartitionStateMachine$$partitionState;
    private final ControllerBrokerRequestBatch brokerRequestBatch;
    private final NoOpLeaderSelector noOpPartitionLeaderSelector;
    private final KafkaController.StateChangeLogger stateChangeLogger;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    private Logger logger$lzycompute() {
        PartitionStateMachine partitionStateMachine = this;
        synchronized (partitionStateMachine) {
            if (!this.bitmap$0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    @Override
    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    @Override
    public Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    @Override
    public void kafka$utils$Logging$_setter_$loggerName_$eq(String x$1) {
        this.loggerName = x$1;
    }

    @Override
    public void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ x$1) {
        this.kafka$utils$Logging$$log4jController = x$1;
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging$class.trace(this, msg);
    }

    @Override
    public Object trace(Function0<Throwable> e) {
        return Logging$class.trace(this, e);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.trace(this, msg, e);
    }

    @Override
    public void swallowTrace(Function0<BoxedUnit> action) {
        Logging$class.swallowTrace(this, action);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging$class.isDebugEnabled(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging$class.debug(this, msg);
    }

    @Override
    public Object debug(Function0<Throwable> e) {
        return Logging$class.debug(this, e);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.debug(this, msg, e);
    }

    @Override
    public void swallowDebug(Function0<BoxedUnit> action) {
        Logging$class.swallowDebug(this, action);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging$class.info(this, msg);
    }

    @Override
    public Object info(Function0<Throwable> e) {
        return Logging$class.info(this, e);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.info(this, msg, e);
    }

    @Override
    public void swallowInfo(Function0<BoxedUnit> action) {
        Logging$class.swallowInfo(this, action);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging$class.warn(this, msg);
    }

    @Override
    public Object warn(Function0<Throwable> e) {
        return Logging$class.warn(this, e);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.warn(this, msg, e);
    }

    @Override
    public void swallowWarn(Function0<BoxedUnit> action) {
        Logging$class.swallowWarn(this, action);
    }

    @Override
    public void swallow(Function0<BoxedUnit> action) {
        Logging$class.swallow(this, action);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging$class.error(this, msg);
    }

    @Override
    public Object error(Function0<Throwable> e) {
        return Logging$class.error(this, e);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.error(this, msg, e);
    }

    @Override
    public void swallowError(Function0<BoxedUnit> action) {
        Logging$class.swallowError(this, action);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging$class.fatal(this, msg);
    }

    @Override
    public Object fatal(Function0<Throwable> e) {
        return Logging$class.fatal(this, e);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.fatal(this, msg, e);
    }

    public ControllerContext kafka$controller$PartitionStateMachine$$controllerContext() {
        return this.kafka$controller$PartitionStateMachine$$controllerContext;
    }

    public int kafka$controller$PartitionStateMachine$$controllerId() {
        return this.kafka$controller$PartitionStateMachine$$controllerId;
    }

    private ZkUtils zkUtils() {
        return this.zkUtils;
    }

    public Map<TopicAndPartition, PartitionState> kafka$controller$PartitionStateMachine$$partitionState() {
        return this.kafka$controller$PartitionStateMachine$$partitionState;
    }

    private ControllerBrokerRequestBatch brokerRequestBatch() {
        return this.brokerRequestBatch;
    }

    private NoOpLeaderSelector noOpPartitionLeaderSelector() {
        return this.noOpPartitionLeaderSelector;
    }

    private KafkaController.StateChangeLogger stateChangeLogger() {
        return this.stateChangeLogger;
    }

    public void startup() {
        this.initializePartitionState();
        this.triggerOnlinePartitionStateChange();
        this.info((Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PartitionStateMachine $outer;

            public final String apply() {
                return new StringBuilder().append((Object)"Started partition state machine with initial state -> ").append((Object)this.$outer.kafka$controller$PartitionStateMachine$$partitionState().toString()).toString();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    public void shutdown() {
        this.kafka$controller$PartitionStateMachine$$partitionState().clear();
        this.info((Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Stopped partition state machine";
            }
        });
    }

    public void triggerOnlinePartitionStateChange() {
        try {
            this.brokerRequestBatch().newBatch();
            this.kafka$controller$PartitionStateMachine$$partitionState().withFilter((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final boolean apply(Tuple2<TopicAndPartition, PartitionState> check$ifrefutable$1) {
                    Tuple2<TopicAndPartition, PartitionState> tuple2 = check$ifrefutable$1;
                    boolean bl = tuple2 != null;
                    return bl;
                }
            }).withFilter((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ PartitionStateMachine $outer;

                public final boolean apply(Tuple2<TopicAndPartition, PartitionState> x$1) {
                    Tuple2<TopicAndPartition, PartitionState> tuple2 = x$1;
                    if (tuple2 != null) {
                        TopicAndPartition topicAndPartition = (TopicAndPartition)tuple2._1();
                        boolean bl = !this.$outer.kafka$controller$PartitionStateMachine$$controller.topicDeletionManager().isTopicQueuedUpForDeletion(topicAndPartition.topic());
                        return bl;
                    }
                    throw new MatchError(tuple2);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            }).foreach((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ PartitionStateMachine $outer;

                public final void apply(Tuple2<TopicAndPartition, PartitionState> x$2) {
                    Tuple2<TopicAndPartition, PartitionState> tuple2 = x$2;
                    if (tuple2 != null) {
                        BoxedUnit boxedUnit;
                        TopicAndPartition topicAndPartition = (TopicAndPartition)tuple2._1();
                        PartitionState partitionState = (PartitionState)tuple2._2();
                        if (partitionState.equals(OfflinePartition$.MODULE$) || partitionState.equals(NewPartition$.MODULE$)) {
                            this.$outer.kafka$controller$PartitionStateMachine$$handleStateChange(topicAndPartition.topic(), topicAndPartition.partition(), OnlinePartition$.MODULE$, this.$outer.kafka$controller$PartitionStateMachine$$controller.offlinePartitionSelector(), new Callbacks.CallbackBuilder().build());
                            boxedUnit = BoxedUnit.UNIT;
                        } else {
                            boxedUnit = BoxedUnit.UNIT;
                        }
                        BoxedUnit boxedUnit2 = boxedUnit;
                        return;
                    }
                    throw new MatchError(tuple2);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            });
            this.brokerRequestBatch().sendRequestsToBrokers(this.kafka$controller$PartitionStateMachine$$controller.epoch());
        }
        catch (Throwable throwable) {
            this.error((Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Error while moving some partitions to the online state";
                }
            }, (Function0<Throwable>)new Serializable(this, throwable){
                public static final long serialVersionUID = 0L;
                private final Throwable e$1;

                public final Throwable apply() {
                    return this.e$1;
                }
                {
                    this.e$1 = e$1;
                }
            });
        }
    }

    public Set<TopicAndPartition> partitionsInState(PartitionState state) {
        return ((MapLike)this.kafka$controller$PartitionStateMachine$$partitionState().filter((Function1)new Serializable(this, state){
            public static final long serialVersionUID = 0L;
            private final PartitionState state$1;

            public final boolean apply(Tuple2<TopicAndPartition, PartitionState> p) {
                Object object = p._2();
                PartitionState partitionState = this.state$1;
                return !(object != null ? !object.equals(partitionState) : partitionState != null);
            }
            {
                this.state$1 = state$1;
            }
        })).keySet();
    }

    public void handleStateChanges(Set<TopicAndPartition> partitions, PartitionState targetState, PartitionLeaderSelector leaderSelector, Callbacks callbacks) {
        this.info((Function0<String>)new Serializable(this, partitions, targetState){
            public static final long serialVersionUID = 0L;
            private final Set partitions$1;
            private final PartitionState targetState$1;

            public final String apply() {
                return new StringOps(Predef$.MODULE$.augmentString("Invoking state change to %s for partitions %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.targetState$1, this.partitions$1.mkString(",")}));
            }
            {
                this.partitions$1 = partitions$1;
                this.targetState$1 = targetState$1;
            }
        });
        try {
            this.brokerRequestBatch().newBatch();
            partitions.foreach((Function1)new Serializable(this, targetState, leaderSelector, callbacks){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ PartitionStateMachine $outer;
                private final PartitionState targetState$1;
                private final PartitionLeaderSelector leaderSelector$1;
                private final Callbacks callbacks$1;

                public final void apply(TopicAndPartition topicAndPartition) {
                    this.$outer.kafka$controller$PartitionStateMachine$$handleStateChange(topicAndPartition.topic(), topicAndPartition.partition(), this.targetState$1, this.leaderSelector$1, this.callbacks$1);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.targetState$1 = targetState$1;
                    this.leaderSelector$1 = leaderSelector$1;
                    this.callbacks$1 = callbacks$1;
                }
            });
            this.brokerRequestBatch().sendRequestsToBrokers(this.kafka$controller$PartitionStateMachine$$controller.epoch());
        }
        catch (Throwable throwable) {
            this.error((Function0<String>)new Serializable(this, targetState){
                public static final long serialVersionUID = 0L;
                private final PartitionState targetState$1;

                public final String apply() {
                    return new StringOps(Predef$.MODULE$.augmentString("Error while moving some partitions to %s state")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.targetState$1}));
                }
                {
                    this.targetState$1 = targetState$1;
                }
            }, (Function0<Throwable>)new Serializable(this, throwable){
                public static final long serialVersionUID = 0L;
                private final Throwable e$2;

                public final Throwable apply() {
                    return this.e$2;
                }
                {
                    this.e$2 = e$2;
                }
            });
        }
    }

    public void kafka$controller$PartitionStateMachine$$handleStateChange(String topic, int partition, PartitionState targetState, PartitionLeaderSelector leaderSelector, Callbacks callbacks) {
        block12: {
            TopicAndPartition topicAndPartition = new TopicAndPartition(topic, partition);
            PartitionState currState = (PartitionState)this.kafka$controller$PartitionStateMachine$$partitionState().getOrElseUpdate((Object)topicAndPartition, (Function0)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final NonExistentPartition$ apply() {
                    return NonExistentPartition$.MODULE$;
                }
            });
            try {
                this.assertValidTransition(topicAndPartition, targetState);
                PartitionState partitionState = targetState;
                if (NewPartition$.MODULE$.equals(partitionState)) {
                    this.kafka$controller$PartitionStateMachine$$partitionState().put((Object)topicAndPartition, (Object)NewPartition$.MODULE$);
                    String assignedReplicas = ((TraversableOnce)this.kafka$controller$PartitionStateMachine$$controllerContext().partitionReplicaAssignment().apply((Object)topicAndPartition)).mkString(",");
                    this.stateChangeLogger().trace((Function0<String>)new Serializable(this, targetState, topicAndPartition, currState, assignedReplicas){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ PartitionStateMachine $outer;
                        private final PartitionState targetState$2;
                        private final TopicAndPartition topicAndPartition$1;
                        private final PartitionState currState$1;
                        private final String assignedReplicas$1;

                        public final String apply() {
                            return new StringOps(Predef$.MODULE$.augmentString("Controller %d epoch %d changed partition %s state from %s to %s with assigned replicas %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.$outer.kafka$controller$PartitionStateMachine$$controllerId()), BoxesRunTime.boxToInteger((int)this.$outer.kafka$controller$PartitionStateMachine$$controller.epoch()), this.topicAndPartition$1, this.currState$1, this.targetState$2, this.assignedReplicas$1}));
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.targetState$2 = targetState$2;
                            this.topicAndPartition$1 = topicAndPartition$1;
                            this.currState$1 = currState$1;
                            this.assignedReplicas$1 = assignedReplicas$1;
                        }
                    });
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break block12;
                }
                if (OnlinePartition$.MODULE$.equals(partitionState)) {
                    PartitionState partitionState2 = (PartitionState)this.kafka$controller$PartitionStateMachine$$partitionState().apply((Object)topicAndPartition);
                    if (NewPartition$.MODULE$.equals(partitionState2)) {
                        this.initializeLeaderAndIsrForPartition(topicAndPartition);
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    } else if (OfflinePartition$.MODULE$.equals(partitionState2)) {
                        this.electLeaderForPartition(topic, partition, leaderSelector);
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    } else if (OnlinePartition$.MODULE$.equals(partitionState2)) {
                        this.electLeaderForPartition(topic, partition, leaderSelector);
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    } else {
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    }
                    this.kafka$controller$PartitionStateMachine$$partitionState().put((Object)topicAndPartition, (Object)OnlinePartition$.MODULE$);
                    int leader = ((LeaderIsrAndControllerEpoch)this.kafka$controller$PartitionStateMachine$$controllerContext().partitionLeadershipInfo().apply((Object)topicAndPartition)).leaderAndIsr().leader();
                    this.stateChangeLogger().trace((Function0<String>)new Serializable(this, targetState, topicAndPartition, currState, leader){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ PartitionStateMachine $outer;
                        private final PartitionState targetState$2;
                        private final TopicAndPartition topicAndPartition$1;
                        private final PartitionState currState$1;
                        private final int leader$1;

                        public final String apply() {
                            return new StringOps(Predef$.MODULE$.augmentString("Controller %d epoch %d changed partition %s from %s to %s with leader %d")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.$outer.kafka$controller$PartitionStateMachine$$controllerId()), BoxesRunTime.boxToInteger((int)this.$outer.kafka$controller$PartitionStateMachine$$controller.epoch()), this.topicAndPartition$1, this.currState$1, this.targetState$2, BoxesRunTime.boxToInteger((int)this.leader$1)}));
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.targetState$2 = targetState$2;
                            this.topicAndPartition$1 = topicAndPartition$1;
                            this.currState$1 = currState$1;
                            this.leader$1 = leader$1;
                        }
                    });
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break block12;
                }
                if (OfflinePartition$.MODULE$.equals(partitionState)) {
                    this.stateChangeLogger().trace((Function0<String>)new Serializable(this, targetState, topicAndPartition, currState){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ PartitionStateMachine $outer;
                        private final PartitionState targetState$2;
                        private final TopicAndPartition topicAndPartition$1;
                        private final PartitionState currState$1;

                        public final String apply() {
                            return new StringOps(Predef$.MODULE$.augmentString("Controller %d epoch %d changed partition %s state from %s to %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.$outer.kafka$controller$PartitionStateMachine$$controllerId()), BoxesRunTime.boxToInteger((int)this.$outer.kafka$controller$PartitionStateMachine$$controller.epoch()), this.topicAndPartition$1, this.currState$1, this.targetState$2}));
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.targetState$2 = targetState$2;
                            this.topicAndPartition$1 = topicAndPartition$1;
                            this.currState$1 = currState$1;
                        }
                    });
                    this.kafka$controller$PartitionStateMachine$$partitionState().put((Object)topicAndPartition, (Object)OfflinePartition$.MODULE$);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break block12;
                }
                if (NonExistentPartition$.MODULE$.equals(partitionState)) {
                    this.stateChangeLogger().trace((Function0<String>)new Serializable(this, targetState, topicAndPartition, currState){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ PartitionStateMachine $outer;
                        private final PartitionState targetState$2;
                        private final TopicAndPartition topicAndPartition$1;
                        private final PartitionState currState$1;

                        public final String apply() {
                            return new StringOps(Predef$.MODULE$.augmentString("Controller %d epoch %d changed partition %s state from %s to %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.$outer.kafka$controller$PartitionStateMachine$$controllerId()), BoxesRunTime.boxToInteger((int)this.$outer.kafka$controller$PartitionStateMachine$$controller.epoch()), this.topicAndPartition$1, this.currState$1, this.targetState$2}));
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.targetState$2 = targetState$2;
                            this.topicAndPartition$1 = topicAndPartition$1;
                            this.currState$1 = currState$1;
                        }
                    });
                    this.kafka$controller$PartitionStateMachine$$partitionState().put((Object)topicAndPartition, (Object)NonExistentPartition$.MODULE$);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break block12;
                }
                throw new MatchError((Object)partitionState);
            }
            catch (Throwable throwable) {
                this.stateChangeLogger().error((Function0<String>)new Serializable(this, targetState, topicAndPartition, currState){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ PartitionStateMachine $outer;
                    private final PartitionState targetState$2;
                    private final TopicAndPartition topicAndPartition$1;
                    private final PartitionState currState$1;

                    public final String apply() {
                        return new StringOps(Predef$.MODULE$.augmentString("Controller %d epoch %d initiated state change for partition %s from %s to %s failed")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.$outer.kafka$controller$PartitionStateMachine$$controllerId()), BoxesRunTime.boxToInteger((int)this.$outer.kafka$controller$PartitionStateMachine$$controller.epoch()), this.topicAndPartition$1, this.currState$1, this.targetState$2}));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.targetState$2 = targetState$2;
                        this.topicAndPartition$1 = topicAndPartition$1;
                        this.currState$1 = currState$1;
                    }
                }, (Function0<Throwable>)new Serializable(this, throwable){
                    public static final long serialVersionUID = 0L;
                    private final Throwable t$1;

                    public final Throwable apply() {
                        return this.t$1;
                    }
                    {
                        this.t$1 = t$1;
                    }
                });
            }
        }
    }

    public PartitionLeaderSelector handleStateChanges$default$3() {
        return this.noOpPartitionLeaderSelector();
    }

    public Callbacks handleStateChanges$default$4() {
        return new Callbacks.CallbackBuilder().build();
    }

    private void initializePartitionState() {
        this.kafka$controller$PartitionStateMachine$$controllerContext().partitionReplicaAssignment().keys().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PartitionStateMachine $outer;

            public final Option<PartitionState> apply(TopicAndPartition topicPartition) {
                Option option;
                block4: {
                    Option option2;
                    block3: {
                        block2: {
                            option = this.$outer.kafka$controller$PartitionStateMachine$$controllerContext().partitionLeadershipInfo().get((Object)topicPartition);
                            if (!(option instanceof Some)) break block2;
                            Some some = (Some)option;
                            LeaderIsrAndControllerEpoch currentLeaderIsrAndEpoch = (LeaderIsrAndControllerEpoch)some.x();
                            option2 = this.$outer.kafka$controller$PartitionStateMachine$$controllerContext().liveBrokerIds().contains((Object)BoxesRunTime.boxToInteger((int)currentLeaderIsrAndEpoch.leaderAndIsr().leader())) ? this.$outer.kafka$controller$PartitionStateMachine$$partitionState().put((Object)topicPartition, (Object)OnlinePartition$.MODULE$) : this.$outer.kafka$controller$PartitionStateMachine$$partitionState().put((Object)topicPartition, (Object)OfflinePartition$.MODULE$);
                            break block3;
                        }
                        if (!None$.MODULE$.equals(option)) break block4;
                        option2 = this.$outer.kafka$controller$PartitionStateMachine$$partitionState().put((Object)topicPartition, (Object)NewPartition$.MODULE$);
                    }
                    return option2;
                }
                throw new MatchError((Object)option);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    private void assertValidTransition(TopicAndPartition topicAndPartition, PartitionState targetState) {
        if (targetState.validPreviousStates().contains(this.kafka$controller$PartitionStateMachine$$partitionState().apply((Object)topicAndPartition))) {
            return;
        }
        throw new IllegalStateException(new StringBuilder().append((Object)new StringOps(Predef$.MODULE$.augmentString("Partition %s should be in the %s states before moving to %s state")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topicAndPartition, targetState.validPreviousStates().mkString(","), targetState}))).append((Object)new StringOps(Predef$.MODULE$.augmentString(". Instead it is in %s state")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.kafka$controller$PartitionStateMachine$$partitionState().apply((Object)topicAndPartition)}))).toString());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void initializeLeaderAndIsrForPartition(TopicAndPartition topicAndPartition) {
        Set<Object> set;
        List replicaAssignment = ((TraversableOnce)this.kafka$controller$PartitionStateMachine$$controllerContext().partitionReplicaAssignment().apply((Object)topicAndPartition)).toList();
        List liveAssignedReplicas = (List)replicaAssignment.filter((Function1)new Serializable(this, set = this.kafka$controller$PartitionStateMachine$$controllerContext().liveBrokerIds()){
            public static final long serialVersionUID = 0L;
            private final Set eta$0$1$1;

            public final boolean apply(int elem) {
                return this.apply$mcZI$sp(elem);
            }

            public boolean apply$mcZI$sp(int elem) {
                return this.eta$0$1$1.contains((Object)BoxesRunTime.boxToInteger((int)elem));
            }
            {
                this.eta$0$1$1 = eta$0$1$1;
            }
        });
        Option option = liveAssignedReplicas.headOption();
        if (None$.MODULE$.equals(option)) {
            String failMsg = new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Controller ", " epoch ", " encountered error during state change of "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.kafka$controller$PartitionStateMachine$$controllerId()), BoxesRunTime.boxToInteger((int)this.kafka$controller$PartitionStateMachine$$controller.epoch())}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"partition ", " from New to Online, assigned replicas are "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topicAndPartition}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"[", "], live brokers are [", "]. No assigned "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{replicaAssignment.mkString(","), this.kafka$controller$PartitionStateMachine$$controllerContext().liveBrokerIds()}))).append((Object)"replica is alive.").toString();
            this.stateChangeLogger().error((Function0<String>)new Serializable(this, failMsg){
                public static final long serialVersionUID = 0L;
                private final String failMsg$1;

                public final String apply() {
                    return this.failMsg$1;
                }
                {
                    this.failMsg$1 = failMsg$1;
                }
            });
            throw new StateChangeFailedException(failMsg);
        }
        if (!(option instanceof Some)) throw new MatchError((Object)option);
        Some some = (Some)option;
        int leader = BoxesRunTime.unboxToInt((Object)some.x());
        this.debug((Function0<String>)new Serializable(this, topicAndPartition, liveAssignedReplicas){
            public static final long serialVersionUID = 0L;
            private final TopicAndPartition topicAndPartition$2;
            private final List liveAssignedReplicas$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Live assigned replicas for partition ", " are: [", "]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topicAndPartition$2, this.liveAssignedReplicas$1}));
            }
            {
                this.topicAndPartition$2 = topicAndPartition$2;
                this.liveAssignedReplicas$1 = liveAssignedReplicas$1;
            }
        });
        LeaderAndIsr leaderAndIsr = LeaderAndIsr$.MODULE$.apply(leader, (List<Object>)liveAssignedReplicas);
        LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch = new LeaderIsrAndControllerEpoch(leaderAndIsr, this.kafka$controller$PartitionStateMachine$$controller.epoch());
        this.debug((Function0<String>)new Serializable(this, topicAndPartition, leaderIsrAndControllerEpoch){
            public static final long serialVersionUID = 0L;
            private final TopicAndPartition topicAndPartition$2;
            private final LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Initializing leader and isr for partition ", " to ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topicAndPartition$2, this.leaderIsrAndControllerEpoch$1}));
            }
            {
                this.topicAndPartition$2 = topicAndPartition$2;
                this.leaderIsrAndControllerEpoch$1 = leaderIsrAndControllerEpoch$1;
            }
        });
        try {
            this.zkUtils().createPersistentPath(ZkUtils$.MODULE$.getTopicPartitionLeaderAndIsrPath(topicAndPartition.topic(), topicAndPartition.partition()), this.zkUtils().leaderAndIsrZkData(leaderAndIsr, this.kafka$controller$PartitionStateMachine$$controller.epoch()), this.zkUtils().createPersistentPath$default$3());
            this.kafka$controller$PartitionStateMachine$$controllerContext().partitionLeadershipInfo().put((Object)topicAndPartition, (Object)leaderIsrAndControllerEpoch);
            this.brokerRequestBatch().addLeaderAndIsrRequestForBrokers((Seq<Object>)liveAssignedReplicas, topicAndPartition.topic(), topicAndPartition.partition(), leaderIsrAndControllerEpoch, (Seq<Object>)replicaAssignment, this.brokerRequestBatch().addLeaderAndIsrRequestForBrokers$default$6());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return;
        }
        catch (ZkNodeExistsException zkNodeExistsException) {
            LeaderIsrAndControllerEpoch leaderIsrAndEpoch = (LeaderIsrAndControllerEpoch)ReplicationUtils$.MODULE$.getLeaderIsrAndEpochForPartition(this.zkUtils(), topicAndPartition.topic(), topicAndPartition.partition()).get();
            String failMsg = new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Controller ", " epoch ", " encountered error while changing "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.kafka$controller$PartitionStateMachine$$controllerId()), BoxesRunTime.boxToInteger((int)this.kafka$controller$PartitionStateMachine$$controller.epoch())}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"partition ", "'s state from New to Online since LeaderAndIsr path already exists with "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topicAndPartition}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"value ", " and controller epoch ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{leaderIsrAndEpoch.leaderAndIsr(), BoxesRunTime.boxToInteger((int)leaderIsrAndEpoch.controllerEpoch())}))).toString();
            this.stateChangeLogger().error((Function0<String>)new Serializable(this, failMsg){
                public static final long serialVersionUID = 0L;
                private final String failMsg$2;

                public final String apply() {
                    return this.failMsg$2;
                }
                {
                    this.failMsg$2 = failMsg$2;
                }
            });
            throw new StateChangeFailedException(failMsg);
        }
    }

    public void electLeaderForPartition(String topic, int partition, PartitionLeaderSelector leaderSelector) {
        TopicAndPartition topicAndPartition = new TopicAndPartition(topic, partition);
        this.stateChangeLogger().trace((Function0<String>)new Serializable(this, topicAndPartition){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PartitionStateMachine $outer;
            private final TopicAndPartition topicAndPartition$3;

            public final String apply() {
                return new StringOps(Predef$.MODULE$.augmentString("Controller %d epoch %d started leader election for partition %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.$outer.kafka$controller$PartitionStateMachine$$controllerId()), BoxesRunTime.boxToInteger((int)this.$outer.kafka$controller$PartitionStateMachine$$controller.epoch()), this.topicAndPartition$3}));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.topicAndPartition$3 = topicAndPartition$3;
            }
        });
        try {
            Seq replicasForThisPartition;
            ObjectRef newLeaderAndIsr;
            block6: {
                Tuple2<LeaderAndIsr, Seq<Object>> tuple2;
                block7: {
                    Tuple2<Object, Object> tuple22;
                    boolean zookeeperPathUpdateSucceeded = false;
                    newLeaderAndIsr = ObjectRef.create(null);
                    replicasForThisPartition = (Seq)Seq$.MODULE$.empty();
                    while (true) {
                        Tuple2.mcZI.sp sp2;
                        Tuple2 tuple23;
                        if (zookeeperPathUpdateSucceeded) break block6;
                        LeaderIsrAndControllerEpoch currentLeaderIsrAndEpoch = this.getLeaderIsrAndEpochOrThrowException(topic, partition);
                        LeaderAndIsr currentLeaderAndIsr = currentLeaderIsrAndEpoch.leaderAndIsr();
                        int controllerEpoch = currentLeaderIsrAndEpoch.controllerEpoch();
                        if (controllerEpoch > this.kafka$controller$PartitionStateMachine$$controller.epoch()) {
                            String failMsg = new StringOps(Predef$.MODULE$.augmentString("aborted leader election for partition [%s,%d] since the LeaderAndIsr path was already written by another controller. This probably means that the current controller %d went through a soft failure and another controller was elected with epoch %d.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topic, BoxesRunTime.boxToInteger((int)partition), BoxesRunTime.boxToInteger((int)this.kafka$controller$PartitionStateMachine$$controllerId()), BoxesRunTime.boxToInteger((int)controllerEpoch)}));
                            this.stateChangeLogger().error((Function0<String>)new Serializable(this, failMsg){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ PartitionStateMachine $outer;
                                private final String failMsg$3;

                                public final String apply() {
                                    return new StringBuilder().append((Object)new StringOps(Predef$.MODULE$.augmentString("Controller %d epoch %d ")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.$outer.kafka$controller$PartitionStateMachine$$controllerId()), BoxesRunTime.boxToInteger((int)this.$outer.kafka$controller$PartitionStateMachine$$controller.epoch())}))).append((Object)this.failMsg$3).toString();
                                }
                                {
                                    if ($outer == null) {
                                        throw null;
                                    }
                                    this.$outer = $outer;
                                    this.failMsg$3 = failMsg$3;
                                }
                            });
                            throw new StateChangeFailedException(failMsg);
                        }
                        tuple2 = leaderSelector.selectLeader(topicAndPartition, currentLeaderAndIsr);
                        if (tuple2 == null) break block7;
                        LeaderAndIsr leaderAndIsr = (LeaderAndIsr)tuple2._1();
                        Seq replicas = (Seq)tuple2._2();
                        Tuple2 tuple24 = tuple23 = new Tuple2((Object)leaderAndIsr, (Object)replicas);
                        LeaderAndIsr leaderAndIsr2 = (LeaderAndIsr)tuple24._1();
                        Seq replicas2 = (Seq)tuple24._2();
                        tuple22 = ReplicationUtils$.MODULE$.updateLeaderAndIsr(this.zkUtils(), topic, partition, leaderAndIsr2, this.kafka$controller$PartitionStateMachine$$controller.epoch(), currentLeaderAndIsr.zkVersion());
                        if (tuple22 == null) break;
                        boolean updateSucceeded = tuple22._1$mcZ$sp();
                        int newVersion = tuple22._2$mcI$sp();
                        Tuple2.mcZI.sp sp3 = sp2 = new Tuple2.mcZI.sp(updateSucceeded, newVersion);
                        boolean updateSucceeded2 = sp3._1$mcZ$sp();
                        int newVersion2 = sp3._2$mcI$sp();
                        var9_6.elem = leaderAndIsr2.withZkVersion(newVersion2);
                        boolean bl = updateSucceeded2;
                        Seq seq = replicas2;
                    }
                    throw new MatchError(tuple22);
                }
                throw new MatchError(tuple2);
            }
            LeaderIsrAndControllerEpoch newLeaderIsrAndControllerEpoch = new LeaderIsrAndControllerEpoch((LeaderAndIsr)newLeaderAndIsr.elem, this.kafka$controller$PartitionStateMachine$$controller.epoch());
            this.kafka$controller$PartitionStateMachine$$controllerContext().partitionLeadershipInfo().put((Object)new TopicAndPartition(topic, partition), (Object)newLeaderIsrAndControllerEpoch);
            this.stateChangeLogger().trace((Function0<String>)new Serializable(this, topicAndPartition, newLeaderAndIsr){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ PartitionStateMachine $outer;
                private final TopicAndPartition topicAndPartition$3;
                private final ObjectRef newLeaderAndIsr$1;

                public final String apply() {
                    return new StringOps(Predef$.MODULE$.augmentString("Controller %d epoch %d elected leader %d for Offline partition %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.$outer.kafka$controller$PartitionStateMachine$$controllerId()), BoxesRunTime.boxToInteger((int)this.$outer.kafka$controller$PartitionStateMachine$$controller.epoch()), BoxesRunTime.boxToInteger((int)((LeaderAndIsr)this.newLeaderAndIsr$1.elem).leader()), this.topicAndPartition$3}));
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.topicAndPartition$3 = topicAndPartition$3;
                    this.newLeaderAndIsr$1 = newLeaderAndIsr$1;
                }
            });
            Seq replicas = (Seq)this.kafka$controller$PartitionStateMachine$$controllerContext().partitionReplicaAssignment().apply((Object)new TopicAndPartition(topic, partition));
            this.brokerRequestBatch().addLeaderAndIsrRequestForBrokers((Seq<Object>)replicasForThisPartition, topic, partition, newLeaderIsrAndControllerEpoch, (Seq<Object>)replicas, this.brokerRequestBatch().addLeaderAndIsrRequestForBrokers$default$6());
        }
        catch (Throwable throwable) {
            String failMsg = new StringOps(Predef$.MODULE$.augmentString("encountered error while electing leader for partition %s due to: %s.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topicAndPartition, throwable.getMessage()}));
            this.stateChangeLogger().error((Function0<String>)new Serializable(this, failMsg){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ PartitionStateMachine $outer;
                private final String failMsg$4;

                public final String apply() {
                    return new StringBuilder().append((Object)new StringOps(Predef$.MODULE$.augmentString("Controller %d epoch %d ")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.$outer.kafka$controller$PartitionStateMachine$$controllerId()), BoxesRunTime.boxToInteger((int)this.$outer.kafka$controller$PartitionStateMachine$$controller.epoch())}))).append((Object)this.failMsg$4).toString();
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.failMsg$4 = failMsg$4;
                }
            });
            throw new StateChangeFailedException(failMsg, throwable);
        }
        catch (NoReplicaOnlineException noReplicaOnlineException) {
            throw noReplicaOnlineException;
        }
        catch (LeaderElectionNotNeededException leaderElectionNotNeededException) {}
        this.debug((Function0<String>)new Serializable(this, topicAndPartition){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PartitionStateMachine $outer;
            private final TopicAndPartition topicAndPartition$3;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"After leader election, leader cache for ", " is updated to ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topicAndPartition$3, this.$outer.kafka$controller$PartitionStateMachine$$controllerContext().partitionLeadershipInfo().apply((Object)this.topicAndPartition$3)}));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.topicAndPartition$3 = topicAndPartition$3;
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    private LeaderIsrAndControllerEpoch getLeaderIsrAndEpochOrThrowException(String topic, int partition) {
        TopicAndPartition topicAndPartition = new TopicAndPartition(topic, partition);
        Option<LeaderIsrAndControllerEpoch> option = ReplicationUtils$.MODULE$.getLeaderIsrAndEpochForPartition(this.zkUtils(), topic, partition);
        if (option instanceof Some) {
            LeaderIsrAndControllerEpoch currentLeaderIsrAndEpoch;
            Some some = (Some)option;
            LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch = currentLeaderIsrAndEpoch = (LeaderIsrAndControllerEpoch)some.x();
            return leaderIsrAndControllerEpoch;
        }
        if (None$.MODULE$.equals(option)) {
            void var3_3;
            String failMsg = new StringOps(Predef$.MODULE$.augmentString("LeaderAndIsr information doesn't exist for partition %s in %s state")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{var3_3, this.kafka$controller$PartitionStateMachine$$partitionState().apply((Object)var3_3)}));
            throw new StateChangeFailedException(failMsg);
        }
        throw new MatchError(option);
    }

    public PartitionStateMachine(KafkaController controller) {
        this.kafka$controller$PartitionStateMachine$$controller = controller;
        Logging$class.$init$(this);
        this.kafka$controller$PartitionStateMachine$$controllerContext = controller.controllerContext();
        this.kafka$controller$PartitionStateMachine$$controllerId = controller.config().brokerId();
        this.zkUtils = this.kafka$controller$PartitionStateMachine$$controllerContext().zkUtils();
        this.kafka$controller$PartitionStateMachine$$partitionState = Map$.MODULE$.empty();
        this.brokerRequestBatch = new ControllerBrokerRequestBatch(controller);
        this.noOpPartitionLeaderSelector = new NoOpLeaderSelector(this.kafka$controller$PartitionStateMachine$$controllerContext());
        this.stateChangeLogger = KafkaController$.MODULE$.stateChangeLogger();
        this.logIdent_$eq(new StringBuilder().append((Object)"[Partition state machine on Controller ").append((Object)BoxesRunTime.boxToInteger((int)this.kafka$controller$PartitionStateMachine$$controllerId())).append((Object)"]: ").toString());
    }
}

