/*
 * Decompiled with CFR 0.152.
 */
package kafka.admin;

import kafka.admin.AdminOperationException;
import kafka.admin.RackAwareMode;
import kafka.api.PartitionMetadata;
import kafka.api.TopicMetadata;
import kafka.client.ClientUtils$;
import kafka.cluster.Broker;
import kafka.cluster.BrokerEndPoint;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.utils.TestUtils$;
import kafka.zk.AdminZkClient;
import kafka.zk.ZooKeeperTestHarness;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.InvalidReplicaAssignmentException;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Prettifier$;
import org.scalactic.source.Position;
import scala.Function1;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq$;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0001\u0005-f\u0001B\u0001\u0003\u0001\u001d\u0011\u0011#\u00113e!\u0006\u0014H/\u001b;j_:\u001cH+Z:u\u0015\t\u0019A!A\u0003bI6LgNC\u0001\u0006\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019\"\u0001\u0001\u0005\u0011\u0005%aQ\"\u0001\u0006\u000b\u0005-!\u0011A\u0001>l\u0013\ti!B\u0001\u000b[_>\\U-\u001a9feR+7\u000f\u001e%be:,7o\u001d\u0005\u0006\u001f\u0001!\t\u0001E\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003E\u0001\"A\u0005\u0001\u000e\u0003\tAq\u0001\u0006\u0001A\u0002\u0013\u0005Q#A\u0004d_:4\u0017nZ:\u0016\u0003Y\u00012aF\u0011%\u001d\tAbD\u0004\u0002\u001a95\t!D\u0003\u0002\u001c\r\u00051AH]8pizJ\u0011!H\u0001\u0006g\u000e\fG.Y\u0005\u0003?\u0001\nq\u0001]1dW\u0006<WMC\u0001\u001e\u0013\t\u00113EA\u0002TKFT!a\b\u0011\u0011\u0005\u0015BS\"\u0001\u0014\u000b\u0005\u001d\"\u0011AB:feZ,'/\u0003\u0002*M\tY1*\u00194lC\u000e{gNZ5h\u0011\u001dY\u0003\u00011A\u0005\u00021\n1bY8oM&<7o\u0018\u0013fcR\u0011Q&\r\t\u0003]=j\u0011\u0001I\u0005\u0003a\u0001\u0012A!\u00168ji\"9!GKA\u0001\u0002\u00041\u0012a\u0001=%c!1A\u0007\u0001Q!\nY\t\u0001bY8oM&<7\u000f\t\u0005\bm\u0001\u0001\r\u0011\"\u00018\u0003\u001d\u0019XM\u001d<feN,\u0012\u0001\u000f\t\u0004/\u0005J\u0004CA\u0013;\u0013\tYdEA\u0006LC\u001a\\\u0017mU3sm\u0016\u0014\bbB\u001f\u0001\u0001\u0004%\tAP\u0001\fg\u0016\u0014h/\u001a:t?\u0012*\u0017\u000f\u0006\u0002.\u007f!9!\u0007PA\u0001\u0002\u0004A\u0004BB!\u0001A\u0003&\u0001(\u0001\u0005tKJ4XM]:!\u0011\u001d\u0019\u0005\u00011A\u0005\u0002\u0011\u000bqA\u0019:pW\u0016\u00148/F\u0001F!\r9\u0012E\u0012\t\u0003\u000f*k\u0011\u0001\u0013\u0006\u0003\u0013\u0012\tqa\u00197vgR,'/\u0003\u0002L\u0011\n1!I]8lKJDq!\u0014\u0001A\u0002\u0013\u0005a*A\u0006ce>\\WM]:`I\u0015\fHCA\u0017P\u0011\u001d\u0011D*!AA\u0002\u0015Ca!\u0015\u0001!B\u0013)\u0015\u0001\u00032s_.,'o\u001d\u0011\t\u000fM\u0003!\u0019!C\u0001)\u0006Y\u0001/\u0019:uSRLwN\\%e+\u0005)\u0006C\u0001\u0018W\u0013\t9\u0006EA\u0002J]RDa!\u0017\u0001!\u0002\u0013)\u0016\u0001\u00049beRLG/[8o\u0013\u0012\u0004\u0003bB.\u0001\u0005\u0004%\t\u0001X\u0001\u0007i>\u0004\u0018nY\u0019\u0016\u0003u\u0003\"AX2\u000e\u0003}S!\u0001Y1\u0002\t1\fgn\u001a\u0006\u0002E\u0006!!.\u0019<b\u0013\t!wL\u0001\u0004TiJLgn\u001a\u0005\u0007M\u0002\u0001\u000b\u0011B/\u0002\u000fQ|\u0007/[22A!9\u0001\u000e\u0001b\u0001\n\u0003I\u0017\u0001\u0005;pa&\u001c\u0017'Q:tS\u001etW.\u001a8u+\u0005Q\u0007\u0003B6q+Jl\u0011\u0001\u001c\u0006\u0003[:\f\u0011\"[7nkR\f'\r\\3\u000b\u0005=\u0004\u0013AC2pY2,7\r^5p]&\u0011\u0011\u000f\u001c\u0002\u0004\u001b\u0006\u0004\bcA:u+6\ta.\u0003\u0002#]\"1a\u000f\u0001Q\u0001\n)\f\u0011\u0003^8qS\u000e\f\u0014i]:jO:lWM\u001c;!\u0011\u001dA\bA1A\u0005\u0002q\u000ba\u0001^8qS\u000e\u0014\u0004B\u0002>\u0001A\u0003%Q,A\u0004u_BL7M\r\u0011\t\u000fq\u0004!\u0019!C\u0001S\u0006\u0001Bo\u001c9jGJ\n5o]5h]6,g\u000e\u001e\u0005\u0007}\u0002\u0001\u000b\u0011\u00026\u0002#Q|\u0007/[23\u0003N\u001c\u0018n\u001a8nK:$\b\u0005\u0003\u0005\u0002\u0002\u0001\u0011\r\u0011\"\u0001]\u0003\u0019!x\u000e]5dg!9\u0011Q\u0001\u0001!\u0002\u0013i\u0016a\u0002;pa&\u001c7\u0007\t\u0005\t\u0003\u0013\u0001!\u0019!C\u0001S\u0006\u0001Bo\u001c9jGN\n5o]5h]6,g\u000e\u001e\u0005\b\u0003\u001b\u0001\u0001\u0015!\u0003k\u0003E!x\u000e]5dg\u0005\u001b8/[4o[\u0016tG\u000f\t\u0005\t\u0003#\u0001!\u0019!C\u00019\u00061Ao\u001c9jGRBq!!\u0006\u0001A\u0003%Q,A\u0004u_BL7\r\u000e\u0011\t\u0011\u0005e\u0001A1A\u0005\u0002%\f\u0001\u0003^8qS\u000e$\u0014i]:jO:lWM\u001c;\t\u000f\u0005u\u0001\u0001)A\u0005U\u0006\tBo\u001c9jGR\n5o]5h]6,g\u000e\u001e\u0011\t\u0011\u0005\u0005\u0002A1A\u0005\u0002q\u000ba\u0001^8qS\u000e,\u0004bBA\u0013\u0001\u0001\u0006I!X\u0001\bi>\u0004\u0018nY\u001b!\u0011!\tI\u0003\u0001b\u0001\n\u0003I\u0017\u0001\u0005;pa&\u001cW'Q:tS\u001etW.\u001a8u\u0011\u001d\ti\u0003\u0001Q\u0001\n)\f\u0011\u0003^8qS\u000e,\u0014i]:jO:lWM\u001c;!\u0011\u001d\t\t\u0004\u0001C!\u0003g\tQa]3u+B$\u0012!\f\u0015\u0005\u0003_\t9\u0004\u0005\u0003\u0002:\u0005\rSBAA\u001e\u0015\u0011\ti$a\u0010\u0002\u000b),h.\u001b;\u000b\u0005\u0005\u0005\u0013aA8sO&!\u0011QIA\u001e\u0005\u0019\u0011UMZ8sK\"9\u0011\u0011\n\u0001\u0005B\u0005M\u0012\u0001\u0003;fCJ$un\u001e8)\t\u0005\u001d\u0013Q\n\t\u0005\u0003s\ty%\u0003\u0003\u0002R\u0005m\"!B!gi\u0016\u0014\bbBA+\u0001\u0011\u0005\u00111G\u0001\u0016i\u0016\u001cHo\u0016:p]\u001e\u0014V\r\u001d7jG\u0006\u001cu.\u001e8uQ\u0011\t\u0019&!\u0017\u0011\t\u0005e\u00121L\u0005\u0005\u0003;\nYD\u0001\u0003UKN$\bbBA1\u0001\u0011\u0005\u00111G\u0001\u0016i\u0016\u001cH/T5tg&tw\rU1si&$\u0018n\u001c81Q\u0011\ty&!\u0017\t\u000f\u0005\u001d\u0004\u0001\"\u0001\u00024\u00059B/Z:u\u0013:\u001c'/Z7f]R\u0004\u0016M\u001d;ji&|gn\u001d\u0015\u0005\u0003K\nI\u0006C\u0004\u0002n\u0001!\t!a\r\u0002=Q,7\u000f^'b]V\fG.Q:tS\u001etW.\u001a8u\u001f\u001a\u0014V\r\u001d7jG\u0006\u001c\b\u0006BA6\u00033Bq!a\u001d\u0001\t\u0003\t\u0019$\u0001\u0010uKN$(+\u001a9mS\u000e\f\u0007\u000b\\1dK6,g\u000e^!mYN+'O^3sg\"\"\u0011\u0011OA-\u0011\u001d\tI\b\u0001C\u0001\u0003g\t!\u0005^3tiJ+\u0007\u000f\\5dCBc\u0017mY3nK:$\b+\u0019:uS\u0006d7+\u001a:wKJ\u001c\b\u0006BA<\u00033Bq!a \u0001\t\u0003\t\t)A\rwC2LG-\u0019;f\u0019\u0016\fG-\u001a:B]\u0012\u0014V\r\u001d7jG\u0006\u001cH#C\u0017\u0002\u0004\u0006M\u0015QSAM\u0011!\t))! A\u0002\u0005\u001d\u0015\u0001C7fi\u0006$\u0017\r^1\u0011\t\u0005%\u0015qR\u0007\u0003\u0003\u0017S1!!$\u0005\u0003\r\t\u0007/[\u0005\u0005\u0003#\u000bYIA\u0007U_BL7-T3uC\u0012\fG/\u0019\u0005\u0007'\u0006u\u0004\u0019A+\t\u000f\u0005]\u0015Q\u0010a\u0001+\u0006\u0001R\r\u001f9fGR,G\rT3bI\u0016\u0014\u0018\n\u001a\u0005\t\u00037\u000bi\b1\u0001\u0002\u001e\u0006\u0001R\r\u001f9fGR,GMU3qY&\u001c\u0017m\u001d\t\u0006\u0003?\u000b)+\u0016\b\u0004]\u0005\u0005\u0016bAARA\u00051\u0001K]3eK\u001aLA!a*\u0002*\n\u00191+\u001a;\u000b\u0007\u0005\r\u0006\u0005")
public class AddPartitionsTest
extends ZooKeeperTestHarness {
    private Seq<KafkaConfig> configs = null;
    private Seq<KafkaServer> servers = (Seq)Seq$.MODULE$.empty();
    private Seq<Broker> brokers = (Seq)Seq$.MODULE$.empty();
    private final int partitionId;
    private final String topic1;
    private final scala.collection.immutable.Map<Object, Seq<Object>> topic1Assignment = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1})))}));
    private final String topic2;
    private final scala.collection.immutable.Map<Object, Seq<Object>> topic2Assignment = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2})))}));
    private final String topic3;
    private final scala.collection.immutable.Map<Object, Seq<Object>> topic3Assignment = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3, 0, 1})))}));
    private final String topic4;
    private final scala.collection.immutable.Map<Object, Seq<Object>> topic4Assignment = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 3})))}));
    private final String topic5;
    private final scala.collection.immutable.Map<Object, Seq<Object>> topic5Assignment = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1})))}));

    public Seq<KafkaConfig> configs() {
        return this.configs;
    }

    public void configs_$eq(Seq<KafkaConfig> x$1) {
        this.configs = x$1;
    }

    public Seq<KafkaServer> servers() {
        return this.servers;
    }

    public void servers_$eq(Seq<KafkaServer> x$1) {
        this.servers = x$1;
    }

    public Seq<Broker> brokers() {
        return this.brokers;
    }

    public void brokers_$eq(Seq<Broker> x$1) {
        this.brokers = x$1;
    }

    public int partitionId() {
        return this.partitionId;
    }

    public String topic1() {
        return this.topic1;
    }

    public scala.collection.immutable.Map<Object, Seq<Object>> topic1Assignment() {
        return this.topic1Assignment;
    }

    public String topic2() {
        return this.topic2;
    }

    public scala.collection.immutable.Map<Object, Seq<Object>> topic2Assignment() {
        return this.topic2Assignment;
    }

    public String topic3() {
        return this.topic3;
    }

    public scala.collection.immutable.Map<Object, Seq<Object>> topic3Assignment() {
        return this.topic3Assignment;
    }

    public String topic4() {
        return this.topic4;
    }

    public scala.collection.immutable.Map<Object, Seq<Object>> topic4Assignment() {
        return this.topic4Assignment;
    }

    public String topic5() {
        return this.topic5;
    }

    public scala.collection.immutable.Map<Object, Seq<Object>> topic5Assignment() {
        return this.topic5Assignment;
    }

    @Override
    @Before
    public void setUp() {
        super.setUp();
        this.configs_$eq((Seq<KafkaConfig>)((Seq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 4).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AddPartitionsTest $outer;

            public final KafkaConfig apply(int i) {
                return KafkaConfig$.MODULE$.fromProps(TestUtils$.MODULE$.createBrokerConfig(i, this.$outer.zkConnect(), false, TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18()));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom())));
        this.servers_$eq((Seq<KafkaServer>)((Seq)this.configs().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final KafkaServer apply(KafkaConfig c) {
                return TestUtils$.MODULE$.createServer(c, TestUtils$.MODULE$.createServer$default$2());
            }
        }, Seq$.MODULE$.canBuildFrom())));
        this.brokers_$eq((Seq<Broker>)((Seq)this.servers().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Broker apply(KafkaServer s) {
                return TestUtils$.MODULE$.createBroker(s.config().brokerId(), s.config().hostName(), TestUtils$.MODULE$.boundPort(s, TestUtils$.MODULE$.boundPort$default$2()), TestUtils$.MODULE$.createBroker$default$4());
            }
        }, Seq$.MODULE$.canBuildFrom())));
        TestUtils$.MODULE$.createTopic(this.zkClient(), this.topic1(), (Map<Object, Seq<Object>>)this.topic1Assignment(), this.servers());
        TestUtils$.MODULE$.createTopic(this.zkClient(), this.topic2(), (Map<Object, Seq<Object>>)this.topic2Assignment(), this.servers());
        TestUtils$.MODULE$.createTopic(this.zkClient(), this.topic3(), (Map<Object, Seq<Object>>)this.topic3Assignment(), this.servers());
        TestUtils$.MODULE$.createTopic(this.zkClient(), this.topic4(), (Map<Object, Seq<Object>>)this.topic4Assignment(), this.servers());
    }

    @Override
    @After
    public void tearDown() {
        TestUtils$.MODULE$.shutdownServers(this.servers());
        super.tearDown();
    }

    @Test
    public void testWrongReplicaCount() {
        try {
            AdminZkClient qual$1 = this.adminZkClient();
            String x$12 = this.topic1();
            scala.collection.immutable.Map<Object, Seq<Object>> x$13 = this.topic1Assignment();
            AdminZkClient qual$2 = this.adminZkClient();
            RackAwareMode x$10 = qual$2.getBrokerMetadatas$default$1();
            Option x$11 = qual$2.getBrokerMetadatas$default$2();
            Seq x$14 = qual$2.getBrokerMetadatas(x$10, x$11);
            int x$15 = 2;
            Some x$16 = new Some((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2})))})));
            boolean x$17 = qual$1.addPartitions$default$6();
            qual$1.addPartitions(x$12, x$13, x$14, x$15, (Option)x$16, x$17);
            throw this.fail("Add partitions should fail", new Position("AddPartitionsTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 79));
        }
        catch (InvalidReplicaAssignmentException invalidReplicaAssignmentException) {
            return;
        }
    }

    @Test
    public void testMissingPartition0() {
        try {
            AdminZkClient qual$3 = this.adminZkClient();
            String x$20 = this.topic5();
            scala.collection.immutable.Map<Object, Seq<Object>> x$21 = this.topic5Assignment();
            AdminZkClient qual$4 = this.adminZkClient();
            RackAwareMode x$18 = qual$4.getBrokerMetadatas$default$1();
            Option x$19 = qual$4.getBrokerMetadatas$default$2();
            Seq x$22 = qual$4.getBrokerMetadatas(x$18, x$19);
            int x$23 = 2;
            Some x$24 = new Some((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2})))})));
            boolean x$25 = qual$3.addPartitions$default$6();
            qual$3.addPartitions(x$20, x$21, x$22, x$23, (Option)x$24, x$25);
            throw this.fail("Add partitions should fail", new Position("AddPartitionsTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 90));
        }
        catch (AdminOperationException adminOperationException) {
            Assert.assertTrue((boolean)adminOperationException.getMessage().contains("Unexpected existing replica assignment for topic 'new-topic5', partition id 0 is missing"));
            return;
        }
    }

    @Test
    public void testIncrementPartitions() {
        AdminZkClient qual$5 = this.adminZkClient();
        String x$28 = this.topic1();
        scala.collection.immutable.Map<Object, Seq<Object>> x$29 = this.topic1Assignment();
        AdminZkClient qual$6 = this.adminZkClient();
        RackAwareMode x$26 = qual$6.getBrokerMetadatas$default$1();
        Option x$27 = qual$6.getBrokerMetadatas$default$2();
        Seq x$30 = qual$6.getBrokerMetadatas(x$26, x$27);
        int x$31 = 3;
        Option x$32 = qual$5.addPartitions$default$5();
        boolean x$33 = qual$5.addPartitions$default$6();
        qual$5.addPartitions(x$28, x$29, x$30, x$31, x$32, x$33);
        int leader1 = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged(this.zkClient(), this.topic1(), 1, TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$4(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$5(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$6());
        int leader2 = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged(this.zkClient(), this.topic1(), 2, TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$4(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$5(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$6());
        int leader1FromZk = BoxesRunTime.unboxToInt((Object)this.zkClient().getLeaderForPartition(new TopicPartition(this.topic1(), 1)).get());
        int leader2FromZk = BoxesRunTime.unboxToInt((Object)this.zkClient().getLeaderForPartition(new TopicPartition(this.topic1(), 2)).get());
        Assert.assertEquals((long)leader1, (long)leader1FromZk);
        Assert.assertEquals((long)leader2, (long)leader2FromZk);
        TestUtils$.MODULE$.waitUntilMetadataIsPropagated(this.servers(), this.topic1(), 1, TestUtils$.MODULE$.waitUntilMetadataIsPropagated$default$4());
        TestUtils$.MODULE$.waitUntilMetadataIsPropagated(this.servers(), this.topic1(), 2, TestUtils$.MODULE$.waitUntilMetadataIsPropagated$default$4());
        ListenerName listenerName = ListenerName.forSecurityProtocol((SecurityProtocol)SecurityProtocol.PLAINTEXT);
        Seq metadata = ClientUtils$.MODULE$.fetchTopicMetadata((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topic1()})), (Seq)this.brokers().map((Function1)new Serializable(this, listenerName){
            public static final long serialVersionUID = 0L;
            private final ListenerName listenerName$1;

            public final BrokerEndPoint apply(Broker x$1) {
                return x$1.brokerEndPoint(this.listenerName$1);
            }
            {
                this.listenerName$1 = listenerName$1;
            }
        }, Seq$.MODULE$.canBuildFrom()), "AddPartitionsTest-testIncrementPartitions", 2000, 0).topicsMetadata();
        Seq metaDataForTopic1 = (Seq)metadata.filter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AddPartitionsTest $outer;

            public final boolean apply(TopicMetadata p) {
                return p.topic().equals(this.$outer.topic1());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        Seq partitionDataForTopic1 = (Seq)((TopicMetadata)metaDataForTopic1.head()).partitionsMetadata().sortBy((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(PartitionMetadata x$2) {
                return x$2.partitionId();
            }
        }, (Ordering)Ordering.Int$.MODULE$);
        Assert.assertEquals((long)partitionDataForTopic1.size(), (long)3L);
        Assert.assertEquals((long)((PartitionMetadata)partitionDataForTopic1.apply(1)).partitionId(), (long)1L);
        Assert.assertEquals((long)((PartitionMetadata)partitionDataForTopic1.apply(2)).partitionId(), (long)2L);
        Seq replicas = ((PartitionMetadata)partitionDataForTopic1.apply(1)).replicas();
        Assert.assertEquals((long)replicas.size(), (long)2L);
        Seq $org_scalatest_assert_macro_left = replicas;
        BrokerEndPoint $org_scalatest_assert_macro_right = (BrokerEndPoint)((PartitionMetadata)partitionDataForTopic1.apply(1)).leader().get();
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains((Object)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
        this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("AddPartitionsTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 121));
    }

    @Test
    public void testManualAssignmentOfReplicas() {
        AdminZkClient qual$7 = this.adminZkClient();
        String x$36 = this.topic2();
        scala.collection.immutable.Map<Object, Seq<Object>> x$37 = this.topic2Assignment();
        AdminZkClient qual$8 = this.adminZkClient();
        RackAwareMode x$34 = qual$8.getBrokerMetadatas$default$1();
        Option x$35 = qual$8.getBrokerMetadatas$default$2();
        Seq x$38 = qual$8.getBrokerMetadatas(x$34, x$35);
        int x$39 = 3;
        Some x$40 = new Some((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3})))})));
        boolean x$41 = qual$7.addPartitions$default$6();
        qual$7.addPartitions(x$36, x$37, x$38, x$39, (Option)x$40, x$41);
        int leader1 = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged(this.zkClient(), this.topic2(), 1, TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$4(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$5(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$6());
        int leader2 = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged(this.zkClient(), this.topic2(), 2, TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$4(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$5(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$6());
        int leader1FromZk = BoxesRunTime.unboxToInt((Object)this.zkClient().getLeaderForPartition(new TopicPartition(this.topic2(), 1)).get());
        int leader2FromZk = BoxesRunTime.unboxToInt((Object)this.zkClient().getLeaderForPartition(new TopicPartition(this.topic2(), 2)).get());
        Assert.assertEquals((long)leader1, (long)leader1FromZk);
        Assert.assertEquals((long)leader2, (long)leader2FromZk);
        TestUtils$.MODULE$.waitUntilMetadataIsPropagated(this.servers(), this.topic2(), 1, TestUtils$.MODULE$.waitUntilMetadataIsPropagated$default$4());
        TestUtils$.MODULE$.waitUntilMetadataIsPropagated(this.servers(), this.topic2(), 2, TestUtils$.MODULE$.waitUntilMetadataIsPropagated$default$4());
        Seq metadata = ClientUtils$.MODULE$.fetchTopicMetadata((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topic2()})), (Seq)this.brokers().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final BrokerEndPoint apply(Broker x$3) {
                return x$3.brokerEndPoint(ListenerName.forSecurityProtocol((SecurityProtocol)SecurityProtocol.PLAINTEXT));
            }
        }, Seq$.MODULE$.canBuildFrom()), "AddPartitionsTest-testManualAssignmentOfReplicas", 2000, 0).topicsMetadata();
        Seq metaDataForTopic2 = (Seq)metadata.filter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AddPartitionsTest $outer;

            public final boolean apply(TopicMetadata x$4) {
                String string = x$4.topic();
                String string2 = this.$outer.topic2();
                return !(string != null ? !string.equals(string2) : string2 != null);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        Seq partitionDataForTopic2 = (Seq)((TopicMetadata)metaDataForTopic2.head()).partitionsMetadata().sortBy((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(PartitionMetadata x$5) {
                return x$5.partitionId();
            }
        }, (Ordering)Ordering.Int$.MODULE$);
        Assert.assertEquals((long)3L, (long)partitionDataForTopic2.size());
        Assert.assertEquals((long)1L, (long)((PartitionMetadata)partitionDataForTopic2.apply(1)).partitionId());
        Assert.assertEquals((long)2L, (long)((PartitionMetadata)partitionDataForTopic2.apply(2)).partitionId());
        Seq replicas = ((PartitionMetadata)partitionDataForTopic2.apply(1)).replicas();
        Assert.assertEquals((long)2L, (long)replicas.size());
        Assert.assertTrue((((BrokerEndPoint)replicas.head()).id() == 0 || ((BrokerEndPoint)replicas.head()).id() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((((BrokerEndPoint)replicas.apply(1)).id() == 0 || ((BrokerEndPoint)replicas.apply(1)).id() == 1 ? 1 : 0) != 0);
    }

    @Test
    public void testReplicaPlacementAllServers() {
        AdminZkClient qual$9 = this.adminZkClient();
        String x$44 = this.topic3();
        scala.collection.immutable.Map<Object, Seq<Object>> x$45 = this.topic3Assignment();
        AdminZkClient qual$10 = this.adminZkClient();
        RackAwareMode x$42 = qual$10.getBrokerMetadatas$default$1();
        Option x$43 = qual$10.getBrokerMetadatas$default$2();
        Seq x$46 = qual$10.getBrokerMetadatas(x$42, x$43);
        int x$47 = 7;
        Option x$48 = qual$9.addPartitions$default$5();
        boolean x$49 = qual$9.addPartitions$default$6();
        qual$9.addPartitions(x$44, x$45, x$46, x$47, x$48, x$49);
        TestUtils$.MODULE$.waitUntilMetadataIsPropagated(this.servers(), this.topic3(), 1, TestUtils$.MODULE$.waitUntilMetadataIsPropagated$default$4());
        TestUtils$.MODULE$.waitUntilMetadataIsPropagated(this.servers(), this.topic3(), 2, TestUtils$.MODULE$.waitUntilMetadataIsPropagated$default$4());
        TestUtils$.MODULE$.waitUntilMetadataIsPropagated(this.servers(), this.topic3(), 3, TestUtils$.MODULE$.waitUntilMetadataIsPropagated$default$4());
        TestUtils$.MODULE$.waitUntilMetadataIsPropagated(this.servers(), this.topic3(), 4, TestUtils$.MODULE$.waitUntilMetadataIsPropagated$default$4());
        TestUtils$.MODULE$.waitUntilMetadataIsPropagated(this.servers(), this.topic3(), 5, TestUtils$.MODULE$.waitUntilMetadataIsPropagated$default$4());
        TestUtils$.MODULE$.waitUntilMetadataIsPropagated(this.servers(), this.topic3(), 6, TestUtils$.MODULE$.waitUntilMetadataIsPropagated$default$4());
        Seq metadata = ClientUtils$.MODULE$.fetchTopicMetadata((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topic3()})), (Seq)this.brokers().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final BrokerEndPoint apply(Broker x$6) {
                return x$6.brokerEndPoint(ListenerName.forSecurityProtocol((SecurityProtocol)SecurityProtocol.PLAINTEXT));
            }
        }, Seq$.MODULE$.canBuildFrom()), "AddPartitionsTest-testReplicaPlacementAllServers", 2000, 0).topicsMetadata();
        TopicMetadata metaDataForTopic3 = (TopicMetadata)metadata.find((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AddPartitionsTest $outer;

            public final boolean apply(TopicMetadata p) {
                String string = p.topic();
                String string2 = this.$outer.topic3();
                return !(string != null ? !string.equals(string2) : string2 != null);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }).get();
        this.validateLeaderAndReplicas(metaDataForTopic3, 0, 2, (scala.collection.immutable.Set<Object>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3, 0, 1}))));
        this.validateLeaderAndReplicas(metaDataForTopic3, 1, 3, (scala.collection.immutable.Set<Object>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 2, 0, 1}))));
        this.validateLeaderAndReplicas(metaDataForTopic3, 2, 0, (scala.collection.immutable.Set<Object>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 3, 1, 2}))));
        this.validateLeaderAndReplicas(metaDataForTopic3, 3, 1, (scala.collection.immutable.Set<Object>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 0, 2, 3}))));
        this.validateLeaderAndReplicas(metaDataForTopic3, 4, 2, (scala.collection.immutable.Set<Object>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3, 0, 1}))));
        this.validateLeaderAndReplicas(metaDataForTopic3, 5, 3, (scala.collection.immutable.Set<Object>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 0, 1, 2}))));
        this.validateLeaderAndReplicas(metaDataForTopic3, 6, 0, (scala.collection.immutable.Set<Object>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2, 3}))));
    }

    @Test
    public void testReplicaPlacementPartialServers() {
        AdminZkClient qual$11 = this.adminZkClient();
        String x$52 = this.topic2();
        scala.collection.immutable.Map<Object, Seq<Object>> x$53 = this.topic2Assignment();
        AdminZkClient qual$12 = this.adminZkClient();
        RackAwareMode x$50 = qual$12.getBrokerMetadatas$default$1();
        Option x$51 = qual$12.getBrokerMetadatas$default$2();
        Seq x$54 = qual$12.getBrokerMetadatas(x$50, x$51);
        int x$55 = 3;
        Option x$56 = qual$11.addPartitions$default$5();
        boolean x$57 = qual$11.addPartitions$default$6();
        qual$11.addPartitions(x$52, x$53, x$54, x$55, x$56, x$57);
        TestUtils$.MODULE$.waitUntilMetadataIsPropagated(this.servers(), this.topic2(), 1, TestUtils$.MODULE$.waitUntilMetadataIsPropagated$default$4());
        TestUtils$.MODULE$.waitUntilMetadataIsPropagated(this.servers(), this.topic2(), 2, TestUtils$.MODULE$.waitUntilMetadataIsPropagated$default$4());
        Seq metadata = ClientUtils$.MODULE$.fetchTopicMetadata((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topic2()})), (Seq)this.brokers().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final BrokerEndPoint apply(Broker x$7) {
                return x$7.brokerEndPoint(ListenerName.forSecurityProtocol((SecurityProtocol)SecurityProtocol.PLAINTEXT));
            }
        }, Seq$.MODULE$.canBuildFrom()), "AddPartitionsTest-testReplicaPlacementPartialServers", 2000, 0).topicsMetadata();
        TopicMetadata metaDataForTopic2 = (TopicMetadata)metadata.find((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AddPartitionsTest $outer;

            public final boolean apply(TopicMetadata p) {
                String string = p.topic();
                String string2 = this.$outer.topic2();
                return !(string != null ? !string.equals(string2) : string2 != null);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }).get();
        this.validateLeaderAndReplicas(metaDataForTopic2, 0, 1, (scala.collection.immutable.Set<Object>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2}))));
        this.validateLeaderAndReplicas(metaDataForTopic2, 1, 2, (scala.collection.immutable.Set<Object>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 2}))));
        this.validateLeaderAndReplicas(metaDataForTopic2, 2, 3, (scala.collection.immutable.Set<Object>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 3}))));
    }

    public void validateLeaderAndReplicas(TopicMetadata metadata, int partitionId, int expectedLeaderId, scala.collection.immutable.Set<Object> expectedReplicas) {
        Option partitionOpt = metadata.partitionsMetadata().find((Function1)new Serializable(this, partitionId){
            public static final long serialVersionUID = 0L;
            private final int partitionId$1;

            public final boolean apply(PartitionMetadata x$8) {
                return x$8.partitionId() == this.partitionId$1;
            }
            {
                this.partitionId$1 = partitionId$1;
            }
        });
        Assert.assertTrue((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Partition ", " should exist"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)partitionId)})), (boolean)partitionOpt.isDefined());
        PartitionMetadata partition = (PartitionMetadata)partitionOpt.get();
        Assert.assertTrue((String)"Partition leader should exist", (boolean)partition.leader().isDefined());
        Assert.assertEquals((String)"Partition leader id should match", (long)expectedLeaderId, (long)((BrokerEndPoint)partition.leader().get()).id());
        Assert.assertEquals((String)"Replica set should match", expectedReplicas, (Object)((TraversableOnce)partition.replicas().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(BrokerEndPoint x$9) {
                return x$9.id();
            }
        }, Seq$.MODULE$.canBuildFrom())).toSet());
    }

    public AddPartitionsTest() {
        this.partitionId = 0;
        this.topic1 = "new-topic1";
        this.topic2 = "new-topic2";
        this.topic3 = "new-topic3";
        this.topic4 = "new-topic4";
        this.topic5 = "new-topic5";
    }
}

