/*
 * Decompiled with CFR 0.152.
 */
package kafka.admin;

import java.nio.charset.StandardCharsets;
import java.util.Properties;
import java.util.concurrent.Future;
import kafka.admin.AdminUtils$;
import kafka.admin.DeleteConsumerGroupTest$;
import kafka.consumer.Consumer$;
import kafka.consumer.ConsumerConfig;
import kafka.consumer.ConsumerConnector;
import kafka.consumer.ConsumerIterator;
import kafka.consumer.KafkaStream;
import kafka.integration.KafkaServerTestHarness;
import kafka.message.MessageAndMetadata;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.utils.TestUtils$;
import kafka.utils.ZKGroupDirs;
import kafka.utils.ZKGroupTopicDirs;
import kafka.utils.ZkUtils;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.junit.Test;
import scala.Function0;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0001\u0005Uc\u0001B\u0001\u0003\u0001\u001d\u0011q\u0003R3mKR,7i\u001c8tk6,'o\u0012:pkB$Vm\u001d;\u000b\u0005\r!\u0011!B1e[&t'\"A\u0003\u0002\u000b-\fgm[1\u0004\u0001M\u0011\u0001\u0001\u0003\t\u0003\u00131i\u0011A\u0003\u0006\u0003\u0017\u0011\t1\"\u001b8uK\u001e\u0014\u0018\r^5p]&\u0011QB\u0003\u0002\u0017\u0017\u000647.Y*feZ,'\u000fV3ti\"\u000b'O\\3tg\")q\u0002\u0001C\u0001!\u00051A(\u001b8jiz\"\u0012!\u0005\t\u0003%\u0001i\u0011A\u0001\u0005\u0006)\u0001!\t!F\u0001\u0010O\u0016tWM]1uK\u000e{gNZ5hgV\ta\u0003E\u0002\u0018C\u0011r!\u0001\u0007\u0010\u000f\u0005eaR\"\u0001\u000e\u000b\u0005m1\u0011A\u0002\u001fs_>$h(C\u0001\u001e\u0003\u0015\u00198-\u00197b\u0013\ty\u0002%A\u0004qC\u000e\\\u0017mZ3\u000b\u0003uI!AI\u0012\u0003\u0007M+\u0017O\u0003\u0002 AA\u0011Q\u0005K\u0007\u0002M)\u0011q\u0005B\u0001\u0007g\u0016\u0014h/\u001a:\n\u0005%2#aC&bM.\f7i\u001c8gS\u001eDQa\u000b\u0001\u0005\u00021\nq\u0003^3ti\u001e\u0013x.\u001e9XS\u0012,G)\u001a7fi\u0016LeNW&\u0015\u00035\u0002\"AL\u0018\u000e\u0003\u0001J!\u0001\r\u0011\u0003\tUs\u0017\u000e\u001e\u0015\u0003UI\u0002\"a\r\u001d\u000e\u0003QR!!\u000e\u001c\u0002\u000b),h.\u001b;\u000b\u0003]\n1a\u001c:h\u0013\tIDG\u0001\u0003UKN$\b\"B\u001e\u0001\t\u0003a\u0013\u0001\u000f;fgR<%o\\;q/&$W\rR3mKR,\u0017J\u001c.L\t>,7OT8uQ&twMR8s\u0003\u000e$\u0018N^3D_:\u001cX/\\3s\u000fJ|W\u000f\u001d\u0015\u0003uIBQA\u0010\u0001\u0005\u00021\nQ\u0007^3ti\u001e\u0013x.\u001e9U_BL7mV5eK\u0012+G.\u001a;f\u0013:T6JR8s\u000fJ|W\u000f]\"p]N,X.\u001b8h\u001f:,Gk\u001c9jG\"\u0012QH\r\u0005\u0006\u0003\u0002!\t\u0001L\u0001<i\u0016\u001cHo\u0012:pkB$v\u000e]5d/&$W\rR3mKR,\u0017J\u001c.L\r>\u0014xI]8va\u000e{gn];nS:<W*\u001e7uSBdW\rV8qS\u000e\u001c\bF\u0001!3\u0011\u0015!\u0005\u0001\"\u0001-\u00031#Xm\u001d;He>,\b\u000fV8qS\u000e<\u0016\u000eZ3EK2,G/Z%o5.#u.Z:O_RD\u0017N\\4G_J\f5\r^5wK\u001e\u0013x.\u001e9D_:\u001cX/\\5oO6+H\u000e^5qY\u0016$v\u000e]5dg\"\u00121I\r\u0005\u0006\u000f\u0002!\t\u0001L\u0001\u0018i\u0016\u001cH\u000fV8qS\u000e<\u0016\u000eZ3EK2,G/Z%o5.C#A\u0012\u001a\t\u000b)\u0003A\u0011\u0001\u0017\u0002oQ,7\u000f^\"p]N,X\u000e\u001d;j_:|eNU3de\u0016\fG/\u001a3U_BL7-\u00114uKJ$v\u000e]5d/&$W\rR3mKR,\u0017J\u001c.LQ\tI%\u0007C\u0003N\u0001\u0011%a*A\fgS2d\u0017J\\\"p]N,X.\u001a:He>,\b/\u00138g_R9Qf\u0014-[9\u0006\u001c\u0007\"\u0002)M\u0001\u0004\t\u0016!\u0002;pa&\u001c\u0007C\u0001*V\u001d\tq3+\u0003\u0002UA\u00051\u0001K]3eK\u001aL!AV,\u0003\rM#(/\u001b8h\u0015\t!\u0006\u0005C\u0003Z\u0019\u0002\u0007\u0011+A\u0003he>,\b\u000fC\u0003\\\u0019\u0002\u0007\u0011+\u0001\u0006d_:\u001cX/\\3s\u0013\u0012DQ!\u0018'A\u0002y\u000b\u0011\u0002]1si&$\u0018n\u001c8\u0011\u00059z\u0016B\u00011!\u0005\rIe\u000e\u001e\u0005\u0006E2\u0003\rAX\u0001\u0007_\u001a47/\u001a;\t\u000b\u0011d\u0005\u0019A3\u0002!I,w-[:uKJ\u001cuN\\:v[\u0016\u0014\bC\u0001\u0018g\u0013\t9\u0007EA\u0004C_>dW-\u00198\t\u000b%\u0004A\u0011\u00026\u0002\u001d\u001d\u0014x.\u001e9ESJ,\u00050[:ugR\u0011Qm\u001b\u0005\u0006Y\"\u0004\r!\\\u0001\u0004I&\u0014\bC\u00018r\u001b\u0005y'B\u00019\u0005\u0003\u0015)H/\u001b7t\u0013\t\u0011xNA\u0006[\u0017\u001e\u0013x.\u001e9ESJ\u001c\b\"\u0002;\u0001\t\u0013)\u0018!I4s_V\u0004Hk\u001c9jG>3gm]3u\u0003:$wj\u001e8fe\u0012K'o]#ySN$HCA3w\u0011\u0015a7\u000f1\u0001x!\tq\u00070\u0003\u0002z_\n\u0001\"lS$s_V\u0004Hk\u001c9jG\u0012K'o\u001d\u0005\u0006w\u0002!I\u0001`\u0001\u000eaJ|G-^2f\u000bZ,g\u000e^:\u0015\r5j\u0018qDA\u0011\u0011\u0015q(\u00101\u0001\u0000\u0003!\u0001(o\u001c3vG\u0016\u0014\b\u0003CA\u0001\u0003\u001f\t\u0019\"a\u0005\u000e\u0005\u0005\r!b\u0001@\u0002\u0006)!\u0011qAA\u0005\u0003\u001d\u0019G.[3oiNT1!BA\u0006\u0015\r\tiAN\u0001\u0007CB\f7\r[3\n\t\u0005E\u00111\u0001\u0002\u000e\u0017\u000647.\u0019)s_\u0012,8-\u001a:\u0011\u000b9\n)\"!\u0007\n\u0007\u0005]\u0001EA\u0003BeJ\f\u0017\u0010E\u0002/\u00037I1!!\b!\u0005\u0011\u0011\u0015\u0010^3\t\u000bAS\b\u0019A)\t\u000f\u0005\r\"\u00101\u0001\u0002&\u0005AQ.Z:tC\u001e,7\u000f\u0005\u0003\u0018\u0003O\t\u0016bAA\u0015G\t!A*[:u\u0011\u001d\ti\u0003\u0001C\u0005\u0003_\tQbY8ogVlW-\u0012<f]R\u001cH#B\u0017\u00022\u0005\u0005\u0003\u0002CA\u001a\u0003W\u0001\r!!\u000e\u0002\u001b5,7o]1hKN#(/Z1n!!\t9$!\u0010\u0002\u0014\u0005MQBAA\u001d\u0015\r\tY\u0004B\u0001\tG>t7/^7fe&!\u0011qHA\u001d\u0005-Y\u0015MZ6b'R\u0014X-Y7\t\u000f\u0005\r\u00131\u0006a\u0001=\u0006\ta\u000eK\u0004\u0001\u0003\u000f\ni%!\u0015\u0011\u00079\nI%C\u0002\u0002L\u0001\u0012!\u0002Z3qe\u0016\u001c\u0017\r^3eC\t\ty%\u0001$UQ&\u001c\b\u0005^3ti\u0002B\u0017m\u001d\u0011cK\u0016t\u0007\u0005Z3qe\u0016\u001c\u0017\r^3eA\u0005tG\rI<jY2\u0004#-\u001a\u0011sK6|g/\u001a3!S:\u0004\u0013\r\t4viV\u0014X\r\t:fY\u0016\f7/\u001a\u0018\"\u0005\u0005M\u0013\u0001\u0003\u0019/cEr\u0003G\f\u0019")
public class DeleteConsumerGroupTest
extends KafkaServerTestHarness {
    @Override
    public Seq<KafkaConfig> generateConfigs() {
        return (Seq)TestUtils$.MODULE$.createBrokerConfigs(3, this.zkConnect(), false, true, TestUtils$.MODULE$.createBrokerConfigs$default$5(), TestUtils$.MODULE$.createBrokerConfigs$default$6(), TestUtils$.MODULE$.createBrokerConfigs$default$7(), TestUtils$.MODULE$.createBrokerConfigs$default$8(), TestUtils$.MODULE$.createBrokerConfigs$default$9(), TestUtils$.MODULE$.createBrokerConfigs$default$10(), TestUtils$.MODULE$.createBrokerConfigs$default$11(), TestUtils$.MODULE$.createBrokerConfigs$default$12(), TestUtils$.MODULE$.createBrokerConfigs$default$13(), TestUtils$.MODULE$.createBrokerConfigs$default$14()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final KafkaConfig apply(Properties props) {
                return KafkaConfig$.MODULE$.fromProps(props);
            }
        }, Seq$.MODULE$.canBuildFrom());
    }

    @Test
    public void testGroupWideDeleteInZK() {
        String topic = "test";
        String groupToDelete = "groupToDelete";
        String otherGroup = "otherGroup";
        this.createTopic(topic, 1, 3, this.createTopic$default$4());
        this.kafka$admin$DeleteConsumerGroupTest$$fillInConsumerGroupInfo(topic, groupToDelete, "consumer", 0, 10, false);
        this.kafka$admin$DeleteConsumerGroupTest$$fillInConsumerGroupInfo(topic, otherGroup, "consumer", 0, 10, false);
        AdminUtils$.MODULE$.deleteConsumerGroupInZK(this.zkUtils(), groupToDelete);
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, groupToDelete){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DeleteConsumerGroupTest $outer;
            private final String groupToDelete$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return !this.$outer.kafka$admin$DeleteConsumerGroupTest$$groupDirExists(new ZKGroupDirs(this.groupToDelete$1));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.groupToDelete$1 = groupToDelete$1;
            }
        }, (Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "DeleteConsumerGroupInZK should delete the provided consumer group's directory";
            }
        }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, otherGroup){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DeleteConsumerGroupTest $outer;
            private final String otherGroup$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return this.$outer.kafka$admin$DeleteConsumerGroupTest$$groupDirExists(new ZKGroupDirs(this.otherGroup$1));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.otherGroup$1 = otherGroup$1;
            }
        }, (Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "DeleteConsumerGroupInZK should not delete unrelated consumer group directories";
            }
        }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
    }

    @Test
    public void testGroupWideDeleteInZKDoesNothingForActiveConsumerGroup() {
        String topic = "test";
        String groupToDelete = "groupToDelete";
        String otherGroup = "otherGroup";
        this.createTopic(topic, 1, 3, this.createTopic$default$4());
        this.kafka$admin$DeleteConsumerGroupTest$$fillInConsumerGroupInfo(topic, groupToDelete, "consumer", 0, 10, true);
        this.kafka$admin$DeleteConsumerGroupTest$$fillInConsumerGroupInfo(topic, otherGroup, "consumer", 0, 10, false);
        AdminUtils$.MODULE$.deleteConsumerGroupInZK(this.zkUtils(), groupToDelete);
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, groupToDelete){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DeleteConsumerGroupTest $outer;
            private final String groupToDelete$2;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return this.$outer.kafka$admin$DeleteConsumerGroupTest$$groupDirExists(new ZKGroupDirs(this.groupToDelete$2));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.groupToDelete$2 = groupToDelete$2;
            }
        }, (Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "DeleteConsumerGroupInZK should not delete the provided consumer group's directory if the consumer group is still active";
            }
        }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, otherGroup){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DeleteConsumerGroupTest $outer;
            private final String otherGroup$2;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return this.$outer.kafka$admin$DeleteConsumerGroupTest$$groupDirExists(new ZKGroupDirs(this.otherGroup$2));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.otherGroup$2 = otherGroup$2;
            }
        }, (Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "DeleteConsumerGroupInZK should not delete unrelated consumer group directories";
            }
        }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
    }

    @Test
    public void testGroupTopicWideDeleteInZKForGroupConsumingOneTopic() {
        String topic = "test";
        String groupToDelete = "groupToDelete";
        String otherGroup = "otherGroup";
        this.createTopic(topic, 1, 3, this.createTopic$default$4());
        this.kafka$admin$DeleteConsumerGroupTest$$fillInConsumerGroupInfo(topic, groupToDelete, "consumer", 0, 10, false);
        this.kafka$admin$DeleteConsumerGroupTest$$fillInConsumerGroupInfo(topic, otherGroup, "consumer", 0, 10, false);
        AdminUtils$.MODULE$.deleteConsumerGroupInfoForTopicInZK(this.zkUtils(), groupToDelete, topic);
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, groupToDelete){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DeleteConsumerGroupTest $outer;
            private final String groupToDelete$3;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return !this.$outer.kafka$admin$DeleteConsumerGroupTest$$groupDirExists(new ZKGroupDirs(this.groupToDelete$3));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.groupToDelete$3 = groupToDelete$3;
            }
        }, (Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "DeleteConsumerGroupInfoForTopicInZK should delete the provided consumer group's directory if it just consumes from one topic";
            }
        }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, topic, otherGroup){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DeleteConsumerGroupTest $outer;
            private final String topic$1;
            private final String otherGroup$3;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return this.$outer.kafka$admin$DeleteConsumerGroupTest$$groupTopicOffsetAndOwnerDirsExist(new ZKGroupTopicDirs(this.otherGroup$3, this.topic$1));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.topic$1 = topic$1;
                this.otherGroup$3 = otherGroup$3;
            }
        }, (Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "DeleteConsumerGroupInfoForTopicInZK should not delete unrelated consumer group owner and offset directories";
            }
        }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
    }

    @Test
    public void testGroupTopicWideDeleteInZKForGroupConsumingMultipleTopics() {
        String topicToDelete = "topicToDelete";
        String otherTopic = "otherTopic";
        String groupToDelete = "groupToDelete";
        String otherGroup = "otherGroup";
        this.createTopic(topicToDelete, 1, 3, this.createTopic$default$4());
        this.createTopic(otherTopic, 1, 3, this.createTopic$default$4());
        this.kafka$admin$DeleteConsumerGroupTest$$fillInConsumerGroupInfo(topicToDelete, groupToDelete, "consumer", 0, 10, false);
        this.kafka$admin$DeleteConsumerGroupTest$$fillInConsumerGroupInfo(otherTopic, groupToDelete, "consumer", 0, 10, false);
        this.kafka$admin$DeleteConsumerGroupTest$$fillInConsumerGroupInfo(topicToDelete, otherGroup, "consumer", 0, 10, false);
        AdminUtils$.MODULE$.deleteConsumerGroupInfoForTopicInZK(this.zkUtils(), groupToDelete, topicToDelete);
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, topicToDelete, groupToDelete){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DeleteConsumerGroupTest $outer;
            private final String topicToDelete$1;
            private final String groupToDelete$4;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return !this.$outer.kafka$admin$DeleteConsumerGroupTest$$groupTopicOffsetAndOwnerDirsExist(new ZKGroupTopicDirs(this.groupToDelete$4, this.topicToDelete$1));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.topicToDelete$1 = topicToDelete$1;
                this.groupToDelete$4 = groupToDelete$4;
            }
        }, (Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "DeleteConsumerGroupInfoForTopicInZK should delete the provided consumer group's owner and offset directories for the given topic";
            }
        }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, otherTopic, groupToDelete){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DeleteConsumerGroupTest $outer;
            private final String otherTopic$1;
            private final String groupToDelete$4;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return this.$outer.kafka$admin$DeleteConsumerGroupTest$$groupTopicOffsetAndOwnerDirsExist(new ZKGroupTopicDirs(this.groupToDelete$4, this.otherTopic$1));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.otherTopic$1 = otherTopic$1;
                this.groupToDelete$4 = groupToDelete$4;
            }
        }, (Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "DeleteConsumerGroupInfoForTopicInZK should not delete the provided consumer group's owner and offset directories for unrelated topics";
            }
        }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, topicToDelete, otherGroup){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DeleteConsumerGroupTest $outer;
            private final String topicToDelete$1;
            private final String otherGroup$4;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return this.$outer.kafka$admin$DeleteConsumerGroupTest$$groupTopicOffsetAndOwnerDirsExist(new ZKGroupTopicDirs(this.otherGroup$4, this.topicToDelete$1));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.topicToDelete$1 = topicToDelete$1;
                this.otherGroup$4 = otherGroup$4;
            }
        }, (Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "DeleteConsumerGroupInfoForTopicInZK should not delete unrelated consumer group owner and offset directories";
            }
        }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
    }

    @Test
    public void testGroupTopicWideDeleteInZKDoesNothingForActiveGroupConsumingMultipleTopics() {
        String topicToDelete = "topicToDelete";
        String otherTopic = "otherTopic";
        String group = "group";
        this.createTopic(topicToDelete, 1, 3, this.createTopic$default$4());
        this.createTopic(otherTopic, 1, 3, this.createTopic$default$4());
        this.kafka$admin$DeleteConsumerGroupTest$$fillInConsumerGroupInfo(topicToDelete, group, "consumer", 0, 10, true);
        this.kafka$admin$DeleteConsumerGroupTest$$fillInConsumerGroupInfo(otherTopic, group, "consumer", 0, 10, true);
        AdminUtils$.MODULE$.deleteConsumerGroupInfoForTopicInZK(this.zkUtils(), group, topicToDelete);
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, topicToDelete, group){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DeleteConsumerGroupTest $outer;
            private final String topicToDelete$2;
            private final String group$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return this.$outer.kafka$admin$DeleteConsumerGroupTest$$groupTopicOffsetAndOwnerDirsExist(new ZKGroupTopicDirs(this.group$1, this.topicToDelete$2));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.topicToDelete$2 = topicToDelete$2;
                this.group$1 = group$1;
            }
        }, (Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "DeleteConsumerGroupInfoForTopicInZK should not delete the provided consumer group's owner and offset directories for the given topic if the consumer group is still active";
            }
        }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, otherTopic, group){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DeleteConsumerGroupTest $outer;
            private final String otherTopic$2;
            private final String group$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return this.$outer.kafka$admin$DeleteConsumerGroupTest$$groupTopicOffsetAndOwnerDirsExist(new ZKGroupTopicDirs(this.group$1, this.otherTopic$2));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.otherTopic$2 = otherTopic$2;
                this.group$1 = group$1;
            }
        }, (Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "DeleteConsumerGroupInfoForTopicInZK should not delete the provided consumer group's owner and offset directories for unrelated topics";
            }
        }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
    }

    @Test
    public void testTopicWideDeleteInZK() {
        String topicToDelete = "topicToDelete";
        String otherTopic = "otherTopic";
        Seq groups = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"group1", "group2"}));
        this.createTopic(topicToDelete, 1, 3, this.createTopic$default$4());
        this.createTopic(otherTopic, 1, 3, this.createTopic$default$4());
        Seq groupTopicDirsForTopicToDelete = (Seq)groups.map((Function1)new Serializable(this, topicToDelete){
            public static final long serialVersionUID = 0L;
            private final String topicToDelete$3;

            public final ZKGroupTopicDirs apply(String group) {
                return new ZKGroupTopicDirs(group, this.topicToDelete$3);
            }
            {
                this.topicToDelete$3 = topicToDelete$3;
            }
        }, Seq$.MODULE$.canBuildFrom());
        Seq groupTopicDirsForOtherTopic = (Seq)groups.map((Function1)new Serializable(this, otherTopic){
            public static final long serialVersionUID = 0L;
            private final String otherTopic$3;

            public final ZKGroupTopicDirs apply(String group) {
                return new ZKGroupTopicDirs(group, this.otherTopic$3);
            }
            {
                this.otherTopic$3 = otherTopic$3;
            }
        }, Seq$.MODULE$.canBuildFrom());
        groupTopicDirsForTopicToDelete.foreach((Function1)new Serializable(this, topicToDelete){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DeleteConsumerGroupTest $outer;
            private final String topicToDelete$3;

            public final void apply(ZKGroupTopicDirs dir) {
                this.$outer.kafka$admin$DeleteConsumerGroupTest$$fillInConsumerGroupInfo(this.topicToDelete$3, dir.group(), "consumer", 0, 10, false);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.topicToDelete$3 = topicToDelete$3;
            }
        });
        groupTopicDirsForOtherTopic.foreach((Function1)new Serializable(this, otherTopic){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DeleteConsumerGroupTest $outer;
            private final String otherTopic$3;

            public final void apply(ZKGroupTopicDirs dir) {
                this.$outer.kafka$admin$DeleteConsumerGroupTest$$fillInConsumerGroupInfo(this.otherTopic$3, dir.group(), "consumer", 0, 10, false);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.otherTopic$3 = otherTopic$3;
            }
        });
        AdminUtils$.MODULE$.deleteAllConsumerGroupInfoForTopicInZK(this.zkUtils(), topicToDelete);
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, groupTopicDirsForTopicToDelete){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DeleteConsumerGroupTest $outer;
            private final Seq groupTopicDirsForTopicToDelete$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return !this.groupTopicDirsForTopicToDelete$1.exists((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$testTopicWideDeleteInZK$1 $outer;

                    public final boolean apply(ZKGroupTopicDirs dir) {
                        return this.$outer.kafka$admin$DeleteConsumerGroupTest$$anonfun$$$outer().kafka$admin$DeleteConsumerGroupTest$$groupTopicOffsetAndOwnerDirsExist(dir);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }

            public /* synthetic */ DeleteConsumerGroupTest kafka$admin$DeleteConsumerGroupTest$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.groupTopicDirsForTopicToDelete$1 = groupTopicDirsForTopicToDelete$1;
            }
        }, (Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Consumer group info on deleted topic should be deleted by DeleteAllConsumerGroupInfoForTopicInZK";
            }
        }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, groupTopicDirsForOtherTopic){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DeleteConsumerGroupTest $outer;
            private final Seq groupTopicDirsForOtherTopic$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return this.groupTopicDirsForOtherTopic$1.forall((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$testTopicWideDeleteInZK$2 $outer;

                    public final boolean apply(ZKGroupTopicDirs dir) {
                        return this.$outer.kafka$admin$DeleteConsumerGroupTest$$anonfun$$$outer().kafka$admin$DeleteConsumerGroupTest$$groupTopicOffsetAndOwnerDirsExist(dir);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }

            public /* synthetic */ DeleteConsumerGroupTest kafka$admin$DeleteConsumerGroupTest$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.groupTopicDirsForOtherTopic$1 = groupTopicDirsForOtherTopic$1;
            }
        }, (Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Consumer group info on unrelated topics should not be deleted by DeleteAllConsumerGroupInfoForTopicInZK";
            }
        }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testConsumptionOnRecreatedTopicAfterTopicWideDeleteInZK() {
        String topic = "topic";
        String group = "group";
        this.createTopic(topic, 1, 3, this.createTopic$default$4());
        ZKGroupTopicDirs dir = new ZKGroupTopicDirs(group, topic);
        this.kafka$admin$DeleteConsumerGroupTest$$fillInConsumerGroupInfo(topic, dir.group(), "consumer", 0, 10, false);
        AdminUtils$.MODULE$.deleteTopic(this.zkUtils(), topic);
        TestUtils$.MODULE$.verifyTopicDeletion(this.zkClient(), topic, 1, (Seq<KafkaServer>)this.servers());
        AdminUtils$.MODULE$.deleteAllConsumerGroupInfoForTopicInZK(this.zkUtils(), topic);
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, dir){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DeleteConsumerGroupTest $outer;
            private final ZKGroupTopicDirs dir$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return !this.$outer.kafka$admin$DeleteConsumerGroupTest$$groupDirExists((ZKGroupDirs)this.dir$1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.dir$1 = dir$1;
            }
        }, (Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Consumer group info on related topics should be deleted by DeleteAllConsumerGroupInfoForTopicInZK";
            }
        }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
        KafkaProducer producer = TestUtils$.MODULE$.createNewProducer(this.brokerList(), TestUtils$.MODULE$.createNewProducer$default$2(), TestUtils$.MODULE$.createNewProducer$default$3(), TestUtils$.MODULE$.createNewProducer$default$4(), TestUtils$.MODULE$.createNewProducer$default$5(), TestUtils$.MODULE$.createNewProducer$default$6(), TestUtils$.MODULE$.createNewProducer$default$7(), TestUtils$.MODULE$.createNewProducer$default$8(), TestUtils$.MODULE$.createNewProducer$default$9(), TestUtils$.MODULE$.createNewProducer$default$10(), TestUtils$.MODULE$.createNewProducer$default$11(), TestUtils$.MODULE$.createNewProducer$default$12(), TestUtils$.MODULE$.createNewProducer$default$13());
        try {
            this.produceEvents(producer, topic, (List<String>)((List)List$.MODULE$.fill(10, (Function0)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "test";
                }
            })));
        }
        catch (Throwable throwable) {
            void var4_4;
            var4_4.close();
            throw throwable;
        }
        producer.close();
        Properties consumerProps = TestUtils$.MODULE$.createConsumerProperties(this.zkConnect(), group, "consumer", TestUtils$.MODULE$.createConsumerProperties$default$4());
        consumerProps.put("auto.commit.enable", "false");
        consumerProps.put("auto.offset.reset", "smallest");
        consumerProps.put("consumer.timeout.ms", "2000");
        consumerProps.put("fetch.wait.max.ms", "0");
        ConsumerConfig consumerConfig = new ConsumerConfig(consumerProps);
        ConsumerConnector consumerConnector = Consumer$.MODULE$.create(consumerConfig);
        try {
            KafkaStream messageStream = (KafkaStream)((IterableLike)consumerConnector.createMessageStreams((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topic), (Object)BoxesRunTime.boxToInteger((int)1))}))).apply((Object)topic)).head();
            this.consumeEvents((KafkaStream<byte[], byte[]>)messageStream, 5);
            consumerConnector.commitOffsets(false);
        }
        catch (Throwable throwable) {
            void var8_7;
            var8_7.shutdown();
            throw throwable;
        }
        consumerConnector.shutdown();
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, dir){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DeleteConsumerGroupTest $outer;
            private final ZKGroupTopicDirs dir$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return this.$outer.kafka$admin$DeleteConsumerGroupTest$$groupTopicOffsetAndOwnerDirsExist(this.dir$1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.dir$1 = dir$1;
            }
        }, (Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Consumer group info should exist after consuming from a recreated topic";
            }
        }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
    }

    public void kafka$admin$DeleteConsumerGroupTest$$fillInConsumerGroupInfo(String topic, String group, String consumerId, int partition, int offset, boolean registerConsumer) {
        Properties consumerProps = TestUtils$.MODULE$.createConsumerProperties(this.zkConnect(), group, consumerId, TestUtils$.MODULE$.createConsumerProperties$default$4());
        ConsumerConfig consumerConfig = new ConsumerConfig(consumerProps);
        ZKGroupTopicDirs dir = new ZKGroupTopicDirs(group, topic);
        TestUtils$.MODULE$.updateConsumerOffset(consumerConfig, new StringBuilder().append((Object)dir.consumerOffsetDir()).append((Object)"/").append((Object)BoxesRunTime.boxToInteger((int)partition)).toString(), offset);
        ZkUtils qual$1 = this.zkUtils();
        String x$2 = this.zkUtils().getConsumerPartitionOwnerPath(group, topic, partition);
        String x$3 = "";
        java.util.List x$4 = qual$1.createEphemeralPathExpectConflict$default$3();
        qual$1.createEphemeralPathExpectConflict(x$2, x$3, x$4);
        ZkUtils qual$2 = this.zkUtils();
        String x$5 = dir.consumerRegistryDir();
        java.util.List x$6 = qual$2.makeSurePersistentPathExists$default$2();
        qual$2.makeSurePersistentPathExists(x$5, x$6);
        if (registerConsumer) {
            ZkUtils qual$3 = this.zkUtils();
            String x$7 = new StringBuilder().append((Object)dir.consumerRegistryDir()).append((Object)"/").append((Object)consumerId).toString();
            String x$8 = "";
            java.util.List x$9 = qual$3.createEphemeralPathExpectConflict$default$3();
            qual$3.createEphemeralPathExpectConflict(x$7, x$8, x$9);
        }
    }

    public boolean kafka$admin$DeleteConsumerGroupTest$$groupDirExists(ZKGroupDirs dir) {
        return this.zkUtils().pathExists(dir.consumerGroupDir());
    }

    public boolean kafka$admin$DeleteConsumerGroupTest$$groupTopicOffsetAndOwnerDirsExist(ZKGroupTopicDirs dir) {
        return this.zkUtils().pathExists(dir.consumerOffsetDir()) && this.zkUtils().pathExists(dir.consumerOwnerDir());
    }

    private void produceEvents(KafkaProducer<byte[], byte[]> producer, String topic, List<String> messages) {
        messages.foreach((Function1)new Serializable(this, producer, topic){
            public static final long serialVersionUID = 0L;
            private final KafkaProducer producer$1;
            private final String topic$2;

            public final Future<RecordMetadata> apply(String message) {
                return this.producer$1.send(new ProducerRecord(this.topic$2, (Object)message.getBytes(StandardCharsets.UTF_8)));
            }
            {
                this.producer$1 = producer$1;
                this.topic$2 = topic$2;
            }
        });
    }

    private void consumeEvents(KafkaStream<byte[], byte[]> messageStream, int n) {
        ConsumerIterator iter = messageStream.iterator();
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), n).foreach((Function1)new Serializable(this, iter){
            public static final long serialVersionUID = 0L;
            private final ConsumerIterator iter$1;

            public final MessageAndMetadata<byte[], byte[]> apply(int x$1) {
                return this.iter$1.next();
            }
            {
                this.iter$1 = iter$1;
            }
        });
    }
}

