/*
 * Decompiled with CFR 0.152.
 */
package kafka.admin;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Properties;
import kafka.admin.ConsumerGroupCommand;
import kafka.admin.ConsumerGroupCommandTest;
import kafka.admin.RackAwareMode;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.utils.TestUtils$;
import kafka.zk.AdminZkClient;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.common.TopicPartition;
import org.junit.Assert;
import org.junit.Test;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Map;
import scala.math.Numeric;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005\u001dh\u0001B\u0001\u0003\u0001\u001d\u0011ADU3tKR\u001cuN\\:v[\u0016\u0014xI]8va>3gm]3u)\u0016\u001cHO\u0003\u0002\u0004\t\u0005)\u0011\rZ7j]*\tQ!A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0005\u0001A\u0001CA\u0005\u000b\u001b\u0005\u0011\u0011BA\u0006\u0003\u0005a\u0019uN\\:v[\u0016\u0014xI]8va\u000e{W.\\1oIR+7\u000f\u001e\u0005\u0006\u001b\u0001!\tAD\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003=\u0001\"!\u0003\u0001\t\u000fE\u0001!\u0019!C\u0001%\u0005yqN^3se&$\u0017N\\4Qe>\u00048/F\u0001\u0014!\t!\u0012$D\u0001\u0016\u0015\t1r#\u0001\u0003vi&d'\"\u0001\r\u0002\t)\fg/Y\u0005\u00035U\u0011!\u0002\u0015:pa\u0016\u0014H/[3t\u0011\u0019a\u0002\u0001)A\u0005'\u0005\u0001rN^3se&$\u0017N\\4Qe>\u00048\u000f\t\u0005\b=\u0001\u0011\r\u0011\"\u0001 \u0003\u0019!x\u000e]5dcU\t\u0001\u0005\u0005\u0002\"I5\t!E\u0003\u0002$/\u0005!A.\u00198h\u0013\t)#E\u0001\u0004TiJLgn\u001a\u0005\u0007O\u0001\u0001\u000b\u0011\u0002\u0011\u0002\u000fQ|\u0007/[22A!9\u0011\u0006\u0001b\u0001\n\u0003y\u0012A\u0002;pa&\u001c'\u0007\u0003\u0004,\u0001\u0001\u0006I\u0001I\u0001\bi>\u0004\u0018n\u0019\u001a!\u0011\u0015i\u0003\u0001\"\u0011/\u0003=9WM\\3sCR,7i\u001c8gS\u001e\u001cX#A\u0018\u0011\u0007ARTH\u0004\u00022o9\u0011!'N\u0007\u0002g)\u0011AGB\u0001\u0007yI|w\u000e\u001e \n\u0003Y\nQa]2bY\u0006L!\u0001O\u001d\u0002\u000fA\f7m[1hK*\ta'\u0003\u0002<y\t\u00191+Z9\u000b\u0005aJ\u0004C\u0001 B\u001b\u0005y$B\u0001!\u0005\u0003\u0019\u0019XM\u001d<fe&\u0011!i\u0010\u0002\f\u0017\u000647.Y\"p]\u001aLw\rC\u0003E\u0001\u0011\u0005Q)\u0001\u0011uKN$(+Z:fi>3gm]3ug:{G/\u0012=jgRLgnZ$s_V\u0004H#\u0001$\u0011\u0005\u001dCU\"A\u001d\n\u0005%K$\u0001B+oSRD#aQ&\u0011\u00051\u000bV\"A'\u000b\u00059{\u0015!\u00026v]&$(\"\u0001)\u0002\u0007=\u0014x-\u0003\u0002S\u001b\n!A+Z:u\u0011\u0015!\u0006\u0001\"\u0001F\u0003!\"Xm\u001d;SKN,Go\u00144gg\u0016$8OT3x\u0007>t7/^7fe\u0016C\u0018n\u001d;j]\u001e$v\u000e]5dQ\t\u00196\nC\u0003X\u0001\u0011\u0005Q)A\u0010uKN$(+Z:fi>3gm]3ugR{Gj\\2bY\u0012\u000bG/\u001a+j[\u0016D#AV&\t\u000bi\u0003A\u0011A#\u0002?Q,7\u000f\u001e*fg\u0016$xJ\u001a4tKR\u001cHk\u001c.p]\u0016$G)\u0019;f)&lW\r\u000b\u0002Z\u0017\")Q\f\u0001C\u0001\u000b\u0006QB/Z:u%\u0016\u001cX\r^(gMN,Go\u001d\"z\tV\u0014\u0018\r^5p]\"\u0012Al\u0013\u0005\u0006A\u0002!\t!R\u0001%i\u0016\u001cHOU3tKR|eMZ:fiN\u0014\u0015\u0010R;sCRLwN\u001c+p\u000b\u0006\u0014H.[3ti\"\u0012ql\u0013\u0005\u0006G\u0002!\t!R\u0001\u001bi\u0016\u001cHOU3tKR|eMZ:fiN$v.R1sY&,7\u000f\u001e\u0015\u0003E.CQA\u001a\u0001\u0005\u0002\u0015\u000b\u0001\u0004^3tiJ+7/\u001a;PM\u001a\u001cX\r^:U_2\u000bG/Z:uQ\t)7\nC\u0003j\u0001\u0011\u0005Q)A\u0010uKN$(+Z:fi>3gm]3ugR{7)\u001e:sK:$xJ\u001a4tKRD#\u0001[&\t\u000b1\u0004A\u0011A#\u0002AQ,7\u000f\u001e*fg\u0016$xJ\u001a4tKR\u001cHk\\*qK\u000eLg-[2PM\u001a\u001cX\r\u001e\u0015\u0003W.CQa\u001c\u0001\u0005\u0002\u0015\u000b\u0011\u0004^3tiJ+7/\u001a;PM\u001a\u001cX\r^:TQ&4G\u000f\u00157vg\"\u0012an\u0013\u0005\u0006e\u0002!\t!R\u0001\u001bi\u0016\u001cHOU3tKR|eMZ:fiN\u001c\u0006.\u001b4u\u001b&tWo\u001d\u0015\u0003c.CQ!\u001e\u0001\u0005\u0002\u0015\u000b\u0001\u0006^3tiJ+7/\u001a;PM\u001a\u001cX\r^:TQ&4GOQ=M_^,'\u000f\u00165b]\u0016\u000b'\u000f\\5fgRD#\u0001^&\t\u000ba\u0004A\u0011A#\u0002OQ,7\u000f\u001e*fg\u0016$xJ\u001a4tKR\u001c8\u000b[5gi\nK\b*[4iKJ$\u0006.\u00198MCR,7\u000f\u001e\u0015\u0003o.CQa\u001f\u0001\u0005\u0002\u0015\u000bA\u0005^3tiJ+7/\u001a;PM\u001a\u001cX\r^:U_\u0016\u000b'\u000f\\5fgR|en\u00148f)>\u0004\u0018n\u0019\u0015\u0003u.CQA \u0001\u0005\u0002\u0015\u000b\u0001\u0007^3tiJ+7/\u001a;PM\u001a\u001cX\r^:U_\u0016\u000b'\u000f\\5fgR|en\u00148f)>\u0004\u0018nY!oIB\u000b'\u000f^5uS>t\u0007FA?L\u0011\u0019\t\u0019\u0001\u0001C\u0001\u000b\u0006\u0011C/Z:u%\u0016\u001cX\r^(gMN,Go\u001d+p\u000b\u0006\u0014H.[3ti>sGk\u001c9jGND3!!\u0001L\u0011\u0019\tI\u0001\u0001C\u0001\u000b\u0006yC/Z:u%\u0016\u001cX\r^(gMN,Go\u001d+p\u000b\u0006\u0014H.[3ti>sGk\u001c9jGN\fe\u000e\u001a)beRLG/[8og\"\u001a\u0011qA&\t\r\u0005=\u0001\u0001\"\u0001F\u0003\u0001\"Xm\u001d;SKN,Go\u00144gg\u0016$8/\u0012=q_J$\u0018*\u001c9peR\u0004F.\u00198)\u0007\u000551\nC\u0004\u0002\u0016\u0001!I!a\u0006\u00023A\u0014x\u000eZ;dK\u000e{gn];nK\u0006sGm\u00155vi\u0012|wO\u001c\u000b\b\r\u0006e\u00111EA\u0014\u0011!\tY\"a\u0005A\u0002\u0005u\u0011!\u0004;pi\u0006dW*Z:tC\u001e,7\u000fE\u0002H\u0003?I1!!\t:\u0005\rIe\u000e\u001e\u0005\u000b\u0003K\t\u0019\u0002%AA\u0002\u0005u\u0011\u0001\u00048v[\u000e{gn];nKJ\u001c\bBCA\u0015\u0003'\u0001\n\u00111\u0001\u0002,\u0005)Ao\u001c9jGB!\u0011QFA\u001a\u001d\r9\u0015qF\u0005\u0004\u0003cI\u0014A\u0002)sK\u0012,g-C\u0002&\u0003kQ1!!\r:\u0011\u001d\tI\u0004\u0001C\u0005\u0003w\tQ#Y<bSR\u001cuN\\:v[\u0016\u0014\bK]8he\u0016\u001c8\u000fF\u0003G\u0003{\ty\u0004\u0003\u0006\u0002*\u0005]\u0002\u0013!a\u0001\u0003WA\u0001\"!\u0011\u00028\u0001\u0007\u00111I\u0001\u0006G>,h\u000e\u001e\t\u0004\u000f\u0006\u0015\u0013bAA$s\t!Aj\u001c8h\u0011\u001d\tY\u0005\u0001C\u0005\u0003\u001b\nQC]3tKR\fe\u000eZ!tg\u0016\u0014Ho\u00144gg\u0016$8\u000fF\u0005G\u0003\u001f\nI&!\u0018\u0002b!A\u0011\u0011KA%\u0001\u0004\t\u0019&\u0001\u0003be\u001e\u001c\b#B$\u0002V\u0005-\u0012bAA,s\t)\u0011I\u001d:bs\"A\u00111LA%\u0001\u0004\t\u0019%\u0001\bfqB,7\r^3e\u001f\u001a47/\u001a;\t\u0015\u0005}\u0013\u0011\nI\u0001\u0002\u0004\tY#A\u0003he>,\b\u000f\u0003\u0006\u0002d\u0005%\u0003\u0013!a\u0001\u0003K\na\u0001\u001a:z%Vt\u0007cA$\u0002h%\u0019\u0011\u0011N\u001d\u0003\u000f\t{w\u000e\\3b]\"9\u0011Q\u000e\u0001\u0005\n\u0005=\u0014A\b:fg\u0016$\u0018I\u001c3BgN,'\u000f^(gMN,Go]\"p[6LG\u000f^3e)\u001d1\u0015\u0011OAF\u0003OC\u0001\"a\u001d\u0002l\u0001\u0007\u0011QO\u0001\u0015G>t7/^7fe\u001e\u0013x.\u001e9TKJ4\u0018nY3\u0011\t\u0005]\u0014Q\u0011\b\u0005\u0003s\n\tI\u0004\u0003\u0002|\u0005}db\u0001\u001a\u0002~%\tQ!\u0003\u0002\u0004\t%\u0019\u00111\u0011\u0002\u0002)\r{gn];nKJ<%o\\;q\u0007>lW.\u00198e\u0013\u0011\t9)!#\u0003)\r{gn];nKJ<%o\\;q'\u0016\u0014h/[2f\u0015\r\t\u0019I\u0001\u0005\t\u0003\u001b\u000bY\u00071\u0001\u0002\u0010\u0006yQ\r\u001f9fGR,Gm\u00144gg\u0016$8\u000f\u0005\u0005\u0002.\u0005E\u0015QSA\"\u0013\u0011\t\u0019*!\u000e\u0003\u00075\u000b\u0007\u000f\u0005\u0003\u0002\u0018\u0006\rVBAAM\u0015\u0011\tY*!(\u0002\r\r|W.\\8o\u0015\r)\u0011q\u0014\u0006\u0004\u0003C{\u0015AB1qC\u000eDW-\u0003\u0003\u0002&\u0006e%A\u0004+pa&\u001c\u0007+\u0019:uSRLwN\u001c\u0005\u000b\u0003S\tY\u0007%AA\u0002\u0005-\u0002bBAV\u0001\u0011%\u0011QV\u0001\re\u0016\u001cX\r^(gMN,Go\u001d\u000b\u0005\u0003\u001f\u000by\u000b\u0003\u0005\u0002t\u0005%\u0006\u0019AA;\u0011%\t\u0019\fAI\u0001\n\u0013\t),A\u0010sKN,G/\u00118e\u0003N\u001cXM\u001d;PM\u001a\u001cX\r^:%I\u00164\u0017-\u001e7uIM*\"!a.+\t\u0005-\u0012\u0011X\u0016\u0003\u0003w\u0003B!!0\u0002H6\u0011\u0011q\u0018\u0006\u0005\u0003\u0003\f\u0019-A\u0005v]\u000eDWmY6fI*\u0019\u0011QY\u001d\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002J\u0006}&!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\"I\u0011Q\u001a\u0001\u0012\u0002\u0013%\u0011qZ\u0001 e\u0016\u001cX\r^!oI\u0006\u001b8/\u001a:u\u001f\u001a47/\u001a;tI\u0011,g-Y;mi\u0012\"TCAAiU\u0011\t)'!/\t\u0013\u0005U\u0007!%A\u0005\n\u0005U\u0016aH1xC&$8i\u001c8tk6,'\u000f\u0015:pOJ,7o\u001d\u0013eK\u001a\fW\u000f\u001c;%c!I\u0011\u0011\u001c\u0001\u0012\u0002\u0013%\u00111\\\u0001$aJ|G-^2f\u0007>t7/^7f\u0003:$7\u000b[;uI><h\u000e\n3fM\u0006,H\u000e\u001e\u00133+\t\tiN\u000b\u0003\u0002\u001e\u0005e\u0006\"CAq\u0001E\u0005I\u0011BA[\u0003\r\u0002(o\u001c3vG\u0016\u001cuN\\:v[\u0016\fe\u000eZ*ikR$wn\u001e8%I\u00164\u0017-\u001e7uIMB\u0011\"!:\u0001#\u0003%I!!.\u0002QI,7/\u001a;B]\u0012\f5o]3si>3gm]3ug\u000e{W.\\5ui\u0016$G\u0005Z3gCVdG\u000fJ\u001a")
public class ResetConsumerGroupOffsetTest
extends ConsumerGroupCommandTest {
    private final Properties overridingProps = new Properties();
    private final String topic1;
    private final String topic2;

    public Properties overridingProps() {
        return this.overridingProps;
    }

    public String topic1() {
        return this.topic1;
    }

    public String topic2() {
        return this.topic2;
    }

    @Override
    public Seq<KafkaConfig> generateConfigs() {
        return (Seq)TestUtils$.MODULE$.createBrokerConfigs(1, this.zkConnect(), false, TestUtils$.MODULE$.createBrokerConfigs$default$4(), TestUtils$.MODULE$.createBrokerConfigs$default$5(), TestUtils$.MODULE$.createBrokerConfigs$default$6(), TestUtils$.MODULE$.createBrokerConfigs$default$7(), TestUtils$.MODULE$.createBrokerConfigs$default$8(), TestUtils$.MODULE$.createBrokerConfigs$default$9(), TestUtils$.MODULE$.createBrokerConfigs$default$10(), TestUtils$.MODULE$.createBrokerConfigs$default$11(), TestUtils$.MODULE$.createBrokerConfigs$default$12(), TestUtils$.MODULE$.createBrokerConfigs$default$13(), TestUtils$.MODULE$.createBrokerConfigs$default$14()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ResetConsumerGroupOffsetTest $outer;

            public final KafkaConfig apply(Properties x$1) {
                return KafkaConfig$.MODULE$.fromProps(x$1, this.$outer.overridingProps());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, Seq$.MODULE$.canBuildFrom());
    }

    @Test
    public void testResetOffsetsNotExistingGroup() {
        String[] args = (String[])((Object[])new String[]{"--bootstrap-server", this.brokerList(), "--reset-offsets", "--group", "missing.group", "--all-topics", "--to-current", "--execute"});
        ConsumerGroupCommand.ConsumerGroupService consumerGroupCommand = this.getConsumerGroupService(args);
        Map resetOffsets2 = consumerGroupCommand.resetOffsets();
        Assert.assertEquals((Object)Predef$.MODULE$.Map().empty(), (Object)resetOffsets2);
        String x$5 = "missing.group";
        String x$6 = this.committedOffsets$default$1();
        Assert.assertEquals((Object)resetOffsets2, this.committedOffsets(x$6, x$5));
    }

    @Test
    public void testResetOffsetsNewConsumerExistingTopic() {
        String[] args = (String[])((Object[])new String[]{"--bootstrap-server", this.brokerList(), "--reset-offsets", "--group", "new.group", "--topic", this.topic(), "--to-offset", "50"});
        TestUtils$.MODULE$.produceMessages((Seq<KafkaServer>)this.servers(), this.topic(), 100, 1, 100000);
        String[] x$7 = args;
        long x$8 = 50L;
        boolean x$9 = true;
        String x$10 = this.resetAndAssertOffsets$default$3();
        this.resetAndAssertOffsets(x$7, x$8, x$10, x$9);
        String[] x$11 = (String[])Predef$.MODULE$.refArrayOps((Object[])args).$plus$plus((GenTraversableOnce)Predef$.MODULE$.refArrayOps((Object[])new String[]{"--dry-run"}), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
        long x$12 = 50L;
        boolean x$13 = true;
        String x$14 = this.resetAndAssertOffsets$default$3();
        this.resetAndAssertOffsets(x$11, x$12, x$14, x$13);
        this.resetAndAssertOffsets((String[])Predef$.MODULE$.refArrayOps((Object[])args).$plus$plus((GenTraversableOnce)Predef$.MODULE$.refArrayOps((Object[])new String[]{"--execute"}), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))), 50L, "new.group", this.resetAndAssertOffsets$default$4());
    }

    @Test
    public void testResetOffsetsToLocalDateTime() {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS");
        Calendar calendar = Calendar.getInstance();
        calendar.add(5, -1);
        TestUtils$.MODULE$.produceMessages((Seq<KafkaServer>)this.servers(), this.topic(), 100, 1, 100000);
        ConsumerGroupCommandTest.ConsumerGroupExecutor executor = this.addConsumerGroupExecutor(1, this.topic(), this.addConsumerGroupExecutor$default$3(), this.addConsumerGroupExecutor$default$4());
        long x$15 = 100L;
        String x$16 = this.awaitConsumerProgress$default$1();
        this.awaitConsumerProgress(x$16, x$15);
        executor.shutdown();
        String[] args = (String[])((Object[])new String[]{"--bootstrap-server", this.brokerList(), "--reset-offsets", "--group", this.group(), "--all-topics", "--to-datetime", format.format(calendar.getTime()), "--execute"});
        this.resetAndAssertOffsets(args, 0L, this.resetAndAssertOffsets$default$3(), this.resetAndAssertOffsets$default$4());
    }

    @Test
    public void testResetOffsetsToZonedDateTime() {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSXXX");
        TestUtils$.MODULE$.produceMessages((Seq<KafkaServer>)this.servers(), this.topic(), 50, 1, 100000);
        Date checkpoint = new Date();
        TestUtils$.MODULE$.produceMessages((Seq<KafkaServer>)this.servers(), this.topic(), 50, 1, 100000);
        ConsumerGroupCommandTest.ConsumerGroupExecutor executor = this.addConsumerGroupExecutor(1, this.topic(), this.addConsumerGroupExecutor$default$3(), this.addConsumerGroupExecutor$default$4());
        long x$17 = 100L;
        String x$18 = this.awaitConsumerProgress$default$1();
        this.awaitConsumerProgress(x$18, x$17);
        executor.shutdown();
        String[] args = (String[])((Object[])new String[]{"--bootstrap-server", this.brokerList(), "--reset-offsets", "--group", this.group(), "--all-topics", "--to-datetime", format.format(checkpoint), "--execute"});
        this.resetAndAssertOffsets(args, 50L, this.resetAndAssertOffsets$default$3(), this.resetAndAssertOffsets$default$4());
    }

    @Test
    public void testResetOffsetsByDuration() {
        String[] args = (String[])((Object[])new String[]{"--bootstrap-server", this.brokerList(), "--reset-offsets", "--group", this.group(), "--all-topics", "--by-duration", "PT1M", "--execute"});
        this.produceConsumeAndShutdown(100, this.produceConsumeAndShutdown$default$2(), this.produceConsumeAndShutdown$default$3());
        this.resetAndAssertOffsets(args, 0L, this.resetAndAssertOffsets$default$3(), this.resetAndAssertOffsets$default$4());
    }

    @Test
    public void testResetOffsetsByDurationToEarliest() {
        String[] args = (String[])((Object[])new String[]{"--bootstrap-server", this.brokerList(), "--reset-offsets", "--group", this.group(), "--all-topics", "--by-duration", "PT0.1S", "--execute"});
        this.produceConsumeAndShutdown(100, this.produceConsumeAndShutdown$default$2(), this.produceConsumeAndShutdown$default$3());
        this.resetAndAssertOffsets(args, 100L, this.resetAndAssertOffsets$default$3(), this.resetAndAssertOffsets$default$4());
    }

    @Test
    public void testResetOffsetsToEarliest() {
        String[] args = (String[])((Object[])new String[]{"--bootstrap-server", this.brokerList(), "--reset-offsets", "--group", this.group(), "--all-topics", "--to-earliest", "--execute"});
        this.produceConsumeAndShutdown(100, this.produceConsumeAndShutdown$default$2(), this.produceConsumeAndShutdown$default$3());
        this.resetAndAssertOffsets(args, 0L, this.resetAndAssertOffsets$default$3(), this.resetAndAssertOffsets$default$4());
    }

    @Test
    public void testResetOffsetsToLatest() {
        String[] args = (String[])((Object[])new String[]{"--bootstrap-server", this.brokerList(), "--reset-offsets", "--group", this.group(), "--all-topics", "--to-latest", "--execute"});
        this.produceConsumeAndShutdown(100, this.produceConsumeAndShutdown$default$2(), this.produceConsumeAndShutdown$default$3());
        TestUtils$.MODULE$.produceMessages((Seq<KafkaServer>)this.servers(), this.topic(), 100, 1, 100000);
        this.resetAndAssertOffsets(args, 200L, this.resetAndAssertOffsets$default$3(), this.resetAndAssertOffsets$default$4());
    }

    @Test
    public void testResetOffsetsToCurrentOffset() {
        String[] args = (String[])((Object[])new String[]{"--bootstrap-server", this.brokerList(), "--reset-offsets", "--group", this.group(), "--all-topics", "--to-current", "--execute"});
        this.produceConsumeAndShutdown(100, this.produceConsumeAndShutdown$default$2(), this.produceConsumeAndShutdown$default$3());
        TestUtils$.MODULE$.produceMessages((Seq<KafkaServer>)this.servers(), this.topic(), 100, 1, 100000);
        this.resetAndAssertOffsets(args, 100L, this.resetAndAssertOffsets$default$3(), this.resetAndAssertOffsets$default$4());
    }

    @Test
    public void testResetOffsetsToSpecificOffset() {
        String[] args = (String[])((Object[])new String[]{"--bootstrap-server", this.brokerList(), "--reset-offsets", "--group", this.group(), "--all-topics", "--to-offset", "1", "--execute"});
        this.produceConsumeAndShutdown(100, this.produceConsumeAndShutdown$default$2(), this.produceConsumeAndShutdown$default$3());
        this.resetAndAssertOffsets(args, 1L, this.resetAndAssertOffsets$default$3(), this.resetAndAssertOffsets$default$4());
    }

    @Test
    public void testResetOffsetsShiftPlus() {
        String[] args = (String[])((Object[])new String[]{"--bootstrap-server", this.brokerList(), "--reset-offsets", "--group", this.group(), "--all-topics", "--shift-by", "50", "--execute"});
        this.produceConsumeAndShutdown(100, this.produceConsumeAndShutdown$default$2(), this.produceConsumeAndShutdown$default$3());
        TestUtils$.MODULE$.produceMessages((Seq<KafkaServer>)this.servers(), this.topic(), 100, 1, 100000);
        this.resetAndAssertOffsets(args, 150L, this.resetAndAssertOffsets$default$3(), this.resetAndAssertOffsets$default$4());
    }

    @Test
    public void testResetOffsetsShiftMinus() {
        String[] args = (String[])((Object[])new String[]{"--bootstrap-server", this.brokerList(), "--reset-offsets", "--group", this.group(), "--all-topics", "--shift-by", "-50", "--execute"});
        this.produceConsumeAndShutdown(100, this.produceConsumeAndShutdown$default$2(), this.produceConsumeAndShutdown$default$3());
        TestUtils$.MODULE$.produceMessages((Seq<KafkaServer>)this.servers(), this.topic(), 100, 1, 100000);
        this.resetAndAssertOffsets(args, 50L, this.resetAndAssertOffsets$default$3(), this.resetAndAssertOffsets$default$4());
    }

    @Test
    public void testResetOffsetsShiftByLowerThanEarliest() {
        String[] args = (String[])((Object[])new String[]{"--bootstrap-server", this.brokerList(), "--reset-offsets", "--group", this.group(), "--all-topics", "--shift-by", "-150", "--execute"});
        this.produceConsumeAndShutdown(100, this.produceConsumeAndShutdown$default$2(), this.produceConsumeAndShutdown$default$3());
        TestUtils$.MODULE$.produceMessages((Seq<KafkaServer>)this.servers(), this.topic(), 100, 1, 100000);
        this.resetAndAssertOffsets(args, 0L, this.resetAndAssertOffsets$default$3(), this.resetAndAssertOffsets$default$4());
    }

    @Test
    public void testResetOffsetsShiftByHigherThanLatest() {
        String[] args = (String[])((Object[])new String[]{"--bootstrap-server", this.brokerList(), "--reset-offsets", "--group", this.group(), "--all-topics", "--shift-by", "150", "--execute"});
        this.produceConsumeAndShutdown(100, this.produceConsumeAndShutdown$default$2(), this.produceConsumeAndShutdown$default$3());
        TestUtils$.MODULE$.produceMessages((Seq<KafkaServer>)this.servers(), this.topic(), 100, 1, 100000);
        this.resetAndAssertOffsets(args, 200L, this.resetAndAssertOffsets$default$3(), this.resetAndAssertOffsets$default$4());
    }

    @Test
    public void testResetOffsetsToEarliestOnOneTopic() {
        String[] args = (String[])((Object[])new String[]{"--bootstrap-server", this.brokerList(), "--reset-offsets", "--group", this.group(), "--topic", this.topic(), "--to-earliest", "--execute"});
        this.produceConsumeAndShutdown(100, this.produceConsumeAndShutdown$default$2(), this.produceConsumeAndShutdown$default$3());
        this.resetAndAssertOffsets(args, 0L, this.resetAndAssertOffsets$default$3(), this.resetAndAssertOffsets$default$4());
    }

    @Test
    public void testResetOffsetsToEarliestOnOneTopicAndPartition() {
        String topic = "bar";
        AdminZkClient qual$1 = this.adminZkClient();
        String x$19 = topic;
        int x$20 = 2;
        int x$21 = 1;
        Properties x$22 = qual$1.createTopic$default$4();
        RackAwareMode x$23 = qual$1.createTopic$default$5();
        qual$1.createTopic(x$19, x$20, x$21, x$22, x$23);
        String[] args = (String[])((Object[])new String[]{"--bootstrap-server", this.brokerList(), "--reset-offsets", "--group", this.group(), "--topic", new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ":1"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topic})), "--to-earliest", "--execute"});
        ConsumerGroupCommand.ConsumerGroupService consumerGroupCommand = this.getConsumerGroupService(args);
        this.produceConsumeAndShutdown(100, 2, topic);
        Map<TopicPartition, Object> priorCommittedOffsets = this.committedOffsets(topic, this.committedOffsets$default$2());
        TopicPartition tp0 = new TopicPartition(topic, 0);
        TopicPartition tp1 = new TopicPartition(topic, 1);
        Map expectedOffsets = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp0), priorCommittedOffsets.apply((Object)tp0)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp1), (Object)BoxesRunTime.boxToLong((long)0L))}));
        this.resetAndAssertOffsetsCommitted(consumerGroupCommand, (Map<TopicPartition, Object>)expectedOffsets, topic);
        this.adminZkClient().deleteTopic(topic);
    }

    @Test
    public void testResetOffsetsToEarliestOnTopics() {
        String topic1 = "topic1";
        String topic2 = "topic2";
        AdminZkClient qual$2 = this.adminZkClient();
        String x$24 = topic1;
        int x$25 = 1;
        int x$26 = 1;
        Properties x$27 = qual$2.createTopic$default$4();
        RackAwareMode x$28 = qual$2.createTopic$default$5();
        qual$2.createTopic(x$24, x$25, x$26, x$27, x$28);
        AdminZkClient qual$3 = this.adminZkClient();
        String x$29 = topic2;
        int x$30 = 1;
        int x$31 = 1;
        Properties x$32 = qual$3.createTopic$default$4();
        RackAwareMode x$33 = qual$3.createTopic$default$5();
        qual$3.createTopic(x$29, x$30, x$31, x$32, x$33);
        String[] args = (String[])((Object[])new String[]{"--bootstrap-server", this.brokerList(), "--reset-offsets", "--group", this.group(), "--topic", topic1, "--topic", topic2, "--to-earliest", "--execute"});
        ConsumerGroupCommand.ConsumerGroupService consumerGroupCommand = this.getConsumerGroupService(args);
        this.produceConsumeAndShutdown(100, 1, topic1);
        this.produceConsumeAndShutdown(100, 1, topic2);
        TopicPartition tp1 = new TopicPartition(topic1, 0);
        TopicPartition tp2 = new TopicPartition(topic2, 0);
        Map<TopicPartition, Object> allResetOffsets = this.resetOffsets(consumerGroupCommand);
        Assert.assertEquals((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp1), (Object)BoxesRunTime.boxToLong((long)0L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp2), (Object)BoxesRunTime.boxToLong((long)0L))})), allResetOffsets);
        Assert.assertEquals((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp1), (Object)BoxesRunTime.boxToLong((long)0L))})), this.committedOffsets(topic1, this.committedOffsets$default$2()));
        Assert.assertEquals((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp2), (Object)BoxesRunTime.boxToLong((long)0L))})), this.committedOffsets(topic2, this.committedOffsets$default$2()));
        this.adminZkClient().deleteTopic(topic1);
        this.adminZkClient().deleteTopic(topic2);
    }

    @Test
    public void testResetOffsetsToEarliestOnTopicsAndPartitions() {
        String topic1 = "topic1";
        String topic2 = "topic2";
        AdminZkClient qual$4 = this.adminZkClient();
        String x$34 = topic1;
        int x$35 = 2;
        int x$36 = 1;
        Properties x$37 = qual$4.createTopic$default$4();
        RackAwareMode x$38 = qual$4.createTopic$default$5();
        qual$4.createTopic(x$34, x$35, x$36, x$37, x$38);
        AdminZkClient qual$5 = this.adminZkClient();
        String x$39 = topic2;
        int x$40 = 2;
        int x$41 = 1;
        Properties x$42 = qual$5.createTopic$default$4();
        RackAwareMode x$43 = qual$5.createTopic$default$5();
        qual$5.createTopic(x$39, x$40, x$41, x$42, x$43);
        String[] args = (String[])((Object[])new String[]{"--bootstrap-server", this.brokerList(), "--reset-offsets", "--group", this.group(), "--topic", new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ":1"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topic1})), "--topic", new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ":1"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topic2})), "--to-earliest", "--execute"});
        ConsumerGroupCommand.ConsumerGroupService consumerGroupCommand = this.getConsumerGroupService(args);
        this.produceConsumeAndShutdown(100, 2, topic1);
        this.produceConsumeAndShutdown(100, 2, topic2);
        Map<TopicPartition, Object> priorCommittedOffsets1 = this.committedOffsets(topic1, this.committedOffsets$default$2());
        Map<TopicPartition, Object> priorCommittedOffsets2 = this.committedOffsets(topic2, this.committedOffsets$default$2());
        TopicPartition tp1 = new TopicPartition(topic1, 1);
        TopicPartition tp2 = new TopicPartition(topic2, 1);
        Map<TopicPartition, Object> allResetOffsets = this.resetOffsets(consumerGroupCommand);
        Assert.assertEquals((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp1), (Object)BoxesRunTime.boxToInteger((int)0)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp2), (Object)BoxesRunTime.boxToInteger((int)0))})), allResetOffsets);
        Assert.assertEquals((Object)priorCommittedOffsets1.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp1), (Object)BoxesRunTime.boxToLong((long)0L))), this.committedOffsets(topic1, this.committedOffsets$default$2()));
        Assert.assertEquals((Object)priorCommittedOffsets2.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp2), (Object)BoxesRunTime.boxToLong((long)0L))), this.committedOffsets(topic2, this.committedOffsets$default$2()));
        this.adminZkClient().deleteTopic(topic1);
        this.adminZkClient().deleteTopic(topic2);
    }

    @Test
    public void testResetOffsetsExportImportPlan() {
        String topic = "bar";
        TopicPartition tp0 = new TopicPartition(topic, 0);
        TopicPartition tp1 = new TopicPartition(topic, 1);
        AdminZkClient qual$6 = this.adminZkClient();
        String x$44 = topic;
        int x$45 = 2;
        int x$46 = 1;
        Properties x$47 = qual$6.createTopic$default$4();
        RackAwareMode x$48 = qual$6.createTopic$default$5();
        qual$6.createTopic(x$44, x$45, x$46, x$47, x$48);
        String[] cgcArgs = (String[])((Object[])new String[]{"--bootstrap-server", this.brokerList(), "--reset-offsets", "--group", this.group(), "--all-topics", "--to-offset", "2", "--export"});
        ConsumerGroupCommand.ConsumerGroupService consumerGroupCommand = this.getConsumerGroupService(cgcArgs);
        this.produceConsumeAndShutdown(100, 2, topic);
        File file = File.createTempFile("reset", ".csv");
        file.deleteOnExit();
        Map exportedOffsets = consumerGroupCommand.resetOffsets();
        BufferedWriter bw = new BufferedWriter(new FileWriter(file));
        bw.write(consumerGroupCommand.exportOffsetsToReset(exportedOffsets));
        bw.close();
        Assert.assertEquals((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp0), (Object)BoxesRunTime.boxToLong((long)2L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp1), (Object)BoxesRunTime.boxToLong((long)2L))})), (Object)exportedOffsets.mapValues((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply(OffsetAndMetadata x$2) {
                return x$2.offset();
            }
        }));
        String[] cgcArgsExec = (String[])((Object[])new String[]{"--bootstrap-server", this.brokerList(), "--reset-offsets", "--group", this.group(), "--all-topics", "--from-file", file.getCanonicalPath(), "--dry-run"});
        ConsumerGroupCommand.ConsumerGroupService consumerGroupCommandExec = this.getConsumerGroupService(cgcArgsExec);
        Map importedOffsets = consumerGroupCommandExec.resetOffsets();
        Assert.assertEquals((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp0), (Object)BoxesRunTime.boxToLong((long)2L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp1), (Object)BoxesRunTime.boxToLong((long)2L))})), (Object)importedOffsets.mapValues((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply(OffsetAndMetadata x$3) {
                return x$3.offset();
            }
        }));
        this.adminZkClient().deleteTopic(topic);
    }

    private void produceConsumeAndShutdown(int totalMessages, int numConsumers, String topic) {
        TestUtils$.MODULE$.produceMessages((Seq<KafkaServer>)this.servers(), topic, totalMessages, 1, 100000);
        ConsumerGroupCommandTest.ConsumerGroupExecutor executor = this.addConsumerGroupExecutor(numConsumers, topic, this.addConsumerGroupExecutor$default$3(), this.addConsumerGroupExecutor$default$4());
        this.awaitConsumerProgress(topic, totalMessages);
        executor.shutdown();
    }

    private int produceConsumeAndShutdown$default$2() {
        return 1;
    }

    private String produceConsumeAndShutdown$default$3() {
        return this.topic();
    }

    private void awaitConsumerProgress(String topic, long count) {
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, topic, count){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ResetConsumerGroupOffsetTest $outer;
            private final String topic$1;
            private final long count$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                Iterable offsets = this.$outer.committedOffsets(this.topic$1, this.$outer.committedOffsets$default$2()).values();
                return this.count$1 == BoxesRunTime.unboxToLong((Object)offsets.sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.topic$1 = topic$1;
                this.count$1 = count$1;
            }
        }, (Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Expected that consumer group has consumed all messages from topic/partition.";
            }
        }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
    }

    private String awaitConsumerProgress$default$1() {
        return this.topic();
    }

    /*
     * WARNING - void declaration
     */
    private void resetAndAssertOffsets(String[] args, long expectedOffset, String group, boolean dryRun) {
        ConsumerGroupCommand.ConsumerGroupService consumerGroupCommand = this.getConsumerGroupService(args);
        try {
            String x$49 = group;
            String x$50 = this.committedOffsets$default$1();
            Map priorOffsets = this.committedOffsets(x$50, x$49);
            Map expectedOffsets = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition(this.topic(), 0)), (Object)BoxesRunTime.boxToLong((long)expectedOffset))}));
            Assert.assertEquals((Object)expectedOffsets, this.resetOffsets(consumerGroupCommand));
            String x$51 = group;
            String x$52 = this.committedOffsets$default$1();
            Assert.assertEquals((Object)(dryRun ? priorOffsets : expectedOffsets), this.committedOffsets(x$52, x$51));
        }
        catch (Throwable throwable) {
            void var6_5;
            var6_5.close();
            throw throwable;
        }
        consumerGroupCommand.close();
    }

    private String resetAndAssertOffsets$default$3() {
        return this.group();
    }

    private boolean resetAndAssertOffsets$default$4() {
        return false;
    }

    private void resetAndAssertOffsetsCommitted(ConsumerGroupCommand.ConsumerGroupService consumerGroupService, Map<TopicPartition, Object> expectedOffsets, String topic) {
        Map<TopicPartition, Object> allResetOffsets = this.resetOffsets(consumerGroupService);
        allResetOffsets.foreach((Function1)new Serializable(this, expectedOffsets){
            public static final long serialVersionUID = 0L;
            private final Map expectedOffsets$1;

            public final void apply(Tuple2<TopicPartition, Object> x0$1) {
                Tuple2<TopicPartition, Object> tuple2 = x0$1;
                if (tuple2 != null) {
                    TopicPartition tp = (TopicPartition)tuple2._1();
                    long offset = tuple2._2$mcJ$sp();
                    Assert.assertEquals((long)offset, (long)BoxesRunTime.unboxToLong((Object)this.expectedOffsets$1.apply((Object)tp)));
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
                throw new MatchError(tuple2);
            }
            {
                this.expectedOffsets$1 = expectedOffsets$1;
            }
        });
        Assert.assertEquals(expectedOffsets, this.committedOffsets(topic, this.committedOffsets$default$2()));
    }

    private String resetAndAssertOffsetsCommitted$default$3() {
        return this.topic();
    }

    private Map<TopicPartition, Object> resetOffsets(ConsumerGroupCommand.ConsumerGroupService consumerGroupService) {
        return consumerGroupService.resetOffsets().mapValues((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply(OffsetAndMetadata x$4) {
                return x$4.offset();
            }
        });
    }

    public ResetConsumerGroupOffsetTest() {
        this.topic1 = "foo1";
        this.topic2 = "foo2";
    }
}

