/*
 * Decompiled with CFR 0.152.
 */
package kafka.api;

import java.util.Collection;
import java.util.Collections;
import java.util.Properties;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import kafka.admin.AdminClient;
import kafka.admin.AdminClient$;
import kafka.api.ConsumerBounceTest$;
import kafka.api.FixedPortTestUtils$;
import kafka.api.IntegrationTestHarness;
import kafka.cluster.Replica;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.utils.CoreUtils$;
import kafka.utils.ShutdownableThread;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.consumer.ConsumerRebalanceListener;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.TopicPartition;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.collection.Iterable;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LongRef;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0001\t]d\u0001B\u0001\u0003\u0001\u001d\u0011!cQ8ogVlWM\u001d\"pk:\u001cW\rV3ti*\u00111\u0001B\u0001\u0004CBL'\"A\u0003\u0002\u000b-\fgm[1\u0004\u0001M\u0019\u0001\u0001\u0003\u0007\u0011\u0005%QQ\"\u0001\u0002\n\u0005-\u0011!AF%oi\u0016<'/\u0019;j_:$Vm\u001d;ICJtWm]:\u0011\u00055\u0001R\"\u0001\b\u000b\u0005=!\u0011!B;uS2\u001c\u0018BA\t\u000f\u0005\u001daunZ4j]\u001eDQa\u0005\u0001\u0005\u0002Q\ta\u0001P5oSRtD#A\u000b\u0011\u0005%\u0001\u0001bB\f\u0001\u0005\u0004%\t\u0001G\u0001\u000eaJ|G-^2fe\u000e{WO\u001c;\u0016\u0003e\u0001\"AG\u000f\u000e\u0003mQ\u0011\u0001H\u0001\u0006g\u000e\fG.Y\u0005\u0003=m\u00111!\u00138u\u0011\u0019\u0001\u0003\u0001)A\u00053\u0005q\u0001O]8ek\u000e,'oQ8v]R\u0004\u0003b\u0002\u0012\u0001\u0005\u0004%\t\u0001G\u0001\u000eG>t7/^7fe\u000e{WO\u001c;\t\r\u0011\u0002\u0001\u0015!\u0003\u001a\u00039\u0019wN\\:v[\u0016\u00148i\\;oi\u0002BqA\n\u0001C\u0002\u0013\u0005\u0001$A\u0006tKJ4XM]\"pk:$\bB\u0002\u0015\u0001A\u0003%\u0011$\u0001\u0007tKJ4XM]\"pk:$\b\u0005C\u0004+\u0001\t\u0007I\u0011A\u0016\u0002\u000bQ|\u0007/[2\u0016\u00031\u0002\"!\f\u001a\u000e\u00039R!a\f\u0019\u0002\t1\fgn\u001a\u0006\u0002c\u0005!!.\u0019<b\u0013\t\u0019dF\u0001\u0004TiJLgn\u001a\u0005\u0007k\u0001\u0001\u000b\u0011\u0002\u0017\u0002\rQ|\u0007/[2!\u0011\u001d9\u0004A1A\u0005\u0002a\tA\u0001]1si\"1\u0011\b\u0001Q\u0001\ne\tQ\u0001]1si\u0002Bqa\u000f\u0001C\u0002\u0013\u0005A(\u0001\u0002uaV\tQ\b\u0005\u0002?\r6\tqH\u0003\u0002A\u0003\u000611m\\7n_:T!!\u0002\"\u000b\u0005\r#\u0015AB1qC\u000eDWMC\u0001F\u0003\ry'oZ\u0005\u0003\u000f~\u0012a\u0002V8qS\u000e\u0004\u0016M\u001d;ji&|g\u000e\u0003\u0004J\u0001\u0001\u0006I!P\u0001\u0004iB\u0004\u0003bB&\u0001\u0005\u0004%\t\u0001G\u0001\u0014OJ\f7-\u001a4vY\u000ecwn]3US6,Wj\u001d\u0005\u0007\u001b\u0002\u0001\u000b\u0011B\r\u0002)\u001d\u0014\u0018mY3gk2\u001cEn\\:f)&lW-T:!\u0011\u001dy\u0005A1A\u0005\u0002A\u000b\u0001\"\u001a=fGV$xN]\u000b\u0002#B\u0011!kV\u0007\u0002'*\u0011A+V\u0001\u000bG>t7-\u001e:sK:$(B\u0001,1\u0003\u0011)H/\u001b7\n\u0005a\u001b&\u0001G*dQ\u0016$W\u000f\\3e\u000bb,7-\u001e;peN+'O^5dK\"1!\f\u0001Q\u0001\nE\u000b\u0011\"\u001a=fGV$xN\u001d\u0011\t\u000bq\u0003A\u0011I/\u0002\u001f\u001d,g.\u001a:bi\u0016\u001cuN\u001c4jON,\u0012A\u0018\t\u0004?\u001eTgB\u00011f\u001d\t\tG-D\u0001c\u0015\t\u0019g!\u0001\u0004=e>|GOP\u0005\u00029%\u0011amG\u0001\ba\u0006\u001c7.Y4f\u0013\tA\u0017NA\u0002TKFT!AZ\u000e\u0011\u0005-tW\"\u00017\u000b\u00055$\u0011AB:feZ,'/\u0003\u0002pY\nY1*\u00194lC\u000e{gNZ5h\u0011\u0015\t\b\u0001\"\u0011s\u0003\u0015\u0019X\r^+q)\u0005\u0019\bC\u0001\u000eu\u0013\t)8D\u0001\u0003V]&$\bF\u00019x!\tA80D\u0001z\u0015\tQH)A\u0003kk:LG/\u0003\u0002}s\n1!)\u001a4pe\u0016DQA \u0001\u0005BI\f\u0001\u0002^3be\u0012{wO\u001c\u0015\u0004{\u0006\u0005\u0001c\u0001=\u0002\u0004%\u0019\u0011QA=\u0003\u000b\u00053G/\u001a:\t\r\u0005%\u0001\u0001\"\u0001s\u0003\u0005\"Xm\u001d;D_:\u001cX/\u001c9uS>tw+\u001b;i\u0005J|7.\u001a:GC&dWO]3tQ\u0011\t9!!\u0004\u0011\u0007a\fy!C\u0002\u0002\u0012e\u0014a!S4o_J,\u0007\u0006BA\u0004\u0003+\u00012\u0001_A\f\u0013\r\tI\"\u001f\u0002\u0005)\u0016\u001cH\u000fC\u0004\u0002\u001e\u0001!\t!a\b\u00023\r|gn];nK^KG\u000f\u001b\"s_.,'OR1jYV\u0014Xm\u001d\u000b\u0004g\u0006\u0005\u0002bBA\u0012\u00037\u0001\r!G\u0001\t]Vl\u0017\n^3sg\"1\u0011q\u0005\u0001\u0005\u0002I\f1\u0005^3tiN+Wm[!oI\u000e{W.\\5u/&$\bN\u0011:pW\u0016\u0014h)Y5mkJ,7\u000f\u000b\u0003\u0002&\u0005U\u0001bBA\u0017\u0001\u0011\u0005\u0011qF\u0001 g\u0016,7.\u00118e\u0007>lW.\u001b;XSRD'I]8lKJ4\u0015-\u001b7ve\u0016\u001cHcA:\u00022!9\u00111EA\u0016\u0001\u0004I\u0002BBA\u001b\u0001\u0011\u0005!/A\u0011uKN$8+\u001e2tGJL'-Z,iK:$v\u000e]5d+:\fg/Y5mC\ndW\r\u000b\u0003\u00024\u0005U\u0001BBA\u001e\u0001\u0011\u0005!/A\u0005uKN$8\t\\8tK\"\"\u0011\u0011HA\u000b\u0011\u001d\t\t\u0005\u0001C\u0005\u0003\u0007\n!c\u00195fG.\u001cEn\\:f\u000f>|G\rU1uQR)1/!\u0012\u0002J!9\u0011qIA \u0001\u0004I\u0012A\u00038v[J+7m\u001c:eg\"A\u00111JA \u0001\u0004\ti%A\u0004he>,\b/\u00133\u0011\t\u0005=\u0013Q\u000b\b\u00045\u0005E\u0013bAA*7\u00051\u0001K]3eK\u001aL1aMA,\u0015\r\t\u0019f\u0007\u0005\b\u00037\u0002A\u0011BA/\u0003\u0001\u001a\u0007.Z2l\u00072|7/Z,ji\"\u001cun\u001c:eS:\fGo\u001c:GC&dWO]3\u0015\u000fM\fy&!\u0019\u0002f!9\u0011qIA-\u0001\u0004I\u0002\u0002CA2\u00033\u0002\r!!\u0014\u0002\u0019\u0011Lh.Y7jG\u001e\u0013x.\u001e9\t\u0011\u0005\u001d\u0014\u0011\fa\u0001\u0003\u001b\n1\"\\1ok\u0006dwI]8va\"9\u00111\u000e\u0001\u0005\n\u00055\u0014\u0001H2iK\u000e\\7\t\\8tK^KG\u000f[\"mkN$XM\u001d$bS2,(/\u001a\u000b\bg\u0006=\u0014\u0011OA;\u0011\u001d\t9%!\u001bA\u0002eA\u0001\"a\u001d\u0002j\u0001\u0007\u0011QJ\u0001\u0007OJ|W\u000f]\u0019\t\u0011\u0005]\u0014\u0011\u000ea\u0001\u0003\u001b\naa\u001a:pkB\u0014\u0004BBA>\u0001\u0011\u0005!/\u0001\ruKN$8\t\\8tK\u0012+(/\u001b8h%\u0016\u0014\u0017\r\\1oG\u0016DC!!\u001f\u0002\u0016!9\u0011\u0011\u0011\u0001\u0005\n\u0005\r\u0015!G2iK\u000e\\7\t\\8tK\u0012+(/\u001b8h%\u0016\u0014\u0017\r\\1oG\u0016$\u0012b]AC\u0003\u000f\u000bI)!%\t\u0011\u0005-\u0013q\u0010a\u0001\u0003\u001bBqAKA@\u0001\u0004\ti\u0005C\u0004P\u0003\u007f\u0002\r!a#\u0011\u0007I\u000bi)C\u0002\u0002\u0010N\u0013q\"\u0012=fGV$xN]*feZL7-\u001a\u0005\t\u0003'\u000by\b1\u0001\u0002\u0016\u0006Y\"M]8lKJ\u001c\u0018I^1jY\u0006\u0014G.\u001a#ve&twm\u00117pg\u0016\u00042AGAL\u0013\r\tIj\u0007\u0002\b\u0005>|G.Z1o\u0011\u001d\ti\n\u0001C\u0005\u0003?\u000bab\u0019:fCR,7i\u001c8tk6,'\u000f\u0006\u0003\u0002\"\u0006u\u0006\u0003CAR\u0003[\u000b\t,!-\u000e\u0005\u0005\u0015&\u0002BAT\u0003S\u000b\u0001bY8ogVlWM\u001d\u0006\u0004\u0003W\u000b\u0015aB2mS\u0016tGo]\u0005\u0005\u0003_\u000b)KA\u0007LC\u001a\\\u0017mQ8ogVlWM\u001d\t\u00065\u0005M\u0016qW\u0005\u0004\u0003k[\"!B!se\u0006L\bc\u0001\u000e\u0002:&\u0019\u00111X\u000e\u0003\t\tKH/\u001a\u0005\t\u0003\u0017\nY\n1\u0001\u0002N!9\u0011\u0011\u0019\u0001\u0005\n\u0005\r\u0017\u0001G2sK\u0006$XmQ8ogVlWM]!oIJ+7-Z5wKRA\u0011\u0011UAc\u0003\u000f\fY\r\u0003\u0005\u0002L\u0005}\u0006\u0019AA'\u0011!\tI-a0A\u0002\u0005U\u0015\u0001D7b]V\fG.Q:tS\u001et\u0007bBA$\u0003\u007f\u0003\r!\u0007\u0005\b\u0003\u001f\u0004A\u0011BAi\u00039\u0011XmY3jm\u0016\u0014VmY8sIN$\u0012b]Aj\u0003+\f9.!7\t\u0011\u0005\u001d\u0016Q\u001aa\u0001\u0003CCq!a\u0012\u0002N\u0002\u0007\u0011\u0004C\u0005+\u0003\u001b\u0004\n\u00111\u0001\u0002N!Q\u00111\\Ag!\u0003\u0005\r!!8\u0002\u0013QLW.Z8vi6\u001b\bc\u0001\u000e\u0002`&\u0019\u0011\u0011]\u000e\u0003\t1{gn\u001a\u0005\b\u0003K\u0004A\u0011BAt\u0003Y\u0019XOY7ji\u000ecwn]3B]\u00124\u0016\r\\5eCR,GCCAu\u0003k\f90a?\u0003\u0006A)!+a;\u0002p&\u0019\u0011Q^*\u0003\r\u0019+H/\u001e:f!\rQ\u0012\u0011_\u0005\u0004\u0003g\\\"aA!os\"A\u0011qUAr\u0001\u0004\t\t\u000b\u0003\u0005\u0002z\u0006\r\b\u0019AAo\u00039\u0019Gn\\:f)&lWm\\;u\u001bND\u0001\"!@\u0002d\u0002\u0007\u0011q`\u0001\u000f[&t7\t\\8tKRKW.Z't!\u0015Q\"\u0011AAo\u0013\r\u0011\u0019a\u0007\u0002\u0007\u001fB$\u0018n\u001c8\t\u0011\t\u001d\u00111\u001da\u0001\u0003\u007f\fa\"\\1y\u00072|7/\u001a+j[\u0016l5\u000fC\u0004\u0003\f\u0001!IA!\u0004\u0002!\rDWmY6DY>\u001cX\rZ*uCR,G#B:\u0003\u0010\tE\u0001\u0002CA&\u0005\u0013\u0001\r!!\u0014\t\u000f\tM!\u0011\u0002a\u00013\u0005\u00012m\\7nSR$X\r\u001a*fG>\u0014Hm\u001d\u0004\u0007\u0005/\u0001AA!\u0007\u0003+\t{WO\\2f\u0005J|7.\u001a:TG\",G-\u001e7feN!!Q\u0003B\u000e!\ri!QD\u0005\u0004\u0005?q!AE*ikR$wn\u001e8bE2,G\u000b\u001b:fC\u0012D!\"a\t\u0003\u0016\t\u0015\r\u0011\"\u0001\u0019\u0011)\u0011)C!\u0006\u0003\u0002\u0003\u0006I!G\u0001\n]Vl\u0017\n^3sg\u0002Bqa\u0005B\u000b\t\u0003\u0011I\u0003\u0006\u0003\u0003,\t=\u0002\u0003\u0002B\u0017\u0005+i\u0011\u0001\u0001\u0005\b\u0003G\u00119\u00031\u0001\u001a\u0011%\u0011\u0019D!\u0006A\u0002\u0013\u0005\u0001$\u0001\u0003ji\u0016\u0014\bB\u0003B\u001c\u0005+\u0001\r\u0011\"\u0001\u0003:\u0005A\u0011\u000e^3s?\u0012*\u0017\u000fF\u0002t\u0005wA\u0011B!\u0010\u00036\u0005\u0005\t\u0019A\r\u0002\u0007a$\u0013\u0007\u0003\u0005\u0003B\tU\u0001\u0015)\u0003\u001a\u0003\u0015IG/\u001a:!\u0011\u001d\u0011)E!\u0006\u0005BI\fa\u0001Z8X_J\\\u0007b\u0002B%\u0001\u0011%!1J\u0001\fg\u0016tGMU3d_J$7\u000fF\u0003t\u0005\u001b\u0012y\u0005C\u0004\u0002H\t\u001d\u0003\u0019A\r\t\u0013)\u00129\u0005%AA\u0002\u00055\u0003\"\u0003B*\u0001E\u0005I\u0011\u0002B+\u0003U\u0019XM\u001c3SK\u000e|'\u000fZ:%I\u00164\u0017-\u001e7uII*\"Aa\u0016+\t\u00055#\u0011L\u0016\u0003\u00057\u0002BA!\u0018\u0003h5\u0011!q\f\u0006\u0005\u0005C\u0012\u0019'A\u0005v]\u000eDWmY6fI*\u0019!QM\u000e\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0003j\t}#!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\"I!Q\u000e\u0001\u0012\u0002\u0013%!QK\u0001\u0019e\u0016\u001cW-\u001b<f%\u0016\u001cwN\u001d3tI\u0011,g-Y;mi\u0012\u001a\u0004\"\u0003B9\u0001E\u0005I\u0011\u0002B:\u0003a\u0011XmY3jm\u0016\u0014VmY8sIN$C-\u001a4bk2$H\u0005N\u000b\u0003\u0005kRC!!8\u0003Z\u0001")
public class ConsumerBounceTest
extends IntegrationTestHarness {
    private final int producerCount;
    private final int consumerCount;
    private final int serverCount;
    private final String topic;
    private final int part;
    private final TopicPartition tp = new TopicPartition(this.topic(), this.part());
    private final int gracefulCloseTimeMs;
    private final ScheduledExecutorService executor = Executors.newScheduledThreadPool(2);

    @Override
    public int producerCount() {
        return this.producerCount;
    }

    @Override
    public int consumerCount() {
        return this.consumerCount;
    }

    @Override
    public int serverCount() {
        return this.serverCount;
    }

    public String topic() {
        return this.topic;
    }

    public int part() {
        return this.part;
    }

    public TopicPartition tp() {
        return this.tp;
    }

    public int gracefulCloseTimeMs() {
        return this.gracefulCloseTimeMs;
    }

    public ScheduledExecutorService executor() {
        return this.executor;
    }

    @Override
    public Seq<KafkaConfig> generateConfigs() {
        return (Seq)FixedPortTestUtils$.MODULE$.createBrokerConfigs(this.serverCount(), this.zkConnect(), false, FixedPortTestUtils$.MODULE$.createBrokerConfigs$default$4()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ConsumerBounceTest $outer;

            public final KafkaConfig apply(Properties x$1) {
                return KafkaConfig$.MODULE$.fromProps(x$1, this.$outer.serverConfig());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, Seq$.MODULE$.canBuildFrom());
    }

    @Override
    @Before
    public void setUp() {
        super.setUp();
        this.createTopic(this.topic(), 1, this.serverCount(), this.createTopic$default$4());
    }

    @Override
    @After
    public void tearDown() {
        try {
            this.executor().shutdownNow();
            Assert.assertTrue((String)"Executor did not terminate", (boolean)this.executor().awaitTermination(5000L, TimeUnit.MILLISECONDS));
            return;
        }
        finally {
            super.tearDown();
        }
    }

    @Test
    @Ignore
    public void testConsumptionWithBrokerFailures() {
        this.consumeWithBrokerFailures(10);
    }

    public void consumeWithBrokerFailures(int numIters) {
        int numRecords = 1000;
        this.sendRecords(numRecords, this.sendRecords$default$2());
        this.producers().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(KafkaProducer<byte[], byte[]> x$2) {
                x$2.close();
            }
        });
        LongRef consumed = LongRef.create((long)0L);
        KafkaConsumer consumer = (KafkaConsumer)this.consumers().head();
        consumer.subscribe(Collections.singletonList(this.topic()));
        BounceBrokerScheduler scheduler = new BounceBrokerScheduler(this, numIters);
        scheduler.start();
        while (scheduler.isRunning()) {
            Iterable records2 = (Iterable)JavaConverters$.MODULE$.iterableAsScalaIterableConverter((java.lang.Iterable)consumer.poll(100L)).asScala();
            Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp()})), (Object)JavaConverters$.MODULE$.asScalaSetConverter(consumer.assignment()).asScala());
            records2.foreach((Function1)new Serializable(this, consumed){
                public static final long serialVersionUID = 0L;
                private final LongRef consumed$1;

                public final void apply(ConsumerRecord<byte[], byte[]> record) {
                    Assert.assertEquals((long)this.consumed$1.elem, (long)record.offset());
                    ++this.consumed$1.elem;
                }
                {
                    this.consumed$1 = consumed$1;
                }
            });
            if (!records2.nonEmpty()) continue;
            consumer.commitSync();
            Assert.assertEquals((long)consumer.position(this.tp()), (long)consumer.committed(this.tp()).offset());
            if (consumer.position(this.tp()) != (long)numRecords) continue;
            consumer.seekToBeginning(Collections.emptyList());
            consumed.elem = 0L;
        }
        scheduler.shutdown();
    }

    @Test
    public void testSeekAndCommitWithBrokerFailures() {
        this.seekAndCommitWithBrokerFailures(5);
    }

    public void seekAndCommitWithBrokerFailures(int numIters) {
        int numRecords = 1000;
        this.sendRecords(numRecords, this.sendRecords$default$2());
        this.producers().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(KafkaProducer<byte[], byte[]> x$3) {
                x$3.close();
            }
        });
        KafkaConsumer consumer = (KafkaConsumer)this.consumers().head();
        consumer.assign(Collections.singletonList(this.tp()));
        consumer.seek(this.tp(), 0L);
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, numRecords){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ConsumerBounceTest $outer;
            public final int numRecords$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return this.$outer.servers().forall((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$seekAndCommitWithBrokerFailures$1 $outer;

                    public final boolean apply(KafkaServer server) {
                        return ((Replica)server.replicaManager().getReplica(this.$outer.kafka$api$ConsumerBounceTest$$anonfun$$$outer().tp()).get()).highWatermark().messageOffset() == (long)this.$outer.numRecords$1;
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }

            public /* synthetic */ ConsumerBounceTest kafka$api$ConsumerBounceTest$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.numRecords$1 = numRecords$1;
            }
        }, (Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Failed to update high watermark for followers after timeout";
            }
        }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
        BounceBrokerScheduler scheduler = new BounceBrokerScheduler(this, numIters);
        scheduler.start();
        while (scheduler.isRunning()) {
            int coin = TestUtils$.MODULE$.random().nextInt(3);
            if (coin == 0) {
                this.info((Function0<String>)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "Seeking to end of log";
                    }
                });
                consumer.seekToEnd(Collections.emptyList());
                Assert.assertEquals((long)numRecords, (long)consumer.position(this.tp()));
                continue;
            }
            if (coin == 1) {
                long pos = TestUtils$.MODULE$.random().nextInt(numRecords);
                this.info((Function0<String>)new Serializable(this, pos){
                    public static final long serialVersionUID = 0L;
                    private final long pos$1;

                    public final String apply() {
                        return new StringBuilder().append((Object)"Seeking to ").append((Object)BoxesRunTime.boxToLong((long)this.pos$1)).toString();
                    }
                    {
                        this.pos$1 = pos$1;
                    }
                });
                consumer.seek(this.tp(), pos);
                Assert.assertEquals((long)pos, (long)consumer.position(this.tp()));
                continue;
            }
            if (coin != 2) continue;
            this.info((Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Committing offset.";
                }
            });
            consumer.commitSync();
            Assert.assertEquals((long)consumer.position(this.tp()), (long)consumer.committed(this.tp()).offset());
        }
    }

    @Test
    public void testSubscribeWhenTopicUnavailable() {
        int numRecords = 1000;
        String newtopic = "newtopic";
        KafkaConsumer consumer = (KafkaConsumer)this.consumers().head();
        consumer.subscribe(Collections.singleton(newtopic));
        this.executor().schedule(new Runnable(this, newtopic){
            private final /* synthetic */ ConsumerBounceTest $outer;
            private final String newtopic$1;

            public void run() {
                TestUtils$.MODULE$.createTopic(this.$outer.zkClient(), this.newtopic$1, this.$outer.serverCount(), this.$outer.serverCount(), (Seq<KafkaServer>)this.$outer.servers(), TestUtils$.MODULE$.createTopic$default$6());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.newtopic$1 = newtopic$1;
            }
        }, 2L, TimeUnit.SECONDS);
        consumer.poll(0L);
        this.sendRecords$1(numRecords, newtopic);
        this.kafka$api$ConsumerBounceTest$$receiveRecords((KafkaConsumer<byte[], byte[]>)consumer, numRecords, newtopic, 10000L);
        this.servers().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ConsumerBounceTest $outer;

            public final void apply(KafkaServer server) {
                this.$outer.killBroker(server.config().brokerId());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        Thread.sleep(500L);
        this.restartDeadBrokers();
        Future<?> future = this.executor().submit(new Runnable(this, numRecords, newtopic, consumer){
            private final /* synthetic */ ConsumerBounceTest $outer;
            private final int numRecords$2;
            private final String newtopic$1;
            private final KafkaConsumer consumer$1;

            public void run() {
                this.$outer.kafka$api$ConsumerBounceTest$$receiveRecords((KafkaConsumer<byte[], byte[]>)this.consumer$1, this.numRecords$2, this.newtopic$1, 10000L);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.numRecords$2 = numRecords$2;
                this.newtopic$1 = newtopic$1;
                this.consumer$1 = consumer$1;
            }
        });
        this.sendRecords$1(numRecords, newtopic);
        future.get();
    }

    @Test
    public void testClose() {
        int numRecords = 10;
        this.sendRecords(numRecords, this.sendRecords$default$2());
        this.checkCloseGoodPath(numRecords, "group1");
        this.checkCloseWithCoordinatorFailure(numRecords, "group2", "group3");
        this.checkCloseWithClusterFailure(numRecords, "group4", "group5");
    }

    private void checkCloseGoodPath(int numRecords, String groupId) {
        KafkaConsumer<byte[], byte[]> consumer = this.createConsumerAndReceive(groupId, false, numRecords);
        Future<Object> future = this.submitCloseAndValidate(consumer, Long.MAX_VALUE, (Option<Object>)None$.MODULE$, (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)this.gracefulCloseTimeMs())));
        future.get();
        this.checkClosedState(groupId, numRecords);
    }

    private void checkCloseWithCoordinatorFailure(int numRecords, String dynamicGroup, String manualGroup) {
        KafkaConsumer<byte[], byte[]> consumer1 = this.createConsumerAndReceive(dynamicGroup, false, numRecords);
        KafkaConsumer<byte[], byte[]> consumer2 = this.createConsumerAndReceive(manualGroup, true, numRecords);
        AdminClient adminClient = AdminClient$.MODULE$.createSimplePlaintext(this.brokerList());
        this.killBroker(adminClient.findCoordinator(dynamicGroup, adminClient.findCoordinator$default$2()).id());
        this.killBroker(adminClient.findCoordinator(manualGroup, adminClient.findCoordinator$default$2()).id());
        Future<Object> future1 = this.submitCloseAndValidate(consumer1, Long.MAX_VALUE, (Option<Object>)None$.MODULE$, (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)this.gracefulCloseTimeMs())));
        Future<Object> future2 = this.submitCloseAndValidate(consumer2, Long.MAX_VALUE, (Option<Object>)None$.MODULE$, (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)this.gracefulCloseTimeMs())));
        future1.get();
        future2.get();
        this.restartDeadBrokers();
        this.checkClosedState(dynamicGroup, 0);
        this.checkClosedState(manualGroup, numRecords);
        adminClient.close();
    }

    private void checkCloseWithClusterFailure(int numRecords, String group1, String group2) {
        KafkaConsumer<byte[], byte[]> consumer1 = this.createConsumerAndReceive(group1, false, numRecords);
        int requestTimeout = 6000;
        this.consumerConfig().setProperty("session.timeout.ms", "5000");
        this.consumerConfig().setProperty("heartbeat.interval.ms", "1000");
        this.consumerConfig().setProperty("request.timeout.ms", ((Object)BoxesRunTime.boxToInteger((int)requestTimeout)).toString());
        KafkaConsumer<byte[], byte[]> consumer2 = this.createConsumerAndReceive(group2, true, numRecords);
        this.servers().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ConsumerBounceTest $outer;

            public final void apply(KafkaServer server) {
                this.$outer.killBroker(server.config().brokerId());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        int closeTimeout = 2000;
        Future<Object> future1 = this.submitCloseAndValidate(consumer1, closeTimeout, (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)closeTimeout)), (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)closeTimeout)));
        Future<Object> future2 = this.submitCloseAndValidate(consumer2, Long.MAX_VALUE, (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)requestTimeout)), (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)requestTimeout)));
        future1.get();
        future2.get();
    }

    @Test
    public void testCloseDuringRebalance() {
        String topic = "closetest";
        this.createTopic(topic, 10, this.serverCount(), this.createTopic$default$4());
        this.consumerConfig().setProperty("max.poll.interval.ms", "60000");
        this.consumerConfig().setProperty("heartbeat.interval.ms", "1000");
        this.consumerConfig().setProperty("enable.auto.commit", "false");
        this.checkCloseDuringRebalance("group1", topic, this.executor(), true);
    }

    private void checkCloseDuringRebalance(String groupId, String topic, ExecutorService executor, boolean brokersAvailableDuringClose) {
        KafkaConsumer<byte[], byte[]> consumer1 = this.createConsumer(groupId);
        this.waitForRebalance$1(2000L, this.subscribeAndPoll$1(consumer1, this.subscribeAndPoll$default$2$1(), topic, executor), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new KafkaConsumer[0]));
        KafkaConsumer<byte[], byte[]> consumer2 = this.createConsumer(groupId);
        this.waitForRebalance$1(2000L, this.subscribeAndPoll$1(consumer2, this.subscribeAndPoll$default$2$1(), topic, executor), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new KafkaConsumer[]{consumer1}));
        Future rebalanceFuture = this.createConsumerToRebalance$1(groupId, topic, executor);
        Future<Object> closeFuture1 = this.submitCloseAndValidate(consumer1, Long.MAX_VALUE, (Option<Object>)None$.MODULE$, (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)this.gracefulCloseTimeMs())));
        this.waitForRebalance$1(2000L, rebalanceFuture, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new KafkaConsumer[]{consumer2}));
        this.createConsumerToRebalance$1(groupId, topic, executor);
        this.servers().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ConsumerBounceTest $outer;

            public final void apply(KafkaServer server) {
                this.$outer.killBroker(server.config().brokerId());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        Future<Object> closeFuture2 = this.submitCloseAndValidate(consumer2, Long.MAX_VALUE, (Option<Object>)None$.MODULE$, (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)0L)));
        closeFuture1.get(2000L, TimeUnit.MILLISECONDS);
        closeFuture2.get(2000L, TimeUnit.MILLISECONDS);
    }

    /*
     * WARNING - void declaration
     */
    private KafkaConsumer<byte[], byte[]> createConsumer(String groupId) {
        void var2_2;
        this.consumerConfig().setProperty("group.id", groupId);
        KafkaConsumer<byte[], byte[]> consumer = this.createNewConsumer();
        this.consumers().$plus$eq(consumer);
        return var2_2;
    }

    private KafkaConsumer<byte[], byte[]> createConsumerAndReceive(String groupId, boolean manualAssign, int numRecords) {
        KafkaConsumer<byte[], byte[]> consumer = this.createConsumer(groupId);
        if (manualAssign) {
            consumer.assign(Collections.singleton(this.tp()));
        } else {
            consumer.subscribe(Collections.singleton(this.topic()));
        }
        this.kafka$api$ConsumerBounceTest$$receiveRecords(consumer, numRecords, this.receiveRecords$default$3(), this.receiveRecords$default$4());
        return consumer;
    }

    public void kafka$api$ConsumerBounceTest$$receiveRecords(KafkaConsumer<byte[], byte[]> consumer, int numRecords, String topic, long timeoutMs) {
        long received;
        long endTimeMs = System.currentTimeMillis() + timeoutMs;
        for (received = 0L; received < (long)numRecords && System.currentTimeMillis() < endTimeMs; received += (long)consumer.poll(1000L).count()) {
        }
        Assert.assertEquals((long)numRecords, (long)received);
    }

    private String receiveRecords$default$3() {
        return this.topic();
    }

    private long receiveRecords$default$4() {
        return 60000L;
    }

    private Future<Object> submitCloseAndValidate(KafkaConsumer<byte[], byte[]> consumer, long closeTimeoutMs, Option<Object> minCloseTimeMs, Option<Object> maxCloseTimeMs) {
        return this.executor().submit(CoreUtils$.MODULE$.runnable((Function0)new Serializable(this, consumer, closeTimeoutMs, minCloseTimeMs, maxCloseTimeMs){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ConsumerBounceTest $outer;
            private final KafkaConsumer consumer$2;
            public final long closeTimeoutMs$1;
            private final Option minCloseTimeMs$1;
            private final Option maxCloseTimeMs$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                int closeGraceTimeMs = 2000;
                long startNanos = System.nanoTime();
                this.$outer.info((Function0<String>)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$submitCloseAndValidate$1 $outer;

                    public final String apply() {
                        return new StringBuilder().append((Object)"Closing consumer with timeout ").append((Object)BoxesRunTime.boxToLong((long)this.$outer.closeTimeoutMs$1)).append((Object)" ms.").toString();
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
                this.consumer$2.close(this.closeTimeoutMs$1, TimeUnit.MILLISECONDS);
                long timeTakenMs = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - startNanos);
                this.maxCloseTimeMs$1.foreach((Function1)new Serializable(this, closeGraceTimeMs, timeTakenMs){
                    public static final long serialVersionUID = 0L;
                    private final int closeGraceTimeMs$1;
                    private final long timeTakenMs$1;

                    public final void apply(long ms) {
                        this.apply$mcVJ$sp(ms);
                    }

                    public void apply$mcVJ$sp(long ms) {
                        Assert.assertTrue((String)new StringBuilder().append((Object)"Close took too long ").append((Object)BoxesRunTime.boxToLong((long)this.timeTakenMs$1)).toString(), (this.timeTakenMs$1 < ms + (long)this.closeGraceTimeMs$1 ? 1 : 0) != 0);
                    }
                    {
                        this.closeGraceTimeMs$1 = closeGraceTimeMs$1;
                        this.timeTakenMs$1 = timeTakenMs$1;
                    }
                });
                this.minCloseTimeMs$1.foreach((Function1)new Serializable(this, timeTakenMs){
                    public static final long serialVersionUID = 0L;
                    private final long timeTakenMs$1;

                    public final void apply(long ms) {
                        this.apply$mcVJ$sp(ms);
                    }

                    public void apply$mcVJ$sp(long ms) {
                        Assert.assertTrue((String)new StringBuilder().append((Object)"Close finished too quickly ").append((Object)BoxesRunTime.boxToLong((long)this.timeTakenMs$1)).toString(), (this.timeTakenMs$1 >= ms ? 1 : 0) != 0);
                    }
                    {
                        this.timeTakenMs$1 = timeTakenMs$1;
                    }
                });
                this.$outer.info((Function0<String>)new Serializable(this, timeTakenMs){
                    public static final long serialVersionUID = 0L;
                    private final long timeTakenMs$1;

                    public final String apply() {
                        return new StringBuilder().append((Object)"consumer.close() completed in ").append((Object)BoxesRunTime.boxToLong((long)this.timeTakenMs$1)).append((Object)" ms.").toString();
                    }
                    {
                        this.timeTakenMs$1 = timeTakenMs$1;
                    }
                });
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.consumer$2 = consumer$2;
                this.closeTimeoutMs$1 = closeTimeoutMs$1;
                this.minCloseTimeMs$1 = minCloseTimeMs$1;
                this.maxCloseTimeMs$1 = maxCloseTimeMs$1;
            }
        }), BoxesRunTime.boxToInteger((int)0));
    }

    private void checkClosedState(String groupId, int committedRecords) {
        Semaphore assignSemaphore = new Semaphore(0);
        KafkaConsumer<byte[], byte[]> consumer = this.createConsumer(groupId);
        consumer.subscribe(Collections.singletonList(this.topic()), new ConsumerRebalanceListener(this, assignSemaphore){
            private final Semaphore assignSemaphore$1;

            public void onPartitionsAssigned(Collection<TopicPartition> partitions) {
                this.assignSemaphore$1.release();
            }

            public void onPartitionsRevoked(Collection<TopicPartition> partitions) {
            }
            {
                this.assignSemaphore$1 = assignSemaphore$1;
            }
        });
        consumer.poll(3000L);
        Assert.assertTrue((String)"Assigment did not complete on time", (boolean)assignSemaphore.tryAcquire(1L, TimeUnit.SECONDS));
        if (committedRecords > 0) {
            Assert.assertEquals((long)committedRecords, (long)consumer.committed(this.tp()).offset());
        }
        consumer.close();
    }

    private void sendRecords(int numRecords, String topic) {
        IndexedSeq futures = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numRecords).map((Function1)new Serializable(this, topic){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ConsumerBounceTest $outer;
            private final String topic$1;

            public final Future<RecordMetadata> apply(int i) {
                return ((KafkaProducer)this.$outer.producers().head()).send(new ProducerRecord(this.topic$1, Predef$.MODULE$.int2Integer(this.$outer.part()), (Object)((Object)BoxesRunTime.boxToInteger((int)i)).toString().getBytes(), (Object)((Object)BoxesRunTime.boxToInteger((int)i)).toString().getBytes()));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.topic$1 = topic$1;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom());
        futures.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final RecordMetadata apply(Future<RecordMetadata> x$4) {
                return x$4.get();
            }
        }, IndexedSeq$.MODULE$.canBuildFrom());
    }

    private String sendRecords$default$2() {
        return this.topic();
    }

    private final void sendRecords$1(int numRecords, String topic) {
        IntRef remainingRecords = IntRef.create((int)numRecords);
        long endTimeMs = System.currentTimeMillis() + 20000L;
        while (remainingRecords.elem > 0 && System.currentTimeMillis() < endTimeMs) {
            IndexedSeq futures = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), remainingRecords.elem).map((Function1)new Serializable(this, topic){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ ConsumerBounceTest $outer;
                private final String topic$2;

                public final Future<RecordMetadata> apply(int i) {
                    return ((KafkaProducer)this.$outer.producers().head()).send(new ProducerRecord(this.topic$2, Predef$.MODULE$.int2Integer(this.$outer.part()), (Object)((Object)BoxesRunTime.boxToInteger((int)i)).toString().getBytes(), (Object)((Object)BoxesRunTime.boxToInteger((int)i)).toString().getBytes()));
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.topic$2 = topic$2;
                }
            }, IndexedSeq$.MODULE$.canBuildFrom());
            futures.map((Function1)new Serializable(this, remainingRecords){
                public static final long serialVersionUID = 0L;
                private final IntRef remainingRecords$1;

                public final void apply(Future<RecordMetadata> future) {
                    try {
                        future.get();
                        --this.remainingRecords$1.elem;
                    }
                    catch (Exception exception) {}
                }
                {
                    this.remainingRecords$1 = remainingRecords$1;
                }
            }, IndexedSeq$.MODULE$.canBuildFrom());
        }
        Assert.assertEquals((long)0L, (long)remainingRecords.elem);
    }

    private final Future subscribeAndPoll$1(KafkaConsumer consumer, Option revokeSemaphore, String topic$3, ExecutorService executor$1) {
        return executor$1.submit(CoreUtils$.MODULE$.runnable((Function0)new Serializable(this, topic$3, consumer, revokeSemaphore){
            public static final long serialVersionUID = 0L;
            private final String topic$3;
            private final KafkaConsumer consumer$3;
            public final Option revokeSemaphore$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.consumer$3.subscribe(Collections.singletonList(this.topic$3), new ConsumerRebalanceListener(this){
                    private final /* synthetic */ $anonfun$subscribeAndPoll$1$1 $outer;

                    public void onPartitionsAssigned(Collection<TopicPartition> partitions) {
                    }

                    public void onPartitionsRevoked(Collection<TopicPartition> partitions) {
                        this.$outer.revokeSemaphore$1.foreach((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final void apply(Semaphore s) {
                                s.release();
                            }
                        });
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
                this.consumer$3.poll(0L);
            }
            {
                this.topic$3 = topic$3;
                this.consumer$3 = consumer$3;
                this.revokeSemaphore$1 = revokeSemaphore$1;
            }
        }), BoxesRunTime.boxToInteger((int)0));
    }

    private final Option subscribeAndPoll$default$2$1() {
        return None$.MODULE$;
    }

    private final void waitForRebalance$1(long timeoutMs, Future future, Seq otherConsumers) {
        long startMs = System.currentTimeMillis();
        while (System.currentTimeMillis() < startMs + timeoutMs && !future.isDone()) {
            otherConsumers.foreach((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final ConsumerRecords<byte[], byte[]> apply(KafkaConsumer<byte[], byte[]> consumer) {
                    return consumer.poll(100L);
                }
            });
        }
        Assert.assertTrue((String)"Rebalance did not complete in time", (boolean)future.isDone());
    }

    private final Future createConsumerToRebalance$1(String groupId$1, String topic$3, ExecutorService executor$1) {
        KafkaConsumer<byte[], byte[]> consumer = this.createConsumer(groupId$1);
        Semaphore rebalanceSemaphore = new Semaphore(0);
        Future future = this.subscribeAndPoll$1(consumer, (Option)new Some((Object)rebalanceSemaphore), topic$3, executor$1);
        Assert.assertTrue((String)"Rebalance not triggered", (boolean)rebalanceSemaphore.tryAcquire(2000L, TimeUnit.MILLISECONDS));
        Assert.assertFalse((String)"Rebalance completed too early", (boolean)future.isDone());
        return future;
    }

    public ConsumerBounceTest() {
        this.producerCount = 1;
        this.consumerCount = 2;
        this.serverCount = 3;
        this.topic = "topic";
        this.part = 0;
        this.gracefulCloseTimeMs = 1000;
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.OffsetsTopicReplicationFactorProp(), "3");
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.OffsetsTopicPartitionsProp(), "1");
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.GroupMinSessionTimeoutMsProp(), "10");
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.GroupInitialRebalanceDelayMsProp(), "0");
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.UncleanLeaderElectionEnableProp(), "true");
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.AutoCreateTopicsEnableProp(), "false");
        this.producerConfig().setProperty("acks", "all");
        this.consumerConfig().setProperty("group.id", "my-test");
        this.consumerConfig().setProperty("max.partition.fetch.bytes", ((Object)BoxesRunTime.boxToInteger((int)4096)).toString());
        this.consumerConfig().setProperty("session.timeout.ms", "10000");
        this.consumerConfig().setProperty("heartbeat.interval.ms", "3000");
        this.consumerConfig().setProperty("auto.offset.reset", "earliest");
    }

    public class BounceBrokerScheduler
    extends ShutdownableThread {
        private final int numIters;
        private int iter;
        public final /* synthetic */ ConsumerBounceTest $outer;

        public int numIters() {
            return this.numIters;
        }

        public int iter() {
            return this.iter;
        }

        public void iter_$eq(int x$1) {
            this.iter = x$1;
        }

        public void doWork() {
            this.kafka$api$ConsumerBounceTest$BounceBrokerScheduler$$$outer().killRandomBroker();
            Thread.sleep(500L);
            this.kafka$api$ConsumerBounceTest$BounceBrokerScheduler$$$outer().restartDeadBrokers();
            this.iter_$eq(this.iter() + 1);
            if (this.iter() == this.numIters()) {
                this.initiateShutdown();
            } else {
                Thread.sleep(500L);
            }
        }

        public /* synthetic */ ConsumerBounceTest kafka$api$ConsumerBounceTest$BounceBrokerScheduler$$$outer() {
            return this.$outer;
        }

        public BounceBrokerScheduler(ConsumerBounceTest $outer, int numIters) {
            this.numIters = numIters;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            super("daemon-bounce-broker", false);
            this.iter = 0;
        }
    }
}

