/*
 * Decompiled with CFR 0.152.
 */
package kafka.api;

import java.io.File;
import java.io.FileOutputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import kafka.admin.ConsumerGroupCommand;
import kafka.api.Both$;
import kafka.api.IntegrationTestHarness;
import kafka.api.SaslSetup;
import kafka.api.SaslSetup$class;
import kafka.api.SaslSetupMode;
import kafka.security.minikdc.MiniKdc;
import kafka.server.KafkaConfig$;
import kafka.utils.JaasTestUtils;
import kafka.utils.JaasTestUtils$;
import kafka.utils.TestUtils$;
import kafka.zk.ConfigEntityChangeNotificationZNode$;
import org.apache.kafka.clients.admin.AdminClient;
import org.apache.kafka.clients.admin.TopicDescription;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.SaslAuthenticationException;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.serialization.ByteArrayDeserializer;
import org.apache.kafka.common.serialization.ByteArraySerializer;
import org.apache.kafka.common.serialization.Deserializer;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.scalactic.source.Position;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0015g\u0001B\u0001\u0003\u0001\u001d\u0011QeU1tY\u000ec\u0017.\u001a8ug^KG\u000f[%om\u0006d\u0017\u000eZ\"sK\u0012,g\u000e^5bYN$Vm\u001d;\u000b\u0005\r!\u0011aA1qS*\tQ!A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0007\u0001AA\u0002\u0005\u0002\n\u00155\t!!\u0003\u0002\f\u0005\t1\u0012J\u001c;fOJ\fG/[8o)\u0016\u001cH\u000fS1s]\u0016\u001c8\u000f\u0005\u0002\n\u001b%\u0011aB\u0001\u0002\n'\u0006\u001cHnU3ukBDQ\u0001\u0005\u0001\u0005\u0002E\ta\u0001P5oSRtD#\u0001\n\u0011\u0005%\u0001\u0001b\u0002\u000b\u0001\u0005\u0004%I!F\u0001\u0019W\u000647.Y\"mS\u0016tGoU1tY6+7\r[1oSNlW#\u0001\f\u0011\u0005]aR\"\u0001\r\u000b\u0005eQ\u0012\u0001\u00027b]\u001eT\u0011aG\u0001\u0005U\u00064\u0018-\u0003\u0002\u001e1\t11\u000b\u001e:j]\u001eDaa\b\u0001!\u0002\u00131\u0012!G6bM.\f7\t\\5f]R\u001c\u0016m\u001d7NK\u000eD\u0017M\\5t[\u0002Bq!\t\u0001C\u0002\u0013%!%A\rlC\u001a\\\u0017mU3sm\u0016\u00148+Y:m\u001b\u0016\u001c\u0007.\u00198jg6\u001cX#A\u0012\u0011\u0007\u0011Zc#D\u0001&\u0015\t1s%A\u0005j[6,H/\u00192mK*\u0011\u0001&K\u0001\u000bG>dG.Z2uS>t'\"\u0001\u0016\u0002\u000bM\u001c\u0017\r\\1\n\u00051*#\u0001\u0002'jgRDaA\f\u0001!\u0002\u0013\u0019\u0013AG6bM.\f7+\u001a:wKJ\u001c\u0016m\u001d7NK\u000eD\u0017M\\5t[N\u0004\u0003b\u0002\u0019\u0001\u0005\u0004%\t&M\u0001\u0011g\u0016\u001cWO]5usB\u0013x\u000e^8d_2,\u0012A\r\t\u0003g}j\u0011\u0001\u000e\u0006\u0003kY\nA!Y;uQ*\u0011q\u0007O\u0001\tg\u0016\u001cWO]5us*\u0011\u0011HO\u0001\u0007G>lWn\u001c8\u000b\u0005\u0015Y$B\u0001\u001f>\u0003\u0019\t\u0007/Y2iK*\ta(A\u0002pe\u001eL!\u0001\u0011\u001b\u0003!M+7-\u001e:jif\u0004&o\u001c;pG>d\u0007B\u0002\"\u0001A\u0003%!'A\ttK\u000e,(/\u001b;z!J|Go\\2pY\u0002Bq\u0001\u0012\u0001C\u0002\u0013ES)\u0001\u000btKJ4XM]*bg2\u0004&o\u001c9feRLWm]\u000b\u0002\rB\u0019q\t\u0013&\u000e\u0003%J!!S\u0015\u0003\tM{W.\u001a\t\u0003\u0017:k\u0011\u0001\u0014\u0006\u0003\u001bj\tA!\u001e;jY&\u0011q\n\u0014\u0002\u000b!J|\u0007/\u001a:uS\u0016\u001c\bBB)\u0001A\u0003%a)A\u000btKJ4XM]*bg2\u0004&o\u001c9feRLWm\u001d\u0011\t\u000fM\u0003!\u0019!C)\u000b\u0006!2\r\\5f]R\u001c\u0016m\u001d7Qe>\u0004XM\u001d;jKNDa!\u0016\u0001!\u0002\u00131\u0015!F2mS\u0016tGoU1tYB\u0013x\u000e]3si&,7\u000f\t\u0005\b/\u0002\u0011\r\u0011\"\u0001Y\u00035\u0019wN\\:v[\u0016\u00148i\\;oiV\t\u0011\f\u0005\u0002H5&\u00111,\u000b\u0002\u0004\u0013:$\bBB/\u0001A\u0003%\u0011,\u0001\bd_:\u001cX/\\3s\u0007>,h\u000e\u001e\u0011\t\u000f}\u0003!\u0019!C\u00011\u0006i\u0001O]8ek\u000e,'oQ8v]RDa!\u0019\u0001!\u0002\u0013I\u0016A\u00049s_\u0012,8-\u001a:D_VtG\u000f\t\u0005\bG\u0002\u0011\r\u0011\"\u0001Y\u0003-\u0019XM\u001d<fe\u000e{WO\u001c;\t\r\u0015\u0004\u0001\u0015!\u0003Z\u00031\u0019XM\u001d<fe\u000e{WO\u001c;!\u0011\u001d9\u0007A1A\u0005\u0002U\tQ\u0001^8qS\u000eDa!\u001b\u0001!\u0002\u00131\u0012A\u0002;pa&\u001c\u0007\u0005C\u0004l\u0001\t\u0007I\u0011\u0001-\u0002\u001b9,X\u000eU1si&$\u0018n\u001c8t\u0011\u0019i\u0007\u0001)A\u00053\u0006qa.^7QCJ$\u0018\u000e^5p]N\u0004\u0003bB8\u0001\u0005\u0004%\t\u0001]\u0001\u0003iB,\u0012!\u001d\t\u0003eNl\u0011\u0001O\u0005\u0003ib\u0012a\u0002V8qS\u000e\u0004\u0016M\u001d;ji&|g\u000e\u0003\u0004w\u0001\u0001\u0006I!]\u0001\u0004iB\u0004\u0003\"\u0002=\u0001\t\u0003J\u0018aI2p]\u001aLw-\u001e:f'\u0016\u001cWO]5us\n+gm\u001c:f'\u0016\u0014h/\u001a:t'R\f'\u000f\u001e\u000b\u0002uB\u0011qi_\u0005\u0003y&\u0012A!\u00168ji\")a\u0010\u0001C!s\u0006)1/\u001a;Va\"\u001aQ0!\u0001\u0011\t\u0005\r\u0011\u0011B\u0007\u0003\u0003\u000bQ1!a\u0002>\u0003\u0015QWO\\5u\u0013\u0011\tY!!\u0002\u0003\r\t+gm\u001c:f\u0011\u0019\ty\u0001\u0001C!s\u0006AA/Z1s\t><h\u000e\u000b\u0003\u0002\u000e\u0005M\u0001\u0003BA\u0002\u0003+IA!a\u0006\u0002\u0006\t)\u0011I\u001a;fe\"1\u00111\u0004\u0001\u0005\u0002e\fQ\u0005^3tiB\u0013x\u000eZ;dKJ<\u0016\u000e\u001e5BkRDWM\u001c;jG\u0006$\u0018n\u001c8GC&dWO]3)\t\u0005e\u0011q\u0004\t\u0005\u0003\u0007\t\t#\u0003\u0003\u0002$\u0005\u0015!\u0001\u0002+fgRDa!a\n\u0001\t\u0003I\u0018A\r;fgR$&/\u00198tC\u000e$\u0018n\u001c8bYB\u0013x\u000eZ;dKJ<\u0016\u000e\u001e5BkRDWM\u001c;jG\u0006$\u0018n\u001c8GC&dWO]3)\t\u0005\u0015\u0012q\u0004\u0005\u0007\u0003[\u0001A\u0011A=\u0002KQ,7\u000f^\"p]N,X.\u001a:XSRD\u0017)\u001e;iK:$\u0018nY1uS>tg)Y5mkJ,\u0007\u0006BA\u0016\u0003?Aa!a\r\u0001\t\u0003I\u0018!\u000e;fgRl\u0015M\\;bY\u0006\u001b8/[4o[\u0016tGoQ8ogVlWM],ji\"\fU\u000f\u001e5f]RL7-\u0019;j_:4\u0015-\u001b7ve\u0016DC!!\r\u0002 !1\u0011\u0011\b\u0001\u0005\u0002e\f1\n^3ti6\u000bg.^1m\u0003N\u001c\u0018n\u001a8nK:$8i\u001c8tk6,'oV5uQ\u0006+Ho\\\"p[6LG\u000fR5tC\ndW\rZ,ji\"\fU\u000f\u001e5f]RL7-\u0019;j_:4\u0015-\u001b7ve\u0016DC!a\u000e\u0002 !9\u0011q\b\u0001\u0005\n\u0005\u0005\u0013a\n<fe&4\u0017pQ8ogVlWM],ji\"\fU\u000f\u001e5f]RL7-\u0019;j_:4\u0015-\u001b7ve\u0016$2A_A\"\u0011!\t)%!\u0010A\u0002\u0005\u001d\u0013\u0001C2p]N,X.\u001a:\u0011\u0011\u0005%\u0013\u0011KA+\u0003+j!!a\u0013\u000b\t\u0005\u0015\u0013Q\n\u0006\u0004\u0003\u001fR\u0014aB2mS\u0016tGo]\u0005\u0005\u0003'\nYEA\u0007LC\u001a\\\u0017mQ8ogVlWM\u001d\t\u0006\u000f\u0006]\u00131L\u0005\u0004\u00033J#!B!se\u0006L\bcA$\u0002^%\u0019\u0011qL\u0015\u0003\t\tKH/\u001a\u0005\u0007\u0003G\u0002A\u0011A=\u0002[Q,7\u000f^&bM.\f\u0017\tZ7j]\u000ec\u0017.\u001a8u/&$\b.Q;uQ\u0016tG/[2bi&|gNR1jYV\u0014X\r\u000b\u0003\u0002b\u0005}\u0001BBA5\u0001\u0011\u0005\u00110A\u0019uKN$8i\u001c8tk6,'o\u0012:pkB\u001cVM\u001d<jG\u0016<\u0016\u000e\u001e5BkRDWM\u001c;jG\u0006$\u0018n\u001c8GC&dWO]3)\t\u0005\u001d\u0014q\u0004\u0005\u0007\u0003_\u0002A\u0011B=\u0002-\r\u0014X-\u0019;f\u00072LWM\u001c;De\u0016$WM\u001c;jC2Dq!a\u001d\u0001\t\u0013\t)(A\u0007tK:$wJ\\3SK\u000e|'\u000f\u001a\u000b\u0004u\u0006]\u0004BCA=\u0003c\u0002\n\u00111\u0001\u0002|\u0005IQ.\u0019=XC&$Xj\u001d\t\u0004\u000f\u0006u\u0014bAA@S\t!Aj\u001c8h\u0011\u001d\t\u0019\t\u0001C\u0005\u0003\u000b\u000bQD^3sS\u001aL\u0018)\u001e;iK:$\u0018nY1uS>tW\t_2faRLwN\u001c\u000b\u0004u\u0006\u001d\u0005\"CAE\u0003\u0003#\t\u0019AAF\u0003\u0019\t7\r^5p]B!q)!${\u0013\r\ty)\u000b\u0002\ty\tLh.Y7f}!9\u00111\u0013\u0001\u0005\n\u0005U\u0015a\u0004<fe&4\u0017pV5uQJ+GO]=\u0015\u0007i\f9\nC\u0005\u0002\n\u0006EE\u00111\u0001\u0002\f\"9\u00111\u0014\u0001\u0005\n\u0005u\u0015aG2sK\u0006$X\r\u0016:b]N\f7\r^5p]\u0006d\u0007K]8ek\u000e,'\u000f\u0006\u0002\u0002 BA\u0011\u0011UAT\u0003+\n)&\u0004\u0002\u0002$*!\u0011QUA'\u0003!\u0001(o\u001c3vG\u0016\u0014\u0018\u0002BAU\u0003G\u0013QbS1gW\u0006\u0004&o\u001c3vG\u0016\u0014\b\"CAW\u0001E\u0005I\u0011BAX\u0003]\u0019XM\u001c3P]\u0016\u0014VmY8sI\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u00022*\"\u00111PAZW\t\t)\f\u0005\u0003\u00028\u0006\u0005WBAA]\u0015\u0011\tY,!0\u0002\u0013Ut7\r[3dW\u0016$'bAA`S\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005\r\u0017\u0011\u0018\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0007")
public class SaslClientsWithInvalidCredentialsTest
extends IntegrationTestHarness
implements SaslSetup {
    private final String kafkaClientSaslMechanism;
    private final List<String> kafkaServerSaslMechanisms;
    private final SecurityProtocol securityProtocol;
    private final Some<Properties> serverSaslProperties;
    private final Some<Properties> clientSaslProperties;
    private final int consumerCount;
    private final int producerCount;
    private final int serverCount;
    private final String topic;
    private final int numPartitions;
    private final TopicPartition tp;
    private final File kafka$api$SaslSetup$$workDir;
    private final Properties kafka$api$SaslSetup$$kdcConf;
    private MiniKdc kafka$api$SaslSetup$$kdc;
    private Option<File> kafka$api$SaslSetup$$serverKeytabFile;
    private Option<File> kafka$api$SaslSetup$$clientKeytabFile;

    @Override
    public File kafka$api$SaslSetup$$workDir() {
        return this.kafka$api$SaslSetup$$workDir;
    }

    @Override
    public Properties kafka$api$SaslSetup$$kdcConf() {
        return this.kafka$api$SaslSetup$$kdcConf;
    }

    @Override
    public MiniKdc kafka$api$SaslSetup$$kdc() {
        return this.kafka$api$SaslSetup$$kdc;
    }

    @Override
    public void kafka$api$SaslSetup$$kdc_$eq(MiniKdc x$1) {
        this.kafka$api$SaslSetup$$kdc = x$1;
    }

    @Override
    public Option<File> kafka$api$SaslSetup$$serverKeytabFile() {
        return this.kafka$api$SaslSetup$$serverKeytabFile;
    }

    @Override
    public void kafka$api$SaslSetup$$serverKeytabFile_$eq(Option<File> x$1) {
        this.kafka$api$SaslSetup$$serverKeytabFile = x$1;
    }

    @Override
    public Option<File> kafka$api$SaslSetup$$clientKeytabFile() {
        return this.kafka$api$SaslSetup$$clientKeytabFile;
    }

    @Override
    public void kafka$api$SaslSetup$$clientKeytabFile_$eq(Option<File> x$1) {
        this.kafka$api$SaslSetup$$clientKeytabFile = x$1;
    }

    @Override
    public void kafka$api$SaslSetup$_setter_$kafka$api$SaslSetup$$workDir_$eq(File x$1) {
        this.kafka$api$SaslSetup$$workDir = x$1;
    }

    @Override
    public void kafka$api$SaslSetup$_setter_$kafka$api$SaslSetup$$kdcConf_$eq(Properties x$1) {
        this.kafka$api$SaslSetup$$kdcConf = x$1;
    }

    @Override
    public void startSasl(Seq<JaasTestUtils.JaasSection> jaasSections) {
        SaslSetup$class.startSasl(this, jaasSections);
    }

    @Override
    public void initializeKerberos() {
        SaslSetup$class.initializeKerberos(this);
    }

    @Override
    public Tuple2<File, File> maybeCreateEmptyKeytabFiles() {
        return SaslSetup$class.maybeCreateEmptyKeytabFiles(this);
    }

    @Override
    public Seq<JaasTestUtils.JaasSection> jaasSections(Seq<String> kafkaServerSaslMechanisms, Option<String> kafkaClientSaslMechanism, SaslSetupMode mode, String kafkaServerEntryName) {
        return SaslSetup$class.jaasSections(this, kafkaServerSaslMechanisms, kafkaClientSaslMechanism, mode, kafkaServerEntryName);
    }

    @Override
    public void closeSasl() {
        SaslSetup$class.closeSasl(this);
    }

    @Override
    public Properties kafkaServerSaslProperties(Seq<String> serverSaslMechanisms, String interBrokerSaslMechanism) {
        return SaslSetup$class.kafkaServerSaslProperties(this, serverSaslMechanisms, interBrokerSaslMechanism);
    }

    @Override
    public Properties kafkaClientSaslProperties(String clientSaslMechanism, boolean dynamicJaasConfig) {
        return SaslSetup$class.kafkaClientSaslProperties(this, clientSaslMechanism, dynamicJaasConfig);
    }

    @Override
    public String jaasClientLoginModule(String clientSaslMechanism) {
        return SaslSetup$class.jaasClientLoginModule(this, clientSaslMechanism);
    }

    @Override
    public void createScramCredentials(String zkConnect, String userName, String password) {
        SaslSetup$class.createScramCredentials(this, zkConnect, userName, password);
    }

    @Override
    public boolean kafkaClientSaslProperties$default$2() {
        return SaslSetup$class.kafkaClientSaslProperties$default$2(this);
    }

    @Override
    public SaslSetupMode jaasSections$default$3() {
        return SaslSetup$class.jaasSections$default$3(this);
    }

    @Override
    public String jaasSections$default$4() {
        return SaslSetup$class.jaasSections$default$4(this);
    }

    private String kafkaClientSaslMechanism() {
        return this.kafkaClientSaslMechanism;
    }

    private List<String> kafkaServerSaslMechanisms() {
        return this.kafkaServerSaslMechanisms;
    }

    @Override
    public SecurityProtocol securityProtocol() {
        return this.securityProtocol;
    }

    public Some<Properties> serverSaslProperties() {
        return this.serverSaslProperties;
    }

    public Some<Properties> clientSaslProperties() {
        return this.clientSaslProperties;
    }

    @Override
    public int consumerCount() {
        return this.consumerCount;
    }

    @Override
    public int producerCount() {
        return this.producerCount;
    }

    @Override
    public int serverCount() {
        return this.serverCount;
    }

    public String topic() {
        return this.topic;
    }

    public int numPartitions() {
        return this.numPartitions;
    }

    public TopicPartition tp() {
        return this.tp;
    }

    @Override
    public void configureSecurityBeforeServersStart() {
        super.configureSecurityBeforeServersStart();
        this.zkClient().makeSurePersistentPathExists(ConfigEntityChangeNotificationZNode$.MODULE$.path());
        this.createScramCredentials(this.zkConnect(), JaasTestUtils$.MODULE$.KafkaScramAdmin(), JaasTestUtils$.MODULE$.KafkaScramAdminPassword());
    }

    @Override
    @Before
    public void setUp() {
        this.startSasl(this.jaasSections((Seq<String>)this.kafkaServerSaslMechanisms(), (Option<String>)new Some((Object)this.kafkaClientSaslMechanism()), Both$.MODULE$, JaasTestUtils$.MODULE$.KafkaServerContextName()));
        super.setUp();
        this.createTopic(this.topic(), this.numPartitions(), this.serverCount(), this.createTopic$default$4());
    }

    @Override
    @After
    public void tearDown() {
        super.tearDown();
        this.closeSasl();
    }

    @Test
    public void testProducerWithAuthenticationFailure() {
        this.verifyAuthenticationException((Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SaslClientsWithInvalidCredentialsTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.kafka$api$SaslClientsWithInvalidCredentialsTest$$sendOneRecord(10000L);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.verifyAuthenticationException((Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SaslClientsWithInvalidCredentialsTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ((KafkaProducer)this.$outer.producers().head()).partitionsFor(this.$outer.topic());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.createClientCredential();
        this.verifyWithRetry((Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SaslClientsWithInvalidCredentialsTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.kafka$api$SaslClientsWithInvalidCredentialsTest$$sendOneRecord(this.$outer.kafka$api$SaslClientsWithInvalidCredentialsTest$$sendOneRecord$default$1());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    @Test
    public void testTransactionalProducerWithAuthenticationFailure() {
        KafkaProducer<byte[], byte[]> txProducer = this.createTransactionalProducer();
        this.verifyAuthenticationException((Function0<BoxedUnit>)new Serializable(this, txProducer){
            public static final long serialVersionUID = 0L;
            private final KafkaProducer txProducer$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.txProducer$1.initTransactions();
            }
            {
                this.txProducer$1 = txProducer$1;
            }
        });
        this.createClientCredential();
        try {
            txProducer.initTransactions();
            throw this.fail("Transaction initialization should fail after authentication failure", new Position("SaslClientsWithInvalidCredentialsTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 91));
        }
        catch (KafkaException kafkaException) {
            return;
        }
    }

    @Test
    public void testConsumerWithAuthenticationFailure() {
        KafkaConsumer consumer = (KafkaConsumer)this.consumers().head();
        consumer.subscribe((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topic()}))).asJava());
        this.verifyConsumerWithAuthenticationFailure((KafkaConsumer<byte[], byte[]>)consumer);
    }

    @Test
    public void testManualAssignmentConsumerWithAuthenticationFailure() {
        KafkaConsumer consumer = (KafkaConsumer)this.consumers().head();
        consumer.assign((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp()}))).asJava());
        this.verifyConsumerWithAuthenticationFailure((KafkaConsumer<byte[], byte[]>)consumer);
    }

    @Test
    public void testManualAssignmentConsumerWithAutoCommitDisabledWithAuthenticationFailure() {
        this.consumerConfig().setProperty("enable.auto.commit", ((Object)BoxesRunTime.boxToBoolean((boolean)false)).toString());
        KafkaConsumer consumer = new KafkaConsumer(this.consumerConfig(), (Deserializer)new ByteArrayDeserializer(), (Deserializer)new ByteArrayDeserializer());
        this.consumers().$plus$eq((Object)consumer);
        consumer.assign((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp()}))).asJava());
        consumer.seek(this.tp(), 0L);
        this.verifyConsumerWithAuthenticationFailure((KafkaConsumer<byte[], byte[]>)consumer);
    }

    private void verifyConsumerWithAuthenticationFailure(KafkaConsumer<byte[], byte[]> consumer) {
        this.verifyAuthenticationException((Function0<BoxedUnit>)new Serializable(this, consumer){
            public static final long serialVersionUID = 0L;
            private final KafkaConsumer consumer$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.consumer$1.poll(10000L);
            }
            {
                this.consumer$1 = consumer$1;
            }
        });
        this.verifyAuthenticationException((Function0<BoxedUnit>)new Serializable(this, consumer){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SaslClientsWithInvalidCredentialsTest $outer;
            private final KafkaConsumer consumer$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.consumer$1.partitionsFor(this.$outer.topic());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.consumer$1 = consumer$1;
            }
        });
        this.createClientCredential();
        this.verifyWithRetry((Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SaslClientsWithInvalidCredentialsTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.kafka$api$SaslClientsWithInvalidCredentialsTest$$sendOneRecord(this.$outer.kafka$api$SaslClientsWithInvalidCredentialsTest$$sendOneRecord$default$1());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.verifyWithRetry((Function0<BoxedUnit>)new Serializable(this, consumer){
            public static final long serialVersionUID = 0L;
            private final KafkaConsumer consumer$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Assert.assertEquals((long)1L, (long)this.consumer$1.poll(1000L).count());
            }
            {
                this.consumer$1 = consumer$1;
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testKafkaAdminClientWithAuthenticationFailure() {
        Properties props = TestUtils$.MODULE$.adminClientSecurityConfigs(this.securityProtocol(), this.trustStoreFile(), (Option<Properties>)this.clientSaslProperties());
        props.put("bootstrap.servers", this.brokerList());
        AdminClient adminClient = AdminClient.create((Properties)props);
        try {
            this.verifyAuthenticationException((Function0<BoxedUnit>)new Serializable(this, adminClient){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ SaslClientsWithInvalidCredentialsTest $outer;
                private final AdminClient adminClient$1;

                public final void apply() {
                    this.apply$mcV$sp();
                }

                public void apply$mcV$sp() {
                    this.$outer.kafka$api$SaslClientsWithInvalidCredentialsTest$$describeTopic$1(this.adminClient$1);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.adminClient$1 = adminClient$1;
                }
            });
            this.createClientCredential();
            this.verifyWithRetry((Function0<BoxedUnit>)new Serializable(this, adminClient){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ SaslClientsWithInvalidCredentialsTest $outer;
                private final AdminClient adminClient$1;

                public final void apply() {
                    this.apply$mcV$sp();
                }

                public void apply$mcV$sp() {
                    this.$outer.kafka$api$SaslClientsWithInvalidCredentialsTest$$describeTopic$1(this.adminClient$1);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.adminClient$1 = adminClient$1;
                }
            });
        }
        catch (Throwable throwable) {
            void var2_2;
            var2_2.close();
            throw throwable;
        }
        adminClient.close();
    }

    @Test
    public void testConsumerGroupServiceWithAuthenticationFailure() {
        File propsFile = TestUtils$.MODULE$.tempFile();
        FileOutputStream propsStream = new FileOutputStream(propsFile);
        propsStream.write("security.protocol=SASL_PLAINTEXT\n".getBytes());
        propsStream.write(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"sasl.mechanism=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.kafkaClientSaslMechanism()})).getBytes());
        propsStream.close();
        String[] cgcArgs = (String[])((Object[])new String[]{"--bootstrap-server", this.brokerList(), "--describe", "--group", "test.group", "--command-config", propsFile.getAbsolutePath()});
        ConsumerGroupCommand.ConsumerGroupCommandOptions opts = new ConsumerGroupCommand.ConsumerGroupCommandOptions(cgcArgs);
        ConsumerGroupCommand.KafkaConsumerGroupService consumerGroupService = new ConsumerGroupCommand.KafkaConsumerGroupService(opts);
        KafkaConsumer consumer = (KafkaConsumer)this.consumers().head();
        consumer.subscribe((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topic()}))).asJava());
        this.verifyAuthenticationException((Function0<BoxedUnit>)new Serializable(this, consumerGroupService){
            public static final long serialVersionUID = 0L;
            private final ConsumerGroupCommand.KafkaConsumerGroupService consumerGroupService$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.consumerGroupService$1.listGroups();
            }
            {
                this.consumerGroupService$1 = consumerGroupService$1;
            }
        });
        this.createClientCredential();
        this.verifyWithRetry((Function0<BoxedUnit>)new Serializable(this, consumer){
            public static final long serialVersionUID = 0L;
            private final KafkaConsumer consumer$2;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.consumer$2.poll(1000L);
            }
            {
                this.consumer$2 = consumer$2;
            }
        });
        Assert.assertEquals((long)1L, (long)consumerGroupService.listGroups().size());
    }

    private void createClientCredential() {
        this.createScramCredentials(this.zkConnect(), JaasTestUtils$.MODULE$.KafkaScramUser2(), JaasTestUtils$.MODULE$.KafkaScramPassword2());
    }

    public void kafka$api$SaslClientsWithInvalidCredentialsTest$$sendOneRecord(long maxWaitMs) {
        KafkaProducer producer = (KafkaProducer)this.producers().head();
        ProducerRecord record = new ProducerRecord(this.tp().topic(), Predef$.MODULE$.int2Integer(this.tp().partition()), Predef$.MODULE$.long2Long(0L), (Object)"key".getBytes(), (Object)"value".getBytes());
        Future future = producer.send(record);
        producer.flush();
        try {
            RecordMetadata recordMetadata = (RecordMetadata)future.get(maxWaitMs, TimeUnit.MILLISECONDS);
            Assert.assertTrue((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid offset ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{recordMetadata})), (recordMetadata.offset() >= 0L ? 1 : 0) != 0);
            return;
        }
        catch (ExecutionException executionException) {
            throw executionException.getCause();
        }
    }

    public long kafka$api$SaslClientsWithInvalidCredentialsTest$$sendOneRecord$default$1() {
        return 15000L;
    }

    private void verifyAuthenticationException(Function0<BoxedUnit> action) {
        long startMs = System.currentTimeMillis();
        try {
            action.apply$mcV$sp();
            throw this.fail("Expected an authentication exception", new Position("SaslClientsWithInvalidCredentialsTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 204));
        }
        catch (SaslAuthenticationException saslAuthenticationException) {
            long elapsedMs = System.currentTimeMillis() - startMs;
            Assert.assertTrue((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Poll took too long, elapsed=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)elapsedMs)})), (elapsedMs <= 5000L ? 1 : 0) != 0);
            Assert.assertTrue((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Exception message not useful: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{saslAuthenticationException})), (boolean)saslAuthenticationException.getMessage().contains("invalid credentials"));
            return;
        }
    }

    private void verifyWithRetry(Function0<BoxedUnit> action) {
        IntRef attempts = IntRef.create((int)0);
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, action, attempts){
            public static final long serialVersionUID = 0L;
            private final Function0 action$1;
            private final IntRef attempts$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                boolean bl;
                try {
                    ++this.attempts$1.elem;
                    this.action$1.apply$mcV$sp();
                    bl = true;
                }
                catch (SaslAuthenticationException saslAuthenticationException) {
                    bl = false;
                }
                return bl;
            }
            {
                this.action$1 = action$1;
                this.attempts$1 = attempts$1;
            }
        }, (Function0<String>)new Serializable(this, attempts){
            public static final long serialVersionUID = 0L;
            private final IntRef attempts$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Operation did not succeed within timeout after ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.attempts$1.elem)}));
            }
            {
                this.attempts$1 = attempts$1;
            }
        }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
    }

    /*
     * WARNING - void declaration
     */
    private KafkaProducer<byte[], byte[]> createTransactionalProducer() {
        void var1_14;
        this.producerConfig().setProperty("transactional.id", "txclient-1");
        this.producerConfig().put("enable.idempotence", "true");
        String x$1 = this.brokerList();
        SecurityProtocol x$2 = this.securityProtocol();
        Some<Properties> x$3 = this.clientSaslProperties();
        int x$4 = 1000;
        int x$5 = -1;
        Some x$6 = new Some((Object)this.producerConfig());
        long x$7 = TestUtils$.MODULE$.createNewProducer$default$3();
        long x$8 = TestUtils$.MODULE$.createNewProducer$default$4();
        long x$9 = TestUtils$.MODULE$.createNewProducer$default$6();
        long x$10 = TestUtils$.MODULE$.createNewProducer$default$7();
        Option<File> x$11 = TestUtils$.MODULE$.createNewProducer$default$9();
        ByteArraySerializer x$12 = TestUtils$.MODULE$.createNewProducer$default$11();
        ByteArraySerializer x$13 = TestUtils$.MODULE$.createNewProducer$default$12();
        KafkaProducer txProducer = TestUtils$.MODULE$.createNewProducer(x$1, x$5, x$7, x$8, x$4, x$9, x$10, x$2, x$11, (Option<Properties>)x$3, x$12, x$13, (Option<Properties>)x$6);
        this.producers().$plus$eq(txProducer);
        return var1_14;
    }

    public final void kafka$api$SaslClientsWithInvalidCredentialsTest$$describeTopic$1(AdminClient adminClient$1) {
        try {
            Map response = (Map)adminClient$1.describeTopics(Collections.singleton(this.topic())).all().get();
            Assert.assertEquals((long)1L, (long)response.size());
            ((IterableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(response).asScala()).foreach((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ SaslClientsWithInvalidCredentialsTest $outer;

                public final void apply(Tuple2<String, TopicDescription> x0$1) {
                    Tuple2<String, TopicDescription> tuple2 = x0$1;
                    if (tuple2 != null) {
                        TopicDescription description = (TopicDescription)tuple2._2();
                        Assert.assertEquals((long)this.$outer.numPartitions(), (long)description.partitions().size());
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        return;
                    }
                    throw new MatchError(tuple2);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            });
            return;
        }
        catch (ExecutionException executionException) {
            throw executionException.getCause();
        }
    }

    public SaslClientsWithInvalidCredentialsTest() {
        SaslSetup$class.$init$(this);
        this.kafkaClientSaslMechanism = "SCRAM-SHA-256";
        this.kafkaServerSaslMechanisms = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.kafkaClientSaslMechanism()}));
        this.securityProtocol = SecurityProtocol.SASL_PLAINTEXT;
        this.serverSaslProperties = new Some((Object)this.kafkaServerSaslProperties((Seq<String>)this.kafkaServerSaslMechanisms(), this.kafkaClientSaslMechanism()));
        this.clientSaslProperties = new Some((Object)this.kafkaClientSaslProperties(this.kafkaClientSaslMechanism(), this.kafkaClientSaslProperties$default$2()));
        this.consumerCount = 1;
        this.producerCount = 1;
        this.serverCount = 1;
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.OffsetsTopicReplicationFactorProp(), "1");
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.TransactionsTopicReplicationFactorProp(), "1");
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.TransactionsTopicMinISRProp(), "1");
        this.consumerConfig().setProperty("auto.offset.reset", "earliest");
        this.topic = "topic";
        this.numPartitions = 1;
        this.tp = new TopicPartition(this.topic(), 0);
    }
}

