/*
 * Decompiled with CFR 0.152.
 */
package kafka.cluster;

import java.io.File;
import java.nio.ByteBuffer;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import kafka.cluster.Partition;
import kafka.cluster.Partition$;
import kafka.cluster.Replica;
import kafka.cluster.Replica$;
import kafka.common.UnexpectedAppendOffsetException;
import kafka.log.CleanerConfig;
import kafka.log.CleanerConfig$;
import kafka.log.Log;
import kafka.log.LogConfig;
import kafka.log.LogConfig$;
import kafka.log.LogManager;
import kafka.server.BrokerTopicStats;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.LogDirFailureChannel;
import kafka.server.MetadataCache;
import kafka.server.QuotaFactory$;
import kafka.server.ReplicaManager;
import kafka.server.ReplicaManager$;
import kafka.utils.MockScheduler;
import kafka.utils.MockTime;
import kafka.utils.Scheduler;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.ReplicaNotAvailableException;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.DefaultRecordBatch;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.MemoryRecordsBuilder;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.common.record.TimestampType;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.collection.Iterable;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005Mf\u0001B\u0001\u0003\u0001\u001d\u0011Q\u0002U1si&$\u0018n\u001c8UKN$(BA\u0002\u0005\u0003\u001d\u0019G.^:uKJT\u0011!B\u0001\u0006W\u000647.Y\u0002\u0001'\t\u0001\u0001\u0002\u0005\u0002\n\u00195\t!BC\u0001\f\u0003\u0015\u00198-\u00197b\u0013\ti!B\u0001\u0004B]f\u0014VM\u001a\u0005\u0006\u001f\u0001!\t\u0001E\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003E\u0001\"A\u0005\u0001\u000e\u0003\tAq\u0001\u0006\u0001C\u0002\u0013\u0005Q#\u0001\u0005ce>\\WM]%e+\u00051\u0002CA\u0005\u0018\u0013\tA\"BA\u0002J]RDaA\u0007\u0001!\u0002\u00131\u0012!\u00032s_.,'/\u00133!\u0011\u001da\u0002A1A\u0005\u0002u\ta\u0002^8qS\u000e\u0004\u0016M\u001d;ji&|g.F\u0001\u001f!\tyr%D\u0001!\u0015\t\t#%\u0001\u0004d_6lwN\u001c\u0006\u0003\u000b\rR!\u0001J\u0013\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u00051\u0013aA8sO&\u0011\u0001\u0006\t\u0002\u000f)>\u0004\u0018n\u0019)beRLG/[8o\u0011\u0019Q\u0003\u0001)A\u0005=\u0005yAo\u001c9jGB\u000b'\u000f^5uS>t\u0007\u0005C\u0004-\u0001\t\u0007I\u0011A\u0017\u0002\tQLW.Z\u000b\u0002]A\u0011qFM\u0007\u0002a)\u0011\u0011\u0007B\u0001\u0006kRLGn]\u0005\u0003gA\u0012\u0001\"T8dWRKW.\u001a\u0005\u0007k\u0001\u0001\u000b\u0011\u0002\u0018\u0002\u000bQLW.\u001a\u0011\t\u000f]\u0002!\u0019!C\u0001q\u0005\u0001\"M]8lKJ$v\u000e]5d'R\fGo]\u000b\u0002sA\u0011!(P\u0007\u0002w)\u0011A\bB\u0001\u0007g\u0016\u0014h/\u001a:\n\u0005yZ$\u0001\u0005\"s_.,'\u000fV8qS\u000e\u001cF/\u0019;t\u0011\u0019\u0001\u0005\u0001)A\u0005s\u0005\t\"M]8lKJ$v\u000e]5d'R\fGo\u001d\u0011\t\u000f\t\u0003!\u0019!C\u0001\u0007\u00069Q.\u001a;sS\u000e\u001cX#\u0001#\u0011\u0005\u0015;U\"\u0001$\u000b\u0005\t\u0003\u0013B\u0001%G\u0005\u001diU\r\u001e:jGNDaA\u0013\u0001!\u0002\u0013!\u0015\u0001C7fiJL7m\u001d\u0011\t\u00131\u0003\u0001\u0019!a\u0001\n\u0003i\u0015A\u0002;na\u0012K'/F\u0001O!\tyE+D\u0001Q\u0015\t\t&+\u0001\u0002j_*\t1+\u0001\u0003kCZ\f\u0017BA+Q\u0005\u00111\u0015\u000e\\3\t\u0013]\u0003\u0001\u0019!a\u0001\n\u0003A\u0016A\u0003;na\u0012K'o\u0018\u0013fcR\u0011\u0011\f\u0018\t\u0003\u0013iK!a\u0017\u0006\u0003\tUs\u0017\u000e\u001e\u0005\b;Z\u000b\t\u00111\u0001O\u0003\rAH%\r\u0005\u0007?\u0002\u0001\u000b\u0015\u0002(\u0002\u000fQl\u0007\u000fR5sA!I\u0011\r\u0001a\u0001\u0002\u0004%\t!T\u0001\u0007Y><G)\u001b:\t\u0013\r\u0004\u0001\u0019!a\u0001\n\u0003!\u0017A\u00037pO\u0012K'o\u0018\u0013fcR\u0011\u0011,\u001a\u0005\b;\n\f\t\u00111\u0001O\u0011\u00199\u0007\u0001)Q\u0005\u001d\u00069An\\4ESJ\u0004\u0003\"C5\u0001\u0001\u0004\u0005\r\u0011\"\u0001k\u00039\u0011X\r\u001d7jG\u0006l\u0015M\\1hKJ,\u0012a\u001b\t\u0003u1L!!\\\u001e\u0003\u001dI+\u0007\u000f\\5dC6\u000bg.Y4fe\"Iq\u000e\u0001a\u0001\u0002\u0004%\t\u0001]\u0001\u0013e\u0016\u0004H.[2b\u001b\u0006t\u0017mZ3s?\u0012*\u0017\u000f\u0006\u0002Zc\"9QL\\A\u0001\u0002\u0004Y\u0007BB:\u0001A\u0003&1.A\bsKBd\u0017nY1NC:\fw-\u001a:!\u0011%)\b\u00011AA\u0002\u0013\u0005a/\u0001\u0006m_\u001el\u0015M\\1hKJ,\u0012a\u001e\t\u0003qnl\u0011!\u001f\u0006\u0003u\u0012\t1\u0001\\8h\u0013\ta\u0018P\u0001\u0006M_\u001el\u0015M\\1hKJD\u0011B \u0001A\u0002\u0003\u0007I\u0011A@\u0002\u001d1|w-T1oC\u001e,'o\u0018\u0013fcR\u0019\u0011,!\u0001\t\u000fuk\u0018\u0011!a\u0001o\"9\u0011Q\u0001\u0001!B\u00139\u0018a\u00037pO6\u000bg.Y4fe\u0002B1\"!\u0003\u0001\u0001\u0004\u0005\r\u0011\"\u0001\u0002\f\u0005IAn\\4D_:4\u0017nZ\u000b\u0003\u0003\u001b\u00012\u0001_A\b\u0013\r\t\t\"\u001f\u0002\n\u0019><7i\u001c8gS\u001eD1\"!\u0006\u0001\u0001\u0004\u0005\r\u0011\"\u0001\u0002\u0018\u0005iAn\\4D_:4\u0017nZ0%KF$2!WA\r\u0011%i\u00161CA\u0001\u0002\u0004\ti\u0001\u0003\u0005\u0002\u001e\u0001\u0001\u000b\u0015BA\u0007\u0003)awnZ\"p]\u001aLw\r\t\u0005\b\u0003C\u0001A\u0011AA\u0012\u0003\u0015\u0019X\r^;q)\u0005I\u0006\u0006BA\u0010\u0003O\u0001B!!\u000b\u000205\u0011\u00111\u0006\u0006\u0004\u0003[)\u0013!\u00026v]&$\u0018\u0002BA\u0019\u0003W\u0011aAQ3g_J,\u0007bBA\u001b\u0001\u0011\u0005\u00111E\u0001\ti\u0016\f'\u000fR8x]\"\"\u00111GA\u001d!\u0011\tI#a\u000f\n\t\u0005u\u00121\u0006\u0002\u0006\u0003\u001a$XM\u001d\u0005\b\u0003\u0003\u0002A\u0011AA\u0012\u00039\"Xm\u001d;BaB,g\u000e\u001a*fG>\u0014Hm]!t\r>dGn\\<fe\n+Gn\\<M_\u001e\u001cF/\u0019:u\u001f\u001a47/\u001a;)\t\u0005}\u0012Q\t\t\u0005\u0003S\t9%\u0003\u0003\u0002J\u0005-\"\u0001\u0002+fgRDq!!\u0014\u0001\t\u0003\t\u0019#\u0001\buKN$x)\u001a;SKBd\u0017nY1)\t\u0005-\u0013Q\t\u0005\b\u0003'\u0002A\u0011AA\u0012\u0003]\"Xm\u001d;BaB,g\u000e\u001a*fG>\u0014Hm\u001d+p\r>dGn\\<fe^KG\u000f\u001b(p%\u0016\u0004H.[2b)\"\u0014xn^:Fq\u000e,\u0007\u000f^5p]\"\"\u0011\u0011KA#\u0011\u001d\tI\u0006\u0001C\u0001\u00037\nQb\u0019:fCR,'+Z2pe\u0012\u001cH\u0003CA/\u0003S\nY)!&\u0011\t\u0005}\u0013QM\u0007\u0003\u0003CR1!a\u0019!\u0003\u0019\u0011XmY8sI&!\u0011qMA1\u00055iU-\\8ssJ+7m\u001c:eg\"A\u00111NA,\u0001\u0004\ti'A\u0004sK\u000e|'\u000fZ:\u0011\r\u0005=\u0014qPAC\u001d\u0011\t\t(a\u001f\u000f\t\u0005M\u0014\u0011P\u0007\u0003\u0003kR1!a\u001e\u0007\u0003\u0019a$o\\8u}%\t1\"C\u0002\u0002~)\tq\u0001]1dW\u0006<W-\u0003\u0003\u0002\u0002\u0006\r%\u0001C%uKJ\f'\r\\3\u000b\u0007\u0005u$\u0002\u0005\u0003\u0002`\u0005\u001d\u0015\u0002BAE\u0003C\u0012AbU5na2,'+Z2pe\u0012D\u0001\"!$\u0002X\u0001\u0007\u0011qR\u0001\u000bE\u0006\u001cXm\u00144gg\u0016$\bcA\u0005\u0002\u0012&\u0019\u00111\u0013\u0006\u0003\t1{gn\u001a\u0005\n\u0003/\u000b9\u0006%AA\u0002Y\tA\u0003]1si&$\u0018n\u001c8MK\u0006$WM]#q_\u000eD\u0007\"CAN\u0001E\u0005I\u0011AAO\u0003]\u0019'/Z1uKJ+7m\u001c:eg\u0012\"WMZ1vYR$3'\u0006\u0002\u0002 *\u001aa#!),\u0005\u0005\r\u0006\u0003BAS\u0003_k!!a*\u000b\t\u0005%\u00161V\u0001\nk:\u001c\u0007.Z2lK\u0012T1!!,\u000b\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003c\u000b9KA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\u0004")
public class PartitionTest {
    private final int brokerId;
    private final TopicPartition topicPartition = new TopicPartition("test-topic", 0);
    private final MockTime time = new MockTime();
    private final BrokerTopicStats brokerTopicStats = new BrokerTopicStats();
    private final Metrics metrics = new Metrics();
    private File tmpDir;
    private File logDir;
    private ReplicaManager replicaManager;
    private LogManager logManager;
    private LogConfig logConfig;

    public int brokerId() {
        return this.brokerId;
    }

    public TopicPartition topicPartition() {
        return this.topicPartition;
    }

    public MockTime time() {
        return this.time;
    }

    public BrokerTopicStats brokerTopicStats() {
        return this.brokerTopicStats;
    }

    public Metrics metrics() {
        return this.metrics;
    }

    public File tmpDir() {
        return this.tmpDir;
    }

    public void tmpDir_$eq(File x$1) {
        this.tmpDir = x$1;
    }

    public File logDir() {
        return this.logDir;
    }

    public void logDir_$eq(File x$1) {
        this.logDir = x$1;
    }

    public ReplicaManager replicaManager() {
        return this.replicaManager;
    }

    public void replicaManager_$eq(ReplicaManager x$1) {
        this.replicaManager = x$1;
    }

    public LogManager logManager() {
        return this.logManager;
    }

    public void logManager_$eq(LogManager x$1) {
        this.logManager = x$1;
    }

    public LogConfig logConfig() {
        return this.logConfig;
    }

    public void logConfig_$eq(LogConfig x$1) {
        this.logConfig = x$1;
    }

    @Before
    public void setup() {
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(512));
        logProps.put(LogConfig$.MODULE$.SegmentIndexBytesProp(), Predef$.MODULE$.int2Integer(1000));
        logProps.put(LogConfig$.MODULE$.RetentionMsProp(), Predef$.MODULE$.int2Integer(999));
        this.logConfig_$eq(new LogConfig((Map)logProps, LogConfig$.MODULE$.apply$default$2()));
        this.tmpDir_$eq(TestUtils$.MODULE$.tempDir());
        this.logDir_$eq(TestUtils$.MODULE$.randomPartitionLogDir(this.tmpDir()));
        boolean x$1 = false;
        int x$2 = CleanerConfig$.MODULE$.apply$default$1();
        long x$3 = CleanerConfig$.MODULE$.apply$default$2();
        double x$4 = CleanerConfig$.MODULE$.apply$default$3();
        int x$5 = CleanerConfig$.MODULE$.apply$default$4();
        int x$6 = CleanerConfig$.MODULE$.apply$default$5();
        double x$7 = CleanerConfig$.MODULE$.apply$default$6();
        long x$8 = CleanerConfig$.MODULE$.apply$default$7();
        String x$9 = CleanerConfig$.MODULE$.apply$default$9();
        this.logManager_$eq(TestUtils$.MODULE$.createLogManager((Seq<File>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new File[]{this.logDir()}))), this.logConfig(), new CleanerConfig(x$2, x$3, x$4, x$5, x$6, x$7, x$8, x$1, x$9), this.time()));
        this.logManager().startup();
        Properties brokerProps = TestUtils$.MODULE$.createBrokerConfig(this.brokerId(), TestUtils$.MODULE$.MockZkConnect(), TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18());
        brokerProps.put("log.dir", this.logDir().getAbsolutePath());
        KafkaConfig brokerConfig = KafkaConfig$.MODULE$.fromProps(brokerProps);
        this.replicaManager_$eq(new ReplicaManager(brokerConfig, this.metrics(), (Time)this.time(), null, (Scheduler)new MockScheduler((Time)this.time()), this.logManager(), new AtomicBoolean(false), QuotaFactory$.MODULE$.instantiate(brokerConfig, this.metrics(), (Time)this.time(), ""), this.brokerTopicStats(), new MetadataCache(this.brokerId()), new LogDirFailureChannel(brokerConfig.logDirs().size()), ReplicaManager$.MODULE$.$lessinit$greater$default$12()));
    }

    @After
    public void tearDown() {
        this.brokerTopicStats().close();
        this.metrics().close();
        this.logManager().shutdown();
        Utils.delete((File)this.tmpDir());
        this.logManager().liveLogDirs().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(File x$1) {
                Utils.delete((File)x$1);
            }
        });
        this.replicaManager().shutdown(false);
    }

    @Test
    public void testAppendRecordsAsFollowerBelowLogStartOffset() {
        LogManager qual$1 = this.logManager();
        TopicPartition x$10 = this.topicPartition();
        LogConfig x$11 = this.logConfig();
        boolean x$12 = qual$1.getOrCreateLog$default$3();
        boolean x$13 = qual$1.getOrCreateLog$default$4();
        Log log2 = qual$1.getOrCreateLog(x$10, x$11, x$12, x$13);
        int x$14 = this.brokerId();
        TopicPartition x$15 = this.topicPartition();
        MockTime x$16 = this.time();
        Some x$17 = new Some((Object)log2);
        long x$18 = Replica$.MODULE$.$lessinit$greater$default$4();
        Replica replica = new Replica(x$14, x$15, (Time)x$16, x$18, (Option)x$17);
        Partition partition = new Partition(this.topicPartition().topic(), this.topicPartition().partition(), (Time)this.time(), this.replicaManager(), Partition$.MODULE$.$lessinit$greater$default$5());
        partition.addReplicaIfNotExists(replica);
        Assert.assertEquals((Object)new Some((Object)replica), (Object)partition.getReplica(replica.brokerId()));
        long initialLogStartOffset = 5L;
        partition.truncateFullyAndStartAt(initialLogStartOffset, false);
        Assert.assertEquals((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Log end offset after truncate fully and start at ", ":"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)initialLogStartOffset)})), (long)initialLogStartOffset, (long)replica.logEndOffset().messageOffset());
        Assert.assertEquals((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Log start offset after truncate fully and start at ", ":"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)initialLogStartOffset)})), (long)initialLogStartOffset, (long)replica.logStartOffset());
        Assertions$.MODULE$.assertThrows((Function0)new Serializable(this, partition){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PartitionTest $outer;
            private final Partition partition$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.partition$1.appendRecordsToFollowerOrFutureReplica(this.$outer.createRecords((Iterable<SimpleRecord>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("k1".getBytes(), "v1".getBytes())})), 3L, this.$outer.createRecords$default$3()), false);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.partition$1 = partition$1;
            }
        }, ClassTag$.MODULE$.apply(UnexpectedAppendOffsetException.class), new Position("PartitionTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 103));
        Assert.assertEquals((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Log end offset should not change after failure to append"})).s((Seq)Nil$.MODULE$), (long)initialLogStartOffset, (long)replica.logEndOffset().messageOffset());
        long newLogStartOffset = 4L;
        MemoryRecords records2 = this.createRecords((Iterable<SimpleRecord>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("k1".getBytes(), "v1".getBytes()), new SimpleRecord("k2".getBytes(), "v2".getBytes()), new SimpleRecord("k3".getBytes(), "v3".getBytes())})), newLogStartOffset, this.createRecords$default$3());
        partition.appendRecordsToFollowerOrFutureReplica(records2, false);
        Assert.assertEquals((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Log end offset after append of 3 records with base offset ", ":"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)newLogStartOffset)})), (long)7L, (long)replica.logEndOffset().messageOffset());
        Assert.assertEquals((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Log start offset after append of 3 records with base offset ", ":"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)newLogStartOffset)})), (long)newLogStartOffset, (long)replica.logStartOffset());
        partition.appendRecordsToFollowerOrFutureReplica(this.createRecords((Iterable<SimpleRecord>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("k1".getBytes(), "v1".getBytes())})), 7L, this.createRecords$default$3()), false);
        Assert.assertEquals((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Log end offset after append of 1 record at offset 7:"})).s((Seq)Nil$.MODULE$), (long)8L, (long)replica.logEndOffset().messageOffset());
        Assert.assertEquals((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Log start offset not expected to change:"})).s((Seq)Nil$.MODULE$), (long)newLogStartOffset, (long)replica.logStartOffset());
        Assertions$.MODULE$.assertThrows((Function0)new Serializable(this, partition){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PartitionTest $outer;
            private final Partition partition$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                MemoryRecords records2 = this.$outer.createRecords((Iterable<SimpleRecord>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("k1".getBytes(), "v1".getBytes()), new SimpleRecord("k2".getBytes(), "v2".getBytes())})), 3L, this.$outer.createRecords$default$3());
                this.partition$1.appendRecordsToFollowerOrFutureReplica(records2, false);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.partition$1 = partition$1;
            }
        }, ClassTag$.MODULE$.apply(UnexpectedAppendOffsetException.class), new Position("PartitionTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 126));
        Assert.assertEquals((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Log end offset should not change after failure to append"})).s((Seq)Nil$.MODULE$), (long)8L, (long)replica.logEndOffset().messageOffset());
        partition.appendRecordsToFollowerOrFutureReplica(this.createRecords((Iterable<SimpleRecord>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("k1".getBytes(), "v1".getBytes())})), 8L, this.createRecords$default$3()), false);
        Assert.assertEquals((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Log end offset after append of 1 record at offset 8:"})).s((Seq)Nil$.MODULE$), (long)9L, (long)replica.logEndOffset().messageOffset());
        Assert.assertEquals((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Log start offset not expected to change:"})).s((Seq)Nil$.MODULE$), (long)newLogStartOffset, (long)replica.logStartOffset());
    }

    @Test
    public void testGetReplica() {
        LogManager qual$2 = this.logManager();
        TopicPartition x$19 = this.topicPartition();
        LogConfig x$20 = this.logConfig();
        boolean x$21 = qual$2.getOrCreateLog$default$3();
        boolean x$22 = qual$2.getOrCreateLog$default$4();
        Log log2 = qual$2.getOrCreateLog(x$19, x$20, x$21, x$22);
        int x$23 = this.brokerId();
        TopicPartition x$24 = this.topicPartition();
        MockTime x$25 = this.time();
        Some x$26 = new Some((Object)log2);
        long x$27 = Replica$.MODULE$.$lessinit$greater$default$4();
        Replica replica = new Replica(x$23, x$24, (Time)x$25, x$27, (Option)x$26);
        Partition partition = new Partition(this.topicPartition().topic(), this.topicPartition().partition(), (Time)this.time(), this.replicaManager(), Partition$.MODULE$.$lessinit$greater$default$5());
        Assert.assertEquals((Object)None$.MODULE$, (Object)partition.getReplica(this.brokerId()));
        Assertions$.MODULE$.assertThrows((Function0)new Serializable(this, partition){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PartitionTest $outer;
            private final Partition partition$2;

            public final Replica apply() {
                return this.partition$2.getReplicaOrException(this.$outer.brokerId());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.partition$2 = partition$2;
            }
        }, ClassTag$.MODULE$.apply(ReplicaNotAvailableException.class), new Position("PartitionTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 148));
        partition.addReplicaIfNotExists(replica);
        Assert.assertEquals((Object)replica, (Object)partition.getReplicaOrException(this.brokerId()));
    }

    @Test
    public void testAppendRecordsToFollowerWithNoReplicaThrowsException() {
        Partition partition = new Partition(this.topicPartition().topic(), this.topicPartition().partition(), (Time)this.time(), this.replicaManager(), Partition$.MODULE$.$lessinit$greater$default$5());
        Assertions$.MODULE$.assertThrows((Function0)new Serializable(this, partition){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PartitionTest $outer;
            private final Partition partition$3;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.partition$3.appendRecordsToFollowerOrFutureReplica(this.$outer.createRecords((Iterable<SimpleRecord>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("k1".getBytes(), "v1".getBytes())})), 0L, this.$outer.createRecords$default$3()), false);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.partition$3 = partition$3;
            }
        }, ClassTag$.MODULE$.apply(ReplicaNotAvailableException.class), new Position("PartitionTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 159));
    }

    public MemoryRecords createRecords(Iterable<SimpleRecord> records2, long baseOffset, int partitionLeaderEpoch) {
        ByteBuffer buf = ByteBuffer.allocate(DefaultRecordBatch.sizeInBytes((java.lang.Iterable)((java.lang.Iterable)JavaConverters$.MODULE$.asJavaIterableConverter(records2).asJava())));
        MemoryRecordsBuilder builder = MemoryRecords.builder((ByteBuffer)buf, (byte)2, (CompressionType)CompressionType.NONE, (TimestampType)TimestampType.LOG_APPEND_TIME, (long)baseOffset, (long)this.time().milliseconds(), (int)partitionLeaderEpoch);
        records2.foreach((Function1)new Serializable(this, builder){
            public static final long serialVersionUID = 0L;
            private final MemoryRecordsBuilder builder$1;

            public final Long apply(SimpleRecord x$1) {
                return this.builder$1.append(x$1);
            }
            {
                this.builder$1 = builder$1;
            }
        });
        return builder.build();
    }

    public int createRecords$default$3() {
        return 0;
    }

    public PartitionTest() {
        this.brokerId = 101;
    }
}

