/*
 * Decompiled with CFR 0.152.
 */
package kafka.coordinator.transaction;

import kafka.coordinator.transaction.CompleteAbort$;
import kafka.coordinator.transaction.CompleteCommit$;
import kafka.coordinator.transaction.Empty$;
import kafka.coordinator.transaction.Ongoing$;
import kafka.coordinator.transaction.PrepareAbort$;
import kafka.coordinator.transaction.PrepareCommit$;
import kafka.coordinator.transaction.TransactionLog$;
import kafka.coordinator.transaction.TransactionMetadata;
import kafka.coordinator.transaction.TransactionMetadata$;
import kafka.coordinator.transaction.TransactionState;
import kafka.coordinator.transaction.TxnKey;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.Record;
import org.apache.kafka.common.record.SimpleRecord;
import org.junit.Assert;
import org.junit.Test;
import org.scalactic.source.Position;
import org.scalatest.junit.JUnitSuite;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;

@ScalaSignature(bytes="\u0006\u0001A3A!\u0001\u0002\u0001\u0013\t\u0011BK]1og\u0006\u001cG/[8o\u0019><G+Z:u\u0015\t\u0019A!A\u0006ue\u0006t7/Y2uS>t'BA\u0003\u0007\u0003-\u0019wn\u001c:eS:\fGo\u001c:\u000b\u0003\u001d\tQa[1gW\u0006\u001c\u0001a\u0005\u0002\u0001\u0015A\u00111BE\u0007\u0002\u0019)\u0011QBD\u0001\u0006UVt\u0017\u000e\u001e\u0006\u0003\u001fA\t\u0011b]2bY\u0006$Xm\u001d;\u000b\u0003E\t1a\u001c:h\u0013\t\u0019BB\u0001\u0006K+:LGoU;ji\u0016DQ!\u0006\u0001\u0005\u0002Y\ta\u0001P5oSRtD#A\f\u0011\u0005a\u0001Q\"\u0001\u0002\t\u000fi\u0001!\u0019!C\u00017\u0005i\u0001O]8ek\u000e,'/\u00129pG\",\u0012\u0001\b\t\u0003;\u0001j\u0011A\b\u0006\u0002?\u0005)1oY1mC&\u0011\u0011E\b\u0002\u0006'\"|'\u000f\u001e\u0005\u0007G\u0001\u0001\u000b\u0011\u0002\u000f\u0002\u001dA\u0014x\u000eZ;dKJ,\u0005o\\2iA!9Q\u0005\u0001b\u0001\n\u00031\u0013\u0001\u0006;sC:\u001c\u0018m\u0019;j_:$\u0016.\\3pkRl5/F\u0001(!\ti\u0002&\u0003\u0002*=\t\u0019\u0011J\u001c;\t\r-\u0002\u0001\u0015!\u0003(\u0003U!(/\u00198tC\u000e$\u0018n\u001c8US6,w.\u001e;Ng\u0002Bq!\f\u0001C\u0002\u0013\u0005a&A\bu_BL7\rU1si&$\u0018n\u001c8t+\u0005y\u0003c\u0001\u00194m9\u0011Q$M\u0005\u0003ey\ta\u0001\u0015:fI\u00164\u0017B\u0001\u001b6\u0005\r\u0019V\r\u001e\u0006\u0003ey\u0001\"aN\u001f\u000e\u0003aR!!\u000f\u001e\u0002\r\r|W.\\8o\u0015\t91H\u0003\u0002=!\u00051\u0011\r]1dQ\u0016L!A\u0010\u001d\u0003\u001dQ{\u0007/[2QCJ$\u0018\u000e^5p]\"1\u0001\t\u0001Q\u0001\n=\n\u0001\u0003^8qS\u000e\u0004\u0016M\u001d;ji&|gn\u001d\u0011\t\u000b\t\u0003A\u0011A\"\u0002GMDw.\u001e7e)\"\u0014xn^#yG\u0016\u0004H/[8o/JLG/Z%om\u0006d\u0017\u000e\u001a+y]R\tA\t\u0005\u0002\u001e\u000b&\u0011aI\b\u0002\u0005+:LG\u000f\u000b\u0002B\u0011B\u0011\u0011jS\u0007\u0002\u0015*\u0011Q\u0002E\u0005\u0003\u0019*\u0013A\u0001V3ti\")a\n\u0001C\u0001\u0007\u000692\u000f[8vY\u0012\u0014V-\u00193Xe&$X-T3tg\u0006<Wm\u001d\u0015\u0003\u001b\"\u0003")
public class TransactionLogTest
extends JUnitSuite {
    private final short producerEpoch;
    private final int transactionTimeoutMs;
    private final Set<TopicPartition> topicPartitions = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("topic1", 0), new TopicPartition("topic1", 1), new TopicPartition("topic2", 0), new TopicPartition("topic2", 1), new TopicPartition("topic2", 2)}));

    public short producerEpoch() {
        return this.producerEpoch;
    }

    public int transactionTimeoutMs() {
        return this.transactionTimeoutMs;
    }

    public Set<TopicPartition> topicPartitions() {
        return this.topicPartitions;
    }

    @Test
    public void shouldThrowExceptionWriteInvalidTxn() {
        String transactionalId = "transactionalId";
        long producerId = 23423L;
        TransactionMetadata txnMetadata = TransactionMetadata$.MODULE$.apply(transactionalId, producerId, this.producerEpoch(), this.transactionTimeoutMs(), 0L);
        txnMetadata.addPartitions(this.topicPartitions());
        this.intercept((Function0)new Serializable(this, txnMetadata){
            public static final long serialVersionUID = 0L;
            private final TransactionMetadata txnMetadata$1;

            public final byte[] apply() {
                return TransactionLog$.MODULE$.valueToBytes(this.txnMetadata$1.prepareNoTransit());
            }
            {
                this.txnMetadata$1 = txnMetadata$1;
            }
        }, ClassTag$.MODULE$.apply(IllegalStateException.class), new Position("TransactionLogTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 48));
    }

    @Test
    public void shouldReadWriteMessages() {
        Map pidMappings = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"zero"), (Object)BoxesRunTime.boxToLong((long)0L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"one"), (Object)BoxesRunTime.boxToLong((long)1L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"two"), (Object)BoxesRunTime.boxToLong((long)2L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"three"), (Object)BoxesRunTime.boxToLong((long)3L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"four"), (Object)BoxesRunTime.boxToLong((long)4L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"five"), (Object)BoxesRunTime.boxToLong((long)5L))}));
        Map transactionStates = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToLong((long)0L)), (Object)Empty$.MODULE$), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToLong((long)1L)), (Object)Ongoing$.MODULE$), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToLong((long)2L)), (Object)PrepareCommit$.MODULE$), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToLong((long)3L)), (Object)CompleteCommit$.MODULE$), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToLong((long)4L)), (Object)PrepareAbort$.MODULE$), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToLong((long)5L)), (Object)CompleteAbort$.MODULE$)}));
        Seq txnRecords = ((TraversableOnce)pidMappings.map((Function1)new Serializable(this, transactionStates){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TransactionLogTest $outer;
            private final Map transactionStates$1;

            public final SimpleRecord apply(Tuple2<String, Object> x0$1) {
                Tuple2<String, Object> tuple2 = x0$1;
                if (tuple2 != null) {
                    long producerId;
                    String transactionalId = (String)tuple2._1();
                    TransactionMetadata txnMetadata = TransactionMetadata$.MODULE$.apply(transactionalId, producerId = tuple2._2$mcJ$sp(), this.$outer.producerEpoch(), this.$outer.transactionTimeoutMs(), (TransactionState)this.transactionStates$1.apply((Object)BoxesRunTime.boxToLong((long)producerId)), 0L);
                    if (!txnMetadata.state().equals(Empty$.MODULE$)) {
                        txnMetadata.addPartitions(this.$outer.topicPartitions());
                    }
                    byte[] keyBytes = TransactionLog$.MODULE$.keyToBytes(transactionalId);
                    byte[] valueBytes = TransactionLog$.MODULE$.valueToBytes(txnMetadata.prepareNoTransit());
                    SimpleRecord simpleRecord = new SimpleRecord(keyBytes, valueBytes);
                    return simpleRecord;
                }
                throw new MatchError(tuple2);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.transactionStates$1 = transactionStates$1;
            }
        }, Iterable$.MODULE$.canBuildFrom())).toSeq();
        MemoryRecords records2 = MemoryRecords.withRecords((long)0L, (CompressionType)CompressionType.NONE, (SimpleRecord[])((SimpleRecord[])txnRecords.toArray(ClassTag$.MODULE$.apply(SimpleRecord.class))));
        IntRef count = IntRef.create((int)0);
        ((IterableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(records2.records()).asScala()).foreach((Function1)new Serializable(this, pidMappings, transactionStates, count){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TransactionLogTest $outer;
            private final Map pidMappings$1;
            private final Map transactionStates$1;
            private final IntRef count$1;

            public final void apply(Record record) {
                TxnKey txnKey = TransactionLog$.MODULE$.readTxnRecordKey(record.key());
                String transactionalId = txnKey.transactionalId();
                TransactionMetadata txnMetadata = TransactionLog$.MODULE$.readTxnRecordValue(transactionalId, record.value());
                Assert.assertEquals((long)BoxesRunTime.unboxToLong((Object)this.pidMappings$1.apply((Object)transactionalId)), (long)txnMetadata.producerId());
                Assert.assertEquals((long)this.$outer.producerEpoch(), (long)txnMetadata.producerEpoch());
                Assert.assertEquals((long)this.$outer.transactionTimeoutMs(), (long)txnMetadata.txnTimeoutMs());
                Assert.assertEquals((Object)this.transactionStates$1.apply((Object)BoxesRunTime.boxToLong((long)txnMetadata.producerId())), (Object)txnMetadata.state());
                if (txnMetadata.state().equals(Empty$.MODULE$)) {
                    Assert.assertEquals((Object)Predef$.MODULE$.Set().empty(), (Object)txnMetadata.topicPartitions());
                } else {
                    Assert.assertEquals(this.$outer.topicPartitions(), (Object)txnMetadata.topicPartitions());
                }
                ++this.count$1.elem;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.pidMappings$1 = pidMappings$1;
                this.transactionStates$1 = transactionStates$1;
                this.count$1 = count$1;
            }
        });
        Assert.assertEquals((long)pidMappings.size(), (long)count.elem);
    }

    public TransactionLogTest() {
        this.producerEpoch = 0;
        this.transactionTimeoutMs = 1000;
    }
}

