/*
 * Decompiled with CFR 0.152.
 */
package kafka.zk;

import kafka.consumer.ConsumerConfig;
import kafka.utils.TestUtils$;
import kafka.utils.ZkUtils;
import kafka.utils.ZkUtils$;
import kafka.zk.ZooKeeperTestHarness;
import org.apache.kafka.common.config.ConfigException;
import org.junit.Assert;
import org.junit.Test;
import org.scalactic.source.Position;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001U3A!\u0001\u0002\u0001\u000f\tQ!l\u0013)bi\"$Vm\u001d;\u000b\u0005\r!\u0011A\u0001>l\u0015\u0005)\u0011!B6bM.\f7\u0001A\n\u0003\u0001!\u0001\"!\u0003\u0006\u000e\u0003\tI!a\u0003\u0002\u0003)i{wnS3fa\u0016\u0014H+Z:u\u0011\u0006\u0014h.Z:t\u0011\u0015i\u0001\u0001\"\u0001\u000f\u0003\u0019a\u0014N\\5u}Q\tq\u0002\u0005\u0002\n\u0001!9\u0011\u0003\u0001b\u0001\n\u0003\u0011\u0012\u0001\u00029bi\",\u0012a\u0005\t\u0003)ei\u0011!\u0006\u0006\u0003-]\tA\u0001\\1oO*\t\u0001$\u0001\u0003kCZ\f\u0017B\u0001\u000e\u0016\u0005\u0019\u0019FO]5oO\"1A\u0004\u0001Q\u0001\nM\tQ\u0001]1uQ\u0002BqA\b\u0001C\u0002\u0013\u0005q$\u0001\n{WN+7o]5p]RKW.Z8vi6\u001bX#\u0001\u0011\u0011\u0005\u0005\"S\"\u0001\u0012\u000b\u0003\r\nQa]2bY\u0006L!!\n\u0012\u0003\u0007%sG\u000f\u0003\u0004(\u0001\u0001\u0006I\u0001I\u0001\u0014u.\u001cVm]:j_:$\u0016.\\3pkRl5\u000f\t\u0005\u0006S\u0001!\tAK\u0001\u0019u.\u001cuN\u001c8fGR<\u0016\u000e\u001e5J]Z\fG.\u001b3S_>$X#A\u0016\u0011\u00051zcBA\u0011.\u0013\tq#%\u0001\u0004Qe\u0016$WMZ\u0005\u00035AR!A\f\u0012\t\u000bI\u0002A\u0011A\u001a\u0002OQ,7\u000f^\"sK\u0006$X\rU3sg&\u001cH/\u001a8u!\u0006$\b\u000e\u00165s_^\u001cX\t_2faRLwN\u001c\u000b\u0002iA\u0011\u0011%N\u0005\u0003m\t\u0012A!\u00168ji\"\u0012\u0011\u0007\u000f\t\u0003syj\u0011A\u000f\u0006\u0003wq\nQA[;oSRT\u0011!P\u0001\u0004_J<\u0017BA ;\u0005\u0011!Vm\u001d;\t\u000b\u0005\u0003A\u0011A\u001a\u00021Q,7\u000f^\"sK\u0006$X\rU3sg&\u001cH/\u001a8u!\u0006$\b\u000e\u000b\u0002Aq!)A\t\u0001C\u0001g\u0005iC/Z:u\u001b\u0006\\WmU;sKB+'o]5tiN\u0004\u0016\r\u001e5Fq&\u001cHo\u001d+ie><8/\u0012=dKB$\u0018n\u001c8)\u0005\rC\u0004\"B$\u0001\t\u0003\u0019\u0014A\b;fgRl\u0015m[3TkJ,\u0007+\u001a:tSN$8\u000fU1uQ\u0016C\u0018n\u001d;tQ\t1\u0005\bC\u0003K\u0001\u0011\u00051'\u0001\u0014uKN$8I]3bi\u0016,\u0005\u000f[3nKJ\fG\u000eU1uQRC'o\\<t\u000bb\u001cW\r\u001d;j_:D#!\u0013\u001d\t\u000b5\u0003A\u0011A\u001a\u0002;Q,7\u000f^\"sK\u0006$X-\u00129iK6,'/\u00197QCRDW\t_5tiND#\u0001\u0014\u001d\t\u000bA\u0003A\u0011A\u001a\u0002[Q,7\u000f^\"sK\u0006$X\rU3sg&\u001cH/\u001a8u'\u0016\fX/\u001a8uS\u0006dG\u000b\u001b:poN,\u0005pY3qi&|g\u000e\u000b\u0002Pq!)1\u000b\u0001C\u0001g\u0005!C/Z:u\u0007J,\u0017\r^3QKJ\u001c\u0018n\u001d;f]R\u001cV-];f]RL\u0017\r\\#ySN$8\u000f\u000b\u0002Sq\u0001")
public class ZKPathTest
extends ZooKeeperTestHarness {
    private final String path;
    private final int zkSessionTimeoutMs;

    public String path() {
        return this.path;
    }

    public int zkSessionTimeoutMs() {
        return this.zkSessionTimeoutMs;
    }

    public String zkConnectWithInvalidRoot() {
        return new StringBuilder().append((Object)this.zkConnect()).append((Object)"/ghost").toString();
    }

    @Test
    public void testCreatePersistentPathThrowsException() {
        ConsumerConfig config = new ConsumerConfig(TestUtils$.MODULE$.createConsumerProperties(this.zkConnectWithInvalidRoot(), "test", "1", TestUtils$.MODULE$.createConsumerProperties$default$4()));
        ZkUtils zkUtils = ZkUtils$.MODULE$.apply(this.zkConnectWithInvalidRoot(), this.zkSessionTimeoutMs(), config.zkConnectionTimeoutMs(), false);
        try {
            zkUtils.zkPath().resetNamespaceCheckedState();
            zkUtils.createPersistentPath(this.path(), zkUtils.createPersistentPath$default$2(), zkUtils.createPersistentPath$default$3());
            throw this.fail("Failed to throw ConfigException for missing ZooKeeper root node", new Position("ZKPathTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 41));
        }
        catch (ConfigException configException) {
            zkUtils.close();
            return;
        }
    }

    @Test
    public void testCreatePersistentPath() {
        ConsumerConfig config = new ConsumerConfig(TestUtils$.MODULE$.createConsumerProperties(this.zkConnect(), "test", "1", TestUtils$.MODULE$.createConsumerProperties$default$4()));
        ZkUtils zkUtils = ZkUtils$.MODULE$.apply(this.zkConnect(), this.zkSessionTimeoutMs(), config.zkConnectionTimeoutMs(), false);
        zkUtils.zkPath().resetNamespaceCheckedState();
        zkUtils.createPersistentPath(this.path(), zkUtils.createPersistentPath$default$2(), zkUtils.createPersistentPath$default$3());
        Assert.assertTrue((String)"Failed to create persistent path", (boolean)zkUtils.pathExists(this.path()));
        zkUtils.close();
    }

    @Test
    public void testMakeSurePersistsPathExistsThrowsException() {
        ConsumerConfig config = new ConsumerConfig(TestUtils$.MODULE$.createConsumerProperties(this.zkConnectWithInvalidRoot(), "test", "1", TestUtils$.MODULE$.createConsumerProperties$default$4()));
        ZkUtils zkUtils = ZkUtils$.MODULE$.apply(this.zkConnectWithInvalidRoot(), this.zkSessionTimeoutMs(), config.zkConnectionTimeoutMs(), false);
        try {
            zkUtils.zkPath().resetNamespaceCheckedState();
            zkUtils.makeSurePersistentPathExists(this.path(), zkUtils.makeSurePersistentPathExists$default$2());
            throw this.fail("Failed to throw ConfigException for missing ZooKeeper root node", new Position("ZKPathTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 65));
        }
        catch (ConfigException configException) {
            zkUtils.close();
            return;
        }
    }

    @Test
    public void testMakeSurePersistsPathExists() {
        ConsumerConfig config = new ConsumerConfig(TestUtils$.MODULE$.createConsumerProperties(this.zkConnect(), "test", "1", TestUtils$.MODULE$.createConsumerProperties$default$4()));
        ZkUtils zkUtils = ZkUtils$.MODULE$.apply(this.zkConnect(), this.zkSessionTimeoutMs(), config.zkConnectionTimeoutMs(), false);
        zkUtils.zkPath().resetNamespaceCheckedState();
        zkUtils.makeSurePersistentPathExists(this.path(), zkUtils.makeSurePersistentPathExists$default$2());
        Assert.assertTrue((String)"Failed to create persistent path", (boolean)zkUtils.pathExists(this.path()));
        zkUtils.close();
    }

    @Test
    public void testCreateEphemeralPathThrowsException() {
        ConsumerConfig config = new ConsumerConfig(TestUtils$.MODULE$.createConsumerProperties(this.zkConnectWithInvalidRoot(), "test", "1", TestUtils$.MODULE$.createConsumerProperties$default$4()));
        ZkUtils zkUtils = ZkUtils$.MODULE$.apply(this.zkConnectWithInvalidRoot(), this.zkSessionTimeoutMs(), config.zkConnectionTimeoutMs(), false);
        try {
            zkUtils.zkPath().resetNamespaceCheckedState();
            zkUtils.createEphemeralPathExpectConflict(this.path(), "somedata", zkUtils.createEphemeralPathExpectConflict$default$3());
            throw this.fail("Failed to throw ConfigException for missing ZooKeeper root node", new Position("ZKPathTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 89));
        }
        catch (ConfigException configException) {
            zkUtils.close();
            return;
        }
    }

    @Test
    public void testCreateEphemeralPathExists() {
        ConsumerConfig config = new ConsumerConfig(TestUtils$.MODULE$.createConsumerProperties(this.zkConnect(), "test", "1", TestUtils$.MODULE$.createConsumerProperties$default$4()));
        ZkUtils zkUtils = ZkUtils$.MODULE$.apply(this.zkConnect(), this.zkSessionTimeoutMs(), config.zkConnectionTimeoutMs(), false);
        zkUtils.zkPath().resetNamespaceCheckedState();
        zkUtils.createEphemeralPathExpectConflict(this.path(), "somedata", zkUtils.createEphemeralPathExpectConflict$default$3());
        Assert.assertTrue((String)"Failed to create ephemeral path", (boolean)zkUtils.pathExists(this.path()));
        zkUtils.close();
    }

    @Test
    public void testCreatePersistentSequentialThrowsException() {
        ConsumerConfig config = new ConsumerConfig(TestUtils$.MODULE$.createConsumerProperties(this.zkConnectWithInvalidRoot(), "test", "1", TestUtils$.MODULE$.createConsumerProperties$default$4()));
        ZkUtils zkUtils = ZkUtils$.MODULE$.apply(this.zkConnectWithInvalidRoot(), this.zkSessionTimeoutMs(), config.zkConnectionTimeoutMs(), false);
        try {
            zkUtils.zkPath().resetNamespaceCheckedState();
            zkUtils.createSequentialPersistentPath(this.path(), zkUtils.createSequentialPersistentPath$default$2(), zkUtils.createSequentialPersistentPath$default$3());
            throw this.fail("Failed to throw ConfigException for missing ZooKeeper root node", new Position("ZKPathTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 114));
        }
        catch (ConfigException configException) {
            zkUtils.close();
            return;
        }
    }

    @Test
    public void testCreatePersistentSequentialExists() {
        ConsumerConfig config = new ConsumerConfig(TestUtils$.MODULE$.createConsumerProperties(this.zkConnect(), "test", "1", TestUtils$.MODULE$.createConsumerProperties$default$4()));
        ZkUtils zkUtils = ZkUtils$.MODULE$.apply(this.zkConnect(), this.zkSessionTimeoutMs(), config.zkConnectionTimeoutMs(), false);
        zkUtils.zkPath().resetNamespaceCheckedState();
        String actualPath = zkUtils.createSequentialPersistentPath(this.path(), zkUtils.createSequentialPersistentPath$default$2(), zkUtils.createSequentialPersistentPath$default$3());
        Assert.assertTrue((String)"Failed to create persistent path", (boolean)zkUtils.pathExists(actualPath));
        zkUtils.close();
    }

    public ZKPathTest() {
        this.path = "/some_dir";
        this.zkSessionTimeoutMs = 1000;
    }
}

