/*
 * Decompiled with CFR 0.152.
 */
package unit.kafka.admin;

import joptsimple.OptionException;
import kafka.admin.ConsumerGroupCommand;
import kafka.admin.ConsumerGroupCommandTest;
import kafka.server.KafkaServer;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.protocol.Errors;
import org.junit.Assert;
import org.junit.Test;
import org.scalactic.source.Position;
import scala.Array$;
import scala.Function0;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001M3A!\u0001\u0002\u0001\u0013\t9B)\u001a7fi\u0016\u001cuN\\:v[\u0016\u0014xI]8vaR+7\u000f\u001e\u0006\u0003\u0007\u0011\tQ!\u00193nS:T!!\u0002\u0004\u0002\u000b-\fgm[1\u000b\u0003\u001d\tA!\u001e8ji\u000e\u00011C\u0001\u0001\u000b!\tYa\"D\u0001\r\u0015\t\u0019QBC\u0001\u0006\u0013\tyAB\u0001\rD_:\u001cX/\\3s\u000fJ|W\u000f]\"p[6\fg\u000e\u001a+fgRDQ!\u0005\u0001\u0005\u0002I\ta\u0001P5oSRtD#A\n\u0011\u0005Q\u0001Q\"\u0001\u0002\t\u000bY\u0001A\u0011A\f\u00023Q,7\u000f\u001e#fY\u0016$XmV5uQR{\u0007/[2PaRLwN\u001c\u000b\u00021A\u0011\u0011\u0004H\u0007\u00025)\t1$A\u0003tG\u0006d\u0017-\u0003\u0002\u001e5\t!QK\\5uQ\u0011)rd\n\u0015\u0011\u0005\u0001*S\"A\u0011\u000b\u0005\t\u001a\u0013!\u00026v]&$(\"\u0001\u0013\u0002\u0007=\u0014x-\u0003\u0002'C\t!A+Z:u\u0003!)\u0007\u0010]3di\u0016$7%A\u0015\u0011\u0005)jS\"A\u0016\u000b\u00031\n!B[8qiNLW\u000e\u001d7f\u0013\tq3FA\bPaRLwN\\#yG\u0016\u0004H/[8o\u0011\u0015\u0001\u0004\u0001\"\u0001\u0018\u0003u!Xm\u001d;EK2,G/Z\"nI:{g.\u0012=jgRLgnZ$s_V\u0004\bFA\u0018 \u0011\u0015\u0019\u0004\u0001\"\u0001\u0018\u0003i!Xm\u001d;EK2,G/\u001a(p]\u0016C\u0018n\u001d;j]\u001e<%o\\;qQ\t\u0011t\u0004C\u00037\u0001\u0011\u0005q#A\u000euKN$H)\u001a7fi\u0016\u001cU\u000eZ%om\u0006d\u0017\u000eZ$s_V\u0004\u0018\n\u001a\u0015\u0003k}AQ!\u000f\u0001\u0005\u0002]\t\u0001\u0004^3ti\u0012+G.\u001a;f\u0013:4\u0018\r\\5e\u000fJ|W\u000f]%eQ\tAt\u0004C\u0003=\u0001\u0011\u0005q#\u0001\u000euKN$H)\u001a7fi\u0016\u001cU\u000e\u001a(p]\u0016k\u0007\u000f^=He>,\b\u000f\u000b\u0002<?!)q\b\u0001C\u0001/\u00059B/Z:u\t\u0016dW\r^3O_:,U\u000e\u001d;z\u000fJ|W\u000f\u001d\u0015\u0003}}AQA\u0011\u0001\u0005\u0002]\tq\u0003^3ti\u0012+G.\u001a;f\u00076$W)\u001c9us\u001e\u0013x.\u001e9)\u0005\u0005{\u0002\"B#\u0001\t\u00039\u0012\u0001\u0006;fgR$U\r\\3uK\u0016k\u0007\u000f^=He>,\b\u000f\u000b\u0002E?!)\u0001\n\u0001C\u0001/\u0005)C/Z:u\t\u0016dW\r^3D[\u0012<\u0016\u000e\u001e5NSb|emU;dG\u0016\u001c8/\u00118e\u000bJ\u0014xN\u001d\u0015\u0003\u000f~AQa\u0013\u0001\u0005\u0002]\t!\u0005^3ti\u0012+G.\u001a;f/&$\b.T5y\u001f\u001a\u001cVoY2fgN\fe\u000eZ#se>\u0014\bF\u0001& \u0011\u0015q\u0005\u0001\"\u0001\u0018\u0003\u0011\"Xm\u001d;EK2,G/Z\"nI^KG\u000f[*i_J$\u0018J\\5uS\u0006d\u0017N_1uS>t\u0007FA' \u0011\u0015\t\u0006\u0001\"\u0001\u0018\u0003\u0005\"Xm\u001d;EK2,G/Z,ji\"\u001c\u0006n\u001c:u\u0013:LG/[1mSj\fG/[8oQ\t\u0001v\u0004")
public class DeleteConsumerGroupTest
extends ConsumerGroupCommandTest {
    @Test(expected=OptionException.class)
    public void testDeleteWithTopicOption() {
        TestUtils$.MODULE$.createOffsetsTopic(this.zkClient(), (Seq<KafkaServer>)this.servers());
        String[] cgcArgs = (String[])((Object[])new String[]{"--bootstrap-server", this.brokerList(), "--delete", "--group", this.group(), "--topic"});
        this.getConsumerGroupService(cgcArgs);
        throw this.fail("Expected an error due to presence of mutually exclusive options", new Position("DeleteConsumerGroupsTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 32));
    }

    @Test
    public void testDeleteCmdNonExistingGroup() {
        TestUtils$.MODULE$.createOffsetsTopic(this.zkClient(), (Seq<KafkaServer>)this.servers());
        String missingGroup = "missing.group";
        String[] cgcArgs = (String[])((Object[])new String[]{"--bootstrap-server", this.brokerList(), "--delete", "--group", missingGroup});
        ConsumerGroupCommand.ConsumerGroupService service = this.getConsumerGroupService(cgcArgs);
        String output = TestUtils$.MODULE$.grabConsoleOutput((Function0<BoxedUnit>)new Serializable(this, service){
            public static final long serialVersionUID = 0L;
            private final ConsumerGroupCommand.ConsumerGroupService service$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.service$1.deleteGroups();
            }
            {
                this.service$1 = service$1;
            }
        });
        Assert.assertTrue((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The expected error (", ") was not detected while deleting consumer group"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Errors.GROUP_ID_NOT_FOUND})), (boolean)output.contains(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Group '", "' could not be deleted due to: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{missingGroup, Errors.GROUP_ID_NOT_FOUND.toString()}))));
    }

    @Test
    public void testDeleteNonExistingGroup() {
        TestUtils$.MODULE$.createOffsetsTopic(this.zkClient(), (Seq<KafkaServer>)this.servers());
        String missingGroup = "missing.group";
        String[] cgcArgs = (String[])((Object[])new String[]{"--bootstrap-server", this.brokerList(), "--delete", "--group", missingGroup});
        ConsumerGroupCommand.ConsumerGroupService service = this.getConsumerGroupService(cgcArgs);
        Map result = service.deleteGroups();
        Assert.assertTrue((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The expected error (", ") was not detected while deleting consumer group"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Errors.GROUP_ID_NOT_FOUND})), (result.size() == 1 && result.keySet().contains((Object)missingGroup) && result.get((Object)missingGroup).contains((Object)Errors.GROUP_ID_NOT_FOUND) ? 1 : 0) != 0);
    }

    @Test
    public void testDeleteCmdInvalidGroupId() {
        TestUtils$.MODULE$.createOffsetsTopic(this.zkClient(), (Seq<KafkaServer>)this.servers());
        String invalidGroupId = "";
        String[] cgcArgs = (String[])((Object[])new String[]{"--bootstrap-server", this.brokerList(), "--delete", "--group", invalidGroupId});
        ConsumerGroupCommand.ConsumerGroupService service = this.getConsumerGroupService(cgcArgs);
        String output = TestUtils$.MODULE$.grabConsoleOutput((Function0<BoxedUnit>)new Serializable(this, service){
            public static final long serialVersionUID = 0L;
            private final ConsumerGroupCommand.ConsumerGroupService service$2;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.service$2.deleteGroups();
            }
            {
                this.service$2 = service$2;
            }
        });
        Assert.assertTrue((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The expected error (", ") was not detected while deleting consumer group"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Errors.INVALID_GROUP_ID})), (boolean)output.contains(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Group '", "' could not be deleted due to: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{invalidGroupId, Errors.INVALID_GROUP_ID.toString()}))));
    }

    @Test
    public void testDeleteInvalidGroupId() {
        TestUtils$.MODULE$.createOffsetsTopic(this.zkClient(), (Seq<KafkaServer>)this.servers());
        String invalidGroupId = "";
        String[] cgcArgs = (String[])((Object[])new String[]{"--bootstrap-server", this.brokerList(), "--delete", "--group", invalidGroupId});
        ConsumerGroupCommand.ConsumerGroupService service = this.getConsumerGroupService(cgcArgs);
        Map result = service.deleteGroups();
        Assert.assertTrue((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The expected error (", ") was not detected while deleting consumer group"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Errors.INVALID_GROUP_ID})), (result.size() == 1 && result.keySet().contains((Object)invalidGroupId) && result.get((Object)invalidGroupId).contains((Object)Errors.INVALID_GROUP_ID) ? 1 : 0) != 0);
    }

    @Test
    public void testDeleteCmdNonEmptyGroup() {
        TestUtils$.MODULE$.createOffsetsTopic(this.zkClient(), (Seq<KafkaServer>)this.servers());
        this.addConsumerGroupExecutor(1, this.addConsumerGroupExecutor$default$2(), this.addConsumerGroupExecutor$default$3(), this.addConsumerGroupExecutor$default$4());
        String[] cgcArgs = (String[])((Object[])new String[]{"--bootstrap-server", this.brokerList(), "--delete", "--group", this.group()});
        ConsumerGroupCommand.ConsumerGroupService service = this.getConsumerGroupService(cgcArgs);
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, service){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DeleteConsumerGroupTest $outer;
            private final ConsumerGroupCommand.ConsumerGroupService service$3;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return this.service$3.listGroups().contains((Object)this.$outer.group());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.service$3 = service$3;
            }
        }, (Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "The group did not initialize as expected.";
            }
        }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
        String output = TestUtils$.MODULE$.grabConsoleOutput((Function0<BoxedUnit>)new Serializable(this, service){
            public static final long serialVersionUID = 0L;
            private final ConsumerGroupCommand.ConsumerGroupService service$3;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.service$3.deleteGroups();
            }
            {
                this.service$3 = service$3;
            }
        });
        Assert.assertTrue((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The expected error (", ") was not detected while deleting consumer group"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Errors.NON_EMPTY_GROUP})), (boolean)output.contains(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Group '", "' could not be deleted due to: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.group(), Errors.NON_EMPTY_GROUP}))));
    }

    @Test
    public void testDeleteNonEmptyGroup() {
        TestUtils$.MODULE$.createOffsetsTopic(this.zkClient(), (Seq<KafkaServer>)this.servers());
        this.addConsumerGroupExecutor(1, this.addConsumerGroupExecutor$default$2(), this.addConsumerGroupExecutor$default$3(), this.addConsumerGroupExecutor$default$4());
        String[] cgcArgs = (String[])((Object[])new String[]{"--bootstrap-server", this.brokerList(), "--delete", "--group", this.group()});
        ConsumerGroupCommand.ConsumerGroupService service = this.getConsumerGroupService(cgcArgs);
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, service){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DeleteConsumerGroupTest $outer;
            private final ConsumerGroupCommand.ConsumerGroupService service$4;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return this.service$4.listGroups().contains((Object)this.$outer.group());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.service$4 = service$4;
            }
        }, (Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "The group did not initialize as expected.";
            }
        }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
        Map result = service.deleteGroups();
        Assert.assertTrue((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The expected error (", ") was not detected while deleting consumer group"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Errors.NON_EMPTY_GROUP})), (result.size() == 1 && result.keySet().contains((Object)this.group()) && result.get((Object)this.group()).contains((Object)Errors.NON_EMPTY_GROUP) ? 1 : 0) != 0);
    }

    @Test
    public void testDeleteCmdEmptyGroup() {
        TestUtils$.MODULE$.createOffsetsTopic(this.zkClient(), (Seq<KafkaServer>)this.servers());
        ConsumerGroupCommandTest.ConsumerGroupExecutor executor = this.addConsumerGroupExecutor(1, this.addConsumerGroupExecutor$default$2(), this.addConsumerGroupExecutor$default$3(), this.addConsumerGroupExecutor$default$4());
        String[] cgcArgs = (String[])((Object[])new String[]{"--bootstrap-server", this.brokerList(), "--delete", "--group", this.group()});
        ConsumerGroupCommand.ConsumerGroupService service = this.getConsumerGroupService(cgcArgs);
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, service){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DeleteConsumerGroupTest $outer;
            private final ConsumerGroupCommand.ConsumerGroupService service$5;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return this.service$5.listGroups().contains((Object)this.$outer.group());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.service$5 = service$5;
            }
        }, (Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "The group did not initialize as expected.";
            }
        }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
        executor.shutdown();
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, service){
            public static final long serialVersionUID = 0L;
            private final ConsumerGroupCommand.ConsumerGroupService service$5;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                String string = this.service$5.collectGroupState().state();
                String string2 = "Empty";
                return !(string != null ? !string.equals(string2) : string2 != null);
            }
            {
                this.service$5 = service$5;
            }
        }, (Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "The group did become empty as expected.";
            }
        }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
        String output = TestUtils$.MODULE$.grabConsoleOutput((Function0<BoxedUnit>)new Serializable(this, service){
            public static final long serialVersionUID = 0L;
            private final ConsumerGroupCommand.ConsumerGroupService service$5;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.service$5.deleteGroups();
            }
            {
                this.service$5 = service$5;
            }
        });
        Assert.assertTrue((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The consumer group could not be deleted as expected"})).s((Seq)Nil$.MODULE$), (boolean)output.contains(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Deletion of requested consumer groups ('", "') was successful."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.group()}))));
    }

    @Test
    public void testDeleteEmptyGroup() {
        TestUtils$.MODULE$.createOffsetsTopic(this.zkClient(), (Seq<KafkaServer>)this.servers());
        ConsumerGroupCommandTest.ConsumerGroupExecutor executor = this.addConsumerGroupExecutor(1, this.addConsumerGroupExecutor$default$2(), this.addConsumerGroupExecutor$default$3(), this.addConsumerGroupExecutor$default$4());
        String[] cgcArgs = (String[])((Object[])new String[]{"--bootstrap-server", this.brokerList(), "--delete", "--group", this.group()});
        ConsumerGroupCommand.ConsumerGroupService service = this.getConsumerGroupService(cgcArgs);
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, service){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DeleteConsumerGroupTest $outer;
            private final ConsumerGroupCommand.ConsumerGroupService service$6;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return this.service$6.listGroups().contains((Object)this.$outer.group());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.service$6 = service$6;
            }
        }, (Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "The group did not initialize as expected.";
            }
        }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
        executor.shutdown();
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, service){
            public static final long serialVersionUID = 0L;
            private final ConsumerGroupCommand.ConsumerGroupService service$6;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                String string = this.service$6.collectGroupState().state();
                String string2 = "Empty";
                return !(string != null ? !string.equals(string2) : string2 != null);
            }
            {
                this.service$6 = service$6;
            }
        }, (Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "The group did become empty as expected.";
            }
        }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
        Map result = service.deleteGroups();
        Assert.assertTrue((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The consumer group could not be deleted as expected"})).s((Seq)Nil$.MODULE$), (result.size() == 1 && result.keySet().contains((Object)this.group()) && result.get((Object)this.group()).contains((Object)Errors.NONE) ? 1 : 0) != 0);
    }

    @Test
    public void testDeleteCmdWithMixOfSuccessAndError() {
        TestUtils$.MODULE$.createOffsetsTopic(this.zkClient(), (Seq<KafkaServer>)this.servers());
        String missingGroup = "missing.group";
        ConsumerGroupCommandTest.ConsumerGroupExecutor executor = this.addConsumerGroupExecutor(1, this.addConsumerGroupExecutor$default$2(), this.addConsumerGroupExecutor$default$3(), this.addConsumerGroupExecutor$default$4());
        String[] cgcArgs = (String[])((Object[])new String[]{"--bootstrap-server", this.brokerList(), "--delete", "--group", this.group()});
        ConsumerGroupCommand.ConsumerGroupService service = this.getConsumerGroupService(cgcArgs);
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, service){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DeleteConsumerGroupTest $outer;
            private final ConsumerGroupCommand.ConsumerGroupService service$7;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return this.service$7.listGroups().contains((Object)this.$outer.group());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.service$7 = service$7;
            }
        }, (Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "The group did not initialize as expected.";
            }
        }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
        executor.shutdown();
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, service){
            public static final long serialVersionUID = 0L;
            private final ConsumerGroupCommand.ConsumerGroupService service$7;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                String string = this.service$7.collectGroupState().state();
                String string2 = "Empty";
                return !(string != null ? !string.equals(string2) : string2 != null);
            }
            {
                this.service$7 = service$7;
            }
        }, (Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "The group did become empty as expected.";
            }
        }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
        ConsumerGroupCommand.ConsumerGroupService service2 = this.getConsumerGroupService((String[])Predef$.MODULE$.refArrayOps((Object[])cgcArgs).$plus$plus((GenTraversableOnce)Predef$.MODULE$.refArrayOps((Object[])new String[]{"--group", missingGroup}), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))));
        String output = TestUtils$.MODULE$.grabConsoleOutput((Function0<BoxedUnit>)new Serializable(this, service2){
            public static final long serialVersionUID = 0L;
            private final ConsumerGroupCommand.ConsumerGroupService service2$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.service2$1.deleteGroups();
            }
            {
                this.service2$1 = service2$1;
            }
        });
        Assert.assertTrue((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The consumer group deletion did not work as expected"})).s((Seq)Nil$.MODULE$), (output.contains(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Group '", "' could not be deleted due to: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{missingGroup, Errors.GROUP_ID_NOT_FOUND}))) && output.contains(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"These consumer groups were deleted successfully: '", "'"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.group()}))) ? 1 : 0) != 0);
    }

    @Test
    public void testDeleteWithMixOfSuccessAndError() {
        TestUtils$.MODULE$.createOffsetsTopic(this.zkClient(), (Seq<KafkaServer>)this.servers());
        String missingGroup = "missing.group";
        ConsumerGroupCommandTest.ConsumerGroupExecutor executor = this.addConsumerGroupExecutor(1, this.addConsumerGroupExecutor$default$2(), this.addConsumerGroupExecutor$default$3(), this.addConsumerGroupExecutor$default$4());
        String[] cgcArgs = (String[])((Object[])new String[]{"--bootstrap-server", this.brokerList(), "--delete", "--group", this.group()});
        ConsumerGroupCommand.ConsumerGroupService service = this.getConsumerGroupService(cgcArgs);
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, service){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DeleteConsumerGroupTest $outer;
            private final ConsumerGroupCommand.ConsumerGroupService service$8;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return this.service$8.listGroups().contains((Object)this.$outer.group());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.service$8 = service$8;
            }
        }, (Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "The group did not initialize as expected.";
            }
        }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
        executor.shutdown();
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, service){
            public static final long serialVersionUID = 0L;
            private final ConsumerGroupCommand.ConsumerGroupService service$8;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                String string = this.service$8.collectGroupState().state();
                String string2 = "Empty";
                return !(string != null ? !string.equals(string2) : string2 != null);
            }
            {
                this.service$8 = service$8;
            }
        }, (Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "The group did become empty as expected.";
            }
        }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
        ConsumerGroupCommand.ConsumerGroupService service2 = this.getConsumerGroupService((String[])Predef$.MODULE$.refArrayOps((Object[])cgcArgs).$plus$plus((GenTraversableOnce)Predef$.MODULE$.refArrayOps((Object[])new String[]{"--group", missingGroup}), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))));
        Map result = service2.deleteGroups();
        Assert.assertTrue((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The consumer group deletion did not work as expected"})).s((Seq)Nil$.MODULE$), (result.size() == 2 && result.keySet().contains((Object)this.group()) && result.get((Object)this.group()).contains((Object)Errors.NONE) && result.keySet().contains((Object)missingGroup) && result.get((Object)missingGroup).contains((Object)Errors.GROUP_ID_NOT_FOUND) ? 1 : 0) != 0);
    }

    @Test
    public void testDeleteCmdWithShortInitialization() {
        ConsumerGroupCommandTest.ConsumerGroupExecutor executor = this.addConsumerGroupExecutor(1, this.addConsumerGroupExecutor$default$2(), this.addConsumerGroupExecutor$default$3(), this.addConsumerGroupExecutor$default$4());
        String[] cgcArgs = (String[])((Object[])new String[]{"--bootstrap-server", this.brokerList(), "--delete", "--group", this.group()});
        ConsumerGroupCommand.ConsumerGroupService service = this.getConsumerGroupService(cgcArgs);
        String output = TestUtils$.MODULE$.grabConsoleOutput((Function0<BoxedUnit>)new Serializable(this, service){
            public static final long serialVersionUID = 0L;
            private final ConsumerGroupCommand.ConsumerGroupService service$9;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.service$9.deleteGroups();
            }
            {
                this.service$9 = service$9;
            }
        });
        Assert.assertTrue((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The consumer group deletion did not work as expected"})).s((Seq)Nil$.MODULE$), (boolean)output.contains(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Group '", "' could not be deleted due to: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.group(), Errors.COORDINATOR_NOT_AVAILABLE}))));
    }

    @Test
    public void testDeleteWithShortInitialization() {
        ConsumerGroupCommandTest.ConsumerGroupExecutor executor = this.addConsumerGroupExecutor(1, this.addConsumerGroupExecutor$default$2(), this.addConsumerGroupExecutor$default$3(), this.addConsumerGroupExecutor$default$4());
        String[] cgcArgs = (String[])((Object[])new String[]{"--bootstrap-server", this.brokerList(), "--delete", "--group", this.group()});
        ConsumerGroupCommand.ConsumerGroupService service = this.getConsumerGroupService(cgcArgs);
        Map result = service.deleteGroups();
        Assert.assertTrue((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The consumer group deletion did not work as expected"})).s((Seq)Nil$.MODULE$), (result.size() == 1 && result.keySet().contains((Object)this.group()) && result.get((Object)this.group()).contains((Object)Errors.COORDINATOR_NOT_AVAILABLE) ? 1 : 0) != 0);
    }
}

