/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.nio.ByteBuffer;
import java.util.LinkedHashMap;
import kafka.api.Request$;
import kafka.cluster.BrokerEndPoint;
import kafka.cluster.Partition;
import kafka.cluster.Replica;
import kafka.server.AbstractFetcherThread;
import kafka.server.BrokerTopicStats;
import kafka.server.FetchPartitionData;
import kafka.server.KafkaConfig;
import kafka.server.LogOffsetMetadata;
import kafka.server.LogOffsetMetadata$;
import kafka.server.PartitionFetchState;
import kafka.server.QuotaFactory$UnboundedQuota$;
import kafka.server.ReplicaManager;
import kafka.server.ReplicationQuotaManager;
import kafka.server.epoch.LeaderEpochCache;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.KafkaStorageException;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.record.FileRecords;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.Records;
import org.apache.kafka.common.requests.EpochEndOffset;
import org.apache.kafka.common.requests.FetchRequest;
import org.apache.kafka.common.requests.FetchResponse;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.Set$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashMap$;
import scala.collection.mutable.SetLike;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;

@ScalaSignature(bytes="\u0006\u0001\t]d\u0001B\u0001\u0003\u0001\u001d\u0011\u0011DU3qY&\u001c\u0017-\u00117uKJdun\u001a#jeN$\u0006N]3bI*\u00111\u0001B\u0001\u0007g\u0016\u0014h/\u001a:\u000b\u0003\u0015\tQa[1gW\u0006\u001c\u0001a\u0005\u0002\u0001\u0011A\u0011\u0011BC\u0007\u0002\u0005%\u00111B\u0001\u0002\u0016\u0003\n\u001cHO]1di\u001a+Go\u00195feRC'/Z1e\u0011%i\u0001A!A!\u0002\u0013q\u0001$\u0001\u0003oC6,\u0007CA\b\u0016\u001d\t\u00012#D\u0001\u0012\u0015\u0005\u0011\u0012!B:dC2\f\u0017B\u0001\u000b\u0012\u0003\u0019\u0001&/\u001a3fM&\u0011ac\u0006\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005Q\t\u0012BA\u0007\u001a\u0013\tQ2D\u0001\nTQV$Hm\\<oC\ndW\r\u00165sK\u0006$'B\u0001\u000f\u0005\u0003\u0015)H/\u001b7t\u0011%q\u0002A!A!\u0002\u0013yR%\u0001\u0007t_V\u00148-\u001a\"s_.,'\u000f\u0005\u0002!G5\t\u0011E\u0003\u0002#\t\u000591\r\\;ti\u0016\u0014\u0018B\u0001\u0013\"\u00059\u0011%o\\6fe\u0016sG\rU8j]RL!A\b\u0006\t\u0011\u001d\u0002!\u0011!Q\u0001\n!\nAB\u0019:pW\u0016\u00148i\u001c8gS\u001e\u0004\"!C\u0015\n\u0005)\u0012!aC&bM.\f7i\u001c8gS\u001eD\u0001\u0002\f\u0001\u0003\u0002\u0003\u0006I!L\u0001\u000be\u0016\u0004H.[2b\u001b\u001e\u0014\bCA\u0005/\u0013\ty#A\u0001\bSKBd\u0017nY1NC:\fw-\u001a:\t\u0011E\u0002!\u0011!Q\u0001\nI\nQ!];pi\u0006\u0004\"!C\u001a\n\u0005Q\u0012!a\u0006*fa2L7-\u0019;j_:\fVo\u001c;b\u001b\u0006t\u0017mZ3s\u0011!1\u0004A!A!\u0002\u00139\u0014\u0001\u00052s_.,'\u000fV8qS\u000e\u001cF/\u0019;t!\tI\u0001(\u0003\u0002:\u0005\t\u0001\"I]8lKJ$v\u000e]5d'R\fGo\u001d\u0005\u0006w\u0001!\t\u0001P\u0001\u0007y%t\u0017\u000e\u001e \u0015\u000furt\bQ!C\u0007B\u0011\u0011\u0002\u0001\u0005\u0006\u001bi\u0002\rA\u0004\u0005\u0006=i\u0002\ra\b\u0005\u0006Oi\u0002\r\u0001\u000b\u0005\u0006Yi\u0002\r!\f\u0005\u0006ci\u0002\rA\r\u0005\u0006mi\u0002\raN\u0003\u0005\u000b\u0002\u0001aIA\u0002S\u000bF\u0003\"a\u0012*\u000f\u0005%Au!B%\u0003\u0011\u0003Q\u0015!\u0007*fa2L7-Y!mi\u0016\u0014Hj\\4ESJ\u001cH\u000b\u001b:fC\u0012\u0004\"!C&\u0007\u000b\u0005\u0011\u0001\u0012\u0001'\u0014\u0005-k\u0005C\u0001\tO\u0013\ty\u0015C\u0001\u0004B]f\u0014VM\u001a\u0005\u0006w-#\t!\u0015\u000b\u0002\u0015\u001a)1k\u0013\u0001\u0003)\naa)\u001a;dQJ+\u0017/^3tiN\u0019!+T+\u0011\u0005YKfBA\u0005X\u0013\tA&!A\u000bBEN$(/Y2u\r\u0016$8\r[3s)\"\u0014X-\u00193\n\u0005MS&B\u0001-\u0003\u0011!a&K!b\u0001\n\u0003i\u0016AC;oI\u0016\u0014H._5oOV\ta\f\u0005\u0002`Y:\u0011\u0001M[\u0007\u0002C*\u0011!mY\u0001\te\u0016\fX/Z:ug*\u0011A-Z\u0001\u0007G>lWn\u001c8\u000b\u0005\u00151'BA4i\u0003\u0019\t\u0007/Y2iK*\t\u0011.A\u0002pe\u001eL!a[1\u0002\u0019\u0019+Go\u00195SKF,Xm\u001d;\n\u00055t'a\u0002\"vS2$WM\u001d\u0006\u0003W\u0006D\u0001\u0002\u001d*\u0003\u0002\u0003\u0006IAX\u0001\fk:$WM\u001d7zS:<\u0007\u0005C\u0003<%\u0012\u0005!\u000f\u0006\u0002tkB\u0011AOU\u0007\u0002\u0017\")A,\u001da\u0001=\")qO\u0015C\u0001q\u00069\u0011n]#naRLX#A=\u0011\u0005AQ\u0018BA>\u0012\u0005\u001d\u0011un\u001c7fC:DQ! *\u0005\u0002y\faa\u001c4gg\u0016$HcA@\u0002\u0006A\u0019\u0001#!\u0001\n\u0007\u0005\r\u0011C\u0001\u0003M_:<\u0007bBA\u0004y\u0002\u0007\u0011\u0011B\u0001\u000fi>\u0004\u0018n\u0019)beRLG/[8o!\u0011\tY!!\u0004\u000e\u0003\rL1!a\u0004d\u00059!v\u000e]5d!\u0006\u0014H/\u001b;j_:Dq!a\u0005S\t\u0003\n)\"\u0001\u0005u_N#(/\u001b8h)\t\t9\u0002\u0005\u0003\u0002\u001a\u0005\rRBAA\u000e\u0015\u0011\ti\"a\b\u0002\t1\fgn\u001a\u0006\u0003\u0003C\tAA[1wC&\u0019a#a\u0007\u0007\u000f\u0005\u001d2\n\u0001\u0002\u0002*\ti\u0001+\u0019:uSRLwN\u001c#bi\u0006\u001cR!!\nN\u0003W\u00012AVA\u0017\u0013\r\t9C\u0017\u0005\u000b9\u0006\u0015\"Q1A\u0005\u0002\u0005ERCAA\u001a!\u0011\t)$a\u000f\u000f\u0007\u0001\f9$C\u0002\u0002:\u0005\fQBR3uG\"\u0014Vm\u001d9p]N,\u0017\u0002BA\u0014\u0003{Q1!!\u000fb\u0011)\u0001\u0018Q\u0005B\u0001B\u0003%\u00111\u0007\u0005\bw\u0005\u0015B\u0011AA\")\u0011\t)%a\u0012\u0011\u0007Q\f)\u0003C\u0004]\u0003\u0003\u0002\r!a\r\t\u0011\u0005-\u0013Q\u0005C\u0001\u0003\u001b\nQ!\u001a:s_J,\"!a\u0014\u0011\t\u0005E\u0013qK\u0007\u0003\u0003'R1!!\u0016d\u0003!\u0001(o\u001c;pG>d\u0017\u0002BA-\u0003'\u0012a!\u0012:s_J\u001c\b\u0002CA/\u0003K!\t!a\u0018\u0002\u0013Q|'+Z2pe\u0012\u001cXCAA1!\u0011\t\u0019'!\u001b\u000e\u0005\u0005\u0015$bAA4G\u00061!/Z2pe\u0012LA!a\u001b\u0002f\tiQ*Z7pef\u0014VmY8sIND\u0001\"a\u001c\u0002&\u0011\u0005\u0011\u0011O\u0001\u000eQ&<\u0007nV1uKJl\u0017M]6\u0016\u0003}D\u0001\"!\u001e\u0002&\u0011\u0005\u0011\u0011O\u0001\u000fY><7\u000b^1si>3gm]3u\u0011!\tI(!\n\u0005\u0002\u0005m\u0014!C3yG\u0016\u0004H/[8o+\t\ti\bE\u0003\u0011\u0003\u007f\n\u0019)C\u0002\u0002\u0002F\u0011aa\u00149uS>t\u0007\u0003BAC\u0003+sA!a\"\u0002\u0012:!\u0011\u0011RAH\u001b\t\tYIC\u0002\u0002\u000e\u001a\ta\u0001\u0010:p_Rt\u0014\"\u0001\n\n\u0007\u0005M\u0015#A\u0004qC\u000e\\\u0017mZ3\n\t\u0005]\u0015\u0011\u0014\u0002\n)\"\u0014xn^1cY\u0016T1!a%\u0012\u0011!\t\u0019\"!\n\u0005B\u0005UQABAP\u0001\u0001\t\tK\u0001\u0002Q\tB\u0019q)!\n\t\u0013\u0005\u0015\u0006A1A\u0005\n\u0005\u001d\u0016!\u0003:fa2L7-Y%e+\t\tI\u000bE\u0002\u0011\u0003WK1!!,\u0012\u0005\rIe\u000e\u001e\u0005\t\u0003c\u0003\u0001\u0015!\u0003\u0002*\u0006Q!/\u001a9mS\u000e\f\u0017\n\u001a\u0011\t\u0013\u0005U\u0006A1A\u0005\n\u0005]\u0016\u0001C7bq\nKH/Z:\u0016\u0005\u0005e\u0006\u0003BA\r\u0003wKA!!0\u0002\u001c\t9\u0011J\u001c;fO\u0016\u0014\b\u0002CAa\u0001\u0001\u0006I!!/\u0002\u00135\f\u0007PQ=uKN\u0004\u0003\"CAc\u0001\t\u0007I\u0011BA\\\u0003%1W\r^2i'&TX\r\u0003\u0005\u0002J\u0002\u0001\u000b\u0011BA]\u0003)1W\r^2i'&TX\r\t\u0005\b\u0003\u001b\u0004A\u0011BAh\u00035)\u0007o\\2i\u0007\u0006\u001c\u0007.Z(qiR!\u0011\u0011[Ap!\u0015\u0001\u0012qPAj!\u0011\t).a7\u000e\u0005\u0005]'bAAm\u0005\u0005)Q\r]8dQ&!\u0011Q\\Al\u0005AaU-\u00193fe\u0016\u0003xn\u00195DC\u000eDW\r\u0003\u0005\u0002b\u0006-\u0007\u0019AA\u0005\u0003\t!\b\u000fC\u0004\u0002f\u0002!\t!a:\u0002\u000b\u0019,Go\u00195\u0015\t\u0005%\u00181 \t\u0007\u0003W\f\t0!>\u000e\u0005\u00055(bAAx#\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\u0005M\u0018Q\u001e\u0002\u0004'\u0016\f\bc\u0002\t\u0002x\u0006%\u0011\u0011U\u0005\u0004\u0003s\f\"A\u0002+va2,'\u0007C\u0004\u0002~\u0006\r\b\u0019\u0001$\u0002\u0019\u0019,Go\u00195SKF,Xm\u001d;\t\u000f\t\u0005\u0001\u0001\"\u0001\u0003\u0004\u0005!\u0002O]8dKN\u001c\b+\u0019:uSRLwN\u001c#bi\u0006$\u0002B!\u0002\u0003\f\t5!\u0011\u0003\t\u0004!\t\u001d\u0011b\u0001B\u0005#\t!QK\\5u\u0011!\t9!a@A\u0002\u0005%\u0001b\u0002B\b\u0003\u007f\u0004\ra`\u0001\fM\u0016$8\r[(gMN,G\u000f\u0003\u0005\u0003\u0014\u0005}\b\u0019AAQ\u00035\u0001\u0018M\u001d;ji&|g\u000eR1uC\"9!q\u0003\u0001\u0005\u0002\te\u0011A\u00065b]\u0012dWm\u00144gg\u0016$x*\u001e;PMJ\u000bgnZ3\u0015\u0007}\u0014Y\u0002\u0003\u0005\u0002\b\tU\u0001\u0019AA\u0005\u0011\u001d\u0011y\u0002\u0001C\u0001\u0005C\t!\u0004[1oI2,\u0007+\u0019:uSRLwN\\:XSRDWI\u001d:peN$BA!\u0002\u0003$!A!Q\u0005B\u000f\u0001\u0004\u00119#\u0001\u0006qCJ$\u0018\u000e^5p]N\u0004b!!\"\u0003*\u0005%\u0011\u0002\u0002B\u0016\u00033\u0013\u0001\"\u0013;fe\u0006\u0014G.\u001a\u0005\b\u0005_\u0001A\u0011\u0001B\u0019\u0003]\u0011W/\u001b7e\u0019\u0016\fG-\u001a:Fa>\u001c\u0007NU3rk\u0016\u001cH\u000f\u0006\u0003\u00034\t}\u0002#\u0002,\u00036\te\u0012b\u0001B\u001c5\n!\"+Z:vYR<\u0016\u000e\u001e5QCJ$\u0018\u000e^5p]N\u0004\u0002\"a;\u0003<\u0005%\u0011\u0011V\u0005\u0005\u0005{\tiOA\u0002NCBD\u0001B!\u0011\u0003.\u0001\u0007!1I\u0001\u000eC2d\u0007+\u0019:uSRLwN\\:\u0011\r\u0005-\u0018\u0011\u001fB#!\u001d\u0001\u0012q_A\u0005\u0005\u000f\u00022!\u0003B%\u0013\r\u0011YE\u0001\u0002\u0014!\u0006\u0014H/\u001b;j_:4U\r^2i'R\fG/\u001a\u0005\b\u0005\u001f\u0002A\u0011\u0001B)\u0003U1W\r^2i\u000bB|7\r[:Ge>lG*Z1eKJ$BAa\u0015\u0003\\AA\u00111\u001eB\u001e\u0003\u0013\u0011)\u0006E\u0002a\u0005/J1A!\u0017b\u00059)\u0005o\\2i\u000b:$wJ\u001a4tKRD\u0001B!\n\u0003N\u0001\u0007!\u0011\b\u0005\b\u0005?\u0002A\u0011\u0001B1\u00035i\u0017-\u001f2f)J,hnY1uKR!!1\rB4!\u00151&Q\u0007B3!\u001d\tYOa\u000f\u0002\n}D\u0001B!\u001b\u0003^\u0001\u0007!1K\u0001\u000eM\u0016$8\r[3e\u000bB|7\r[:\t\u000f\t5\u0004\u0001\"\u0001\u0003p\u0005\t\"-^5mI\u001a+Go\u00195SKF,Xm\u001d;\u0015\t\tE$1\u000f\t\u0005-\nUb\t\u0003\u0005\u0003v\t-\u0004\u0019\u0001B\"\u00031\u0001\u0018M\u001d;ji&|g.T1q\u0001")
public class ReplicaAlterLogDirsThread
extends AbstractFetcherThread {
    private final KafkaConfig brokerConfig;
    public final ReplicaManager kafka$server$ReplicaAlterLogDirsThread$$replicaMgr;
    public final ReplicationQuotaManager kafka$server$ReplicaAlterLogDirsThread$$quota;
    private final int replicaId;
    private final Integer maxBytes;
    private final Integer fetchSize;

    private int replicaId() {
        return this.replicaId;
    }

    private Integer maxBytes() {
        return this.maxBytes;
    }

    private Integer fetchSize() {
        return this.fetchSize;
    }

    public Option<LeaderEpochCache> kafka$server$ReplicaAlterLogDirsThread$$epochCacheOpt(TopicPartition tp) {
        return this.kafka$server$ReplicaAlterLogDirsThread$$replicaMgr.getReplica(tp).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final LeaderEpochCache apply(Replica x$1) {
                return (LeaderEpochCache)x$1.epochs().get();
            }
        });
    }

    public Seq<Tuple2<TopicPartition, PartitionData>> fetch(FetchRequest fetchRequest) {
        ObjectRef partitionData = ObjectRef.create(null);
        org.apache.kafka.common.requests.FetchRequest request = (org.apache.kafka.common.requests.FetchRequest)fetchRequest.underlying().build();
        this.kafka$server$ReplicaAlterLogDirsThread$$replicaMgr.fetchMessages(0L, Request$.MODULE$.FutureLocalReplicaId(), request.minBytes(), request.maxBytes(), request.version() <= 2, (Seq<Tuple2<TopicPartition, FetchRequest.PartitionData>>)((MapLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(request.fetchData()).asScala()).toSeq(), QuotaFactory$UnboundedQuota$.MODULE$, (Function1<Seq<Tuple2<TopicPartition, FetchPartitionData>>, BoxedUnit>)new Serializable(this, partitionData){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ReplicaAlterLogDirsThread $outer;
            private final ObjectRef partitionData$1;

            public final void apply(Seq<Tuple2<TopicPartition, FetchPartitionData>> responsePartitionData) {
                this.$outer.kafka$server$ReplicaAlterLogDirsThread$$processResponseCallback$1(responsePartitionData, this.partitionData$1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.partitionData$1 = partitionData$1;
            }
        }, request.isolationLevel());
        if ((Seq)partitionData.elem == null) {
            throw new IllegalStateException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to fetch data for partitions ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Predef$.MODULE$.refArrayOps(request.fetchData().keySet().toArray()).mkString(",")})));
        }
        return (Seq)((Seq)partitionData.elem).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Tuple2<TopicPartition, PartitionData> apply(Tuple2<TopicPartition, FetchResponse.PartitionData> x0$2) {
                Tuple2<TopicPartition, FetchResponse.PartitionData> tuple2 = x0$2;
                if (tuple2 != null) {
                    TopicPartition key = (TopicPartition)tuple2._1();
                    FetchResponse.PartitionData value2 = (FetchResponse.PartitionData)tuple2._2();
                    Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)key), (Object)new PartitionData(value2));
                    return tuple22;
                }
                throw new MatchError(tuple2);
            }
        }, Seq$.MODULE$.canBuildFrom());
    }

    public void processPartitionData(TopicPartition topicPartition, long fetchOffset, PartitionData partitionData) {
        Replica futureReplica = this.kafka$server$ReplicaAlterLogDirsThread$$replicaMgr.getReplicaOrException(topicPartition, Request$.MODULE$.FutureLocalReplicaId());
        Partition partition = (Partition)this.kafka$server$ReplicaAlterLogDirsThread$$replicaMgr.getPartition(topicPartition).get();
        MemoryRecords records = partitionData.toRecords();
        if (fetchOffset != futureReplica.logEndOffset().messageOffset()) {
            throw new IllegalStateException(new StringOps(Predef$.MODULE$.augmentString("Offset mismatch for the future replica %s: fetched offset = %d, log end offset = %d.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topicPartition, BoxesRunTime.boxToLong((long)fetchOffset), BoxesRunTime.boxToLong((long)futureReplica.logEndOffset().messageOffset())})));
        }
        partition.appendRecordsToFollowerOrFutureReplica(records, true);
        futureReplica.highWatermark_$eq(new LogOffsetMetadata(partitionData.highWatermark(), LogOffsetMetadata$.MODULE$.$lessinit$greater$default$2(), LogOffsetMetadata$.MODULE$.$lessinit$greater$default$3()));
        futureReplica.maybeIncrementLogStartOffset(partitionData.logStartOffset());
        if (partition.maybeReplaceCurrentWithFutureReplica()) {
            this.removePartitions((Set<TopicPartition>)((Set)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{topicPartition}))));
        }
        this.kafka$server$ReplicaAlterLogDirsThread$$quota.record(records.sizeInBytes());
    }

    @Override
    public long handleOffsetOutOfRange(TopicPartition topicPartition) {
        long l;
        Replica futureReplica = this.kafka$server$ReplicaAlterLogDirsThread$$replicaMgr.getReplicaOrException(topicPartition, Request$.MODULE$.FutureLocalReplicaId());
        Replica currentReplica = this.kafka$server$ReplicaAlterLogDirsThread$$replicaMgr.getReplicaOrException(topicPartition);
        Partition partition = (Partition)this.kafka$server$ReplicaAlterLogDirsThread$$replicaMgr.getPartition(topicPartition).get();
        long logEndOffset2 = currentReplica.logEndOffset().messageOffset();
        if (logEndOffset2 < futureReplica.logEndOffset().messageOffset()) {
            this.warn((Function0<String>)new Serializable(this, topicPartition, futureReplica, logEndOffset2){
                public static final long serialVersionUID = 0L;
                private final TopicPartition topicPartition$1;
                private final Replica futureReplica$1;
                private final long logEndOffset$1;

                public final String apply() {
                    return new StringOps(Predef$.MODULE$.augmentString("Future replica for partition %s reset its fetch offset from %d to current replica's latest offset %d")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topicPartition$1, BoxesRunTime.boxToLong((long)this.futureReplica$1.logEndOffset().messageOffset()), BoxesRunTime.boxToLong((long)this.logEndOffset$1)}));
                }
                {
                    this.topicPartition$1 = topicPartition$1;
                    this.futureReplica$1 = futureReplica$1;
                    this.logEndOffset$1 = logEndOffset$1;
                }
            });
            partition.truncateTo(logEndOffset2, true);
            l = logEndOffset2;
        } else {
            long currentReplicaStartOffset = currentReplica.logStartOffset();
            this.warn((Function0<String>)new Serializable(this, topicPartition, futureReplica, currentReplicaStartOffset){
                public static final long serialVersionUID = 0L;
                private final TopicPartition topicPartition$1;
                private final Replica futureReplica$1;
                private final long currentReplicaStartOffset$1;

                public final String apply() {
                    return new StringOps(Predef$.MODULE$.augmentString("Future replica for partition %s reset its fetch offset from %d to current replica's start offset %d")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topicPartition$1, BoxesRunTime.boxToLong((long)this.futureReplica$1.logEndOffset().messageOffset()), BoxesRunTime.boxToLong((long)this.currentReplicaStartOffset$1)}));
                }
                {
                    this.topicPartition$1 = topicPartition$1;
                    this.futureReplica$1 = futureReplica$1;
                    this.currentReplicaStartOffset$1 = currentReplicaStartOffset$1;
                }
            });
            long offsetToFetch = Math.max(currentReplicaStartOffset, futureReplica.logEndOffset().messageOffset());
            if (currentReplicaStartOffset > futureReplica.logEndOffset().messageOffset()) {
                partition.truncateFullyAndStartAt(currentReplicaStartOffset, true);
            }
            l = offsetToFetch;
        }
        return l;
    }

    @Override
    public void handlePartitionsWithErrors(Iterable<TopicPartition> partitions) {
        if (partitions.nonEmpty()) {
            this.delayPartitions(partitions, Predef$.MODULE$.Integer2int(this.brokerConfig.replicaFetchBackoffMs()));
        }
    }

    @Override
    public AbstractFetcherThread.ResultWithPartitions<Map<TopicPartition, Object>> buildLeaderEpochRequest(Seq<Tuple2<TopicPartition, PartitionFetchState>> allPartitions) {
        scala.collection.immutable.Map partitionEpochOpts = ((TraversableOnce)((TraversableLike)allPartitions.filter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<TopicPartition, PartitionFetchState> x0$3) {
                Tuple2<TopicPartition, PartitionFetchState> tuple2 = x0$3;
                if (tuple2 != null) {
                    PartitionFetchState state = (PartitionFetchState)tuple2._2();
                    boolean bl = state.isTruncatingLog();
                    return bl;
                }
                throw new MatchError(tuple2);
            }
        })).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ReplicaAlterLogDirsThread $outer;

            public final Tuple2<TopicPartition, Option<LeaderEpochCache>> apply(Tuple2<TopicPartition, PartitionFetchState> x0$4) {
                Tuple2<TopicPartition, PartitionFetchState> tuple2 = x0$4;
                if (tuple2 != null) {
                    TopicPartition tp = (TopicPartition)tuple2._1();
                    Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), this.$outer.kafka$server$ReplicaAlterLogDirsThread$$epochCacheOpt(tp));
                    return tuple22;
                }
                throw new MatchError(tuple2);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        Tuple2 tuple2 = partitionEpochOpts.partition((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<TopicPartition, Option<LeaderEpochCache>> x0$5) {
                Tuple2<TopicPartition, Option<LeaderEpochCache>> tuple2 = x0$5;
                if (tuple2 != null) {
                    Option epochCacheOpt2 = (Option)tuple2._2();
                    boolean bl = epochCacheOpt2.nonEmpty();
                    return bl;
                }
                throw new MatchError(tuple2);
            }
        });
        if (tuple2 != null) {
            Tuple2 tuple22;
            scala.collection.immutable.Map partitionsWithEpoch = (scala.collection.immutable.Map)tuple2._1();
            scala.collection.immutable.Map partitionsWithoutEpoch = (scala.collection.immutable.Map)tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)partitionsWithEpoch, (Object)partitionsWithoutEpoch);
            scala.collection.immutable.Map partitionsWithEpoch2 = (scala.collection.immutable.Map)tuple23._1();
            scala.collection.immutable.Map partitionsWithoutEpoch2 = (scala.collection.immutable.Map)tuple23._2();
            scala.collection.immutable.Map result = (scala.collection.immutable.Map)partitionsWithEpoch2.map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final Tuple2<TopicPartition, Object> apply(Tuple2<TopicPartition, Option<LeaderEpochCache>> x0$6) {
                    Tuple2<TopicPartition, Option<LeaderEpochCache>> tuple2 = x0$6;
                    if (tuple2 != null) {
                        TopicPartition tp = (TopicPartition)tuple2._1();
                        Option epochCacheOpt2 = (Option)tuple2._2();
                        Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)BoxesRunTime.boxToInteger((int)((LeaderEpochCache)epochCacheOpt2.get()).latestEpoch()));
                        return tuple22;
                    }
                    throw new MatchError(tuple2);
                }
            }, scala.collection.immutable.Map$.MODULE$.canBuildFrom());
            return new AbstractFetcherThread.ResultWithPartitions<scala.collection.immutable.Map>(result, (Set<TopicPartition>)partitionsWithoutEpoch2.keys().toSet());
        }
        throw new MatchError((Object)tuple2);
    }

    @Override
    public Map<TopicPartition, EpochEndOffset> fetchEpochsFromLeader(Map<TopicPartition, Object> partitions) {
        return (Map)partitions.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ReplicaAlterLogDirsThread $outer;

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Tuple2<TopicPartition, EpochEndOffset> apply(Tuple2<TopicPartition, Object> x0$7) {
                Tuple2 tuple2;
                Tuple2<TopicPartition, Object> tuple22 = x0$7;
                if (tuple22 == null) throw new MatchError(tuple22);
                TopicPartition tp = (TopicPartition)tuple22._1();
                int epoch = tuple22._2$mcI$sp();
                try {
                    tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)new EpochEndOffset(Errors.NONE, ((LeaderEpochCache)this.$outer.kafka$server$ReplicaAlterLogDirsThread$$replicaMgr.getReplicaOrException(tp).epochs().get()).endOffsetFor(epoch)));
                    return tuple2;
                }
                catch (Throwable throwable) {
                    this.$outer.warn((Function0<String>)new Serializable(this, tp){
                        public static final long serialVersionUID = 0L;
                        private final TopicPartition tp$1;

                        public final String apply() {
                            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Error when getting EpochEndOffset for ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.tp$1}));
                        }
                        {
                            this.tp$1 = tp$1;
                        }
                    }, (Function0<Throwable>)new Serializable(this, throwable){
                        public static final long serialVersionUID = 0L;
                        private final Throwable t$1;

                        public final Throwable apply() {
                            return this.t$1;
                        }
                        {
                            this.t$1 = t$1;
                        }
                    });
                    tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)new EpochEndOffset(Errors.forException((Throwable)throwable), -1L));
                }
                return tuple2;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, Map$.MODULE$.canBuildFrom());
    }

    @Override
    public AbstractFetcherThread.ResultWithPartitions<Map<TopicPartition, Object>> maybeTruncate(Map<TopicPartition, EpochEndOffset> fetchedEpochs) {
        HashMap fetchOffsets2 = HashMap$.MODULE$.empty();
        scala.collection.mutable.Set partitionsWithError = (scala.collection.mutable.Set)scala.collection.mutable.Set$.MODULE$.apply((Seq)Nil$.MODULE$);
        fetchedEpochs.foreach((Function1)new Serializable(this, fetchOffsets2, partitionsWithError){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ReplicaAlterLogDirsThread $outer;
            private final HashMap fetchOffsets$1;
            private final scala.collection.mutable.Set partitionsWithError$1;

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object apply(Tuple2<TopicPartition, EpochEndOffset> x0$8) {
                SetLike setLike;
                Tuple2<TopicPartition, EpochEndOffset> tuple2 = x0$8;
                if (tuple2 == null) throw new MatchError(tuple2);
                TopicPartition topicPartition = (TopicPartition)tuple2._1();
                EpochEndOffset epochOffset = (EpochEndOffset)tuple2._2();
                try {
                    Replica futureReplica = this.$outer.kafka$server$ReplicaAlterLogDirsThread$$replicaMgr.getReplicaOrException(topicPartition, Request$.MODULE$.FutureLocalReplicaId());
                    Partition partition = (Partition)this.$outer.kafka$server$ReplicaAlterLogDirsThread$$replicaMgr.getPartition(topicPartition).get();
                    if (epochOffset.hasError()) {
                        this.$outer.info((Function0<String>)new Serializable(this, topicPartition, epochOffset){
                            public static final long serialVersionUID = 0L;
                            private final TopicPartition topicPartition$2;
                            private final EpochEndOffset epochOffset$1;

                            public final String apply() {
                                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Retrying leaderEpoch request for partition ", " as the current replica reported an error: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topicPartition$2, this.epochOffset$1.error()}));
                            }
                            {
                                this.topicPartition$2 = topicPartition$2;
                                this.epochOffset$1 = epochOffset$1;
                            }
                        });
                        setLike = this.partitionsWithError$1.$plus$eq((Object)topicPartition);
                        return setLike;
                    } else {
                        long fetchOffset = epochOffset.endOffset() == -1L ? ((PartitionFetchState)this.$outer.partitionStates().stateValue(topicPartition)).fetchOffset() : (epochOffset.endOffset() >= futureReplica.logEndOffset().messageOffset() ? futureReplica.logEndOffset().messageOffset() : epochOffset.endOffset());
                        partition.truncateTo(fetchOffset, true);
                        setLike = this.fetchOffsets$1.put((Object)topicPartition, (Object)BoxesRunTime.boxToLong((long)fetchOffset));
                    }
                    return setLike;
                }
                catch (KafkaStorageException kafkaStorageException) {
                    this.$outer.info((Function0<String>)new Serializable(this, topicPartition){
                        public static final long serialVersionUID = 0L;
                        private final TopicPartition topicPartition$2;

                        public final String apply() {
                            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to truncate ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topicPartition$2}));
                        }
                        {
                            this.topicPartition$2 = topicPartition$2;
                        }
                    }, (Function0<Throwable>)new Serializable(this, kafkaStorageException){
                        public static final long serialVersionUID = 0L;
                        private final KafkaStorageException e$1;

                        public final KafkaStorageException apply() {
                            return this.e$1;
                        }
                        {
                            this.e$1 = e$1;
                        }
                    });
                    setLike = this.partitionsWithError$1.$plus$eq((Object)topicPartition);
                }
                return setLike;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.fetchOffsets$1 = fetchOffsets$1;
                this.partitionsWithError$1 = partitionsWithError$1;
            }
        });
        return new AbstractFetcherThread.ResultWithPartitions<HashMap>(fetchOffsets2, (Set<TopicPartition>)partitionsWithError);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public AbstractFetcherThread.ResultWithPartitions<FetchRequest> buildFetchRequest(Seq<Tuple2<TopicPartition, PartitionFetchState>> partitionMap) {
        BoxedUnit boxedUnit;
        Option maxPartitionOpt = ((TraversableOnce)partitionMap.filter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ReplicaAlterLogDirsThread $outer;

            public final boolean apply(Tuple2<TopicPartition, PartitionFetchState> x0$9) {
                Tuple2<TopicPartition, PartitionFetchState> tuple2 = x0$9;
                if (tuple2 != null) {
                    PartitionFetchState partitionFetchState = (PartitionFetchState)tuple2._2();
                    boolean bl = partitionFetchState.isReadyForFetch() && !this.$outer.kafka$server$ReplicaAlterLogDirsThread$$quota.isQuotaExceeded();
                    return bl;
                }
                throw new MatchError(tuple2);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        })).reduceLeftOption((Function2)new Serializable(this){
            public static final long serialVersionUID = 0L;

            /*
             * Enabled aggressive block sorting
             */
            public final Tuple2<TopicPartition, PartitionFetchState> apply(Tuple2<TopicPartition, PartitionFetchState> left, Tuple2<TopicPartition, PartitionFetchState> right) {
                Tuple2<TopicPartition, PartitionFetchState> tuple2;
                block3: {
                    block2: {
                        if (new StringOps(Predef$.MODULE$.augmentString(((TopicPartition)left._1()).topic())).$greater((Object)((TopicPartition)right._1()).topic())) break block2;
                        String string = ((TopicPartition)left._1()).topic();
                        String string2 = ((TopicPartition)right._1()).topic();
                        if ((string != null ? !string.equals(string2) : string2 != null) || ((TopicPartition)left._1()).partition() < ((TopicPartition)right._1()).partition()) break block3;
                    }
                    tuple2 = left;
                    return tuple2;
                }
                tuple2 = right;
                return tuple2;
            }
        });
        LinkedHashMap<TopicPartition, FetchRequest.PartitionData> requestMap = new LinkedHashMap<TopicPartition, FetchRequest.PartitionData>();
        scala.collection.mutable.Set partitionsWithError = (scala.collection.mutable.Set)scala.collection.mutable.Set$.MODULE$.apply((Seq)Nil$.MODULE$);
        if (maxPartitionOpt.nonEmpty()) {
            Tuple2 tuple2;
            Tuple2 tuple22 = (Tuple2)maxPartitionOpt.get();
            if (tuple22 == null) {
                throw new MatchError((Object)tuple22);
            }
            TopicPartition topicPartition = (TopicPartition)tuple22._1();
            PartitionFetchState partitionFetchState = (PartitionFetchState)tuple22._2();
            Tuple2 tuple23 = tuple2 = new Tuple2((Object)topicPartition, (Object)partitionFetchState);
            TopicPartition topicPartition2 = (TopicPartition)tuple23._1();
            PartitionFetchState partitionFetchState2 = (PartitionFetchState)tuple23._2();
            try {
                long logStartOffset2 = this.kafka$server$ReplicaAlterLogDirsThread$$replicaMgr.getReplicaOrException(topicPartition2, Request$.MODULE$.FutureLocalReplicaId()).logStartOffset();
                boxedUnit = requestMap.put(topicPartition2, new FetchRequest.PartitionData(partitionFetchState2.fetchOffset(), logStartOffset2, Predef$.MODULE$.Integer2int(this.fetchSize())));
            }
            catch (KafkaStorageException kafkaStorageException) {
                boxedUnit = partitionsWithError.$plus$eq((Object)topicPartition2);
            }
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        FetchRequest.Builder requestBuilder = FetchRequest.Builder.forReplica((short)ApiKeys.FETCH.latestVersion(), (int)this.replicaId(), (int)0, (int)0, requestMap).setMaxBytes(Predef$.MODULE$.Integer2int(this.maxBytes()));
        return new AbstractFetcherThread.ResultWithPartitions<FetchRequest>(new FetchRequest(requestBuilder), (Set<TopicPartition>)partitionsWithError);
    }

    public final void kafka$server$ReplicaAlterLogDirsThread$$processResponseCallback$1(Seq responsePartitionData, ObjectRef partitionData$1) {
        partitionData$1.elem = (Seq)responsePartitionData.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Tuple2<TopicPartition, FetchResponse.PartitionData> apply(Tuple2<TopicPartition, FetchPartitionData> x0$1) {
                Tuple2<TopicPartition, FetchPartitionData> tuple2 = x0$1;
                if (tuple2 != null) {
                    TopicPartition tp = (TopicPartition)tuple2._1();
                    FetchPartitionData data = (FetchPartitionData)tuple2._2();
                    java.util.List abortedTransactions = (java.util.List)data.abortedTransactions().map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final java.util.List<FetchResponse.AbortedTransaction> apply(List<FetchResponse.AbortedTransaction> x$2) {
                            return (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(x$2).asJava();
                        }
                    }).orNull(Predef$.MODULE$.$conforms());
                    long lastStableOffset2 = BoxesRunTime.unboxToLong((Object)data.lastStableOffset().getOrElse((Function0)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final long apply() {
                            return this.apply$mcJ$sp();
                        }

                        public long apply$mcJ$sp() {
                            return -1L;
                        }
                    }));
                    Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)new FetchResponse.PartitionData(data.error(), data.highWatermark(), lastStableOffset2, data.logStartOffset(), abortedTransactions, data.records()));
                    return tuple22;
                }
                throw new MatchError(tuple2);
            }
        }, Seq$.MODULE$.canBuildFrom());
    }

    public ReplicaAlterLogDirsThread(String name, BrokerEndPoint sourceBroker, KafkaConfig brokerConfig2, ReplicaManager replicaMgr, ReplicationQuotaManager quota, BrokerTopicStats brokerTopicStats) {
        this.brokerConfig = brokerConfig2;
        this.kafka$server$ReplicaAlterLogDirsThread$$replicaMgr = replicaMgr;
        this.kafka$server$ReplicaAlterLogDirsThread$$quota = quota;
        super(name, name, sourceBroker, Predef$.MODULE$.Integer2int(brokerConfig2.replicaFetchBackoffMs()), false, true);
        this.replicaId = brokerConfig2.brokerId();
        this.maxBytes = brokerConfig2.replicaFetchResponseMaxBytes();
        this.fetchSize = brokerConfig2.replicaFetchMaxBytes();
    }

    public static class FetchRequest
    implements AbstractFetcherThread.FetchRequest {
        private final FetchRequest.Builder underlying;

        public FetchRequest.Builder underlying() {
            return this.underlying;
        }

        @Override
        public boolean isEmpty() {
            return this.underlying().fetchData().isEmpty();
        }

        @Override
        public long offset(TopicPartition topicPartition) {
            return ((FetchRequest.PartitionData)((MapLike)JavaConverters$.MODULE$.mapAsScalaMapConverter((java.util.Map)this.underlying().fetchData()).asScala()).apply((Object)topicPartition)).fetchOffset;
        }

        public String toString() {
            return this.underlying().toString();
        }

        public FetchRequest(FetchRequest.Builder underlying) {
            this.underlying = underlying;
        }
    }

    public static class PartitionData
    implements AbstractFetcherThread.PartitionData {
        private final FetchResponse.PartitionData underlying;

        public FetchResponse.PartitionData underlying() {
            return this.underlying;
        }

        @Override
        public Errors error() {
            return this.underlying().error;
        }

        @Override
        public MemoryRecords toRecords() {
            MemoryRecords memoryRecords;
            Records records = this.underlying().records;
            MemoryRecords memoryRecords2 = MemoryRecords.EMPTY;
            if (!(records != null ? !records.equals(memoryRecords2) : memoryRecords2 != null)) {
                memoryRecords = (MemoryRecords)this.underlying().records;
            } else {
                ByteBuffer buffer = ByteBuffer.allocate(this.underlying().records.sizeInBytes());
                ((FileRecords)this.underlying().records).readInto(buffer, 0);
                memoryRecords = MemoryRecords.readableRecords((ByteBuffer)buffer);
            }
            return memoryRecords;
        }

        @Override
        public long highWatermark() {
            return this.underlying().highWatermark;
        }

        public long logStartOffset() {
            return this.underlying().logStartOffset;
        }

        @Override
        public Option<Throwable> exception() {
            Errors errors = this.error();
            Object object = Errors.NONE.equals(errors) ? None$.MODULE$ : new Some((Object)errors.exception());
            return object;
        }

        public String toString() {
            return this.underlying().toString();
        }

        public PartitionData(FetchResponse.PartitionData underlying) {
            this.underlying = underlying;
        }
    }
}

