/*
 * Decompiled with CFR 0.152.
 */
package kafka.tools;

import com.typesafe.scalalogging.Logger;
import java.util.Random;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicLong;
import kafka.tools.ProducerPerformance;
import kafka.utils.Exit$;
import kafka.utils.Logging;
import kafka.utils.Logging$class;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

public final class ProducerPerformance$
implements Logging {
    public static final ProducerPerformance$ MODULE$;
    private final Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    static {
        new ProducerPerformance$();
    }

    private Logger logger$lzycompute() {
        ProducerPerformance$ producerPerformance$ = this;
        synchronized (producerPerformance$) {
            if (!this.bitmap$0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    @Override
    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    @Override
    public String loggerName() {
        return Logging$class.loggerName(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging$class.msgWithLogIdent(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging$class.trace(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.trace(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging$class.isDebugEnabled(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging$class.isTraceEnabled(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging$class.debug(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.debug(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging$class.info(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.info(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging$class.warn(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.warn(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging$class.error(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.error(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging$class.fatal(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.fatal(this, msg, e);
    }

    public void main(String[] args) {
        BoxedUnit boxedUnit;
        ProducerPerformance.ProducerPerfConfig config = new ProducerPerformance.ProducerPerfConfig(args);
        if (config.isFixedSize()) {
            boxedUnit = BoxedUnit.UNIT;
        } else if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info("WARN: Throughput will be slower due to changing message size per request");
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        AtomicLong totalBytesSent = new AtomicLong(0L);
        AtomicLong totalMessagesSent = new AtomicLong(0L);
        ExecutorService executor = Executors.newFixedThreadPool(config.numThreads());
        CountDownLatch allDone = new CountDownLatch(config.numThreads());
        long startMs = System.currentTimeMillis();
        Random rand = new Random();
        if (!config.hideHeader()) {
            Predef$.MODULE$.println((Object)"start.time, end.time, compression, message.size, batch.size, total.data.sent.in.MB, MB.sec, total.data.sent.in.nMsg, nMsg.sec");
        }
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), config.numThreads()).foreach$mVc$sp((Function1)new Serializable(config, totalBytesSent, totalMessagesSent, executor, allDone, rand){
            public static final long serialVersionUID = 0L;
            private final ProducerPerformance.ProducerPerfConfig config$1;
            private final AtomicLong totalBytesSent$1;
            private final AtomicLong totalMessagesSent$1;
            private final ExecutorService executor$1;
            private final CountDownLatch allDone$1;
            private final Random rand$1;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                this.executor$1.execute(new ProducerPerformance.ProducerThread(i, this.config$1, this.totalBytesSent$1, this.totalMessagesSent$1, this.allDone$1, this.rand$1));
            }
            {
                this.config$1 = config$1;
                this.totalBytesSent$1 = totalBytesSent$1;
                this.totalMessagesSent$1 = totalMessagesSent$1;
                this.executor$1 = executor$1;
                this.allDone$1 = allDone$1;
                this.rand$1 = rand$1;
            }
        });
        allDone.await();
        long endMs = System.currentTimeMillis();
        double elapsedSecs = (double)(endMs - startMs) / 1000.0;
        double totalMBSent = (double)totalBytesSent.get() * 1.0 / (double)0x100000;
        Predef$.MODULE$.println((Object)new StringOps(Predef$.MODULE$.augmentString("%s, %s, %d, %d, %d, %.2f, %.4f, %d, %.4f")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{config.dateFormat().format(BoxesRunTime.boxToLong((long)startMs)), config.dateFormat().format(BoxesRunTime.boxToLong((long)endMs)), BoxesRunTime.boxToInteger((int)config.compressionCodec().codec()), BoxesRunTime.boxToInteger((int)config.messageSize()), BoxesRunTime.boxToInteger((int)config.batchSize()), BoxesRunTime.boxToDouble((double)totalMBSent), BoxesRunTime.boxToDouble((double)(totalMBSent / elapsedSecs)), BoxesRunTime.boxToLong((long)totalMessagesSent.get()), BoxesRunTime.boxToDouble((double)((double)totalMessagesSent.get() / elapsedSecs))})));
        throw Exit$.MODULE$.exit(0, Exit$.MODULE$.exit$default$2());
    }

    private ProducerPerformance$() {
        MODULE$ = this;
        Logging$class.$init$(this);
    }
}

