/*
 * Decompiled with CFR 0.152.
 */
package kafka.consumer;

import java.io.Serializable;
import kafka.api.FetchRequest$;
import kafka.api.FetchRequestBuilder;
import kafka.api.FetchResponsePartitionData;
import kafka.api.OffsetRequest$;
import kafka.api.PartitionFetchInfo;
import kafka.api.Request$;
import kafka.cluster.BrokerEndPoint;
import kafka.common.ErrorMapping$;
import kafka.common.TopicAndPartition;
import kafka.consumer.ConsumerConfig;
import kafka.consumer.ConsumerFetcherManager;
import kafka.consumer.PartitionTopicInfo;
import kafka.consumer.SimpleConsumer;
import kafka.message.ByteBufferMessageSet;
import kafka.server.AbstractFetcherThread;
import kafka.server.PartitionFetchState;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.record.MemoryRecords;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.TraversableOnce;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\t\u0005b\u0001B\u0001\u0003\u0001\u001d\u0011QcQ8ogVlWM\u001d$fi\u000eDWM\u001d+ie\u0016\fGM\u0003\u0002\u0004\t\u0005A1m\u001c8tk6,'OC\u0001\u0006\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019\"\u0001\u0001\u0005\u0011\u0005%aQ\"\u0001\u0006\u000b\u0005-!\u0011AB:feZ,'/\u0003\u0002\u000e\u0015\t)\u0012IY:ue\u0006\u001cGOR3uG\",'\u000f\u00165sK\u0006$\u0007\u0002C\b\u0001\u0005\u0003\u0005\u000b\u0011\u0002\t\u0002\t9\fW.\u001a\t\u0003#iq!A\u0005\r\u0011\u0005M1R\"\u0001\u000b\u000b\u0005U1\u0011A\u0002\u001fs_>$hHC\u0001\u0018\u0003\u0015\u00198-\u00197b\u0013\tIb#\u0001\u0004Qe\u0016$WMZ\u0005\u00037q\u0011aa\u0015;sS:<'BA\r\u0017\u0011!q\u0002A!b\u0001\n\u0003y\u0012AB2p]\u001aLw-F\u0001!!\t\t#%D\u0001\u0003\u0013\t\u0019#A\u0001\bD_:\u001cX/\\3s\u0007>tg-[4\t\u0011\u0015\u0002!\u0011!Q\u0001\n\u0001\nqaY8oM&<\u0007\u0005\u0003\u0005(\u0001\t\u0005\t\u0015!\u0003)\u00031\u0019x.\u001e:dK\n\u0013xn[3s!\tIC&D\u0001+\u0015\tYC!A\u0004dYV\u001cH/\u001a:\n\u00055R#A\u0004\"s_.,'/\u00128e!>Lg\u000e\u001e\u0005\t_\u0001\u0011\t\u0011)A\u0005a\u0005a\u0001/\u0019:uSRLwN\\'baB!\u0011\u0007\u000e\u001cB\u001b\u0005\u0011$BA\u001a\u0017\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0003kI\u00121!T1q!\t9t(D\u00019\u0015\tI$(\u0001\u0004d_6lwN\u001c\u0006\u0003\u000bmR!\u0001P\u001f\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005q\u0014aA8sO&\u0011\u0001\t\u000f\u0002\u000f)>\u0004\u0018n\u0019)beRLG/[8o!\t\t#)\u0003\u0002D\u0005\t\u0011\u0002+\u0019:uSRLwN\u001c+pa&\u001c\u0017J\u001c4p\u0011!)\u0005A!b\u0001\n\u00031\u0015AF2p]N,X.\u001a:GKR\u001c\u0007.\u001a:NC:\fw-\u001a:\u0016\u0003\u001d\u0003\"!\t%\n\u0005%\u0013!AF\"p]N,X.\u001a:GKR\u001c\u0007.\u001a:NC:\fw-\u001a:\t\u0011-\u0003!\u0011!Q\u0001\n\u001d\u000bqcY8ogVlWM\u001d$fi\u000eDWM]'b]\u0006<WM\u001d\u0011\t\u000b5\u0003A\u0011\u0001(\u0002\rqJg.\u001b;?)\u0019y\u0005+\u0015*T)B\u0011\u0011\u0005\u0001\u0005\u0006\u001f1\u0003\r\u0001\u0005\u0005\u0006=1\u0003\r\u0001\t\u0005\u0006O1\u0003\r\u0001\u000b\u0005\u0006_1\u0003\r\u0001\r\u0005\u0006\u000b2\u0003\raR\u0003\u0005-\u0002\u0001qKA\u0002S\u000bF\u0003\"\u0001\u00173\u000f\u0005\u0005Jv!\u0002.\u0003\u0011\u0003Y\u0016!F\"p]N,X.\u001a:GKR\u001c\u0007.\u001a:UQJ,\u0017\r\u001a\t\u0003Cq3Q!\u0001\u0002\t\u0002u\u001b\"\u0001\u00180\u0011\u0005}\u0003W\"\u0001\f\n\u0005\u00054\"AB!osJ+g\rC\u0003N9\u0012\u00051\rF\u0001\\\r\u0011)G\f\u00014\u0003\u0019\u0019+Go\u00195SKF,Xm\u001d;\u0014\u0007\u0011tv\r\u0005\u0002iW:\u0011\u0011\"[\u0005\u0003U*\tQ#\u00112tiJ\f7\r\u001e$fi\u000eDWM\u001d+ie\u0016\fG-\u0003\u0002fY*\u0011!N\u0003\u0005\t]\u0012\u0014)\u0019!C\u0001_\u0006QQO\u001c3fe2L\u0018N\\4\u0016\u0003A\u0004\"!\u001d;\u000e\u0003IT!a\u001d\u0003\u0002\u0007\u0005\u0004\u0018.\u0003\u0002fe\"Aa\u000f\u001aB\u0001B\u0003%\u0001/A\u0006v]\u0012,'\u000f\\=j]\u001e\u0004\u0003\"B'e\t\u0003AHCA=|!\tQH-D\u0001]\u0011\u0015qw\u000f1\u0001q\u0011!iH\r#b\u0001\n\u0013q\u0018A\u0003;q)>|eMZ:fiV\tq\u0010E\u00032iY\n\t\u0001E\u0002`\u0003\u0007I1!!\u0002\u0017\u0005\u0011auN\\4\t\u000f\u0005%A\r\"\u0001\u0002\f\u00059\u0011n]#naRLXCAA\u0007!\ry\u0016qB\u0005\u0004\u0003#1\"a\u0002\"p_2,\u0017M\u001c\u0005\b\u0003+!G\u0011AA\f\u0003\u0019ygMZ:fiR!\u0011\u0011AA\r\u0011\u001d\tY\"a\u0005A\u0002Y\na\u0002^8qS\u000e\u0004\u0016M\u001d;ji&|gN\u0002\u0004\u0002 q\u0003\u0011\u0011\u0005\u0002\u000e!\u0006\u0014H/\u001b;j_:$\u0015\r^1\u0014\u000b\u0005ua,a\t\u0011\u0007!\f)#C\u0002\u0002 1D!B\\A\u000f\u0005\u000b\u0007I\u0011AA\u0015+\t\tY\u0003E\u0002r\u0003[I1!a\fs\u0005i1U\r^2i%\u0016\u001c\bo\u001c8tKB\u000b'\u000f^5uS>tG)\u0019;b\u0011)1\u0018Q\u0004B\u0001B\u0003%\u00111\u0006\u0005\b\u001b\u0006uA\u0011AA\u001b)\u0011\t9$!\u000f\u0011\u0007i\fi\u0002C\u0004o\u0003g\u0001\r!a\u000b\t\u0011\u0005u\u0012Q\u0004C\u0001\u0003\u007f\t\u0011\"\u001a:s_J\u001cu\u000eZ3\u0016\u0005\u0005\u0005\u0003cA0\u0002D%\u0019\u0011Q\t\f\u0003\u000bMCwN\u001d;\t\u0011\u0005%\u0013Q\u0004C\u0001\u0003\u0017\n\u0011\u0002^8SK\u000e|'\u000fZ:\u0016\u0005\u00055\u0003\u0003BA(\u0003+j!!!\u0015\u000b\u0007\u0005M\u0003(\u0001\u0004sK\u000e|'\u000fZ\u0005\u0005\u0003/\n\tFA\u0007NK6|'/\u001f*fG>\u0014Hm\u001d\u0005\t\u00037\ni\u0002\"\u0001\u0002^\u0005i\u0001.[4i/\u0006$XM]7be.,\"!!\u0001\t\u0011\u0005\u0005\u0014Q\u0004C\u0001\u0003G\n\u0011\"\u001a=dKB$\u0018n\u001c8\u0016\u0005\u0005\u0015\u0004#B0\u0002h\u0005-\u0014bAA5-\t1q\n\u001d;j_:\u0004B!!\u001c\u0002x9!\u0011qNA:\u001d\r\u0019\u0012\u0011O\u0005\u0002/%\u0019\u0011Q\u000f\f\u0002\u000fA\f7m[1hK&!\u0011\u0011PA>\u0005%!\u0006N]8xC\ndWMC\u0002\u0002vY)a!a \u0001\u0001\u0005\u0005%A\u0001)E!\rA\u0016Q\u0004\u0005\n\u0003\u000b\u0003!\u0019!C\u0005\u0003\u000f\u000b\u0001b\u00197jK:$\u0018\nZ\u000b\u0002!!9\u00111\u0012\u0001!\u0002\u0013\u0001\u0012!C2mS\u0016tG/\u00133!\u0011%\ty\t\u0001b\u0001\n\u0013\t\t*A\u0005gKR\u001c\u0007nU5{KV\u0011\u00111\u0013\t\u0004?\u0006U\u0015bAAL-\t\u0019\u0011J\u001c;\t\u0011\u0005m\u0005\u0001)A\u0005\u0003'\u000b!BZ3uG\"\u001c\u0016N_3!\u0011%\ty\n\u0001b\u0001\n\u0013\t\t+\u0001\btS6\u0004H.Z\"p]N,X.\u001a:\u0016\u0005\u0005\r\u0006cA\u0011\u0002&&\u0019\u0011q\u0015\u0002\u0003\u001dMKW\u000e\u001d7f\u0007>t7/^7fe\"A\u00111\u0016\u0001!\u0002\u0013\t\u0019+A\btS6\u0004H.Z\"p]N,X.\u001a:!\u0011%\ty\u000b\u0001b\u0001\n\u0013\t\t,A\ngKR\u001c\u0007NU3rk\u0016\u001cHOQ;jY\u0012,'/\u0006\u0002\u00024B\u0019\u0011/!.\n\u0007\u0005]&OA\nGKR\u001c\u0007NU3rk\u0016\u001cHOQ;jY\u0012,'\u000f\u0003\u0005\u0002<\u0002\u0001\u000b\u0011BAZ\u0003Q1W\r^2i%\u0016\fX/Z:u\u0005VLG\u000eZ3sA!9\u0011q\u0018\u0001\u0005B\u0005\u0005\u0017\u0001E5oSRL\u0017\r^3TQV$Hm\\<o)\t\ti\u0001C\u0004\u0002F\u0002!\t%a2\u0002\u0011MDW\u000f\u001e3po:$\"!!3\u0011\u0007}\u000bY-C\u0002\u0002NZ\u0011A!\u00168ji\"9\u0011\u0011\u001b\u0001\u0005\u0002\u0005M\u0017\u0001\u00069s_\u000e,7o\u001d)beRLG/[8o\t\u0006$\u0018\r\u0006\u0005\u0002J\u0006U\u0017q[An\u0011\u001d\tY\"a4A\u0002YB\u0001\"!7\u0002P\u0002\u0007\u0011\u0011A\u0001\fM\u0016$8\r[(gMN,G\u000f\u0003\u0005\u0002^\u0006=\u0007\u0019AAA\u00035\u0001\u0018M\u001d;ji&|g\u000eR1uC\"9\u0011\u0011\u001d\u0001\u0005\u0002\u0005\r\u0018A\u00065b]\u0012dWm\u00144gg\u0016$x*\u001e;PMJ\u000bgnZ3\u0015\t\u0005\u0005\u0011Q\u001d\u0005\b\u00037\ty\u000e1\u00017\u0011\u001d\tI\u000f\u0001C\u0001\u0003W\f!\u0004[1oI2,\u0007+\u0019:uSRLwN\\:XSRDWI\u001d:peN$B!!3\u0002n\"A\u0011q^At\u0001\u0004\t\t0\u0001\u0006qCJ$\u0018\u000e^5p]N\u0004R!!\u001c\u0002tZJA!!>\u0002|\tA\u0011\n^3sC\ndW\rC\u0004\u0002z\u0002!\t\"a?\u0002#\t,\u0018\u000e\u001c3GKR\u001c\u0007NU3rk\u0016\u001cH\u000fF\u0002X\u0003{DqaLA|\u0001\u0004\ty\u0010E\u00032\u0005\u0003\u0011)!C\u0002\u0003\u0004I\u00121aU3r!\u0019y&q\u0001\u001c\u0003\f%\u0019!\u0011\u0002\f\u0003\rQ+\b\u000f\\33!\rI!QB\u0005\u0004\u0005\u001fQ!a\u0005)beRLG/[8o\r\u0016$8\r[*uCR,\u0007b\u0002B\n\u0001\u0011E!QC\u0001\u0006M\u0016$8\r\u001b\u000b\u0005\u0005/\u0011i\u0002\u0005\u0004\u0002n\te!1D\u0005\u0005\u0005\u0007\tY\b\u0005\u0004`\u0005\u000f1\u0014\u0011\u0011\u0005\b\u0005?\u0011\t\u00021\u0001X\u000311W\r^2i%\u0016\fX/Z:u\u0001")
public class ConsumerFetcherThread
extends AbstractFetcherThread {
    private final ConsumerConfig config;
    private final Map<TopicPartition, PartitionTopicInfo> partitionMap;
    private final ConsumerFetcherManager consumerFetcherManager;
    private final String clientId;
    private final int fetchSize;
    private final SimpleConsumer simpleConsumer;
    private final FetchRequestBuilder fetchRequestBuilder;

    public ConsumerConfig config() {
        return this.config;
    }

    public ConsumerFetcherManager consumerFetcherManager() {
        return this.consumerFetcherManager;
    }

    private String clientId() {
        return this.clientId;
    }

    private int fetchSize() {
        return this.fetchSize;
    }

    private SimpleConsumer simpleConsumer() {
        return this.simpleConsumer;
    }

    private FetchRequestBuilder fetchRequestBuilder() {
        return this.fetchRequestBuilder;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean initiateShutdown() {
        void var1_1;
        block0: {
            boolean justShutdown = super.initiateShutdown();
            if (!justShutdown || !this.isInterruptible()) break block0;
            this.simpleConsumer().disconnectToHandleJavaIOBug();
        }
        return (boolean)var1_1;
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.simpleConsumer().close();
    }

    public void processPartitionData(TopicPartition topicPartition, long fetchOffset, PartitionData partitionData) {
        PartitionTopicInfo pti = (PartitionTopicInfo)this.partitionMap.apply((Object)topicPartition);
        if (pti.getFetchOffset() != fetchOffset) {
            throw new RuntimeException(new StringOps(Predef$.MODULE$.augmentString("Offset doesn't match for partition [%s,%d] pti offset: %d fetch offset: %d")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topicPartition.topic(), BoxesRunTime.boxToInteger((int)topicPartition.partition()), BoxesRunTime.boxToLong((long)pti.getFetchOffset()), BoxesRunTime.boxToLong((long)fetchOffset)})));
        }
        pti.enqueue((ByteBufferMessageSet)partitionData.underlying().messages());
    }

    @Override
    public long handleOffsetOutOfRange(TopicPartition topicPartition) {
        long l;
        String string = this.config().autoOffsetReset();
        String string2 = OffsetRequest$.MODULE$.SmallestTimeString();
        String string3 = string;
        if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
            l = OffsetRequest$.MODULE$.EarliestTime();
        } else {
            String string4 = OffsetRequest$.MODULE$.LargestTimeString();
            String string5 = string;
            l = !(string4 != null ? !string4.equals(string5) : string5 != null) ? OffsetRequest$.MODULE$.LatestTime() : OffsetRequest$.MODULE$.LatestTime();
        }
        long startTimestamp = l;
        TopicAndPartition topicAndPartition = new TopicAndPartition(topicPartition.topic(), topicPartition.partition());
        long newOffset = this.simpleConsumer().earliestOrLatestOffset(topicAndPartition, startTimestamp, Request$.MODULE$.OrdinaryConsumerId());
        PartitionTopicInfo pti = (PartitionTopicInfo)this.partitionMap.apply((Object)topicPartition);
        pti.resetFetchOffset(newOffset);
        pti.resetConsumeOffset(newOffset);
        return newOffset;
    }

    @Override
    public void handlePartitionsWithErrors(Iterable<TopicPartition> partitions) {
        this.removePartitions((Set<TopicPartition>)partitions.toSet());
        this.consumerFetcherManager().addPartitionsWithError(partitions);
    }

    @Override
    public FetchRequest buildFetchRequest(Seq<Tuple2<TopicPartition, PartitionFetchState>> partitionMap) {
        partitionMap.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            TopicPartition topicPartition = (TopicPartition)tuple2._1();
            PartitionFetchState partitionFetchState = (PartitionFetchState)tuple2._2();
            BoxedUnit boxedUnit = partitionFetchState.isActive() ? this.fetchRequestBuilder().addFetch(topicPartition.topic(), topicPartition.partition(), partitionFetchState.offset(), this.fetchSize()) : BoxedUnit.UNIT;
            return boxedUnit;
        });
        return new FetchRequest(this.fetchRequestBuilder().build());
    }

    public Seq<Tuple2<TopicPartition, PartitionData>> fetch(FetchRequest fetchRequest) {
        return (Seq)this.simpleConsumer().fetch(fetchRequest.underlying()).data().map((Function1 & Serializable & scala.Serializable)x0$2 -> {
            FetchResponsePartitionData value;
            TopicAndPartition topicAndPartition;
            block3: {
                Tuple2 tuple2;
                block2: {
                    tuple2 = x0$2;
                    if (tuple2 == null) break block2;
                    topicAndPartition = (TopicAndPartition)tuple2._1();
                    value = (FetchResponsePartitionData)tuple2._2();
                    if (topicAndPartition != null) break block3;
                }
                throw new MatchError((Object)tuple2);
            }
            String t = topicAndPartition.topic();
            int p = topicAndPartition.partition();
            Tuple2 tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition(t, p)), (Object)new PartitionData(value));
            return tuple2;
        }, Seq$.MODULE$.canBuildFrom());
    }

    public ConsumerFetcherThread(String name, ConsumerConfig config, BrokerEndPoint sourceBroker, Map<TopicPartition, PartitionTopicInfo> partitionMap, ConsumerFetcherManager consumerFetcherManager) {
        this.config = config;
        this.partitionMap = partitionMap;
        this.consumerFetcherManager = consumerFetcherManager;
        super(name, config.clientId(), sourceBroker, config.refreshLeaderBackoffMs(), true);
        this.clientId = config.clientId();
        this.fetchSize = config.fetchMessageMaxBytes();
        this.simpleConsumer = new SimpleConsumer(sourceBroker.host(), sourceBroker.port(), config.socketTimeoutMs(), config.socketReceiveBufferBytes(), config.clientId());
        this.fetchRequestBuilder = new FetchRequestBuilder().clientId(this.clientId()).replicaId(Request$.MODULE$.OrdinaryConsumerId()).maxWait(config.fetchWaitMaxMs()).minBytes(config.fetchMinBytes()).requestVersion(FetchRequest$.MODULE$.CurrentVersion());
    }

    public static class FetchRequest
    implements AbstractFetcherThread.FetchRequest {
        private Map<TopicPartition, Object> tpToOffset;
        private final kafka.api.FetchRequest underlying;
        private volatile boolean bitmap$0;

        public kafka.api.FetchRequest underlying() {
            return this.underlying;
        }

        private Map<TopicPartition, Object> tpToOffset$lzycompute() {
            FetchRequest fetchRequest = this;
            synchronized (fetchRequest) {
                if (!this.bitmap$0) {
                    this.tpToOffset = ((TraversableOnce)this.underlying().requestInfo().map((Function1 & Serializable & scala.Serializable)x0$3 -> {
                        Tuple2 tuple2 = x0$3;
                        if (tuple2 == null) {
                            throw new MatchError((Object)tuple2);
                        }
                        TopicAndPartition tp = (TopicAndPartition)tuple2._1();
                        PartitionFetchInfo fetchInfo = (PartitionFetchInfo)tuple2._2();
                        Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition(tp.topic(), tp.partition())), (Object)BoxesRunTime.boxToLong((long)fetchInfo.offset()));
                        return tuple22;
                    }, Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
                    this.bitmap$0 = true;
                }
            }
            return this.tpToOffset;
        }

        private Map<TopicPartition, Object> tpToOffset() {
            return !this.bitmap$0 ? this.tpToOffset$lzycompute() : this.tpToOffset;
        }

        @Override
        public boolean isEmpty() {
            return this.underlying().requestInfo().isEmpty();
        }

        @Override
        public long offset(TopicPartition topicPartition) {
            return BoxesRunTime.unboxToLong((Object)this.tpToOffset().apply((Object)topicPartition));
        }

        public FetchRequest(kafka.api.FetchRequest underlying) {
            this.underlying = underlying;
        }
    }

    public static class PartitionData
    implements AbstractFetcherThread.PartitionData {
        private final FetchResponsePartitionData underlying;

        public FetchResponsePartitionData underlying() {
            return this.underlying;
        }

        @Override
        public short errorCode() {
            return this.underlying().error();
        }

        @Override
        public MemoryRecords toRecords() {
            return ((ByteBufferMessageSet)this.underlying().messages()).asRecords();
        }

        @Override
        public long highWatermark() {
            return this.underlying().hw();
        }

        @Override
        public Option<Throwable> exception() {
            return this.errorCode() == ErrorMapping$.MODULE$.NoError() ? None$.MODULE$ : new Some((Object)ErrorMapping$.MODULE$.exceptionFor(this.errorCode()));
        }

        public PartitionData(FetchResponsePartitionData underlying) {
            this.underlying = underlying;
        }
    }
}

