/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import java.io.File;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Date;
import kafka.common.LogCleaningAbortedException;
import kafka.log.CleanerStats;
import kafka.log.CleanerStats$;
import kafka.log.Log;
import kafka.log.Log$;
import kafka.log.LogCleaner;
import kafka.log.LogSegment;
import kafka.log.LogToClean;
import kafka.log.OffsetIndex;
import kafka.log.OffsetMap;
import kafka.log.TimeIndex;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.Throttler;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.record.FileRecords;
import org.apache.kafka.common.record.LogEntry;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.Record;
import org.apache.kafka.common.utils.Time;
import org.apache.log4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Buffer;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.java8.JFunction0;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@ScalaSignature(bytes="\u0006\u0001\u0005Uh!B\u0001\u0003\u0001\t1!aB\"mK\u0006tWM\u001d\u0006\u0003\u0007\u0011\t1\u0001\\8h\u0015\u0005)\u0011!B6bM.\f7c\u0001\u0001\b\u001bA\u0011\u0001bC\u0007\u0002\u0013)\t!\"A\u0003tG\u0006d\u0017-\u0003\u0002\r\u0013\t1\u0011I\\=SK\u001a\u0004\"AD\t\u000e\u0003=Q!\u0001\u0005\u0003\u0002\u000bU$\u0018\u000e\\:\n\u0005Iy!a\u0002'pO\u001eLgn\u001a\u0005\t)\u0001\u0011)\u0019!C\u0001-\u0005\u0011\u0011\u000eZ\u0002\u0001+\u00059\u0002C\u0001\u0005\u0019\u0013\tI\u0012BA\u0002J]RD\u0001b\u0007\u0001\u0003\u0002\u0003\u0006IaF\u0001\u0004S\u0012\u0004\u0003\u0002C\u000f\u0001\u0005\u000b\u0007I\u0011\u0001\u0010\u0002\u0013=4gm]3u\u001b\u0006\u0004X#A\u0010\u0011\u0005\u0001\nS\"\u0001\u0002\n\u0005\t\u0012!!C(gMN,G/T1q\u0011!!\u0003A!A!\u0002\u0013y\u0012AC8gMN,G/T1qA!Aa\u0005\u0001B\u0001B\u0003%q#\u0001\u0007j_\n+hMZ3s'&TX\r\u0003\u0005)\u0001\t\u0005\t\u0015!\u0003\u0018\u0003=i\u0017\r_%p\u0005V4g-\u001a:TSj,\u0007\u0002\u0003\u0016\u0001\u0005\u0003\u0005\u000b\u0011B\u0016\u0002'\u0011,\bOQ;gM\u0016\u0014Hj\\1e\r\u0006\u001cGo\u001c:\u0011\u0005!a\u0013BA\u0017\n\u0005\u0019!u.\u001e2mK\"Aq\u0006\u0001B\u0001B\u0003%\u0001'A\u0005uQJ|G\u000f\u001e7feB\u0011a\"M\u0005\u0003e=\u0011\u0011\u0002\u00165s_R$H.\u001a:\t\u0011Q\u0002!\u0011!Q\u0001\nU\nA\u0001^5nKB\u0011agP\u0007\u0002o)\u0011\u0001\u0003\u000f\u0006\u0003si\naaY8n[>t'BA\u0003<\u0015\taT(\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002}\u0005\u0019qN]4\n\u0005\u0001;$\u0001\u0002+j[\u0016D\u0001B\u0011\u0001\u0003\u0002\u0003\u0006IaQ\u0001\nG\",7m\u001b#p]\u0016\u0004B\u0001\u0003#G\u0015&\u0011Q)\u0003\u0002\n\rVt7\r^5p]F\u0002\"a\u0012%\u000e\u0003aJ!!\u0013\u001d\u0003\u001dQ{\u0007/[2QCJ$\u0018\u000e^5p]B\u0011\u0001bS\u0005\u0003\u0019&\u0011A!\u00168ji\")a\n\u0001C\u0001\u001f\u00061A(\u001b8jiz\"\u0012\u0002U)S'R+fk\u0016-\u0011\u0005\u0001\u0002\u0001\"\u0002\u000bN\u0001\u00049\u0002\"B\u000fN\u0001\u0004y\u0002\"\u0002\u0014N\u0001\u00049\u0002\"\u0002\u0015N\u0001\u00049\u0002\"\u0002\u0016N\u0001\u0004Y\u0003\"B\u0018N\u0001\u0004\u0001\u0004\"\u0002\u001bN\u0001\u0004)\u0004\"\u0002\"N\u0001\u0004\u0019\u0005b\u0002.\u0001\u0005\u0004%\teW\u0001\u000bY><w-\u001a:OC6,W#\u0001/\u0011\u0005u\u0013W\"\u00010\u000b\u0005}\u0003\u0017\u0001\u00027b]\u001eT\u0011!Y\u0001\u0005U\u00064\u0018-\u0003\u0002d=\n11\u000b\u001e:j]\u001eDa!\u001a\u0001!\u0002\u0013a\u0016a\u00037pO\u001e,'OT1nK\u0002Bqa\u001a\u0001A\u0002\u0013%\u0001.\u0001\u0006sK\u0006$')\u001e4gKJ,\u0012!\u001b\t\u0003U6l\u0011a\u001b\u0006\u0003Y\u0002\f1A\\5p\u0013\tq7N\u0001\u0006CsR,')\u001e4gKJDq\u0001\u001d\u0001A\u0002\u0013%\u0011/\u0001\bsK\u0006$')\u001e4gKJ|F%Z9\u0015\u0005)\u0013\bbB:p\u0003\u0003\u0005\r![\u0001\u0004q\u0012\n\u0004BB;\u0001A\u0003&\u0011.A\u0006sK\u0006$')\u001e4gKJ\u0004\u0003bB<\u0001\u0001\u0004%I\u0001[\u0001\foJLG/\u001a\"vM\u001a,'\u000fC\u0004z\u0001\u0001\u0007I\u0011\u0002>\u0002\u001f]\u0014\u0018\u000e^3Ck\u001a4WM]0%KF$\"AS>\t\u000fMD\u0018\u0011!a\u0001S\"1Q\u0010\u0001Q!\n%\fAb\u001e:ji\u0016\u0014UO\u001a4fe\u0002Bqa \u0001\u0005\u0002\t\t\t!A\u0003dY\u0016\fg\u000e\u0006\u0003\u0002\u0004\u0005U\u0001c\u0002\u0005\u0002\u0006\u0005%\u0011qB\u0005\u0004\u0003\u000fI!A\u0002+va2,'\u0007E\u0002\t\u0003\u0017I1!!\u0004\n\u0005\u0011auN\\4\u0011\u0007\u0001\n\t\"C\u0002\u0002\u0014\t\u0011Ab\u00117fC:,'o\u0015;biNDq!a\u0006\u007f\u0001\u0004\tI\"A\u0005dY\u0016\fg.\u00192mKB\u0019\u0001%a\u0007\n\u0007\u0005u!A\u0001\u0006M_\u001e$vn\u00117fC:D\u0001\"!\t\u0001\t\u0003\u0011\u00111E\u0001\u000eG2,\u0017M\\*fO6,g\u000e^:\u0015\u0017)\u000b)#!\f\u0002D\u0005\u001d\u00131\n\u0005\b\u0007\u0005}\u0001\u0019AA\u0014!\r\u0001\u0013\u0011F\u0005\u0004\u0003W\u0011!a\u0001'pO\"A\u0011qFA\u0010\u0001\u0004\t\t$\u0001\u0005tK\u001elWM\u001c;t!\u0019\t\u0019$!\u000f\u0002>5\u0011\u0011Q\u0007\u0006\u0004\u0003oI\u0011AC2pY2,7\r^5p]&!\u00111HA\u001b\u0005\r\u0019V-\u001d\t\u0004A\u0005}\u0012bAA!\u0005\tQAj\\4TK\u001elWM\u001c;\t\u000f\u0005\u0015\u0013q\u0004a\u0001?\u0005\u0019Q.\u00199\t\u0011\u0005%\u0013q\u0004a\u0001\u0003\u0013\tq\u0002Z3mKR,\u0007j\u001c:ju>tWj\u001d\u0005\t\u0003\u001b\ny\u00021\u0001\u0002\u0010\u0005)1\u000f^1ug\"A\u0011\u0011\u000b\u0001\u0005\u0002\t\t\u0019&A\u0005dY\u0016\fg.\u00138u_Ry!*!\u0016\u0002Z\u0005u\u0013\u0011MA2\u0003[\n\t\bC\u0004\u0002X\u0005=\u0003\u0019\u0001$\u0002\u001dQ|\u0007/[2QCJ$\u0018\u000e^5p]\"A\u00111LA(\u0001\u0004\ti$\u0001\u0004t_V\u00148-\u001a\u0005\t\u0003?\ny\u00051\u0001\u0002>\u0005!A-Z:u\u0011\u001d\t)%a\u0014A\u0002}A\u0001\"!\u001a\u0002P\u0001\u0007\u0011qM\u0001\u000ee\u0016$\u0018-\u001b8EK2,G/Z:\u0011\u0007!\tI'C\u0002\u0002l%\u0011qAQ8pY\u0016\fg\u000eC\u0004\u0002p\u0005=\u0003\u0019A\f\u0002#5\f\u0007\u0010T8h\u001b\u0016\u001c8/Y4f'&TX\r\u0003\u0005\u0002N\u0005=\u0003\u0019AA\b\u0011\u001d\t)\b\u0001C\u0005\u0003o\n1c\u001d5pk2$'+\u001a;bS:lUm]:bO\u0016$B\"a\u001a\u0002z\u0005m\u0014QPA@\u0003\u001fC\u0001\"a\u0017\u0002t\u0001\u0007\u0011Q\b\u0005\b\u0003\u000b\n\u0019\b1\u0001 \u0011!\t)'a\u001dA\u0002\u0005\u001d\u0004\u0002CAA\u0003g\u0002\r!a!\u0002\u000b\u0015tGO]=\u0011\t\u0005\u0015\u00151R\u0007\u0003\u0003\u000fS1!!#9\u0003\u0019\u0011XmY8sI&!\u0011QRAD\u0005!aunZ#oiJL\b\u0002CA'\u0003g\u0002\r!a\u0004\t\u000f\u0005M\u0005\u0001\"\u0001\u0002\u0016\u0006YqM]8x\u0005V4g-\u001a:t)\rQ\u0015q\u0013\u0005\b\u0003_\n\t\n1\u0001\u0018\u0011\u001d\tY\n\u0001C\u0001\u0003;\u000baB]3ti>\u0014XMQ;gM\u0016\u00148\u000fF\u0001K\u0011!\t\t\u000b\u0001C\u0001\u0005\u0005\r\u0016aE4s_V\u00048+Z4nK:$8OQ=TSj,G\u0003CAS\u0003{\u000b)-!3\u0011\r\u0005\u001d\u0016qWA\u0019\u001d\u0011\tI+a-\u000f\t\u0005-\u0016\u0011W\u0007\u0003\u0003[S1!a,\u0016\u0003\u0019a$o\\8u}%\t!\"C\u0002\u00026&\tq\u0001]1dW\u0006<W-\u0003\u0003\u0002:\u0006m&\u0001\u0002'jgRT1!!.\n\u0011!\ty#a(A\u0002\u0005}\u0006CBA\u001a\u0003\u0003\fi$\u0003\u0003\u0002D\u0006U\"\u0001C%uKJ\f'\r\\3\t\u000f\u0005\u001d\u0017q\u0014a\u0001/\u00059Q.\u0019=TSj,\u0007bBAf\u0003?\u0003\raF\u0001\r[\u0006D\u0018J\u001c3fqNK'0\u001a\u0005\t\u0003\u001f\u0004A\u0011\u0001\u0002\u0002R\u0006q!-^5mI>3gm]3u\u001b\u0006\u0004Hc\u0003&\u0002T\u0006U\u0017\u0011\\Ao\u0003?DqaAAg\u0001\u0004\t9\u0003\u0003\u0005\u0002X\u00065\u0007\u0019AA\u0005\u0003\u0015\u0019H/\u0019:u\u0011!\tY.!4A\u0002\u0005%\u0011aA3oI\"9\u0011QIAg\u0001\u0004y\u0002\u0002CA'\u0003\u001b\u0004\r!a\u0004\t\u000f\u0005\r\b\u0001\"\u0003\u0002f\u0006A\"-^5mI>3gm]3u\u001b\u0006\u0004hi\u001c:TK\u001elWM\u001c;\u0015\u001d\u0005\u001d\u0014q]Au\u0003[\fy/!=\u0002t\"9\u0011qKAq\u0001\u00041\u0005\u0002CAv\u0003C\u0004\r!!\u0010\u0002\u000fM,w-\\3oi\"9\u0011QIAq\u0001\u0004y\u0002\u0002CAl\u0003C\u0004\r!!\u0003\t\u000f\u0005=\u0014\u0011\u001da\u0001/!A\u0011QJAq\u0001\u0004\ty\u0001")
public class Cleaner
implements Logging {
    private final int id;
    private final OffsetMap offsetMap;
    private final int ioBufferSize;
    private final int maxIoBufferSize;
    private final double dupBufferLoadFactor;
    private final Throttler throttler;
    private final Time time;
    private final Function1<TopicPartition, BoxedUnit> checkDone;
    private final String loggerName;
    private ByteBuffer readBuffer;
    private ByteBuffer writeBuffer;
    private Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    private volatile boolean bitmap$0;

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public Object trace(Function0<Throwable> e) {
        return Logging.trace$(this, e);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public void swallowTrace(Function0<BoxedUnit> action) {
        Logging.swallowTrace$(this, action);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public Object debug(Function0<Throwable> e) {
        return Logging.debug$(this, e);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void swallowDebug(Function0<BoxedUnit> action) {
        Logging.swallowDebug$(this, action);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public Object info(Function0<Throwable> e) {
        return Logging.info$(this, e);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void swallowInfo(Function0<BoxedUnit> action) {
        Logging.swallowInfo$(this, action);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public Object warn(Function0<Throwable> e) {
        return Logging.warn$(this, e);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void swallowWarn(Function0<BoxedUnit> action) {
        Logging.swallowWarn$(this, action);
    }

    @Override
    public void swallow(Function0<BoxedUnit> action) {
        Logging.swallow$(this, action);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public Object error(Function0<Throwable> e) {
        return Logging.error$(this, e);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void swallowError(Function0<BoxedUnit> action) {
        Logging.swallowError$(this, action);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public Object fatal(Function0<Throwable> e) {
        return Logging.fatal$(this, e);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        Cleaner cleaner = this;
        synchronized (cleaner) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        return !this.bitmap$0 ? this.logger$lzycompute() : this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    @Override
    public Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    @Override
    public void kafka$utils$Logging$_setter_$loggerName_$eq(String x$1) {
    }

    @Override
    public final void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ x$1) {
        this.kafka$utils$Logging$$log4jController = x$1;
    }

    public int id() {
        return this.id;
    }

    public OffsetMap offsetMap() {
        return this.offsetMap;
    }

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    private ByteBuffer readBuffer() {
        return this.readBuffer;
    }

    private void readBuffer_$eq(ByteBuffer x$1) {
        this.readBuffer = x$1;
    }

    private ByteBuffer writeBuffer() {
        return this.writeBuffer;
    }

    private void writeBuffer_$eq(ByteBuffer x$1) {
        this.writeBuffer = x$1;
    }

    public Tuple2<Object, CleanerStats> clean(LogToClean cleanable) {
        long l;
        CleanerStats stats = new CleanerStats(CleanerStats$.MODULE$.$lessinit$greater$default$1());
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Beginning cleaning of log %s.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{cleanable.log().name()})));
        Log log = cleanable.log();
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Building offset map for %s...")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{cleanable.log().name()})));
        long upperBoundOffset = cleanable.firstUncleanableOffset();
        this.buildOffsetMap(log, cleanable.firstDirtyOffset(), upperBoundOffset, this.offsetMap(), stats);
        long endOffset = this.offsetMap().latestOffset() + 1L;
        stats.indexDone();
        Option option = log.logSegments(0L, cleanable.firstDirtyOffset()).lastOption();
        if (None$.MODULE$.equals(option)) {
            l = 0L;
        } else if (option instanceof Some) {
            Some some = (Some)option;
            LogSegment seg = (LogSegment)some.value();
            l = seg.lastModified() - Predef$.MODULE$.Long2long(log.config().deleteRetentionMs());
        } else {
            throw new MatchError((Object)option);
        }
        long deleteHorizonMs = l;
        long cleanableHorizonMs = BoxesRunTime.unboxToLong((Object)log.logSegments(0L, cleanable.firstUncleanableOffset()).lastOption().map((Function1 & Serializable & scala.Serializable)x$13 -> BoxesRunTime.boxToLong((long)x$13.lastModified())).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 0L));
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Cleaning log %s (cleaning prior to %s, discarding tombstones prior to %s)...")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{log.name(), new Date(cleanableHorizonMs), new Date(deleteHorizonMs)})));
        this.groupSegmentsBySize(log.logSegments(0L, endOffset), Predef$.MODULE$.Integer2int(log.config().segmentSize()), Predef$.MODULE$.Integer2int(log.config().maxIndexSize())).foreach((Function1 & Serializable & scala.Serializable)group -> {
            this.cleanSegments(log, (Seq<LogSegment>)group, this.offsetMap(), deleteHorizonMs, stats);
            return BoxedUnit.UNIT;
        });
        stats.bufferUtilization_$eq(this.offsetMap().utilization());
        stats.allDone();
        return new Tuple2((Object)BoxesRunTime.boxToLong((long)endOffset), (Object)stats);
    }

    public void cleanSegments(Log log, Seq<LogSegment> segments, OffsetMap map, long deleteHorizonMs, CleanerStats stats) {
        File logFile = new File(((LogSegment)segments.head()).log().file().getPath() + Log$.MODULE$.CleanedFileSuffix());
        logFile.delete();
        File indexFile = new File(((LogSegment)segments.head()).index().file().getPath() + Log$.MODULE$.CleanedFileSuffix());
        File timeIndexFile = new File(((LogSegment)segments.head()).timeIndex().file().getPath() + Log$.MODULE$.CleanedFileSuffix());
        indexFile.delete();
        timeIndexFile.delete();
        FileRecords records = FileRecords.open((File)logFile, (boolean)false, (int)log.initFileSize(), (boolean)Predef$.MODULE$.Boolean2boolean(log.config().preallocate()));
        OffsetIndex index = new OffsetIndex(indexFile, ((LogSegment)segments.head()).baseOffset(), ((LogSegment)segments.head()).index().maxIndexSize());
        TimeIndex timeIndex = new TimeIndex(timeIndexFile, ((LogSegment)segments.head()).baseOffset(), ((LogSegment)segments.head()).timeIndex().maxIndexSize());
        LogSegment cleaned = new LogSegment(records, index, timeIndex, ((LogSegment)segments.head()).baseOffset(), ((LogSegment)segments.head()).indexIntervalBytes(), log.config().randomSegmentJitter(), this.time);
        try {
            segments.foreach((Function1 & Serializable & scala.Serializable)old -> {
                Cleaner.$anonfun$cleanSegments$1(this, log, map, deleteHorizonMs, stats, cleaned, old);
                return BoxedUnit.UNIT;
            });
            index.trimToValidSize();
            cleaned.onBecomeInactiveSegment();
            timeIndex.trimToValidSize();
            cleaned.flush();
            long modified = ((LogSegment)segments.last()).lastModified();
            cleaned.lastModified_$eq(modified);
            this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Swapping in cleaned segment %d for segment(s) %s in log %s.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)cleaned.baseOffset()), ((TraversableOnce)segments.map((Function1 & Serializable & scala.Serializable)x$14 -> BoxesRunTime.boxToLong((long)x$14.baseOffset()), Seq$.MODULE$.canBuildFrom())).mkString(","), log.name()})));
            log.replaceSegments(cleaned, segments, log.replaceSegments$default$3());
        }
        catch (LogCleaningAbortedException e) {
            cleaned.delete();
            throw e;
        }
    }

    public void cleanInto(TopicPartition topicPartition, LogSegment source, LogSegment dest, OffsetMap map, boolean retainDeletes, int maxLogMessageSize, CleanerStats stats) {
        MemoryRecords.LogEntryFilter logCleanerFilter = new MemoryRecords.LogEntryFilter(this, source, map, retainDeletes, stats){
            private final /* synthetic */ Cleaner $outer;
            private final LogSegment source$1;
            private final OffsetMap map$3;
            private final boolean retainDeletes$2;
            private final CleanerStats stats$5;

            public boolean shouldRetain(LogEntry logEntry) {
                return this.$outer.kafka$log$Cleaner$$shouldRetainMessage(this.source$1, this.map$3, this.retainDeletes$2, logEntry, this.stats$5);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.source$1 = source$1;
                this.map$3 = map$3;
                this.retainDeletes$2 = retainDeletes$2;
                this.stats$5 = stats$5;
            }
        };
        int position = 0;
        while (position < source.log().sizeInBytes()) {
            this.checkDone.apply((Object)topicPartition);
            this.readBuffer().clear();
            this.writeBuffer().clear();
            source.log().readInto(this.readBuffer(), position);
            MemoryRecords records = MemoryRecords.readableRecords((ByteBuffer)this.readBuffer());
            this.throttler.maybeThrottle(records.sizeInBytes());
            MemoryRecords.FilterResult result = records.filterTo(logCleanerFilter, this.writeBuffer());
            stats.readMessages(result.messagesRead, result.bytesRead);
            stats.recopyMessages(result.messagesRetained, result.bytesRetained);
            position += result.bytesRead;
            if (this.writeBuffer().position() > 0) {
                this.writeBuffer().flip();
                MemoryRecords retained = MemoryRecords.readableRecords((ByteBuffer)this.writeBuffer());
                dest.append(((LogEntry)retained.deepEntries().iterator().next()).offset(), result.maxOffset, result.maxTimestamp, result.shallowOffsetOfMaxTimestamp, retained);
                this.throttler.maybeThrottle(this.writeBuffer().limit());
            }
            if (this.readBuffer().limit() <= 0 || result.messagesRead != 0) continue;
            this.growBuffers(maxLogMessageSize);
        }
        this.restoreBuffers();
    }

    public boolean kafka$log$Cleaner$$shouldRetainMessage(LogSegment source, OffsetMap map, boolean retainDeletes, LogEntry entry, CleanerStats stats) {
        boolean bl;
        boolean pastLatestOffset;
        boolean bl2 = pastLatestOffset = entry.offset() > map.latestOffset();
        if (pastLatestOffset) {
            return true;
        }
        if (entry.record().hasKey()) {
            boolean obsoleteDelete;
            ByteBuffer key = entry.record().key();
            long foundOffset = map.get(key);
            boolean redundant = foundOffset >= 0L && entry.offset() < foundOffset;
            boolean bl3 = obsoleteDelete = !retainDeletes && entry.record().hasNullValue();
            bl = !redundant && !obsoleteDelete;
        } else {
            stats.invalidMessage();
            bl = false;
        }
        return bl;
    }

    public void growBuffers(int maxLogMessageSize) {
        int maxBufferSize = package$.MODULE$.max(maxLogMessageSize, this.maxIoBufferSize);
        if (this.readBuffer().capacity() >= maxBufferSize || this.writeBuffer().capacity() >= maxBufferSize) {
            throw new IllegalStateException(new StringOps(Predef$.MODULE$.augmentString("This log contains a message larger than maximum allowable size of %s.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)maxBufferSize)})));
        }
        int newSize = package$.MODULE$.min(this.readBuffer().capacity() * 2, maxBufferSize);
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Growing cleaner I/O buffers from " + this.readBuffer().capacity() + "bytes to " + newSize + " bytes.");
        this.readBuffer_$eq(ByteBuffer.allocate(newSize));
        this.writeBuffer_$eq(ByteBuffer.allocate(newSize));
    }

    public void restoreBuffers() {
        block1: {
            if (this.readBuffer().capacity() > this.ioBufferSize) {
                this.readBuffer_$eq(ByteBuffer.allocate(this.ioBufferSize));
            }
            if (this.writeBuffer().capacity() <= this.ioBufferSize) break block1;
            this.writeBuffer_$eq(ByteBuffer.allocate(this.ioBufferSize));
        }
    }

    public List<Seq<LogSegment>> groupSegmentsBySize(Iterable<LogSegment> segments, int maxSize, int maxIndexSize) {
        Nil$ grouped = Nil$.MODULE$;
        List segs = segments.toList();
        while (segs.nonEmpty()) {
            List group = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new LogSegment[]{(LogSegment)segs.head()}));
            long logSize = ((LogSegment)segs.head()).size();
            int indexSize = ((LogSegment)segs.head()).index().sizeInBytes();
            int timeIndexSize = ((LogSegment)segs.head()).timeIndex().sizeInBytes();
            segs = (List)segs.tail();
            while (segs.nonEmpty() && logSize + ((LogSegment)segs.head()).size() <= (long)maxSize && indexSize + ((LogSegment)segs.head()).index().sizeInBytes() <= maxIndexSize && timeIndexSize + ((LogSegment)segs.head()).timeIndex().sizeInBytes() <= maxIndexSize && ((LogSegment)segs.head()).index().lastOffset() - ((LogSegment)group.last()).index().baseOffset() <= Integer.MAX_VALUE) {
                LogSegment logSegment = (LogSegment)segs.head();
                group = group.$colon$colon((Object)logSegment);
                logSize += ((LogSegment)segs.head()).size();
                indexSize += ((LogSegment)segs.head()).index().sizeInBytes();
                timeIndexSize += ((LogSegment)segs.head()).timeIndex().sizeInBytes();
                segs = (List)segs.tail();
            }
            grouped = grouped.$colon$colon((Object)group.reverse());
        }
        return grouped.reverse();
    }

    public void buildOffsetMap(Log log, long start, long end, OffsetMap map, CleanerStats stats) {
        map.clear();
        Buffer dirty = log.logSegments(start, end).toBuffer();
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Building offset map for log %s for %d segments in offset range [%d, %d).")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{log.name(), BoxesRunTime.boxToInteger((int)dirty.size()), BoxesRunTime.boxToLong((long)start), BoxesRunTime.boxToLong((long)end)})));
        BooleanRef full = BooleanRef.create((boolean)false);
        dirty.withFilter((Function1 & Serializable & scala.Serializable)segment -> BoxesRunTime.boxToBoolean((boolean)Cleaner.$anonfun$buildOffsetMap$2(full, segment))).foreach((Function1 & Serializable & scala.Serializable)segment -> {
            Cleaner.$anonfun$buildOffsetMap$3(this, log, start, map, stats, dirty, full, segment);
            return BoxedUnit.UNIT;
        });
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Offset map for log %s complete.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{log.name()})));
    }

    private boolean buildOffsetMapForSegment(TopicPartition topicPartition, LogSegment segment, OffsetMap map, long start, int maxLogMessageSize, CleanerStats stats) {
        boolean bl;
        Object object = new Object();
        try {
            int position = segment.index().lookup(start).position();
            int maxDesiredMapSize = (int)((double)map.slots() * this.dupBufferLoadFactor);
            while (position < segment.log().sizeInBytes()) {
                this.checkDone.apply((Object)topicPartition);
                this.readBuffer().clear();
                segment.log().readInto(this.readBuffer(), position);
                MemoryRecords records = MemoryRecords.readableRecords((ByteBuffer)this.readBuffer());
                this.throttler.maybeThrottle(records.sizeInBytes());
                int startPosition = position;
                ((IterableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(records.deepEntries()).asScala()).foreach((Function1 & Serializable & scala.Serializable)entry -> {
                    Cleaner.$anonfun$buildOffsetMapForSegment$1(map, start, stats, maxDesiredMapSize, object, entry);
                    return BoxedUnit.UNIT;
                });
                int bytesRead = records.validBytes();
                stats.indexBytesRead(bytesRead);
                if ((position += bytesRead) != startPosition) continue;
                this.growBuffers(maxLogMessageSize);
            }
            this.restoreBuffers();
            bl = false;
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                bl = ex.value$mcZ$sp();
            }
            throw ex;
        }
        return bl;
    }

    public static final /* synthetic */ void $anonfun$cleanSegments$1(Cleaner $this, Log log$3, OffsetMap map$2, long deleteHorizonMs$2, CleanerStats stats$4, LogSegment cleaned$1, LogSegment old) {
        boolean retainDeletes = old.lastModified() > deleteHorizonMs$2;
        $this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Cleaning segment %s in log %s (largest timestamp %s) into %s, %s deletes.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)old.baseOffset()), log$3.name(), new Date(old.largestTimestamp()), BoxesRunTime.boxToLong((long)cleaned$1.baseOffset()), retainDeletes ? "retaining" : "discarding"})));
        $this.cleanInto(log$3.topicPartition(), old, cleaned$1, map$2, retainDeletes, Predef$.MODULE$.Integer2int(log$3.config().maxMessageSize()), stats$4);
    }

    public static final /* synthetic */ boolean $anonfun$buildOffsetMap$2(BooleanRef full$1, LogSegment segment) {
        return !full$1.elem;
    }

    public static final /* synthetic */ void $anonfun$buildOffsetMap$3(Cleaner $this, Log log$2, long start$1, OffsetMap map$1, CleanerStats stats$3, Buffer dirty$1, BooleanRef full$1, LogSegment segment) {
        block0: {
            $this.checkDone.apply((Object)log$2.topicPartition());
            full$1.elem = $this.buildOffsetMapForSegment(log$2.topicPartition(), segment, map$1, start$1, Predef$.MODULE$.Integer2int(log$2.config().maxMessageSize()), stats$3);
            if (!full$1.elem) break block0;
            $this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Offset map is full, %d segments fully mapped, segment with base offset %d is partially mapped")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)dirty$1.indexOf((Object)segment)), BoxesRunTime.boxToLong((long)segment.baseOffset())})));
        }
    }

    public static final /* synthetic */ void $anonfun$buildOffsetMapForSegment$1(OffsetMap map$4, long start$2, CleanerStats stats$6, int maxDesiredMapSize$1, Object nonLocalReturnKey1$1, LogEntry entry) {
        Record message = entry.record();
        if (message.hasKey() && entry.offset() >= start$2) {
            if (map$4.size() < maxDesiredMapSize$1) {
                map$4.put(message.key(), entry.offset());
            } else {
                throw new NonLocalReturnControl.mcZ.sp(nonLocalReturnKey1$1, true);
            }
        }
        stats$6.indexMessagesRead(1);
    }

    public Cleaner(int id, OffsetMap offsetMap, int ioBufferSize, int maxIoBufferSize, double dupBufferLoadFactor, Throttler throttler, Time time, Function1<TopicPartition, BoxedUnit> checkDone) {
        this.id = id;
        this.offsetMap = offsetMap;
        this.ioBufferSize = ioBufferSize;
        this.maxIoBufferSize = maxIoBufferSize;
        this.dupBufferLoadFactor = dupBufferLoadFactor;
        this.throttler = throttler;
        this.time = time;
        this.checkDone = checkDone;
        Logging.$init$(this);
        this.loggerName = LogCleaner.class.getName();
        this.logIdent_$eq("Cleaner " + id + ": ");
        this.readBuffer = ByteBuffer.allocate(ioBufferSize);
        this.writeBuffer = ByteBuffer.allocate(ioBufferSize);
        Predef$.MODULE$.require((double)offsetMap.slots() * dupBufferLoadFactor > 1.0, (Function0 & Serializable & scala.Serializable)() -> "offset map is too small to fit in even a single message, so log cleaning will never make progress. You can increase log.cleaner.dedupe.buffer.size or decrease log.cleaner.threads");
    }
}

