/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.Histogram;
import com.yammer.metrics.core.Meter;
import com.yammer.metrics.core.Timer;
import java.io.File;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import kafka.common.LogCleaningAbortedException;
import kafka.common.ThreadShutdownException;
import kafka.log.Cleaner;
import kafka.log.CleanerConfig;
import kafka.log.CleanerStats;
import kafka.log.CleanerStats$;
import kafka.log.Log;
import kafka.log.LogCleaner$;
import kafka.log.LogCleanerManager;
import kafka.log.LogToClean;
import kafka.log.SkimpyOffsetMap;
import kafka.metrics.KafkaMetricsGroup;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.Pool;
import kafka.utils.ShutdownableThread;
import kafka.utils.Throttler;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.utils.Time;
import org.apache.log4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.StringOps;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@ScalaSignature(bytes="\u0006\u0001\teb\u0001B\u0001\u0003\u0001\u001d\u0011!\u0002T8h\u00072,\u0017M\\3s\u0015\t\u0019A!A\u0002m_\u001eT\u0011!B\u0001\u0006W\u000647.Y\u0002\u0001'\u0011\u0001\u0001B\u0004\u000b\u0011\u0005%aQ\"\u0001\u0006\u000b\u0003-\tQa]2bY\u0006L!!\u0004\u0006\u0003\r\u0005s\u0017PU3g!\ty!#D\u0001\u0011\u0015\t\tB!A\u0003vi&d7/\u0003\u0002\u0014!\t9Aj\\4hS:<\u0007CA\u000b\u0019\u001b\u00051\"BA\f\u0005\u0003\u001diW\r\u001e:jGNL!!\u0007\f\u0003#-\u000bgm[1NKR\u0014\u0018nY:He>,\b\u000f\u0003\u0005\u001c\u0001\t\u0015\r\u0011\"\u0001\u001d\u0003\u0019\u0019wN\u001c4jOV\tQ\u0004\u0005\u0002\u001f?5\t!!\u0003\u0002!\u0005\ti1\t\\3b]\u0016\u00148i\u001c8gS\u001eD\u0001B\t\u0001\u0003\u0002\u0003\u0006I!H\u0001\bG>tg-[4!\u0011!!\u0003A!b\u0001\n\u0003)\u0013a\u00027pO\u0012K'o]\u000b\u0002MA\u0019\u0011bJ\u0015\n\u0005!R!!B!se\u0006L\bC\u0001\u00160\u001b\u0005Y#B\u0001\u0017.\u0003\tIwNC\u0001/\u0003\u0011Q\u0017M^1\n\u0005AZ#\u0001\u0002$jY\u0016D\u0001B\r\u0001\u0003\u0002\u0003\u0006IAJ\u0001\tY><G)\u001b:tA!AA\u0007\u0001BC\u0002\u0013\u0005Q'\u0001\u0003m_\u001e\u001cX#\u0001\u001c\u0011\t=9\u0014\bR\u0005\u0003qA\u0011A\u0001U8pYB\u0011!HQ\u0007\u0002w)\u0011A(P\u0001\u0007G>lWn\u001c8\u000b\u0005\u0015q$BA A\u0003\u0019\t\u0007/Y2iK*\t\u0011)A\u0002pe\u001eL!aQ\u001e\u0003\u001dQ{\u0007/[2QCJ$\u0018\u000e^5p]B\u0011a$R\u0005\u0003\r\n\u00111\u0001T8h\u0011!A\u0005A!A!\u0002\u00131\u0014!\u00027pON\u0004\u0003\u0002\u0003&\u0001\u0005\u0003\u0005\u000b\u0011B&\u0002\tQLW.\u001a\t\u0003\u0019:k\u0011!\u0014\u0006\u0003#mJ!aT'\u0003\tQKW.\u001a\u0005\u0006#\u0002!\tAU\u0001\u0007y%t\u0017\u000e\u001e \u0015\u000bM#VKV,\u0011\u0005y\u0001\u0001\"B\u000eQ\u0001\u0004i\u0002\"\u0002\u0013Q\u0001\u00041\u0003\"\u0002\u001bQ\u0001\u00041\u0004b\u0002&Q!\u0003\u0005\ra\u0013\u0005\t3\u0002\u0011\r\u0011\"\u0001\u00035\u0006q1\r\\3b]\u0016\u0014X*\u00198bO\u0016\u0014X#A.\u0011\u0005ya\u0016BA/\u0003\u0005EaunZ\"mK\u0006tWM]'b]\u0006<WM\u001d\u0005\u0007?\u0002\u0001\u000b\u0011B.\u0002\u001f\rdW-\u00198fe6\u000bg.Y4fe\u0002Bq!\u0019\u0001C\u0002\u0013%!-A\u0005uQJ|G\u000f\u001e7feV\t1\r\u0005\u0002\u0010I&\u0011Q\r\u0005\u0002\n)\"\u0014x\u000e\u001e;mKJDaa\u001a\u0001!\u0002\u0013\u0019\u0017A\u0003;ie>$H\u000f\\3sA!9\u0011\u000e\u0001b\u0001\n\u0013Q\u0017\u0001C2mK\u0006tWM]:\u0016\u0003-\u00042\u0001\\9t\u001b\u0005i'B\u00018p\u0003%IW.\\;uC\ndWM\u0003\u0002q\u0015\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\u0005Il'AC%oI\u0016DX\rZ*fcB\u0011A/^\u0007\u0002\u0001\u0019!a\u000f\u0001\u0003x\u00055\u0019E.Z1oKJ$\u0006N]3bIN\u0011Q\u000f\u001f\t\u0003\u001feL!A\u001f\t\u0003%MCW\u000f\u001e3po:\f'\r\\3UQJ,\u0017\r\u001a\u0005\tyV\u0014\t\u0011)A\u0005{\u0006AA\u000f\u001b:fC\u0012LE\r\u0005\u0002\n}&\u0011qP\u0003\u0002\u0004\u0013:$\bBB)v\t\u0003\t\u0019\u0001F\u0002t\u0003\u000bAa\u0001`A\u0001\u0001\u0004i\b\"CA\u0005k\n\u0007I\u0011IA\u0006\u0003)awnZ4fe:\u000bW.Z\u000b\u0003\u0003\u001b\u0001B!a\u0004\u0002\u00165\u0011\u0011\u0011\u0003\u0006\u0004\u0003'i\u0013\u0001\u00027b]\u001eLA!a\u0006\u0002\u0012\t11\u000b\u001e:j]\u001eD\u0001\"a\u0007vA\u0003%\u0011QB\u0001\fY><w-\u001a:OC6,\u0007\u0005C\u0005\u0002 U\u0014\r\u0011\"\u0001\u0002\"\u000591\r\\3b]\u0016\u0014XCAA\u0012!\rq\u0012QE\u0005\u0004\u0003O\u0011!aB\"mK\u0006tWM\u001d\u0005\t\u0003W)\b\u0015!\u0003\u0002$\u0005A1\r\\3b]\u0016\u0014\b\u0005C\u0005\u00020U\u0004\r\u0011\"\u0001\u00022\u0005IA.Y:u'R\fGo]\u000b\u0003\u0003g\u00012AHA\u001b\u0013\r\t9D\u0001\u0002\r\u00072,\u0017M\\3s'R\fGo\u001d\u0005\n\u0003w)\b\u0019!C\u0001\u0003{\tQ\u0002\\1tiN#\u0018\r^:`I\u0015\fH\u0003BA \u0003\u000b\u00022!CA!\u0013\r\t\u0019E\u0003\u0002\u0005+:LG\u000f\u0003\u0006\u0002H\u0005e\u0012\u0011!a\u0001\u0003g\t1\u0001\u001f\u00132\u0011!\tY%\u001eQ!\n\u0005M\u0012A\u00037bgR\u001cF/\u0019;tA!\"\u0011\u0011JA(!\rI\u0011\u0011K\u0005\u0004\u0003'R!\u0001\u0003<pY\u0006$\u0018\u000e\\3\t\u0013\u0005]SO1A\u0005\n\u0005e\u0013\u0001\u00052bG.|eMZ,bSRd\u0015\r^2i+\t\tY\u0006\u0005\u0003\u0002^\u0005\u001dTBAA0\u0015\u0011\t\t'a\u0019\u0002\u0015\r|gnY;se\u0016tGOC\u0002\u0002f5\nA!\u001e;jY&!\u0011\u0011NA0\u00059\u0019u.\u001e8u\t><h\u000eT1uG\"D\u0001\"!\u001cvA\u0003%\u00111L\u0001\u0012E\u0006\u001c7n\u00144g/\u0006LG\u000fT1uG\"\u0004\u0003bBA9k\u0012%\u00111O\u0001\nG\",7m\u001b#p]\u0016$B!a\u0010\u0002v!9\u0011qOA8\u0001\u0004I\u0014A\u0004;pa&\u001c\u0007+\u0019:uSRLwN\u001c\u0005\b\u0003w*H\u0011IA?\u0003\u0019!wnV8sWR\u0011\u0011q\b\u0005\b\u0003\u0003+H\u0011IA?\u0003!\u0019\b.\u001e;e_^t\u0007bBACk\u0012%\u0011QP\u0001\rG2,\u0017M\\(s'2,W\r\u001d\u0005\b\u0003\u0013+H\u0011AAF\u0003-\u0011XmY8sIN#\u0018\r^:\u0015\u0019\u0005}\u0012QRAI\u0003S\u000b\u0019,a.\t\u000f\u0005=\u0015q\u0011a\u0001{\u0006\u0011\u0011\u000e\u001a\u0005\t\u0003'\u000b9\t1\u0001\u0002\u0016\u0006!a.Y7f!\u0011\t9*!*\u000f\t\u0005e\u0015\u0011\u0015\t\u0004\u00037SQBAAO\u0015\r\tyJB\u0001\u0007yI|w\u000e\u001e \n\u0007\u0005\r&\"\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003/\t9KC\u0002\u0002$*A\u0001\"a+\u0002\b\u0002\u0007\u0011QV\u0001\u0005MJ|W\u000eE\u0002\n\u0003_K1!!-\u000b\u0005\u0011auN\\4\t\u0011\u0005U\u0016q\u0011a\u0001\u0003[\u000b!\u0001^8\t\u0011\u0005e\u0016q\u0011a\u0001\u0003g\tQa\u001d;biNDq!!0\u0001A\u0003%1.A\u0005dY\u0016\fg.\u001a:tA!9\u0011\u0011\u0019\u0001\u0005\u0002\u0005u\u0014aB:uCJ$X\u000f\u001d\u0005\b\u0003\u0003\u0003A\u0011AA?\u0011\u001d\t9\r\u0001C\u0001\u0003\u0013\fQ\"\u00192peR\u001cE.Z1oS:<G\u0003BA \u0003\u0017Dq!a\u001e\u0002F\u0002\u0007\u0011\bC\u0004\u0002P\u0002!\t!!5\u0002#U\u0004H-\u0019;f\u0007\",7m\u001b9pS:$8\u000f\u0006\u0003\u0002@\u0005M\u0007bBAk\u0003\u001b\u0004\r!K\u0001\bI\u0006$\u0018\rR5s\u0011\u001d\tI\u000e\u0001C\u0001\u00037\fq#\\1zE\u0016$&/\u001e8dCR,7\t[3dWB|\u0017N\u001c;\u0015\u0011\u0005}\u0012Q\\Ap\u0003CDq!!6\u0002X\u0002\u0007\u0011\u0006C\u0004\u0002x\u0005]\u0007\u0019A\u001d\t\u0011\u0005\r\u0018q\u001ba\u0001\u0003[\u000baa\u001c4gg\u0016$\bbBAt\u0001\u0011\u0005\u0011\u0011^\u0001\u0016C\n|'\u000f^!oIB\u000bWo]3DY\u0016\fg.\u001b8h)\u0011\ty$a;\t\u000f\u0005]\u0014Q\u001da\u0001s!9\u0011q\u001e\u0001\u0005\u0002\u0005E\u0018A\u0004:fgVlWm\u00117fC:Lgn\u001a\u000b\u0005\u0003\u007f\t\u0019\u0010C\u0004\u0002x\u00055\b\u0019A\u001d\t\u000f\u0005]\b\u0001\"\u0001\u0002z\u0006a\u0011m^1ji\u000ecW-\u00198fIRA\u00111 B\u0001\u0005\u0007\u0011)\u0001E\u0002\n\u0003{L1!a@\u000b\u0005\u001d\u0011un\u001c7fC:Dq!a\u001e\u0002v\u0002\u0007\u0011\b\u0003\u0005\u0002d\u0006U\b\u0019AAW\u0011)\u00119!!>\u0011\u0002\u0003\u0007\u0011QV\u0001\n[\u0006Dx+Y5u\u001bND\u0011Ba\u0003\u0001#\u0003%\tA!\u0004\u0002-\u0005<\u0018-\u001b;DY\u0016\fg.\u001a3%I\u00164\u0017-\u001e7uIM*\"Aa\u0004+\t\u00055&\u0011C\u0016\u0003\u0005'\u0001BA!\u0006\u0003 5\u0011!q\u0003\u0006\u0005\u00053\u0011Y\"A\u0005v]\u000eDWmY6fI*\u0019!Q\u0004\u0006\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0003\"\t]!!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u001eI!Q\u0005\u0002\u0002\u0002#\u0005!qE\u0001\u000b\u0019><7\t\\3b]\u0016\u0014\bc\u0001\u0010\u0003*\u0019A\u0011AAA\u0001\u0012\u0003\u0011YcE\u0002\u0003*!Aq!\u0015B\u0015\t\u0003\u0011y\u0003\u0006\u0002\u0003(!Q!1\u0007B\u0015#\u0003%\tA!\u000e\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00135+\t\u00119DK\u0002L\u0005#\u0001")
public class LogCleaner
implements KafkaMetricsGroup {
    private final CleanerConfig config;
    private final File[] logDirs;
    private final Pool<TopicPartition, Log> logs;
    public final Time kafka$log$LogCleaner$$time;
    private final LogCleanerManager cleanerManager;
    private final Throttler kafka$log$LogCleaner$$throttler;
    private final IndexedSeq<CleanerThread> kafka$log$LogCleaner$$cleaners;
    private final String loggerName;
    private Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    private volatile boolean bitmap$0;

    public static Time $lessinit$greater$default$4() {
        return LogCleaner$.MODULE$.$lessinit$greater$default$4();
    }

    @Override
    public <T> Gauge<T> newGauge(String name, Gauge<T> metric, Map<String, String> tags) {
        return KafkaMetricsGroup.newGauge$(this, name, metric, tags);
    }

    @Override
    public Meter newMeter(String name, String eventType, TimeUnit timeUnit, Map<String, String> tags) {
        return KafkaMetricsGroup.newMeter$(this, name, eventType, timeUnit, tags);
    }

    @Override
    public Histogram newHistogram(String name, boolean biased, Map<String, String> tags) {
        return KafkaMetricsGroup.newHistogram$(this, name, biased, tags);
    }

    @Override
    public Timer newTimer(String name, TimeUnit durationUnit, TimeUnit rateUnit, Map<String, String> tags) {
        return KafkaMetricsGroup.newTimer$(this, name, durationUnit, rateUnit, tags);
    }

    @Override
    public void removeMetric(String name, Map<String, String> tags) {
        KafkaMetricsGroup.removeMetric$(this, name, tags);
    }

    @Override
    public <T> Map<String, String> newGauge$default$3() {
        return KafkaMetricsGroup.newGauge$default$3$(this);
    }

    @Override
    public Map<String, String> newMeter$default$4() {
        return KafkaMetricsGroup.newMeter$default$4$(this);
    }

    @Override
    public Map<String, String> removeMetric$default$2() {
        return KafkaMetricsGroup.removeMetric$default$2$(this);
    }

    @Override
    public Map<String, String> newTimer$default$4() {
        return KafkaMetricsGroup.newTimer$default$4$(this);
    }

    @Override
    public boolean newHistogram$default$2() {
        return KafkaMetricsGroup.newHistogram$default$2$(this);
    }

    @Override
    public Map<String, String> newHistogram$default$3() {
        return KafkaMetricsGroup.newHistogram$default$3$(this);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public Object trace(Function0<Throwable> e) {
        return Logging.trace$(this, e);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public void swallowTrace(Function0<BoxedUnit> action) {
        Logging.swallowTrace$(this, action);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public Object debug(Function0<Throwable> e) {
        return Logging.debug$(this, e);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void swallowDebug(Function0<BoxedUnit> action) {
        Logging.swallowDebug$(this, action);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public Object info(Function0<Throwable> e) {
        return Logging.info$(this, e);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void swallowInfo(Function0<BoxedUnit> action) {
        Logging.swallowInfo$(this, action);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public Object warn(Function0<Throwable> e) {
        return Logging.warn$(this, e);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void swallowWarn(Function0<BoxedUnit> action) {
        Logging.swallowWarn$(this, action);
    }

    @Override
    public void swallow(Function0<BoxedUnit> action) {
        Logging.swallow$(this, action);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public Object error(Function0<Throwable> e) {
        return Logging.error$(this, e);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void swallowError(Function0<BoxedUnit> action) {
        Logging.swallowError$(this, action);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public Object fatal(Function0<Throwable> e) {
        return Logging.fatal$(this, e);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    private Logger logger$lzycompute() {
        LogCleaner logCleaner = this;
        synchronized (logCleaner) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        return !this.bitmap$0 ? this.logger$lzycompute() : this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    @Override
    public Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    @Override
    public void kafka$utils$Logging$_setter_$loggerName_$eq(String x$1) {
        this.loggerName = x$1;
    }

    @Override
    public final void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ x$1) {
        this.kafka$utils$Logging$$log4jController = x$1;
    }

    public CleanerConfig config() {
        return this.config;
    }

    public File[] logDirs() {
        return this.logDirs;
    }

    public Pool<TopicPartition, Log> logs() {
        return this.logs;
    }

    public LogCleanerManager cleanerManager() {
        return this.cleanerManager;
    }

    public Throttler kafka$log$LogCleaner$$throttler() {
        return this.kafka$log$LogCleaner$$throttler;
    }

    public IndexedSeq<CleanerThread> kafka$log$LogCleaner$$cleaners() {
        return this.kafka$log$LogCleaner$$cleaners;
    }

    public void startup() {
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Starting the log cleaner");
        this.kafka$log$LogCleaner$$cleaners().foreach((Function1 & Serializable & scala.Serializable)x$9 -> {
            x$9.start();
            return BoxedUnit.UNIT;
        });
    }

    public void shutdown() {
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Shutting down the log cleaner.");
        this.kafka$log$LogCleaner$$cleaners().foreach((Function1 & Serializable & scala.Serializable)x$10 -> {
            x$10.shutdown();
            return BoxedUnit.UNIT;
        });
    }

    public void abortCleaning(TopicPartition topicPartition) {
        this.cleanerManager().abortCleaning(topicPartition);
    }

    public void updateCheckpoints(File dataDir) {
        this.cleanerManager().updateCheckpoints(dataDir, (Option<Tuple2<TopicPartition, Object>>)None$.MODULE$);
    }

    public void maybeTruncateCheckpoint(File dataDir, TopicPartition topicPartition, long offset) {
        this.cleanerManager().maybeTruncateCheckpoint(dataDir, topicPartition, offset);
    }

    public void abortAndPauseCleaning(TopicPartition topicPartition) {
        this.cleanerManager().abortAndPauseCleaning(topicPartition);
    }

    public void resumeCleaning(TopicPartition topicPartition) {
        this.cleanerManager().resumeCleaning(topicPartition);
    }

    public boolean awaitCleaned(TopicPartition topicPartition, long offset, long maxWaitMs) {
        long sleepTime;
        for (long remainingWaitMs = maxWaitMs; !this.isCleaned$1(topicPartition, offset) && remainingWaitMs > 0L; remainingWaitMs -= sleepTime) {
            sleepTime = package$.MODULE$.min(100L, remainingWaitMs);
            Thread.sleep(sleepTime);
        }
        return this.isCleaned$1(topicPartition, offset);
    }

    public long awaitCleaned$default$3() {
        return 60000L;
    }

    public static final /* synthetic */ CleanerThread $anonfun$cleaners$1(LogCleaner $this, int x$1) {
        return $this.new CleanerThread(x$1);
    }

    private final boolean isCleaned$1(TopicPartition topicPartition$1, long offset$1) {
        return BoxesRunTime.unboxToBoolean((Object)this.cleanerManager().allCleanerCheckpoints().get((Object)topicPartition$1).fold((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> false, (Function1)(JFunction1.mcZJ.sp & Serializable & scala.Serializable)x$11 -> x$11 >= offset$1));
    }

    public LogCleaner(CleanerConfig config, File[] logDirs, Pool<TopicPartition, Log> logs, Time time) {
        this.config = config;
        this.logDirs = logDirs;
        this.logs = logs;
        this.kafka$log$LogCleaner$$time = time;
        Logging.$init$(this);
        KafkaMetricsGroup.$init$(this);
        this.cleanerManager = new LogCleanerManager(logDirs, logs);
        this.kafka$log$LogCleaner$$throttler = new Throttler(config.maxIoBytesPerSecond(), 300L, true, "cleaner-io", "bytes", time);
        this.kafka$log$LogCleaner$$cleaners = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), config.numThreads()).map((Function1 & Serializable & scala.Serializable)x$1 -> LogCleaner.$anonfun$cleaners$1(this, BoxesRunTime.unboxToInt((Object)x$1)), IndexedSeq$.MODULE$.canBuildFrom());
        this.newGauge("max-buffer-utilization-percent", new Gauge<Object>(this){
            private final /* synthetic */ LogCleaner $outer;

            public int value() {
                return (int)BoxesRunTime.unboxToDouble((Object)((TraversableOnce)((TraversableLike)this.$outer.kafka$log$LogCleaner$$cleaners().map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.lastStats(), IndexedSeq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToDouble((double)$anon$1.$anonfun$value$2(x$3)), IndexedSeq$.MODULE$.canBuildFrom())).max((Ordering)Ordering.Double$.MODULE$));
            }

            public static final /* synthetic */ double $anonfun$value$2(CleanerStats x$3) {
                return (double)100 * x$3.bufferUtilization();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$value$1(kafka.log.LogCleaner$CleanerThread ), $anonfun$value$2$adapted(kafka.log.CleanerStats )}, serializedLambda);
            }
        }, this.newGauge$default$3());
        this.newGauge("cleaner-recopy-percent", new Gauge<Object>(this){
            private final /* synthetic */ LogCleaner $outer;

            public int value() {
                IndexedSeq stats = (IndexedSeq)this.$outer.kafka$log$LogCleaner$$cleaners().map((Function1 & Serializable & scala.Serializable)x$4 -> x$4.lastStats(), IndexedSeq$.MODULE$.canBuildFrom());
                double recopyRate = (double)BoxesRunTime.unboxToLong((Object)((TraversableOnce)stats.map((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToLong((long)$anon$2.$anonfun$value$4(x$5)), IndexedSeq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$)) / (double)package$.MODULE$.max(BoxesRunTime.unboxToLong((Object)((TraversableOnce)stats.map((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToLong((long)$anon$2.$anonfun$value$5(x$6)), IndexedSeq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$)), 1L);
                return (int)((double)100 * recopyRate);
            }

            public static final /* synthetic */ long $anonfun$value$4(CleanerStats x$5) {
                return x$5.bytesWritten();
            }

            public static final /* synthetic */ long $anonfun$value$5(CleanerStats x$6) {
                return x$6.bytesRead();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$value$3(kafka.log.LogCleaner$CleanerThread ), $anonfun$value$4$adapted(kafka.log.CleanerStats ), $anonfun$value$5$adapted(kafka.log.CleanerStats )}, serializedLambda);
            }
        }, this.newGauge$default$3());
        this.newGauge("max-clean-time-secs", new Gauge<Object>(this){
            private final /* synthetic */ LogCleaner $outer;

            public int value() {
                return (int)BoxesRunTime.unboxToDouble((Object)((TraversableOnce)((TraversableLike)this.$outer.kafka$log$LogCleaner$$cleaners().map((Function1 & Serializable & scala.Serializable)x$7 -> x$7.lastStats(), IndexedSeq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToDouble((double)$anon$3.$anonfun$value$7(x$8)), IndexedSeq$.MODULE$.canBuildFrom())).max((Ordering)Ordering.Double$.MODULE$));
            }

            public static final /* synthetic */ double $anonfun$value$7(CleanerStats x$8) {
                return x$8.elapsedSecs();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$value$6(kafka.log.LogCleaner$CleanerThread ), $anonfun$value$7$adapted(kafka.log.CleanerStats )}, serializedLambda);
            }
        }, this.newGauge$default$3());
    }

    public class CleanerThread
    extends ShutdownableThread {
        private final String loggerName;
        private final Cleaner cleaner;
        private volatile CleanerStats lastStats;
        private final CountDownLatch backOffWaitLatch;

        @Override
        public String loggerName() {
            return this.loggerName;
        }

        public Cleaner cleaner() {
            return this.cleaner;
        }

        public CleanerStats lastStats() {
            return this.lastStats;
        }

        public void lastStats_$eq(CleanerStats x$1) {
            this.lastStats = x$1;
        }

        private CountDownLatch backOffWaitLatch() {
            return this.backOffWaitLatch;
        }

        private void checkDone(TopicPartition topicPartition) {
            if (!this.isRunning().get()) {
                throw new ThreadShutdownException();
            }
            this.kafka$log$LogCleaner$CleanerThread$$$outer().cleanerManager().checkCleaningAborted(topicPartition);
        }

        @Override
        public void doWork() {
            this.cleanOrSleep();
        }

        @Override
        public void shutdown() {
            this.initiateShutdown();
            this.backOffWaitLatch().countDown();
            this.awaitShutdown();
        }

        private void cleanOrSleep() {
            block11: {
                boolean bl;
                Option<LogToClean> option = this.kafka$log$LogCleaner$CleanerThread$$$outer().cleanerManager().grabFilthiestCompactedLog(this.kafka$log$LogCleaner$CleanerThread$$$outer().kafka$log$LogCleaner$$time);
                if (None$.MODULE$.equals(option)) {
                    bl = false;
                } else if (option instanceof Some) {
                    Some some = (Some)option;
                    LogToClean cleanable = (LogToClean)some.value();
                    long endOffset = cleanable.firstDirtyOffset();
                    try {
                        try {
                            Tuple2<Object, CleanerStats> tuple2 = this.cleaner().clean(cleanable);
                            if (tuple2 == null) {
                                throw new MatchError(tuple2);
                            }
                            long nextDirtyOffset = tuple2._1$mcJ$sp();
                            CleanerStats cleanerStats = (CleanerStats)tuple2._2();
                            Tuple2 tuple22 = new Tuple2((Object)BoxesRunTime.boxToLong((long)nextDirtyOffset), (Object)cleanerStats);
                            Tuple2 tuple23 = tuple22;
                            long nextDirtyOffset2 = tuple23._1$mcJ$sp();
                            CleanerStats cleanerStats2 = (CleanerStats)tuple23._2();
                            this.recordStats(this.cleaner().id(), cleanable.log().name(), cleanable.firstDirtyOffset(), endOffset, cleanerStats2);
                            endOffset = nextDirtyOffset2;
                        }
                        catch (LogCleaningAbortedException logCleaningAbortedException) {}
                    }
                    finally {
                        this.kafka$log$LogCleaner$CleanerThread$$$outer().cleanerManager().doneCleaning(cleanable.topicPartition(), cleanable.log().dir().getParentFile(), endOffset);
                    }
                    bl = true;
                } else {
                    throw new MatchError(option);
                }
                boolean cleaned = bl;
                Iterable<Tuple2<TopicPartition, Log>> deletable = this.kafka$log$LogCleaner$CleanerThread$$$outer().cleanerManager().deletableLogs();
                deletable.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToInteger((int)CleanerThread.$anonfun$cleanOrSleep$1(this, x0$1)));
                if (cleaned) break block11;
                this.backOffWaitLatch().await(this.kafka$log$LogCleaner$CleanerThread$$$outer().config().backOffMs(), TimeUnit.MILLISECONDS);
            }
        }

        public void recordStats(int id, String name, long from, long to, CleanerStats stats) {
            block0: {
                this.lastStats_$eq(stats);
                String message = new StringOps(Predef$.MODULE$.augmentString("%n\tLog cleaner thread %d cleaned log %s (dirty section = [%d, %d])%n")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)id), name, BoxesRunTime.boxToLong((long)from), BoxesRunTime.boxToLong((long)to)})) + new StringOps(Predef$.MODULE$.augmentString("\t%,.1f MB of log processed in %,.1f seconds (%,.1f MB/sec).%n")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)CleanerThread.mb$1(stats.bytesRead())), BoxesRunTime.boxToDouble((double)stats.elapsedSecs()), BoxesRunTime.boxToDouble((double)CleanerThread.mb$1((double)stats.bytesRead() / stats.elapsedSecs()))})) + new StringOps(Predef$.MODULE$.augmentString("\tIndexed %,.1f MB in %.1f seconds (%,.1f Mb/sec, %.1f%% of total time)%n")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)CleanerThread.mb$1(stats.mapBytesRead())), BoxesRunTime.boxToDouble((double)stats.elapsedIndexSecs()), BoxesRunTime.boxToDouble((double)(CleanerThread.mb$1(stats.mapBytesRead()) / stats.elapsedIndexSecs())), BoxesRunTime.boxToDouble((double)((double)100 * stats.elapsedIndexSecs() / stats.elapsedSecs()))})) + new StringOps(Predef$.MODULE$.augmentString("\tBuffer utilization: %.1f%%%n")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)((double)100 * stats.bufferUtilization()))})) + new StringOps(Predef$.MODULE$.augmentString("\tCleaned %,.1f MB in %.1f seconds (%,.1f Mb/sec, %.1f%% of total time)%n")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)CleanerThread.mb$1(stats.bytesRead())), BoxesRunTime.boxToDouble((double)(stats.elapsedSecs() - stats.elapsedIndexSecs())), BoxesRunTime.boxToDouble((double)(CleanerThread.mb$1(stats.bytesRead()) / (stats.elapsedSecs() - stats.elapsedIndexSecs()))), BoxesRunTime.boxToDouble((double)((double)100 * (stats.elapsedSecs() - stats.elapsedIndexSecs()) / stats.elapsedSecs()))})) + new StringOps(Predef$.MODULE$.augmentString("\tStart size: %,.1f MB (%,d messages)%n")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)CleanerThread.mb$1(stats.bytesRead())), BoxesRunTime.boxToLong((long)stats.messagesRead())})) + new StringOps(Predef$.MODULE$.augmentString("\tEnd size: %,.1f MB (%,d messages)%n")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)CleanerThread.mb$1(stats.bytesWritten())), BoxesRunTime.boxToLong((long)stats.messagesWritten())})) + new StringOps(Predef$.MODULE$.augmentString("\t%.1f%% size reduction (%.1f%% fewer messages)%n")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)(100.0 * (1.0 - (double)stats.bytesWritten() / (double)stats.bytesRead()))), BoxesRunTime.boxToDouble((double)(100.0 * (1.0 - (double)stats.messagesWritten() / (double)stats.messagesRead())))}));
                this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> message);
                if (stats.invalidMessagesRead() <= 0L) break block0;
                this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("\tFound %d invalid messages during compaction.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)stats.invalidMessagesRead())})));
            }
        }

        public /* synthetic */ LogCleaner kafka$log$LogCleaner$CleanerThread$$$outer() {
            return LogCleaner.this;
        }

        public static final /* synthetic */ int $anonfun$cleanOrSleep$1(CleanerThread $this, Tuple2 x0$1) {
            int n;
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                TopicPartition topicPartition = (TopicPartition)tuple2._1();
                Log log = (Log)tuple2._2();
                try {
                    n = log.deleteOldSegments();
                }
                finally {
                    $this.kafka$log$LogCleaner$CleanerThread$$$outer().cleanerManager().doneDeleting(topicPartition);
                }
            } else {
                throw new MatchError((Object)tuple2);
            }
            int n2 = n;
            return n2;
        }

        private static final double mb$1(double bytes) {
            return bytes / (double)0x100000;
        }

        public CleanerThread(int threadId) {
            if (LogCleaner.this == null) {
                throw null;
            }
            super("kafka-log-cleaner-thread-" + threadId, false);
            this.loggerName = LogCleaner.class.getName();
            if (LogCleaner.this.config().dedupeBufferSize() / (long)LogCleaner.this.config().numThreads() > Integer.MAX_VALUE) {
                this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Cannot use more than 2G of cleaner buffer space per cleaner thread, ignoring excess buffer space...");
            }
            this.cleaner = new Cleaner(threadId, new SkimpyOffsetMap((int)package$.MODULE$.min(LogCleaner.this.config().dedupeBufferSize() / (long)LogCleaner.this.config().numThreads(), Integer.MAX_VALUE), LogCleaner.this.config().hashAlgorithm()), LogCleaner.this.config().ioBufferSize() / LogCleaner.this.config().numThreads() / 2, LogCleaner.this.config().maxMessageSize(), LogCleaner.this.config().dedupeBufferLoadFactor(), LogCleaner.this.kafka$log$LogCleaner$$throttler(), LogCleaner.this.kafka$log$LogCleaner$$time, (Function1<TopicPartition, BoxedUnit>)(Function1 & Serializable & scala.Serializable)topicPartition -> {
                this.checkDone(topicPartition);
                return BoxedUnit.UNIT;
            });
            this.lastStats = new CleanerStats(CleanerStats$.MODULE$.$lessinit$greater$default$1());
            this.backOffWaitLatch = new CountDownLatch(1);
        }
    }
}

