/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import java.io.File;
import java.io.Serializable;
import java.nio.ByteBuffer;
import kafka.common.InvalidOffsetException;
import kafka.log.AbstractIndex;
import kafka.log.IndexEntry;
import kafka.log.IndexSearchType$;
import kafka.log.TimeIndex$;
import kafka.log.TimestampOffset;
import kafka.utils.CoreUtils$;
import scala.Function0;
import scala.Predef$;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0005]b\u0001B\u0001\u0003\u0001\u001d\u0011\u0011\u0002V5nK&sG-\u001a=\u000b\u0005\r!\u0011a\u00017pO*\tQ!A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0007\u0001A!\u0003\u0005\u0003\n\u00151aQ\"\u0001\u0002\n\u0005-\u0011!!D!cgR\u0014\u0018m\u0019;J]\u0012,\u0007\u0010\u0005\u0002\u000e!5\taBC\u0001\u0010\u0003\u0015\u00198-\u00197b\u0013\t\tbB\u0001\u0003M_:<\u0007CA\n\u0017\u001b\u0005!\"BA\u000b\u0005\u0003\u0015)H/\u001b7t\u0013\t9BCA\u0004M_\u001e<\u0017N\\4\t\u0011e\u0001!\u0011!Q\u0001\ni\tAAZ5mKB\u00111\u0004I\u0007\u00029)\u0011QDH\u0001\u0003S>T\u0011aH\u0001\u0005U\u00064\u0018-\u0003\u0002\"9\t!a)\u001b7f\u0011%\u0019\u0003A!A!\u0002\u0013aA%\u0001\u0006cCN,wJ\u001a4tKRL!a\t\u0006\t\u0013\u0019\u0002!\u0011!Q\u0001\n\u001dR\u0013\u0001D7bq&sG-\u001a=TSj,\u0007CA\u0007)\u0013\tIcBA\u0002J]RL!A\n\u0006\t\u000b1\u0002A\u0011A\u0017\u0002\rqJg.\u001b;?)\u0011qs\u0006M\u0019\u0011\u0005%\u0001\u0001\"B\r,\u0001\u0004Q\u0002\"B\u0012,\u0001\u0004a\u0001b\u0002\u0014,!\u0003\u0005\ra\n\u0005\u0006g\u0001!\t\u0005N\u0001\nK:$(/_*ju\u0016,\u0012a\n\u0005\u0006m\u0001!\teN\u0001\u0007SN4U\u000f\u001c7\u0016\u0003a\u0002\"!D\u001d\n\u0005ir!a\u0002\"p_2,\u0017M\u001c\u0005\u0006y\u0001!I!P\u0001\ni&lWm\u001d;b[B$2\u0001\u0004 G\u0011\u0015y4\b1\u0001A\u0003\u0019\u0011WO\u001a4feB\u0011\u0011\tR\u0007\u0002\u0005*\u00111IH\u0001\u0004]&|\u0017BA#C\u0005)\u0011\u0015\u0010^3Ck\u001a4WM\u001d\u0005\u0006\u000fn\u0002\raJ\u0001\u0002]\")\u0011\n\u0001C\u0005\u0015\u0006q!/\u001a7bi&4Xm\u00144gg\u0016$HcA\u0014L\u0019\")q\b\u0013a\u0001\u0001\")q\t\u0013a\u0001O!)a\n\u0001C\u0001\u001f\u0006IA.Y:u\u000b:$(/_\u000b\u0002!B\u0011\u0011\"U\u0005\u0003%\n\u0011q\u0002V5nKN$\u0018-\u001c9PM\u001a\u001cX\r\u001e\u0005\u0006)\u0002!\t!V\u0001\u0006K:$(/\u001f\u000b\u0003!ZCQaR*A\u0002\u001dBQ\u0001\u0017\u0001\u0005Be\u000b!\u0002]1sg\u0016,e\u000e\u001e:z)\rQVL\u0018\t\u0003\u0013mK!\u0001\u0018\u0002\u0003\u0015%sG-\u001a=F]R\u0014\u0018\u0010C\u0003@/\u0002\u0007\u0001\tC\u0003H/\u0002\u0007q\u0005C\u0003a\u0001\u0011\u0005\u0011-A\u0006nCf\u0014W-\u00119qK:$G\u0003\u00022fM\"\u0004\"!D2\n\u0005\u0011t!\u0001B+oSRDQ\u0001P0A\u00021AQaZ0A\u00021\taa\u001c4gg\u0016$\bbB5`!\u0003\u0005\r\u0001O\u0001\u000eg.L\u0007OR;mY\u000eCWmY6\t\u000b-\u0004A\u0011\u00017\u0002\r1|wn[;q)\t\u0001V\u000eC\u0003oU\u0002\u0007A\"A\buCJ<W\r\u001e+j[\u0016\u001cH/Y7q\u0011\u0015\u0001\b\u0001\"\u0011r\u0003!!(/\u001e8dCR,G#\u00012\t\u000bM\u0004A\u0011\t;\u0002\u0015Q\u0014XO\\2bi\u0016$v\u000e\u0006\u0002ck\")qM\u001da\u0001\u0019!)q\u000f\u0001C\u0005q\u0006\tBO];oG\u0006$X\rV8F]R\u0014\u0018.Z:\u0015\u0005\tL\b\"\u0002>w\u0001\u00049\u0013aB3oiJLWm\u001d\u0005\u0006y\u0002!\t%]\u0001\fg\u0006t\u0017\u000e^=DQ\u0016\u001c7\u000eC\u0004\u007f\u0001E\u0005I\u0011A@\u0002+5\f\u0017PY3BaB,g\u000e\u001a\u0013eK\u001a\fW\u000f\u001c;%gU\u0011\u0011\u0011\u0001\u0016\u0004q\u0005\r1FAA\u0003!\u0011\t9!!\u0005\u000e\u0005\u0005%!\u0002BA\u0006\u0003\u001b\t\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005=a\"\u0001\u0006b]:|G/\u0019;j_:LA!a\u0005\u0002\n\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\t\u001b\u0005]\u0001\u0001%A\u0002\u0002\u0003%I!!\u0007%\u0003A\u0019X\u000f]3sI\t\f7/Z(gMN,G/F\u0001\r\u000f%\tiBAA\u0001\u0012\u0003\ty\"A\u0005US6,\u0017J\u001c3fqB\u0019\u0011\"!\t\u0007\u0011\u0005\u0011\u0011\u0011!E\u0001\u0003G\u0019B!!\t\u0002&A\u0019Q\"a\n\n\u0007\u0005%bB\u0001\u0004B]f\u0014VM\u001a\u0005\bY\u0005\u0005B\u0011AA\u0017)\t\ty\u0002\u0003\u0006\u00022\u0005\u0005\u0012\u0013!C\u0001\u0003g\t1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012\u001aTCAA\u001bU\r9\u00131\u0001")
public class TimeIndex
extends AbstractIndex<Object, Object> {
    private final File file;

    public static int $lessinit$greater$default$3() {
        return TimeIndex$.MODULE$.$lessinit$greater$default$3();
    }

    private /* synthetic */ long super$baseOffset() {
        return super.baseOffset();
    }

    @Override
    public int entrySize() {
        return 12;
    }

    @Override
    public boolean isFull() {
        return this.entries() >= this.maxEntries() - 1;
    }

    private long timestamp(ByteBuffer buffer, int n) {
        return buffer.getLong(n * this.entrySize());
    }

    private int relativeOffset(ByteBuffer buffer, int n) {
        return buffer.getInt(n * this.entrySize() + 8);
    }

    public TimestampOffset lastEntry() {
        return (TimestampOffset)CoreUtils$.MODULE$.inLock(this.lock(), (Function0 & Serializable & scala.Serializable)() -> {
            TimestampOffset timestampOffset;
            int n = this._entries();
            switch (n) {
                case 0: {
                    timestampOffset = new TimestampOffset(-1L, this.super$baseOffset());
                    break;
                }
                default: {
                    timestampOffset = (TimestampOffset)this.parseEntry(this.mmap(), n - 1);
                    break;
                }
            }
            return timestampOffset;
        });
    }

    public TimestampOffset entry(int n) {
        return (TimestampOffset)this.maybeLock(this.lock(), (Function0 & Serializable & scala.Serializable)() -> {
            if (n >= this._entries()) {
                throw new IllegalArgumentException(new StringOps(Predef$.MODULE$.augmentString("Attempt to fetch the %dth entry from a time index of size %d.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)n), BoxesRunTime.boxToInteger((int)this._entries())})));
            }
            ByteBuffer idx = this.mmap().duplicate();
            return new TimestampOffset(this.timestamp(idx, n), this.relativeOffset(idx, n));
        });
    }

    @Override
    public IndexEntry parseEntry(ByteBuffer buffer, int n) {
        return new TimestampOffset(this.timestamp(buffer, n), super.baseOffset() + (long)this.relativeOffset(buffer, n));
    }

    public void maybeAppend(long timestamp, long offset, boolean skipFullCheck) {
        CoreUtils$.MODULE$.inLock(this.lock(), (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            block3: {
                if (!skipFullCheck) {
                    Predef$.MODULE$.require(!this.isFull(), (Function0 & Serializable & scala.Serializable)() -> "Attempt to append to a full time index (size = " + this._entries() + ").");
                }
                if (this._entries() != 0 && offset < this.lastEntry().offset()) {
                    throw new InvalidOffsetException(new StringOps(Predef$.MODULE$.augmentString("Attempt to append an offset (%d) to slot %d no larger than the last offset appended (%d) to %s.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)offset), BoxesRunTime.boxToInteger((int)this._entries()), BoxesRunTime.boxToLong((long)this.lastEntry().offset()), $this.file.getAbsolutePath()})));
                }
                if (this._entries() != 0 && timestamp < this.lastEntry().timestamp()) {
                    throw new IllegalStateException(new StringOps(Predef$.MODULE$.augmentString("Attempt to append an timestamp (%d) to slot %d no larger than the last timestamp appended (%d) to %s.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)timestamp), BoxesRunTime.boxToInteger((int)this._entries()), BoxesRunTime.boxToLong((long)this.lastEntry().timestamp()), $this.file.getAbsolutePath()})));
                }
                if (timestamp <= this.lastEntry().timestamp()) break block3;
                this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Adding index entry %d => %d to %s.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)timestamp), BoxesRunTime.boxToLong((long)offset), $this.file.getName()})));
                this.mmap().putLong(timestamp);
                this.mmap().putInt((int)(offset - this.super$baseOffset()));
                this._entries_$eq(this._entries() + 1);
                Predef$.MODULE$.require(this._entries() * this.entrySize() == this.mmap().position(), (Function0 & Serializable & scala.Serializable)() -> this._entries() + " entries but file position in index is " + this.mmap().position() + ".");
            }
        });
    }

    public boolean maybeAppend$default$3() {
        return false;
    }

    public TimestampOffset lookup(long targetTimestamp) {
        return (TimestampOffset)this.maybeLock(this.lock(), (Function0 & Serializable & scala.Serializable)() -> {
            TimestampOffset timestampOffset;
            ByteBuffer idx = this.mmap().duplicate();
            int slot = this.indexSlotFor(idx, targetTimestamp, IndexSearchType$.MODULE$.KEY());
            if (slot == -1) {
                timestampOffset = new TimestampOffset(-1L, this.super$baseOffset());
            } else {
                TimestampOffset entry = (TimestampOffset)this.parseEntry(idx, slot);
                timestampOffset = new TimestampOffset(entry.timestamp(), entry.offset());
            }
            return timestampOffset;
        });
    }

    @Override
    public void truncate() {
        this.truncateToEntries(0);
    }

    @Override
    public void truncateTo(long offset) {
        CoreUtils$.MODULE$.inLock(this.lock(), (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            ByteBuffer idx = this.mmap().duplicate();
            int slot = this.indexSlotFor(idx, offset, IndexSearchType$.MODULE$.VALUE());
            int newEntries = slot < 0 ? 0 : ((long)this.relativeOffset(idx, slot) == offset - this.super$baseOffset() ? slot : slot + 1);
            this.truncateToEntries(newEntries);
        });
    }

    private void truncateToEntries(int entries) {
        CoreUtils$.MODULE$.inLock(this.lock(), (Function0 & Serializable & scala.Serializable)() -> {
            this._entries_$eq(entries);
            return this.mmap().position(this._entries() * this.entrySize());
        });
    }

    @Override
    public void sanityCheck() {
        TimestampOffset entry = this.lastEntry();
        long lastTimestamp = entry.timestamp();
        long lastOffset = entry.offset();
        Predef$.MODULE$.require(this._entries() == 0 || lastTimestamp >= this.timestamp(this.mmap(), 0), (Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Corrupt time index found, time index file (", ") has non-zero size but the last timestamp "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{$this.file.getAbsolutePath()})) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"is ", " which is no larger than the first timestamp ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)lastTimestamp), BoxesRunTime.boxToLong((long)this.timestamp(this.mmap(), 0))})));
        Predef$.MODULE$.require(this._entries() == 0 || lastOffset >= super.baseOffset(), (Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Corrupt time index found, time index file (", ") has non-zero size but the last offset "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{$this.file.getAbsolutePath()})) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"is ", " which is smaller than the first offset ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)lastOffset), BoxesRunTime.boxToLong((long)this.super$baseOffset())})));
        long len = this.file.length();
        Predef$.MODULE$.require(len % (long)this.entrySize() == 0L, (Function0 & Serializable & scala.Serializable)() -> "Time index file " + $this.file.getAbsolutePath() + " is corrupt, found " + len + " bytes which is not positive or not a multiple of 12.");
    }

    public TimeIndex(File file, long baseOffset, int maxIndexSize) {
        this.file = file;
        super(file, baseOffset, maxIndexSize);
    }
}

