/*
 * Decompiled with CFR 0.152.
 */
package kafka.network;

import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.Histogram;
import com.yammer.metrics.core.Meter;
import com.yammer.metrics.core.Timer;
import java.io.IOException;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.net.InetAddress;
import java.net.SocketAddress;
import java.nio.channels.SocketChannel;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.TimeUnit;
import kafka.metrics.KafkaMetricsGroup;
import kafka.network.AbstractServerThread;
import kafka.network.ConnectionQuotas;
import kafka.network.Processor$;
import kafka.network.Processor$ConnectionId$;
import kafka.network.RequestChannel;
import kafka.network.RequestChannel$CloseConnectionAction$;
import kafka.network.RequestChannel$NoOpAction$;
import kafka.network.RequestChannel$SendAction$;
import kafka.security.CredentialProvider;
import org.apache.kafka.common.errors.InvalidRequestException;
import org.apache.kafka.common.metrics.KafkaMetric;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.network.ChannelBuilders;
import org.apache.kafka.common.network.KafkaChannel;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.network.NetworkReceive;
import org.apache.kafka.common.network.Selector;
import org.apache.kafka.common.network.Send;
import org.apache.kafka.common.protocol.SecurityProtocol;
import org.apache.kafka.common.protocol.types.SchemaException;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.security.authenticator.CredentialCache;
import org.apache.kafka.common.utils.Time;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Map$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction0;
import scala.util.control.ControlThrowable;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001\t5h!B\u0001\u0003\u0001\u00111!!\u0003)s_\u000e,7o]8s\u0015\t\u0019A!A\u0004oKR<xN]6\u000b\u0003\u0015\tQa[1gW\u0006\u001c2\u0001A\u0004\f!\tA\u0011\"D\u0001\u0003\u0013\tQ!A\u0001\u000bBEN$(/Y2u'\u0016\u0014h/\u001a:UQJ,\u0017\r\u001a\t\u0003\u0019=i\u0011!\u0004\u0006\u0003\u001d\u0011\tq!\\3ue&\u001c7/\u0003\u0002\u0011\u001b\t\t2*\u00194lC6+GO]5dg\u001e\u0013x.\u001e9\t\u0011I\u0001!Q1A\u0005\u0002Q\t!!\u001b3\u0004\u0001U\tQ\u0003\u0005\u0002\u001735\tqCC\u0001\u0019\u0003\u0015\u00198-\u00197b\u0013\tQrCA\u0002J]RD\u0001\u0002\b\u0001\u0003\u0002\u0003\u0006I!F\u0001\u0004S\u0012\u0004\u0003\u0002\u0003\u0010\u0001\u0005\u0003\u0005\u000b\u0011B\u0010\u0002\tQLW.\u001a\t\u0003A)j\u0011!\t\u0006\u0003E\r\nQ!\u001e;jYNT!\u0001J\u0013\u0002\r\r|W.\\8o\u0015\t)aE\u0003\u0002(Q\u00051\u0011\r]1dQ\u0016T\u0011!K\u0001\u0004_J<\u0017BA\u0016\"\u0005\u0011!\u0016.\\3\t\u00115\u0002!\u0011!Q\u0001\nU\ta\"\\1y%\u0016\fX/Z:u'&TX\r\u0003\u00050\u0001\t\u0005\t\u0015!\u00031\u00039\u0011X-];fgR\u001c\u0005.\u00198oK2\u0004\"\u0001C\u0019\n\u0005I\u0012!A\u0004*fcV,7\u000f^\"iC:tW\r\u001c\u0005\ti\u0001\u0011\t\u0011)A\u0005k\u0005\u00012m\u001c8oK\u000e$\u0018n\u001c8Rk>$\u0018m\u001d\t\u0003\u0011YJ!a\u000e\u0002\u0003!\r{gN\\3di&|g.U;pi\u0006\u001c\b\u0002C\u001d\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u001e\u0002)\r|gN\\3di&|gn]'bq&#G.Z't!\t12(\u0003\u0002=/\t!Aj\u001c8h\u0011!q\u0004A!A!\u0002\u0013y\u0014\u0001\u00047jgR,g.\u001a:OC6,\u0007C\u0001!C\u001b\u0005\t%BA\u0002$\u0013\t\u0019\u0015I\u0001\u0007MSN$XM\\3s\u001d\u0006lW\r\u0003\u0005F\u0001\t\u0005\t\u0015!\u0003G\u0003A\u0019XmY;sSRL\bK]8u_\u000e|G\u000e\u0005\u0002H\u00156\t\u0001J\u0003\u0002JG\u0005A\u0001O]8u_\u000e|G.\u0003\u0002L\u0011\n\u00012+Z2ve&$\u0018\u0010\u0015:pi>\u001cw\u000e\u001c\u0005\t\u001b\u0002\u0011\t\u0011)A\u0005\u001d\u0006q1\r[1o]\u0016d7i\u001c8gS\u001e\u001c\bGA(e!\u0011\u0001Vk\u00162\u000e\u0003ES!AU*\u0002\tU$\u0018\u000e\u001c\u0006\u0002)\u0006!!.\u0019<b\u0013\t1\u0016KA\u0002NCB\u0004\"\u0001W0\u000f\u0005ek\u0006C\u0001.\u0018\u001b\u0005Y&B\u0001/\u0014\u0003\u0019a$o\\8u}%\u0011alF\u0001\u0007!J,G-\u001a4\n\u0005\u0001\f'AB*ue&twM\u0003\u0002_/A\u00111\r\u001a\u0007\u0001\t%)G*!A\u0001\u0002\u000b\u0005aMA\u0002`IE\n\"a\u001a6\u0011\u0005YA\u0017BA5\u0018\u0005\u001dqu\u000e\u001e5j]\u001e\u0004\"AF6\n\u00051<\"aA!os\"Aa\u0002\u0001B\u0001B\u0003%a\u000e\u0005\u0002pc6\t\u0001O\u0003\u0002\u000fG%\u0011!\u000f\u001d\u0002\b\u001b\u0016$(/[2t\u0011!!\bA!A!\u0002\u0013)\u0018AE2sK\u0012,g\u000e^5bYB\u0013xN^5eKJ\u0004\"A^=\u000e\u0003]T!\u0001\u001f\u0003\u0002\u0011M,7-\u001e:jifL!A_<\u0003%\r\u0013X\rZ3oi&\fG\u000e\u0015:pm&$WM\u001d\u0005\u0006y\u0002!\t!`\u0001\u0007y%t\u0017\u000e\u001e \u0015-y|\u0018\u0011AA\u0002\u0003\u000b\t9!!\u0003\u0002\f\u00055\u0011qBA\r\u00037\u0001\"\u0001\u0003\u0001\t\u000bIY\b\u0019A\u000b\t\u000byY\b\u0019A\u0010\t\u000b5Z\b\u0019A\u000b\t\u000b=Z\b\u0019\u0001\u0019\t\u000bQZ\b\u0019A\u001b\t\u000beZ\b\u0019\u0001\u001e\t\u000byZ\b\u0019A \t\u000b\u0015[\b\u0019\u0001$\t\r5[\b\u0019AA\ta\u0011\t\u0019\"a\u0006\u0011\u000bA+v+!\u0006\u0011\u0007\r\f9\u0002\u0002\u0006f\u0003\u001f\t\t\u0011!A\u0003\u0002\u0019DQAD>A\u00029DQ\u0001^>A\u0002U<q!a\b\u0001\u0011\u0013\t\t#\u0001\u0007D_:tWm\u0019;j_:LE\r\u0005\u0003\u0002$\u0005\u0015R\"\u0001\u0001\u0007\u000f\u0005\u001d\u0002\u0001#\u0003\u0002*\ta1i\u001c8oK\u000e$\u0018n\u001c8JIN1\u0011QEA\u0016\u0003c\u00012AFA\u0017\u0013\r\tyc\u0006\u0002\u0007\u0003:L(+\u001a4\u0011\u0007Y\t\u0019$C\u0002\u00026]\u0011AbU3sS\u0006d\u0017N_1cY\u0016Dq\u0001`A\u0013\t\u0003\tI\u0004\u0006\u0002\u0002\"!A\u0011QHA\u0013\t\u0003\ty$\u0001\u0006ge>l7\u000b\u001e:j]\u001e$B!!\u0011\u0003\fA)a#a\u0011\u0002H%\u0019\u0011QI\f\u0003\r=\u0003H/[8o!\u0011\t\u0019#!\u0013\u0007\r\u0005\u001d\u0002\u0001RA&'!\tI%a\u000b\u0002N\u0005E\u0002c\u0001\f\u0002P%\u0019\u0011\u0011K\f\u0003\u000fA\u0013x\u000eZ;di\"Y\u0011QKA%\u0005+\u0007I\u0011AA,\u0003%awnY1m\u0011>\u001cH/F\u0001X\u0011)\tY&!\u0013\u0003\u0012\u0003\u0006IaV\u0001\u000bY>\u001c\u0017\r\u001c%pgR\u0004\u0003BCA0\u0003\u0013\u0012)\u001a!C\u0001)\u0005IAn\\2bYB{'\u000f\u001e\u0005\u000b\u0003G\nIE!E!\u0002\u0013)\u0012A\u00037pG\u0006d\u0007k\u001c:uA!Y\u0011qMA%\u0005+\u0007I\u0011AA,\u0003)\u0011X-\\8uK\"{7\u000f\u001e\u0005\u000b\u0003W\nIE!E!\u0002\u00139\u0016a\u0003:f[>$X\rS8ti\u0002B!\"a\u001c\u0002J\tU\r\u0011\"\u0001\u0015\u0003)\u0011X-\\8uKB{'\u000f\u001e\u0005\u000b\u0003g\nIE!E!\u0002\u0013)\u0012a\u0003:f[>$X\rU8si\u0002Bq\u0001`A%\t\u0003\t9\b\u0006\u0006\u0002H\u0005e\u00141PA?\u0003\u007fBq!!\u0016\u0002v\u0001\u0007q\u000bC\u0004\u0002`\u0005U\u0004\u0019A\u000b\t\u000f\u0005\u001d\u0014Q\u000fa\u0001/\"9\u0011qNA;\u0001\u0004)\u0002\u0002CAB\u0003\u0013\"\t%!\"\u0002\u0011Q|7\u000b\u001e:j]\u001e$\u0012a\u0016\u0005\u000b\u0003\u0013\u000bI%!A\u0005\u0002\u0005-\u0015\u0001B2paf$\"\"a\u0012\u0002\u000e\u0006=\u0015\u0011SAJ\u0011%\t)&a\"\u0011\u0002\u0003\u0007q\u000bC\u0005\u0002`\u0005\u001d\u0005\u0013!a\u0001+!I\u0011qMAD!\u0003\u0005\ra\u0016\u0005\n\u0003_\n9\t%AA\u0002UA!\"a&\u0002JE\u0005I\u0011AAM\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIE*\"!a'+\u0007]\u000bij\u000b\u0002\u0002 B!\u0011\u0011UAV\u001b\t\t\u0019K\u0003\u0003\u0002&\u0006\u001d\u0016!C;oG\",7m[3e\u0015\r\tIkF\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BAW\u0003G\u0013\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0011)\t\t,!\u0013\u0012\u0002\u0013\u0005\u00111W\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00133+\t\t)LK\u0002\u0016\u0003;C!\"!/\u0002JE\u0005I\u0011AAM\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIMB!\"!0\u0002JE\u0005I\u0011AAZ\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIQB!\"!1\u0002J\u0005\u0005I\u0011IAb\u00035\u0001(o\u001c3vGR\u0004&/\u001a4jqV\u0011\u0011Q\u0019\t\u0005\u0003\u000f\fi-\u0004\u0002\u0002J*\u0019\u00111Z*\u0002\t1\fgnZ\u0005\u0004A\u0006%\u0007\"CAi\u0003\u0013\n\t\u0011\"\u0001\u0015\u00031\u0001(o\u001c3vGR\f%/\u001b;z\u0011)\t).!\u0013\u0002\u0002\u0013\u0005\u0011q[\u0001\u000faJ|G-^2u\u000b2,W.\u001a8u)\rQ\u0017\u0011\u001c\u0005\n\u00037\f\u0019.!AA\u0002U\t1\u0001\u001f\u00132\u0011)\ty.!\u0013\u0002\u0002\u0013\u0005\u0013\u0011]\u0001\u0010aJ|G-^2u\u0013R,'/\u0019;peV\u0011\u00111\u001d\t\u0006\u0003K\fYO[\u0007\u0003\u0003OT1!!;\u0018\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0003[\f9O\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0011)\t\t0!\u0013\u0002\u0002\u0013\u0005\u00111_\u0001\tG\u0006tW)];bYR!\u0011Q_A~!\r1\u0012q_\u0005\u0004\u0003s<\"a\u0002\"p_2,\u0017M\u001c\u0005\n\u00037\fy/!AA\u0002)D!\"a@\u0002J\u0005\u0005I\u0011\tB\u0001\u0003!A\u0017m\u001d5D_\u0012,G#A\u000b\t\u0015\t\u0015\u0011\u0011JA\u0001\n\u0003\u00129!\u0001\u0004fcV\fGn\u001d\u000b\u0005\u0003k\u0014I\u0001C\u0005\u0002\\\n\r\u0011\u0011!a\u0001U\"9!QBA\u001e\u0001\u00049\u0016!A:\t\u0015\tE\u0011QEA\u0001\n\u0003\u0013\u0019\"A\u0003baBd\u0017\u0010\u0006\u0006\u0002H\tU!q\u0003B\r\u00057Aq!!\u0016\u0003\u0010\u0001\u0007q\u000bC\u0004\u0002`\t=\u0001\u0019A\u000b\t\u000f\u0005\u001d$q\u0002a\u0001/\"9\u0011q\u000eB\b\u0001\u0004)\u0002B\u0003B\u0010\u0003K\t\t\u0011\"!\u0003\"\u00059QO\\1qa2LH\u0003\u0002B\u0012\u0005W\u0001RAFA\"\u0005K\u0001rA\u0006B\u0014/V9V#C\u0002\u0003*]\u0011a\u0001V;qY\u0016$\u0004B\u0003B\u0017\u0005;\t\t\u00111\u0001\u0002H\u0005\u0019\u0001\u0010\n\u0019\t\u0013\tE\u0002A1A\u0005\n\tM\u0012A\u00048fo\u000e{gN\\3di&|gn]\u000b\u0003\u0005k\u0001bAa\u000e\u0003>\t\u0005SB\u0001B\u001d\u0015\r\u0011Y$U\u0001\u000bG>t7-\u001e:sK:$\u0018\u0002\u0002B \u0005s\u0011QcQ8oGV\u0014(/\u001a8u\u0019&t7.\u001a3Rk\u0016,X\r\u0005\u0003\u0003D\t5SB\u0001B#\u0015\u0011\u00119E!\u0013\u0002\u0011\rD\u0017M\u001c8fYNT1Aa\u0013T\u0003\rq\u0017n\\\u0005\u0005\u0005\u001f\u0012)EA\u0007T_\u000e\\W\r^\"iC:tW\r\u001c\u0005\t\u0005'\u0002\u0001\u0015!\u0003\u00036\u0005ya.Z<D_:tWm\u0019;j_:\u001c\b\u0005C\u0005\u0003X\u0001\u0011\r\u0011\"\u0003\u0003Z\u0005\t\u0012N\u001c4mS\u001eDGOU3ta>t7/Z:\u0016\u0005\tm\u0003c\u0002B/\u0005G:&QM\u0007\u0003\u0005?RAA!\u0019\u0002h\u00069Q.\u001e;bE2,\u0017b\u0001,\u0003`A!!q\rB7\u001d\rA!\u0011N\u0005\u0004\u0005W\u0012\u0011A\u0004*fcV,7\u000f^\"iC:tW\r\\\u0005\u0005\u0005_\u0012\tH\u0001\u0005SKN\u0004xN\\:f\u0015\r\u0011YG\u0001\u0005\t\u0005k\u0002\u0001\u0015!\u0003\u0003\\\u0005\u0011\u0012N\u001c4mS\u001eDGOU3ta>t7/Z:!\u0011%\u0011I\b\u0001b\u0001\n\u0013\u0011Y(\u0001\u0006nKR\u0014\u0018n\u0019+bON,\"A! \u0011\rA+\u0016QYAc\u0011!\u0011\t\t\u0001Q\u0001\n\tu\u0014aC7fiJL7\rV1hg\u0002B\u0011B!\"\u0001\u0005\u0004%IAa\"\u0002\u0011M,G.Z2u_J,\"A!#\u0011\u0007\u0001\u0013Y)C\u0002\u0003\u000e\u0006\u0013\u0001bU3mK\u000e$xN\u001d\u0005\t\u0005#\u0003\u0001\u0015!\u0003\u0003\n\u0006I1/\u001a7fGR|'\u000f\t\u0005\b\u0005+\u0003A\u0011\tBL\u0003\r\u0011XO\u001c\u000b\u0003\u00053\u00032A\u0006BN\u0013\r\u0011ij\u0006\u0002\u0005+:LG\u000fC\u0004\u0003\"\u0002!IAa&\u0002'A\u0014xnY3tg:+wOU3ta>t7/Z:\t\u0011\t\u0015\u0006\u0001\"\u0005\u0003\u0005O\u000bAb]3oIJ+7\u000f]8og\u0016$BA!'\u0003*\"A!1\u0016BR\u0001\u0004\u0011)'\u0001\u0005sKN\u0004xN\\:f\u0011\u001d\u0011y\u000b\u0001C\u0005\u0005/\u000bA\u0001]8mY\"9!1\u0017\u0001\u0005\n\t]\u0015\u0001\u00079s_\u000e,7o]\"p[BdW\r^3e%\u0016\u001cW-\u001b<fg\"9!q\u0017\u0001\u0005\n\t]\u0015!\u00069s_\u000e,7o]\"p[BdW\r^3e'\u0016tGm\u001d\u0005\b\u0005w\u0003A\u0011\u0002BL\u0003M\u0001(o\\2fgN$\u0015n]2p]:,7\r^3e\u0011\u001d\u0011y\f\u0001C\u0001\u0005\u0003\fa!Y2dKB$H\u0003\u0002BM\u0005\u0007D\u0001B!2\u0003>\u0002\u0007!\u0011I\u0001\u000eg>\u001c7.\u001a;DQ\u0006tg.\u001a7\t\u000f\t%\u0007\u0001\"\u0003\u0003\u0018\u000692m\u001c8gS\u001e,(/\u001a(fo\u000e{gN\\3di&|gn\u001d\u0005\b\u0005\u001b\u0004A\u0011\u0002BL\u0003!\u0019Gn\\:f\u00032d\u0007\u0002\u0003Bi\u0001\u0011\u0005!Aa5\u0002\u000f\rD\u0017M\u001c8fYR!!Q\u001bBo!\u00151\u00121\tBl!\r\u0001%\u0011\\\u0005\u0004\u00057\f%\u0001D&bM.\f7\t[1o]\u0016d\u0007b\u0002Bp\u0005\u001f\u0004\raV\u0001\rG>tg.Z2uS>t\u0017\n\u001a\u0005\b\u0005G\u0004A\u0011\u0001BL\u0003\u00199\u0018m[3va\"\"!\u0011\u001dBt!\u0011\t9M!;\n\t\t-\u0018\u0011\u001a\u0002\t\u001fZ,'O]5eK\u0002")
public class Processor
extends AbstractServerThread
implements KafkaMetricsGroup {
    private volatile Processor$ConnectionId$ ConnectionId$module;
    private final int id;
    private final Time time;
    private final RequestChannel requestChannel;
    private final ConnectionQuotas connectionQuotas;
    private final ListenerName listenerName;
    private final SecurityProtocol securityProtocol;
    public final Metrics kafka$network$Processor$$metrics;
    private final ConcurrentLinkedQueue<SocketChannel> newConnections;
    private final scala.collection.mutable.Map<String, RequestChannel.Response> inflightResponses;
    private final java.util.Map<String, String> kafka$network$Processor$$metricTags;
    private final Selector selector;

    @Override
    public <T> Gauge<T> newGauge(String name, Gauge<T> metric, Map<String, String> tags) {
        return KafkaMetricsGroup.newGauge$(this, name, metric, tags);
    }

    @Override
    public Meter newMeter(String name, String eventType, TimeUnit timeUnit, Map<String, String> tags) {
        return KafkaMetricsGroup.newMeter$(this, name, eventType, timeUnit, tags);
    }

    @Override
    public Histogram newHistogram(String name, boolean biased, Map<String, String> tags) {
        return KafkaMetricsGroup.newHistogram$(this, name, biased, tags);
    }

    @Override
    public Timer newTimer(String name, TimeUnit durationUnit, TimeUnit rateUnit, Map<String, String> tags) {
        return KafkaMetricsGroup.newTimer$(this, name, durationUnit, rateUnit, tags);
    }

    @Override
    public void removeMetric(String name, Map<String, String> tags) {
        KafkaMetricsGroup.removeMetric$(this, name, tags);
    }

    @Override
    public <T> Map<String, String> newGauge$default$3() {
        return KafkaMetricsGroup.newGauge$default$3$(this);
    }

    @Override
    public Map<String, String> newMeter$default$4() {
        return KafkaMetricsGroup.newMeter$default$4$(this);
    }

    @Override
    public Map<String, String> removeMetric$default$2() {
        return KafkaMetricsGroup.removeMetric$default$2$(this);
    }

    @Override
    public Map<String, String> newTimer$default$4() {
        return KafkaMetricsGroup.newTimer$default$4$(this);
    }

    @Override
    public boolean newHistogram$default$2() {
        return KafkaMetricsGroup.newHistogram$default$2$(this);
    }

    @Override
    public Map<String, String> newHistogram$default$3() {
        return KafkaMetricsGroup.newHistogram$default$3$(this);
    }

    private Processor$ConnectionId$ ConnectionId() {
        if (this.ConnectionId$module == null) {
            this.ConnectionId$lzycompute$1();
        }
        return this.ConnectionId$module;
    }

    public int id() {
        return this.id;
    }

    private ConcurrentLinkedQueue<SocketChannel> newConnections() {
        return this.newConnections;
    }

    private scala.collection.mutable.Map<String, RequestChannel.Response> inflightResponses() {
        return this.inflightResponses;
    }

    public java.util.Map<String, String> kafka$network$Processor$$metricTags() {
        return this.kafka$network$Processor$$metricTags;
    }

    private Selector selector() {
        return this.selector;
    }

    @Override
    public void run() {
        this.startupComplete();
        while (this.isRunning()) {
            try {
                this.configureNewConnections();
                this.processNewResponses();
                this.poll();
                this.processCompletedReceives();
                this.processCompletedSends();
                this.processDisconnected();
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                if (throwable2 instanceof ControlThrowable) {
                    ControlThrowable controlThrowable = (ControlThrowable)throwable2;
                    throw (Throwable)controlThrowable;
                }
                if (throwable2 != null) {
                    Throwable throwable3 = throwable2;
                    this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Processor got uncaught exception.", (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> throwable3);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    continue;
                }
                throw throwable;
            }
        }
        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Closing selector - processor " + this.id());
        this.swallowError((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.closeAll());
        this.shutdownComplete();
    }

    private void processNewResponses() {
        ObjectRef curr = ObjectRef.create((Object)this.requestChannel.receiveResponse(this.id()));
        while ((RequestChannel.Response)curr.elem != null) {
            try {
                BoxedUnit boxedUnit;
                RequestChannel.ResponseAction responseAction = ((RequestChannel.Response)curr.elem).responseAction();
                if (RequestChannel$NoOpAction$.MODULE$.equals(responseAction)) {
                    BoxedUnit boxedUnit2;
                    ((RequestChannel.Response)curr.elem).request().updateRequestMetrics();
                    this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Socket server received empty response to send, registering for read: " + (RequestChannel.Response)curr$1.elem);
                    String channelId = ((RequestChannel.Response)curr.elem).request().connectionId();
                    if (this.selector().channel(channelId) != null || this.selector().closingChannel(channelId) != null) {
                        this.selector().unmute(channelId);
                        boxedUnit2 = BoxedUnit.UNIT;
                    } else {
                        boxedUnit2 = BoxedUnit.UNIT;
                    }
                    boxedUnit = boxedUnit2;
                    continue;
                }
                if (RequestChannel$SendAction$.MODULE$.equals(responseAction)) {
                    this.sendResponse((RequestChannel.Response)curr.elem);
                    boxedUnit = BoxedUnit.UNIT;
                    continue;
                }
                if (RequestChannel$CloseConnectionAction$.MODULE$.equals(responseAction)) {
                    ((RequestChannel.Response)curr.elem).request().updateRequestMetrics();
                    this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Closing socket connection actively according to the response code.");
                    this.close(this.selector(), ((RequestChannel.Response)curr.elem).request().connectionId());
                    boxedUnit = BoxedUnit.UNIT;
                    continue;
                }
                throw new MatchError((Object)responseAction);
            }
            finally {
                curr.elem = this.requestChannel.receiveResponse(this.id());
            }
        }
    }

    public void sendResponse(RequestChannel.Response response) {
        this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Socket server received response to send, registering for write and sending data: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{response})));
        KafkaChannel channel = this.selector().channel(response.responseSend().destination());
        if (channel == null) {
            this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Attempting to send response via channel for which there is no open connection, connection id ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.id())})));
            response.request().updateRequestMetrics();
        } else {
            this.selector().send(response.responseSend());
            this.inflightResponses().$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)response.request().connectionId()), (Object)response));
        }
    }

    private void poll() {
        try {
            this.selector().poll(300L);
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            boolean bl = throwable2 instanceof IllegalStateException ? true : throwable2 instanceof IOException;
            if (bl) {
                this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Closing processor ", " due to illegal state or IO exception"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.id())})));
                this.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.closeAll());
                this.shutdownComplete();
                throw throwable2;
            }
            throw throwable;
        }
    }

    private void processCompletedReceives() {
        ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(this.selector().completedReceives()).asScala()).foreach((Function1 & Serializable & scala.Serializable)receive -> {
            Processor.$anonfun$processCompletedReceives$1(this, receive);
            return BoxedUnit.UNIT;
        });
    }

    private void processCompletedSends() {
        ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(this.selector().completedSends()).asScala()).foreach((Function1 & Serializable & scala.Serializable)send -> {
            Processor.$anonfun$processCompletedSends$1(this, send);
            return BoxedUnit.UNIT;
        });
    }

    private void processDisconnected() {
        ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(this.selector().disconnected()).asScala()).foreach((Function1 & Serializable & scala.Serializable)connectionId -> {
            Processor.$anonfun$processDisconnected$1(this, connectionId);
            return BoxedUnit.UNIT;
        });
    }

    public void accept(SocketChannel socketChannel) {
        this.newConnections().add(socketChannel);
        this.wakeup();
    }

    private void configureNewConnections() {
        while (!this.newConnections().isEmpty()) {
            SocketChannel channel = this.newConnections().poll();
            try {
                this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Processor ", " listening to new connection from ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.id()), channel.socket().getRemoteSocketAddress()})));
                String localHost = channel.socket().getLocalAddress().getHostAddress();
                int localPort = channel.socket().getLocalPort();
                String remoteHost = channel.socket().getInetAddress().getHostAddress();
                int remotePort = channel.socket().getPort();
                String connectionId = new ConnectionId(this, localHost, localPort, remoteHost, remotePort).toString();
                this.selector().register(connectionId, channel);
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                Option option = NonFatal$.MODULE$.unapply(throwable2);
                if (!option.isEmpty()) {
                    Throwable e = (Throwable)option.get();
                    SocketAddress remoteAddress = channel.getRemoteAddress();
                    this.close(channel);
                    this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Processor ", " closed connection from ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.id()), remoteAddress})), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    continue;
                }
                throw throwable;
            }
        }
    }

    private void closeAll() {
        ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(this.selector().channels()).asScala()).foreach((Function1 & Serializable & scala.Serializable)channel -> {
            this.close(this.selector(), channel.id());
            return BoxedUnit.UNIT;
        });
        this.selector().close();
    }

    public Option<KafkaChannel> channel(String connectionId) {
        return Option$.MODULE$.apply((Object)this.selector().channel(connectionId));
    }

    @Override
    public void wakeup() {
        this.selector().wakeup();
    }

    private final void ConnectionId$lzycompute$1() {
        Processor processor = this;
        synchronized (processor) {
            if (this.ConnectionId$module == null) {
                this.ConnectionId$module = new Processor$ConnectionId$(this);
            }
        }
    }

    public static final /* synthetic */ void $anonfun$processCompletedReceives$1(Processor $this, NetworkReceive receive) {
        try {
            KafkaChannel openChannel = $this.selector().channel(receive.source());
            KafkaChannel channel = openChannel != null ? openChannel : $this.selector().closingChannel(receive.source());
            RequestChannel.Session session = new RequestChannel.Session(new KafkaPrincipal("User", channel.principal().getName()), channel.socketAddress());
            RequestChannel.Request req = new RequestChannel.Request($this.id(), receive.source(), session, receive.payload(), $this.time.milliseconds(), $this.listenerName, $this.securityProtocol);
            $this.requestChannel.sendRequest(req);
            $this.selector().mute(receive.source());
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            boolean bl = throwable2 instanceof InvalidRequestException ? true : throwable2 instanceof SchemaException;
            if (bl) {
                $this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Closing socket for ", " because of error"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{receive.source()})), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> throwable2);
                $this.close($this.selector(), receive.source());
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            throw throwable;
        }
    }

    public static final /* synthetic */ void $anonfun$processCompletedSends$1(Processor $this, Send send) {
        RequestChannel.Response resp = (RequestChannel.Response)$this.inflightResponses().remove((Object)send.destination()).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new IllegalStateException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Send for ", " completed, but not in `inflightResponses`"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{send.destination()})));
        });
        resp.request().updateRequestMetrics();
        $this.selector().unmute(send.destination());
    }

    public static final /* synthetic */ void $anonfun$processDisconnected$3(RequestChannel.Response x$6) {
        x$6.request().updateRequestMetrics();
    }

    public static final /* synthetic */ void $anonfun$processDisconnected$1(Processor $this, String connectionId) {
        String remoteHost = ((ConnectionId)$this.ConnectionId().fromString(connectionId).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new IllegalStateException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"connectionId has unexpected format: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{connectionId})));
        })).remoteHost();
        $this.inflightResponses().remove((Object)connectionId).foreach((Function1 & Serializable & scala.Serializable)x$6 -> {
            Processor.$anonfun$processDisconnected$3(x$6);
            return BoxedUnit.UNIT;
        });
        $this.connectionQuotas.dec(InetAddress.getByName(remoteHost));
    }

    public Processor(int id, Time time, int maxRequestSize, RequestChannel requestChannel, ConnectionQuotas connectionQuotas, long connectionsMaxIdleMs, ListenerName listenerName, SecurityProtocol securityProtocol, java.util.Map<String, ?> channelConfigs, Metrics metrics, CredentialProvider credentialProvider) {
        this.id = id;
        this.time = time;
        this.requestChannel = requestChannel;
        this.connectionQuotas = connectionQuotas;
        this.listenerName = listenerName;
        this.securityProtocol = securityProtocol;
        this.kafka$network$Processor$$metrics = metrics;
        super(connectionQuotas);
        KafkaMetricsGroup.$init$(this);
        this.newConnections = new ConcurrentLinkedQueue();
        this.inflightResponses = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.kafka$network$Processor$$metricTags = (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"networkProcessor"), (Object)((Object)BoxesRunTime.boxToInteger((int)id)).toString())}))).asJava();
        this.newGauge("IdlePercent", new Gauge<Object>(this){
            private final /* synthetic */ Processor $outer;

            public double value() {
                return BoxesRunTime.unboxToDouble((Object)Option$.MODULE$.apply((Object)this.$outer.kafka$network$Processor$$metrics.metric(this.$outer.kafka$network$Processor$$metrics.metricName("io-wait-ratio", "socket-server-metrics", this.$outer.kafka$network$Processor$$metricTags()))).fold((Function0)(JFunction0.mcD.sp & Serializable & scala.Serializable)() -> 0.0, (Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToDouble((double)$anon$2.$anonfun$value$5(x$5))));
            }

            public static final /* synthetic */ double $anonfun$value$5(KafkaMetric x$5) {
                return x$5.value();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$value$4(), $anonfun$value$5$adapted(org.apache.kafka.common.metrics.KafkaMetric )}, serializedLambda);
            }
        }, (Map<String, String>)((Map)JavaConverters$.MODULE$.mapAsScalaMapConverter(this.kafka$network$Processor$$metricTags()).asScala()));
        this.selector = new Selector(maxRequestSize, connectionsMaxIdleMs, metrics, time, "socket-server", this.kafka$network$Processor$$metricTags(), false, ChannelBuilders.serverChannelBuilder((SecurityProtocol)securityProtocol, channelConfigs, (CredentialCache)credentialProvider.credentialCache()));
    }

    public class ConnectionId
    implements Product,
    scala.Serializable {
        private final String localHost;
        private final int localPort;
        private final String remoteHost;
        private final int remotePort;
        public final /* synthetic */ Processor $outer;

        public String localHost() {
            return this.localHost;
        }

        public int localPort() {
            return this.localPort;
        }

        public String remoteHost() {
            return this.remoteHost;
        }

        public int remotePort() {
            return this.remotePort;
        }

        public String toString() {
            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ":", "-", ":", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.localHost(), BoxesRunTime.boxToInteger((int)this.localPort()), this.remoteHost(), BoxesRunTime.boxToInteger((int)this.remotePort())}));
        }

        public ConnectionId copy(String localHost, int localPort, String remoteHost, int remotePort) {
            return new ConnectionId(this.kafka$network$Processor$ConnectionId$$$outer(), localHost, localPort, remoteHost, remotePort);
        }

        public String copy$default$1() {
            return this.localHost();
        }

        public int copy$default$2() {
            return this.localPort();
        }

        public String copy$default$3() {
            return this.remoteHost();
        }

        public int copy$default$4() {
            return this.remotePort();
        }

        public String productPrefix() {
            return "ConnectionId";
        }

        public int productArity() {
            return 4;
        }

        public Object productElement(int x$1) {
            Object object;
            int n = x$1;
            switch (n) {
                case 0: {
                    object = this.localHost();
                    break;
                }
                case 1: {
                    object = BoxesRunTime.boxToInteger((int)this.localPort());
                    break;
                }
                case 2: {
                    object = this.remoteHost();
                    break;
                }
                case 3: {
                    object = BoxesRunTime.boxToInteger((int)this.remotePort());
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
                }
            }
            return object;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof ConnectionId;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.localHost()));
            n = Statics.mix((int)n, (int)this.localPort());
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.remoteHost()));
            n = Statics.mix((int)n, (int)this.remotePort());
            return Statics.finalizeHash((int)n, (int)4);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof ConnectionId)) return false;
            if (((ConnectionId)object).kafka$network$Processor$ConnectionId$$$outer() != this.kafka$network$Processor$ConnectionId$$$outer()) return false;
            boolean bl = true;
            if (!bl) return false;
            ConnectionId connectionId = (ConnectionId)x$1;
            String string = this.localHost();
            String string2 = connectionId.localHost();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            if (this.localPort() != connectionId.localPort()) return false;
            String string3 = this.remoteHost();
            String string4 = connectionId.remoteHost();
            if (string3 == null) {
                if (string4 != null) {
                    return false;
                }
            } else if (!string3.equals(string4)) return false;
            if (this.remotePort() != connectionId.remotePort()) return false;
            if (!connectionId.canEqual(this)) return false;
            return true;
        }

        public /* synthetic */ Processor kafka$network$Processor$ConnectionId$$$outer() {
            return this.$outer;
        }

        public ConnectionId(Processor $outer, String localHost, int localPort, String remoteHost, int remotePort) {
            this.localHost = localHost;
            this.localPort = localPort;
            this.remoteHost = remoteHost;
            this.remotePort = remotePort;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            Product.$init$((Product)this);
        }
    }
}

