/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import kafka.controller.ControllerContext;
import kafka.controller.KafkaController$;
import kafka.server.LeaderElector;
import kafka.utils.CoreUtils$;
import kafka.utils.Json$;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.ZKCheckedEphemeral;
import org.I0Itec.zkclient.IZkDataListener;
import org.I0Itec.zkclient.exception.ZkNodeExistsException;
import org.apache.kafka.common.security.JaasUtils;
import org.apache.kafka.common.utils.Time;
import org.apache.log4j.Logger;
import scala.Function0;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@ScalaSignature(bytes="\u0006\u0001\u0005=e\u0001B\u0001\u0003\u0001\u001d\u0011aCW8pW\u0016,\u0007/\u001a:MK\u0006$WM]#mK\u000e$xN\u001d\u0006\u0003\u0007\u0011\taa]3sm\u0016\u0014(\"A\u0003\u0002\u000b-\fgm[1\u0004\u0001M!\u0001\u0001\u0003\b\u0013!\tIA\"D\u0001\u000b\u0015\u0005Y\u0011!B:dC2\f\u0017BA\u0007\u000b\u0005\u0019\te.\u001f*fMB\u0011q\u0002E\u0007\u0002\u0005%\u0011\u0011C\u0001\u0002\u000e\u0019\u0016\fG-\u001a:FY\u0016\u001cGo\u001c:\u0011\u0005M1R\"\u0001\u000b\u000b\u0005U!\u0011!B;uS2\u001c\u0018BA\f\u0015\u0005\u001daunZ4j]\u001eD\u0001\"\u0007\u0001\u0003\u0002\u0003\u0006IAG\u0001\u0012G>tGO]8mY\u0016\u00148i\u001c8uKb$\bCA\u000e\u001f\u001b\u0005a\"BA\u000f\u0005\u0003)\u0019wN\u001c;s_2dWM]\u0005\u0003?q\u0011\u0011cQ8oiJ|G\u000e\\3s\u0007>tG/\u001a=u\u0011!\t\u0003A!A!\u0002\u0013\u0011\u0013\u0001D3mK\u000e$\u0018n\u001c8QCRD\u0007CA\u0012+\u001d\t!\u0003\u0006\u0005\u0002&\u00155\taE\u0003\u0002(\r\u00051AH]8pizJ!!\u000b\u0006\u0002\rA\u0013X\rZ3g\u0013\tYCF\u0001\u0004TiJLgn\u001a\u0006\u0003S)A\u0001B\f\u0001\u0003\u0002\u0003\u0006IaL\u0001\u0011_:\u0014UmY8nS:<G*Z1eKJ\u00042!\u0003\u00193\u0013\t\t$BA\u0005Gk:\u001cG/[8oaA\u0011\u0011bM\u0005\u0003i)\u0011A!\u00168ji\"Aa\u0007\u0001B\u0001B\u0003%q&A\np]J+7/[4oS:<\u0017i\u001d'fC\u0012,'\u000f\u0003\u00059\u0001\t\u0005\t\u0015!\u0003:\u0003!\u0011'o\\6fe&#\u0007CA\u0005;\u0013\tY$BA\u0002J]RD\u0001\"\u0010\u0001\u0003\u0002\u0003\u0006IAP\u0001\u0005i&lW\r\u0005\u0002@\u00116\t\u0001I\u0003\u0002\u0016\u0003*\u0011!iQ\u0001\u0007G>lWn\u001c8\u000b\u0005\u0015!%BA#G\u0003\u0019\t\u0007/Y2iK*\tq)A\u0002pe\u001eL!!\u0013!\u0003\tQKW.\u001a\u0005\u0006\u0017\u0002!\t\u0001T\u0001\u0007y%t\u0017\u000e\u001e \u0015\u000f5su\nU)S'B\u0011q\u0002\u0001\u0005\u00063)\u0003\rA\u0007\u0005\u0006C)\u0003\rA\t\u0005\u0006])\u0003\ra\f\u0005\u0006m)\u0003\ra\f\u0005\u0006q)\u0003\r!\u000f\u0005\u0006{)\u0003\rA\u0010\u0005\b+\u0002\u0001\r\u0011\"\u0001W\u0003!aW-\u00193fe&#W#A\u001d\t\u000fa\u0003\u0001\u0019!C\u00013\u0006aA.Z1eKJLEm\u0018\u0013fcR\u0011!G\u0017\u0005\b7^\u000b\t\u00111\u0001:\u0003\rAH%\r\u0005\u0007;\u0002\u0001\u000b\u0015B\u001d\u0002\u00131,\u0017\rZ3s\u0013\u0012\u0004\u0003bB0\u0001\u0005\u0004%\tAV\u0001\u0006S:$W\r\u001f\u0005\u0007C\u0002\u0001\u000b\u0011B\u001d\u0002\r%tG-\u001a=!\u0011\u001d\u0019\u0007A1A\u0005\u0002\u0011\fA\u0003\\3bI\u0016\u00148\t[1oO\u0016d\u0015n\u001d;f]\u0016\u0014X#A3\u0011\u0005\u0019<W\"\u0001\u0001\u0007\t!\u0004\u0001!\u001b\u0002\u0015\u0019\u0016\fG-\u001a:DQ\u0006tw-\u001a'jgR,g.\u001a:\u0014\t\u001dT'O\u0005\t\u0003WBl\u0011\u0001\u001c\u0006\u0003[:\fA\u0001\\1oO*\tq.\u0001\u0003kCZ\f\u0017BA9m\u0005\u0019y%M[3diB\u00111\u000f_\u0007\u0002i*\u0011QO^\u0001\tu.\u001cG.[3oi*\u0011qOR\u0001\u0007\u0013BJE/Z2\n\u0005e$(aD%[W\u0012\u000bG/\u0019'jgR,g.\u001a:\t\u000b-;G\u0011A>\u0015\u0003\u0015DQ!`4\u0005\u0002y\f\u0001\u0003[1oI2,G)\u0019;b\u0007\"\fgnZ3\u0015\tIz\u00181\u0001\u0005\u0007\u0003\u0003a\b\u0019\u0001\u0012\u0002\u0011\u0011\fG/\u0019)bi\"Da!!\u0002}\u0001\u0004Q\u0017\u0001\u00023bi\u0006DS\u0001`A\u0005\u0003C\u0001R!CA\u0006\u0003\u001fI1!!\u0004\u000b\u0005\u0019!\bN]8xgB!\u0011\u0011CA\u000e\u001d\u0011\t\u0019\"a\u0006\u000f\u0007\u0015\n)\"C\u0001\f\u0013\r\tIBC\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\ti\"a\b\u0003\u0013\u0015C8-\u001a9uS>t'bAA\r\u0015E2aDIA\u0012\u0003\u001f\n\u0014bIA\u0013\u0003[\t)%a\f\u0016\t\u0005\u001d\u0012\u0011F\u000b\u0002E\u00119\u00111\u0006\u0004C\u0002\u0005U\"!\u0001+\n\t\u0005=\u0012\u0011G\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000fJ\u0019\u000b\u0007\u0005M\"\"\u0001\u0004uQJ|wo]\t\u0005\u0003o\ti\u0004E\u0002\n\u0003sI1!a\u000f\u000b\u0005\u001dqu\u000e\u001e5j]\u001e\u0004B!a\u0010\u0002B9\u0019\u0011\"a\u0006\n\t\u0005\r\u0013q\u0004\u0002\n)\"\u0014xn^1cY\u0016\f\u0014bIA$\u0003\u0013\nY%a\r\u000f\u0007%\tI%C\u0002\u00024)\tTAI\u0005\u000b\u0003\u001b\u0012Qa]2bY\u0006\f4AJA\b\u0011\u001d\t\u0019f\u001aC\u0001\u0003+\n\u0011\u0003[1oI2,G)\u0019;b\t\u0016dW\r^3e)\r\u0011\u0014q\u000b\u0005\b\u0003\u0003\t\t\u00061\u0001#Q\u0019\t\t&!\u0003\u0002\\E2aDIA/\u0003G\n\u0014bIA\u0013\u0003[\ty&a\f2\u0013\r\n9%!\u0013\u0002b\u0005M\u0012'\u0002\u0012\n\u0015\u00055\u0013g\u0001\u0014\u0002\u0010!9\u0011q\r\u0001!\u0002\u0013)\u0017!\u00067fC\u0012,'o\u00115b]\u001e,G*[:uK:,'\u000f\t\u0005\b\u0003W\u0002A\u0011AA7\u0003\u001d\u0019H/\u0019:ukB,\u0012A\r\u0005\b\u0003c\u0002A\u0011AA:\u0003=9W\r^\"p]R\u0014x\u000e\u001c7fe&#E#A\u001d\t\u000f\u0005]\u0004\u0001\"\u0001\u0002z\u0005)Q\r\\3diV\u0011\u00111\u0010\t\u0004\u0013\u0005u\u0014bAA@\u0015\t9!i\\8mK\u0006t\u0007bBAB\u0001\u0011\u0005\u0011QN\u0001\u0006G2|7/\u001a\u0005\b\u0003\u000f\u0003A\u0011AA=\u0003%\tW.\u0013'fC\u0012,'\u000fC\u0004\u0002\f\u0002!\t!!$\u0002\rI,7/[4o)\t\tY\b")
public class ZookeeperLeaderElector
implements LeaderElector {
    public final ControllerContext kafka$server$ZookeeperLeaderElector$$controllerContext;
    private final String electionPath;
    private final Function0<BoxedUnit> onBecomingLeader;
    public final Function0<BoxedUnit> kafka$server$ZookeeperLeaderElector$$onResigningAsLeader;
    public final int kafka$server$ZookeeperLeaderElector$$brokerId;
    private final Time time;
    private int leaderId;
    private final int index;
    private final LeaderChangeListener leaderChangeListener;
    private final String loggerName;
    private Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    private volatile boolean bitmap$0;

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public Object trace(Function0<Throwable> e) {
        return Logging.trace$(this, e);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public void swallowTrace(Function0<BoxedUnit> action) {
        Logging.swallowTrace$(this, action);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public Object debug(Function0<Throwable> e) {
        return Logging.debug$(this, e);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void swallowDebug(Function0<BoxedUnit> action) {
        Logging.swallowDebug$(this, action);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public Object info(Function0<Throwable> e) {
        return Logging.info$(this, e);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void swallowInfo(Function0<BoxedUnit> action) {
        Logging.swallowInfo$(this, action);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public Object warn(Function0<Throwable> e) {
        return Logging.warn$(this, e);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void swallowWarn(Function0<BoxedUnit> action) {
        Logging.swallowWarn$(this, action);
    }

    @Override
    public void swallow(Function0<BoxedUnit> action) {
        Logging.swallow$(this, action);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public Object error(Function0<Throwable> e) {
        return Logging.error$(this, e);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void swallowError(Function0<BoxedUnit> action) {
        Logging.swallowError$(this, action);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public Object fatal(Function0<Throwable> e) {
        return Logging.fatal$(this, e);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    private Logger logger$lzycompute() {
        ZookeeperLeaderElector zookeeperLeaderElector = this;
        synchronized (zookeeperLeaderElector) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        return !this.bitmap$0 ? this.logger$lzycompute() : this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    @Override
    public Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    @Override
    public void kafka$utils$Logging$_setter_$loggerName_$eq(String x$1) {
        this.loggerName = x$1;
    }

    @Override
    public final void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ x$1) {
        this.kafka$utils$Logging$$log4jController = x$1;
    }

    public int leaderId() {
        return this.leaderId;
    }

    public void leaderId_$eq(int x$1) {
        this.leaderId = x$1;
    }

    public int index() {
        return this.index;
    }

    public LeaderChangeListener leaderChangeListener() {
        return this.leaderChangeListener;
    }

    @Override
    public void startup() {
        CoreUtils$.MODULE$.inLock(this.kafka$server$ZookeeperLeaderElector$$controllerContext.controllerLock(), (JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            $this.kafka$server$ZookeeperLeaderElector$$controllerContext.zkUtils().zkClient().subscribeDataChanges($this.electionPath, (IZkDataListener)this.leaderChangeListener());
            return this.elect();
        });
    }

    public int getControllerID() {
        int n;
        Option option = (Option)this.kafka$server$ZookeeperLeaderElector$$controllerContext.zkUtils().readDataMaybeNull(this.electionPath)._1();
        if (option instanceof Some) {
            Some some = (Some)option;
            String controller = (String)some.value();
            n = KafkaController$.MODULE$.parseControllerId(controller);
        } else if (None$.MODULE$.equals(option)) {
            n = -1;
        } else {
            throw new MatchError((Object)option);
        }
        return n;
    }

    @Override
    public boolean elect() {
        Boolean bl;
        String timestamp = ((Object)BoxesRunTime.boxToLong((long)this.time.milliseconds())).toString();
        String electString = Json$.MODULE$.encode(Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"version"), (Object)BoxesRunTime.boxToInteger((int)1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"brokerid"), (Object)BoxesRunTime.boxToInteger((int)this.kafka$server$ZookeeperLeaderElector$$brokerId)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"timestamp"), (Object)timestamp)})));
        this.leaderId_$eq(this.getControllerID());
        if (this.leaderId() != -1) {
            this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Broker %d has been elected as leader, so stopping the election process.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.leaderId())})));
            return this.amILeader();
        }
        try {
            ZKCheckedEphemeral zkCheckedEphemeral = new ZKCheckedEphemeral(this.electionPath, electString, this.kafka$server$ZookeeperLeaderElector$$controllerContext.zkUtils().zkConnection().getZookeeper(), JaasUtils.isZkSecurityEnabled());
            zkCheckedEphemeral.create();
            this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> $this.kafka$server$ZookeeperLeaderElector$$brokerId + " successfully elected as leader");
            this.leaderId_$eq(this.kafka$server$ZookeeperLeaderElector$$brokerId);
            this.onBecomingLeader.apply$mcV$sp();
            bl = BoxedUnit.UNIT;
        }
        catch (ZkNodeExistsException zkNodeExistsException) {
            this.leaderId_$eq(this.getControllerID());
            if (this.leaderId() != -1) {
                this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Broker %d was elected as leader instead of broker %d")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.leaderId()), BoxesRunTime.boxToInteger((int)$this.kafka$server$ZookeeperLeaderElector$$brokerId)})));
            } else {
                this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "A leader has been elected but just resigned, this will result in another round of election");
            }
            bl = BoxedUnit.UNIT;
        }
        catch (Throwable e2) {
            this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Error while electing or becoming leader on broker %d")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)$this.kafka$server$ZookeeperLeaderElector$$brokerId)})), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e2);
            bl = BoxesRunTime.boxToBoolean((boolean)this.resign());
        }
        return this.amILeader();
    }

    @Override
    public void close() {
        this.leaderId_$eq(-1);
    }

    @Override
    public boolean amILeader() {
        return this.leaderId() == this.kafka$server$ZookeeperLeaderElector$$brokerId;
    }

    public boolean resign() {
        this.leaderId_$eq(-1);
        return this.kafka$server$ZookeeperLeaderElector$$controllerContext.zkUtils().deletePath(this.electionPath);
    }

    public ZookeeperLeaderElector(ControllerContext controllerContext, String electionPath, Function0<BoxedUnit> onBecomingLeader, Function0<BoxedUnit> onResigningAsLeader, int brokerId, Time time) {
        this.kafka$server$ZookeeperLeaderElector$$controllerContext = controllerContext;
        this.electionPath = electionPath;
        this.onBecomingLeader = onBecomingLeader;
        this.kafka$server$ZookeeperLeaderElector$$onResigningAsLeader = onResigningAsLeader;
        this.kafka$server$ZookeeperLeaderElector$$brokerId = brokerId;
        this.time = time;
        Logging.$init$(this);
        this.leaderId = -1;
        this.index = electionPath.lastIndexOf("/");
        if (this.index() > 0) {
            controllerContext.zkUtils().makeSurePersistentPathExists(electionPath.substring(0, this.index()), controllerContext.zkUtils().makeSurePersistentPathExists$default$2());
        }
        this.leaderChangeListener = new LeaderChangeListener();
    }

    /*
     * Duplicate member names - consider using --renamedupmembers true
     */
    public class LeaderChangeListener
    implements IZkDataListener,
    Logging {
        private final String loggerName;
        private Logger logger;
        private String logIdent;
        private final Log4jController$ kafka$utils$Logging$$log4jController;
        private volatile boolean bitmap$0;

        @Override
        public void trace(Function0<String> msg) {
            Logging.trace$(this, msg);
        }

        @Override
        public Object trace(Function0<Throwable> e) {
            return Logging.trace$(this, e);
        }

        @Override
        public void trace(Function0<String> msg, Function0<Throwable> e) {
            Logging.trace$(this, msg, e);
        }

        @Override
        public void swallowTrace(Function0<BoxedUnit> action) {
            Logging.swallowTrace$(this, action);
        }

        @Override
        public boolean isDebugEnabled() {
            return Logging.isDebugEnabled$(this);
        }

        @Override
        public void debug(Function0<String> msg) {
            Logging.debug$(this, msg);
        }

        @Override
        public Object debug(Function0<Throwable> e) {
            return Logging.debug$(this, e);
        }

        @Override
        public void debug(Function0<String> msg, Function0<Throwable> e) {
            Logging.debug$(this, msg, e);
        }

        @Override
        public void swallowDebug(Function0<BoxedUnit> action) {
            Logging.swallowDebug$(this, action);
        }

        @Override
        public void info(Function0<String> msg) {
            Logging.info$(this, msg);
        }

        @Override
        public Object info(Function0<Throwable> e) {
            return Logging.info$(this, e);
        }

        @Override
        public void info(Function0<String> msg, Function0<Throwable> e) {
            Logging.info$(this, msg, e);
        }

        @Override
        public void swallowInfo(Function0<BoxedUnit> action) {
            Logging.swallowInfo$(this, action);
        }

        @Override
        public void warn(Function0<String> msg) {
            Logging.warn$(this, msg);
        }

        @Override
        public Object warn(Function0<Throwable> e) {
            return Logging.warn$(this, e);
        }

        @Override
        public void warn(Function0<String> msg, Function0<Throwable> e) {
            Logging.warn$(this, msg, e);
        }

        @Override
        public void swallowWarn(Function0<BoxedUnit> action) {
            Logging.swallowWarn$(this, action);
        }

        @Override
        public void swallow(Function0<BoxedUnit> action) {
            Logging.swallow$(this, action);
        }

        @Override
        public void error(Function0<String> msg) {
            Logging.error$(this, msg);
        }

        @Override
        public Object error(Function0<Throwable> e) {
            return Logging.error$(this, e);
        }

        @Override
        public void error(Function0<String> msg, Function0<Throwable> e) {
            Logging.error$(this, msg, e);
        }

        @Override
        public void swallowError(Function0<BoxedUnit> action) {
            Logging.swallowError$(this, action);
        }

        @Override
        public void fatal(Function0<String> msg) {
            Logging.fatal$(this, msg);
        }

        @Override
        public Object fatal(Function0<Throwable> e) {
            return Logging.fatal$(this, e);
        }

        @Override
        public void fatal(Function0<String> msg, Function0<Throwable> e) {
            Logging.fatal$(this, msg, e);
        }

        @Override
        public String loggerName() {
            return this.loggerName;
        }

        private Logger logger$lzycompute() {
            LeaderChangeListener leaderChangeListener = this;
            synchronized (leaderChangeListener) {
                if (!this.bitmap$0) {
                    this.logger = Logging.logger$(this);
                    this.bitmap$0 = true;
                }
            }
            return this.logger;
        }

        @Override
        public Logger logger() {
            return !this.bitmap$0 ? this.logger$lzycompute() : this.logger;
        }

        @Override
        public String logIdent() {
            return this.logIdent;
        }

        @Override
        public void logIdent_$eq(String x$1) {
            this.logIdent = x$1;
        }

        @Override
        public Log4jController$ kafka$utils$Logging$$log4jController() {
            return this.kafka$utils$Logging$$log4jController;
        }

        @Override
        public void kafka$utils$Logging$_setter_$loggerName_$eq(String x$1) {
            this.loggerName = x$1;
        }

        @Override
        public final void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ x$1) {
            this.kafka$utils$Logging$$log4jController = x$1;
        }

        public void handleDataChange(String dataPath, Object data) throws Exception {
            block0: {
                boolean shouldResign = BoxesRunTime.unboxToBoolean(CoreUtils$.MODULE$.inLock(this.kafka$server$ZookeeperLeaderElector$LeaderChangeListener$$$outer().kafka$server$ZookeeperLeaderElector$$controllerContext.controllerLock(), (JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
                    boolean amILeaderBeforeDataChange = this.kafka$server$ZookeeperLeaderElector$LeaderChangeListener$$$outer().amILeader();
                    this.kafka$server$ZookeeperLeaderElector$LeaderChangeListener$$$outer().leaderId_$eq(KafkaController$.MODULE$.parseControllerId(data.toString()));
                    this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("New leader is %d")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.kafka$server$ZookeeperLeaderElector$LeaderChangeListener$$$outer().leaderId())})));
                    return amILeaderBeforeDataChange && !this.kafka$server$ZookeeperLeaderElector$LeaderChangeListener$$$outer().amILeader();
                }));
                if (!shouldResign) break block0;
                this.kafka$server$ZookeeperLeaderElector$LeaderChangeListener$$$outer().kafka$server$ZookeeperLeaderElector$$onResigningAsLeader.apply$mcV$sp();
            }
        }

        public void handleDataDeleted(String dataPath) throws Exception {
            boolean shouldResign = BoxesRunTime.unboxToBoolean(CoreUtils$.MODULE$.inLock(this.kafka$server$ZookeeperLeaderElector$LeaderChangeListener$$$outer().kafka$server$ZookeeperLeaderElector$$controllerContext.controllerLock(), (JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
                this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("%s leader change listener fired for path %s to handle data deleted: trying to elect as a leader")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)$this.kafka$server$ZookeeperLeaderElector$LeaderChangeListener$$$outer().kafka$server$ZookeeperLeaderElector$$brokerId), dataPath})));
                return this.kafka$server$ZookeeperLeaderElector$LeaderChangeListener$$$outer().amILeader();
            }));
            if (shouldResign) {
                this.kafka$server$ZookeeperLeaderElector$LeaderChangeListener$$$outer().kafka$server$ZookeeperLeaderElector$$onResigningAsLeader.apply$mcV$sp();
            }
            CoreUtils$.MODULE$.inLock(this.kafka$server$ZookeeperLeaderElector$LeaderChangeListener$$$outer().kafka$server$ZookeeperLeaderElector$$controllerContext.controllerLock(), (JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> this.kafka$server$ZookeeperLeaderElector$LeaderChangeListener$$$outer().elect());
        }

        public /* synthetic */ ZookeeperLeaderElector kafka$server$ZookeeperLeaderElector$LeaderChangeListener$$$outer() {
            return ZookeeperLeaderElector.this;
        }

        public LeaderChangeListener() {
            if (ZookeeperLeaderElector.this == null) {
                throw null;
            }
            Logging.$init$(this);
        }
    }
}

