/*
 * Decompiled with CFR 0.152.
 */
package kafka.tools;

import java.io.OutputStream;
import java.io.Serializable;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import kafka.consumer.ConsumerThreadId;
import kafka.utils.CommandLineUtils$;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.ZKGroupTopicDirs;
import kafka.utils.ZkUtils;
import kafka.utils.ZkUtils$;
import org.apache.kafka.common.security.JaasUtils;
import org.apache.log4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.LinearSeqOptimized;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Map;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction1;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public final class VerifyConsumerRebalance$
implements Logging {
    public static VerifyConsumerRebalance$ MODULE$;
    private final String loggerName;
    private Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    private volatile boolean bitmap$0;

    static {
        new VerifyConsumerRebalance$();
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public Object trace(Function0<Throwable> e) {
        return Logging.trace$(this, e);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public void swallowTrace(Function0<BoxedUnit> action) {
        Logging.swallowTrace$(this, action);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public Object debug(Function0<Throwable> e) {
        return Logging.debug$(this, e);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void swallowDebug(Function0<BoxedUnit> action) {
        Logging.swallowDebug$(this, action);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public Object info(Function0<Throwable> e) {
        return Logging.info$(this, e);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void swallowInfo(Function0<BoxedUnit> action) {
        Logging.swallowInfo$(this, action);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public Object warn(Function0<Throwable> e) {
        return Logging.warn$(this, e);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void swallowWarn(Function0<BoxedUnit> action) {
        Logging.swallowWarn$(this, action);
    }

    @Override
    public void swallow(Function0<BoxedUnit> action) {
        Logging.swallow$(this, action);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public Object error(Function0<Throwable> e) {
        return Logging.error$(this, e);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void swallowError(Function0<BoxedUnit> action) {
        Logging.swallowError$(this, action);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public Object fatal(Function0<Throwable> e) {
        return Logging.fatal$(this, e);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    private Logger logger$lzycompute() {
        VerifyConsumerRebalance$ verifyConsumerRebalance$ = this;
        synchronized (verifyConsumerRebalance$) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        return !this.bitmap$0 ? this.logger$lzycompute() : this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    @Override
    public Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    @Override
    public void kafka$utils$Logging$_setter_$loggerName_$eq(String x$1) {
        this.loggerName = x$1;
    }

    @Override
    public final void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ x$1) {
        this.kafka$utils$Logging$$log4jController = x$1;
    }

    public void main(String[] args) {
        block9: {
            OptionParser parser = new OptionParser();
            ArgumentAcceptingOptionSpec zkConnectOpt = parser.accepts("zookeeper.connect", "ZooKeeper connect string.").withRequiredArg().defaultsTo((Object)"localhost:2181", (Object[])new String[0]).ofType(String.class);
            ArgumentAcceptingOptionSpec groupOpt = parser.accepts("group", "Consumer group.").withRequiredArg().ofType(String.class);
            parser.accepts("help", "Print this message.");
            if (args.length == 0) {
                throw CommandLineUtils$.MODULE$.printUsageAndDie(parser, "Validate that all partitions have a consumer for a given consumer group.");
            }
            OptionSet options = parser.parse(args);
            if (options.has("help")) {
                parser.printHelpOn((OutputStream)System.out);
                System.exit(0);
            }
            CommandLineUtils$.MODULE$.checkRequiredArgs(parser, options, (Seq<OptionSpec<?>>)Predef$.MODULE$.wrapRefArray((Object[])new OptionSpec[]{groupOpt}));
            String zkConnect = (String)options.valueOf((OptionSpec)zkConnectOpt);
            String group = (String)options.valueOf((OptionSpec)groupOpt);
            try (ZkUtils zkUtils = null;){
                zkUtils = ZkUtils$.MODULE$.apply(zkConnect, 30000, 30000, JaasUtils.isZkSecurityEnabled());
                this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("zkConnect = %s; group = %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{zkConnect, group})));
                try {
                    if (this.validateRebalancingOperation(zkUtils, group)) {
                        Predef$.MODULE$.println((Object)"Rebalance operation successful !");
                        break block9;
                    }
                    Predef$.MODULE$.println((Object)"Rebalance operation failed !");
                }
                catch (Throwable e2) {
                    this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Error while verifying current rebalancing operation", (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e2);
                }
            }
        }
    }

    private boolean validateRebalancingOperation(ZkUtils zkUtils, String group) {
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Verifying rebalancing operation for consumer group " + group);
        BooleanRef rebalanceSucceeded = BooleanRef.create((boolean)true);
        Map<String, List<ConsumerThreadId>> consumersPerTopicMap = zkUtils.getConsumersPerTopic(group, false);
        Map<String, Seq<Object>> partitionsPerTopicMap = zkUtils.getPartitionsForTopics((Seq<String>)consumersPerTopicMap.keySet().toSeq());
        partitionsPerTopicMap.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            VerifyConsumerRebalance$.$anonfun$validateRebalancingOperation$2(this, zkUtils, group, rebalanceSucceeded, consumersPerTopicMap, x0$1);
            return BoxedUnit.UNIT;
        });
        return rebalanceSucceeded.elem;
    }

    public static final /* synthetic */ void $anonfun$validateRebalancingOperation$2(VerifyConsumerRebalance$ $this, ZkUtils zkUtils$1, String group$2, BooleanRef rebalanceSucceeded$1, Map consumersPerTopicMap$1, Tuple2 x0$1) {
        Seq<String> partitionsWithOwners;
        ZKGroupTopicDirs topicDirs;
        Seq partitions;
        String topic;
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            topic = (String)tuple2._1();
            partitions = (Seq)tuple2._2();
            topicDirs = new ZKGroupTopicDirs(group$2, topic);
            $this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Alive partitions for topic %s are %s ")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topic, partitions.toString()})));
            $this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Alive consumers for topic %s => %s ")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topic, consumersPerTopicMap$1.get((Object)topic)})));
            partitionsWithOwners = zkUtils$1.getChildrenParentMayNotExist(topicDirs.consumerOwnerDir());
            if (partitionsWithOwners.isEmpty()) {
                $this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "No owners for any partitions for topic " + topic);
                rebalanceSucceeded$1.elem = false;
            }
        } else {
            throw new MatchError((Object)tuple2);
        }
        $this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Children of " + topicDirs.consumerOwnerDir() + " = " + partitionsWithOwners.toString());
        Option consumerIdsForTopic = consumersPerTopicMap$1.get((Object)topic);
        partitions.foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)partition -> {
            String string;
            String partitionOwnerPath;
            Option option;
            if (!partitionsWithOwners.contains((Object)((Object)BoxesRunTime.boxToInteger((int)partition)).toString())) {
                $this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("No owner for partition [%s,%d]")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topic, BoxesRunTime.boxToInteger((int)partition)})));
                rebalanceSucceeded$1.elem = false;
            }
            if ((option = (Option)zkUtils$1.readDataMaybeNull(partitionOwnerPath = topicDirs.consumerOwnerDir() + "/" + partition)._1()) instanceof Some) {
                String m;
                Some some = (Some)option;
                string = m = (String)some.value();
            } else if (None$.MODULE$.equals(option)) {
                string = null;
            } else {
                throw new MatchError((Object)option);
            }
            String partitionOwner = string;
            if (partitionOwner == null) {
                $this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("No owner for partition [%s,%d]")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topic, BoxesRunTime.boxToInteger((int)partition)})));
                rebalanceSucceeded$1.elem = false;
            } else {
                Option option2 = consumerIdsForTopic;
                if (option2 instanceof Some) {
                    BoxedUnit boxedUnit;
                    Some some = (Some)option2;
                    List consumerIds = (List)some.value();
                    if (!((LinearSeqOptimized)consumerIds.map((Function1 & Serializable & scala.Serializable)c -> c.toString(), List$.MODULE$.canBuildFrom())).contains((Object)partitionOwner)) {
                        $this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Owner %s for partition [%s,%d] is not a valid member of consumer group %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{partitionOwner, topic, BoxesRunTime.boxToInteger((int)partition), group$2})));
                        rebalanceSucceeded$1.elem = false;
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        $this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Owner of partition [%s,%d] is %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topic, BoxesRunTime.boxToInteger((int)partition), partitionOwner})));
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    BoxedUnit boxedUnit2 = boxedUnit;
                } else if (None$.MODULE$.equals(option2)) {
                    $this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "No consumer ids registered for topic " + topic);
                    rebalanceSucceeded$1.elem = false;
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else {
                    throw new MatchError((Object)option2);
                }
            }
        });
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    private VerifyConsumerRebalance$() {
        MODULE$ = this;
        Logging.$init$(this);
    }
}

