/*
 * Decompiled with CFR 0.152.
 */
package kafka.cluster;

import java.io.Serializable;
import kafka.cluster.Broker;
import kafka.cluster.EndPoint;
import kafka.cluster.EndPoint$;
import kafka.common.BrokerNotAvailableException;
import kafka.common.KafkaException;
import kafka.utils.Json$;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.protocol.SecurityProtocol;
import org.apache.kafka.common.utils.Time;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class Broker$
implements scala.Serializable {
    public static Broker$ MODULE$;
    private final String HostKey;
    private final String PortKey;
    private final String VersionKey;
    private final String EndpointsKey;
    private final String RackKey;
    private final String JmxPortKey;
    private final String ListenerSecurityProtocolMapKey;
    private final String TimestampKey;

    static {
        new Broker$();
    }

    private String HostKey() {
        return this.HostKey;
    }

    private String PortKey() {
        return this.PortKey;
    }

    private String VersionKey() {
        return this.VersionKey;
    }

    private String EndpointsKey() {
        return this.EndpointsKey;
    }

    private String RackKey() {
        return this.RackKey;
    }

    private String JmxPortKey() {
        return this.JmxPortKey;
    }

    private String ListenerSecurityProtocolMapKey() {
        return this.ListenerSecurityProtocolMapKey;
    }

    private String TimestampKey() {
        return this.TimestampKey;
    }

    public Broker createBroker(int id, String brokerInfoString) {
        Broker broker;
        if (brokerInfoString == null) {
            throw new BrokerNotAvailableException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Broker id ", " does not exist"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)id)})));
        }
        try {
            Seq seq;
            scala.collection.immutable.Map brokerInfo;
            Option<Object> option = Json$.MODULE$.parseFull(brokerInfoString);
            if (option instanceof Some) {
                Some some = (Some)option;
                Object m = some.value();
                brokerInfo = (scala.collection.immutable.Map)m;
                int version = BoxesRunTime.unboxToInt((Object)brokerInfo.apply((Object)this.VersionKey()));
                if (version < 1) {
                    throw new KafkaException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unsupported version of broker registration: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{brokerInfoString})));
                }
                if (version == 1) {
                    String host = (String)brokerInfo.apply((Object)this.HostKey());
                    int port = BoxesRunTime.unboxToInt((Object)brokerInfo.apply((Object)this.PortKey()));
                    SecurityProtocol securityProtocol = SecurityProtocol.PLAINTEXT;
                    EndPoint endPoint = new EndPoint(host, port, ListenerName.forSecurityProtocol((SecurityProtocol)securityProtocol), securityProtocol);
                    seq = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new EndPoint[]{endPoint}));
                } else {
                    Option securityProtocolMap = brokerInfo.get((Object)this.ListenerSecurityProtocolMapKey()).map((Function1 & Serializable & scala.Serializable)x$1 -> (scala.collection.immutable.Map)((scala.collection.immutable.Map)x$1).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                        Tuple2 tuple2 = x0$1;
                        if (tuple2 == null) {
                            throw new MatchError((Object)tuple2);
                        }
                        String listenerName = (String)tuple2._1();
                        String securityProtocol = (String)tuple2._2();
                        Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new ListenerName(listenerName)), (Object)SecurityProtocol.forName((String)securityProtocol));
                        return tuple22;
                    }, Map$.MODULE$.canBuildFrom()));
                    List listeners = (List)brokerInfo.apply((Object)this.EndpointsKey());
                    seq = (Seq)listeners.map((Function1 & Serializable & scala.Serializable)x$2 -> EndPoint$.MODULE$.createEndPoint((String)x$2, (Option<Map<ListenerName, SecurityProtocol>>)securityProtocolMap), List$.MODULE$.canBuildFrom());
                }
            } else {
                if (None$.MODULE$.equals(option)) {
                    throw new BrokerNotAvailableException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Broker id ", " does not exist"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)id)})));
                }
                throw new MatchError(option);
            }
            Seq endpoints = seq;
            Option rack = brokerInfo.get((Object)this.RackKey()).filter((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)Broker$.$anonfun$createBroker$4(x$3))).map((Function1 & Serializable & scala.Serializable)x$4 -> (String)x$4);
            Broker broker2 = new Broker(id, (Seq<EndPoint>)endpoints, (Option<String>)rack);
            broker = broker2;
        }
        catch (Throwable t) {
            throw new KafkaException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to parse the broker info from zookeeper: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{brokerInfoString})), t);
        }
        return broker;
    }

    public String toJson(int version, int id, String host, int port, Seq<EndPoint> advertisedEndpoints, int jmxPort, Option<String> rack2) {
        scala.collection.mutable.Map jsonMap = (scala.collection.mutable.Map)scala.collection.mutable.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.VersionKey()), (Object)BoxesRunTime.boxToInteger((int)version)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.HostKey()), (Object)host), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.PortKey()), (Object)BoxesRunTime.boxToInteger((int)port)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.EndpointsKey()), ((TraversableOnce)advertisedEndpoints.map((Function1 & Serializable & scala.Serializable)x$5 -> x$5.connectionString(), Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(String.class))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.JmxPortKey()), (Object)BoxesRunTime.boxToInteger((int)jmxPort)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.TimestampKey()), (Object)((Object)BoxesRunTime.boxToLong((long)Time.SYSTEM.milliseconds())).toString())}));
        rack2.foreach((Function1 & Serializable & scala.Serializable)rack -> version >= 3 ? jsonMap.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.RackKey()), rack)) : BoxedUnit.UNIT);
        Object object = version >= 4 ? jsonMap.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.ListenerSecurityProtocolMapKey()), (Object)((TraversableOnce)advertisedEndpoints.map((Function1 & Serializable & scala.Serializable)endPoint -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)endPoint.listenerName().value()), (Object)endPoint.securityProtocol().name), Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms()))) : BoxedUnit.UNIT;
        return Json$.MODULE$.encode(jsonMap);
    }

    public Broker apply(int id, Seq<EndPoint> endPoints, Option<String> rack) {
        return new Broker(id, endPoints, rack);
    }

    public Option<Tuple3<Object, Seq<EndPoint>, Option<String>>> unapply(Broker x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)new Tuple3((Object)BoxesRunTime.boxToInteger((int)x$0.id()), x$0.endPoints(), x$0.rack()));
    }

    private Object readResolve() {
        return MODULE$;
    }

    public static final /* synthetic */ boolean $anonfun$createBroker$4(Object x$3) {
        return x$3 != null;
    }

    private Broker$() {
        MODULE$ = this;
        this.HostKey = "host";
        this.PortKey = "port";
        this.VersionKey = "version";
        this.EndpointsKey = "endpoints";
        this.RackKey = "rack";
        this.JmxPortKey = "jmx_port";
        this.ListenerSecurityProtocolMapKey = "listener_security_protocol_map";
        this.TimestampKey = "timestamp";
    }
}

