/*
 * Decompiled with CFR 0.152.
 */
package kafka.cluster;

import java.io.Serializable;
import kafka.cluster.Partition;
import kafka.cluster.Replica$;
import kafka.common.KafkaException;
import kafka.log.Log;
import kafka.log.Log$;
import kafka.server.LogOffsetMetadata;
import kafka.server.LogOffsetMetadata$;
import kafka.server.LogReadResult;
import kafka.server.epoch.LeaderEpochCache;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.OffsetOutOfRangeException;
import org.apache.kafka.common.utils.Time;
import org.apache.log4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.StringBuilder;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@ScalaSignature(bytes="\u0006\u0001\u0005}g\u0001B\u0001\u0003\u0001\u001d\u0011qAU3qY&\u001c\u0017M\u0003\u0002\u0004\t\u000591\r\\;ti\u0016\u0014(\"A\u0003\u0002\u000b-\fgm[1\u0004\u0001M\u0019\u0001\u0001\u0003\b\u0011\u0005%aQ\"\u0001\u0006\u000b\u0003-\tQa]2bY\u0006L!!\u0004\u0006\u0003\r\u0005s\u0017PU3g!\ty!#D\u0001\u0011\u0015\t\tB!A\u0003vi&d7/\u0003\u0002\u0014!\t9Aj\\4hS:<\u0007\u0002C\u000b\u0001\u0005\u000b\u0007I\u0011\u0001\f\u0002\u0011\t\u0014xn[3s\u0013\u0012,\u0012a\u0006\t\u0003\u0013aI!!\u0007\u0006\u0003\u0007%sG\u000f\u0003\u0005\u001c\u0001\t\u0005\t\u0015!\u0003\u0018\u0003%\u0011'o\\6fe&#\u0007\u0005\u0003\u0005\u001e\u0001\t\u0015\r\u0011\"\u0001\u001f\u0003%\u0001\u0018M\u001d;ji&|g.F\u0001 !\t\u0001\u0013%D\u0001\u0003\u0013\t\u0011#AA\u0005QCJ$\u0018\u000e^5p]\"AA\u0005\u0001B\u0001B\u0003%q$\u0001\u0006qCJ$\u0018\u000e^5p]\u0002B\u0001B\n\u0001\u0003\u0002\u0003\u0006IaJ\u0001\u0005i&lW\r\u0005\u0002)c5\t\u0011F\u0003\u0002\u0012U)\u00111\u0006L\u0001\u0007G>lWn\u001c8\u000b\u0005\u0015i#B\u0001\u00180\u0003\u0019\t\u0007/Y2iK*\t\u0001'A\u0002pe\u001eL!AM\u0015\u0003\tQKW.\u001a\u0005\ti\u0001\u0011\t\u0011)A\u0005k\u0005I\u0012N\\5uS\u0006d\u0007*[4i/\u0006$XM]7be.4\u0016\r\\;f!\tIa'\u0003\u00028\u0015\t!Aj\u001c8h\u0011!I\u0004A!b\u0001\n\u0003Q\u0014a\u00017pOV\t1\bE\u0002\nyyJ!!\u0010\u0006\u0003\r=\u0003H/[8o!\ty\u0014)D\u0001A\u0015\tID!\u0003\u0002C\u0001\n\u0019Aj\\4\t\u0011\u0011\u0003!\u0011!Q\u0001\nm\nA\u0001\\8hA!)a\t\u0001C\u0001\u000f\u00061A(\u001b8jiz\"b\u0001S%K\u00172k\u0005C\u0001\u0011\u0001\u0011\u0015)R\t1\u0001\u0018\u0011\u0015iR\t1\u0001 \u0011\u001d1S\t%AA\u0002\u001dBq\u0001N#\u0011\u0002\u0003\u0007Q\u0007C\u0004:\u000bB\u0005\t\u0019A\u001e\t\r=\u0003\u0001\u0015)\u0003Q\u0003UA\u0017n\u001a5XCR,'/\\1sW6+G/\u00193bi\u0006\u0004\"!\u0015+\u000e\u0003IS!a\u0015\u0003\u0002\rM,'O^3s\u0013\t)&KA\tM_\u001e|eMZ:fi6+G/\u00193bi\u0006D#AT,\u0011\u0005%A\u0016BA-\u000b\u0005!1x\u000e\\1uS2,\u0007BB.\u0001A\u0003&\u0001+\u0001\u000bm_\u001e,e\u000eZ(gMN,G/T3uC\u0012\fG/\u0019\u0015\u00035^CaA\u0018\u0001!B\u0013)\u0014aD0m_\u001e\u001cF/\u0019:u\u001f\u001a47/\u001a;)\u0005u;\u0006BB1\u0001A\u0003&Q'A\u000emCN$h)\u001a;dQ2+\u0017\rZ3s\u0019><WI\u001c3PM\u001a\u001cX\r\u001e\u0015\u0003A^Ca\u0001\u001a\u0001!B\u0013)\u0014a\u00047bgR4U\r^2i)&lW-T:)\u0005\r<\u0006BB4\u0001A\u0003&Q'A\n`Y\u0006\u001cHoQ1vO\"$X\u000b\u001d+j[\u0016l5\u000f\u000b\u0002g/\"9!\u000e\u0001b\u0001\n\u0003Y\u0017A\u0004;pa&\u001c\u0007+\u0019:uSRLwN\\\u000b\u0002YB\u0011QN\\\u0007\u0002U%\u0011qN\u000b\u0002\u000f)>\u0004\u0018n\u0019)beRLG/[8o\u0011\u0019\t\b\u0001)A\u0005Y\u0006yAo\u001c9jGB\u000b'\u000f^5uS>t\u0007\u0005C\u0003t\u0001\u0011\u0005A/A\u0004jg2{7-\u00197\u0016\u0003U\u0004\"!\u0003<\n\u0005]T!a\u0002\"p_2,\u0017M\u001c\u0005\u0006s\u0002!\tA_\u0001\u0013Y\u0006\u001cHoQ1vO\"$X\u000b\u001d+j[\u0016l5/F\u00016\u0011\u001da\bA1A\u0005\u0002u\fa!\u001a9pG\"\u001cX#\u0001@\u0011\u0007%at\u0010\u0005\u0003\u0002\u0002\u0005\u001dQBAA\u0002\u0015\r\t)AU\u0001\u0006KB|7\r[\u0005\u0005\u0003\u0013\t\u0019A\u0001\tMK\u0006$WM]#q_\u000eD7)Y2iK\"9\u0011Q\u0002\u0001!\u0002\u0013q\u0018aB3q_\u000eD7\u000f\t\u0005\b\u0003#\u0001A\u0011AA\n\u0003M)\b\u000fZ1uK2{wMU3bIJ+7/\u001e7u)\u0011\t)\"a\u0007\u0011\u0007%\t9\"C\u0002\u0002\u001a)\u0011A!\u00168ji\"A\u0011QDA\b\u0001\u0004\ty\"A\u0007m_\u001e\u0014V-\u00193SKN,H\u000e\u001e\t\u0004#\u0006\u0005\u0012bAA\u0012%\niAj\\4SK\u0006$'+Z:vYRDq!a\n\u0001\t\u0003\tI#A\u000bsKN,G\u000fT1ti\u000e\u000bWo\u001a5u+B$\u0016.\\3\u0015\u0011\u0005U\u00111FA\u0018\u0003gAq!!\f\u0002&\u0001\u0007Q'A\u000bdkJdU-\u00193fe2{w-\u00128e\u001f\u001a47/\u001a;\t\u000f\u0005E\u0012Q\u0005a\u0001k\u0005I1-\u001e:US6,Wj\u001d\u0005\u0007s\u0006\u0015\u0002\u0019A\u001b\t\u000f\u0005]\u0002\u0001\"\u0003\u0002:\u0005\u0001Bn\\4F]\u0012|eMZ:fi~#S-\u001d\u000b\u0005\u0003+\tY\u0004C\u0004\u0002>\u0005U\u0002\u0019\u0001)\u0002\u001f9,w\u000fT8h\u000b:$wJ\u001a4tKRDq!!\u0011\u0001\t\u0003\t\u0019%\u0001\u0007m_\u001e,e\u000eZ(gMN,G/F\u0001Q\u0011\u001d\t9\u0005\u0001C\u0001\u0003\u0013\nA$\\1zE\u0016Len\u0019:f[\u0016tG\u000fT8h'R\f'\u000f^(gMN,G\u000f\u0006\u0003\u0002\u0016\u0005-\u0003bBA'\u0003\u000b\u0002\r!N\u0001\u0007_\u001a47/\u001a;\t\u000f\u0005E\u0003\u0001\"\u0003\u0002T\u0005\u0011Bn\\4Ti\u0006\u0014Ho\u00144gg\u0016$x\fJ3r)\u0011\t)\"!\u0016\t\u000f\u0005]\u0013q\na\u0001k\u0005\tb.Z<M_\u001e\u001cF/\u0019:u\u001f\u001a47/\u001a;\t\r\u0005m\u0003\u0001\"\u0001{\u00039awnZ*uCJ$xJ\u001a4tKRDq!a\u0018\u0001\t\u0003\t\t'A\tiS\u001eDw+\u0019;fe6\f'o[0%KF$B!!\u0006\u0002d!9\u0011QMA/\u0001\u0004\u0001\u0016\u0001\u00058fo\"Kw\r[,bi\u0016\u0014X.\u0019:l\u0011\u001d\tI\u0007\u0001C\u0001\u0003\u0007\nQ\u0002[5hQ^\u000bG/\u001a:nCJ\\\u0007bBA7\u0001\u0011\u0005\u00111I\u0001\u0011Y\u0006\u001cHo\u0015;bE2,wJ\u001a4tKRDq!!\u001d\u0001\t\u0003\t\u0019(\u0001\u0010d_:4XM\u001d;I/R{Gj\\2bY>3gm]3u\u001b\u0016$\u0018\rZ1uCR\u0011\u0011Q\u0003\u0005\b\u0003o\u0002A\u0011IA=\u0003\u0019)\u0017/^1mgR\u0019Q/a\u001f\t\u0011\u0005u\u0014Q\u000fa\u0001\u0003\u007f\nA\u0001\u001e5biB\u0019\u0011\"!!\n\u0007\u0005\r%BA\u0002B]fDq!a\"\u0001\t\u0003\nI)\u0001\u0005iCND7i\u001c3f)\u00059\u0002bBAG\u0001\u0011\u0005\u0013qR\u0001\ti>\u001cFO]5oOR\u0011\u0011\u0011\u0013\t\u0005\u0003'\u000b\tK\u0004\u0003\u0002\u0016\u0006u\u0005cAAL\u00155\u0011\u0011\u0011\u0014\u0006\u0004\u000373\u0011A\u0002\u001fs_>$h(C\u0002\u0002 *\ta\u0001\u0015:fI\u00164\u0017\u0002BAR\u0003K\u0013aa\u0015;sS:<'bAAP\u0015\u001dI\u0011\u0011\u0016\u0002\u0002\u0002#\u0005\u00111V\u0001\b%\u0016\u0004H.[2b!\r\u0001\u0013Q\u0016\u0004\t\u0003\t\t\t\u0011#\u0001\u00020N\u0019\u0011Q\u0016\u0005\t\u000f\u0019\u000bi\u000b\"\u0001\u00024R\u0011\u00111\u0016\u0005\u000b\u0003o\u000bi+%A\u0005\u0002\u0005e\u0016a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$3'\u0006\u0002\u0002<*\u001aq%!0,\u0005\u0005}\u0006\u0003BAa\u0003\u0017l!!a1\u000b\t\u0005\u0015\u0017qY\u0001\nk:\u001c\u0007.Z2lK\u0012T1!!3\u000b\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003\u001b\f\u0019MA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016D!\"!5\u0002.F\u0005I\u0011AAj\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%iU\u0011\u0011Q\u001b\u0016\u0004k\u0005u\u0006BCAm\u0003[\u000b\n\u0011\"\u0001\u0002\\\u0006YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uIU*\"!!8+\u0007m\ni\f")
public class Replica
implements Logging {
    private final int brokerId;
    private final Partition partition;
    private final Option<Log> log;
    private volatile LogOffsetMetadata highWatermarkMetadata;
    private volatile LogOffsetMetadata logEndOffsetMetadata;
    private volatile long _logStartOffset;
    private volatile long lastFetchLeaderLogEndOffset;
    private volatile long lastFetchTimeMs;
    private volatile long _lastCaughtUpTimeMs;
    private final TopicPartition topicPartition;
    private final Option<LeaderEpochCache> epochs;
    private final String loggerName;
    private Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    private volatile boolean bitmap$0;

    public static Option<Log> $lessinit$greater$default$5() {
        return Replica$.MODULE$.$lessinit$greater$default$5();
    }

    public static long $lessinit$greater$default$4() {
        return Replica$.MODULE$.$lessinit$greater$default$4();
    }

    public static Time $lessinit$greater$default$3() {
        return Replica$.MODULE$.$lessinit$greater$default$3();
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public Object trace(Function0<Throwable> e) {
        return Logging.trace$(this, e);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public void swallowTrace(Function0<BoxedUnit> action) {
        Logging.swallowTrace$(this, action);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public Object debug(Function0<Throwable> e) {
        return Logging.debug$(this, e);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void swallowDebug(Function0<BoxedUnit> action) {
        Logging.swallowDebug$(this, action);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public Object info(Function0<Throwable> e) {
        return Logging.info$(this, e);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void swallowInfo(Function0<BoxedUnit> action) {
        Logging.swallowInfo$(this, action);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public Object warn(Function0<Throwable> e) {
        return Logging.warn$(this, e);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void swallowWarn(Function0<BoxedUnit> action) {
        Logging.swallowWarn$(this, action);
    }

    @Override
    public void swallow(Function0<BoxedUnit> action) {
        Logging.swallow$(this, action);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public Object error(Function0<Throwable> e) {
        return Logging.error$(this, e);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void swallowError(Function0<BoxedUnit> action) {
        Logging.swallowError$(this, action);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public Object fatal(Function0<Throwable> e) {
        return Logging.fatal$(this, e);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    private Logger logger$lzycompute() {
        Replica replica = this;
        synchronized (replica) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        return !this.bitmap$0 ? this.logger$lzycompute() : this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    @Override
    public Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    @Override
    public void kafka$utils$Logging$_setter_$loggerName_$eq(String x$1) {
        this.loggerName = x$1;
    }

    @Override
    public final void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ x$1) {
        this.kafka$utils$Logging$$log4jController = x$1;
    }

    public int brokerId() {
        return this.brokerId;
    }

    public Partition partition() {
        return this.partition;
    }

    public Option<Log> log() {
        return this.log;
    }

    public TopicPartition topicPartition() {
        return this.topicPartition;
    }

    public boolean isLocal() {
        return this.log().isDefined();
    }

    public long lastCaughtUpTimeMs() {
        return this._lastCaughtUpTimeMs;
    }

    public Option<LeaderEpochCache> epochs() {
        return this.epochs;
    }

    public void updateLogReadResult(LogReadResult logReadResult) {
        if (logReadResult.info().fetchOffsetMetadata().messageOffset() >= logReadResult.leaderLogEndOffset()) {
            this._lastCaughtUpTimeMs = package$.MODULE$.max(this._lastCaughtUpTimeMs, logReadResult.fetchTimeMs());
        } else if (logReadResult.info().fetchOffsetMetadata().messageOffset() >= this.lastFetchLeaderLogEndOffset) {
            this._lastCaughtUpTimeMs = package$.MODULE$.max(this._lastCaughtUpTimeMs, this.lastFetchTimeMs);
        }
        this.logStartOffset_$eq(logReadResult.followerLogStartOffset());
        this.logEndOffset_$eq(logReadResult.info().fetchOffsetMetadata());
        this.lastFetchLeaderLogEndOffset = logReadResult.leaderLogEndOffset();
        this.lastFetchTimeMs = logReadResult.fetchTimeMs();
    }

    public void resetLastCaughtUpTime(long curLeaderLogEndOffset, long curTimeMs, long lastCaughtUpTimeMs) {
        this.lastFetchLeaderLogEndOffset = curLeaderLogEndOffset;
        this.lastFetchTimeMs = curTimeMs;
        this._lastCaughtUpTimeMs = lastCaughtUpTimeMs;
    }

    private void logEndOffset_$eq(LogOffsetMetadata newLogEndOffset) {
        if (this.isLocal()) {
            throw new KafkaException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Should not set log end offset on partition ", "'s local replica ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topicPartition(), BoxesRunTime.boxToInteger((int)this.brokerId())})));
        }
        this.logEndOffsetMetadata = newLogEndOffset;
        this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Setting log end offset for replica ", " for partition ", " to [", "]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.brokerId()), this.topicPartition(), $this.logEndOffsetMetadata})));
    }

    public LogOffsetMetadata logEndOffset() {
        return this.isLocal() ? ((Log)this.log().get()).logEndOffsetMetadata() : this.logEndOffsetMetadata;
    }

    public void maybeIncrementLogStartOffset(long offset) {
        if (this.isLocal()) {
            if (this.highWatermark().messageOffset() < offset) {
                throw new OffsetOutOfRangeException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The specified offset ", " is higher than the high watermark"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)offset)})) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" ", " of the partition ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.highWatermark().messageOffset()), this.topicPartition()})));
            }
        } else {
            throw new KafkaException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Should not try to delete records on partition ", "'s non-local replica ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topicPartition(), BoxesRunTime.boxToInteger((int)this.brokerId())})));
        }
        ((Log)this.log().get()).maybeIncrementLogStartOffset(offset);
    }

    private void logStartOffset_$eq(long newLogStartOffset) {
        if (this.isLocal()) {
            throw new KafkaException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Should not set log start offset on partition ", "'s local replica ", " "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topicPartition(), BoxesRunTime.boxToInteger((int)this.brokerId())})) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"without attempting to delete records of the log"})).s((Seq)Nil$.MODULE$));
        }
        this._logStartOffset = newLogStartOffset;
        this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Setting log start offset for remote replica ", " for partition ", " to [", "]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.brokerId()), this.topicPartition(), BoxesRunTime.boxToLong((long)newLogStartOffset)})));
    }

    public long logStartOffset() {
        return this.isLocal() ? ((Log)this.log().get()).logStartOffset() : this._logStartOffset;
    }

    public void highWatermark_$eq(LogOffsetMetadata newHighWatermark) {
        if (!this.isLocal()) {
            throw new KafkaException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Should not set high watermark on partition ", "'s non-local replica ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topicPartition(), BoxesRunTime.boxToInteger((int)this.brokerId())})));
        }
        this.highWatermarkMetadata = newHighWatermark;
        this.log().foreach((Function1 & Serializable & scala.Serializable)x$2 -> {
            x$2.onHighWatermarkIncremented(newHighWatermark.messageOffset());
            return BoxedUnit.UNIT;
        });
        this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Setting high watermark for replica ", " partition ", " to [", "]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.brokerId()), this.topicPartition(), newHighWatermark})));
    }

    public LogOffsetMetadata highWatermark() {
        return this.highWatermarkMetadata;
    }

    public LogOffsetMetadata lastStableOffset() {
        return (LogOffsetMetadata)this.log().map((Function1 & Serializable & scala.Serializable)log -> {
            Some some;
            LogOffsetMetadata offsetMetadata;
            Option<LogOffsetMetadata> option = log.firstUnstableOffset();
            LogOffsetMetadata logOffsetMetadata = option instanceof Some && (offsetMetadata = (LogOffsetMetadata)(some = (Some)option).value()).messageOffset() < this.highWatermark().messageOffset() ? offsetMetadata : this.highWatermark();
            return logOffsetMetadata;
        }).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new KafkaException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Cannot fetch last stable offset on partition ", "'s "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topicPartition()})) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"non-local replica ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.brokerId())})));
        });
    }

    public void convertHWToLocalOffsetMetadata() {
        if (!this.isLocal()) {
            throw new KafkaException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Should not construct complete high watermark on partition ", "'s non-local replica ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topicPartition(), BoxesRunTime.boxToInteger((int)this.brokerId())})));
        }
        this.highWatermarkMetadata = ((Log)this.log().get()).convertToOffsetMetadata(this.highWatermarkMetadata.messageOffset());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object that) {
        Object object = that;
        if (!(object instanceof Replica)) return false;
        Replica replica = (Replica)object;
        if (this.brokerId() != replica.brokerId()) return false;
        TopicPartition topicPartition = this.topicPartition();
        TopicPartition topicPartition2 = replica.topicPartition();
        if (topicPartition != null) {
            if (!topicPartition.equals(topicPartition2)) return false;
            return true;
        }
        if (topicPartition2 == null) return true;
        return false;
    }

    public int hashCode() {
        return 31 + this.topicPartition().hashCode() + 17 * this.brokerId();
    }

    public String toString() {
        BoxedUnit boxedUnit;
        StringBuilder replicaString = new StringBuilder();
        replicaString.append("ReplicaId: " + this.brokerId());
        replicaString.append("; Topic: " + this.partition().topic());
        replicaString.append("; Partition: " + this.partition().partitionId());
        replicaString.append("; isLocal: " + this.isLocal());
        replicaString.append("; lastCaughtUpTimeMs: " + this.lastCaughtUpTimeMs());
        if (this.isLocal()) {
            replicaString.append("; Highwatermark: " + this.highWatermark());
            boxedUnit = replicaString.append("; LastStableOffset: " + this.lastStableOffset());
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return replicaString.toString();
    }

    public Replica(int brokerId, Partition partition, Time time, long initialHighWatermarkValue, Option<Log> log) {
        this.brokerId = brokerId;
        this.partition = partition;
        this.log = log;
        Logging.$init$(this);
        this.highWatermarkMetadata = new LogOffsetMetadata(initialHighWatermarkValue, LogOffsetMetadata$.MODULE$.$lessinit$greater$default$2(), LogOffsetMetadata$.MODULE$.$lessinit$greater$default$3());
        this.logEndOffsetMetadata = LogOffsetMetadata$.MODULE$.UnknownOffsetMetadata();
        this._logStartOffset = Log$.MODULE$.UnknownLogStartOffset();
        this.lastFetchLeaderLogEndOffset = 0L;
        this.lastFetchTimeMs = 0L;
        this._lastCaughtUpTimeMs = 0L;
        this.topicPartition = partition.topicPartition();
        this.epochs = log.map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.leaderEpochCache());
    }
}

