/*
 * Decompiled with CFR 0.152.
 */
package kafka.coordinator.transaction;

import java.io.Serializable;
import kafka.coordinator.transaction.CompleteAbort$;
import kafka.coordinator.transaction.CompleteCommit$;
import kafka.coordinator.transaction.Dead$;
import kafka.coordinator.transaction.Empty$;
import kafka.coordinator.transaction.Ongoing$;
import kafka.coordinator.transaction.PrepareAbort$;
import kafka.coordinator.transaction.PrepareCommit$;
import kafka.coordinator.transaction.TransactionMetadata$;
import kafka.coordinator.transaction.TransactionState;
import kafka.coordinator.transaction.TxnTransitMetadata;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import org.apache.kafka.common.TopicPartition;
import org.apache.log4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.SetLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction2;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@ScalaSignature(bytes="\u0006\u0001\t\u0015vAB\u0001\u0003\u0011\u0003\u0011\u0001\"A\nUe\u0006t7/Y2uS>tW*\u001a;bI\u0006$\u0018M\u0003\u0002\u0004\t\u0005YAO]1og\u0006\u001cG/[8o\u0015\t)a!A\u0006d_>\u0014H-\u001b8bi>\u0014(\"A\u0004\u0002\u000b-\fgm[1\u0011\u0005%QQ\"\u0001\u0002\u0007\r-\u0011\u0001\u0012\u0001\u0002\r\u0005M!&/\u00198tC\u000e$\u0018n\u001c8NKR\fG-\u0019;b'\tQQ\u0002\u0005\u0002\u000f#5\tqBC\u0001\u0011\u0003\u0015\u00198-\u00197b\u0013\t\u0011rB\u0001\u0004B]f\u0014VM\u001a\u0005\u0006))!\tAF\u0001\u0007y%t\u0017\u000e\u001e \u0004\u0001Q\t\u0001\u0002C\u0003\u0019\u0015\u0011\u0005\u0011$A\u0003baBd\u0017\u0010F\u0006\u001b\u0005\u007f\u0011\tEa\u0011\u0003F\t\u001d\u0003CA\u0005\u001c\r\u0015Y!\u0001\u0001\u0002\u001d'\rYR\"\b\t\u0003=\u0005j\u0011a\b\u0006\u0003A\u0019\tQ!\u001e;jYNL!AI\u0010\u0003\u000f1{wmZ5oO\"AAe\u0007BC\u0002\u0013\u0005Q%A\bue\u0006t7/Y2uS>t\u0017\r\\%e+\u00051\u0003CA\u0014/\u001d\tAC\u0006\u0005\u0002*\u001f5\t!F\u0003\u0002,+\u00051AH]8pizJ!!L\b\u0002\rA\u0013X\rZ3g\u0013\ty\u0003G\u0001\u0004TiJLgn\u001a\u0006\u0003[=A\u0001BM\u000e\u0003\u0002\u0003\u0006IAJ\u0001\u0011iJ\fgn]1di&|g.\u00197JI\u0002B\u0001\u0002N\u000e\u0003\u0002\u0004%\t!N\u0001\u000baJ|G-^2fe&#W#\u0001\u001c\u0011\u000599\u0014B\u0001\u001d\u0010\u0005\u0011auN\\4\t\u0011iZ\"\u00111A\u0005\u0002m\na\u0002\u001d:pIV\u001cWM]%e?\u0012*\u0017\u000f\u0006\u0002=\u007fA\u0011a\"P\u0005\u0003}=\u0011A!\u00168ji\"9\u0001)OA\u0001\u0002\u00041\u0014a\u0001=%c!A!i\u0007B\u0001B\u0003&a'A\u0006qe>$WoY3s\u0013\u0012\u0004\u0003\u0002\u0003#\u001c\u0005\u0003\u0007I\u0011A#\u0002\u001bA\u0014x\u000eZ;dKJ,\u0005o\\2i+\u00051\u0005C\u0001\bH\u0013\tAuBA\u0003TQ>\u0014H\u000f\u0003\u0005K7\t\u0005\r\u0011\"\u0001L\u0003E\u0001(o\u001c3vG\u0016\u0014X\t]8dQ~#S-\u001d\u000b\u0003y1Cq\u0001Q%\u0002\u0002\u0003\u0007a\t\u0003\u0005O7\t\u0005\t\u0015)\u0003G\u00039\u0001(o\u001c3vG\u0016\u0014X\t]8dQ\u0002B\u0001\u0002U\u000e\u0003\u0002\u0004%\t!U\u0001\ribtG+[7f_V$Xj]\u000b\u0002%B\u0011abU\u0005\u0003)>\u00111!\u00138u\u0011!16D!a\u0001\n\u00039\u0016\u0001\u0005;y]RKW.Z8vi6\u001bx\fJ3r)\ta\u0004\fC\u0004A+\u0006\u0005\t\u0019\u0001*\t\u0011i[\"\u0011!Q!\nI\u000bQ\u0002\u001e=o)&lWm\\;u\u001bN\u0004\u0003\u0002\u0003/\u001c\u0005\u0003\u0007I\u0011A/\u0002\u000bM$\u0018\r^3\u0016\u0003y\u0003\"!C0\n\u0005\u0001\u0014!\u0001\u0005+sC:\u001c\u0018m\u0019;j_:\u001cF/\u0019;f\u0011!\u00117D!a\u0001\n\u0003\u0019\u0017!C:uCR,w\fJ3r)\taD\rC\u0004AC\u0006\u0005\t\u0019\u00010\t\u0011\u0019\\\"\u0011!Q!\ny\u000baa\u001d;bi\u0016\u0004\u0003\u0002\u00035\u001c\u0005\u000b\u0007I\u0011A5\u0002\u001fQ|\u0007/[2QCJ$\u0018\u000e^5p]N,\u0012A\u001b\t\u0004WB\u0014X\"\u00017\u000b\u00055t\u0017aB7vi\u0006\u0014G.\u001a\u0006\u0003_>\t!bY8mY\u0016\u001cG/[8o\u0013\t\tHNA\u0002TKR\u0004\"a]>\u000e\u0003QT!!\u001e<\u0002\r\r|W.\\8o\u0015\t9qO\u0003\u0002ys\u00061\u0011\r]1dQ\u0016T\u0011A_\u0001\u0004_J<\u0017B\u0001?u\u00059!v\u000e]5d!\u0006\u0014H/\u001b;j_:D\u0001B`\u000e\u0003\u0002\u0003\u0006IA[\u0001\u0011i>\u0004\u0018n\u0019)beRLG/[8og\u0002B\u0011\"!\u0001\u001c\u0005\u0003\u0007I\u0011A\u001b\u0002#QDhn\u0015;beR$\u0016.\\3ti\u0006l\u0007\u000f\u0003\u0006\u0002\u0006m\u0011\t\u0019!C\u0001\u0003\u000f\tQ\u0003\u001e=o'R\f'\u000f\u001e+j[\u0016\u001cH/Y7q?\u0012*\u0017\u000fF\u0002=\u0003\u0013A\u0001\u0002QA\u0002\u0003\u0003\u0005\rA\u000e\u0005\n\u0003\u001bY\"\u0011!Q!\nY\n!\u0003\u001e=o'R\f'\u000f\u001e+j[\u0016\u001cH/Y7qA!\"\u00111BA\t!\rq\u00111C\u0005\u0004\u0003+y!\u0001\u0003<pY\u0006$\u0018\u000e\\3\t\u0013\u0005e1D!a\u0001\n\u0003)\u0014A\u0006;y]2\u000b7\u000f^+qI\u0006$X\rV5nKN$\u0018-\u001c9\t\u0015\u0005u1D!a\u0001\n\u0003\ty\"\u0001\u000euq:d\u0015m\u001d;Va\u0012\fG/\u001a+j[\u0016\u001cH/Y7q?\u0012*\u0017\u000fF\u0002=\u0003CA\u0001\u0002QA\u000e\u0003\u0003\u0005\rA\u000e\u0005\n\u0003KY\"\u0011!Q!\nY\nq\u0003\u001e=o\u0019\u0006\u001cH/\u00169eCR,G+[7fgR\fW\u000e\u001d\u0011)\t\u0005\r\u0012\u0011\u0003\u0005\u0007)m!\t!a\u000b\u0015#i\ti#a\f\u00022\u0005M\u0012QGA\u001c\u0003s\tY\u0004\u0003\u0004%\u0003S\u0001\rA\n\u0005\u0007i\u0005%\u0002\u0019\u0001\u001c\t\r\u0011\u000bI\u00031\u0001G\u0011\u0019\u0001\u0016\u0011\u0006a\u0001%\"1A,!\u000bA\u0002yCa\u0001[A\u0015\u0001\u0004Q\u0007\"CA\u0001\u0003S\u0001\n\u00111\u00017\u0011\u001d\tI\"!\u000bA\u0002YB\u0011\"a\u0010\u001c\u0001\u0004%\t!!\u0011\u0002\u0019A,g\u000eZ5oON#\u0018\r^3\u0016\u0005\u0005\r\u0003\u0003\u0002\b\u0002FyK1!a\u0012\u0010\u0005\u0019y\u0005\u000f^5p]\"I\u00111J\u000eA\u0002\u0013\u0005\u0011QJ\u0001\u0011a\u0016tG-\u001b8h'R\fG/Z0%KF$2\u0001PA(\u0011%\u0001\u0015\u0011JA\u0001\u0002\u0004\t\u0019\u0005\u0003\u0005\u0002Tm\u0001\u000b\u0015BA\"\u00035\u0001XM\u001c3j]\u001e\u001cF/\u0019;fA!9\u0011qK\u000e\u0005\u0002\u0005e\u0013!D1eIB\u000b'\u000f^5uS>t7\u000fF\u0002=\u00037B\u0001\"!\u0018\u0002V\u0001\u0007\u0011qL\u0001\u000ba\u0006\u0014H/\u001b;j_:\u001c\b#BA1\u0003G\u0012X\"\u00018\n\u0005Et\u0007bBA47\u0011\u0005\u0011\u0011N\u0001\u0010e\u0016lwN^3QCJ$\u0018\u000e^5p]R\u0019A(a\u001b\t\u000f\u00055\u0014Q\ra\u0001e\u0006qAo\u001c9jGB\u000b'\u000f^5uS>t\u0007bBA97\u0011\u0005\u00111O\u0001\u0011aJ,\u0007/\u0019:f\u001d>$&/\u00198tSR$\"!!\u001e\u0011\u0007%\t9(C\u0002\u0002z\t\u0011!\u0003\u0016=o)J\fgn]5u\u001b\u0016$\u0018\rZ1uC\"9\u0011QP\u000e\u0005\u0002\u0005M\u0014!\u00079sKB\f'/\u001a$f]\u000e,\u0007K]8ek\u000e,'/\u00129pG\"Dq!!!\u001c\t\u0003\t\u0019)A\u000fqe\u0016\u0004\u0018M]3J]\u000e\u0014X-\\3oiB\u0013x\u000eZ;dKJ,\u0005o\\2i)\u0019\t)(!\"\u0002\n\"9\u0011qQA@\u0001\u0004\u0011\u0016a\u00048foRCh\u000eV5nK>,H/T:\t\u000f\u0005-\u0015q\u0010a\u0001m\u0005yQ\u000f\u001d3bi\u0016$\u0016.\\3ti\u0006l\u0007\u000fC\u0004\u0002\u0010n!\t!!%\u00023A\u0014X\r]1sKB\u0013x\u000eZ;dKJLEMU8uCRLwN\u001c\u000b\t\u0003k\n\u0019*a&\u0002\u001a\"9\u0011QSAG\u0001\u00041\u0014!\u00048foB\u0013x\u000eZ;dKJLE\rC\u0004\u0002\b\u00065\u0005\u0019\u0001*\t\u000f\u0005-\u0015Q\u0012a\u0001m!9\u0011QT\u000e\u0005\u0002\u0005}\u0015\u0001\u00069sKB\f'/Z!eIB\u000b'\u000f^5uS>t7\u000f\u0006\u0004\u0002v\u0005\u0005\u0016q\u0016\u0005\t\u0003G\u000bY\n1\u0001\u0002&\u0006!\u0012\r\u001a3fIR{\u0007/[2QCJ$\u0018\u000e^5p]N\u0004R!a*\u0002.Jl!!!+\u000b\u0007\u0005-f.A\u0005j[6,H/\u00192mK&\u0019\u0011/!+\t\u000f\u0005-\u00151\u0014a\u0001m!9\u00111W\u000e\u0005\u0002\u0005U\u0016\u0001\u00069sKB\f'/Z!c_J$xJ]\"p[6LG\u000f\u0006\u0004\u0002v\u0005]\u00161\u0018\u0005\b\u0003s\u000b\t\f1\u0001_\u0003!qWm^*uCR,\u0007bBAF\u0003c\u0003\rA\u000e\u0005\b\u0003\u007f[B\u0011AAa\u0003=\u0001(/\u001a9be\u0016\u001cu.\u001c9mKR,G\u0003BA;\u0003\u0007Dq!a#\u0002>\u0002\u0007a\u0007C\u0004\u0002Hn!\t!a\u001d\u0002\u0017A\u0014X\r]1sK\u0012+\u0017\r\u001a\u0005\b\u0003\u0017\\B\u0011AAg\u0003aI7\u000f\u0015:pIV\u001cWM]#q_\u000eDW\t\u001f5bkN$X\rZ\u000b\u0003\u0003\u001f\u00042ADAi\u0013\r\t\u0019n\u0004\u0002\b\u0005>|G.Z1o\u0011\u001d\t9n\u0007C\u0005\u0003\u001b\fQ\u0003[1t!\u0016tG-\u001b8h)J\fgn]1di&|g\u000eC\u0004\u0002\\n!I!!8\u0002'A\u0014X\r]1sKR\u0013\u0018M\\:ji&|g\u000eV8\u0015!\u0005U\u0014q\\Aq\u0003G\f9/!;\u0002n\u0006E\bbBA]\u00033\u0004\rA\u0018\u0005\b\u0003+\u000bI\u000e1\u00017\u0011\u001d\t)/!7A\u0002\u0019\u000b\u0001B\\3x\u000bB|7\r\u001b\u0005\b\u0003\u000f\u000bI\u000e1\u0001S\u0011!\tY/!7A\u0002\u0005\u0015\u0016A\u00058foR{\u0007/[2QCJ$\u0018\u000e^5p]NDq!a<\u0002Z\u0002\u0007a'\u0001\u000boK^$\u0006P\\*uCJ$H+[7fgR\fW\u000e\u001d\u0005\b\u0003\u0017\u000bI\u000e1\u00017\u0011\u001d\t)p\u0007C\u0001\u0003o\fAcY8na2,G/\u001a+sC:\u001c\u0018\u000e^5p]R{Gc\u0001\u001f\u0002z\"A\u00111`Az\u0001\u0004\t)(A\bue\u0006t7/\u001b;NKR\fG-\u0019;b\u0011\u001d\typ\u0007C\u0005\u0005\u0003\t!C^1mS\u0012\u0004&o\u001c3vG\u0016\u0014X\t]8dQR!\u0011q\u001aB\u0002\u0011!\tY0!@A\u0002\u0005U\u0004b\u0002B\u00047\u0011%!\u0011B\u0001\u0017m\u0006d\u0017\u000e\u001a)s_\u0012,8-\u001a:Fa>\u001c\u0007NQ;naR!\u0011q\u001aB\u0006\u0011!\tYP!\u0002A\u0002\u0005U\u0004b\u0002B\b7\u0011%!\u0011C\u0001\u001ci\"\u0014xn^*uCR,GK]1og&$\u0018n\u001c8GC&dWO]3\u0015\u0007q\u0012\u0019\u0002\u0003\u0005\u0003\u0016\t5\u0001\u0019AA;\u0003I!\bP\u001c+sC:\u001c\u0018\u000e^'fi\u0006$\u0017\r^1\t\u000f\te1\u0004\"\u0001\u0002N\u0006Y\u0002/\u001a8eS:<GK]1og&$\u0018n\u001c8J]B\u0013xn\u001a:fgNDqA!\b\u001c\t\u0003\u0012y\"\u0001\u0005u_N#(/\u001b8h)\u00051\u0003b\u0002B\u00127\u0011\u0005#QE\u0001\u0007KF,\u0018\r\\:\u0015\t\u0005='q\u0005\u0005\t\u0005S\u0011\t\u00031\u0001\u0003,\u0005!A\u000f[1u!\rq!QF\u0005\u0004\u0005_y!aA!os\"9!1G\u000e\u0005B\tU\u0012\u0001\u00035bg\"\u001cu\u000eZ3\u0015\u0003IC3a\u0007B\u001d!\rq\"1H\u0005\u0004\u0005{y\"!\u00048p]RD'/Z1eg\u00064W\rC\u0003%/\u0001\u0007a\u0005C\u00035/\u0001\u0007a\u0007C\u0003E/\u0001\u0007a\tC\u0003Q/\u0001\u0007!\u000b\u0003\u0004\u0003J]\u0001\rAN\u0001\ni&lWm\u001d;b[BDa\u0001\u0007\u0006\u0005\u0002\t5C#\u0004\u000e\u0003P\tE#1\u000bB+\u0005/\u0012I\u0006\u0003\u0004%\u0005\u0017\u0002\rA\n\u0005\u0007i\t-\u0003\u0019\u0001\u001c\t\r\u0011\u0013Y\u00051\u0001G\u0011\u0019\u0001&1\na\u0001%\"1ALa\u0013A\u0002yCqA!\u0013\u0003L\u0001\u0007a\u0007C\u0004\u0003^)!\tAa\u0018\u0002\u0017\tLH/\u001a+p'R\fG/\u001a\u000b\u0004=\n\u0005\u0004\u0002\u0003B2\u00057\u0002\rA!\u001a\u0002\t\tLH/\u001a\t\u0004\u001d\t\u001d\u0014b\u0001B5\u001f\t!!)\u001f;f\u0011\u001d\u0011iG\u0003C\u0001\u0005_\n\u0011#[:WC2LG\r\u0016:b]NLG/[8o)\u0019\tyM!\u001d\u0003v!9!1\u000fB6\u0001\u0004q\u0016\u0001C8mIN#\u0018\r^3\t\u000f\u0005e&1\u000ea\u0001=\"I!\u0011\u0010\u0006C\u0002\u0013%!1P\u0001\u0014m\u0006d\u0017\u000e\u001a)sKZLw.^:Ti\u0006$Xm]\u000b\u0003\u0005{\u0002ba\nB@=\n\r\u0015b\u0001BAa\t\u0019Q*\u00199\u0011\t\u001d\u0012)IX\u0005\u0003cBB\u0001B!#\u000bA\u0003%!QP\u0001\u0015m\u0006d\u0017\u000e\u001a)sKZLw.^:Ti\u0006$Xm\u001d\u0011\t\u0013\t5%\"%A\u0005\u0002\t=\u0015a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$s'\u0006\u0002\u0003\u0012*\u001aaGa%,\u0005\tU\u0005\u0003\u0002BL\u0005Ck!A!'\u000b\t\tm%QT\u0001\nk:\u001c\u0007.Z2lK\u0012T1Aa(\u0010\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0005G\u0013IJA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\u0004")
public class TransactionMetadata
implements Logging {
    private final String transactionalId;
    private long producerId;
    private short producerEpoch;
    private int txnTimeoutMs;
    private TransactionState state;
    private final scala.collection.mutable.Set<TopicPartition> topicPartitions;
    private volatile long txnStartTimestamp;
    private volatile long txnLastUpdateTimestamp;
    private Option<TransactionState> pendingState;
    private final String loggerName;
    private Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    private volatile boolean bitmap$0;

    public static long $lessinit$greater$default$7() {
        return TransactionMetadata$.MODULE$.$lessinit$greater$default$7();
    }

    public static boolean isValidTransition(TransactionState transactionState, TransactionState transactionState2) {
        return TransactionMetadata$.MODULE$.isValidTransition(transactionState, transactionState2);
    }

    public static TransactionState byteToState(byte by) {
        return TransactionMetadata$.MODULE$.byteToState(by);
    }

    public static TransactionMetadata apply(String string, long l, short s, int n, TransactionState transactionState, long l2) {
        return TransactionMetadata$.MODULE$.apply(string, l, s, n, transactionState, l2);
    }

    public static TransactionMetadata apply(String string, long l, short s, int n, long l2) {
        return TransactionMetadata$.MODULE$.apply(string, l, s, n, l2);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public Object trace(Function0<Throwable> e) {
        return Logging.trace$(this, e);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public void swallowTrace(Function0<BoxedUnit> action) {
        Logging.swallowTrace$(this, action);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public Object debug(Function0<Throwable> e) {
        return Logging.debug$(this, e);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void swallowDebug(Function0<BoxedUnit> action) {
        Logging.swallowDebug$(this, action);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public Object info(Function0<Throwable> e) {
        return Logging.info$(this, e);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void swallowInfo(Function0<BoxedUnit> action) {
        Logging.swallowInfo$(this, action);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public Object warn(Function0<Throwable> e) {
        return Logging.warn$(this, e);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void swallowWarn(Function0<BoxedUnit> action) {
        Logging.swallowWarn$(this, action);
    }

    @Override
    public void swallow(Function0<BoxedUnit> action) {
        Logging.swallow$(this, action);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public Object error(Function0<Throwable> e) {
        return Logging.error$(this, e);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void swallowError(Function0<BoxedUnit> action) {
        Logging.swallowError$(this, action);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public Object fatal(Function0<Throwable> e) {
        return Logging.fatal$(this, e);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    private Logger logger$lzycompute() {
        TransactionMetadata transactionMetadata = this;
        synchronized (transactionMetadata) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        return !this.bitmap$0 ? this.logger$lzycompute() : this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    @Override
    public Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    @Override
    public void kafka$utils$Logging$_setter_$loggerName_$eq(String x$1) {
        this.loggerName = x$1;
    }

    @Override
    public final void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ x$1) {
        this.kafka$utils$Logging$$log4jController = x$1;
    }

    public String transactionalId() {
        return this.transactionalId;
    }

    public long producerId() {
        return this.producerId;
    }

    public void producerId_$eq(long x$1) {
        this.producerId = x$1;
    }

    public short producerEpoch() {
        return this.producerEpoch;
    }

    public void producerEpoch_$eq(short x$1) {
        this.producerEpoch = x$1;
    }

    public int txnTimeoutMs() {
        return this.txnTimeoutMs;
    }

    public void txnTimeoutMs_$eq(int x$1) {
        this.txnTimeoutMs = x$1;
    }

    public TransactionState state() {
        return this.state;
    }

    public void state_$eq(TransactionState x$1) {
        this.state = x$1;
    }

    public scala.collection.mutable.Set<TopicPartition> topicPartitions() {
        return this.topicPartitions;
    }

    public long txnStartTimestamp() {
        return this.txnStartTimestamp;
    }

    public void txnStartTimestamp_$eq(long x$1) {
        this.txnStartTimestamp = x$1;
    }

    public long txnLastUpdateTimestamp() {
        return this.txnLastUpdateTimestamp;
    }

    public void txnLastUpdateTimestamp_$eq(long x$1) {
        this.txnLastUpdateTimestamp = x$1;
    }

    public Option<TransactionState> pendingState() {
        return this.pendingState;
    }

    public void pendingState_$eq(Option<TransactionState> x$1) {
        this.pendingState = x$1;
    }

    public void addPartitions(Set<TopicPartition> partitions) {
        this.topicPartitions().$plus$plus$eq(partitions);
    }

    public void removePartition(TopicPartition topicPartition) {
        TransactionState transactionState = this.state();
        PrepareCommit$ prepareCommit$ = PrepareCommit$.MODULE$;
        if (transactionState == null ? prepareCommit$ != null : !transactionState.equals(prepareCommit$)) {
            TransactionState transactionState2 = this.state();
            PrepareAbort$ prepareAbort$ = PrepareAbort$.MODULE$;
            if (transactionState2 == null ? prepareAbort$ != null : !transactionState2.equals(prepareAbort$)) {
                throw new IllegalStateException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Transaction metadata's current state is ", ", and its pending state is ", " "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.state(), this.pendingState()})) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"while trying to remove partitions whose txn marker has been sent, this is not expected"})).s((Seq)Nil$.MODULE$));
            }
        }
        this.topicPartitions().$minus$eq((Object)topicPartition);
    }

    public TxnTransitMetadata prepareNoTransit() {
        return new TxnTransitMetadata(this.producerId(), this.producerEpoch(), this.txnTimeoutMs(), this.state(), (scala.collection.immutable.Set<TopicPartition>)this.topicPartitions().toSet(), this.txnStartTimestamp(), this.txnLastUpdateTimestamp());
    }

    public TxnTransitMetadata prepareFenceProducerEpoch() {
        if (this.producerEpoch() == Short.MAX_VALUE) {
            throw new IllegalStateException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Cannot fence producer with epoch equal to Short.MaxValue since this would overflow"})).s((Seq)Nil$.MODULE$));
        }
        this.producerEpoch_$eq((short)(this.producerEpoch() + 1));
        return new TxnTransitMetadata(this.producerId(), this.producerEpoch(), this.txnTimeoutMs(), this.state(), (scala.collection.immutable.Set<TopicPartition>)this.topicPartitions().toSet(), this.txnStartTimestamp(), this.txnLastUpdateTimestamp());
    }

    public TxnTransitMetadata prepareIncrementProducerEpoch(int newTxnTimeoutMs, long updateTimestamp) {
        if (this.isProducerEpochExhausted()) {
            throw new IllegalStateException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Cannot allocate any more producer epochs for producerId ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.producerId())})));
        }
        int nextEpoch = this.producerEpoch() == -1 ? 0 : this.producerEpoch() + 1;
        return this.prepareTransitionTo(Empty$.MODULE$, this.producerId(), (short)nextEpoch, newTxnTimeoutMs, (scala.collection.immutable.Set<TopicPartition>)Set$.MODULE$.empty(), -1L, updateTimestamp);
    }

    public TxnTransitMetadata prepareProducerIdRotation(long newProducerId, int newTxnTimeoutMs, long updateTimestamp) {
        if (this.hasPendingTransaction()) {
            throw new IllegalStateException("Cannot rotate producer ids while a transaction is still pending");
        }
        return this.prepareTransitionTo(Empty$.MODULE$, newProducerId, (short)0, newTxnTimeoutMs, (scala.collection.immutable.Set<TopicPartition>)Set$.MODULE$.empty(), -1L, updateTimestamp);
    }

    public TxnTransitMetadata prepareAddPartitions(scala.collection.immutable.Set<TopicPartition> addedTopicPartitions, long updateTimestamp) {
        TransactionState transactionState = this.state();
        boolean bl = Empty$.MODULE$.equals(transactionState) ? true : (CompleteAbort$.MODULE$.equals(transactionState) ? true : CompleteCommit$.MODULE$.equals(transactionState));
        long l = bl ? updateTimestamp : this.txnStartTimestamp();
        long newTxnStartTimestamp = l;
        return this.prepareTransitionTo(Ongoing$.MODULE$, this.producerId(), this.producerEpoch(), this.txnTimeoutMs(), (scala.collection.immutable.Set<TopicPartition>)this.topicPartitions().$plus$plus(addedTopicPartitions).toSet(), newTxnStartTimestamp, updateTimestamp);
    }

    public TxnTransitMetadata prepareAbortOrCommit(TransactionState newState, long updateTimestamp) {
        return this.prepareTransitionTo(newState, this.producerId(), this.producerEpoch(), this.txnTimeoutMs(), (scala.collection.immutable.Set<TopicPartition>)this.topicPartitions().toSet(), this.txnStartTimestamp(), updateTimestamp);
    }

    public TxnTransitMetadata prepareComplete(long updateTimestamp) {
        TransactionState transactionState = this.state();
        PrepareCommit$ prepareCommit$ = PrepareCommit$.MODULE$;
        Product newState = !(transactionState != null ? !transactionState.equals(prepareCommit$) : prepareCommit$ != null) ? CompleteCommit$.MODULE$ : CompleteAbort$.MODULE$;
        return this.prepareTransitionTo((TransactionState)newState, this.producerId(), this.producerEpoch(), this.txnTimeoutMs(), (scala.collection.immutable.Set<TopicPartition>)Predef$.MODULE$.Set().empty(), this.txnStartTimestamp(), updateTimestamp);
    }

    public TxnTransitMetadata prepareDead() {
        return this.prepareTransitionTo(Dead$.MODULE$, this.producerId(), this.producerEpoch(), this.txnTimeoutMs(), (scala.collection.immutable.Set<TopicPartition>)Predef$.MODULE$.Set().empty(), this.txnStartTimestamp(), this.txnLastUpdateTimestamp());
    }

    public boolean isProducerEpochExhausted() {
        return this.producerEpoch() >= 32766;
    }

    private boolean hasPendingTransaction() {
        TransactionState transactionState = this.state();
        boolean bl = Ongoing$.MODULE$.equals(transactionState) ? true : (PrepareAbort$.MODULE$.equals(transactionState) ? true : PrepareCommit$.MODULE$.equals(transactionState));
        boolean bl2 = bl;
        return bl2;
    }

    private TxnTransitMetadata prepareTransitionTo(TransactionState newState, long newProducerId, short newEpoch, int newTxnTimeoutMs, scala.collection.immutable.Set<TopicPartition> newTopicPartitions, long newTxnStartTimestamp, long updateTimestamp) {
        if (this.pendingState().isDefined()) {
            throw new IllegalStateException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Preparing transaction state transition to ", " "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{newState})) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"while it already a pending state ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.pendingState().get()})));
        }
        if (newProducerId < 0L) {
            throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Illegal new producer id ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)newProducerId)})));
        }
        if (newEpoch < 0) {
            throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Illegal new producer epoch ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToShort((short)newEpoch)})));
        }
        if (!((SetLike)TransactionMetadata$.MODULE$.kafka$coordinator$transaction$TransactionMetadata$$validPreviousStates().apply((Object)newState)).contains((Object)this.state())) {
            throw new IllegalStateException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Preparing transaction state transition to ", " failed since the target state"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{newState})) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" ", " is not a valid previous state of the current state ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{newState, this.state()})));
        }
        TxnTransitMetadata transitMetadata = new TxnTransitMetadata(newProducerId, newEpoch, newTxnTimeoutMs, newState, newTopicPartitions, newTxnStartTimestamp, updateTimestamp);
        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"TransactionalId ", " prepare transition from ", " to ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.transactionalId(), this.state(), transitMetadata})));
        this.pendingState_$eq((Option<TransactionState>)new Some((Object)newState));
        return transitMetadata;
    }

    public void completeTransitionTo(TxnTransitMetadata transitMetadata) {
        TransactionState toState;
        TransactionState transactionState = toState = (TransactionState)this.pendingState().getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            this.fatal((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "'s transition to ", " failed since pendingState is not defined: this should not happen"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this, transitMetadata})));
            throw new IllegalStateException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"TransactionalId ", " "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.transactionalId()})) + "completing transaction state transition while it does not have a pending state");
        });
        TransactionState transactionState2 = transitMetadata.txnState();
        if (transactionState == null ? transactionState2 != null : !transactionState.equals(transactionState2)) {
            this.throwStateTransitionFailure(transitMetadata);
        } else {
            TransactionState transactionState3 = toState;
            if (Empty$.MODULE$.equals(transactionState3)) {
                BoxedUnit boxedUnit;
                if (this.producerEpoch() != transitMetadata.producerEpoch() && !this.validProducerEpochBump(transitMetadata) || transitMetadata.topicPartitions().nonEmpty() || transitMetadata.txnStartTimestamp() != -1L) {
                    this.throwStateTransitionFailure(transitMetadata);
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    this.txnTimeoutMs_$eq(transitMetadata.txnTimeoutMs());
                    this.producerEpoch_$eq(transitMetadata.producerEpoch());
                    this.producerId_$eq(transitMetadata.producerId());
                    boxedUnit = BoxedUnit.UNIT;
                }
                BoxedUnit boxedUnit2 = boxedUnit;
            } else if (Ongoing$.MODULE$.equals(transactionState3)) {
                BoxedUnit boxedUnit;
                if (!this.validProducerEpoch(transitMetadata) || !this.topicPartitions().subsetOf(transitMetadata.topicPartitions()) || this.txnTimeoutMs() != transitMetadata.txnTimeoutMs() || this.txnStartTimestamp() > transitMetadata.txnStartTimestamp()) {
                    this.throwStateTransitionFailure(transitMetadata);
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    this.txnStartTimestamp_$eq(transitMetadata.txnStartTimestamp());
                    this.addPartitions((Set<TopicPartition>)transitMetadata.topicPartitions());
                    boxedUnit = BoxedUnit.UNIT;
                }
                BoxedUnit boxedUnit3 = boxedUnit;
            } else {
                boolean bl = PrepareAbort$.MODULE$.equals(transactionState3) ? true : PrepareCommit$.MODULE$.equals(transactionState3);
                if (bl) {
                    BoxedUnit boxedUnit;
                    if (!this.validProducerEpoch(transitMetadata) || !this.topicPartitions().toSet().equals(transitMetadata.topicPartitions()) || this.txnTimeoutMs() != transitMetadata.txnTimeoutMs() || this.txnStartTimestamp() != transitMetadata.txnStartTimestamp()) {
                        this.throwStateTransitionFailure(transitMetadata);
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    BoxedUnit boxedUnit4 = boxedUnit;
                } else {
                    boolean bl2 = CompleteAbort$.MODULE$.equals(transactionState3) ? true : CompleteCommit$.MODULE$.equals(transactionState3);
                    if (bl2) {
                        BoxedUnit boxedUnit;
                        if (!this.validProducerEpoch(transitMetadata) || this.txnTimeoutMs() != transitMetadata.txnTimeoutMs() || transitMetadata.txnStartTimestamp() == -1L) {
                            this.throwStateTransitionFailure(transitMetadata);
                            boxedUnit = BoxedUnit.UNIT;
                        } else {
                            this.txnStartTimestamp_$eq(transitMetadata.txnStartTimestamp());
                            this.topicPartitions().clear();
                            boxedUnit = BoxedUnit.UNIT;
                        }
                        BoxedUnit boxedUnit5 = boxedUnit;
                    } else {
                        if (Dead$.MODULE$.equals(transactionState3)) {
                            throw new IllegalStateException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"TransactionalId ", " is trying to complete a transition to "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.transactionalId()})) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ". This means that the transactionalId was being expired, and the only acceptable completion of "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{toState})) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"this operation is to remove the transaction metadata from the cache, not to persist the ", " in the log."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{toState})));
                        }
                        throw new MatchError((Object)transactionState3);
                    }
                }
            }
            this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"TransactionalId ", " complete transition from ", " to ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.transactionalId(), this.state(), transitMetadata})));
            this.txnLastUpdateTimestamp_$eq(transitMetadata.txnLastUpdateTimestamp());
            this.pendingState_$eq((Option<TransactionState>)None$.MODULE$);
            this.state_$eq(toState);
        }
    }

    private boolean validProducerEpoch(TxnTransitMetadata transitMetadata) {
        short transitEpoch = transitMetadata.producerEpoch();
        long transitProducerId = transitMetadata.producerId();
        return transitEpoch == this.producerEpoch() && transitProducerId == this.producerId();
    }

    private boolean validProducerEpochBump(TxnTransitMetadata transitMetadata) {
        short transitEpoch = transitMetadata.producerEpoch();
        long transitProducerId = transitMetadata.producerId();
        return transitEpoch == this.producerEpoch() + 1 || transitEpoch == 0 && transitProducerId != this.producerId();
    }

    private void throwStateTransitionFailure(TxnTransitMetadata txnTransitMetadata) {
        this.fatal((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "'s transition to ", " failed: this should not happen"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.toString(), txnTransitMetadata})));
        throw new IllegalStateException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"TransactionalId ", " failed transition to state ", " "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.transactionalId(), txnTransitMetadata})) + "due to unexpected metadata");
    }

    public boolean pendingTransitionInProgress() {
        return this.pendingState().isDefined();
    }

    public String toString() {
        return "TransactionMetadata(" + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"transactionalId=", ", "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.transactionalId()})) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"producerId=", ", "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.producerId())})) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"producerEpoch=", ", "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToShort((short)this.producerEpoch())})) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"txnTimeoutMs=", ", "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.txnTimeoutMs())})) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"state=", ", "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.state()})) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"pendingState=", ", "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.pendingState()})) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"topicPartitions=", ", "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topicPartitions()})) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"txnStartTimestamp=", ", "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.txnStartTimestamp())})) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"txnLastUpdateTimestamp=", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.txnLastUpdateTimestamp())}));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object that) {
        Object object = that;
        if (!(object instanceof TransactionMetadata)) return false;
        TransactionMetadata transactionMetadata = (TransactionMetadata)object;
        String string = this.transactionalId();
        String string2 = transactionMetadata.transactionalId();
        if (string == null) {
            if (string2 != null) {
                return false;
            }
        } else if (!string.equals(string2)) return false;
        if (this.producerId() != transactionMetadata.producerId()) return false;
        if (this.producerEpoch() != transactionMetadata.producerEpoch()) return false;
        if (this.txnTimeoutMs() != transactionMetadata.txnTimeoutMs()) return false;
        if (!this.state().equals(transactionMetadata.state())) return false;
        if (!this.topicPartitions().equals(transactionMetadata.topicPartitions())) return false;
        if (this.txnStartTimestamp() != transactionMetadata.txnStartTimestamp()) return false;
        if (this.txnLastUpdateTimestamp() != transactionMetadata.txnLastUpdateTimestamp()) return false;
        return true;
    }

    public int hashCode() {
        Seq fields = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.transactionalId(), BoxesRunTime.boxToLong((long)this.producerId()), BoxesRunTime.boxToShort((short)this.producerEpoch()), BoxesRunTime.boxToInteger((int)this.txnTimeoutMs()), this.state(), this.topicPartitions(), BoxesRunTime.boxToLong((long)this.txnStartTimestamp()), BoxesRunTime.boxToLong((long)this.txnLastUpdateTimestamp())}));
        return BoxesRunTime.unboxToInt((Object)((TraversableOnce)fields.map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToInteger((int)x$1.hashCode()), Seq$.MODULE$.canBuildFrom())).foldLeft((Object)BoxesRunTime.boxToInteger((int)0), (Function2)(JFunction2.mcIII.sp & Serializable & scala.Serializable)(a, b) -> 31 * a + b));
    }

    public TransactionMetadata(String transactionalId, long producerId, short producerEpoch, int txnTimeoutMs, TransactionState state, scala.collection.mutable.Set<TopicPartition> topicPartitions, long txnStartTimestamp, long txnLastUpdateTimestamp) {
        this.transactionalId = transactionalId;
        this.producerId = producerId;
        this.producerEpoch = producerEpoch;
        this.txnTimeoutMs = txnTimeoutMs;
        this.state = state;
        this.topicPartitions = topicPartitions;
        this.txnStartTimestamp = txnStartTimestamp;
        this.txnLastUpdateTimestamp = txnLastUpdateTimestamp;
        Logging.$init$(this);
        this.pendingState = None$.MODULE$;
    }
}

