/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import java.io.File;
import java.io.FileOutputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import kafka.log.CorruptSnapshotException;
import kafka.log.Log$;
import kafka.log.ProducerIdEntry;
import org.apache.kafka.common.protocol.types.ArrayOf;
import org.apache.kafka.common.protocol.types.Field;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Struct;
import org.apache.kafka.common.protocol.types.Type;
import org.apache.kafka.common.utils.ByteUtils;
import org.apache.kafka.common.utils.Crc32C;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Iterable$;
import scala.collection.mutable.Map;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

public final class ProducerStateManager$ {
    public static ProducerStateManager$ MODULE$;
    private final short ProducerSnapshotVersion;
    private final String VersionField;
    private final String CrcField;
    private final String ProducerIdField;
    private final String LastSequenceField;
    private final String ProducerEpochField;
    private final String LastOffsetField;
    private final String OffsetDeltaField;
    private final String TimestampField;
    private final String ProducerEntriesField;
    private final String CoordinatorEpochField;
    private final String CurrentTxnFirstOffsetField;
    private final int VersionOffset;
    private final int CrcOffset;
    private final int ProducerEntriesOffset;
    private final Schema ProducerSnapshotEntrySchema;
    private final Schema PidSnapshotMapSchema;

    static {
        new ProducerStateManager$();
    }

    private short ProducerSnapshotVersion() {
        return this.ProducerSnapshotVersion;
    }

    private String VersionField() {
        return this.VersionField;
    }

    private String CrcField() {
        return this.CrcField;
    }

    private String ProducerIdField() {
        return this.ProducerIdField;
    }

    private String LastSequenceField() {
        return this.LastSequenceField;
    }

    private String ProducerEpochField() {
        return this.ProducerEpochField;
    }

    private String LastOffsetField() {
        return this.LastOffsetField;
    }

    private String OffsetDeltaField() {
        return this.OffsetDeltaField;
    }

    private String TimestampField() {
        return this.TimestampField;
    }

    private String ProducerEntriesField() {
        return this.ProducerEntriesField;
    }

    private String CoordinatorEpochField() {
        return this.CoordinatorEpochField;
    }

    private String CurrentTxnFirstOffsetField() {
        return this.CurrentTxnFirstOffsetField;
    }

    private int VersionOffset() {
        return this.VersionOffset;
    }

    private int CrcOffset() {
        return this.CrcOffset;
    }

    private int ProducerEntriesOffset() {
        return this.ProducerEntriesOffset;
    }

    public Schema ProducerSnapshotEntrySchema() {
        return this.ProducerSnapshotEntrySchema;
    }

    public Schema PidSnapshotMapSchema() {
        return this.PidSnapshotMapSchema;
    }

    public Iterable<ProducerIdEntry> readSnapshot(File file) {
        long computedCrc;
        byte[] buffer = Files.readAllBytes(file.toPath());
        Struct struct = this.PidSnapshotMapSchema().read(ByteBuffer.wrap(buffer));
        Short version = struct.getShort(this.VersionField());
        if (!BoxesRunTime.equalsNumObject((Number)version, (Object)BoxesRunTime.boxToShort((short)this.ProducerSnapshotVersion()))) {
            throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unhandled snapshot file version ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{version})));
        }
        Long crc = struct.getUnsignedInt(this.CrcField());
        if (!BoxesRunTime.equalsNumObject((Number)crc, (Object)BoxesRunTime.boxToLong((long)(computedCrc = Crc32C.compute((byte[])buffer, (int)this.ProducerEntriesOffset(), (int)(buffer.length - this.ProducerEntriesOffset())))))) {
            throw new CorruptSnapshotException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Snapshot file '", "' is corrupted (CRC is no longer valid). "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{file})) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Stored crc: ", ". Computed crc: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{crc, BoxesRunTime.boxToLong((long)computedCrc)})));
        }
        return (Iterable)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps(struct.getArray(this.ProducerEntriesField()))).map((Function1 & Serializable & scala.Serializable)producerEntryObj -> {
            Struct producerEntryStruct = (Struct)producerEntryObj;
            long producerId = Predef$.MODULE$.Long2long(producerEntryStruct.getLong(this.ProducerIdField()));
            Short producerEpoch = producerEntryStruct.getShort(this.ProducerEpochField());
            Integer seq = producerEntryStruct.getInt(this.LastSequenceField());
            Long offset = producerEntryStruct.getLong(this.LastOffsetField());
            Long timestamp = producerEntryStruct.getLong(this.TimestampField());
            Integer offsetDelta = producerEntryStruct.getInt(this.OffsetDeltaField());
            Integer coordinatorEpoch = producerEntryStruct.getInt(this.CoordinatorEpochField());
            Long currentTxnFirstOffset = producerEntryStruct.getLong(this.CurrentTxnFirstOffsetField());
            ProducerIdEntry newEntry = new ProducerIdEntry(producerId, Predef$.MODULE$.Short2short(producerEpoch), Predef$.MODULE$.Integer2int(seq), Predef$.MODULE$.Long2long(offset), Predef$.MODULE$.Integer2int(offsetDelta), Predef$.MODULE$.Long2long(timestamp), Predef$.MODULE$.Integer2int(coordinatorEpoch), (Option<Object>)(Predef$.MODULE$.Long2long(currentTxnFirstOffset) >= 0L ? new Some((Object)BoxesRunTime.boxToLong((long)Predef$.MODULE$.Long2long(currentTxnFirstOffset))) : None$.MODULE$));
            return newEntry;
        }, Array$.MODULE$.fallbackCanBuildFrom(Predef.DummyImplicit$.MODULE$.dummyImplicit()));
    }

    public void kafka$log$ProducerStateManager$$writeSnapshot(File file, Map<Object, ProducerIdEntry> entries) {
        Struct struct = new Struct(this.PidSnapshotMapSchema());
        struct.set(this.VersionField(), (Object)BoxesRunTime.boxToShort((short)this.ProducerSnapshotVersion()));
        struct.set(this.CrcField(), (Object)BoxesRunTime.boxToLong((long)0L));
        Struct[] entriesArray = (Struct[])((TraversableOnce)entries.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            long producerId = tuple2._1$mcJ$sp();
            ProducerIdEntry entry = (ProducerIdEntry)tuple2._2();
            Struct producerEntryStruct = struct.instance(this.ProducerEntriesField());
            producerEntryStruct.set(this.ProducerIdField(), (Object)BoxesRunTime.boxToLong((long)producerId)).set(this.ProducerEpochField(), (Object)BoxesRunTime.boxToShort((short)entry.producerEpoch())).set(this.LastSequenceField(), (Object)BoxesRunTime.boxToInteger((int)entry.lastSeq())).set(this.LastOffsetField(), (Object)BoxesRunTime.boxToLong((long)entry.lastOffset())).set(this.OffsetDeltaField(), (Object)BoxesRunTime.boxToInteger((int)entry.offsetDelta())).set(this.TimestampField(), (Object)BoxesRunTime.boxToLong((long)entry.timestamp())).set(this.CoordinatorEpochField(), (Object)BoxesRunTime.boxToInteger((int)entry.coordinatorEpoch())).set(this.CurrentTxnFirstOffsetField(), entry.currentTxnFirstOffset().getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> -1L));
            Struct struct = producerEntryStruct;
            return struct;
        }, Iterable$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(Struct.class));
        struct.set(this.ProducerEntriesField(), (Object)entriesArray);
        ByteBuffer buffer = ByteBuffer.allocate(struct.sizeOf());
        struct.writeTo(buffer);
        buffer.flip();
        long crc = Crc32C.compute((ByteBuffer)buffer, (int)this.ProducerEntriesOffset(), (int)(buffer.limit() - this.ProducerEntriesOffset()));
        ByteUtils.writeUnsignedInt((ByteBuffer)buffer, (int)this.CrcOffset(), (long)crc);
        try (FileOutputStream fos = new FileOutputStream(file);){
            fos.write(buffer.array(), buffer.arrayOffset(), buffer.limit());
        }
    }

    public boolean kafka$log$ProducerStateManager$$isSnapshotFile(String name) {
        return name.endsWith(Log$.MODULE$.PidSnapshotFileSuffix());
    }

    public int $lessinit$greater$default$3() {
        return 3600000;
    }

    private ProducerStateManager$() {
        MODULE$ = this;
        this.ProducerSnapshotVersion = 1;
        this.VersionField = "version";
        this.CrcField = "crc";
        this.ProducerIdField = "producer_id";
        this.LastSequenceField = "last_sequence";
        this.ProducerEpochField = "epoch";
        this.LastOffsetField = "last_offset";
        this.OffsetDeltaField = "offset_delta";
        this.TimestampField = "timestamp";
        this.ProducerEntriesField = "producer_entries";
        this.CoordinatorEpochField = "coordinator_epoch";
        this.CurrentTxnFirstOffsetField = "current_txn_first_offset";
        this.VersionOffset = 0;
        this.CrcOffset = this.VersionOffset() + 2;
        this.ProducerEntriesOffset = this.CrcOffset() + 4;
        this.ProducerSnapshotEntrySchema = new Schema(new Field[]{new Field(this.ProducerIdField(), Type.INT64, "The producer ID"), new Field(this.ProducerEpochField(), Type.INT16, "Current epoch of the producer"), new Field(this.LastSequenceField(), Type.INT32, "Last written sequence of the producer"), new Field(this.LastOffsetField(), Type.INT64, "Last written offset of the producer"), new Field(this.OffsetDeltaField(), Type.INT32, "The difference of the last sequence and first sequence in the last written batch"), new Field(this.TimestampField(), Type.INT64, "Max timestamp from the last written entry"), new Field(this.CoordinatorEpochField(), Type.INT32, "The epoch of the last transaction coordinator to send an end transaction marker"), new Field(this.CurrentTxnFirstOffsetField(), Type.INT64, "The first offset of the on-going transaction (-1 if there is none)")});
        this.PidSnapshotMapSchema = new Schema(new Field[]{new Field(this.VersionField(), Type.INT16, "Version of the snapshot file"), new Field(this.CrcField(), Type.UNSIGNED_INT32, "CRC of the snapshot data"), new Field(this.ProducerEntriesField(), (Type)new ArrayOf((Type)this.ProducerSnapshotEntrySchema()), "The entries in the producer table")});
    }
}

