/*
 * Decompiled with CFR 0.152.
 */
package kafka.network;

import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.Histogram;
import com.yammer.metrics.core.Meter;
import com.yammer.metrics.core.Timer;
import java.io.IOException;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.net.InetAddress;
import java.net.SocketAddress;
import java.nio.channels.SocketChannel;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.TimeUnit;
import kafka.metrics.KafkaMetricsGroup;
import kafka.network.AbstractServerThread;
import kafka.network.ConnectionQuotas;
import kafka.network.Processor$;
import kafka.network.Processor$ConnectionId$;
import kafka.network.RequestChannel;
import kafka.network.RequestChannel$CloseConnectionAction$;
import kafka.network.RequestChannel$NoOpAction$;
import kafka.network.RequestChannel$SendAction$;
import kafka.security.CredentialProvider;
import kafka.server.KafkaConfig;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.common.errors.InvalidRequestException;
import org.apache.kafka.common.metrics.KafkaMetric;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.network.ChannelBuilders;
import org.apache.kafka.common.network.KafkaChannel;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.network.NetworkReceive;
import org.apache.kafka.common.network.Selector;
import org.apache.kafka.common.network.Send;
import org.apache.kafka.common.protocol.SecurityProtocol;
import org.apache.kafka.common.protocol.types.SchemaException;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.security.authenticator.CredentialCache;
import org.apache.kafka.common.utils.Time;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.LinkedHashMap$;
import scala.collection.mutable.Map$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction0;
import scala.util.control.ControlThrowable;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001\t]h!B\u0001\u0003\u0001\u00111!!\u0003)s_\u000e,7o]8s\u0015\t\u0019A!A\u0004oKR<xN]6\u000b\u0003\u0015\tQa[1gW\u0006\u001c2\u0001A\u0004\f!\tA\u0011\"D\u0001\u0003\u0013\tQ!A\u0001\u000bBEN$(/Y2u'\u0016\u0014h/\u001a:UQJ,\u0017\r\u001a\t\u0003\u0019=i\u0011!\u0004\u0006\u0003\u001d\u0011\tq!\\3ue&\u001c7/\u0003\u0002\u0011\u001b\t\t2*\u00194lC6+GO]5dg\u001e\u0013x.\u001e9\t\u0011I\u0001!Q1A\u0005\u0002Q\t!!\u001b3\u0004\u0001U\tQ\u0003\u0005\u0002\u001735\tqCC\u0001\u0019\u0003\u0015\u00198-\u00197b\u0013\tQrCA\u0002J]RD\u0001\u0002\b\u0001\u0003\u0002\u0003\u0006I!F\u0001\u0004S\u0012\u0004\u0003\u0002\u0003\u0010\u0001\u0005\u0003\u0005\u000b\u0011B\u0010\u0002\tQLW.\u001a\t\u0003A)j\u0011!\t\u0006\u0003E\r\nQ!\u001e;jYNT!\u0001J\u0013\u0002\r\r|W.\\8o\u0015\t)aE\u0003\u0002(Q\u00051\u0011\r]1dQ\u0016T\u0011!K\u0001\u0004_J<\u0017BA\u0016\"\u0005\u0011!\u0016.\\3\t\u00115\u0002!\u0011!Q\u0001\nU\ta\"\\1y%\u0016\fX/Z:u'&TX\r\u0003\u00050\u0001\t\u0005\t\u0015!\u00031\u00039\u0011X-];fgR\u001c\u0005.\u00198oK2\u0004\"\u0001C\u0019\n\u0005I\u0012!A\u0004*fcV,7\u000f^\"iC:tW\r\u001c\u0005\ti\u0001\u0011\t\u0011)A\u0005k\u0005\u00012m\u001c8oK\u000e$\u0018n\u001c8Rk>$\u0018m\u001d\t\u0003\u0011YJ!a\u000e\u0002\u0003!\r{gN\\3di&|g.U;pi\u0006\u001c\b\u0002C\u001d\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u001e\u0002)\r|gN\\3di&|gn]'bq&#G.Z't!\t12(\u0003\u0002=/\t!Aj\u001c8h\u0011!q\u0004A!A!\u0002\u0013y\u0014\u0001\u00047jgR,g.\u001a:OC6,\u0007C\u0001!C\u001b\u0005\t%BA\u0002$\u0013\t\u0019\u0015I\u0001\u0007MSN$XM\\3s\u001d\u0006lW\r\u0003\u0005F\u0001\t\u0005\t\u0015!\u0003G\u0003A\u0019XmY;sSRL\bK]8u_\u000e|G\u000e\u0005\u0002H\u00156\t\u0001J\u0003\u0002JG\u0005A\u0001O]8u_\u000e|G.\u0003\u0002L\u0011\n\u00012+Z2ve&$\u0018\u0010\u0015:pi>\u001cw\u000e\u001c\u0005\t\u001b\u0002\u0011\t\u0011)A\u0005\u001d\u000611m\u001c8gS\u001e\u0004\"a\u0014*\u000e\u0003AS!!\u0015\u0003\u0002\rM,'O^3s\u0013\t\u0019\u0006KA\u0006LC\u001a\\\u0017mQ8oM&<\u0007\u0002\u0003\b\u0001\u0005\u0003\u0005\u000b\u0011B+\u0011\u0005YCV\"A,\u000b\u00059\u0019\u0013BA-X\u0005\u001diU\r\u001e:jGND\u0001b\u0017\u0001\u0003\u0002\u0003\u0006I\u0001X\u0001\u0013GJ,G-\u001a8uS\u0006d\u0007K]8wS\u0012,'\u000f\u0005\u0002^A6\taL\u0003\u0002`\t\u0005A1/Z2ve&$\u00180\u0003\u0002b=\n\u00112I]3eK:$\u0018.\u00197Qe>4\u0018\u000eZ3s\u0011\u0015\u0019\u0007\u0001\"\u0001e\u0003\u0019a\u0014N\\5u}QaQMZ4iS*\\G.\u001c8paB\u0011\u0001\u0002\u0001\u0005\u0006%\t\u0004\r!\u0006\u0005\u0006=\t\u0004\ra\b\u0005\u0006[\t\u0004\r!\u0006\u0005\u0006_\t\u0004\r\u0001\r\u0005\u0006i\t\u0004\r!\u000e\u0005\u0006s\t\u0004\rA\u000f\u0005\u0006}\t\u0004\ra\u0010\u0005\u0006\u000b\n\u0004\rA\u0012\u0005\u0006\u001b\n\u0004\rA\u0014\u0005\u0006\u001d\t\u0004\r!\u0016\u0005\u00067\n\u0004\r\u0001X\u0004\u0006e\u0002AIa]\u0001\r\u0007>tg.Z2uS>t\u0017\n\u001a\t\u0003iVl\u0011\u0001\u0001\u0004\u0006m\u0002AIa\u001e\u0002\r\u0007>tg.Z2uS>t\u0017\nZ\n\u0004kb\\\bC\u0001\fz\u0013\tQxC\u0001\u0004B]f\u0014VM\u001a\t\u0003-qL!!`\f\u0003\u0019M+'/[1mSj\f'\r\\3\t\u000b\r,H\u0011A@\u0015\u0003MDq!a\u0001v\t\u0003\t)!\u0001\u0006ge>l7\u000b\u001e:j]\u001e$B!a\u0002\u0002rB)a#!\u0003\u0002\u000e%\u0019\u00111B\f\u0003\r=\u0003H/[8o!\r!\u0018q\u0002\u0004\u0006m\u0002!\u0015\u0011C\n\u0007\u0003\u001fA\u00181C>\u0011\u0007Y\t)\"C\u0002\u0002\u0018]\u0011q\u0001\u0015:pIV\u001cG\u000fC\u0006\u0002\u001c\u0005=!Q3A\u0005\u0002\u0005u\u0011!\u00037pG\u0006d\u0007j\\:u+\t\ty\u0002\u0005\u0003\u0002\"\u0005=b\u0002BA\u0012\u0003W\u00012!!\n\u0018\u001b\t\t9CC\u0002\u0002*M\ta\u0001\u0010:p_Rt\u0014bAA\u0017/\u00051\u0001K]3eK\u001aLA!!\r\u00024\t11\u000b\u001e:j]\u001eT1!!\f\u0018\u0011-\t9$a\u0004\u0003\u0012\u0003\u0006I!a\b\u0002\u00151|7-\u00197I_N$\b\u0005\u0003\u0006\u0002<\u0005=!Q3A\u0005\u0002Q\t\u0011\u0002\\8dC2\u0004vN\u001d;\t\u0015\u0005}\u0012q\u0002B\tB\u0003%Q#\u0001\u0006m_\u000e\fG\u000eU8si\u0002B1\"a\u0011\u0002\u0010\tU\r\u0011\"\u0001\u0002\u001e\u0005Q!/Z7pi\u0016Dun\u001d;\t\u0017\u0005\u001d\u0013q\u0002B\tB\u0003%\u0011qD\u0001\fe\u0016lw\u000e^3I_N$\b\u0005\u0003\u0006\u0002L\u0005=!Q3A\u0005\u0002Q\t!B]3n_R,\u0007k\u001c:u\u0011)\ty%a\u0004\u0003\u0012\u0003\u0006I!F\u0001\fe\u0016lw\u000e^3Q_J$\b\u0005C\u0004d\u0003\u001f!\t!a\u0015\u0015\u0015\u00055\u0011QKA,\u00033\nY\u0006\u0003\u0005\u0002\u001c\u0005E\u0003\u0019AA\u0010\u0011\u001d\tY$!\u0015A\u0002UA\u0001\"a\u0011\u0002R\u0001\u0007\u0011q\u0004\u0005\b\u0003\u0017\n\t\u00061\u0001\u0016\u0011!\ty&a\u0004\u0005B\u0005\u0005\u0014\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0005\u0005}\u0001BCA3\u0003\u001f\t\t\u0011\"\u0001\u0002h\u0005!1m\u001c9z))\ti!!\u001b\u0002l\u00055\u0014q\u000e\u0005\u000b\u00037\t\u0019\u0007%AA\u0002\u0005}\u0001\"CA\u001e\u0003G\u0002\n\u00111\u0001\u0016\u0011)\t\u0019%a\u0019\u0011\u0002\u0003\u0007\u0011q\u0004\u0005\n\u0003\u0017\n\u0019\u0007%AA\u0002UA!\"a\u001d\u0002\u0010E\u0005I\u0011AA;\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIE*\"!a\u001e+\t\u0005}\u0011\u0011P\u0016\u0003\u0003w\u0002B!! \u0002\b6\u0011\u0011q\u0010\u0006\u0005\u0003\u0003\u000b\u0019)A\u0005v]\u000eDWmY6fI*\u0019\u0011QQ\f\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002\n\u0006}$!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\"Q\u0011QRA\b#\u0003%\t!a$\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%eU\u0011\u0011\u0011\u0013\u0016\u0004+\u0005e\u0004BCAK\u0003\u001f\t\n\u0011\"\u0001\u0002v\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012\u001a\u0004BCAM\u0003\u001f\t\n\u0011\"\u0001\u0002\u0010\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\"\u0004BCAO\u0003\u001f\t\t\u0011\"\u0011\u0002 \u0006i\u0001O]8ek\u000e$\bK]3gSb,\"!!)\u0011\t\u0005\r\u0016QV\u0007\u0003\u0003KSA!a*\u0002*\u0006!A.\u00198h\u0015\t\tY+\u0001\u0003kCZ\f\u0017\u0002BA\u0019\u0003KC\u0011\"!-\u0002\u0010\u0005\u0005I\u0011\u0001\u000b\u0002\u0019A\u0014x\u000eZ;di\u0006\u0013\u0018\u000e^=\t\u0015\u0005U\u0016qBA\u0001\n\u0003\t9,\u0001\bqe>$Wo\u0019;FY\u0016lWM\u001c;\u0015\t\u0005e\u0016q\u0018\t\u0004-\u0005m\u0016bAA_/\t\u0019\u0011I\\=\t\u0013\u0005\u0005\u00171WA\u0001\u0002\u0004)\u0012a\u0001=%c!Q\u0011QYA\b\u0003\u0003%\t%a2\u0002\u001fA\u0014x\u000eZ;di&#XM]1u_J,\"!!3\u0011\r\u0005-\u0017\u0011[A]\u001b\t\tiMC\u0002\u0002P^\t!bY8mY\u0016\u001cG/[8o\u0013\u0011\t\u0019.!4\u0003\u0011%#XM]1u_JD!\"a6\u0002\u0010\u0005\u0005I\u0011AAm\u0003!\u0019\u0017M\\#rk\u0006dG\u0003BAn\u0003C\u00042AFAo\u0013\r\tyn\u0006\u0002\b\u0005>|G.Z1o\u0011)\t\t-!6\u0002\u0002\u0003\u0007\u0011\u0011\u0018\u0005\u000b\u0003K\fy!!A\u0005B\u0005\u001d\u0018\u0001\u00035bg\"\u001cu\u000eZ3\u0015\u0003UA!\"a;\u0002\u0010\u0005\u0005I\u0011IAw\u0003\u0019)\u0017/^1mgR!\u00111\\Ax\u0011)\t\t-!;\u0002\u0002\u0003\u0007\u0011\u0011\u0018\u0005\t\u0003g\f\t\u00011\u0001\u0002 \u0005\t1\u000fC\u0005\u0002xV\f\t\u0011\"!\u0002z\u0006)\u0011\r\u001d9msRQ\u0011QBA~\u0003{\fyP!\u0001\t\u0011\u0005m\u0011Q\u001fa\u0001\u0003?Aq!a\u000f\u0002v\u0002\u0007Q\u0003\u0003\u0005\u0002D\u0005U\b\u0019AA\u0010\u0011\u001d\tY%!>A\u0002UA\u0011B!\u0002v\u0003\u0003%\tIa\u0002\u0002\u000fUt\u0017\r\u001d9msR!!\u0011\u0002B\t!\u00151\u0012\u0011\u0002B\u0006!%1\"QBA\u0010+\u0005}Q#C\u0002\u0003\u0010]\u0011a\u0001V;qY\u0016$\u0004B\u0003B\n\u0005\u0007\t\t\u00111\u0001\u0002\u000e\u0005\u0019\u0001\u0010\n\u0019\t\u0013\t]\u0001A1A\u0005\n\te\u0011A\u00048fo\u000e{gN\\3di&|gn]\u000b\u0003\u00057\u0001bA!\b\u0003(\t-RB\u0001B\u0010\u0015\u0011\u0011\tCa\t\u0002\u0015\r|gnY;se\u0016tGO\u0003\u0003\u0003&\u0005%\u0016\u0001B;uS2LAA!\u000b\u0003 \t)2i\u001c8dkJ\u0014XM\u001c;MS:\\W\rZ)vKV,\u0007\u0003\u0002B\u0017\u0005oi!Aa\f\u000b\t\tE\"1G\u0001\tG\"\fgN\\3mg*!!QGAU\u0003\rq\u0017n\\\u0005\u0005\u0005s\u0011yCA\u0007T_\u000e\\W\r^\"iC:tW\r\u001c\u0005\t\u0005{\u0001\u0001\u0015!\u0003\u0003\u001c\u0005ya.Z<D_:tWm\u0019;j_:\u001c\b\u0005C\u0005\u0003B\u0001\u0011\r\u0011\"\u0003\u0003D\u0005\t\u0012N\u001c4mS\u001eDGOU3ta>t7/Z:\u0016\u0005\t\u0015\u0003\u0003\u0003B$\u0005\u001b\nyB!\u0015\u000e\u0005\t%#\u0002\u0002B&\u0003\u001b\fq!\\;uC\ndW-\u0003\u0003\u0003P\t%#aA'baB!!1\u000bB-\u001d\rA!QK\u0005\u0004\u0005/\u0012\u0011A\u0004*fcV,7\u000f^\"iC:tW\r\\\u0005\u0005\u00057\u0012iF\u0001\u0005SKN\u0004xN\\:f\u0015\r\u00119F\u0001\u0005\t\u0005C\u0002\u0001\u0015!\u0003\u0003F\u0005\u0011\u0012N\u001c4mS\u001eDGOU3ta>t7/Z:!\u0011)\u0011)\u0007\u0001b\u0001\n\u0003!!qM\u0001\u000b[\u0016$(/[2UC\u001e\u001cXC\u0001B5!!\u0011YG!\u001c\u0002\"\u0006\u0005VB\u0001B\u0012\u0013\u0011\u0011yEa\t\t\u0011\tE\u0004\u0001)A\u0005\u0005S\n1\"\\3ue&\u001cG+Y4tA!I!Q\u000f\u0001C\u0002\u0013%!qO\u0001\tg\u0016dWm\u0019;peV\u0011!\u0011\u0010\t\u0004\u0001\nm\u0014b\u0001B?\u0003\nA1+\u001a7fGR|'\u000f\u0003\u0005\u0003\u0002\u0002\u0001\u000b\u0011\u0002B=\u0003%\u0019X\r\\3di>\u0014\b\u0005C\u0004\u0003\u0006\u0002!\tEa\"\u0002\u0007I,h\u000e\u0006\u0002\u0003\nB\u0019aCa#\n\u0007\t5uC\u0001\u0003V]&$\bb\u0002BI\u0001\u0011%!qQ\u0001\u0014aJ|7-Z:t\u001d\u0016<(+Z:q_:\u001cXm\u001d\u0005\t\u0005+\u0003A\u0011\u0003\u0002\u0003\u0018\u0006a1/\u001a8e%\u0016\u001c\bo\u001c8tKR1!\u0011\u0012BM\u0005;C\u0001Ba'\u0003\u0014\u0002\u0007!\u0011K\u0001\te\u0016\u001c\bo\u001c8tK\"A!q\u0014BJ\u0001\u0004\u0011\t+\u0001\u0007sKN\u0004xN\\:f'\u0016tG\rE\u0002A\u0005GK1A!*B\u0005\u0011\u0019VM\u001c3\t\u000f\t%\u0006\u0001\"\u0003\u0003\b\u0006!\u0001o\u001c7m\u0011\u001d\u0011i\u000b\u0001C\u0005\u0005\u000f\u000b\u0001\u0004\u001d:pG\u0016\u001c8oQ8na2,G/\u001a3SK\u000e,\u0017N^3t\u0011\u001d\u0011\t\f\u0001C\u0005\u0005\u000f\u000bQ\u0003\u001d:pG\u0016\u001c8oQ8na2,G/\u001a3TK:$7\u000fC\u0004\u00036\u0002!IAa.\u0002)U\u0004H-\u0019;f%\u0016\fX/Z:u\u001b\u0016$(/[2t)\u0011\u0011II!/\t\u0011\tm&1\u0017a\u0001\u0005{\u000bqA]3rk\u0016\u001cH\u000f\u0005\u0003\u0003T\t}\u0016\u0002\u0002Ba\u0005;\u0012qAU3rk\u0016\u001cH\u000fC\u0004\u0003F\u0002!IAa\"\u0002'A\u0014xnY3tg\u0012K7oY8o]\u0016\u001cG/\u001a3\t\u000f\t%\u0007\u0001\"\u0001\u0003L\u00061\u0011mY2faR$BA!#\u0003N\"A!q\u001aBd\u0001\u0004\u0011Y#A\u0007t_\u000e\\W\r^\"iC:tW\r\u001c\u0005\b\u0005'\u0004A\u0011\u0002BD\u0003]\u0019wN\u001c4jOV\u0014XMT3x\u0007>tg.Z2uS>t7\u000fC\u0004\u0003X\u0002!IAa\"\u0002\u0011\rdwn]3BY2D\u0001Ba7\u0001\t\u0003\u0011!Q\\\u0001\bG\"\fgN\\3m)\u0011\u0011yNa:\u0011\u000bY\tIA!9\u0011\u0007\u0001\u0013\u0019/C\u0002\u0003f\u0006\u0013AbS1gW\u0006\u001c\u0005.\u00198oK2D\u0001B!;\u0003Z\u0002\u0007\u0011qD\u0001\rG>tg.Z2uS>t\u0017\n\u001a\u0005\b\u0005[\u0004A\u0011\u0001BD\u0003\u00199\u0018m[3va\"\"!1\u001eBy!\u0011\t\u0019Ka=\n\t\tU\u0018Q\u0015\u0002\t\u001fZ,'O]5eK\u0002")
public class Processor
extends AbstractServerThread
implements KafkaMetricsGroup {
    private volatile Processor$ConnectionId$ ConnectionId$module;
    private final int id;
    private final Time time;
    private final RequestChannel requestChannel;
    private final ConnectionQuotas connectionQuotas;
    private final ListenerName listenerName;
    private final SecurityProtocol securityProtocol;
    public final Metrics kafka$network$Processor$$metrics;
    private final ConcurrentLinkedQueue<SocketChannel> newConnections;
    private final scala.collection.mutable.Map<String, RequestChannel.Response> inflightResponses;
    private final java.util.Map<String, String> metricTags;
    private final Selector selector;

    @Override
    public <T> Gauge<T> newGauge(String name, Gauge<T> metric, Map<String, String> tags) {
        return KafkaMetricsGroup.newGauge$(this, name, metric, tags);
    }

    @Override
    public Meter newMeter(String name, String eventType, TimeUnit timeUnit, Map<String, String> tags) {
        return KafkaMetricsGroup.newMeter$(this, name, eventType, timeUnit, tags);
    }

    @Override
    public Histogram newHistogram(String name, boolean biased, Map<String, String> tags) {
        return KafkaMetricsGroup.newHistogram$(this, name, biased, tags);
    }

    @Override
    public Timer newTimer(String name, TimeUnit durationUnit, TimeUnit rateUnit, Map<String, String> tags) {
        return KafkaMetricsGroup.newTimer$(this, name, durationUnit, rateUnit, tags);
    }

    @Override
    public void removeMetric(String name, Map<String, String> tags) {
        KafkaMetricsGroup.removeMetric$(this, name, tags);
    }

    @Override
    public <T> Map<String, String> newGauge$default$3() {
        return KafkaMetricsGroup.newGauge$default$3$(this);
    }

    @Override
    public Map<String, String> newMeter$default$4() {
        return KafkaMetricsGroup.newMeter$default$4$(this);
    }

    @Override
    public Map<String, String> removeMetric$default$2() {
        return KafkaMetricsGroup.removeMetric$default$2$(this);
    }

    @Override
    public Map<String, String> newTimer$default$4() {
        return KafkaMetricsGroup.newTimer$default$4$(this);
    }

    @Override
    public boolean newHistogram$default$2() {
        return KafkaMetricsGroup.newHistogram$default$2$(this);
    }

    @Override
    public Map<String, String> newHistogram$default$3() {
        return KafkaMetricsGroup.newHistogram$default$3$(this);
    }

    private Processor$ConnectionId$ ConnectionId() {
        if (this.ConnectionId$module == null) {
            this.ConnectionId$lzycompute$1();
        }
        return this.ConnectionId$module;
    }

    public int id() {
        return this.id;
    }

    private ConcurrentLinkedQueue<SocketChannel> newConnections() {
        return this.newConnections;
    }

    private scala.collection.mutable.Map<String, RequestChannel.Response> inflightResponses() {
        return this.inflightResponses;
    }

    public java.util.Map<String, String> metricTags() {
        return this.metricTags;
    }

    private Selector selector() {
        return this.selector;
    }

    @Override
    public void run() {
        this.startupComplete();
        while (this.isRunning()) {
            try {
                this.configureNewConnections();
                this.processNewResponses();
                this.poll();
                this.processCompletedReceives();
                this.processCompletedSends();
                this.processDisconnected();
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                if (throwable2 instanceof ControlThrowable) {
                    ControlThrowable controlThrowable = (ControlThrowable)throwable2;
                    throw (Throwable)controlThrowable;
                }
                if (throwable2 != null) {
                    Throwable throwable3 = throwable2;
                    this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Processor got uncaught exception.", (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> throwable3);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    continue;
                }
                throw throwable;
            }
        }
        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Closing selector - processor " + this.id());
        this.swallowError((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.closeAll());
        this.shutdownComplete();
    }

    private void processNewResponses() {
        ObjectRef curr = ObjectRef.create((Object)this.requestChannel.receiveResponse(this.id()));
        while ((RequestChannel.Response)curr.elem != null) {
            try {
                BoxedUnit boxedUnit;
                RequestChannel.ResponseAction responseAction = ((RequestChannel.Response)curr.elem).responseAction();
                if (RequestChannel$NoOpAction$.MODULE$.equals(responseAction)) {
                    BoxedUnit boxedUnit2;
                    this.updateRequestMetrics(((RequestChannel.Response)curr.elem).request());
                    this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Socket server received empty response to send, registering for read: " + (RequestChannel.Response)curr$1.elem);
                    String channelId = ((RequestChannel.Response)curr.elem).request().connectionId();
                    if (this.selector().channel(channelId) != null || this.selector().closingChannel(channelId) != null) {
                        this.selector().unmute(channelId);
                        boxedUnit2 = BoxedUnit.UNIT;
                    } else {
                        boxedUnit2 = BoxedUnit.UNIT;
                    }
                    boxedUnit = boxedUnit2;
                    continue;
                }
                if (RequestChannel$SendAction$.MODULE$.equals(responseAction)) {
                    Send responseSend = (Send)((RequestChannel.Response)curr.elem).responseSend().getOrElse((Function0 & Serializable & scala.Serializable)() -> {
                        throw new IllegalStateException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"responseSend must be defined for SendAction, response: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{(RequestChannel.Response)curr$1.elem})));
                    });
                    this.sendResponse((RequestChannel.Response)curr.elem, responseSend);
                    boxedUnit = BoxedUnit.UNIT;
                    continue;
                }
                if (RequestChannel$CloseConnectionAction$.MODULE$.equals(responseAction)) {
                    this.updateRequestMetrics(((RequestChannel.Response)curr.elem).request());
                    this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Closing socket connection actively according to the response code.");
                    this.close(this.selector(), ((RequestChannel.Response)curr.elem).request().connectionId());
                    boxedUnit = BoxedUnit.UNIT;
                    continue;
                }
                throw new MatchError((Object)responseAction);
            }
            finally {
                curr.elem = this.requestChannel.receiveResponse(this.id());
            }
        }
    }

    public void sendResponse(RequestChannel.Response response, Send responseSend) {
        this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Socket server received response to send, registering for write and sending data: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{response})));
        KafkaChannel channel = this.selector().channel(responseSend.destination());
        if (channel == null) {
            this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Attempting to send response via channel for which there is no open connection, connection id ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.id())})));
            response.request().updateRequestMetrics(0L);
        } else {
            this.selector().send(responseSend);
            this.inflightResponses().$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)response.request().connectionId()), (Object)response));
        }
    }

    private void poll() {
        try {
            this.selector().poll(300L);
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            boolean bl = throwable2 instanceof IllegalStateException ? true : throwable2 instanceof IOException;
            if (bl) {
                this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Closing processor ", " due to illegal state or IO exception"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.id())})));
                this.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.closeAll());
                this.shutdownComplete();
                throw throwable2;
            }
            throw throwable;
        }
    }

    private void processCompletedReceives() {
        ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(this.selector().completedReceives()).asScala()).foreach((Function1 & Serializable & scala.Serializable)receive -> {
            Processor.$anonfun$processCompletedReceives$1(this, receive);
            return BoxedUnit.UNIT;
        });
    }

    private void processCompletedSends() {
        ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(this.selector().completedSends()).asScala()).foreach((Function1 & Serializable & scala.Serializable)send -> {
            Processor.$anonfun$processCompletedSends$1(this, send);
            return BoxedUnit.UNIT;
        });
    }

    private void updateRequestMetrics(RequestChannel.Request request) {
        KafkaChannel channel = this.selector().channel(request.connectionId());
        KafkaChannel openOrClosingChannel = channel != null ? channel : this.selector().closingChannel(request.connectionId());
        long networkThreadTimeNanos = openOrClosingChannel != null ? openOrClosingChannel.getAndResetNetworkThreadTimeNanos() : 0L;
        request.updateRequestMetrics(networkThreadTimeNanos);
    }

    private void processDisconnected() {
        ((IterableLike)JavaConverters$.MODULE$.asScalaSetConverter(this.selector().disconnected().keySet()).asScala()).foreach((Function1 & Serializable & scala.Serializable)connectionId -> {
            Processor.$anonfun$processDisconnected$1(this, connectionId);
            return BoxedUnit.UNIT;
        });
    }

    public void accept(SocketChannel socketChannel) {
        this.newConnections().add(socketChannel);
        this.wakeup();
    }

    private void configureNewConnections() {
        while (!this.newConnections().isEmpty()) {
            SocketChannel channel = this.newConnections().poll();
            try {
                this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Processor ", " listening to new connection from ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.id()), channel.socket().getRemoteSocketAddress()})));
                String localHost = channel.socket().getLocalAddress().getHostAddress();
                int localPort = channel.socket().getLocalPort();
                String remoteHost = channel.socket().getInetAddress().getHostAddress();
                int remotePort = channel.socket().getPort();
                String connectionId = new ConnectionId(this, localHost, localPort, remoteHost, remotePort).toString();
                this.selector().register(connectionId, channel);
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                Option option = NonFatal$.MODULE$.unapply(throwable2);
                if (!option.isEmpty()) {
                    Throwable e = (Throwable)option.get();
                    SocketAddress remoteAddress = channel.getRemoteAddress();
                    this.close(channel);
                    this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Processor ", " closed connection from ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.id()), remoteAddress})), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    continue;
                }
                throw throwable;
            }
        }
    }

    private void closeAll() {
        ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(this.selector().channels()).asScala()).foreach((Function1 & Serializable & scala.Serializable)channel -> {
            this.close(this.selector(), channel.id());
            return BoxedUnit.UNIT;
        });
        this.selector().close();
    }

    public Option<KafkaChannel> channel(String connectionId) {
        return Option$.MODULE$.apply((Object)this.selector().channel(connectionId));
    }

    @Override
    public void wakeup() {
        this.selector().wakeup();
    }

    private final void ConnectionId$lzycompute$1() {
        Processor processor = this;
        synchronized (processor) {
            if (this.ConnectionId$module == null) {
                this.ConnectionId$module = new Processor$ConnectionId$(this);
            }
        }
    }

    public static final /* synthetic */ void $anonfun$processCompletedReceives$1(Processor $this, NetworkReceive receive) {
        try {
            KafkaChannel openChannel = $this.selector().channel(receive.source());
            KafkaChannel openOrClosingChannel = openChannel != null ? openChannel : $this.selector().closingChannel(receive.source());
            RequestChannel.Session session = new RequestChannel.Session(new KafkaPrincipal("User", openOrClosingChannel.principal().getName()), openOrClosingChannel.socketAddress());
            RequestChannel.Request req = new RequestChannel.Request($this.id(), receive.source(), session, receive.payload(), $this.time.nanoseconds(), $this.listenerName, $this.securityProtocol);
            $this.requestChannel.sendRequest(req);
            $this.selector().mute(receive.source());
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            boolean bl = throwable2 instanceof InvalidRequestException ? true : throwable2 instanceof SchemaException;
            if (bl) {
                $this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Closing socket for ", " because of error"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{receive.source()})), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> throwable2);
                $this.close($this.selector(), receive.source());
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            throw throwable;
        }
    }

    public static final /* synthetic */ void $anonfun$processCompletedSends$1(Processor $this, Send send) {
        RequestChannel.Response resp = (RequestChannel.Response)$this.inflightResponses().remove((Object)send.destination()).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new IllegalStateException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Send for ", " completed, but not in `inflightResponses`"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{send.destination()})));
        });
        $this.updateRequestMetrics(resp.request());
        $this.selector().unmute(send.destination());
    }

    public static final /* synthetic */ void $anonfun$processDisconnected$1(Processor $this, String connectionId) {
        String remoteHost = ((ConnectionId)$this.ConnectionId().fromString(connectionId).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new IllegalStateException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"connectionId has unexpected format: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{connectionId})));
        })).remoteHost();
        $this.inflightResponses().remove((Object)connectionId).foreach((Function1 & Serializable & scala.Serializable)response -> {
            $this.updateRequestMetrics(response.request());
            return BoxedUnit.UNIT;
        });
        $this.connectionQuotas.dec(InetAddress.getByName(remoteHost));
    }

    public Processor(int id, Time time, int maxRequestSize, RequestChannel requestChannel, ConnectionQuotas connectionQuotas, long connectionsMaxIdleMs, ListenerName listenerName, SecurityProtocol securityProtocol, KafkaConfig config, Metrics metrics, CredentialProvider credentialProvider) {
        this.id = id;
        this.time = time;
        this.requestChannel = requestChannel;
        this.connectionQuotas = connectionQuotas;
        this.listenerName = listenerName;
        this.securityProtocol = securityProtocol;
        this.kafka$network$Processor$$metrics = metrics;
        super(connectionQuotas);
        KafkaMetricsGroup.$init$(this);
        this.newConnections = new ConcurrentLinkedQueue();
        this.inflightResponses = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.metricTags = (java.util.Map)JavaConverters$.MODULE$.mutableMapAsJavaMapConverter((scala.collection.mutable.Map)LinkedHashMap$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"listener"), (Object)listenerName.value()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"networkProcessor"), (Object)((Object)BoxesRunTime.boxToInteger((int)id)).toString())}))).asJava();
        this.newGauge("IdlePercent", new Gauge<Object>(this){
            private final /* synthetic */ Processor $outer;

            public double value() {
                return BoxesRunTime.unboxToDouble((Object)Option$.MODULE$.apply((Object)this.$outer.kafka$network$Processor$$metrics.metric(this.$outer.kafka$network$Processor$$metrics.metricName("io-wait-ratio", "socket-server-metrics", this.$outer.metricTags()))).fold((Function0)(JFunction0.mcD.sp & Serializable & scala.Serializable)() -> 0.0, (Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToDouble((double)$anon$2.$anonfun$value$5(x$5))));
            }

            public static final /* synthetic */ double $anonfun$value$5(KafkaMetric x$5) {
                return x$5.value();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$value$4(), $anonfun$value$5$adapted(org.apache.kafka.common.metrics.KafkaMetric )}, serializedLambda);
            }
        }, (Map<String, String>)((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"networkProcessor"), (Object)((Object)BoxesRunTime.boxToInteger((int)id)).toString())}))));
        this.selector = new Selector(maxRequestSize, connectionsMaxIdleMs, metrics, time, "socket-server", this.metricTags(), false, true, ChannelBuilders.serverChannelBuilder((ListenerName)listenerName, (SecurityProtocol)securityProtocol, (AbstractConfig)config, (CredentialCache)credentialProvider.credentialCache()));
    }

    public class ConnectionId
    implements Product,
    scala.Serializable {
        private final String localHost;
        private final int localPort;
        private final String remoteHost;
        private final int remotePort;
        public final /* synthetic */ Processor $outer;

        public String localHost() {
            return this.localHost;
        }

        public int localPort() {
            return this.localPort;
        }

        public String remoteHost() {
            return this.remoteHost;
        }

        public int remotePort() {
            return this.remotePort;
        }

        public String toString() {
            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ":", "-", ":", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.localHost(), BoxesRunTime.boxToInteger((int)this.localPort()), this.remoteHost(), BoxesRunTime.boxToInteger((int)this.remotePort())}));
        }

        public ConnectionId copy(String localHost, int localPort, String remoteHost, int remotePort) {
            return new ConnectionId(this.kafka$network$Processor$ConnectionId$$$outer(), localHost, localPort, remoteHost, remotePort);
        }

        public String copy$default$1() {
            return this.localHost();
        }

        public int copy$default$2() {
            return this.localPort();
        }

        public String copy$default$3() {
            return this.remoteHost();
        }

        public int copy$default$4() {
            return this.remotePort();
        }

        public String productPrefix() {
            return "ConnectionId";
        }

        public int productArity() {
            return 4;
        }

        public Object productElement(int x$1) {
            Object object;
            int n = x$1;
            switch (n) {
                case 0: {
                    object = this.localHost();
                    break;
                }
                case 1: {
                    object = BoxesRunTime.boxToInteger((int)this.localPort());
                    break;
                }
                case 2: {
                    object = this.remoteHost();
                    break;
                }
                case 3: {
                    object = BoxesRunTime.boxToInteger((int)this.remotePort());
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
                }
            }
            return object;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof ConnectionId;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.localHost()));
            n = Statics.mix((int)n, (int)this.localPort());
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.remoteHost()));
            n = Statics.mix((int)n, (int)this.remotePort());
            return Statics.finalizeHash((int)n, (int)4);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof ConnectionId)) return false;
            if (((ConnectionId)object).kafka$network$Processor$ConnectionId$$$outer() != this.kafka$network$Processor$ConnectionId$$$outer()) return false;
            boolean bl = true;
            if (!bl) return false;
            ConnectionId connectionId = (ConnectionId)x$1;
            String string = this.localHost();
            String string2 = connectionId.localHost();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            if (this.localPort() != connectionId.localPort()) return false;
            String string3 = this.remoteHost();
            String string4 = connectionId.remoteHost();
            if (string3 == null) {
                if (string4 != null) {
                    return false;
                }
            } else if (!string3.equals(string4)) return false;
            if (this.remotePort() != connectionId.remotePort()) return false;
            if (!connectionId.canEqual(this)) return false;
            return true;
        }

        public /* synthetic */ Processor kafka$network$Processor$ConnectionId$$$outer() {
            return this.$outer;
        }

        public ConnectionId(Processor $outer, String localHost, int localPort, String remoteHost, int remotePort) {
            this.localHost = localHost;
            this.localPort = localPort;
            this.remoteHost = remoteHost;
            this.remotePort = remotePort;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            Product.$init$((Product)this);
        }
    }
}

