/*
 * Decompiled with CFR 0.152.
 */
package kafka.tools;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import kafka.utils.CommandLineUtils$;
import kafka.utils.Exit$;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.ZkUtils;
import kafka.utils.ZkUtils$;
import org.apache.kafka.common.security.JaasUtils;
import org.apache.log4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public final class ImportZkOffsets$
implements Logging {
    public static ImportZkOffsets$ MODULE$;
    private final String loggerName;
    private Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    private volatile boolean bitmap$0;

    static {
        new ImportZkOffsets$();
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public Object trace(Function0<Throwable> e) {
        return Logging.trace$(this, e);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public void swallowTrace(Function0<BoxedUnit> action) {
        Logging.swallowTrace$(this, action);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public Object debug(Function0<Throwable> e) {
        return Logging.debug$(this, e);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void swallowDebug(Function0<BoxedUnit> action) {
        Logging.swallowDebug$(this, action);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public Object info(Function0<Throwable> e) {
        return Logging.info$(this, e);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void swallowInfo(Function0<BoxedUnit> action) {
        Logging.swallowInfo$(this, action);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public Object warn(Function0<Throwable> e) {
        return Logging.warn$(this, e);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void swallowWarn(Function0<BoxedUnit> action) {
        Logging.swallowWarn$(this, action);
    }

    @Override
    public void swallow(Function0<BoxedUnit> action) {
        Logging.swallow$(this, action);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public Object error(Function0<Throwable> e) {
        return Logging.error$(this, e);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void swallowError(Function0<BoxedUnit> action) {
        Logging.swallowError$(this, action);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public Object fatal(Function0<Throwable> e) {
        return Logging.fatal$(this, e);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    private Logger logger$lzycompute() {
        ImportZkOffsets$ importZkOffsets$ = this;
        synchronized (importZkOffsets$) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        return !this.bitmap$0 ? this.logger$lzycompute() : this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    @Override
    public Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    @Override
    public void kafka$utils$Logging$_setter_$loggerName_$eq(String x$1) {
        this.loggerName = x$1;
    }

    @Override
    public final void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ x$1) {
        this.kafka$utils$Logging$$log4jController = x$1;
    }

    public void main(String[] args) {
        OptionParser parser = new OptionParser(false);
        ArgumentAcceptingOptionSpec zkConnectOpt = parser.accepts("zkconnect", "ZooKeeper connect string.").withRequiredArg().defaultsTo((Object)"localhost:2181", (Object[])new String[0]).ofType(String.class);
        ArgumentAcceptingOptionSpec inFileOpt = parser.accepts("input-file", "Input file").withRequiredArg().ofType(String.class);
        parser.accepts("help", "Print this message.");
        if (args.length == 0) {
            throw CommandLineUtils$.MODULE$.printUsageAndDie(parser, "Import offsets to zookeeper from files.");
        }
        OptionSet options = parser.parse(args);
        if (options.has("help")) {
            parser.printHelpOn((OutputStream)System.out);
            throw Exit$.MODULE$.exit(0, Exit$.MODULE$.exit$default$2());
        }
        CommandLineUtils$.MODULE$.checkRequiredArgs(parser, options, (Seq<OptionSpec<?>>)Predef$.MODULE$.wrapRefArray((Object[])new OptionSpec[]{inFileOpt}));
        String zkConnect = (String)options.valueOf((OptionSpec)zkConnectOpt);
        String partitionOffsetFile = (String)options.valueOf((OptionSpec)inFileOpt);
        ZkUtils zkUtils = ZkUtils$.MODULE$.apply(zkConnect, 30000, 30000, JaasUtils.isZkSecurityEnabled());
        Map<String, String> partitionOffsets = this.getPartitionOffsetsFromFile(partitionOffsetFile);
        this.updateZkOffsets(zkUtils, partitionOffsets);
    }

    /*
     * WARNING - void declaration
     */
    private Map<String, String> getPartitionOffsetsFromFile(String filename) {
        void v0;
        try (BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(filename), StandardCharsets.UTF_8));){
            void var3_3;
            Map partOffsetsMap = (Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$);
            ObjectRef s = ObjectRef.create((Object)br.readLine());
            while ((String)s.elem != null && ((String)s.elem).length() >= 1) {
                String[] tokens = ((String)s.elem).split(":");
                partOffsetsMap = partOffsetsMap.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tokens[0]), (Object)tokens[1]));
                this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "adding node path [" + (String)s$1.elem + "]");
                s.elem = br.readLine();
            }
            v0 = var3_3;
        }
        return v0;
    }

    private void updateZkOffsets(ZkUtils zkUtils, Map<String, String> partitionOffsets) {
        partitionOffsets.withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)ImportZkOffsets$.$anonfun$updateZkOffsets$1(check$ifrefutable$1))).foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
            ImportZkOffsets$.$anonfun$updateZkOffsets$2(this, zkUtils, x$1);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ boolean $anonfun$updateZkOffsets$1(Tuple2 check$ifrefutable$1) {
        Tuple2 tuple2 = check$ifrefutable$1;
        boolean bl = tuple2 != null;
        return bl;
    }

    public static final /* synthetic */ void $anonfun$updateZkOffsets$2(ImportZkOffsets$ $this, ZkUtils zkUtils$1, Tuple2 x$1) {
        BoxedUnit boxedUnit;
        Tuple2 tuple2 = x$1;
        if (tuple2 != null) {
            String partition = (String)tuple2._1();
            String offset = (String)tuple2._2();
            $this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "updating [" + partition + "] with offset [" + offset + "]");
            try {
                zkUtils$1.updatePersistentPath(partition, offset.toString(), zkUtils$1.updatePersistentPath$default$3());
                boxedUnit = BoxedUnit.UNIT;
            }
            catch (Throwable e) {
                e.printStackTrace();
                boxedUnit = BoxedUnit.UNIT;
            }
        } else {
            throw new MatchError((Object)tuple2);
        }
        BoxedUnit boxedUnit2 = boxedUnit;
    }

    private ImportZkOffsets$() {
        MODULE$ = this;
        Logging.$init$(this);
    }
}

