/*
 * Decompiled with CFR 0.152.
 */
package kafka.tools;

import java.io.OutputStream;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.management.Attribute;
import javax.management.MBeanInfo;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import joptsimple.OptionSpecBuilder;
import kafka.utils.CommandLineUtils$;
import kafka.utils.Exit$;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import org.apache.log4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.Set;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Null$;
import scala.runtime.ObjectRef;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public final class JmxTool$
implements Logging {
    public static JmxTool$ MODULE$;
    private final String loggerName;
    private Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    private volatile boolean bitmap$0;

    static {
        new JmxTool$();
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public Object trace(Function0<Throwable> e) {
        return Logging.trace$(this, e);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public void swallowTrace(Function0<BoxedUnit> action) {
        Logging.swallowTrace$(this, action);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public Object debug(Function0<Throwable> e) {
        return Logging.debug$(this, e);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void swallowDebug(Function0<BoxedUnit> action) {
        Logging.swallowDebug$(this, action);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public Object info(Function0<Throwable> e) {
        return Logging.info$(this, e);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void swallowInfo(Function0<BoxedUnit> action) {
        Logging.swallowInfo$(this, action);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public Object warn(Function0<Throwable> e) {
        return Logging.warn$(this, e);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void swallowWarn(Function0<BoxedUnit> action) {
        Logging.swallowWarn$(this, action);
    }

    @Override
    public void swallow(Function0<BoxedUnit> action) {
        Logging.swallow$(this, action);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public Object error(Function0<Throwable> e) {
        return Logging.error$(this, e);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void swallowError(Function0<BoxedUnit> action) {
        Logging.swallowError$(this, action);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public Object fatal(Function0<Throwable> e) {
        return Logging.fatal$(this, e);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    private Logger logger$lzycompute() {
        JmxTool$ jmxTool$ = this;
        synchronized (jmxTool$) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        return !this.bitmap$0 ? this.logger$lzycompute() : this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    @Override
    public Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    @Override
    public void kafka$utils$Logging$_setter_$loggerName_$eq(String x$1) {
        this.loggerName = x$1;
    }

    @Override
    public final void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ x$1) {
        this.kafka$utils$Logging$$log4jController = x$1;
    }

    public void main(String[] args) {
        OptionParser parser = new OptionParser(false);
        ArgumentAcceptingOptionSpec objectNameOpt = parser.accepts("object-name", "A JMX object name to use as a query. This can contain wild cards, and this option can be given multiple times to specify more than one query. If no objects are specified all objects will be queried.").withRequiredArg().describedAs("name").ofType(String.class);
        ArgumentAcceptingOptionSpec attributesOpt = parser.accepts("attributes", "The whitelist of attributes to query. This is a comma-separated list. If no attributes are specified all objects will be queried.").withRequiredArg().describedAs("name").ofType(String.class);
        ArgumentAcceptingOptionSpec reportingIntervalOpt = parser.accepts("reporting-interval", "Interval in MS with which to poll jmx stats.").withRequiredArg().describedAs("ms").ofType(Integer.class).defaultsTo((Object)Predef$.MODULE$.int2Integer(2000), (Object[])new Integer[0]);
        OptionSpecBuilder helpOpt = parser.accepts("help", "Print usage information.");
        ArgumentAcceptingOptionSpec dateFormatOpt = parser.accepts("date-format", "The date format to use for formatting the time field. See java.text.SimpleDateFormat for options.").withRequiredArg().describedAs("format").ofType(String.class);
        ArgumentAcceptingOptionSpec jmxServiceUrlOpt = parser.accepts("jmx-url", "The url to connect to to poll JMX data. See Oracle javadoc for JMXServiceURL for details.").withRequiredArg().describedAs("service-url").ofType(String.class).defaultsTo((Object)"service:jmx:rmi:///jndi/rmi://:9999/jmxrmi", (Object[])new String[0]);
        if (args.length == 0) {
            throw CommandLineUtils$.MODULE$.printUsageAndDie(parser, "Dump JMX values to standard output.");
        }
        OptionSet options = parser.parse(args);
        if (options.has((OptionSpec)helpOpt)) {
            parser.printHelpOn((OutputStream)System.out);
            throw Exit$.MODULE$.exit(0, Exit$.MODULE$.exit$default$2());
        }
        JMXServiceURL url = new JMXServiceURL((String)options.valueOf((OptionSpec)jmxServiceUrlOpt));
        int interval = (Integer)options.valueOf((OptionSpec)reportingIntervalOpt);
        boolean attributesWhitelistExists = options.has((OptionSpec)attributesOpt);
        None$ attributesWhitelist = attributesWhitelistExists ? new Some((Object)((String)options.valueOf((OptionSpec)attributesOpt)).split(",")) : None$.MODULE$;
        boolean dateFormatExists = options.has((OptionSpec)dateFormatOpt);
        None$ dateFormat = dateFormatExists ? new Some((Object)new SimpleDateFormat((String)options.valueOf((OptionSpec)dateFormatOpt))) : None$.MODULE$;
        JMXConnector jmxc = null;
        ObjectRef mbsc = ObjectRef.create(null);
        int retries = 0;
        int maxNumRetries = 10;
        boolean connected = false;
        while (retries < maxNumRetries && !connected) {
            try {
                System.err.println(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Trying to connect to JMX url: ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{url})));
                jmxc = JMXConnectorFactory.connect(url, null);
                mbsc.elem = jmxc.getMBeanServerConnection();
                connected = true;
            }
            catch (Exception e) {
                System.err.println(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Could not connect to JMX url: ", ". Exception ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{url, e.getMessage()})));
                e.printStackTrace();
                ++retries;
                Thread.sleep(500L);
            }
        }
        if (!connected) {
            System.err.println(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Could not connect to JMX url ", " after ", " retries."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{url, BoxesRunTime.boxToInteger((int)maxNumRetries)})));
            System.err.println("Exiting.");
            throw scala.sys.package$.MODULE$.exit(1);
        }
        List queries = options.has((OptionSpec)objectNameOpt) ? (Iterable)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(options.valuesOf((OptionSpec)objectNameOpt)).asScala()).map((Function1 & Serializable & scala.Serializable)x$1 -> new ObjectName((String)x$1), Buffer$.MODULE$.canBuildFrom()) : List$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Null$[]{null}));
        Iterable names = (Iterable)queries.flatMap((Function1 & Serializable & scala.Serializable)name -> (Set)JavaConverters$.MODULE$.asScalaSetConverter(((MBeanServerConnection)mbsc$1.elem).queryNames((ObjectName)name, null)).asScala(), Iterable$.MODULE$.canBuildFrom());
        Map numExpectedAttributes = attributesWhitelistExists ? ((TraversableOnce)queries.map(arg_0 -> JmxTool$.$anonfun$main$3((Option)attributesWhitelist, arg_0), Iterable$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms()) : ((TraversableOnce)names.map((Function1 & Serializable & scala.Serializable)name -> {
            MBeanInfo mbean = ((MBeanServerConnection)mbsc$1.elem).getMBeanInfo((ObjectName)name);
            return new Tuple2(name, (Object)BoxesRunTime.boxToInteger((int)((MBeanServerConnection)mbsc$1.elem).getAttributes((ObjectName)name, (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])mbean.getAttributes())).map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.getName(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))).size()));
        }, Iterable$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        List keys = (List)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"time"})).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.queryAttributes((MBeanServerConnection)mbsc.elem, (Iterable<ObjectName>)names, (Option<String[]>)attributesWhitelist).keys().toArray(ClassTag$.MODULE$.apply(String.class)))).sorted((Ordering)Ordering.String$.MODULE$))), List$.MODULE$.canBuildFrom());
        if (keys.size() == BoxesRunTime.unboxToInt((Object)numExpectedAttributes.values().sum((Numeric)Numeric.IntIsIntegral$.MODULE$)) + 1) {
            Predef$.MODULE$.println((Object)((TraversableOnce)keys.map((Function1 & Serializable & scala.Serializable)x$4 -> "\"" + x$4 + "\"", List$.MODULE$.canBuildFrom())).mkString(","));
        }
        while (true) {
            String string;
            long start = System.currentTimeMillis();
            HashMap<String, Object> attributes = this.queryAttributes((MBeanServerConnection)mbsc.elem, (Iterable<ObjectName>)names, (Option<String[]>)attributesWhitelist);
            None$ none$ = dateFormat;
            if (none$ instanceof Some) {
                Some some = (Some)none$;
                SimpleDateFormat dFormat = (SimpleDateFormat)some.value();
                string = dFormat.format(new Date());
            } else if (None$.MODULE$.equals(none$)) {
                string = ((Object)BoxesRunTime.boxToLong((long)System.currentTimeMillis())).toString();
            } else {
                throw new MatchError((Object)none$);
            }
            attributes.update((Object)"time", (Object)string);
            if (attributes.keySet().size() == BoxesRunTime.unboxToInt((Object)numExpectedAttributes.values().sum((Numeric)Numeric.IntIsIntegral$.MODULE$)) + 1) {
                Predef$.MODULE$.println((Object)((TraversableOnce)keys.map((Function1 & Serializable & scala.Serializable)x$5 -> attributes.apply(x$5), List$.MODULE$.canBuildFrom())).mkString(","));
            }
            long sleep = package$.MODULE$.max(0L, (long)interval - (System.currentTimeMillis() - start));
            Thread.sleep(sleep);
        }
    }

    public HashMap<String, Object> queryAttributes(MBeanServerConnection mbsc, Iterable<ObjectName> names, Option<String[]> attributesWhitelist) {
        ObjectRef attributes = ObjectRef.create((Object)new HashMap());
        names.foreach((Function1 & Serializable & scala.Serializable)name -> {
            JmxTool$.$anonfun$queryAttributes$1(mbsc, attributesWhitelist, attributes, name);
            return BoxedUnit.UNIT;
        });
        return (HashMap)attributes.elem;
    }

    public static final /* synthetic */ Tuple2 $anonfun$main$3(Option attributesWhitelist$1, ObjectName x$2) {
        return new Tuple2((Object)x$2, (Object)BoxesRunTime.boxToInteger((int)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])attributesWhitelist$1.get())).size()));
    }

    public static final /* synthetic */ void $anonfun$queryAttributes$3(Option attributesWhitelist$2, ObjectRef attributes$1, ObjectName name$1, Object attrObj) {
        Attribute attr = (Attribute)attrObj;
        Option option = attributesWhitelist$2;
        if (option instanceof Some) {
            BoxedUnit boxedUnit;
            Some some = (Some)option;
            String[] allowedAttributes = (String[])some.value();
            if (new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])allowedAttributes)).contains((Object)attr.getName())) {
                ((HashMap)attributes$1.elem).update((Object)(Predef.any2stringadd$.MODULE$.$plus$extension(Predef$.MODULE$.any2stringadd((Object)name$1), ":") + attr.getName()), attr.getValue());
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit2 = boxedUnit;
        } else if (None$.MODULE$.equals(option)) {
            ((HashMap)attributes$1.elem).update((Object)(Predef.any2stringadd$.MODULE$.$plus$extension(Predef$.MODULE$.any2stringadd((Object)name$1), ":") + attr.getName()), attr.getValue());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError((Object)option);
        }
    }

    public static final /* synthetic */ void $anonfun$queryAttributes$1(MBeanServerConnection mbsc$2, Option attributesWhitelist$2, ObjectRef attributes$1, ObjectName name) {
        MBeanInfo mbean = mbsc$2.getMBeanInfo(name);
        ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter((java.util.List)mbsc$2.getAttributes(name, (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])mbean.getAttributes())).map((Function1 & Serializable & scala.Serializable)x$6 -> x$6.getName(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).asScala()).foreach((Function1 & Serializable & scala.Serializable)attrObj -> {
            JmxTool$.$anonfun$queryAttributes$3(attributesWhitelist$2, attributes$1, name, attrObj);
            return BoxedUnit.UNIT;
        });
    }

    private JmxTool$() {
        MODULE$ = this;
        Logging.$init$(this);
    }
}

