/*
 * Decompiled with CFR 0.152.
 */
package kafka.utils;

import java.io.EOFException;
import java.io.File;
import java.io.Serializable;
import java.lang.management.ManagementFactory;
import java.lang.reflect.Constructor;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.util.Properties;
import java.util.UUID;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.xml.bind.DatatypeConverter;
import kafka.cluster.EndPoint;
import kafka.cluster.EndPoint$;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.protocol.SecurityProtocol;
import org.apache.kafka.common.utils.Utils;
import org.apache.log4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.Iterator;
import scala.collection.Iterator$;
import scala.collection.Map;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.Traversable;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.HashMap;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public final class CoreUtils$
implements Logging {
    public static CoreUtils$ MODULE$;
    private final String loggerName;
    private Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    private volatile boolean bitmap$0;

    static {
        new CoreUtils$();
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public Object trace(Function0<Throwable> e) {
        return Logging.trace$(this, e);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public void swallowTrace(Function0<BoxedUnit> action) {
        Logging.swallowTrace$(this, action);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public Object debug(Function0<Throwable> e) {
        return Logging.debug$(this, e);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void swallowDebug(Function0<BoxedUnit> action) {
        Logging.swallowDebug$(this, action);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public Object info(Function0<Throwable> e) {
        return Logging.info$(this, e);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void swallowInfo(Function0<BoxedUnit> action) {
        Logging.swallowInfo$(this, action);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public Object warn(Function0<Throwable> e) {
        return Logging.warn$(this, e);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void swallowWarn(Function0<BoxedUnit> action) {
        Logging.swallowWarn$(this, action);
    }

    @Override
    public void swallow(Function0<BoxedUnit> action) {
        Logging.swallow$(this, action);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public Object error(Function0<Throwable> e) {
        return Logging.error$(this, e);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void swallowError(Function0<BoxedUnit> action) {
        Logging.swallowError$(this, action);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public Object fatal(Function0<Throwable> e) {
        return Logging.fatal$(this, e);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    private Logger logger$lzycompute() {
        CoreUtils$ coreUtils$ = this;
        synchronized (coreUtils$) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        return !this.bitmap$0 ? this.logger$lzycompute() : this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    @Override
    public Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    @Override
    public void kafka$utils$Logging$_setter_$loggerName_$eq(String x$1) {
        this.loggerName = x$1;
    }

    @Override
    public final void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ x$1) {
        this.kafka$utils$Logging$$log4jController = x$1;
    }

    public Runnable runnable(Function0<BoxedUnit> fun) {
        return new Runnable(fun){
            private final Function0 fun$1;

            public void run() {
                this.fun$1.apply$mcV$sp();
            }
            {
                this.fun$1 = fun$1;
            }
        };
    }

    public Thread newThread(String name, boolean daemon, Function0<BoxedUnit> fun) {
        return Utils.newThread((String)name, (Runnable)this.runnable(fun), (boolean)daemon);
    }

    public void swallow(Function2<Object, Throwable, BoxedUnit> log, Function0<BoxedUnit> action) {
        try {
            action.apply$mcV$sp();
        }
        catch (Throwable e) {
            log.apply((Object)e.getMessage(), (Object)e);
        }
    }

    public void delete(Seq<String> files) {
        files.foreach((Function1 & Serializable & scala.Serializable)f -> {
            CoreUtils$.$anonfun$delete$1(f);
            return BoxedUnit.UNIT;
        });
    }

    public boolean registerMBean(Object mbean, String name) {
        boolean bl;
        try {
            MBeanServer mbs;
            MBeanServer mBeanServer = mbs = ManagementFactory.getPlatformMBeanServer();
            synchronized (mBeanServer) {
                ObjectName objName = new ObjectName(name);
                if (mbs.isRegistered(objName)) {
                    mbs.unregisterMBean(objName);
                }
                mbs.registerMBean(mbean, objName);
                boolean bl2 = true;
                // MONITOREXIT @DISABLED, blocks:[0, 1, 2] lbl11 : MonitorExitStatement: MONITOREXIT : var4_4
                bl = bl2;
            }
        }
        catch (Exception e) {
            this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Failed to register Mbean " + name, (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
            bl = false;
        }
        return bl;
    }

    public void unregisterMBean(String name) {
        MBeanServer mbs;
        MBeanServer mBeanServer = mbs = ManagementFactory.getPlatformMBeanServer();
        synchronized (mBeanServer) {
            ObjectName objName = new ObjectName(name);
            if (mbs.isRegistered(objName)) {
                mbs.unregisterMBean(objName);
            }
        }
    }

    public int read(ReadableByteChannel channel, ByteBuffer buffer) {
        int n;
        int n2 = channel.read(buffer);
        if (-1 == n2) {
            throw new EOFException("Received -1 when reading from channel, socket has likely been closed.");
        }
        int n3 = n = n2;
        return n3;
    }

    public Map<String, String> parseCsvMap(String str) {
        HashMap map = new HashMap();
        if ("".equals(str)) {
            return map;
        }
        Tuple2[] keyVals = (Tuple2[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])str.split("\\s*,\\s*"))).map((Function1 & Serializable & scala.Serializable)s -> {
            int lio = s.lastIndexOf(":");
            return new Tuple2((Object)s.substring(0, lio).trim(), (Object)s.substring(lio + 1).trim());
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)));
        return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])keyVals)).toMap(Predef$.MODULE$.$conforms());
    }

    public Seq<String> parseCsvList(String csvList) {
        return csvList == null || csvList.isEmpty() ? (Seq)Seq$.MODULE$.empty() : Predef$.MODULE$.wrapRefArray((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])csvList.split("\\s*,\\s*"))).filter((Function1 & Serializable & scala.Serializable)v -> BoxesRunTime.boxToBoolean((boolean)CoreUtils$.$anonfun$parseCsvList$1(v))));
    }

    public <T> T createObject(String className, Seq<Object> args) {
        Class<?> klass = Class.forName(className, true, Utils.getContextOrKafkaClassLoader());
        Constructor<?> constructor = klass.getConstructor((Class[])((TraversableOnce)args.map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.getClass(), Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(Class.class)));
        return (T)constructor.newInstance((Object[])args.toArray(ClassTag$.MODULE$.AnyRef()));
    }

    public <T> Iterator<T> circularIterator(Iterable<T> coll) {
        return Iterator$.MODULE$.continually((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 1).flatMap((Function1 & Serializable & scala.Serializable)_ -> CoreUtils$.$anonfun$circularIterator$2(coll, BoxesRunTime.unboxToInt((Object)_)));
    }

    public String replaceSuffix(String s, String oldSuffix, String newSuffix) {
        if (!s.endsWith(oldSuffix)) {
            throw new IllegalArgumentException(new StringOps(Predef$.MODULE$.augmentString("Expected string to end with '%s' but string is '%s'")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{oldSuffix, s})));
        }
        return s.substring(0, s.length() - oldSuffix.length()) + newSuffix;
    }

    public int readInt(byte[] bytes, int offset) {
        return (bytes[offset] & 0xFF) << 24 | (bytes[offset + 1] & 0xFF) << 16 | (bytes[offset + 2] & 0xFF) << 8 | bytes[offset + 3] & 0xFF;
    }

    public <T> T inLock(Lock lock, Function0<T> fun) {
        Object object;
        lock.lock();
        try {
            object = fun.apply();
        }
        finally {
            lock.unlock();
        }
        return (T)object;
    }

    public <T> T inReadLock(ReadWriteLock lock, Function0<T> fun) {
        return this.inLock(lock.readLock(), fun);
    }

    public <T> T inWriteLock(ReadWriteLock lock, Function0<T> fun) {
        return this.inLock(lock.writeLock(), fun);
    }

    public String JSONEscapeString(String s) {
        return ((TraversableOnce)new StringOps(Predef$.MODULE$.augmentString(s)).map((Function1 & Serializable & scala.Serializable)x0$1 -> CoreUtils$.$anonfun$JSONEscapeString$1(BoxesRunTime.unboxToChar((Object)x0$1)), Predef$.MODULE$.fallbackStringCanBuildFrom())).mkString();
    }

    public <T> Iterable<T> duplicates(Traversable<T> s) {
        return ((MapLike)((TraversableLike)s.groupBy((Function1 & Serializable & scala.Serializable)x -> Predef$.MODULE$.identity(x)).map((Function1 & Serializable & scala.Serializable)x0$2 -> {
            Tuple2 tuple2 = x0$2;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Object k = tuple2._1();
            Traversable l = (Traversable)tuple2._2();
            Tuple2 tuple22 = new Tuple2(k, (Object)BoxesRunTime.boxToInteger((int)l.size()));
            return tuple22;
        }, Map$.MODULE$.canBuildFrom())).filter((Function1 & Serializable & scala.Serializable)x0$3 -> BoxesRunTime.boxToBoolean((boolean)CoreUtils$.$anonfun$duplicates$3(x0$3)))).keys();
    }

    /*
     * WARNING - void declaration
     */
    public Seq<EndPoint> listenerListToEndPoints(String listeners, Map<ListenerName, SecurityProtocol> securityProtocolMap) {
        void var3_5;
        Seq seq;
        try {
            Seq<String> listenerList = this.parseCsvList(listeners);
            seq = (Seq)listenerList.map((Function1 & Serializable & scala.Serializable)x$5 -> EndPoint$.MODULE$.createEndPoint((String)x$5, (Option<Map<ListenerName, SecurityProtocol>>)new Some((Object)securityProtocolMap)), Seq$.MODULE$.canBuildFrom());
        }
        catch (Exception e) {
            throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Error creating broker listeners from '", "': ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{listeners, e.getMessage()})), e);
        }
        Seq endPoints = seq;
        CoreUtils$.validate$1(endPoints, listeners);
        return var3_5;
    }

    public String generateUuidAsBase64() {
        UUID uuid = UUID.randomUUID();
        return this.urlSafeBase64EncodeNoPadding(this.getBytesFromUuid(uuid));
    }

    public byte[] getBytesFromUuid(UUID uuid) {
        ByteBuffer uuidBytes = ByteBuffer.wrap(new byte[16]);
        uuidBytes.putLong(uuid.getMostSignificantBits());
        uuidBytes.putLong(uuid.getLeastSignificantBits());
        return uuidBytes.array();
    }

    public String urlSafeBase64EncodeNoPadding(byte[] data) {
        String base64EncodedUUID = DatatypeConverter.printBase64Binary((byte[])data);
        String urlSafeBase64EncodedUUID = base64EncodedUUID.replace("+", "-").replace("/", "_");
        return urlSafeBase64EncodedUUID.substring(0, urlSafeBase64EncodedUUID.length() - 2);
    }

    public Properties propsWith(String key, String value) {
        return this.propsWith((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)key, (Object)value)}));
    }

    /*
     * WARNING - void declaration
     */
    public Properties propsWith(Seq<Tuple2<String, String>> props) {
        void var2_2;
        Properties properties = new Properties();
        props.foreach((Function1 & Serializable & scala.Serializable)x0$4 -> {
            Tuple2 tuple2 = x0$4;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String k = (String)tuple2._1();
            String v = (String)tuple2._2();
            Object object = properties.put(k, v);
            return object;
        });
        return var2_2;
    }

    public static final /* synthetic */ void $anonfun$delete$1(String f) {
        Utils.delete((File)new File(f));
    }

    public static final /* synthetic */ boolean $anonfun$parseCsvList$1(String v) {
        return !v.equals("");
    }

    public static final /* synthetic */ Iterable $anonfun$circularIterator$2(Iterable coll$1, int _) {
        return (Iterable)coll$1.map((Function1 & Serializable & scala.Serializable)t -> t, Iterable$.MODULE$.canBuildFrom());
    }

    public static final /* synthetic */ Object $anonfun$JSONEscapeString$1(char x0$1) {
        Object object;
        char c = x0$1;
        switch (c) {
            case '\"': {
                object = "\\\"";
                break;
            }
            case '\\': {
                object = "\\\\";
                break;
            }
            case '/': {
                object = "\\/";
                break;
            }
            case '\b': {
                object = "\\b";
                break;
            }
            case '\f': {
                object = "\\f";
                break;
            }
            case '\n': {
                object = "\\n";
                break;
            }
            case '\r': {
                object = "\\r";
                break;
            }
            case '\t': {
                object = "\\t";
                break;
            }
            default: {
                if (c >= '\u0000' && c <= '\u001f' || c >= '\u007f' && c <= '\u009f') {
                    object = new StringOps(Predef$.MODULE$.augmentString("\\u%04x")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)c)}));
                    break;
                }
                object = BoxesRunTime.boxToCharacter((char)c);
                break;
            }
        }
        return object;
    }

    public static final /* synthetic */ boolean $anonfun$duplicates$3(Tuple2 x0$3) {
        Tuple2 tuple2 = x0$3;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        int l = tuple2._2$mcI$sp();
        boolean bl = l > 1;
        return bl;
    }

    private static final void validate$1(Seq endPoints, String listeners$1) {
        Seq portsExcludingZero = (Seq)((TraversableLike)endPoints.map((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToInteger((int)x$2.port()), Seq$.MODULE$.canBuildFrom())).filter((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)x$3 -> x$3 != 0);
        Seq distinctPorts = (Seq)portsExcludingZero.distinct();
        Seq distinctListenerNames = (Seq)((SeqLike)endPoints.map((Function1 & Serializable & scala.Serializable)x$4 -> x$4.listenerName(), Seq$.MODULE$.canBuildFrom())).distinct();
        Predef$.MODULE$.require(distinctPorts.size() == portsExcludingZero.size(), (Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Each listener must have a different port, listeners: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{listeners$1})));
        Predef$.MODULE$.require(distinctListenerNames.size() == endPoints.size(), (Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Each listener must have a different name, listeners: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{listeners$1})));
    }

    private CoreUtils$() {
        MODULE$ = this;
        Logging.$init$(this);
    }
}

