/*
 * Decompiled with CFR 0.152.
 */
package kafka.controller;

import com.yammer.metrics.core.MetricName;
import com.yammer.metrics.core.Timer;
import java.io.File;
import java.io.Serializable;
import java.util.Properties;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.LinkedBlockingQueue;
import kafka.api.ApiVersion;
import kafka.api.KAFKA_2_6_IV0$;
import kafka.api.KAFKA_2_7_IV0$;
import kafka.api.LeaderAndIsr;
import kafka.api.LeaderAndIsr$;
import kafka.controller.AlterIsrReceived;
import kafka.controller.ApiPartitionReassignment;
import kafka.controller.ControlledShutdown;
import kafka.controller.ControllerEvent;
import kafka.controller.ControllerEventManager;
import kafka.controller.ControllerState;
import kafka.controller.ElectionTrigger;
import kafka.controller.KafkaController;
import kafka.controller.KafkaController$;
import kafka.controller.LeaderIsrAndControllerEpoch;
import kafka.controller.ListPartitionReassignments;
import kafka.controller.MockEvent;
import kafka.controller.ReplicaAssignment;
import kafka.controller.ReplicaLeaderElection;
import kafka.controller.ZkTriggered$;
import kafka.metrics.KafkaYammerMetrics;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.utils.LogCaptureAppender;
import kafka.utils.LogCaptureAppender$;
import kafka.utils.ShutdownableThread;
import kafka.utils.TestUtils$;
import kafka.utils.TestUtils$Checkpoint$;
import kafka.zk.AdminZkClient;
import kafka.zk.FeatureZNode;
import kafka.zk.FeatureZNode$;
import kafka.zk.FeatureZNodeStatus$;
import kafka.zk.PreferredReplicaElectionZNode$;
import kafka.zk.ZooKeeperTestHarness;
import org.apache.kafka.common.ElectionType;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.ControllerMovedException;
import org.apache.kafka.common.errors.StaleBrokerEpochException;
import org.apache.kafka.common.feature.Features;
import org.apache.kafka.common.message.UpdateMetadataRequestData;
import org.apache.kafka.common.metrics.KafkaMetric;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.ApiError;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.Time;
import org.apache.log4j.Level;
import org.apache.log4j.spi.LoggingEvent;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableFactory;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Map;
import scala.collection.MapOps;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqOps;
import scala.collection.Set;
import scala.collection.convert.AsJavaExtensions;
import scala.collection.convert.AsScalaExtensions;
import scala.collection.immutable.;
import scala.collection.immutable.ArraySeq;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set$;
import scala.collection.mutable.Map$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.VolatileBooleanRef;
import scala.runtime.java8.JFunction1;
import scala.util.Either;
import scala.util.Failure;
import scala.util.Left;
import scala.util.Right;
import scala.util.Success;
import scala.util.Try;

@ScalaSignature(bytes="\u0006\u0005\t-g\u0001\u0002!B\u0001\u0019CQ!\u0014\u0001\u0005\u00029Cq!\u0015\u0001A\u0002\u0013\u0005!\u000bC\u0004b\u0001\u0001\u0007I\u0011\u00012\t\r%\u0004\u0001\u0015)\u0003T\u0011\u001dQ\u0007A1A\u0005\u0002-Daa\u001c\u0001!\u0002\u0013a\u0007b\u00029\u0001\u0005\u0004%\ta\u001b\u0005\u0007c\u0002\u0001\u000b\u0011\u00027\t\u000bI\u0004A\u0011I:\t\u000bu\u0004A\u0011I:\t\r\u0005\u0015\u0001\u0001\"\u0001t\u0011\u0019\ty\u0001\u0001C\u0001g\"1\u00111\u0003\u0001\u0005\u0002MDa!a\u0006\u0001\t\u0003\u0019\bBBA\u000e\u0001\u0011\u00051\u000f\u0003\u0004\u0002 \u0001!\ta\u001d\u0005\u0007\u0003G\u0001A\u0011A:\t\r\u0005\u001d\u0002\u0001\"\u0001t\u0011\u0019\tY\u0003\u0001C\u0001g\"1\u0011q\u0006\u0001\u0005\u0002MDa!a\r\u0001\t\u0003\u0019\bBBA\u001c\u0001\u0011\u00051\u000f\u0003\u0004\u0002<\u0001!\ta\u001d\u0005\u0007\u0003\u007f\u0001A\u0011A:\t\r\u0005\r\u0003\u0001\"\u0001t\u0011\u0019\t9\u0005\u0001C\u0001g\"1\u00111\n\u0001\u0005\u0002MDa!a\u0014\u0001\t\u0003\u0019\bBBA*\u0001\u0011\u00051\u000f\u0003\u0004\u0002X\u0001!\ta\u001d\u0005\u0007\u00037\u0002A\u0011A:\t\r\u0005}\u0003\u0001\"\u0001t\u0011\u0019\t\u0019\u0007\u0001C\u0001g\"1\u0011q\r\u0001\u0005\u0002MDa!a\u001b\u0001\t\u0003\u0019\bBBA8\u0001\u0011\u00051\u000f\u0003\u0004\u0002t\u0001!\ta\u001d\u0005\u0007\u0003o\u0002A\u0011A:\t\r\u0005m\u0004\u0001\"\u0001t\u0011\u0019\ty\b\u0001C\u0001g\"1\u00111\u0011\u0001\u0005\u0002MDa!a\"\u0001\t\u0003\u0019\bBBAF\u0001\u0011\u00051\u000f\u0003\u0004\u0002\u0010\u0002!\ta\u001d\u0005\u0007\u0003'\u0003A\u0011A:\t\u000f\u0005]\u0005\u0001\"\u0003\u0002\u001a\"1\u00111\u0018\u0001\u0005\u0002MDq!a0\u0001\t\u0013\t\t\rC\u0004\u0002N\u0002!I!a4\t\u000f\t5\u0001\u0001\"\u0003\u0003\u0010!9!q\u0004\u0001\u0005\n\t\u0005\u0002b\u0002B\u0019\u0001\u0011%!1\u0007\u0005\b\u0005\u0017\u0002A\u0011\u0002B'\u0011%\u0011)\bAI\u0001\n\u0013\u00119\bC\u0005\u0003\u000e\u0002\t\n\u0011\"\u0003\u0003x!I!q\u0012\u0001\u0012\u0002\u0013%!q\u000f\u0005\n\u0005#\u0003\u0011\u0013!C\u0005\u0005'C\u0011Ba&\u0001#\u0003%IAa%\t\u0013\te\u0005!%A\u0005\n\tM\u0005\"\u0003BN\u0001E\u0005I\u0011\u0002BO\u0011%\u0011\t\u000bAI\u0001\n\u0013\u0011\u0019\u000bC\u0004\u0003(\u0002!IA!+\t\u000f\t\u001d\u0007\u0001\"\u0003\u0003J\nI2i\u001c8ue>dG.\u001a:J]R,wM]1uS>tG+Z:u\u0015\t\u00115)\u0001\u0006d_:$(o\u001c7mKJT\u0011\u0001R\u0001\u0006W\u000647.Y\u0002\u0001'\t\u0001q\t\u0005\u0002I\u00176\t\u0011J\u0003\u0002K\u0007\u0006\u0011!p[\u0005\u0003\u0019&\u0013ACW8p\u0017\u0016,\u0007/\u001a:UKN$\b*\u0019:oKN\u001c\u0018A\u0002\u001fj]&$h\bF\u0001P!\t\u0001\u0006!D\u0001B\u0003\u001d\u0019XM\u001d<feN,\u0012a\u0015\t\u0004)f[V\"A+\u000b\u0005Y;\u0016AC2pY2,7\r^5p]*\t\u0001,A\u0003tG\u0006d\u0017-\u0003\u0002[+\n\u00191+Z9\u0011\u0005q{V\"A/\u000b\u0005y\u001b\u0015AB:feZ,'/\u0003\u0002a;\nY1*\u00194lCN+'O^3s\u0003-\u0019XM\u001d<feN|F%Z9\u0015\u0005\r<\u0007C\u00013f\u001b\u00059\u0016B\u00014X\u0005\u0011)f.\u001b;\t\u000f!\u001c\u0011\u0011!a\u0001'\u0006\u0019\u0001\u0010J\u0019\u0002\u0011M,'O^3sg\u0002\nACZ5sgR\u001cuN\u001c;s_2dWM]#q_\u000eDW#\u00017\u0011\u0005\u0011l\u0017B\u00018X\u0005\rIe\u000e^\u0001\u0016M&\u00148\u000f^\"p]R\u0014x\u000e\u001c7fe\u0016\u0003xn\u00195!\u0003u1\u0017N]:u\u0007>tGO]8mY\u0016\u0014X\t]8dQj[g+\u001a:tS>t\u0017A\b4jeN$8i\u001c8ue>dG.\u001a:Fa>\u001c\u0007NW6WKJ\u001c\u0018n\u001c8!\u0003\u0015\u0019X\r^+q)\u0005\u0019\u0007FA\u0005v!\t180D\u0001x\u0015\tA\u00180A\u0003kk:LGOC\u0001{\u0003\ry'oZ\u0005\u0003y^\u0014aAQ3g_J,\u0017\u0001\u0003;fCJ$un\u001e8)\u0005)y\bc\u0001<\u0002\u0002%\u0019\u00111A<\u0003\u000b\u00053G/\u001a:\u0002!Q,7\u000f^#naRL8\t\\;ti\u0016\u0014\bfA\u0006\u0002\nA\u0019a/a\u0003\n\u0007\u00055qO\u0001\u0003UKN$\u0018!\f;fgR\u001cuN\u001c;s_2dWM]#q_\u000eD\u0007+\u001a:tSN$8o\u00165f]\u0006cGN\u0011:pW\u0016\u00148\u000fR8x]\"\u001aA\"!\u0003\u0002WQ,7\u000f^\"p]R\u0014x\u000e\u001c7fe6{g/Z%oGJ,W.\u001a8ug\u000e{g\u000e\u001e:pY2,'/\u00129pG\"D3!DA\u0005\u0003\u0015\"Xm\u001d;NKR\fG-\u0019;b!J|\u0007/Y4bi&|gn\u00148D_:$(o\u001c7QY\u0006tW\rK\u0002\u000f\u0003\u0013\tQ\u0005^3ti6+G/\u00193bi\u0006\u0004&o\u001c9bO\u0006$\u0018n\u001c8P]\n\u0013xn[3s\u0007\"\fgnZ3)\u0007=\tI!A\u0015uKN$X*\u001a;bI\u0006$\u0018\r\u0015:pa\u0006<\u0017\r^5p]\u001a{'o\u00144gY&tWMU3qY&\u001c\u0017m\u001d\u0015\u0004!\u0005%\u0011!\u0005;fgR$v\u000e]5d\u0007J,\u0017\r^5p]\"\u001a\u0011#!\u0003\u0002GQ,7\u000f\u001e+pa&\u001c7I]3bi&|gnV5uQ>3g\r\\5oKJ+\u0007\u000f\\5dC\"\u001a!#!\u0003\u00027Q,7\u000f\u001e+pa&\u001c\u0007+\u0019:uSRLwN\\#ya\u0006t7/[8oQ\r\u0019\u0012\u0011B\u0001.i\u0016\u001cH\u000fV8qS\u000e\u0004\u0016M\u001d;ji&|g.\u0012=qC:\u001c\u0018n\u001c8XSRDwJ\u001a4mS:,'+\u001a9mS\u000e\f\u0007f\u0001\u000b\u0002\n\u0005IB/Z:u!\u0006\u0014H/\u001b;j_:\u0014V-Y:tS\u001etW.\u001a8uQ\r)\u0012\u0011B\u00013i\u0016\u001cH\u000fU1si&$\u0018n\u001c8SK\u0006\u001c8/[4o[\u0016tG\u000fV8Ce>\\WM],ji\"|eM\u001a7j]\u0016dun\u001a#je\"\u001aa#!\u0003\u0002uQ,7\u000f\u001e)beRLG/[8o%\u0016\f7o]5h]6,g\u000e^,ji\"|eM\u001a7j]\u0016\u0014V\r\u001d7jG\u0006D\u0015\r\u001c;j]\u001e\u0004&o\\4sKN\u001c\bfA\f\u0002\n\u00059D/Z:u!\u0006\u0014H/\u001b;j_:\u0014V-Y:tS\u001etW.\u001a8u%\u0016\u001cX/\\3t\u0003\u001a$XM\u001d*fa2L7-Y\"p[\u0016\u001cxJ\u001c7j]\u0016D3\u0001GA\u0005\u0003\t\"Xm\u001d;Qe\u00164WM\u001d:fIJ+\u0007\u000f\\5dC2+\u0017\rZ3s\u000b2,7\r^5p]\"\u001a\u0011$!\u0003\u0002[Q,7\u000f\u001e\"bG.$vNQ1dWB\u0013XMZ3se\u0016$'+\u001a9mS\u000e\fG*Z1eKJ,E.Z2uS>t7\u000fK\u0002\u001b\u0003\u0013\tQ\b^3tiB\u0013XMZ3se\u0016$'+\u001a9mS\u000e\fG*Z1eKJ,E.Z2uS>tw+\u001b;i\u001f\u001a4G.\u001b8f!J,g-\u001a:sK\u0012\u0014V\r\u001d7jG\u0006D3aGA\u0005\u0003\u0019\"Xm\u001d;BkR|\u0007K]3gKJ\u0014X\r\u001a*fa2L7-\u0019'fC\u0012,'/\u00127fGRLwN\u001c\u0015\u00049\u0005%\u0011\u0001\u0012;fgRdU-\u00193fe\u0006sG-S:s/\",g.\u00128uSJ,\u0017j\u001d:PM\u001ad\u0017N\\3B]\u0012,fn\u00197fC:dU-\u00193fe\u0016cWm\u0019;j_:$\u0015n]1cY\u0016$\u0007fA\u000f\u0002\n\u0005\u0019E/Z:u\u0019\u0016\fG-\u001a:B]\u0012L5O],iK:,e\u000e^5sK&\u001b(o\u00144gY&tW-\u00118e+:\u001cG.Z1o\u0019\u0016\fG-\u001a:FY\u0016\u001cG/[8o\u000b:\f'\r\\3eQ\rq\u0012\u0011B\u0001\u0017i\u0016\u001cHoQ8oiJ|G\u000e\\3e'\",H\u000fZ8x]\"\u001aq$!\u0003\u0002\u0003R,7\u000f^\"p]R\u0014x\u000e\u001c7feJ+'.Z2u\u0007>tGO]8mY\u0016$7\u000b[;uI><hNU3rk\u0016\u001cHoV5uQN#\u0018\r\\3Ce>\\WM]#q_\u000eD\u0007f\u0001\u0011\u0002\n\u0005\tC/Z:u\u0007>tGO]8mY\u0016\u0014Xj\u001c<f\u001f:$v\u000e]5d\u0007J,\u0017\r^5p]\"\u001a\u0011%!\u0003\u0002CQ,7\u000f^\"p]R\u0014x\u000e\u001c7fe6{g/Z(o)>\u0004\u0018n\u0019#fY\u0016$\u0018n\u001c8)\u0007\t\nI!\u0001\u0017uKN$8i\u001c8ue>dG.\u001a:N_Z,wJ\u001c)sK\u001a,'O]3e%\u0016\u0004H.[2b\u000b2,7\r^5p]\"\u001a1%!\u0003\u0002SQ,7\u000f^\"p]R\u0014x\u000e\u001c7fe6{g/Z(o!\u0006\u0014H/\u001b;j_:\u0014V-Y:tS\u001etW.\u001a8uQ\r!\u0013\u0011B\u0001Yi\u0016\u001cHoQ8oiJ|G\u000e\\3s\r\u0016\fG/\u001e:f5:{G-Z*fiV\u0004x\u000b[3o\r\u0016\fG/\u001e:f-\u0016\u00148/[8oS:<\u0017j]#oC\ndW\rZ,ji\"tuN\\#ySN$\u0018N\\4GK\u0006$XO]3[\u001d>$W\rK\u0002&\u0003\u0013\tQ\f^3ti\u000e{g\u000e\u001e:pY2,'OR3biV\u0014XM\u0017(pI\u0016\u001cV\r^;q/\",gNR3biV\u0014XMV3sg&|g.\u001b8h\u0013N,e.\u00192mK\u0012<\u0016\u000e\u001e5ESN\f'\r\\3e\u000bbL7\u000f^5oO\u001a+\u0017\r^;sKjsu\u000eZ3)\u0007\u0019\nI!\u0001/uKN$8i\u001c8ue>dG.\u001a:GK\u0006$XO]3[\u001d>$WmU3ukB<\u0006.\u001a8GK\u0006$XO]3WKJ\u001c\u0018n\u001c8j]\u001eL5/\u00128bE2,GmV5uQ\u0016s\u0017M\u00197fI\u0016C\u0018n\u001d;j]\u001e4U-\u0019;ve\u0016Tfj\u001c3fQ\r9\u0013\u0011B\u0001Zi\u0016\u001cHoQ8oiJ|G\u000e\\3s\r\u0016\fG/\u001e:f5:{G-Z*fiV\u0004x\u000b[3o\r\u0016\fG/\u001e:f-\u0016\u00148/[8oS:<\u0017j\u001d#jg\u0006\u0014G.\u001a3XSRDgj\u001c8Fq&\u001cH/\u001b8h\r\u0016\fG/\u001e:f5:{G-\u001a\u0015\u0004Q\u0005%\u0011A\u0018;fgR\u001cuN\u001c;s_2dWM\u001d$fCR,(/\u001a.O_\u0012,7+\u001a;va^CWM\u001c$fCR,(/\u001a,feNLwN\\5oO&\u001bH)[:bE2,GmV5uQ\u0012K7/\u00192mK\u0012,\u00050[:uS:<g)Z1ukJ,'LT8eK\"\u001a\u0011&!\u0003\u0002;R,7\u000f^\"p]R\u0014x\u000e\u001c7fe\u001a+\u0017\r^;sKjsu\u000eZ3TKR,\bo\u00165f]\u001a+\u0017\r^;sKZ+'o]5p]&tw-S:ESN\f'\r\\3e/&$\b.\u00128bE2,G-\u0012=jgRLgn\u001a$fCR,(/\u001a.O_\u0012,\u0007f\u0001\u0016\u0002\n\u0005\u0019C/Z:u\u0007>tGO]8mY\u0016\u0014H)\u001a;fGR\u001c(i\\;oG\u0016$'I]8lKJ\u001c\bfA\u0016\u0002\n\u0005\u0011C/Z:u!J,W-\u001c9uS>twJ\\\"p]R\u0014x\u000e\u001c7feNCW\u000f\u001e3po:D3\u0001LA\u0005\u0003m!Xm\u001d;Qe\u0016,W\u000e\u001d;j_:<\u0016\u000e\u001e5DC2d'-Y2lg\"\u001aQ&!\u0003\u0002?Q,7\u000f^\"p]R\u0014x\u000e\u001c7fe\u001a+\u0017\r^;sKjsu\u000eZ3TKR,\b\u000fF\u0003d\u00037\u000bY\u000bC\u0004\u0002\u001e:\u0002\r!a(\u0002\u0019%t\u0017\u000e^5bYjsu\u000eZ3\u0011\u000b\u0011\f\t+!*\n\u0007\u0005\rvK\u0001\u0004PaRLwN\u001c\t\u0004\u0011\u0006\u001d\u0016bAAU\u0013\naa)Z1ukJ,'LT8eK\"9\u0011Q\u0016\u0018A\u0002\u0005=\u0016AG5oi\u0016\u0014(I]8lKJ\u0004&o\u001c;pG>dg+\u001a:tS>t\u0007\u0003BAY\u0003ok!!a-\u000b\u0007\u0005U6)A\u0002ba&LA!!/\u00024\nQ\u0011\t]5WKJ\u001c\u0018n\u001c8\u0002-Q,7\u000f^%eK6\u0004x\u000e^3oi\u0006cG/\u001a:JgJD3aLA\u0005\u0003I!Xm\u001d;D_:$(o\u001c7mKJluN^3\u0015\u0007\r\f\u0019\rC\u0004\u0002FB\u0002\r!a2\u0002\u0007\u0019,h\u000e\u0005\u0003e\u0003\u0013\u001c\u0017bAAf/\nIa)\u001e8di&|g\u000eM\u0001\u001faJ,g-\u001a:sK\u0012\u0014V\r\u001d7jG\u0006dU-\u00193fe\u0016cWm\u0019;j_:$2bYAi\u0003+\fI.a<\u0003\n!1\u00111[\u0019A\u00021\fAbY8oiJ|G\u000e\\3s\u0013\u0012Da!a62\u0001\u0004Y\u0016aC8uQ\u0016\u0014(I]8lKJDq!a72\u0001\u0004\ti.\u0001\u0002uaB!\u0011q\\Av\u001b\t\t\tO\u0003\u0003\u0002d\u0006\u0015\u0018AB2p[6|gNC\u0002E\u0003OT1!!;z\u0003\u0019\t\u0007/Y2iK&!\u0011Q^Aq\u00059!v\u000e]5d!\u0006\u0014H/\u001b;j_:Dq!!=2\u0001\u0004\t\u00190\u0001\u0005sKBd\u0017nY1t!\u0015\t)Pa\u0001m\u001d\u0011\t90a@\u0011\u0007\u0005ex+\u0004\u0002\u0002|*\u0019\u0011Q`#\u0002\rq\u0012xn\u001c;?\u0013\r\u0011\taV\u0001\u0007!J,G-\u001a4\n\t\t\u0015!q\u0001\u0002\u0004'\u0016$(b\u0001B\u0001/\"1!1B\u0019A\u00021\f1\u0002\\3bI\u0016\u0014X\t]8dQ\u0006Ar/Y5u+:$\u0018\u000e\\\"p]R\u0014x\u000e\u001c7fe\u0016\u0003xn\u00195\u0015\u000b\r\u0014\tB!\u0006\t\r\tM!\u00071\u0001m\u0003\u0015)\u0007o\\2i\u0011\u001d\u00119B\ra\u0001\u00053\tq!\\3tg\u0006<W\r\u0005\u0003\u0002v\nm\u0011\u0002\u0002B\u000f\u0005\u000f\u0011aa\u0015;sS:<\u0017!F<bSR4uN\u001d)beRLG/[8o'R\fG/\u001a\u000b\fG\n\r\"Q\u0005B\u0015\u0005[\u0011y\u0003C\u0004\u0002\\N\u0002\r!!8\t\r\t\u001d2\u00071\u0001m\u0003=\u0019wN\u001c;s_2dWM]#q_\u000eD\u0007B\u0002B\u0016g\u0001\u0007A.\u0001\u0004mK\u0006$WM\u001d\u0005\u0007\u0005\u0017\u0019\u0004\u0019\u00017\t\u000f\t]1\u00071\u0001\u0003\u001a\u0005A\u0012n]#ya\u0016\u001cG/\u001a3QCJ$\u0018\u000e^5p]N#\u0018\r^3\u0015\u0015\tU\"1\bB#\u0005\u000f\u0012I\u0005E\u0002e\u0005oI1A!\u000fX\u0005\u001d\u0011un\u001c7fC:DqA!\u00105\u0001\u0004\u0011y$A\u000emK\u0006$WM]%te\u0006sGmQ8oiJ|G\u000e\\3s\u000bB|7\r\u001b\t\u0004!\n\u0005\u0013b\u0001B\"\u0003\nYB*Z1eKJL5O]!oI\u000e{g\u000e\u001e:pY2,'/\u00129pG\"DaAa\n5\u0001\u0004a\u0007B\u0002B\u0016i\u0001\u0007A\u000e\u0003\u0004\u0003\fQ\u0002\r\u0001\\\u0001\f[\u0006\\WmU3sm\u0016\u00148\u000fF\nT\u0005\u001f\u0012\u0019Fa\u0016\u0003\\\t}#Q\rB5\u0005[\u0012\t\b\u0003\u0004\u0003RU\u0002\r\u0001\\\u0001\u000b]Vl7i\u001c8gS\u001e\u001c\b\"\u0003B+kA\u0005\t\u0019\u0001B\u001b\u0003e\tW\u000f^8MK\u0006$WM\u001d*fE\u0006d\u0017M\\2f\u000b:\f'\r\\3\t\u0013\teS\u0007%AA\u0002\tU\u0012aG;oG2,\u0017M\u001c'fC\u0012,'/\u00127fGRLwN\\#oC\ndW\rC\u0005\u0003^U\u0002\n\u00111\u0001\u00036\u0005ARM\\1cY\u0016\u001cuN\u001c;s_2dW\rZ*ikR$wn\u001e8\t\u0013\t\u0005T\u0007%AA\u0002\t\r\u0014!\u00037jgR,g.\u001a:t!\u0015!\u0017\u0011\u0015B\r\u0011%\u00119'\u000eI\u0001\u0002\u0004\u0011\u0019'A\u000emSN$XM\\3s'\u0016\u001cWO]5usB\u0013x\u000e^8d_2l\u0015\r\u001d\u0005\n\u0005W*\u0004\u0013!a\u0001\u0005G\n\u0001dY8oiJ|G\u000e\u00157b]\u0016d\u0015n\u001d;f]\u0016\u0014h*Y7f\u0011%\ti+\u000eI\u0001\u0002\u0004\u0011y\u0007E\u0003e\u0003C\u000by\u000b\u0003\u0005\u0003tU\u0002\n\u00111\u0001m\u0003-awn\u001a#je\u000e{WO\u001c;\u0002+5\f7.Z*feZ,'o\u001d\u0013eK\u001a\fW\u000f\u001c;%eU\u0011!\u0011\u0010\u0016\u0005\u0005k\u0011Yh\u000b\u0002\u0003~A!!q\u0010BE\u001b\t\u0011\tI\u0003\u0003\u0003\u0004\n\u0015\u0015!C;oG\",7m[3e\u0015\r\u00119iV\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002\u0002BF\u0005\u0003\u0013\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0003Ui\u0017m[3TKJ4XM]:%I\u00164\u0017-\u001e7uIM\nQ#\\1lKN+'O^3sg\u0012\"WMZ1vYR$C'A\u000bnC.,7+\u001a:wKJ\u001cH\u0005Z3gCVdG\u000fJ\u001b\u0016\u0005\tU%\u0006\u0002B2\u0005w\nQ#\\1lKN+'O^3sg\u0012\"WMZ1vYR$c'A\u000bnC.,7+\u001a:wKJ\u001cH\u0005Z3gCVdG\u000fJ\u001c\u0002+5\f7.Z*feZ,'o\u001d\u0013eK\u001a\fW\u000f\u001c;%qU\u0011!q\u0014\u0016\u0005\u0005_\u0012Y(A\u000bnC.,7+\u001a:wKJ\u001cH\u0005Z3gCVdG\u000fJ\u001d\u0016\u0005\t\u0015&f\u00017\u0003|\u0005)A/[7feR!!1\u0016Bb!\u0011\u0011iKa0\u000e\u0005\t=&\u0002\u0002BY\u0005g\u000bAaY8sK*!!Q\u0017B\\\u0003\u001diW\r\u001e:jGNTAA!/\u0003<\u00061\u00110Y7nKJT!A!0\u0002\u0007\r|W.\u0003\u0003\u0003B\n=&!\u0002+j[\u0016\u0014\bb\u0002Bc}\u0001\u0007!\u0011D\u0001\u000b[\u0016$(/[2OC6,\u0017!D4fi\u000e{g\u000e\u001e:pY2,'\u000fF\u0001\\\u0001")
public class ControllerIntegrationTest
extends ZooKeeperTestHarness {
    private Seq<KafkaServer> servers = (Seq)Seq$.MODULE$.empty();
    private final int firstControllerEpoch = KafkaController$.MODULE$.InitialControllerEpoch() + 1;
    private final int firstControllerEpochZkVersion = KafkaController$.MODULE$.InitialControllerEpochZkVersion() + 1;

    public Seq<KafkaServer> servers() {
        return this.servers;
    }

    public void servers_$eq(Seq<KafkaServer> x$1) {
        this.servers = x$1;
    }

    public int firstControllerEpoch() {
        return this.firstControllerEpoch;
    }

    public int firstControllerEpochZkVersion() {
        return this.firstControllerEpochZkVersion;
    }

    @Override
    @Before
    public void setUp() {
        super.setUp();
        this.servers_$eq((Seq<KafkaServer>)((Seq)Seq$.MODULE$.empty()));
    }

    @Override
    @After
    public void tearDown() {
        TestUtils$.MODULE$.shutdownServers(this.servers());
        super.tearDown();
    }

    @Test
    public void testEmptyCluster() {
        this.servers_$eq(this.makeServers(1, false, false, true, (Option<String>)None$.MODULE$, (Option<String>)None$.MODULE$, (Option<String>)None$.MODULE$, (Option<ApiVersion>)None$.MODULE$, 1));
        long l = 15000L;
        long l2 = 100L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!ControllerIntegrationTest.$anonfun$testEmptyCluster$1(this)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime + l) {
                throw Assertions$.MODULE$.fail("failed to elect a controller", new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 847));
            }
            Thread.sleep(Math.min(l, l2));
        }
        this.waitUntilControllerEpoch(this.firstControllerEpoch(), "broker failed to set controller epoch");
    }

    @Test
    public void testControllerEpochPersistsWhenAllBrokersDown() {
        this.servers_$eq(this.makeServers(1, false, false, true, (Option<String>)None$.MODULE$, (Option<String>)None$.MODULE$, (Option<String>)None$.MODULE$, (Option<ApiVersion>)None$.MODULE$, 1));
        long l = 15000L;
        long l2 = 100L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!ControllerIntegrationTest.$anonfun$testControllerEpochPersistsWhenAllBrokersDown$1(this)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime + l) {
                throw Assertions$.MODULE$.fail("failed to elect a controller", new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 847));
            }
            Thread.sleep(Math.min(l, l2));
        }
        this.waitUntilControllerEpoch(this.firstControllerEpoch(), "broker failed to set controller epoch");
        ((KafkaServer)this.servers().head()).shutdown();
        ((KafkaServer)this.servers().head()).awaitShutdown();
        long l3 = 15000L;
        long l4 = 100L;
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!ControllerIntegrationTest.$anonfun$testControllerEpochPersistsWhenAllBrokersDown$3(this)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + l3) {
                throw Assertions$.MODULE$.fail("failed to kill controller", new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 847));
            }
            Thread.sleep(Math.min(l3, l4));
        }
        this.waitUntilControllerEpoch(this.firstControllerEpoch(), "controller epoch was not persisted after broker failure");
    }

    @Test
    public void testControllerMoveIncrementsControllerEpoch() {
        this.servers_$eq(this.makeServers(1, false, false, true, (Option<String>)None$.MODULE$, (Option<String>)None$.MODULE$, (Option<String>)None$.MODULE$, (Option<ApiVersion>)None$.MODULE$, 1));
        long l = 15000L;
        long l2 = 100L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!ControllerIntegrationTest.$anonfun$testControllerMoveIncrementsControllerEpoch$1(this)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime + l) {
                throw Assertions$.MODULE$.fail("failed to elect a controller", new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 847));
            }
            Thread.sleep(Math.min(l, l2));
        }
        this.waitUntilControllerEpoch(this.firstControllerEpoch(), "broker failed to set controller epoch");
        ((KafkaServer)this.servers().head()).shutdown();
        ((KafkaServer)this.servers().head()).awaitShutdown();
        ((KafkaServer)this.servers().head()).startup();
        long l3 = 15000L;
        long l4 = 100L;
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!ControllerIntegrationTest.$anonfun$testControllerMoveIncrementsControllerEpoch$3(this)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + l3) {
                throw Assertions$.MODULE$.fail("failed to elect a controller", new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 847));
            }
            Thread.sleep(Math.min(l3, l4));
        }
        this.waitUntilControllerEpoch(this.firstControllerEpoch() + 1, "controller epoch was not incremented after controller move");
    }

    @Test
    public void testMetadataPropagationOnControlPlane() {
        None$ none$;
        Some x$2 = new Some((Object)"PLAINTEXT://localhost:0,CONTROLLER://localhost:0");
        Some x$3 = new Some((Object)"PLAINTEXT:PLAINTEXT,CONTROLLER:PLAINTEXT");
        Some x$4 = new Some((Object)"CONTROLLER");
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = true;
        None$ none$2 = none$ = None$.MODULE$;
        none$ = null;
        None$ x$8 = none$2;
        int n = 1;
        this.servers_$eq(this.makeServers(1, bl, bl2, bl3, (Option<String>)x$2, (Option<String>)x$3, (Option<String>)x$4, (Option<ApiVersion>)x$8, n));
        TestUtils$.MODULE$.waitUntilBrokerMetadataIsPropagated(this.servers(), 15000L);
        scala.collection.mutable.Map controlPlaneMetricMap = (scala.collection.mutable.Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$);
        scala.collection.mutable.Map dataPlaneMetricMap = (scala.collection.mutable.Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$);
        ((KafkaServer)this.servers().head()).metrics().metrics().values().forEach(kafkaMetric -> {
            if (kafkaMetric.metricName().tags().values().contains("CONTROLLER")) {
                controlPlaneMetricMap.put((Object)kafkaMetric.metricName().name(), kafkaMetric);
            }
            if (kafkaMetric.metricName().tags().values().contains("PLAINTEXT")) {
                dataPlaneMetricMap.put((Object)kafkaMetric.metricName().name(), kafkaMetric);
            }
        });
        Assert.assertEquals((double)1.0, (double)BoxesRunTime.unboxToDouble((Object)((KafkaMetric)controlPlaneMetricMap.apply((Object)"response-total")).metricValue()), (double)0.0);
        Assert.assertEquals((double)0.0, (double)BoxesRunTime.unboxToDouble((Object)((KafkaMetric)dataPlaneMetricMap.apply((Object)"response-total")).metricValue()), (double)0.0);
        Assert.assertEquals((double)1.0, (double)BoxesRunTime.unboxToDouble((Object)((KafkaMetric)controlPlaneMetricMap.apply((Object)"request-total")).metricValue()), (double)0.0);
        Assert.assertEquals((double)0.0, (double)BoxesRunTime.unboxToDouble((Object)((KafkaMetric)dataPlaneMetricMap.apply((Object)"request-total")).metricValue()), (double)0.0);
        Assert.assertTrue((BoxesRunTime.unboxToDouble((Object)((KafkaMetric)controlPlaneMetricMap.apply((Object)"incoming-byte-total")).metricValue()) > 1.0 ? 1 : 0) != 0);
        Assert.assertTrue((BoxesRunTime.unboxToDouble((Object)((KafkaMetric)dataPlaneMetricMap.apply((Object)"incoming-byte-total")).metricValue()) == 0.0 ? 1 : 0) != 0);
        Assert.assertTrue((BoxesRunTime.unboxToDouble((Object)((KafkaMetric)controlPlaneMetricMap.apply((Object)"network-io-total")).metricValue()) == 2.0 ? 1 : 0) != 0);
        Assert.assertTrue((BoxesRunTime.unboxToDouble((Object)((KafkaMetric)dataPlaneMetricMap.apply((Object)"network-io-total")).metricValue()) == 0.0 ? 1 : 0) != 0);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testMetadataPropagationOnBrokerChange() {
        void $minus$greater$extension_y;
        void $minus$greater$extension_y2;
        this.servers_$eq(this.makeServers(3, false, false, true, (Option<String>)None$.MODULE$, (Option<String>)None$.MODULE$, (Option<String>)None$.MODULE$, (Option<ApiVersion>)None$.MODULE$, 1));
        TestUtils$.MODULE$.waitUntilBrokerMetadataIsPropagated(this.servers(), 15000L);
        int controllerId = TestUtils$.MODULE$.waitUntilControllerElected(this.zkClient(), 15000L);
        KafkaServer testBroker = (KafkaServer)((IterableOps)this.servers().filter((Function1 & Serializable)e -> BoxesRunTime.boxToBoolean((boolean)ControllerIntegrationTest.$anonfun$testMetadataPropagationOnBrokerChange$1(controllerId, e)))).head();
        Seq remainingBrokers = (Seq)this.servers().filter((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)ControllerIntegrationTest.$anonfun$testMetadataPropagationOnBrokerChange$2(testBroker, x$1)));
        String topic = "topic1";
        Object[] objectArray = new Tuple2[2];
        SeqOps seqOps = Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{((KafkaServer)remainingBrokers.apply(0)).config().brokerId(), testBroker.config().brokerId()}));
        Integer $minus$greater$extension_$this = 0;
        Object var6_6 = null;
        seqOps = null;
        objectArray[0] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y2);
        Object object = remainingBrokers.map((Function1 & Serializable)x$2 -> BoxesRunTime.boxToInteger((int)ControllerIntegrationTest.$anonfun$testMetadataPropagationOnBrokerChange$3(x$2)));
        Integer $minus$greater$extension_$this2 = 1;
        Object var8_8 = null;
        object = null;
        objectArray[1] = new Tuple2((Object)$minus$greater$extension_$this2, (Object)$minus$greater$extension_y);
        Map assignment = (Map)scala.collection.Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
        TestUtils$.MODULE$.createTopic(this.zkClient(), topic, (Map<Object, Seq<Object>>)assignment, this.servers());
        testBroker.shutdown();
        testBroker.awaitShutdown();
        TestUtils$.MODULE$.waitUntilBrokerMetadataIsPropagated((Seq<KafkaServer>)remainingBrokers, 15000L);
        remainingBrokers.foreach((Function1 & Serializable)server -> {
            ControllerIntegrationTest.$anonfun$testMetadataPropagationOnBrokerChange$4(topic, testBroker, assignment, remainingBrokers, server);
            return BoxedUnit.UNIT;
        });
        testBroker.startup();
        long l = 15000L;
        long l2 = 100L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!ControllerIntegrationTest.$anonfun$testMetadataPropagationOnBrokerChange$5(this, assignment, topic)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime + l) {
                throw Assertions$.MODULE$.fail("Inconsistent metadata after broker startup", new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 847));
            }
            Thread.sleep(Math.min(l, l2));
        }
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testMetadataPropagationForOfflineReplicas() {
        void $minus$greater$extension_y;
        this.servers_$eq(this.makeServers(3, false, false, true, (Option<String>)None$.MODULE$, (Option<String>)None$.MODULE$, (Option<String>)None$.MODULE$, (Option<ApiVersion>)None$.MODULE$, 1));
        TestUtils$.MODULE$.waitUntilBrokerMetadataIsPropagated(this.servers(), 15000L);
        int controllerId = TestUtils$.MODULE$.waitUntilControllerElected(this.zkClient(), 15000L);
        KafkaServer replicaBroker = (KafkaServer)((IterableOps)this.servers().filter((Function1 & Serializable)e -> BoxesRunTime.boxToBoolean((boolean)ControllerIntegrationTest.$anonfun$testMetadataPropagationForOfflineReplicas$1(controllerId, e)))).head();
        KafkaServer controllerBroker = (KafkaServer)((IterableOps)this.servers().filter((Function1 & Serializable)e -> BoxesRunTime.boxToBoolean((boolean)ControllerIntegrationTest.$anonfun$testMetadataPropagationForOfflineReplicas$2(controllerId, e)))).head();
        KafkaServer otherBroker = (KafkaServer)((IterableOps)this.servers().filter((Function1 & Serializable)e -> BoxesRunTime.boxToBoolean((boolean)ControllerIntegrationTest.$anonfun$testMetadataPropagationForOfflineReplicas$3(controllerId, replicaBroker, e)))).head();
        String topic = "topic1";
        Object[] objectArray = new Tuple2[1];
        SeqOps seqOps = Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{replicaBroker.config().brokerId()}));
        Integer $minus$greater$extension_$this = 0;
        Object var7_7 = null;
        seqOps = null;
        objectArray[0] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
        Map assignment = (Map)scala.collection.Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
        TestUtils$.MODULE$.createTopic(this.zkClient(), topic, (Map<Object, Seq<Object>>)assignment, this.servers());
        otherBroker.shutdown();
        otherBroker.awaitShutdown();
        replicaBroker.shutdown();
        replicaBroker.awaitShutdown();
        controllerBroker.shutdown();
        controllerBroker.awaitShutdown();
        ControllerIntegrationTest.verifyMetadata$1(controllerBroker, topic);
        ControllerIntegrationTest.verifyMetadata$1(otherBroker, topic);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testTopicCreation() {
        void $minus$greater$extension_y;
        this.servers_$eq(this.makeServers(1, false, false, true, (Option<String>)None$.MODULE$, (Option<String>)None$.MODULE$, (Option<String>)None$.MODULE$, (Option<ApiVersion>)None$.MODULE$, 1));
        TopicPartition tp = new TopicPartition("t", 0);
        Object[] objectArray = new Tuple2[1];
        SeqOps seqOps = Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0}));
        Integer $minus$greater$extension_$this = tp.partition();
        Object var3_3 = null;
        seqOps = null;
        objectArray[0] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
        Map assignment = (Map)scala.collection.Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
        TestUtils$.MODULE$.createTopic(this.zkClient(), tp.topic(), (Map<Object, Seq<Object>>)assignment, this.servers());
        this.waitForPartitionState(tp, this.firstControllerEpoch(), 0, LeaderAndIsr$.MODULE$.initialLeaderEpoch(), "failed to get expected partition state upon topic creation");
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testTopicCreationWithOfflineReplica() {
        void $minus$greater$extension_y;
        this.servers_$eq(this.makeServers(2, false, false, true, (Option<String>)None$.MODULE$, (Option<String>)None$.MODULE$, (Option<String>)None$.MODULE$, (Option<ApiVersion>)None$.MODULE$, 1));
        int controllerId = TestUtils$.MODULE$.waitUntilControllerElected(this.zkClient(), 15000L);
        int otherBrokerId = BoxesRunTime.unboxToInt((Object)((IterableOps)((IterableOps)this.servers().map((Function1 & Serializable)x$3 -> BoxesRunTime.boxToInteger((int)ControllerIntegrationTest.$anonfun$testTopicCreationWithOfflineReplica$1(x$3)))).filter((Function1)(JFunction1.mcZI.sp & Serializable)x$4 -> x$4 != controllerId)).head());
        ((KafkaServer)this.servers().apply(otherBrokerId)).shutdown();
        ((KafkaServer)this.servers().apply(otherBrokerId)).awaitShutdown();
        TopicPartition tp = new TopicPartition("t", 0);
        Object[] objectArray = new Tuple2[1];
        SeqOps seqOps = Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{otherBrokerId, controllerId}));
        Integer $minus$greater$extension_$this = tp.partition();
        Object var5_5 = null;
        seqOps = null;
        objectArray[0] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
        Map assignment = (Map)scala.collection.Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
        TestUtils$.MODULE$.createTopic(this.zkClient(), tp.topic(), (Map<Object, Seq<Object>>)assignment, (Seq<KafkaServer>)((Seq)this.servers().take(1)));
        this.waitForPartitionState(tp, this.firstControllerEpoch(), controllerId, LeaderAndIsr$.MODULE$.initialLeaderEpoch(), "failed to get expected partition state upon topic creation");
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testTopicPartitionExpansion() {
        void apply_removingReplicas;
        void apply_addingReplicas;
        ReplicaAssignment replicaAssignment;
        void apply_removingReplicas2;
        void apply_addingReplicas2;
        ReplicaAssignment replicaAssignment2;
        void $minus$greater$extension_y;
        this.servers_$eq(this.makeServers(1, false, false, true, (Option<String>)None$.MODULE$, (Option<String>)None$.MODULE$, (Option<String>)None$.MODULE$, (Option<ApiVersion>)None$.MODULE$, 1));
        TopicPartition tp0 = new TopicPartition("t", 0);
        TopicPartition tp1 = new TopicPartition("t", 1);
        Object[] objectArray = new Tuple2[1];
        SeqOps seqOps = Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0}));
        Integer $minus$greater$extension_$this = tp0.partition();
        Object var5_4 = null;
        seqOps = null;
        objectArray[0] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
        Map assignment = (Map)scala.collection.Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
        Object[] objectArray2 = new Tuple2[2];
        Nil$ nil$ = Nil$.MODULE$;
        Nil$ nil$2 = Nil$.MODULE$;
        Seq apply_replicas = (Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0}));
        ReplicaAssignment replicaAssignment3 = replicaAssignment2 = new ReplicaAssignment(apply_replicas, (Seq)apply_addingReplicas2, (Seq)apply_removingReplicas2);
        Object var9_8 = null;
        nil$2 = null;
        nil$ = null;
        replicaAssignment2 = null;
        ReplicaAssignment $minus$greater$extension_y2 = replicaAssignment3;
        Object var7_10 = null;
        objectArray2[0] = new Tuple2((Object)tp0, (Object)$minus$greater$extension_y2);
        Nil$ nil$3 = Nil$.MODULE$;
        Nil$ nil$4 = Nil$.MODULE$;
        Seq apply_replicas2 = (Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0}));
        ReplicaAssignment replicaAssignment4 = replicaAssignment = new ReplicaAssignment(apply_replicas2, (Seq)apply_addingReplicas, (Seq)apply_removingReplicas);
        Object var13_13 = null;
        nil$4 = null;
        nil$3 = null;
        replicaAssignment = null;
        ReplicaAssignment $minus$greater$extension_y3 = replicaAssignment4;
        Object var8_15 = null;
        objectArray2[1] = new Tuple2((Object)tp1, (Object)$minus$greater$extension_y3);
        Map expandedAssignment = (Map)scala.collection.Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray2));
        TestUtils$.MODULE$.createTopic(this.zkClient(), tp0.topic(), (Map<Object, Seq<Object>>)assignment, this.servers());
        this.zkClient().setTopicAssignment(tp0.topic(), expandedAssignment, this.firstControllerEpochZkVersion());
        this.waitForPartitionState(tp1, this.firstControllerEpoch(), 0, LeaderAndIsr$.MODULE$.initialLeaderEpoch(), "failed to get expected partition state upon topic partition expansion");
        TestUtils$.MODULE$.waitUntilMetadataIsPropagated(this.servers(), tp1.topic(), tp1.partition(), 15000L);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testTopicPartitionExpansionWithOfflineReplica() {
        void apply_removingReplicas;
        void apply_addingReplicas;
        ReplicaAssignment replicaAssignment;
        void apply_removingReplicas2;
        void apply_addingReplicas2;
        ReplicaAssignment replicaAssignment2;
        void $minus$greater$extension_y;
        this.servers_$eq(this.makeServers(2, false, false, true, (Option<String>)None$.MODULE$, (Option<String>)None$.MODULE$, (Option<String>)None$.MODULE$, (Option<ApiVersion>)None$.MODULE$, 1));
        int controllerId = TestUtils$.MODULE$.waitUntilControllerElected(this.zkClient(), 15000L);
        int otherBrokerId = BoxesRunTime.unboxToInt((Object)((IterableOps)((IterableOps)this.servers().map((Function1 & Serializable)x$5 -> BoxesRunTime.boxToInteger((int)ControllerIntegrationTest.$anonfun$testTopicPartitionExpansionWithOfflineReplica$1(x$5)))).filter((Function1)(JFunction1.mcZI.sp & Serializable)x$6 -> x$6 != controllerId)).head());
        TopicPartition tp0 = new TopicPartition("t", 0);
        TopicPartition tp1 = new TopicPartition("t", 1);
        Object[] objectArray = new Tuple2[1];
        SeqOps seqOps = Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{otherBrokerId, controllerId}));
        Integer $minus$greater$extension_$this = tp0.partition();
        Object var7_6 = null;
        seqOps = null;
        objectArray[0] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
        Map assignment = (Map)scala.collection.Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
        Object[] objectArray2 = new Tuple2[2];
        Nil$ nil$ = Nil$.MODULE$;
        Nil$ nil$2 = Nil$.MODULE$;
        Seq apply_replicas = (Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{otherBrokerId, controllerId}));
        ReplicaAssignment replicaAssignment3 = replicaAssignment2 = new ReplicaAssignment(apply_replicas, (Seq)apply_addingReplicas2, (Seq)apply_removingReplicas2);
        Object var11_10 = null;
        nil$2 = null;
        nil$ = null;
        replicaAssignment2 = null;
        ReplicaAssignment $minus$greater$extension_y2 = replicaAssignment3;
        Object var9_12 = null;
        objectArray2[0] = new Tuple2((Object)tp0, (Object)$minus$greater$extension_y2);
        Nil$ nil$3 = Nil$.MODULE$;
        Nil$ nil$4 = Nil$.MODULE$;
        Seq apply_replicas2 = (Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{otherBrokerId, controllerId}));
        ReplicaAssignment replicaAssignment4 = replicaAssignment = new ReplicaAssignment(apply_replicas2, (Seq)apply_addingReplicas, (Seq)apply_removingReplicas);
        Object var15_15 = null;
        nil$4 = null;
        nil$3 = null;
        replicaAssignment = null;
        ReplicaAssignment $minus$greater$extension_y3 = replicaAssignment4;
        Object var10_17 = null;
        objectArray2[1] = new Tuple2((Object)tp1, (Object)$minus$greater$extension_y3);
        Map expandedAssignment = (Map)scala.collection.Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray2));
        TestUtils$.MODULE$.createTopic(this.zkClient(), tp0.topic(), (Map<Object, Seq<Object>>)assignment, this.servers());
        ((KafkaServer)this.servers().apply(otherBrokerId)).shutdown();
        ((KafkaServer)this.servers().apply(otherBrokerId)).awaitShutdown();
        this.zkClient().setTopicAssignment(tp0.topic(), expandedAssignment, this.firstControllerEpochZkVersion());
        this.waitForPartitionState(tp1, this.firstControllerEpoch(), controllerId, LeaderAndIsr$.MODULE$.initialLeaderEpoch(), "failed to get expected partition state upon topic partition expansion");
        TestUtils$.MODULE$.waitUntilMetadataIsPropagated((Seq<KafkaServer>)new .colon.colon((Object)((KafkaServer)this.servers().apply(controllerId)), (List)Nil$.MODULE$), tp1.topic(), tp1.partition(), 15000L);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testPartitionReassignment() {
        void apply_removingReplicas;
        void apply_addingReplicas;
        ReplicaAssignment replicaAssignment;
        void $minus$greater$extension_y;
        this.servers_$eq(this.makeServers(2, false, false, true, (Option<String>)None$.MODULE$, (Option<String>)None$.MODULE$, (Option<String>)None$.MODULE$, (Option<ApiVersion>)None$.MODULE$, 1));
        int controllerId = TestUtils$.MODULE$.waitUntilControllerElected(this.zkClient(), 15000L);
        String metricName = new StringBuilder(43).append("kafka.controller:type=ControllerStats,name=").append(new Some((Object)"PartitionReassignmentRateAndTimeMs").value()).toString();
        long timerCount = this.timer(metricName).count();
        int otherBrokerId = BoxesRunTime.unboxToInt((Object)((IterableOps)((IterableOps)this.servers().map((Function1 & Serializable)x$7 -> BoxesRunTime.boxToInteger((int)ControllerIntegrationTest.$anonfun$testPartitionReassignment$1(x$7)))).filter((Function1)(JFunction1.mcZI.sp & Serializable)x$8 -> x$8 != controllerId)).head());
        TopicPartition tp = new TopicPartition("t", 0);
        Object[] objectArray = new Tuple2[1];
        SeqOps seqOps = Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{controllerId}));
        Integer $minus$greater$extension_$this = tp.partition();
        Object var11_7 = null;
        seqOps = null;
        objectArray[0] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
        Map assignment = (Map)scala.collection.Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
        Object[] objectArray2 = new Tuple2[1];
        Nil$ nil$ = Nil$.MODULE$;
        Nil$ nil$2 = Nil$.MODULE$;
        Seq apply_replicas = (Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{otherBrokerId}));
        ReplicaAssignment replicaAssignment2 = replicaAssignment = new ReplicaAssignment(apply_replicas, (Seq)apply_addingReplicas, (Seq)apply_removingReplicas);
        Object var18_11 = null;
        nil$2 = null;
        nil$ = null;
        replicaAssignment = null;
        ReplicaAssignment $minus$greater$extension_y2 = replicaAssignment2;
        Object var13_13 = null;
        objectArray2[0] = new Tuple2((Object)tp, (Object)$minus$greater$extension_y2);
        Map reassignment = (Map)scala.collection.Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray2));
        TestUtils$.MODULE$.createTopic(this.zkClient(), tp.topic(), (Map<Object, Seq<Object>>)assignment, this.servers());
        this.zkClient().createPartitionReassignment((Map)reassignment.map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2;
            if (x0$1 == null) {
                throw new MatchError(null);
            }
            TopicPartition k = (TopicPartition)x0$1._1();
            ReplicaAssignment v = (ReplicaAssignment)x0$1._2();
            Seq $minus$greater$extension_y = v.replicas();
            Tuple2 tuple22 = tuple2 = new Tuple2((Object)k, (Object)$minus$greater$extension_y);
            Object var4_3 = null;
            tuple2 = null;
            Tuple2 tuple23 = tuple22;
            return tuple23;
        }));
        this.waitForPartitionState(tp, this.firstControllerEpoch(), otherBrokerId, LeaderAndIsr$.MODULE$.initialLeaderEpoch() + 3, "failed to get expected partition state after partition reassignment");
        long l = 15000L;
        long l2 = 100L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!ControllerIntegrationTest.$anonfun$testPartitionReassignment$4(this, tp, reassignment)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime + l) {
                throw Assertions$.MODULE$.fail("failed to get updated partition assignment on topic znode after partition reassignment", new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 847));
            }
            Thread.sleep(Math.min(l, l2));
        }
        long l3 = 15000L;
        long l4 = 100L;
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!ControllerIntegrationTest.$anonfun$testPartitionReassignment$6(this)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + l3) {
                throw Assertions$.MODULE$.fail("failed to remove reassign partitions path after completion", new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 847));
            }
            Thread.sleep(Math.min(l3, l4));
        }
        long updatedTimerCount = this.timer(metricName).count();
        Assert.assertTrue((String)new StringBuilder(36).append("Timer count ").append(updatedTimerCount).append(" should be greater than ").append(timerCount).toString(), (updatedTimerCount > timerCount ? 1 : 0) != 0);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testPartitionReassignmentToBrokerWithOfflineLogDir() {
        void apply_removingReplicas;
        void apply_addingReplicas;
        ReplicaAssignment replicaAssignment;
        void $minus$greater$extension_y;
        void $minus$greater$extension_y2;
        None$ none$;
        None$ none$2;
        None$ none$3;
        None$ none$4;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = true;
        None$ none$5 = none$4 = None$.MODULE$;
        none$4 = null;
        None$ x$6 = none$5;
        None$ none$6 = none$3 = None$.MODULE$;
        none$3 = null;
        None$ x$7 = none$6;
        None$ none$7 = none$2 = None$.MODULE$;
        none$2 = null;
        None$ x$8 = none$7;
        None$ none$8 = none$ = None$.MODULE$;
        none$ = null;
        None$ x$92 = none$8;
        this.servers_$eq(this.makeServers(2, bl, bl2, bl3, (Option<String>)x$6, (Option<String>)x$7, (Option<String>)x$8, (Option<ApiVersion>)x$92, 2));
        int controllerId = TestUtils$.MODULE$.waitUntilControllerElected(this.zkClient(), 15000L);
        String metricName = new StringBuilder(43).append("kafka.controller:type=ControllerStats,name=").append(new Some((Object)"PartitionReassignmentRateAndTimeMs").value()).toString();
        long timerCount = this.timer(metricName).count();
        KafkaServer otherBroker = (KafkaServer)((IterableOps)this.servers().filter((Function1 & Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)ControllerIntegrationTest.$anonfun$testPartitionReassignmentToBrokerWithOfflineLogDir$1(controllerId, x$9)))).head();
        int otherBrokerId = otherBroker.config().brokerId();
        TopicPartition topicPartitionToPutOffline = new TopicPartition("filler", 0);
        Object[] objectArray = new Tuple2[1];
        SeqOps seqOps = Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{otherBrokerId}));
        Integer $minus$greater$extension_$this = topicPartitionToPutOffline.partition();
        Object var17_19 = null;
        seqOps = null;
        objectArray[0] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y2);
        TestUtils$.MODULE$.createTopic(this.zkClient(), topicPartitionToPutOffline.topic(), (Map<Object, Seq<Object>>)((Map)scala.collection.Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray))), this.servers());
        TestUtils$.MODULE$.causeLogDirFailure(TestUtils$Checkpoint$.MODULE$, otherBroker, topicPartitionToPutOffline);
        TopicPartition tp = new TopicPartition("t", 0);
        Object[] objectArray2 = new Tuple2[1];
        SeqOps seqOps2 = Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{controllerId}));
        Integer $minus$greater$extension_$this2 = tp.partition();
        Object var19_22 = null;
        seqOps2 = null;
        objectArray2[0] = new Tuple2((Object)$minus$greater$extension_$this2, (Object)$minus$greater$extension_y);
        Map assignment = (Map)scala.collection.Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray2));
        Object[] objectArray3 = new Tuple2[1];
        Nil$ nil$ = Nil$.MODULE$;
        Nil$ nil$2 = Nil$.MODULE$;
        Seq apply_replicas = (Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{otherBrokerId}));
        ReplicaAssignment replicaAssignment2 = replicaAssignment = new ReplicaAssignment(apply_replicas, (Seq)apply_addingReplicas, (Seq)apply_removingReplicas);
        Object var26_26 = null;
        nil$2 = null;
        nil$ = null;
        replicaAssignment = null;
        ReplicaAssignment $minus$greater$extension_y3 = replicaAssignment2;
        Object var21_28 = null;
        objectArray3[0] = new Tuple2((Object)tp, (Object)$minus$greater$extension_y3);
        Map reassignment = (Map)scala.collection.Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray3));
        TestUtils$.MODULE$.createTopic(this.zkClient(), tp.topic(), (Map<Object, Seq<Object>>)assignment, this.servers());
        this.zkClient().createPartitionReassignment((Map)reassignment.map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2;
            if (x0$1 == null) {
                throw new MatchError(null);
            }
            TopicPartition k = (TopicPartition)x0$1._1();
            ReplicaAssignment v = (ReplicaAssignment)x0$1._2();
            Seq $minus$greater$extension_y = v.replicas();
            Tuple2 tuple22 = tuple2 = new Tuple2((Object)k, (Object)$minus$greater$extension_y);
            Object var4_3 = null;
            tuple2 = null;
            Tuple2 tuple23 = tuple22;
            return tuple23;
        }));
        this.waitForPartitionState(tp, this.firstControllerEpoch(), otherBrokerId, LeaderAndIsr$.MODULE$.initialLeaderEpoch() + 3, "with an offline log directory on the target broker, the partition reassignment stalls");
        long l = 15000L;
        long l2 = 100L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!ControllerIntegrationTest.$anonfun$testPartitionReassignmentToBrokerWithOfflineLogDir$3(this, tp, reassignment)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime + l) {
                throw Assertions$.MODULE$.fail("failed to get updated partition assignment on topic znode after partition reassignment", new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 847));
            }
            Thread.sleep(Math.min(l, l2));
        }
        long l3 = 15000L;
        long l4 = 100L;
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!ControllerIntegrationTest.$anonfun$testPartitionReassignmentToBrokerWithOfflineLogDir$5(this)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + l3) {
                throw Assertions$.MODULE$.fail("failed to remove reassign partitions path after completion", new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 847));
            }
            Thread.sleep(Math.min(l3, l4));
        }
        long updatedTimerCount = this.timer(metricName).count();
        Assert.assertTrue((String)new StringBuilder(36).append("Timer count ").append(updatedTimerCount).append(" should be greater than ").append(timerCount).toString(), (updatedTimerCount > timerCount ? 1 : 0) != 0);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testPartitionReassignmentWithOfflineReplicaHaltingProgress() {
        void $minus$greater$extension_y;
        this.servers_$eq(this.makeServers(2, false, false, true, (Option<String>)None$.MODULE$, (Option<String>)None$.MODULE$, (Option<String>)None$.MODULE$, (Option<ApiVersion>)None$.MODULE$, 1));
        int controllerId = TestUtils$.MODULE$.waitUntilControllerElected(this.zkClient(), 15000L);
        int otherBrokerId = BoxesRunTime.unboxToInt((Object)((IterableOps)((IterableOps)this.servers().map((Function1 & Serializable)x$10 -> BoxesRunTime.boxToInteger((int)ControllerIntegrationTest.$anonfun$testPartitionReassignmentWithOfflineReplicaHaltingProgress$1(x$10)))).filter((Function1)(JFunction1.mcZI.sp & Serializable)x$11 -> x$11 != controllerId)).head());
        TopicPartition tp = new TopicPartition("t", 0);
        Object[] objectArray = new Tuple2[1];
        SeqOps seqOps = Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{controllerId}));
        Integer $minus$greater$extension_$this = tp.partition();
        Object var7_5 = null;
        seqOps = null;
        objectArray[0] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
        Map assignment = (Map)scala.collection.Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
        Object[] objectArray2 = new Tuple2[1];
        SeqOps $minus$greater$extension_y2 = Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{otherBrokerId}));
        Object var9_7 = null;
        objectArray2[0] = new Tuple2((Object)tp, (Object)$minus$greater$extension_y2);
        Map reassignment = (Map)scala.collection.Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray2));
        TestUtils$.MODULE$.createTopic(this.zkClient(), tp.topic(), (Map<Object, Seq<Object>>)assignment, this.servers());
        ((KafkaServer)this.servers().apply(otherBrokerId)).shutdown();
        ((KafkaServer)this.servers().apply(otherBrokerId)).awaitShutdown();
        KafkaServer controller = this.getController();
        this.zkClient().setOrCreatePartitionReassignment(reassignment, controller.kafkaController().controllerContext().epochZkVersion());
        this.waitForPartitionState(tp, this.firstControllerEpoch(), controllerId, LeaderAndIsr$.MODULE$.initialLeaderEpoch() + 1, "failed to get expected partition state during partition reassignment with offline replica");
        long l = 15000L;
        long l2 = 100L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!ControllerIntegrationTest.$anonfun$testPartitionReassignmentWithOfflineReplicaHaltingProgress$3(this)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime + l) {
                throw Assertions$.MODULE$.fail("partition reassignment path should remain while reassignment in progress", new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 847));
            }
            Thread.sleep(Math.min(l, l2));
        }
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testPartitionReassignmentResumesAfterReplicaComesOnline() {
        void apply_removingReplicas;
        void apply_addingReplicas;
        ReplicaAssignment replicaAssignment;
        void $minus$greater$extension_y;
        this.servers_$eq(this.makeServers(2, false, false, true, (Option<String>)None$.MODULE$, (Option<String>)None$.MODULE$, (Option<String>)None$.MODULE$, (Option<ApiVersion>)None$.MODULE$, 1));
        int controllerId = TestUtils$.MODULE$.waitUntilControllerElected(this.zkClient(), 15000L);
        int otherBrokerId = BoxesRunTime.unboxToInt((Object)((IterableOps)((IterableOps)this.servers().map((Function1 & Serializable)x$12 -> BoxesRunTime.boxToInteger((int)ControllerIntegrationTest.$anonfun$testPartitionReassignmentResumesAfterReplicaComesOnline$1(x$12)))).filter((Function1)(JFunction1.mcZI.sp & Serializable)x$13 -> x$13 != controllerId)).head());
        TopicPartition tp = new TopicPartition("t", 0);
        Object[] objectArray = new Tuple2[1];
        SeqOps seqOps = Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{controllerId}));
        Integer $minus$greater$extension_$this = tp.partition();
        Object var6_5 = null;
        seqOps = null;
        objectArray[0] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
        Map assignment = (Map)scala.collection.Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
        Object[] objectArray2 = new Tuple2[1];
        Nil$ nil$ = Nil$.MODULE$;
        Nil$ nil$2 = Nil$.MODULE$;
        Seq apply_replicas = (Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{otherBrokerId}));
        ReplicaAssignment replicaAssignment2 = replicaAssignment = new ReplicaAssignment(apply_replicas, (Seq)apply_addingReplicas, (Seq)apply_removingReplicas);
        Object var13_9 = null;
        nil$2 = null;
        nil$ = null;
        replicaAssignment = null;
        ReplicaAssignment $minus$greater$extension_y2 = replicaAssignment2;
        Object var8_11 = null;
        objectArray2[0] = new Tuple2((Object)tp, (Object)$minus$greater$extension_y2);
        Map reassignment = (Map)scala.collection.Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray2));
        TestUtils$.MODULE$.createTopic(this.zkClient(), tp.topic(), (Map<Object, Seq<Object>>)assignment, this.servers());
        ((KafkaServer)this.servers().apply(otherBrokerId)).shutdown();
        ((KafkaServer)this.servers().apply(otherBrokerId)).awaitShutdown();
        this.zkClient().createPartitionReassignment((Map)reassignment.map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2;
            if (x0$1 == null) {
                throw new MatchError(null);
            }
            TopicPartition k = (TopicPartition)x0$1._1();
            ReplicaAssignment v = (ReplicaAssignment)x0$1._2();
            Seq $minus$greater$extension_y = v.replicas();
            Tuple2 tuple22 = tuple2 = new Tuple2((Object)k, (Object)$minus$greater$extension_y);
            Object var4_3 = null;
            tuple2 = null;
            Tuple2 tuple23 = tuple22;
            return tuple23;
        }));
        this.waitForPartitionState(tp, this.firstControllerEpoch(), controllerId, LeaderAndIsr$.MODULE$.initialLeaderEpoch() + 1, "failed to get expected partition state during partition reassignment with offline replica");
        ((KafkaServer)this.servers().apply(otherBrokerId)).startup();
        this.waitForPartitionState(tp, this.firstControllerEpoch(), otherBrokerId, LeaderAndIsr$.MODULE$.initialLeaderEpoch() + 4, "failed to get expected partition state after partition reassignment");
        long l = 15000L;
        long l2 = 100L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!ControllerIntegrationTest.$anonfun$testPartitionReassignmentResumesAfterReplicaComesOnline$4(this, tp, reassignment)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime + l) {
                throw Assertions$.MODULE$.fail("failed to get updated partition assignment on topic znode after partition reassignment", new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 847));
            }
            Thread.sleep(Math.min(l, l2));
        }
        long l3 = 15000L;
        long l4 = 100L;
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!ControllerIntegrationTest.$anonfun$testPartitionReassignmentResumesAfterReplicaComesOnline$6(this)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + l3) {
                throw Assertions$.MODULE$.fail("failed to remove reassign partitions path after completion", new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 847));
            }
            Thread.sleep(Math.min(l3, l4));
        }
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testPreferredReplicaLeaderElection() {
        void $minus$greater$extension_y;
        this.servers_$eq(this.makeServers(2, false, false, true, (Option<String>)None$.MODULE$, (Option<String>)None$.MODULE$, (Option<String>)None$.MODULE$, (Option<ApiVersion>)None$.MODULE$, 1));
        int controllerId = TestUtils$.MODULE$.waitUntilControllerElected(this.zkClient(), 15000L);
        KafkaServer otherBroker = (KafkaServer)this.servers().find((Function1 & Serializable)x$14 -> BoxesRunTime.boxToBoolean((boolean)ControllerIntegrationTest.$anonfun$testPreferredReplicaLeaderElection$1(controllerId, x$14))).get();
        TopicPartition tp = new TopicPartition("t", 0);
        Object[] objectArray = new Tuple2[1];
        SeqOps seqOps = Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{otherBroker.config().brokerId(), controllerId}));
        Integer $minus$greater$extension_$this = tp.partition();
        Object var5_5 = null;
        seqOps = null;
        objectArray[0] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
        Map assignment = (Map)scala.collection.Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
        TestUtils$.MODULE$.createTopic(this.zkClient(), tp.topic(), (Map<Object, Seq<Object>>)assignment, this.servers());
        this.preferredReplicaLeaderElection(controllerId, otherBroker, tp, (scala.collection.immutable.Set<Object>)((IterableOnceOps)assignment.apply((Object)tp.partition())).toSet(), LeaderAndIsr$.MODULE$.initialLeaderEpoch());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testBackToBackPreferredReplicaLeaderElections() {
        void $minus$greater$extension_y;
        this.servers_$eq(this.makeServers(2, false, false, true, (Option<String>)None$.MODULE$, (Option<String>)None$.MODULE$, (Option<String>)None$.MODULE$, (Option<ApiVersion>)None$.MODULE$, 1));
        int controllerId = TestUtils$.MODULE$.waitUntilControllerElected(this.zkClient(), 15000L);
        KafkaServer otherBroker = (KafkaServer)this.servers().find((Function1 & Serializable)x$15 -> BoxesRunTime.boxToBoolean((boolean)ControllerIntegrationTest.$anonfun$testBackToBackPreferredReplicaLeaderElections$1(controllerId, x$15))).get();
        TopicPartition tp = new TopicPartition("t", 0);
        Object[] objectArray = new Tuple2[1];
        SeqOps seqOps = Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{otherBroker.config().brokerId(), controllerId}));
        Integer $minus$greater$extension_$this = tp.partition();
        Object var5_5 = null;
        seqOps = null;
        objectArray[0] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
        Map assignment = (Map)scala.collection.Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
        TestUtils$.MODULE$.createTopic(this.zkClient(), tp.topic(), (Map<Object, Seq<Object>>)assignment, this.servers());
        this.preferredReplicaLeaderElection(controllerId, otherBroker, tp, (scala.collection.immutable.Set<Object>)((IterableOnceOps)assignment.apply((Object)tp.partition())).toSet(), LeaderAndIsr$.MODULE$.initialLeaderEpoch());
        this.preferredReplicaLeaderElection(controllerId, otherBroker, tp, (scala.collection.immutable.Set<Object>)((IterableOnceOps)assignment.apply((Object)tp.partition())).toSet(), LeaderAndIsr$.MODULE$.initialLeaderEpoch() + 2);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testPreferredReplicaLeaderElectionWithOfflinePreferredReplica() {
        void apply_elems;
        void $minus$greater$extension_y;
        this.servers_$eq(this.makeServers(2, false, false, true, (Option<String>)None$.MODULE$, (Option<String>)None$.MODULE$, (Option<String>)None$.MODULE$, (Option<ApiVersion>)None$.MODULE$, 1));
        int controllerId = TestUtils$.MODULE$.waitUntilControllerElected(this.zkClient(), 15000L);
        int otherBrokerId = BoxesRunTime.unboxToInt((Object)((IterableOps)((IterableOps)this.servers().map((Function1 & Serializable)x$16 -> BoxesRunTime.boxToInteger((int)ControllerIntegrationTest.$anonfun$testPreferredReplicaLeaderElectionWithOfflinePreferredReplica$1(x$16)))).filter((Function1)(JFunction1.mcZI.sp & Serializable)x$17 -> x$17 != controllerId)).head());
        TopicPartition tp = new TopicPartition("t", 0);
        Object[] objectArray = new Tuple2[1];
        SeqOps seqOps = Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{otherBrokerId, controllerId}));
        Integer $minus$greater$extension_$this = tp.partition();
        Object var5_5 = null;
        seqOps = null;
        objectArray[0] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
        Map assignment = (Map)scala.collection.Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
        TestUtils$.MODULE$.createTopic(this.zkClient(), tp.topic(), (Map<Object, Seq<Object>>)assignment, this.servers());
        ((KafkaServer)this.servers().apply(otherBrokerId)).shutdown();
        ((KafkaServer)this.servers().apply(otherBrokerId)).awaitShutdown();
        Set$ set$ = Predef$.MODULE$.Set();
        ArraySeq arraySeq = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp});
        if (set$ == null) {
            throw null;
        }
        arraySeq = null;
        this.zkClient().createPreferredReplicaElection((scala.collection.immutable.Set)IterableFactory.apply$((IterableFactory)set$, (scala.collection.immutable.Seq)apply_elems));
        long l = 15000L;
        long l2 = 100L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!ControllerIntegrationTest.$anonfun$testPreferredReplicaLeaderElectionWithOfflinePreferredReplica$3(this)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime + l) {
                throw Assertions$.MODULE$.fail("failed to remove preferred replica leader election path after giving up", new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 847));
            }
            Thread.sleep(Math.min(l, l2));
        }
        this.waitForPartitionState(tp, this.firstControllerEpoch(), controllerId, LeaderAndIsr$.MODULE$.initialLeaderEpoch() + 1, "failed to get expected partition state upon broker shutdown");
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testAutoPreferredReplicaLeaderElection() {
        void $minus$greater$extension_y;
        this.servers_$eq(this.makeServers(2, true, false, true, (Option<String>)None$.MODULE$, (Option<String>)None$.MODULE$, (Option<String>)None$.MODULE$, (Option<ApiVersion>)None$.MODULE$, 1));
        int controllerId = TestUtils$.MODULE$.waitUntilControllerElected(this.zkClient(), 15000L);
        int otherBrokerId = BoxesRunTime.unboxToInt((Object)((IterableOps)((IterableOps)this.servers().map((Function1 & Serializable)x$18 -> BoxesRunTime.boxToInteger((int)ControllerIntegrationTest.$anonfun$testAutoPreferredReplicaLeaderElection$1(x$18)))).filter((Function1)(JFunction1.mcZI.sp & Serializable)x$19 -> x$19 != controllerId)).head());
        TopicPartition tp = new TopicPartition("t", 0);
        Object[] objectArray = new Tuple2[1];
        SeqOps seqOps = Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 0}));
        Integer $minus$greater$extension_$this = tp.partition();
        Object var5_5 = null;
        seqOps = null;
        objectArray[0] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
        Map assignment = (Map)scala.collection.Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
        TestUtils$.MODULE$.createTopic(this.zkClient(), tp.topic(), (Map<Object, Seq<Object>>)assignment, this.servers());
        ((KafkaServer)this.servers().apply(otherBrokerId)).shutdown();
        ((KafkaServer)this.servers().apply(otherBrokerId)).awaitShutdown();
        this.waitForPartitionState(tp, this.firstControllerEpoch(), controllerId, LeaderAndIsr$.MODULE$.initialLeaderEpoch() + 1, "failed to get expected partition state upon broker shutdown");
        ((KafkaServer)this.servers().apply(otherBrokerId)).startup();
        this.waitForPartitionState(tp, this.firstControllerEpoch(), otherBrokerId, LeaderAndIsr$.MODULE$.initialLeaderEpoch() + 2, "failed to get expected partition state upon broker startup");
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testLeaderAndIsrWhenEntireIsrOfflineAndUncleanLeaderElectionDisabled() {
        void $minus$greater$extension_y;
        this.servers_$eq(this.makeServers(2, false, false, true, (Option<String>)None$.MODULE$, (Option<String>)None$.MODULE$, (Option<String>)None$.MODULE$, (Option<ApiVersion>)None$.MODULE$, 1));
        int controllerId = TestUtils$.MODULE$.waitUntilControllerElected(this.zkClient(), 15000L);
        int otherBrokerId = BoxesRunTime.unboxToInt((Object)((IterableOps)((IterableOps)this.servers().map((Function1 & Serializable)x$20 -> BoxesRunTime.boxToInteger((int)ControllerIntegrationTest.$anonfun$testLeaderAndIsrWhenEntireIsrOfflineAndUncleanLeaderElectionDisabled$1(x$20)))).filter((Function1)(JFunction1.mcZI.sp & Serializable)x$21 -> x$21 != controllerId)).head());
        TopicPartition tp = new TopicPartition("t", 0);
        Object[] objectArray = new Tuple2[1];
        SeqOps seqOps = Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{otherBrokerId}));
        Integer $minus$greater$extension_$this = tp.partition();
        Object var5_5 = null;
        seqOps = null;
        objectArray[0] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
        Map assignment = (Map)scala.collection.Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
        TestUtils$.MODULE$.createTopic(this.zkClient(), tp.topic(), (Map<Object, Seq<Object>>)assignment, this.servers());
        this.waitForPartitionState(tp, this.firstControllerEpoch(), otherBrokerId, LeaderAndIsr$.MODULE$.initialLeaderEpoch(), "failed to get expected partition state upon topic creation");
        ((KafkaServer)this.servers().apply(otherBrokerId)).shutdown();
        ((KafkaServer)this.servers().apply(otherBrokerId)).awaitShutdown();
        long l = 15000L;
        long l2 = 100L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!ControllerIntegrationTest.$anonfun$testLeaderAndIsrWhenEntireIsrOfflineAndUncleanLeaderElectionDisabled$3(this, tp, otherBrokerId)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime + l) {
                throw Assertions$.MODULE$.fail("failed to get expected partition state after entire isr went offline", new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 847));
            }
            Thread.sleep(Math.min(l, l2));
        }
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testLeaderAndIsrWhenEntireIsrOfflineAndUncleanLeaderElectionEnabled() {
        void $minus$greater$extension_y;
        None$ none$;
        None$ none$2;
        None$ none$3;
        None$ none$4;
        boolean bl = false;
        boolean bl2 = true;
        None$ none$5 = none$4 = None$.MODULE$;
        none$4 = null;
        None$ x$5 = none$5;
        None$ none$6 = none$3 = None$.MODULE$;
        none$3 = null;
        None$ x$6 = none$6;
        None$ none$7 = none$2 = None$.MODULE$;
        none$2 = null;
        None$ x$7 = none$7;
        None$ none$8 = none$ = None$.MODULE$;
        none$ = null;
        None$ x$8 = none$8;
        int n = 1;
        this.servers_$eq(this.makeServers(2, bl, true, bl2, (Option<String>)x$5, (Option<String>)x$6, (Option<String>)x$7, (Option<ApiVersion>)x$8, n));
        int controllerId = TestUtils$.MODULE$.waitUntilControllerElected(this.zkClient(), 15000L);
        int otherBrokerId = BoxesRunTime.unboxToInt((Object)((IterableOps)((IterableOps)this.servers().map((Function1 & Serializable)x$22 -> BoxesRunTime.boxToInteger((int)ControllerIntegrationTest.$anonfun$testLeaderAndIsrWhenEntireIsrOfflineAndUncleanLeaderElectionEnabled$1(x$22)))).filter((Function1)(JFunction1.mcZI.sp & Serializable)x$23 -> x$23 != controllerId)).head());
        TopicPartition tp = new TopicPartition("t", 0);
        Object[] objectArray = new Tuple2[1];
        SeqOps seqOps = Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{otherBrokerId}));
        Integer $minus$greater$extension_$this = tp.partition();
        Object var9_16 = null;
        seqOps = null;
        objectArray[0] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
        Map assignment = (Map)scala.collection.Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
        TestUtils$.MODULE$.createTopic(this.zkClient(), tp.topic(), (Map<Object, Seq<Object>>)assignment, this.servers());
        this.waitForPartitionState(tp, this.firstControllerEpoch(), otherBrokerId, LeaderAndIsr$.MODULE$.initialLeaderEpoch(), "failed to get expected partition state upon topic creation");
        ((KafkaServer)this.servers().apply(otherBrokerId)).shutdown();
        ((KafkaServer)this.servers().apply(otherBrokerId)).awaitShutdown();
        long l = 15000L;
        long l2 = 100L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!ControllerIntegrationTest.$anonfun$testLeaderAndIsrWhenEntireIsrOfflineAndUncleanLeaderElectionEnabled$3(this, tp, otherBrokerId)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime + l) {
                throw Assertions$.MODULE$.fail("failed to get expected partition state after entire isr went offline", new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 847));
            }
            Thread.sleep(Math.min(l, l2));
        }
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testControlledShutdown() {
        void $minus$greater$extension_y;
        void apply_elems;
        Object object;
        Object[] objectArray = new Tuple2[1];
        ArraySeq arraySeq = ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2});
        List$ apply_this = List$.MODULE$;
        Object object2 = object = IterableFactory.apply$((IterableFactory)apply_this, (scala.collection.immutable.Seq)apply_elems);
        Object var17_2 = null;
        arraySeq = null;
        object = null;
        Object object3 = object2;
        Integer $minus$greater$extension_$this = 0;
        Object var15_5 = null;
        object3 = null;
        objectArray[0] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
        Map expectedReplicaAssignment = (Map)scala.collection.Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
        String topic = "test";
        int partition = 0;
        Seq serverConfigs = (Seq)TestUtils$.MODULE$.createBrokerConfigs(3, this.zkConnect(), false, true, (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, false, false, (Map<Object, String>)((Map)scala.collection.Map$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$)), 1, false, 1, (short)1).map((Function1 & Serializable)props -> KafkaConfig$.MODULE$.fromProps(props));
        this.servers_$eq((Seq<KafkaServer>)((Seq)((IterableOps)serverConfigs.reverse()).map((Function1 & Serializable)s -> {
            Time time;
            Time time2 = time = Time.SYSTEM;
            time = null;
            Time createServer_time = time2;
            return TestUtils$.MODULE$.createServer((KafkaConfig)s, createServer_time, (Option<String>)None$.MODULE$);
        })));
        TestUtils$.MODULE$.createTopic(this.zkClient(), topic, (Map<Object, Seq<Object>>)expectedReplicaAssignment, this.servers());
        int controllerId = BoxesRunTime.unboxToInt((Object)this.zkClient().getControllerId().get());
        KafkaController controller = ((KafkaServer)this.servers().find((Function1 & Serializable)p -> BoxesRunTime.boxToBoolean((boolean)ControllerIntegrationTest.$anonfun$testControlledShutdown$3(controllerId, p))).get()).kafkaController();
        LinkedBlockingQueue resultQueue = new LinkedBlockingQueue();
        Function1 & Serializable controlledShutdownCallback = (Function1 & Serializable)controlledShutdownResult -> {
            resultQueue.put(controlledShutdownResult);
            return BoxedUnit.UNIT;
        };
        controller.controlledShutdown(2, ((KafkaServer)this.servers().find((Function1 & Serializable)x$24 -> BoxesRunTime.boxToBoolean((boolean)ControllerIntegrationTest.$anonfun$testControlledShutdown$5(x$24))).get()).kafkaController().brokerEpoch(), (Function1)controlledShutdownCallback);
        Set partitionsRemaining = (Set)((Try)resultQueue.take()).get();
        Seq seq = (Seq)this.servers().filter((Function1 & Serializable)s -> BoxesRunTime.boxToBoolean((boolean)ControllerIntegrationTest.$anonfun$testControlledShutdown$6(s)));
        long l = 15000L;
        long l2 = 100L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!seq.forall((Function1 & Serializable)x$25 -> BoxesRunTime.boxToBoolean((boolean)ControllerIntegrationTest.$anonfun$testControlledShutdown$8(topic$3, partition$1, x$25)))) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime + l) {
                throw Assertions$.MODULE$.fail("Topic test not created after timeout", new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 847));
            }
            Thread.sleep(Math.min(l, l2));
        }
        Assert.assertEquals((long)0L, (long)partitionsRemaining.size());
        UpdateMetadataRequestData.UpdateMetadataPartitionState partitionStateInfo = (UpdateMetadataRequestData.UpdateMetadataPartitionState)((KafkaServer)seq.head()).dataPlaneRequestProcessor().metadataCache().getPartitionInfo(topic, partition).get();
        int leaderAfterShutdown = partitionStateInfo.leader();
        Assert.assertEquals((long)0L, (long)leaderAfterShutdown);
        Assert.assertEquals((long)2L, (long)partitionStateInfo.isr().size());
        Assert.assertEquals((Object)IterableFactory.apply$((IterableFactory)List$.MODULE$, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1})), (Object)AsScalaExtensions.ListHasAsScala$((AsScalaExtensions)CollectionConverters$.MODULE$, (java.util.List)partitionStateInfo.isr()).asScala());
        controller.controlledShutdown(1, ((KafkaServer)this.servers().find((Function1 & Serializable)x$26 -> BoxesRunTime.boxToBoolean((boolean)ControllerIntegrationTest.$anonfun$testControlledShutdown$10(x$26))).get()).kafkaController().brokerEpoch(), (Function1)controlledShutdownCallback);
        Try try_ = (Try)resultQueue.take();
        if (!(try_ instanceof Success)) {
            if (try_ instanceof Failure) {
                Throwable exception = ((Failure)try_).exception();
                throw Assertions$.MODULE$.fail("Controlled shutdown failed due to error", exception, new Position("ControllerIntegrationTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 517));
            }
            throw new MatchError((Object)try_);
        }
        Set set = (Set)((Success)try_).value();
        partitionsRemaining = set;
        Assert.assertEquals((long)0L, (long)partitionsRemaining.size());
        seq = (Seq)this.servers().filter((Function1 & Serializable)s -> BoxesRunTime.boxToBoolean((boolean)ControllerIntegrationTest.$anonfun$testControlledShutdown$11(s)));
        partitionStateInfo = (UpdateMetadataRequestData.UpdateMetadataPartitionState)((KafkaServer)seq.head()).dataPlaneRequestProcessor().metadataCache().getPartitionInfo(topic, partition).get();
        leaderAfterShutdown = partitionStateInfo.leader();
        Assert.assertEquals((long)0L, (long)leaderAfterShutdown);
        Assert.assertTrue((boolean)this.servers().forall((Function1 & Serializable)x$27 -> BoxesRunTime.boxToBoolean((boolean)ControllerIntegrationTest.$anonfun$testControlledShutdown$12(topic, partition, x$27))));
        controller.controlledShutdown(0, ((KafkaServer)this.servers().find((Function1 & Serializable)x$28 -> BoxesRunTime.boxToBoolean((boolean)ControllerIntegrationTest.$anonfun$testControlledShutdown$13(x$28))).get()).kafkaController().brokerEpoch(), (Function1)controlledShutdownCallback);
        partitionsRemaining = (Set)((Try)resultQueue.take()).get();
        Assert.assertEquals((long)1L, (long)partitionsRemaining.size());
        Assert.assertTrue((boolean)this.servers().forall((Function1 & Serializable)x$29 -> BoxesRunTime.boxToBoolean((boolean)ControllerIntegrationTest.$anonfun$testControlledShutdown$14(topic, partition, x$29))));
    }

    @Test
    public void testControllerRejectControlledShutdownRequestWithStaleBrokerEpoch() {
        VolatileBooleanRef volatileBooleanRef;
        Seq serverConfigs = (Seq)TestUtils$.MODULE$.createBrokerConfigs(2, this.zkConnect(), false, true, (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, false, false, (Map<Object, String>)((Map)scala.collection.Map$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$)), 1, false, 1, (short)1).map((Function1 & Serializable)props -> KafkaConfig$.MODULE$.fromProps(props));
        this.servers_$eq((Seq<KafkaServer>)((Seq)((IterableOps)serverConfigs.reverse()).map((Function1 & Serializable)s -> {
            Time time;
            Time time2 = time = Time.SYSTEM;
            time = null;
            Time createServer_time = time2;
            return TestUtils$.MODULE$.createServer((KafkaConfig)s, createServer_time, (Option<String>)None$.MODULE$);
        })));
        KafkaController controller = this.getController().kafkaController();
        KafkaServer otherBroker = (KafkaServer)this.servers().find((Function1 & Serializable)e -> BoxesRunTime.boxToBoolean((boolean)ControllerIntegrationTest.$anonfun$testControllerRejectControlledShutdownRequestWithStaleBrokerEpoch$3(controller, e))).get();
        boolean create_e = false;
        VolatileBooleanRef volatileBooleanRef2 = volatileBooleanRef = new VolatileBooleanRef(create_e);
        volatileBooleanRef = null;
        VolatileBooleanRef staleBrokerEpochDetected = volatileBooleanRef2;
        controller.controlledShutdown(otherBroker.config().brokerId(), otherBroker.kafkaController().brokerEpoch() - 1L, (Function1 & Serializable)x0$1 -> {
            ControllerIntegrationTest.$anonfun$testControllerRejectControlledShutdownRequestWithStaleBrokerEpoch$4(staleBrokerEpochDetected, x0$1);
            return BoxedUnit.UNIT;
        });
        long l = 15000L;
        long l2 = 100L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!staleBrokerEpochDetected.elem) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime + l) {
                throw Assertions$.MODULE$.fail("Fail to detect stale broker epoch", new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 847));
            }
            Thread.sleep(Math.min(l, l2));
        }
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testControllerMoveOnTopicCreation() {
        void $minus$greater$extension_y;
        this.servers_$eq(this.makeServers(1, false, false, true, (Option<String>)None$.MODULE$, (Option<String>)None$.MODULE$, (Option<String>)None$.MODULE$, (Option<ApiVersion>)None$.MODULE$, 1));
        TestUtils$.MODULE$.waitUntilControllerElected(this.zkClient(), 15000L);
        TopicPartition tp = new TopicPartition("t", 0);
        Object[] objectArray = new Tuple2[1];
        SeqOps seqOps = Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0}));
        Integer $minus$greater$extension_$this = tp.partition();
        Object var3_3 = null;
        seqOps = null;
        objectArray[0] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
        Map assignment = (Map)scala.collection.Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
        KafkaController testControllerMove_controller = this.getController().kafkaController();
        LogCaptureAppender testControllerMove_appender = LogCaptureAppender$.MODULE$.createAndRegister();
        Level testControllerMove_previousLevel = LogCaptureAppender$.MODULE$.setClassLoggerLevel(testControllerMove_controller.getClass(), Level.INFO);
        try {
            long l = 15000L;
            long l2 = 100L;
            long testControllerMove_waitUntilTrue_startTime = System.currentTimeMillis();
            while (!ControllerIntegrationTest.$anonfun$testControllerMove$1(testControllerMove_controller)) {
                if (System.currentTimeMillis() > testControllerMove_waitUntilTrue_startTime + l) {
                    throw Assertions$.MODULE$.fail("Controller event thread is still busy", new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 847));
                }
                Thread.sleep(Math.min(l, l2));
            }
            CountDownLatch testControllerMove_latch = new CountDownLatch(1);
            testControllerMove_controller.eventManager().put((ControllerEvent)new MockEvent(null, testControllerMove_latch){
                private final CountDownLatch latch$6;

                public void process() {
                    this.latch$6.await();
                }

                public void preempt() {
                }
                {
                    this.latch$6 = latch$6;
                    super((ControllerState)ControllerState.TopicChange$.MODULE$);
                }
            });
            ControllerIntegrationTest.$anonfun$testControllerMoveOnTopicCreation$1(this, tp, assignment);
            this.zkClient().deleteController(testControllerMove_controller.controllerContext().epochZkVersion());
            Seq<KafkaServer> seq = this.servers();
            if (seq == null) {
                throw null;
            }
            this.zkClient().registerControllerAndIncrementControllerEpoch(seq.length());
            testControllerMove_latch.countDown();
            long l3 = 15000L;
            long l4 = 100L;
            long testControllerMove_waitUntilTrue_startTime2 = System.currentTimeMillis();
            while (!ControllerIntegrationTest.$anonfun$testControllerMove$3(testControllerMove_controller)) {
                if (System.currentTimeMillis() > testControllerMove_waitUntilTrue_startTime2 + l3) {
                    throw Assertions$.MODULE$.fail("Controller fails to resign", new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 847));
                }
                Thread.sleep(Math.min(l3, l4));
            }
            Assert.assertTrue((boolean)testControllerMove_appender.getMessages().find((Function1 & Serializable)e -> BoxesRunTime.boxToBoolean((boolean)ControllerIntegrationTest.$anonfun$testControllerMove$5(e))).isDefined());
        }
        finally {
            LogCaptureAppender$.MODULE$.unregister(testControllerMove_appender);
            LogCaptureAppender$.MODULE$.setClassLoggerLevel(testControllerMove_controller.eventManager().thread().getClass(), testControllerMove_previousLevel);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testControllerMoveOnTopicDeletion() {
        void $minus$greater$extension_y;
        this.servers_$eq(this.makeServers(1, false, false, true, (Option<String>)None$.MODULE$, (Option<String>)None$.MODULE$, (Option<String>)None$.MODULE$, (Option<ApiVersion>)None$.MODULE$, 1));
        TestUtils$.MODULE$.waitUntilControllerElected(this.zkClient(), 15000L);
        TopicPartition tp = new TopicPartition("t", 0);
        Object[] objectArray = new Tuple2[1];
        SeqOps seqOps = Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0}));
        Integer $minus$greater$extension_$this = tp.partition();
        Object var3_3 = null;
        seqOps = null;
        objectArray[0] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
        Map assignment = (Map)scala.collection.Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
        TestUtils$.MODULE$.createTopic(this.zkClient(), tp.topic(), (Map<Object, Seq<Object>>)assignment, this.servers());
        KafkaController testControllerMove_controller = this.getController().kafkaController();
        LogCaptureAppender testControllerMove_appender = LogCaptureAppender$.MODULE$.createAndRegister();
        Level testControllerMove_previousLevel = LogCaptureAppender$.MODULE$.setClassLoggerLevel(testControllerMove_controller.getClass(), Level.INFO);
        try {
            long l = 15000L;
            long l2 = 100L;
            long testControllerMove_waitUntilTrue_startTime = System.currentTimeMillis();
            while (!ControllerIntegrationTest.$anonfun$testControllerMove$1(testControllerMove_controller)) {
                if (System.currentTimeMillis() > testControllerMove_waitUntilTrue_startTime + l) {
                    throw Assertions$.MODULE$.fail("Controller event thread is still busy", new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 847));
                }
                Thread.sleep(Math.min(l, l2));
            }
            CountDownLatch testControllerMove_latch = new CountDownLatch(1);
            testControllerMove_controller.eventManager().put((ControllerEvent)new /* invalid duplicate definition of identical inner class */);
            ControllerIntegrationTest.$anonfun$testControllerMoveOnTopicDeletion$1(this, tp);
            this.zkClient().deleteController(testControllerMove_controller.controllerContext().epochZkVersion());
            Seq<KafkaServer> seq = this.servers();
            if (seq == null) {
                throw null;
            }
            this.zkClient().registerControllerAndIncrementControllerEpoch(seq.length());
            testControllerMove_latch.countDown();
            long l3 = 15000L;
            long l4 = 100L;
            long testControllerMove_waitUntilTrue_startTime2 = System.currentTimeMillis();
            while (!ControllerIntegrationTest.$anonfun$testControllerMove$3(testControllerMove_controller)) {
                if (System.currentTimeMillis() > testControllerMove_waitUntilTrue_startTime2 + l3) {
                    throw Assertions$.MODULE$.fail("Controller fails to resign", new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 847));
                }
                Thread.sleep(Math.min(l3, l4));
            }
            Assert.assertTrue((boolean)testControllerMove_appender.getMessages().find((Function1 & Serializable)e -> BoxesRunTime.boxToBoolean((boolean)ControllerIntegrationTest.$anonfun$testControllerMove$5(e))).isDefined());
        }
        finally {
            LogCaptureAppender$.MODULE$.unregister(testControllerMove_appender);
            LogCaptureAppender$.MODULE$.setClassLoggerLevel(testControllerMove_controller.eventManager().thread().getClass(), testControllerMove_previousLevel);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testControllerMoveOnPreferredReplicaElection() {
        void $minus$greater$extension_y;
        this.servers_$eq(this.makeServers(1, false, false, true, (Option<String>)None$.MODULE$, (Option<String>)None$.MODULE$, (Option<String>)None$.MODULE$, (Option<ApiVersion>)None$.MODULE$, 1));
        TopicPartition tp = new TopicPartition("t", 0);
        Object[] objectArray = new Tuple2[1];
        SeqOps seqOps = Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0}));
        Integer $minus$greater$extension_$this = tp.partition();
        Object var3_3 = null;
        seqOps = null;
        objectArray[0] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
        Map assignment = (Map)scala.collection.Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
        TestUtils$.MODULE$.createTopic(this.zkClient(), tp.topic(), (Map<Object, Seq<Object>>)assignment, this.servers());
        KafkaController testControllerMove_controller = this.getController().kafkaController();
        LogCaptureAppender testControllerMove_appender = LogCaptureAppender$.MODULE$.createAndRegister();
        Level testControllerMove_previousLevel = LogCaptureAppender$.MODULE$.setClassLoggerLevel(testControllerMove_controller.getClass(), Level.INFO);
        try {
            long l = 15000L;
            long l2 = 100L;
            long testControllerMove_waitUntilTrue_startTime = System.currentTimeMillis();
            while (!ControllerIntegrationTest.$anonfun$testControllerMove$1(testControllerMove_controller)) {
                if (System.currentTimeMillis() > testControllerMove_waitUntilTrue_startTime + l) {
                    throw Assertions$.MODULE$.fail("Controller event thread is still busy", new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 847));
                }
                Thread.sleep(Math.min(l, l2));
            }
            CountDownLatch testControllerMove_latch = new CountDownLatch(1);
            testControllerMove_controller.eventManager().put((ControllerEvent)new /* invalid duplicate definition of identical inner class */);
            ControllerIntegrationTest.$anonfun$testControllerMoveOnPreferredReplicaElection$1(this, tp);
            this.zkClient().deleteController(testControllerMove_controller.controllerContext().epochZkVersion());
            Seq<KafkaServer> seq = this.servers();
            if (seq == null) {
                throw null;
            }
            this.zkClient().registerControllerAndIncrementControllerEpoch(seq.length());
            testControllerMove_latch.countDown();
            long l3 = 15000L;
            long l4 = 100L;
            long testControllerMove_waitUntilTrue_startTime2 = System.currentTimeMillis();
            while (!ControllerIntegrationTest.$anonfun$testControllerMove$3(testControllerMove_controller)) {
                if (System.currentTimeMillis() > testControllerMove_waitUntilTrue_startTime2 + l3) {
                    throw Assertions$.MODULE$.fail("Controller fails to resign", new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 847));
                }
                Thread.sleep(Math.min(l3, l4));
            }
            Assert.assertTrue((boolean)testControllerMove_appender.getMessages().find((Function1 & Serializable)e -> BoxesRunTime.boxToBoolean((boolean)ControllerIntegrationTest.$anonfun$testControllerMove$5(e))).isDefined());
        }
        finally {
            LogCaptureAppender$.MODULE$.unregister(testControllerMove_appender);
            LogCaptureAppender$.MODULE$.setClassLoggerLevel(testControllerMove_controller.eventManager().thread().getClass(), testControllerMove_previousLevel);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testControllerMoveOnPartitionReassignment() {
        void $minus$greater$extension_y;
        this.servers_$eq(this.makeServers(1, false, false, true, (Option<String>)None$.MODULE$, (Option<String>)None$.MODULE$, (Option<String>)None$.MODULE$, (Option<ApiVersion>)None$.MODULE$, 1));
        TestUtils$.MODULE$.waitUntilControllerElected(this.zkClient(), 15000L);
        TopicPartition tp = new TopicPartition("t", 0);
        Object[] objectArray = new Tuple2[1];
        SeqOps seqOps = Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0}));
        Integer $minus$greater$extension_$this = tp.partition();
        Object var4_3 = null;
        seqOps = null;
        objectArray[0] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
        Map assignment = (Map)scala.collection.Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
        TestUtils$.MODULE$.createTopic(this.zkClient(), tp.topic(), (Map<Object, Seq<Object>>)assignment, this.servers());
        Object[] objectArray2 = new Tuple2[1];
        SeqOps $minus$greater$extension_y2 = Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0}));
        Object var6_5 = null;
        objectArray2[0] = new Tuple2((Object)tp, (Object)$minus$greater$extension_y2);
        Map reassignment = (Map)scala.collection.Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray2));
        KafkaController testControllerMove_controller = this.getController().kafkaController();
        LogCaptureAppender testControllerMove_appender = LogCaptureAppender$.MODULE$.createAndRegister();
        Level testControllerMove_previousLevel = LogCaptureAppender$.MODULE$.setClassLoggerLevel(testControllerMove_controller.getClass(), Level.INFO);
        try {
            long l = 15000L;
            long l2 = 100L;
            long testControllerMove_waitUntilTrue_startTime = System.currentTimeMillis();
            while (!ControllerIntegrationTest.$anonfun$testControllerMove$1(testControllerMove_controller)) {
                if (System.currentTimeMillis() > testControllerMove_waitUntilTrue_startTime + l) {
                    throw Assertions$.MODULE$.fail("Controller event thread is still busy", new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 847));
                }
                Thread.sleep(Math.min(l, l2));
            }
            CountDownLatch testControllerMove_latch = new CountDownLatch(1);
            testControllerMove_controller.eventManager().put((ControllerEvent)new /* invalid duplicate definition of identical inner class */);
            ControllerIntegrationTest.$anonfun$testControllerMoveOnPartitionReassignment$1(this, reassignment);
            this.zkClient().deleteController(testControllerMove_controller.controllerContext().epochZkVersion());
            Seq<KafkaServer> seq = this.servers();
            if (seq == null) {
                throw null;
            }
            this.zkClient().registerControllerAndIncrementControllerEpoch(seq.length());
            testControllerMove_latch.countDown();
            long l3 = 15000L;
            long l4 = 100L;
            long testControllerMove_waitUntilTrue_startTime2 = System.currentTimeMillis();
            while (!ControllerIntegrationTest.$anonfun$testControllerMove$3(testControllerMove_controller)) {
                if (System.currentTimeMillis() > testControllerMove_waitUntilTrue_startTime2 + l3) {
                    throw Assertions$.MODULE$.fail("Controller fails to resign", new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 847));
                }
                Thread.sleep(Math.min(l3, l4));
            }
            Assert.assertTrue((boolean)testControllerMove_appender.getMessages().find((Function1 & Serializable)e -> BoxesRunTime.boxToBoolean((boolean)ControllerIntegrationTest.$anonfun$testControllerMove$5(e))).isDefined());
        }
        finally {
            LogCaptureAppender$.MODULE$.unregister(testControllerMove_appender);
            LogCaptureAppender$.MODULE$.setClassLoggerLevel(testControllerMove_controller.eventManager().thread().getClass(), testControllerMove_previousLevel);
        }
    }

    @Test
    public void testControllerFeatureZNodeSetupWhenFeatureVersioningIsEnabledWithNonExistingFeatureZNode() {
        this.testControllerFeatureZNodeSetup((Option<FeatureZNode>)None$.MODULE$, (ApiVersion)KAFKA_2_7_IV0$.MODULE$);
    }

    @Test
    public void testControllerFeatureZNodeSetupWhenFeatureVersioningIsEnabledWithDisabledExistingFeatureZNode() {
        this.testControllerFeatureZNodeSetup((Option<FeatureZNode>)new Some((Object)new FeatureZNode(FeatureZNodeStatus$.MODULE$.Disabled(), Features.emptyFinalizedFeatures())), (ApiVersion)KAFKA_2_7_IV0$.MODULE$);
    }

    @Test
    public void testControllerFeatureZNodeSetupWhenFeatureVersioningIsEnabledWithEnabledExistingFeatureZNode() {
        this.testControllerFeatureZNodeSetup((Option<FeatureZNode>)new Some((Object)new FeatureZNode(FeatureZNodeStatus$.MODULE$.Enabled(), Features.emptyFinalizedFeatures())), (ApiVersion)KAFKA_2_7_IV0$.MODULE$);
    }

    @Test
    public void testControllerFeatureZNodeSetupWhenFeatureVersioningIsDisabledWithNonExistingFeatureZNode() {
        this.testControllerFeatureZNodeSetup((Option<FeatureZNode>)None$.MODULE$, (ApiVersion)KAFKA_2_6_IV0$.MODULE$);
    }

    @Test
    public void testControllerFeatureZNodeSetupWhenFeatureVersioningIsDisabledWithDisabledExistingFeatureZNode() {
        this.testControllerFeatureZNodeSetup((Option<FeatureZNode>)new Some((Object)new FeatureZNode(FeatureZNodeStatus$.MODULE$.Disabled(), Features.emptyFinalizedFeatures())), (ApiVersion)KAFKA_2_6_IV0$.MODULE$);
    }

    @Test
    public void testControllerFeatureZNodeSetupWhenFeatureVersioningIsDisabledWithEnabledExistingFeatureZNode() {
        this.testControllerFeatureZNodeSetup((Option<FeatureZNode>)new Some((Object)new FeatureZNode(FeatureZNodeStatus$.MODULE$.Enabled(), Features.emptyFinalizedFeatures())), (ApiVersion)KAFKA_2_6_IV0$.MODULE$);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testControllerDetectsBouncedBrokers() {
        void $minus$greater$extension_y;
        None$ none$;
        None$ none$2;
        None$ none$3;
        None$ none$4;
        boolean bl = false;
        boolean bl2 = false;
        None$ none$5 = none$4 = None$.MODULE$;
        none$4 = null;
        None$ x$5 = none$5;
        None$ none$6 = none$3 = None$.MODULE$;
        none$3 = null;
        None$ x$6 = none$6;
        None$ none$7 = none$2 = None$.MODULE$;
        none$2 = null;
        None$ x$7 = none$7;
        None$ none$8 = none$ = None$.MODULE$;
        none$ = null;
        None$ x$8 = none$8;
        int n = 1;
        this.servers_$eq(this.makeServers(2, bl, bl2, false, (Option<String>)x$5, (Option<String>)x$6, (Option<String>)x$7, (Option<ApiVersion>)x$8, n));
        KafkaController controller = this.getController().kafkaController();
        KafkaServer otherBroker = (KafkaServer)this.servers().find((Function1 & Serializable)e -> BoxesRunTime.boxToBoolean((boolean)ControllerIntegrationTest.$anonfun$testControllerDetectsBouncedBrokers$1(controller, e))).get();
        TopicPartition tp = new TopicPartition("t", 0);
        Object[] objectArray = new Tuple2[1];
        SeqOps seqOps = Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1}));
        Integer $minus$greater$extension_$this = tp.partition();
        Object var10_16 = null;
        seqOps = null;
        objectArray[0] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
        Map assignment = (Map)scala.collection.Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
        TestUtils$.MODULE$.createTopic(this.zkClient(), tp.topic(), (Map<Object, Seq<Object>>)assignment, this.servers());
        this.waitForPartitionState(tp, this.firstControllerEpoch(), 0, LeaderAndIsr$.MODULE$.initialLeaderEpoch(), "failed to get expected partition state upon topic creation");
        long l = 15000L;
        long l2 = 100L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!ControllerIntegrationTest.$anonfun$testControllerDetectsBouncedBrokers$2(controller)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime + l) {
                throw Assertions$.MODULE$.fail("Controller event thread is still busy", new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 847));
            }
            Thread.sleep(Math.min(l, l2));
        }
        CountDownLatch latch = new CountDownLatch(1);
        controller.eventManager().put((ControllerEvent)new MockEvent(null, latch){
            private final CountDownLatch latch$1;

            public void process() {
                this.latch$1.await();
            }

            public void preempt() {
            }
            {
                this.latch$1 = latch$1;
                super((ControllerState)ControllerState.TopicChange$.MODULE$);
            }
        });
        otherBroker.shutdown();
        otherBroker.startup();
        Assert.assertEquals((long)0L, (long)BoxesRunTime.unboxToInt((Object)otherBroker.replicaManager().partitionCount().value()));
        latch.countDown();
        long l3 = 15000L;
        long l4 = 100L;
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!ControllerIntegrationTest.$anonfun$testControllerDetectsBouncedBrokers$4(otherBroker)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + l3) {
                throw Assertions$.MODULE$.fail("Broker fail to initialize after restart", new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 847));
            }
            Thread.sleep(Math.min(l3, l4));
        }
    }

    @Test
    public void testPreemptionOnControllerShutdown() {
        IntRef intRef;
        None$ none$;
        None$ none$2;
        None$ none$3;
        None$ none$4;
        boolean bl = false;
        boolean bl2 = false;
        None$ none$5 = none$4 = None$.MODULE$;
        none$4 = null;
        None$ x$5 = none$5;
        None$ none$6 = none$3 = None$.MODULE$;
        none$3 = null;
        None$ x$6 = none$6;
        None$ none$7 = none$2 = None$.MODULE$;
        none$2 = null;
        None$ x$7 = none$7;
        None$ none$8 = none$ = None$.MODULE$;
        none$ = null;
        None$ x$8 = none$8;
        int n = 1;
        this.servers_$eq(this.makeServers(1, bl, bl2, false, (Option<String>)x$5, (Option<String>)x$6, (Option<String>)x$7, (Option<ApiVersion>)x$8, n));
        KafkaController controller = this.getController().kafkaController();
        int create_e = 2;
        IntRef intRef2 = intRef = new IntRef(create_e);
        intRef = null;
        IntRef count = intRef2;
        CountDownLatch latch = new CountDownLatch(1);
        ControllerEventManager.ControllerEventThread spyThread = (ControllerEventManager.ControllerEventThread)Mockito.spy((Object)controller.eventManager().thread());
        controller.eventManager().thread_$eq(spyThread);
        MockEvent processedEvent = new MockEvent(null, latch){
            private final CountDownLatch latch$2;

            public void process() {
                this.latch$2.await();
            }

            public void preempt() {
            }
            {
                this.latch$2 = latch$2;
                super((ControllerState)ControllerState.TopicChange$.MODULE$);
            }
        };
        MockEvent preemptedEvent = new MockEvent(null, count){
            private final IntRef count$1;

            public void process() {
            }

            public void preempt() {
                --this.count$1.elem;
            }
            {
                this.count$1 = count$1;
                super((ControllerState)ControllerState.TopicChange$.MODULE$);
            }
        };
        controller.eventManager().put((ControllerEvent)processedEvent);
        controller.eventManager().put((ControllerEvent)preemptedEvent);
        controller.eventManager().put((ControllerEvent)preemptedEvent);
        ((ShutdownableThread)Mockito.doAnswer(x$30 -> {
            latch.countDown();
            return BoxedUnit.UNIT;
        }).doCallRealMethod().when((Object)spyThread)).awaitShutdown();
        controller.shutdown();
        long l = 15000L;
        long l2 = 100L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!(count.elem == 0)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime + l) {
                throw Assertions$.MODULE$.fail("preemption was not fully completed before shutdown", new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 847));
            }
            Thread.sleep(Math.min(l, l2));
        }
        ((ShutdownableThread)Mockito.verify((Object)spyThread)).awaitShutdown();
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testPreemptionWithCallbacks() {
        void apply_elems;
        None$ none$;
        None$ none$2;
        None$ none$3;
        None$ none$4;
        boolean bl = false;
        boolean bl2 = false;
        None$ none$5 = none$4 = None$.MODULE$;
        none$4 = null;
        None$ x$5 = none$5;
        None$ none$6 = none$3 = None$.MODULE$;
        none$3 = null;
        None$ x$6 = none$6;
        None$ none$7 = none$2 = None$.MODULE$;
        none$2 = null;
        None$ x$7 = none$7;
        None$ none$8 = none$ = None$.MODULE$;
        none$ = null;
        None$ x$8 = none$8;
        int n = 1;
        this.servers_$eq(this.makeServers(1, bl, bl2, false, (Option<String>)x$5, (Option<String>)x$6, (Option<String>)x$7, (Option<ApiVersion>)x$8, n));
        KafkaController controller = this.getController().kafkaController();
        CountDownLatch latch = new CountDownLatch(1);
        ControllerEventManager.ControllerEventThread spyThread = (ControllerEventManager.ControllerEventThread)Mockito.spy((Object)controller.eventManager().thread());
        controller.eventManager().thread_$eq(spyThread);
        MockEvent processedEvent = new MockEvent(null, latch){
            private final CountDownLatch latch$3;

            public void process() {
                this.latch$3.await();
            }

            public void preempt() {
            }
            {
                this.latch$3 = latch$3;
                super((ControllerState)ControllerState.TopicChange$.MODULE$);
            }
        };
        TopicPartition tp0 = new TopicPartition("t", 0);
        TopicPartition tp1 = new TopicPartition("t", 1);
        Set$ set$ = Predef$.MODULE$.Set();
        ArraySeq arraySeq = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp0, tp1});
        if (set$ == null) {
            throw null;
        }
        arraySeq = null;
        scala.collection.immutable.Set partitions = (scala.collection.immutable.Set)IterableFactory.apply$((IterableFactory)set$, (scala.collection.immutable.Seq)apply_elems);
        ReplicaLeaderElection event1 = new ReplicaLeaderElection((Option)new Some((Object)partitions), ElectionType.PREFERRED, (ElectionTrigger)ZkTriggered$.MODULE$, (Function1 & Serializable)partitionsMap -> {
            partitionsMap.foreach((Function1 & Serializable)partition -> {
                ControllerIntegrationTest.$anonfun$testPreemptionWithCallbacks$2(partition);
                return BoxedUnit.UNIT;
            });
            return BoxedUnit.UNIT;
        });
        ControlledShutdown event2 = new ControlledShutdown(0, 0L, (Function1 & Serializable)x0$1 -> {
            ControllerIntegrationTest.$anonfun$testPreemptionWithCallbacks$3(x0$1);
            return BoxedUnit.UNIT;
        });
        Object[] objectArray = new Tuple2[2];
        None$ $minus$greater$extension_y = None$.MODULE$;
        Object var16_22 = null;
        objectArray[0] = new Tuple2((Object)tp0, (Object)$minus$greater$extension_y);
        None$ $minus$greater$extension_y2 = None$.MODULE$;
        Object var17_23 = null;
        objectArray[1] = new Tuple2((Object)tp1, (Object)$minus$greater$extension_y2);
        ApiPartitionReassignment event3 = new ApiPartitionReassignment((Map)scala.collection.Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray)), (Function1 & Serializable)x0$2 -> {
            ControllerIntegrationTest.$anonfun$testPreemptionWithCallbacks$4(x0$2);
            return BoxedUnit.UNIT;
        });
        ListPartitionReassignments event4 = new ListPartitionReassignments((Option)new Some((Object)partitions), (Function1 & Serializable)x0$3 -> {
            ControllerIntegrationTest.$anonfun$testPreemptionWithCallbacks$5(x0$3);
            return BoxedUnit.UNIT;
        });
        controller.eventManager().put((ControllerEvent)processedEvent);
        controller.eventManager().put((ControllerEvent)event1);
        controller.eventManager().put((ControllerEvent)event2);
        controller.eventManager().put((ControllerEvent)event3);
        controller.eventManager().put((ControllerEvent)event4);
        ((ShutdownableThread)Mockito.doAnswer(x$31 -> {
            latch.countDown();
            return BoxedUnit.UNIT;
        }).doCallRealMethod().when((Object)spyThread)).awaitShutdown();
        controller.shutdown();
    }

    private void testControllerFeatureZNodeSetup(Option<FeatureZNode> initialZNode, ApiVersion interBrokerProtocolVersion) {
        None$ none$;
        None$ none$2;
        None$ none$3;
        None$ none$4;
        if (initialZNode instanceof Some) {
            FeatureZNode node = (FeatureZNode)((Some)initialZNode).value();
            this.zkClient().createFeatureZNode(node);
            none$4 = new Some((Object)this.zkClient().getDataAndVersion("/feature")._2$mcI$sp());
        } else if (None$.MODULE$.equals(initialZNode)) {
            None$ none$5;
            None$ none$6 = none$5 = None$.MODULE$;
            none$5 = null;
            none$4 = none$6;
        } else {
            throw new MatchError(initialZNode);
        }
        Some x$2 = new Some((Object)interBrokerProtocolVersion);
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = true;
        None$ none$7 = none$3 = None$.MODULE$;
        none$3 = null;
        None$ x$6 = none$7;
        None$ none$8 = none$2 = None$.MODULE$;
        none$2 = null;
        None$ x$7 = none$8;
        None$ none$9 = none$ = None$.MODULE$;
        none$ = null;
        None$ x$8 = none$9;
        int n = 1;
        this.servers_$eq(this.makeServers(1, bl, bl2, bl3, (Option<String>)x$6, (Option<String>)x$7, (Option<String>)x$8, (Option<ApiVersion>)x$2, n));
        TestUtils$.MODULE$.waitUntilControllerElected(this.zkClient(), 15000L);
        KafkaController controller = this.getController().kafkaController();
        CountDownLatch latch = new CountDownLatch(1);
        controller.eventManager().put((ControllerEvent)new MockEvent(null, latch){
            private final CountDownLatch latch$4;

            public void process() {
                this.latch$4.countDown();
            }

            public void preempt() {
            }
            {
                this.latch$4 = latch$4;
                super((ControllerState)ControllerState.TopicChange$.MODULE$);
            }
        });
        latch.await();
        Tuple2 tuple2 = this.zkClient().getDataAndVersion("/feature");
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        Option option = (Option)tuple2._1();
        int n2 = tuple2._2$mcI$sp();
        FeatureZNode newZNode = FeatureZNode$.MODULE$.decode((byte[])option.get());
        if (interBrokerProtocolVersion.$greater$eq((Object)KAFKA_2_7_IV0$.MODULE$)) {
            FeatureZNode emptyZNode = new FeatureZNode(FeatureZNodeStatus$.MODULE$.Enabled(), Features.emptyFinalizedFeatures());
            if (initialZNode instanceof Some) {
                FeatureZNode node = (FeatureZNode)((Some)initialZNode).value();
                Enumeration.Value value = node.status();
                Enumeration.Value value2 = FeatureZNodeStatus$.MODULE$.Enabled();
                if (!(value2 != null ? !value2.equals(value) : value != null)) {
                    Assert.assertEquals((long)BoxesRunTime.unboxToInt((Object)none$4.get()), (long)n2);
                    Assert.assertEquals((Object)node, (Object)newZNode);
                    return;
                }
                Enumeration.Value value3 = FeatureZNodeStatus$.MODULE$.Disabled();
                if (!(value3 != null ? !value3.equals(value) : value != null)) {
                    Assert.assertEquals((long)(BoxesRunTime.unboxToInt((Object)none$4.get()) + 1), (long)n2);
                    Assert.assertEquals((Object)emptyZNode, (Object)newZNode);
                    return;
                }
                throw new MatchError((Object)value);
            }
            if (None$.MODULE$.equals(initialZNode)) {
                Assert.assertEquals((long)0L, (long)n2);
                Assert.assertEquals((Object)new FeatureZNode(FeatureZNodeStatus$.MODULE$.Enabled(), Features.emptyFinalizedFeatures()), (Object)newZNode);
                return;
            }
            throw new MatchError(initialZNode);
        }
        FeatureZNode emptyZNode = new FeatureZNode(FeatureZNodeStatus$.MODULE$.Disabled(), Features.emptyFinalizedFeatures());
        if (initialZNode instanceof Some) {
            Enumeration.Value value = ((FeatureZNode)((Some)initialZNode).value()).status();
            Enumeration.Value value4 = FeatureZNodeStatus$.MODULE$.Enabled();
            if (!(value4 != null ? !value4.equals(value) : value != null)) {
                Assert.assertEquals((long)(BoxesRunTime.unboxToInt((Object)none$4.get()) + 1), (long)n2);
                Assert.assertEquals((Object)emptyZNode, (Object)newZNode);
                return;
            }
            Enumeration.Value value5 = FeatureZNodeStatus$.MODULE$.Disabled();
            if (!(value5 != null ? !value5.equals(value) : value != null)) {
                Assert.assertEquals((long)BoxesRunTime.unboxToInt((Object)none$4.get()), (long)n2);
                Assert.assertEquals((Object)emptyZNode, (Object)newZNode);
                return;
            }
            throw new MatchError((Object)value);
        }
        if (None$.MODULE$.equals(initialZNode)) {
            Assert.assertEquals((long)0L, (long)n2);
            Assert.assertEquals((Object)new FeatureZNode(FeatureZNodeStatus$.MODULE$.Disabled(), Features.emptyFinalizedFeatures()), (Object)newZNode);
            return;
        }
        throw new MatchError(initialZNode);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testIdempotentAlterIsr() {
        void $minus$greater$extension_y;
        this.servers_$eq(this.makeServers(2, false, false, true, (Option<String>)None$.MODULE$, (Option<String>)None$.MODULE$, (Option<String>)None$.MODULE$, (Option<ApiVersion>)None$.MODULE$, 1));
        int controllerId = TestUtils$.MODULE$.waitUntilControllerElected(this.zkClient(), 15000L);
        KafkaServer otherBroker = (KafkaServer)this.servers().find((Function1 & Serializable)x$33 -> BoxesRunTime.boxToBoolean((boolean)ControllerIntegrationTest.$anonfun$testIdempotentAlterIsr$1(controllerId, x$33))).get();
        TopicPartition tp = new TopicPartition("t", 0);
        Object[] objectArray = new Tuple2[1];
        SeqOps seqOps = Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{otherBroker.config().brokerId(), controllerId}));
        Integer $minus$greater$extension_$this = tp.partition();
        Object var11_5 = null;
        seqOps = null;
        objectArray[0] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
        Map assignment = (Map)scala.collection.Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
        TestUtils$.MODULE$.createTopic(this.zkClient(), tp.topic(), (Map<Object, Seq<Object>>)assignment, this.servers());
        CountDownLatch latch = new CountDownLatch(1);
        KafkaController controller = this.getController().kafkaController();
        LeaderAndIsr newLeaderAndIsr = ((LeaderIsrAndControllerEpoch)this.zkClient().getTopicPartitionStates((Seq)new .colon.colon((Object)tp, (List)Nil$.MODULE$)).apply((Object)tp)).leaderAndIsr();
        Function1 & Serializable callback = (Function1 & Serializable)result -> {
            ControllerIntegrationTest.$anonfun$testIdempotentAlterIsr$2(tp, newLeaderAndIsr, latch, result);
            return BoxedUnit.UNIT;
        };
        long brokerEpoch = BoxesRunTime.unboxToLong((Object)controller.controllerContext().liveBrokerIdAndEpochs().get((Object)otherBroker.config().brokerId()).get());
        Object[] objectArray2 = new Tuple2[1];
        objectArray2[0] = new Tuple2((Object)tp, (Object)newLeaderAndIsr);
        controller.eventManager().put((ControllerEvent)new AlterIsrReceived(otherBroker.config().brokerId(), brokerEpoch, (Map)scala.collection.Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray2)), (Function1)callback));
        latch.await();
    }

    private void testControllerMove(Function0<BoxedUnit> fun) {
        KafkaController controller = this.getController().kafkaController();
        LogCaptureAppender appender = LogCaptureAppender$.MODULE$.createAndRegister();
        Level previousLevel = LogCaptureAppender$.MODULE$.setClassLoggerLevel(controller.getClass(), Level.INFO);
        try {
            long l = 15000L;
            long l2 = 100L;
            long waitUntilTrue_startTime = System.currentTimeMillis();
            while (!ControllerIntegrationTest.$anonfun$testControllerMove$1(controller)) {
                if (System.currentTimeMillis() > waitUntilTrue_startTime + l) {
                    throw Assertions$.MODULE$.fail("Controller event thread is still busy", new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 847));
                }
                Thread.sleep(Math.min(l, l2));
            }
            CountDownLatch latch = new CountDownLatch(1);
            controller.eventManager().put((ControllerEvent)new /* invalid duplicate definition of identical inner class */);
            fun.apply$mcV$sp();
            this.zkClient().deleteController(controller.controllerContext().epochZkVersion());
            Seq<KafkaServer> seq = this.servers();
            if (seq == null) {
                throw null;
            }
            this.zkClient().registerControllerAndIncrementControllerEpoch(seq.length());
            latch.countDown();
            long l3 = 15000L;
            long l4 = 100L;
            long waitUntilTrue_startTime2 = System.currentTimeMillis();
            while (!ControllerIntegrationTest.$anonfun$testControllerMove$3(controller)) {
                if (System.currentTimeMillis() > waitUntilTrue_startTime2 + l3) {
                    throw Assertions$.MODULE$.fail("Controller fails to resign", new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 847));
                }
                Thread.sleep(Math.min(l3, l4));
            }
            Assert.assertTrue((boolean)appender.getMessages().find((Function1 & Serializable)e -> BoxesRunTime.boxToBoolean((boolean)ControllerIntegrationTest.$anonfun$testControllerMove$5(e))).isDefined());
        }
        finally {
            LogCaptureAppender$.MODULE$.unregister(appender);
            LogCaptureAppender$.MODULE$.setClassLoggerLevel(controller.eventManager().thread().getClass(), previousLevel);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void preferredReplicaLeaderElection(int controllerId, KafkaServer otherBroker, TopicPartition tp, scala.collection.immutable.Set<Object> replicas, int leaderEpoch) {
        void apply_elems;
        otherBroker.shutdown();
        otherBroker.awaitShutdown();
        this.waitForPartitionState(tp, this.firstControllerEpoch(), controllerId, leaderEpoch + 1, "failed to get expected partition state upon broker shutdown");
        otherBroker.startup();
        long l = 15000L;
        long l2 = 100L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!ControllerIntegrationTest.$anonfun$preferredReplicaLeaderElection$1(this, tp, replicas)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime + l) {
                throw Assertions$.MODULE$.fail("restarted broker failed to join in-sync replicas", new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 847));
            }
            Thread.sleep(Math.min(l, l2));
        }
        Set$ set$ = Predef$.MODULE$.Set();
        ArraySeq arraySeq = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp});
        if (set$ == null) {
            throw null;
        }
        arraySeq = null;
        this.zkClient().createPreferredReplicaElection((scala.collection.immutable.Set)IterableFactory.apply$((IterableFactory)set$, (scala.collection.immutable.Seq)apply_elems));
        long l3 = 15000L;
        long l4 = 100L;
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!ControllerIntegrationTest.$anonfun$preferredReplicaLeaderElection$3(this)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + l3) {
                throw Assertions$.MODULE$.fail("failed to remove preferred replica leader election path after completion", new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 847));
            }
            Thread.sleep(Math.min(l3, l4));
        }
        this.waitForPartitionState(tp, this.firstControllerEpoch(), otherBroker.config().brokerId(), leaderEpoch + 2, "failed to get expected partition state upon broker startup");
    }

    private void waitUntilControllerEpoch(int epoch, String message) {
        long l = 15000L;
        long l2 = 100L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!ControllerIntegrationTest.$anonfun$waitUntilControllerEpoch$1(this, epoch)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime + l) {
                throw Assertions$.MODULE$.fail(message, new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 847));
            }
            Thread.sleep(Math.min(l, l2));
        }
    }

    private void waitForPartitionState(TopicPartition tp, int controllerEpoch, int leader, int leaderEpoch, String message) {
        long l = 15000L;
        long l2 = 100L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!ControllerIntegrationTest.$anonfun$waitForPartitionState$1(this, tp, controllerEpoch, leader, leaderEpoch)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime + l) {
                throw Assertions$.MODULE$.fail(message, new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 847));
            }
            Thread.sleep(Math.min(l, l2));
        }
    }

    private boolean isExpectedPartitionState(LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch, int controllerEpoch, int leader, int leaderEpoch) {
        return leaderIsrAndControllerEpoch.controllerEpoch() == controllerEpoch && leaderIsrAndControllerEpoch.leaderAndIsr().leader() == leader && leaderIsrAndControllerEpoch.leaderAndIsr().leaderEpoch() == leaderEpoch;
    }

    private Seq<KafkaServer> makeServers(int numConfigs, boolean autoLeaderRebalanceEnable, boolean uncleanLeaderElectionEnable, boolean enableControlledShutdown, Option<String> listeners, Option<String> listenerSecurityProtocolMap, Option<String> controlPlaneListenerName, Option<ApiVersion> interBrokerProtocolVersion, int logDirCount) {
        Map map;
        None$ none$;
        None$ none$2;
        None$ none$3;
        String x$2 = this.zkConnect();
        boolean bl = true;
        None$ none$4 = none$3 = None$.MODULE$;
        none$3 = null;
        None$ x$6 = none$4;
        None$ none$5 = none$2 = None$.MODULE$;
        none$2 = null;
        None$ x$7 = none$5;
        None$ none$6 = none$ = None$.MODULE$;
        none$ = null;
        None$ x$8 = none$6;
        boolean bl2 = true;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        Map map2 = map = (Map)scala.collection.Map$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$);
        map = null;
        Map x$13 = map2;
        boolean bl6 = false;
        int n = 1;
        short s = 1;
        Seq<Properties> configs = TestUtils$.MODULE$.createBrokerConfigs(numConfigs, x$2, enableControlledShutdown, bl, (Option<SecurityProtocol>)x$6, (Option<File>)x$7, (Option<Properties>)x$8, bl2, bl3, bl4, bl5, (Map<Object, String>)x$13, logDirCount, bl6, n, s);
        configs.foreach((Function1 & Serializable)config -> {
            ControllerIntegrationTest.$anonfun$makeServers$1(autoLeaderRebalanceEnable, uncleanLeaderElectionEnable, listeners, listenerSecurityProtocolMap, controlPlaneListenerName, interBrokerProtocolVersion, config);
            return BoxedUnit.UNIT;
        });
        return (Seq)configs.map((Function1 & Serializable)config -> TestUtils$.MODULE$.createServer(KafkaConfig$.MODULE$.fromProps(config), Time.SYSTEM, (Option<String>)None$.MODULE$));
    }

    private boolean makeServers$default$2() {
        return false;
    }

    private boolean makeServers$default$3() {
        return false;
    }

    private boolean makeServers$default$4() {
        return true;
    }

    private Option<String> makeServers$default$5() {
        return None$.MODULE$;
    }

    private Option<String> makeServers$default$6() {
        return None$.MODULE$;
    }

    private Option<String> makeServers$default$7() {
        return None$.MODULE$;
    }

    private Option<ApiVersion> makeServers$default$8() {
        return None$.MODULE$;
    }

    private int makeServers$default$9() {
        return 1;
    }

    private Timer timer(String metricName) {
        Option option = ((MapOps)AsScalaExtensions.MapHasAsScala$((AsScalaExtensions)CollectionConverters$.MODULE$, (java.util.Map)KafkaYammerMetrics.defaultRegistry().allMetrics()).asScala().filter((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)ControllerIntegrationTest.$anonfun$timer$1(metricName, x0$1)))).values().headOption();
        if (option == null) {
            throw null;
        }
        Option getOrElse_this = option;
        if (getOrElse_this.isEmpty()) {
            throw Assertions$.MODULE$.fail(new StringBuilder(22).append("Unable to find metric ").append(metricName).toString(), new Position("ControllerIntegrationTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 957));
        }
        return (Timer)getOrElse_this.get();
    }

    private KafkaServer getController() {
        int controllerId = TestUtils$.MODULE$.waitUntilControllerElected(this.zkClient(), 15000L);
        return (KafkaServer)((IterableOps)this.servers().filter((Function1 & Serializable)s -> BoxesRunTime.boxToBoolean((boolean)ControllerIntegrationTest.$anonfun$getController$1(controllerId, s)))).head();
    }

    public static final /* synthetic */ boolean $anonfun$testEmptyCluster$1(ControllerIntegrationTest $this) {
        return $this.zkClient().getControllerId().isDefined();
    }

    public static final /* synthetic */ String $anonfun$testEmptyCluster$2() {
        return "failed to elect a controller";
    }

    public static final /* synthetic */ boolean $anonfun$testControllerEpochPersistsWhenAllBrokersDown$1(ControllerIntegrationTest $this) {
        return $this.zkClient().getControllerId().isDefined();
    }

    public static final /* synthetic */ String $anonfun$testControllerEpochPersistsWhenAllBrokersDown$2() {
        return "failed to elect a controller";
    }

    public static final /* synthetic */ boolean $anonfun$testControllerEpochPersistsWhenAllBrokersDown$3(ControllerIntegrationTest $this) {
        return !$this.zkClient().getControllerId().isDefined();
    }

    public static final /* synthetic */ String $anonfun$testControllerEpochPersistsWhenAllBrokersDown$4() {
        return "failed to kill controller";
    }

    public static final /* synthetic */ boolean $anonfun$testControllerMoveIncrementsControllerEpoch$1(ControllerIntegrationTest $this) {
        return $this.zkClient().getControllerId().isDefined();
    }

    public static final /* synthetic */ String $anonfun$testControllerMoveIncrementsControllerEpoch$2() {
        return "failed to elect a controller";
    }

    public static final /* synthetic */ boolean $anonfun$testControllerMoveIncrementsControllerEpoch$3(ControllerIntegrationTest $this) {
        return $this.zkClient().getControllerId().isDefined();
    }

    public static final /* synthetic */ String $anonfun$testControllerMoveIncrementsControllerEpoch$4() {
        return "failed to elect a controller";
    }

    public static final /* synthetic */ boolean $anonfun$testMetadataPropagationOnBrokerChange$1(int controllerId$1, KafkaServer e) {
        return e.config().brokerId() != controllerId$1;
    }

    public static final /* synthetic */ boolean $anonfun$testMetadataPropagationOnBrokerChange$2(KafkaServer testBroker$1, KafkaServer x$1) {
        return x$1.config().brokerId() != testBroker$1.config().brokerId();
    }

    public static final /* synthetic */ int $anonfun$testMetadataPropagationOnBrokerChange$3(KafkaServer x$2) {
        return x$2.config().brokerId();
    }

    public static final /* synthetic */ void $anonfun$testMetadataPropagationOnBrokerChange$4(String topic$1, KafkaServer testBroker$1, Map assignment$1, Seq remainingBrokers$1, KafkaServer server) {
        UpdateMetadataRequestData.UpdateMetadataPartitionState offlineReplicaPartitionInfo = (UpdateMetadataRequestData.UpdateMetadataPartitionState)server.metadataCache().getPartitionInfo(topic$1, 0).get();
        Assert.assertEquals((long)1L, (long)offlineReplicaPartitionInfo.offlineReplicas().size());
        Assert.assertEquals((Object)testBroker$1.config().brokerId(), offlineReplicaPartitionInfo.offlineReplicas().get(0));
        Assert.assertEquals((Object)AsJavaExtensions.SeqHasAsJava$((AsJavaExtensions)CollectionConverters$.MODULE$, (Seq)((Seq)assignment$1.apply((Object)0))).asJava(), (Object)offlineReplicaPartitionInfo.replicas());
        Assert.assertEquals((Object)AsJavaExtensions.SeqHasAsJava$((AsJavaExtensions)CollectionConverters$.MODULE$, (Seq)((Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{((KafkaServer)remainingBrokers$1.head()).config().brokerId()})))).asJava(), (Object)offlineReplicaPartitionInfo.isr());
        UpdateMetadataRequestData.UpdateMetadataPartitionState onlinePartitionInfo = (UpdateMetadataRequestData.UpdateMetadataPartitionState)server.metadataCache().getPartitionInfo(topic$1, 1).get();
        Assert.assertEquals((Object)AsJavaExtensions.SeqHasAsJava$((AsJavaExtensions)CollectionConverters$.MODULE$, (Seq)((Seq)assignment$1.apply((Object)1))).asJava(), (Object)onlinePartitionInfo.replicas());
        Assert.assertTrue((boolean)onlinePartitionInfo.offlineReplicas().isEmpty());
    }

    public static final /* synthetic */ boolean $anonfun$testMetadataPropagationOnBrokerChange$7(KafkaServer server$1, String topic$1, Tuple2 x0$1) {
        UpdateMetadataRequestData.UpdateMetadataPartitionState partitionInfo;
        Seq replicas;
        int partitionId;
        if (x0$1 != null) {
            partitionId = x0$1._1$mcI$sp();
            replicas = (Seq)x0$1._2();
        } else {
            throw new MatchError(null);
        }
        Option partitionInfoOpt = server$1.metadataCache().getPartitionInfo(topic$1, partitionId);
        boolean bl = partitionInfoOpt.isDefined() ? !(partitionInfo = (UpdateMetadataRequestData.UpdateMetadataPartitionState)partitionInfoOpt.get()).offlineReplicas().isEmpty() || !AsScalaExtensions.ListHasAsScala$((AsScalaExtensions)CollectionConverters$.MODULE$, (java.util.List)partitionInfo.replicas()).asScala().equals((Object)replicas) : true;
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$testMetadataPropagationOnBrokerChange$5(ControllerIntegrationTest $this, Map assignment$1, String topic$1) {
        return !$this.servers().exists((Function1 & Serializable)server -> BoxesRunTime.boxToBoolean((boolean)assignment$1.exists((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)ControllerIntegrationTest.$anonfun$testMetadataPropagationOnBrokerChange$7(server, topic$1, x0$1)))));
    }

    public static final /* synthetic */ String $anonfun$testMetadataPropagationOnBrokerChange$8() {
        return "Inconsistent metadata after broker startup";
    }

    public static final /* synthetic */ boolean $anonfun$testMetadataPropagationForOfflineReplicas$1(int controllerId$2, KafkaServer e) {
        return e.config().brokerId() != controllerId$2;
    }

    public static final /* synthetic */ boolean $anonfun$testMetadataPropagationForOfflineReplicas$2(int controllerId$2, KafkaServer e) {
        return e.config().brokerId() == controllerId$2;
    }

    public static final /* synthetic */ boolean $anonfun$testMetadataPropagationForOfflineReplicas$3(int controllerId$2, KafkaServer replicaBroker$1, KafkaServer e) {
        return e.config().brokerId() != controllerId$2 && e.config().brokerId() != replicaBroker$1.config().brokerId();
    }

    public static final /* synthetic */ boolean $anonfun$testMetadataPropagationForOfflineReplicas$4(KafkaServer broker$1, String topic$2) {
        Option partitionInfoOpt = broker$1.metadataCache().getPartitionInfo(topic$2, 0);
        if (partitionInfoOpt.isDefined()) {
            UpdateMetadataRequestData.UpdateMetadataPartitionState partitionInfo = (UpdateMetadataRequestData.UpdateMetadataPartitionState)partitionInfoOpt.get();
            return !partitionInfo.offlineReplicas().isEmpty() && partitionInfo.leader() == -1 && !partitionInfo.replicas().isEmpty() && !partitionInfo.isr().isEmpty();
        }
        return false;
    }

    public static final /* synthetic */ String $anonfun$testMetadataPropagationForOfflineReplicas$5() {
        return "Inconsistent metadata after broker startup";
    }

    private static final void verifyMetadata$1(KafkaServer broker, String topic$2) {
        broker.startup();
        long l = 15000L;
        long l2 = 100L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!ControllerIntegrationTest.$anonfun$testMetadataPropagationForOfflineReplicas$4(broker, topic$2)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime + l) {
                throw Assertions$.MODULE$.fail("Inconsistent metadata after broker startup", new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 847));
            }
            Thread.sleep(Math.min(l, l2));
        }
    }

    public static final /* synthetic */ int $anonfun$testTopicCreationWithOfflineReplica$1(KafkaServer x$3) {
        return x$3.config().brokerId();
    }

    public static final /* synthetic */ int $anonfun$testTopicPartitionExpansionWithOfflineReplica$1(KafkaServer x$5) {
        return x$5.config().brokerId();
    }

    public static final /* synthetic */ int $anonfun$testPartitionReassignment$1(KafkaServer x$7) {
        return x$7.config().brokerId();
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ boolean $anonfun$testPartitionReassignment$4(ControllerIntegrationTest $this, TopicPartition tp$1, Map reassignment$1) {
        void apply_elems;
        Set$ set$ = Predef$.MODULE$.Set();
        ArraySeq arraySeq = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{tp$1.topic()});
        if (set$ == null) {
            throw null;
        }
        arraySeq = null;
        Map map = $this.zkClient().getFullReplicaAssignmentForTopics((scala.collection.immutable.Set)IterableFactory.apply$((IterableFactory)set$, (scala.collection.immutable.Seq)apply_elems));
        return !(map != null ? !map.equals(reassignment$1) : reassignment$1 != null);
    }

    public static final /* synthetic */ String $anonfun$testPartitionReassignment$5() {
        return "failed to get updated partition assignment on topic znode after partition reassignment";
    }

    public static final /* synthetic */ boolean $anonfun$testPartitionReassignment$6(ControllerIntegrationTest $this) {
        return !$this.zkClient().reassignPartitionsInProgress();
    }

    public static final /* synthetic */ String $anonfun$testPartitionReassignment$7() {
        return "failed to remove reassign partitions path after completion";
    }

    public static final /* synthetic */ boolean $anonfun$testPartitionReassignmentToBrokerWithOfflineLogDir$1(int controllerId$6, KafkaServer x$9) {
        return x$9.config().brokerId() != controllerId$6;
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ boolean $anonfun$testPartitionReassignmentToBrokerWithOfflineLogDir$3(ControllerIntegrationTest $this, TopicPartition tp$2, Map reassignment$2) {
        void apply_elems;
        Set$ set$ = Predef$.MODULE$.Set();
        ArraySeq arraySeq = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{tp$2.topic()});
        if (set$ == null) {
            throw null;
        }
        arraySeq = null;
        Map map = $this.zkClient().getFullReplicaAssignmentForTopics((scala.collection.immutable.Set)IterableFactory.apply$((IterableFactory)set$, (scala.collection.immutable.Seq)apply_elems));
        return !(map != null ? !map.equals(reassignment$2) : reassignment$2 != null);
    }

    public static final /* synthetic */ String $anonfun$testPartitionReassignmentToBrokerWithOfflineLogDir$4() {
        return "failed to get updated partition assignment on topic znode after partition reassignment";
    }

    public static final /* synthetic */ boolean $anonfun$testPartitionReassignmentToBrokerWithOfflineLogDir$5(ControllerIntegrationTest $this) {
        return !$this.zkClient().reassignPartitionsInProgress();
    }

    public static final /* synthetic */ String $anonfun$testPartitionReassignmentToBrokerWithOfflineLogDir$6() {
        return "failed to remove reassign partitions path after completion";
    }

    public static final /* synthetic */ int $anonfun$testPartitionReassignmentWithOfflineReplicaHaltingProgress$1(KafkaServer x$10) {
        return x$10.config().brokerId();
    }

    public static final /* synthetic */ boolean $anonfun$testPartitionReassignmentWithOfflineReplicaHaltingProgress$3(ControllerIntegrationTest $this) {
        return $this.zkClient().reassignPartitionsInProgress();
    }

    public static final /* synthetic */ String $anonfun$testPartitionReassignmentWithOfflineReplicaHaltingProgress$4() {
        return "partition reassignment path should remain while reassignment in progress";
    }

    public static final /* synthetic */ int $anonfun$testPartitionReassignmentResumesAfterReplicaComesOnline$1(KafkaServer x$12) {
        return x$12.config().brokerId();
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ boolean $anonfun$testPartitionReassignmentResumesAfterReplicaComesOnline$4(ControllerIntegrationTest $this, TopicPartition tp$3, Map reassignment$3) {
        void apply_elems;
        Set$ set$ = Predef$.MODULE$.Set();
        ArraySeq arraySeq = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{tp$3.topic()});
        if (set$ == null) {
            throw null;
        }
        arraySeq = null;
        Map map = $this.zkClient().getFullReplicaAssignmentForTopics((scala.collection.immutable.Set)IterableFactory.apply$((IterableFactory)set$, (scala.collection.immutable.Seq)apply_elems));
        return !(map != null ? !map.equals(reassignment$3) : reassignment$3 != null);
    }

    public static final /* synthetic */ String $anonfun$testPartitionReassignmentResumesAfterReplicaComesOnline$5() {
        return "failed to get updated partition assignment on topic znode after partition reassignment";
    }

    public static final /* synthetic */ boolean $anonfun$testPartitionReassignmentResumesAfterReplicaComesOnline$6(ControllerIntegrationTest $this) {
        return !$this.zkClient().reassignPartitionsInProgress();
    }

    public static final /* synthetic */ String $anonfun$testPartitionReassignmentResumesAfterReplicaComesOnline$7() {
        return "failed to remove reassign partitions path after completion";
    }

    public static final /* synthetic */ boolean $anonfun$testPreferredReplicaLeaderElection$1(int controllerId$9, KafkaServer x$14) {
        return x$14.config().brokerId() != controllerId$9;
    }

    public static final /* synthetic */ boolean $anonfun$testBackToBackPreferredReplicaLeaderElections$1(int controllerId$10, KafkaServer x$15) {
        return x$15.config().brokerId() != controllerId$10;
    }

    public static final /* synthetic */ int $anonfun$testPreferredReplicaLeaderElectionWithOfflinePreferredReplica$1(KafkaServer x$16) {
        return x$16.config().brokerId();
    }

    public static final /* synthetic */ boolean $anonfun$testPreferredReplicaLeaderElectionWithOfflinePreferredReplica$3(ControllerIntegrationTest $this) {
        return !$this.zkClient().pathExists(PreferredReplicaElectionZNode$.MODULE$.path());
    }

    public static final /* synthetic */ String $anonfun$testPreferredReplicaLeaderElectionWithOfflinePreferredReplica$4() {
        return "failed to remove preferred replica leader election path after giving up";
    }

    public static final /* synthetic */ int $anonfun$testAutoPreferredReplicaLeaderElection$1(KafkaServer x$18) {
        return x$18.config().brokerId();
    }

    public static final /* synthetic */ int $anonfun$testLeaderAndIsrWhenEntireIsrOfflineAndUncleanLeaderElectionDisabled$1(KafkaServer x$20) {
        return x$20.config().brokerId();
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ boolean $anonfun$testLeaderAndIsrWhenEntireIsrOfflineAndUncleanLeaderElectionDisabled$3(ControllerIntegrationTest $this, TopicPartition tp$4, int otherBrokerId$1) {
        Map leaderIsrAndControllerEpochMap = $this.zkClient().getTopicPartitionStates((Seq)new .colon.colon((Object)tp$4, (List)Nil$.MODULE$));
        if (leaderIsrAndControllerEpochMap.contains((Object)tp$4) && $this.isExpectedPartitionState((LeaderIsrAndControllerEpoch)leaderIsrAndControllerEpochMap.apply((Object)tp$4), $this.firstControllerEpoch(), LeaderAndIsr$.MODULE$.NoLeader(), LeaderAndIsr$.MODULE$.initialLeaderEpoch() + 1)) {
            void apply_elems;
            Object object;
            List list = ((LeaderIsrAndControllerEpoch)leaderIsrAndControllerEpochMap.apply((Object)tp$4)).leaderAndIsr().isr();
            ArraySeq arraySeq = ScalaRunTime$.MODULE$.wrapIntArray(new int[]{otherBrokerId$1});
            List$ apply_this = List$.MODULE$;
            Object object2 = object = IterableFactory.apply$((IterableFactory)apply_this, (scala.collection.immutable.Seq)apply_elems);
            Object var5_5 = null;
            arraySeq = null;
            object = null;
            Object object3 = object2;
            if (!(list != null ? !list.equals(object3) : object3 != null)) {
                return true;
            }
        }
        return false;
    }

    public static final /* synthetic */ String $anonfun$testLeaderAndIsrWhenEntireIsrOfflineAndUncleanLeaderElectionDisabled$4() {
        return "failed to get expected partition state after entire isr went offline";
    }

    public static final /* synthetic */ int $anonfun$testLeaderAndIsrWhenEntireIsrOfflineAndUncleanLeaderElectionEnabled$1(KafkaServer x$22) {
        return x$22.config().brokerId();
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ boolean $anonfun$testLeaderAndIsrWhenEntireIsrOfflineAndUncleanLeaderElectionEnabled$3(ControllerIntegrationTest $this, TopicPartition tp$5, int otherBrokerId$2) {
        Map leaderIsrAndControllerEpochMap = $this.zkClient().getTopicPartitionStates((Seq)new .colon.colon((Object)tp$5, (List)Nil$.MODULE$));
        if (leaderIsrAndControllerEpochMap.contains((Object)tp$5) && $this.isExpectedPartitionState((LeaderIsrAndControllerEpoch)leaderIsrAndControllerEpochMap.apply((Object)tp$5), $this.firstControllerEpoch(), LeaderAndIsr$.MODULE$.NoLeader(), LeaderAndIsr$.MODULE$.initialLeaderEpoch() + 1)) {
            void apply_elems;
            Object object;
            List list = ((LeaderIsrAndControllerEpoch)leaderIsrAndControllerEpochMap.apply((Object)tp$5)).leaderAndIsr().isr();
            ArraySeq arraySeq = ScalaRunTime$.MODULE$.wrapIntArray(new int[]{otherBrokerId$2});
            List$ apply_this = List$.MODULE$;
            Object object2 = object = IterableFactory.apply$((IterableFactory)apply_this, (scala.collection.immutable.Seq)apply_elems);
            Object var5_5 = null;
            arraySeq = null;
            object = null;
            Object object3 = object2;
            if (!(list != null ? !list.equals(object3) : object3 != null)) {
                return true;
            }
        }
        return false;
    }

    public static final /* synthetic */ String $anonfun$testLeaderAndIsrWhenEntireIsrOfflineAndUncleanLeaderElectionEnabled$4() {
        return "failed to get expected partition state after entire isr went offline";
    }

    public static final /* synthetic */ boolean $anonfun$testControlledShutdown$3(int controllerId$15, KafkaServer p) {
        return p.config().brokerId() == controllerId$15;
    }

    public static final /* synthetic */ boolean $anonfun$testControlledShutdown$5(KafkaServer x$24) {
        return x$24.config().brokerId() == 2;
    }

    public static final /* synthetic */ boolean $anonfun$testControlledShutdown$6(KafkaServer s) {
        return s.config().brokerId() != 2;
    }

    public static final /* synthetic */ boolean $anonfun$testControlledShutdown$8(String topic$3, int partition$1, KafkaServer x$25) {
        return ((UpdateMetadataRequestData.UpdateMetadataPartitionState)x$25.dataPlaneRequestProcessor().metadataCache().getPartitionInfo(topic$3, partition$1).get()).isr().size() != 3;
    }

    public static final /* synthetic */ boolean $anonfun$testControlledShutdown$7(ObjectRef activeServers$1, String topic$3, int partition$1) {
        return ((Seq)activeServers$1.elem).forall((Function1 & Serializable)x$25 -> BoxesRunTime.boxToBoolean((boolean)ControllerIntegrationTest.$anonfun$testControlledShutdown$8(topic$3, partition$1, x$25)));
    }

    public static final /* synthetic */ String $anonfun$testControlledShutdown$9() {
        return "Topic test not created after timeout";
    }

    public static final /* synthetic */ boolean $anonfun$testControlledShutdown$10(KafkaServer x$26) {
        return x$26.config().brokerId() == 1;
    }

    public static final /* synthetic */ boolean $anonfun$testControlledShutdown$11(KafkaServer s) {
        return s.config().brokerId() == 0;
    }

    public static final /* synthetic */ boolean $anonfun$testControlledShutdown$12(String topic$3, int partition$1, KafkaServer x$27) {
        return ((UpdateMetadataRequestData.UpdateMetadataPartitionState)x$27.dataPlaneRequestProcessor().metadataCache().getPartitionInfo(topic$3, partition$1).get()).leader() == 0;
    }

    public static final /* synthetic */ boolean $anonfun$testControlledShutdown$13(KafkaServer x$28) {
        return x$28.config().brokerId() == 0;
    }

    public static final /* synthetic */ boolean $anonfun$testControlledShutdown$14(String topic$3, int partition$1, KafkaServer x$29) {
        return ((UpdateMetadataRequestData.UpdateMetadataPartitionState)x$29.dataPlaneRequestProcessor().metadataCache().getPartitionInfo(topic$3, partition$1).get()).leader() == 0;
    }

    public static final /* synthetic */ boolean $anonfun$testControllerRejectControlledShutdownRequestWithStaleBrokerEpoch$3(KafkaController controller$1, KafkaServer e) {
        return e.config().brokerId() != controller$1.config().brokerId();
    }

    public static final /* synthetic */ void $anonfun$testControllerRejectControlledShutdownRequestWithStaleBrokerEpoch$4(VolatileBooleanRef staleBrokerEpochDetected$1, Try x0$1) {
        if (x0$1 instanceof Failure && ((Failure)x0$1).exception() instanceof StaleBrokerEpochException) {
            staleBrokerEpochDetected$1.elem = true;
            return;
        }
    }

    public static final /* synthetic */ boolean $anonfun$testControllerRejectControlledShutdownRequestWithStaleBrokerEpoch$5(VolatileBooleanRef staleBrokerEpochDetected$1) {
        return staleBrokerEpochDetected$1.elem;
    }

    public static final /* synthetic */ String $anonfun$testControllerRejectControlledShutdownRequestWithStaleBrokerEpoch$6() {
        return "Fail to detect stale broker epoch";
    }

    public static final /* synthetic */ void $anonfun$testControllerMoveOnTopicCreation$1(ControllerIntegrationTest $this, TopicPartition tp$6, Map assignment$2) {
        AdminZkClient adminZkClient = new AdminZkClient($this.zkClient());
        adminZkClient.createTopicWithAssignment(tp$6.topic(), new Properties(), assignment$2, adminZkClient.createTopicWithAssignment$default$4());
    }

    public static final /* synthetic */ void $anonfun$testControllerMoveOnTopicDeletion$1(ControllerIntegrationTest $this, TopicPartition tp$7) {
        new AdminZkClient($this.zkClient()).deleteTopic(tp$7.topic());
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void $anonfun$testControllerMoveOnPreferredReplicaElection$1(ControllerIntegrationTest $this, TopicPartition tp$8) {
        void apply_elems;
        Set$ set$ = Predef$.MODULE$.Set();
        ArraySeq arraySeq = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp$8});
        if (set$ == null) {
            throw null;
        }
        arraySeq = null;
        $this.zkClient().createPreferredReplicaElection((scala.collection.immutable.Set)IterableFactory.apply$((IterableFactory)set$, (scala.collection.immutable.Seq)apply_elems));
    }

    public static final /* synthetic */ void $anonfun$testControllerMoveOnPartitionReassignment$1(ControllerIntegrationTest $this, Map reassignment$4) {
        $this.zkClient().createPartitionReassignment(reassignment$4);
    }

    public static final /* synthetic */ boolean $anonfun$testControllerDetectsBouncedBrokers$1(KafkaController controller$2, KafkaServer e) {
        return e.config().brokerId() != controller$2.config().brokerId();
    }

    public static final /* synthetic */ boolean $anonfun$testControllerDetectsBouncedBrokers$2(KafkaController controller$2) {
        ControllerState controllerState = controller$2.eventManager().state();
        ControllerState.Idle$ idle$ = ControllerState.Idle$.MODULE$;
        return controllerState != null && controllerState.equals(idle$);
    }

    public static final /* synthetic */ String $anonfun$testControllerDetectsBouncedBrokers$3() {
        return "Controller event thread is still busy";
    }

    public static final /* synthetic */ boolean $anonfun$testControllerDetectsBouncedBrokers$4(KafkaServer otherBroker$1) {
        if (BoxesRunTime.unboxToInt((Object)otherBroker$1.replicaManager().partitionCount().value()) == 1 && otherBroker$1.replicaManager().metadataCache().getAllTopics().size() == 1) {
            Seq seq = otherBroker$1.replicaManager().metadataCache().getAliveBrokers();
            if (seq == null) {
                throw null;
            }
            if (seq.length() == 2) {
                return true;
            }
        }
        return false;
    }

    public static final /* synthetic */ String $anonfun$testControllerDetectsBouncedBrokers$5() {
        return "Broker fail to initialize after restart";
    }

    public static final /* synthetic */ boolean $anonfun$testPreemptionOnControllerShutdown$2(IntRef count$1) {
        return count$1.elem == 0;
    }

    public static final /* synthetic */ String $anonfun$testPreemptionOnControllerShutdown$3() {
        return "preemption was not fully completed before shutdown";
    }

    public static final /* synthetic */ void $anonfun$testPreemptionWithCallbacks$2(Tuple2 partition) {
        Either either = (Either)partition._2();
        if (either instanceof Left) {
            ApiError e = (ApiError)((Left)either).value();
            Assert.assertEquals((Object)Errors.NOT_CONTROLLER, (Object)e.error());
            return;
        }
        if (either instanceof Right) {
            throw Assertions$.MODULE$.fail("replica leader election should error", new Position("ControllerIntegrationTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 722));
        }
        throw new MatchError((Object)either);
    }

    public static final /* synthetic */ void $anonfun$testPreemptionWithCallbacks$3(Try x0$1) {
        if (x0$1 instanceof Success) {
            throw Assertions$.MODULE$.fail("controlled shutdown should error", new Position("ControllerIntegrationTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 727));
        }
        if (x0$1 instanceof Failure) {
            Throwable e = ((Failure)x0$1).exception();
            Assert.assertEquals(ControllerMovedException.class, e.getClass());
            return;
        }
        throw new MatchError((Object)x0$1);
    }

    public static final /* synthetic */ void $anonfun$testPreemptionWithCallbacks$4(Either x0$2) {
        if (x0$2 instanceof Left) {
            throw Assertions$.MODULE$.fail("api partition reassignment should error", new Position("ControllerIntegrationTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 732));
        }
        if (x0$2 instanceof Right) {
            ApiError e = (ApiError)((Right)x0$2).value();
            Assert.assertEquals((Object)Errors.NOT_CONTROLLER, (Object)e.error());
            return;
        }
        throw new MatchError((Object)x0$2);
    }

    public static final /* synthetic */ void $anonfun$testPreemptionWithCallbacks$5(Either x0$3) {
        if (x0$3 instanceof Left) {
            throw Assertions$.MODULE$.fail("api partition reassignment should error", new Position("ControllerIntegrationTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 736));
        }
        if (x0$3 instanceof Right) {
            ApiError e = (ApiError)((Right)x0$3).value();
            Assert.assertEquals((Object)Errors.NOT_CONTROLLER, (Object)e.error());
            return;
        }
        throw new MatchError((Object)x0$3);
    }

    public static final /* synthetic */ boolean $anonfun$testIdempotentAlterIsr$1(int controllerId$16, KafkaServer x$33) {
        return x$33.config().brokerId() != controllerId$16;
    }

    public static final /* synthetic */ void $anonfun$testIdempotentAlterIsr$2(TopicPartition tp$9, LeaderAndIsr newLeaderAndIsr$1, CountDownLatch latch$5, Either result) {
        LeaderAndIsr leaderAndIsr;
        Map partitionResults;
        if (result instanceof Left && (partitionResults = (Map)((Left)result).value()) != null) {
            Either either;
            boolean bl = false;
            Some some = null;
            Option option = partitionResults.get((Object)tp$9);
            if (option instanceof Some) {
                bl = true;
                some = (Some)option;
                Either either2 = (Either)some.value();
                if (either2 instanceof Left && (Errors)((Left)either2).value() != null) {
                    throw Assertions$.MODULE$.fail(new StringBuilder(31).append("Should not have seen error for ").append(tp$9).toString(), new Position("ControllerIntegrationTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 836));
                }
            }
            if (!bl || !((either = (Either)some.value()) instanceof Right) || (leaderAndIsr = (LeaderAndIsr)((Right)either).value()) == null) {
                if (None$.MODULE$.equals(option)) {
                    throw Assertions$.MODULE$.fail(new StringBuilder(27).append("Should have seen ").append(tp$9).append(" in result").toString(), new Position("ControllerIntegrationTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 838));
                }
                throw new MatchError((Object)option);
            }
        } else {
            if (result instanceof Right && ((Right)result).value() != null) {
                throw Assertions$.MODULE$.fail("Should not have had top-level error here", new Position("ControllerIntegrationTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 840));
            }
            throw new MatchError((Object)result);
        }
        Assert.assertEquals((String)"ISR should remain unchanged", (Object)leaderAndIsr, (Object)newLeaderAndIsr$1);
        latch$5.countDown();
    }

    public static final /* synthetic */ boolean $anonfun$testControllerMove$1(KafkaController controller$3) {
        ControllerState controllerState = controller$3.eventManager().state();
        ControllerState.Idle$ idle$ = ControllerState.Idle$.MODULE$;
        return controllerState != null && controllerState.equals(idle$);
    }

    public static final /* synthetic */ String $anonfun$testControllerMove$2() {
        return "Controller event thread is still busy";
    }

    public static final /* synthetic */ boolean $anonfun$testControllerMove$3(KafkaController controller$3) {
        return !controller$3.isActive();
    }

    public static final /* synthetic */ String $anonfun$testControllerMove$4() {
        return "Controller fails to resign";
    }

    public static final /* synthetic */ boolean $anonfun$testControllerMove$5(LoggingEvent e) {
        Level level = e.getLevel();
        Level level2 = Level.INFO;
        if (!(level != null ? !level.equals(level2) : level2 != null)) {
            if (e.getThrowableInformation() != null && e.getThrowableInformation().getThrowable().getClass().getName().equals(ControllerMovedException.class.getName())) {
                return true;
            }
        }
        return false;
    }

    public static final /* synthetic */ boolean $anonfun$preferredReplicaLeaderElection$1(ControllerIntegrationTest $this, TopicPartition tp$10, scala.collection.immutable.Set replicas$1) {
        scala.collection.immutable.Set set = ((IterableOnceOps)$this.zkClient().getInSyncReplicasForPartition(new TopicPartition(tp$10.topic(), tp$10.partition())).get()).toSet();
        return !(set != null ? !set.equals(replicas$1) : replicas$1 != null);
    }

    public static final /* synthetic */ String $anonfun$preferredReplicaLeaderElection$2() {
        return "restarted broker failed to join in-sync replicas";
    }

    public static final /* synthetic */ boolean $anonfun$preferredReplicaLeaderElection$3(ControllerIntegrationTest $this) {
        return !$this.zkClient().pathExists(PreferredReplicaElectionZNode$.MODULE$.path());
    }

    public static final /* synthetic */ String $anonfun$preferredReplicaLeaderElection$4() {
        return "failed to remove preferred replica leader election path after completion";
    }

    public static final /* synthetic */ boolean $anonfun$waitUntilControllerEpoch$1(ControllerIntegrationTest $this, int epoch$1) {
        Option option = $this.zkClient().getControllerEpoch();
        if (option == null) {
            throw null;
        }
        Option map_this = option;
        Object object = map_this.isEmpty() ? None$.MODULE$ : new Some((Object)((Tuple2)map_this.get())._1$mcI$sp());
        None$ none$ = object;
        Object var2_2 = null;
        object = null;
        return none$.contains((Object)epoch$1);
    }

    public static final /* synthetic */ String $anonfun$waitUntilControllerEpoch$3(String message$1) {
        return message$1;
    }

    public static final /* synthetic */ boolean $anonfun$waitForPartitionState$1(ControllerIntegrationTest $this, TopicPartition tp$11, int controllerEpoch$1, int leader$1, int leaderEpoch$1) {
        Map leaderIsrAndControllerEpochMap = $this.zkClient().getTopicPartitionStates((Seq)new .colon.colon((Object)tp$11, (List)Nil$.MODULE$));
        return leaderIsrAndControllerEpochMap.contains((Object)tp$11) && $this.isExpectedPartitionState((LeaderIsrAndControllerEpoch)leaderIsrAndControllerEpochMap.apply((Object)tp$11), controllerEpoch$1, leader$1, leaderEpoch$1);
    }

    public static final /* synthetic */ String $anonfun$waitForPartitionState$2(String message$2) {
        return message$2;
    }

    public static final /* synthetic */ void $anonfun$makeServers$1(boolean autoLeaderRebalanceEnable$1, boolean uncleanLeaderElectionEnable$1, Option listeners$1, Option listenerSecurityProtocolMap$1, Option controlPlaneListenerName$1, Option interBrokerProtocolVersion$1, Properties config) {
        config.setProperty(KafkaConfig$.MODULE$.AutoLeaderRebalanceEnableProp(), ((Object)autoLeaderRebalanceEnable$1).toString());
        config.setProperty(KafkaConfig$.MODULE$.UncleanLeaderElectionEnableProp(), ((Object)uncleanLeaderElectionEnable$1).toString());
        config.setProperty(KafkaConfig$.MODULE$.LeaderImbalanceCheckIntervalSecondsProp(), "1");
        if (listeners$1 == null) {
            throw null;
        }
        if (!listeners$1.isEmpty()) {
            String string = (String)listeners$1.get();
            config.setProperty(KafkaConfig$.MODULE$.ListenersProp(), string);
        }
        if (listenerSecurityProtocolMap$1 == null) {
            throw null;
        }
        if (!listenerSecurityProtocolMap$1.isEmpty()) {
            String string = (String)listenerSecurityProtocolMap$1.get();
            config.setProperty(KafkaConfig$.MODULE$.ListenerSecurityProtocolMapProp(), string);
        }
        if (controlPlaneListenerName$1 == null) {
            throw null;
        }
        if (!controlPlaneListenerName$1.isEmpty()) {
            String string = (String)controlPlaneListenerName$1.get();
            config.setProperty(KafkaConfig$.MODULE$.ControlPlaneListenerNameProp(), string);
        }
        if (interBrokerProtocolVersion$1 == null) {
            throw null;
        }
        if (!interBrokerProtocolVersion$1.isEmpty()) {
            ApiVersion apiVersion = (ApiVersion)interBrokerProtocolVersion$1.get();
            config.setProperty(KafkaConfig$.MODULE$.InterBrokerProtocolVersionProp(), apiVersion.toString());
        }
    }

    public static final /* synthetic */ boolean $anonfun$timer$1(String metricName$1, Tuple2 x0$1) {
        if (x0$1 == null) {
            throw new MatchError(null);
        }
        String string = ((MetricName)x0$1._1()).getMBeanName();
        boolean bl = !(string != null ? !string.equals(metricName$1) : metricName$1 != null);
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$getController$1(int controllerId$17, KafkaServer s) {
        return s.config().brokerId() == controllerId$17;
    }

    public static final /* synthetic */ Object $anonfun$waitUntilControllerEpoch$2$adapted(Tuple2 x$34) {
        return BoxesRunTime.boxToInteger((int)x$34._1$mcI$sp());
    }
}

