/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.epoch;

import java.io.File;
import java.io.Serializable;
import kafka.server.checkpoints.LeaderEpochCheckpoint;
import kafka.server.checkpoints.LeaderEpochCheckpointFile;
import kafka.server.epoch.EpochEntry;
import kafka.server.epoch.LeaderEpochFileCache;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.test.TestUtils;
import org.junit.Assert;
import org.junit.Test;
import scala.Function0;
import scala.None$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableFactory;
import scala.collection.LinearSeqOps;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ListBuffer$;
import scala.reflect.ScalaSignature;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\u0005\re\u0001B\u00193\u0001eBQ\u0001\u0011\u0001\u0005\u0002\u0005Cq\u0001\u0012\u0001C\u0002\u0013\u0005Q\t\u0003\u0004R\u0001\u0001\u0006IA\u0012\u0005\b%\u0002\u0001\r\u0011\"\u0003T\u0011\u001d9\u0006\u00011A\u0005\naCaA\u0018\u0001!B\u0013!\u0006bB0\u0001\u0005\u0004%I\u0001\u0019\u0005\u0007O\u0002\u0001\u000b\u0011B1\t\u000f!\u0004!\u0019!C\u0005S\"1Q\u000e\u0001Q\u0001\n)DQA\u001c\u0001\u0005\u0002=DQa\u001e\u0001\u0005\u0002=DQ!\u001f\u0001\u0005\u0002=DQa\u001f\u0001\u0005\u0002=DQ! \u0001\u0005\u0002=DQa \u0001\u0005\u0002=Da!a\u0001\u0001\t\u0003y\u0007BBA\u0004\u0001\u0011\u0005q\u000e\u0003\u0004\u0002\f\u0001!\ta\u001c\u0005\u0007\u0003\u001f\u0001A\u0011A8\t\r\u0005M\u0001\u0001\"\u0001p\u0011\u0019\t9\u0002\u0001C\u0001_\"1\u00111\u0004\u0001\u0005\u0002=Da!a\b\u0001\t\u0003y\u0007BBA\u0012\u0001\u0011\u0005q\u000e\u0003\u0004\u0002(\u0001!\ta\u001c\u0005\u0007\u0003W\u0001A\u0011A8\t\r\u0005=\u0002\u0001\"\u0001p\u0011\u0019\t\u0019\u0004\u0001C\u0001_\"1\u0011q\u0007\u0001\u0005\u0002=Da!a\u000f\u0001\t\u0003y\u0007BBA \u0001\u0011\u0005q\u000e\u0003\u0004\u0002D\u0001!\ta\u001c\u0005\u0007\u0003\u000f\u0002A\u0011A8\t\r\u0005-\u0003\u0001\"\u0001p\u0011\u0019\ty\u0005\u0001C\u0001_\"1\u00111\u000b\u0001\u0005\u0002=Da!a\u0016\u0001\t\u0003y\u0007BBA.\u0001\u0011\u0005q\u000e\u0003\u0004\u0002`\u0001!\ta\u001c\u0005\u0007\u0003G\u0002A\u0011A8\t\r\u0005\u001d\u0004\u0001\"\u0001p\u0011\u0019\tY\u0007\u0001C\u0001_\"1\u0011q\u000e\u0001\u0005\u0002=Da!a\u001d\u0001\t\u0003y\u0007BBA<\u0001\u0011\u0005q\u000e\u0003\u0004\u0002|\u0001!\ta\u001c\u0005\u0007\u0003\u007f\u0002A\u0011A8\u000311+\u0017\rZ3s\u000bB|7\r\u001b$jY\u0016\u001c\u0015m\u00195f)\u0016\u001cHO\u0003\u00024i\u0005)Q\r]8dQ*\u0011QGN\u0001\u0007g\u0016\u0014h/\u001a:\u000b\u0003]\nQa[1gW\u0006\u001c\u0001a\u0005\u0002\u0001uA\u00111HP\u0007\u0002y)\tQ(A\u0003tG\u0006d\u0017-\u0003\u0002@y\t1\u0011I\\=SK\u001a\fa\u0001P5oSRtD#\u0001\"\u0011\u0005\r\u0003Q\"\u0001\u001a\u0002\u0005Q\u0004X#\u0001$\u0011\u0005\u001d{U\"\u0001%\u000b\u0005%S\u0015AB2p[6|gN\u0003\u00028\u0017*\u0011A*T\u0001\u0007CB\f7\r[3\u000b\u00039\u000b1a\u001c:h\u0013\t\u0001\u0006J\u0001\bU_BL7\rU1si&$\u0018n\u001c8\u0002\u0007Q\u0004\b%\u0001\u0007m_\u001e,e\u000eZ(gMN,G/F\u0001U!\tYT+\u0003\u0002Wy\t!Aj\u001c8h\u0003AawnZ#oI>3gm]3u?\u0012*\u0017\u000f\u0006\u0002Z9B\u00111HW\u0005\u00037r\u0012A!\u00168ji\"9Q,BA\u0001\u0002\u0004!\u0016a\u0001=%c\u0005iAn\\4F]\u0012|eMZ:fi\u0002\n!b\u00195fG.\u0004x.\u001b8u+\u0005\t\u0007C\u00012f\u001b\u0005\u0019'B\u000135\u0003-\u0019\u0007.Z2la>Lg\u000e^:\n\u0005\u0019\u001c'!\u0006'fC\u0012,'/\u00129pG\"\u001c\u0005.Z2la>Lg\u000e^\u0001\fG\",7m\u001b9pS:$\b%A\u0003dC\u000eDW-F\u0001k!\t\u00195.\u0003\u0002me\t!B*Z1eKJ,\u0005o\\2i\r&dWmQ1dQ\u0016\faaY1dQ\u0016\u0004\u0013!\u0005;fgR\u0004&/\u001a<j_V\u001cX\t]8dQR\t\u0011\f\u000b\u0002\fcB\u0011!/^\u0007\u0002g*\u0011A/T\u0001\u0006UVt\u0017\u000e^\u0005\u0003mN\u0014A\u0001V3ti\u0006)3\u000f[8vY\u0012\fE\rZ#q_\u000eD\u0017I\u001c3NKN\u001c\u0018mZ3PM\u001a\u001cX\r\u001e+p\u0007\u0006\u001c\u0007.\u001a\u0015\u0003\u0019E\faf\u001d5pk2$'+\u001a;ve:dunZ#oI>3gm]3u\u0013\u001ad\u0015\r^3ti\u0016\u0003xn\u00195SKF,Xm\u001d;fI\"\u0012Q\"]\u00015g\"|W\u000f\u001c3SKR,(O\\+oI\u00164\u0017N\\3e\u001f\u001a47/\u001a;JMVsG-\u001a4j]\u0016$W\t]8dQJ+\u0017/^3ti\u0016$\u0007F\u0001\br\u0003\t\u001b\bn\\;mI:{Go\u0014<fe^\u0014\u0018\u000e^3M_\u001e,e\u000eZ(gMN,GOR8s\u00032+\u0017\rZ3s\u000bB|7\r[(oG\u0016LE\u000fS1t\u0005\u0016,g.Q:tS\u001etW\r\u001a\u0015\u0003\u001fE\f\u0001g\u001d5pk2$WI\u001c4pe\u000e,Wj\u001c8pi>t\u0017nY1mYfLen\u0019:fCNLgnZ*uCJ$xJ\u001a4tKR\u001c\bF\u0001\tr\u0003q\u001a\bn\\;mI:{Go\u0014<fe^\u0014\u0018\u000e^3PM\u001a\u001cX\r\u001e$pe\u0006cU-\u00193fe\u0016\u0003xn\u00195P]\u000e,\u0017\n\u001e%bg\n+WM\\!tg&<g.\u001a3)\u0005E\t\u0018\u0001K:i_VdGMU3ukJtWK\\:vaB|'\u000f^3e\u0013\u001atu.\u00129pG\"\u0014VmY8sI\u0016$\u0007F\u0001\nr\u0003\t\u001b\bn\\;mIJ+G/\u001e:o+:\u001cX\u000f\u001d9peR,G-\u00134O_\u0016\u0003xn\u00195SK\u000e|'\u000fZ3e\u0003:$WK\u001c3fM&tW\rZ#q_\u000eD'+Z9vKN$X\r\u001a\u0015\u0003'E\f\u0001h\u001d5pk2$'+\u001a;ve:4\u0015N]:u\u000bB|7\r[%g%\u0016\fX/Z:uK\u0012,\u0005o\\2i\u0019\u0016\u001c8\u000f\u00165b]\u001aK'o\u001d;Fa>\u001c\u0007\u000e\u000b\u0002\u0015c\u0006)4\u000f[8vY\u0012$&/\u001e8dCR,\u0017JZ'bi\u000eD\u0017N\\4Fa>\u001c\u0007NQ;u\u000b\u0006\u0014H.[3s'R\f'\u000f^5oO>3gm]3uQ\t)\u0012/\u0001%tQ>,H\u000eZ$fi\u001aK'o\u001d;PM\u001a\u001cX\r^(g'V\u00147/Z9vK:$X\t]8dQ^CWM\\(gMN,GOU3rk\u0016\u001cH/\u001a3G_J\u0004&/\u001a<j_V\u001cX\t]8dQ\"\u0012a#]\u0001Fg\"|W\u000f\u001c3SKR,(O\u001c(fqR\fe/Y5mC\ndW-\u00129pG\"Le\r\u00165fe\u0016L5OT8Fq\u0006\u001cG/\u00129pG\"4uN\u001d+iK>sWMU3rk\u0016\u001cH/\u001a3)\u0005]\t\u0018AM:i_VdGMT8u+B$\u0017\r^3Fa>\u001c\u0007.\u00118e'R\f'\u000f^(gMN,G/\u00134Ji\u0012KGMT8u\u0007\"\fgnZ3)\u0005a\t\u0018!R:i_VdGMU3ukJt\u0017J\u001c<bY&$wJ\u001a4tKRLe-\u00129pG\"L5OU3rk\u0016\u001cH/\u001a3XQ&\u001c\u0007.S:O_R\u001cUO\u001d:f]Rd\u0017\u0010\u0016:bG.,G\r\u000b\u0002\u001ac\u0006I3\u000f[8vY\u0012\u001cV\u000f\u001d9peR,\u0005o\\2igRC\u0017\r\u001e#p\u001d>$8\u000b^1si\u001a\u0013x.\u001c.fe>D#AG9\u0002GMDw.\u001e7e!\u0016\u00148/[:u\u000bB|7\r[:CKR<X-\u001a8J]N$\u0018M\\2fg\"\u00121$]\u0001+g\"|W\u000f\u001c3F]\u001a|'oY3N_:|Go\u001c8jG\u0006dG._%oGJ,\u0017m]5oO\u0016\u0003xn\u00195tQ\ta\u0012/A\u0015tQ>,H\u000eZ#oM>\u00148-Z(gMN,Go]%oGJ,\u0017m]3N_:|Go\u001c8jG\u0006dG.\u001f\u0015\u0003;E\fAg\u001d5pk2$\u0017J\\2sK\u0006\u001cX-\u00118e)J\f7m[#q_\u000eD7/Q:MK\u0006$WM]:DQ\u0006tw-Z'b]f$\u0016.\\3tQ\tq\u0012/\u0001\u001etQ>,H\u000eZ%oGJ,\u0017m]3B]\u0012$&/Y2l\u000bB|7\r[:Bg\u001a{G\u000e\\8xKJ\u0014VmY3jm\u0016\u001cX*\u00198z\u001b\u0016\u001c8/Y4fg\"\u0012q$]\u0001:g\"|W\u000f\u001c3Ee>\u0004XI\u001c;sS\u0016\u001cxJ\\#q_\u000eD'i\\;oI\u0006\u0014\u0018p\u00165f]J+Wn\u001c<j]\u001ed\u0015\r^3ti\u0016sGO]5fg\"\u0012\u0001%]\u00014g\"|W\u000f\u001c3Qe\u0016\u001cXM\u001d<f%\u0016\u001cX\r^(gMN,Go\u00148DY\u0016\f'/R1sY&,7\u000f^%g\u001f:,W\t_5tiND#!I9\u0002sMDw.\u001e7e+B$\u0017\r^3TCZ,Gm\u00144gg\u0016$x\u000b[3o\u001f\u001a47/\u001a;U_\u000ecW-\u0019:U_&\u001b()\u001a;xK\u0016tW\t]8dQND#AI9\u0002KMDw.\u001e7e\u001d>$8\t\\3be\u0006s\u0017\u0010\u001e5j]\u001eLem\u00144gg\u0016$Hk\\#be2L\bFA\u0012r\u0003-\u001a\bn\\;mI:{Go\u00117fCJ\fe.\u001f;iS:<\u0017JZ(gMN,G\u000fV8GSJ\u001cHo\u00144gg\u0016$\bF\u0001\u0013r\u0003%\u001a\bn\\;mIJ+G/Y5o\u0019\u0006$Xm\u001d;Fa>\u001c\u0007n\u00148DY\u0016\f'/\u00117m\u000b\u0006\u0014H.[3ti\"\u0012Q%]\u00018g\"|W\u000f\u001c3Va\u0012\fG/Z(gMN,GOQ3uo\u0016,g.\u00129pG\"\u0014u.\u001e8eCJLWm](o\u00072,\u0017M]#be2LWm\u001d;)\u0005\u0019\n\u0018\u0001O:i_VdG-\u00169eCR,wJ\u001a4tKR\u0014U\r^<fK:,\u0005o\\2i\u0005>,h\u000eZ1sS\u0016\u001cxJ\\\"mK\u0006\u0014X)\u0019:mS\u0016\u001cHO\r\u0015\u0003OE\f1h\u001d5pk2$'+\u001a;bS:d\u0015\r^3ti\u0016\u0003xn\u00195P]\u000ecW-\u0019:BY2,\u0015M\u001d7jKN$\u0018I\u001c3Va\u0012\fG/Z%ug>3gm]3uQ\tA\u0013/A\u001ctQ>,H\u000e\u001a#s_B,e\u000e\u001e:jKN\u0014U\r^<fK:,\u0005o\\2i\u0005>,h\u000eZ1ss^CWM\u001c*f[>4\u0018N\\4OK^,7\u000f\u001e\u0015\u0003SE\fQc\u001d5pk2$7\t\\3be\u0006cG.\u00128ue&,7\u000f\u000b\u0002+c\u0006y3\u000f[8vY\u0012tu\u000e\u001e*fg\u0016$X\t]8dQ\"K7\u000f^8ss\"+\u0017\rZ%g+:$WMZ5oK\u0012\u0004\u0016m]:fI\"\u00121&]\u00010g\"|W\u000f\u001c3O_R\u0014Vm]3u\u000bB|7\r\u001b%jgR|'/\u001f+bS2Le-\u00168eK\u001aLg.\u001a3QCN\u001cX\r\u001a\u0015\u0003YE\f!e\u001d5pk2$g)\u001a;dQ2\u000bG/Z:u\u000bB|7\r[(g\u000b6\u0004H/_\"bG\",\u0007FA\u0017r\u0003\u0001\u001a\bn\\;mI\u001a+Go\u00195F]\u0012|eMZ:fi>3W)\u001c9us\u000e\u000b7\r[3)\u00059\n\u0018aH:i_VdGm\u00117fCJ,\u0015M\u001d7jKN$xJ\\#naRL8)Y2iK\"\u0012q&]\u0001\u001eg\"|W\u000f\u001c3DY\u0016\f'\u000fT1uKN$xJ\\#naRL8)Y2iK\"\u0012\u0001'\u001d")
public class LeaderEpochFileCacheTest {
    private final TopicPartition tp = new TopicPartition("TestTopic", 5);
    private long logEndOffset = 0L;
    private final LeaderEpochCheckpoint checkpoint = new LeaderEpochCheckpoint(null){
        private Seq<EpochEntry> epochs;

        private Seq<EpochEntry> epochs() {
            return this.epochs;
        }

        private void epochs_$eq(Seq<EpochEntry> x$1) {
            this.epochs = x$1;
        }

        public void write(Iterable<EpochEntry> epochs) {
            this.epochs_$eq((Seq<EpochEntry>)epochs.toSeq());
        }

        public Seq<EpochEntry> read() {
            return this.epochs();
        }
        {
            this.epochs = Nil$.MODULE$;
        }
    };
    private final LeaderEpochFileCache cache = new LeaderEpochFileCache(this.tp(), (Function0)(JFunction0.mcJ.sp & Serializable)() -> this.logEndOffset(), this.checkpoint());

    public TopicPartition tp() {
        return this.tp;
    }

    private long logEndOffset() {
        return this.logEndOffset;
    }

    private void logEndOffset_$eq(long x$1) {
        this.logEndOffset = x$1;
    }

    private LeaderEpochCheckpoint checkpoint() {
        return this.checkpoint;
    }

    private LeaderEpochFileCache cache() {
        return this.cache;
    }

    @Test
    public void testPreviousEpoch() {
        Assert.assertEquals((Object)None$.MODULE$, (Object)this.cache().previousEpoch());
        this.cache().assign(2, 10L);
        Assert.assertEquals((Object)None$.MODULE$, (Object)this.cache().previousEpoch());
        this.cache().assign(4, 15L);
        Assert.assertEquals((Object)new Some((Object)2), (Object)this.cache().previousEpoch());
        this.cache().assign(10, 20L);
        Assert.assertEquals((Object)new Some((Object)4), (Object)this.cache().previousEpoch());
        this.cache().truncateFromEnd(18L);
        Assert.assertEquals((Object)new Some((Object)2), (Object)this.cache().previousEpoch());
    }

    @Test
    public void shouldAddEpochAndMessageOffsetToCache() {
        this.cache().assign(2, 10L);
        this.logEndOffset_$eq(11L);
        Assert.assertEquals((Object)new Some((Object)2), (Object)this.cache().latestEpoch());
        Assert.assertEquals((Object)new EpochEntry(2, 10L), (Object)this.cache().epochEntries().apply(0));
        Assert.assertEquals((Object)new Tuple2.mcIJ.sp(2, this.logEndOffset()), (Object)this.cache().endOffsetFor(2));
    }

    @Test
    public void shouldReturnLogEndOffsetIfLatestEpochRequested() {
        this.cache().assign(2, 11L);
        this.cache().assign(2, 12L);
        this.logEndOffset_$eq(14L);
        Assert.assertEquals((Object)new Tuple2.mcIJ.sp(2, this.logEndOffset()), (Object)this.cache().endOffsetFor(2));
    }

    @Test
    public void shouldReturnUndefinedOffsetIfUndefinedEpochRequested() {
        Tuple2.mcIJ.sp expectedEpochEndOffset = new Tuple2.mcIJ.sp(-1, -1L);
        this.cache().assign(2, 11L);
        this.cache().assign(3, 12L);
        Tuple2 epochAndOffsetFor = this.cache().endOffsetFor(-1);
        Assert.assertEquals((String)"Expected undefined epoch and offset if undefined epoch requested. Cache not empty.", (Object)expectedEpochEndOffset, (Object)epochAndOffsetFor);
    }

    @Test
    public void shouldNotOverwriteLogEndOffsetForALeaderEpochOnceItHasBeenAssigned() {
        this.logEndOffset_$eq(9L);
        this.cache().assign(2, this.logEndOffset());
        this.cache().assign(2, 10L);
        Assert.assertEquals((long)this.logEndOffset(), (long)((EpochEntry)this.cache().epochEntries().apply(0)).startOffset());
        Assert.assertEquals((Object)IterableFactory.apply$((IterableFactory)ListBuffer$.MODULE$, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new EpochEntry[]{new EpochEntry(2, 9L)})), (Object)this.cache().epochEntries());
    }

    @Test
    public void shouldEnforceMonotonicallyIncreasingStartOffsets() {
        this.cache().assign(2, 9L);
        this.cache().assign(3, 9L);
        Assert.assertEquals((Object)IterableFactory.apply$((IterableFactory)ListBuffer$.MODULE$, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new EpochEntry[]{new EpochEntry(3, 9L)})), (Object)this.cache().epochEntries());
    }

    @Test
    public void shouldNotOverwriteOffsetForALeaderEpochOnceItHasBeenAssigned() {
        this.cache().assign(2, 6L);
        this.cache().assign(2, 10L);
        Assert.assertEquals((long)6L, (long)((EpochEntry)this.cache().epochEntries().apply(0)).startOffset());
    }

    @Test
    public void shouldReturnUnsupportedIfNoEpochRecorded() {
        Assert.assertEquals((Object)new Tuple2.mcIJ.sp(-1, -1L), (Object)this.cache().endOffsetFor(0));
    }

    @Test
    public void shouldReturnUnsupportedIfNoEpochRecordedAndUndefinedEpochRequested() {
        this.logEndOffset_$eq(73L);
        Tuple2 offsetFor = this.cache().endOffsetFor(-1);
        Assert.assertEquals((String)"Expected undefined epoch and offset if undefined epoch requested. Empty cache.", (Object)new Tuple2.mcIJ.sp(-1, -1L), (Object)offsetFor);
    }

    @Test
    public void shouldReturnFirstEpochIfRequestedEpochLessThanFirstEpoch() {
        this.cache().assign(5, 11L);
        this.cache().assign(6, 12L);
        this.cache().assign(7, 13L);
        Tuple2 epochAndOffset = this.cache().endOffsetFor(4);
        Assert.assertEquals((Object)new Tuple2.mcII.sp(4, 11), (Object)epochAndOffset);
    }

    @Test
    public void shouldTruncateIfMatchingEpochButEarlierStartingOffset() {
        this.cache().assign(5, 11L);
        this.cache().assign(6, 12L);
        this.cache().assign(7, 13L);
        this.cache().assign(7, 12L);
        Assert.assertEquals((Object)new Tuple2.mcII.sp(5, 12), (Object)this.cache().endOffsetFor(5));
        Assert.assertEquals((Object)new Tuple2.mcII.sp(5, 12), (Object)this.cache().endOffsetFor(6));
    }

    @Test
    public void shouldGetFirstOffsetOfSubsequentEpochWhenOffsetRequestedForPreviousEpoch() {
        this.cache().assign(1, 11L);
        this.cache().assign(1, 12L);
        this.cache().assign(2, 13L);
        this.cache().assign(2, 14L);
        this.cache().assign(3, 15L);
        this.cache().assign(3, 16L);
        this.logEndOffset_$eq(17L);
        Assert.assertEquals((Object)new Tuple2.mcII.sp(2, 15), (Object)this.cache().endOffsetFor(2));
    }

    @Test
    public void shouldReturnNextAvailableEpochIfThereIsNoExactEpochForTheOneRequested() {
        this.cache().assign(0, 10L);
        this.cache().assign(2, 13L);
        this.cache().assign(4, 17L);
        Assert.assertEquals((Object)new Tuple2.mcII.sp(0, 13), (Object)this.cache().endOffsetFor(1));
        Assert.assertEquals((Object)new Tuple2.mcII.sp(2, 17), (Object)this.cache().endOffsetFor(2));
        Assert.assertEquals((Object)new Tuple2.mcII.sp(2, 17), (Object)this.cache().endOffsetFor(3));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void shouldNotUpdateEpochAndStartOffsetIfItDidNotChange() {
        void apply_n;
        this.cache().assign(2, 6L);
        this.cache().assign(2, 7L);
        Seq seq = this.cache().epochEntries();
        if (seq == null) {
            throw null;
        }
        Assert.assertEquals((long)1L, (long)seq.length());
        List list = this.cache().epochEntries().toList();
        boolean bl = false;
        if (list == null) {
            throw null;
        }
        Assert.assertEquals((Object)new EpochEntry(2, 6L), (Object)LinearSeqOps.apply$((LinearSeqOps)list, (int)apply_n));
    }

    @Test
    public void shouldReturnInvalidOffsetIfEpochIsRequestedWhichIsNotCurrentlyTracked() {
        this.logEndOffset_$eq(100L);
        this.cache().assign(2, 100L);
        Assert.assertEquals((Object)new Tuple2.mcIJ.sp(-1, -1L), (Object)this.cache().endOffsetFor(3));
    }

    @Test
    public void shouldSupportEpochsThatDoNotStartFromZero() {
        this.cache().assign(2, 6L);
        this.logEndOffset_$eq(7L);
        Assert.assertEquals((Object)new Tuple2.mcIJ.sp(2, this.logEndOffset()), (Object)this.cache().endOffsetFor(2));
        Seq seq = this.cache().epochEntries();
        if (seq == null) {
            throw null;
        }
        Assert.assertEquals((long)1L, (long)seq.length());
        Assert.assertEquals((Object)new EpochEntry(2, 6L), (Object)this.cache().epochEntries().apply(0));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void shouldPersistEpochsBetweenInstances() {
        void apply_n;
        String checkpointPath = TestUtils.tempFile().getAbsolutePath();
        LeaderEpochCheckpointFile checkpoint = new LeaderEpochCheckpointFile(new File(checkpointPath), null);
        new LeaderEpochFileCache(this.tp(), (Function0)(JFunction0.mcJ.sp & Serializable)() -> this.logEndOffset(), (LeaderEpochCheckpoint)checkpoint).assign(2, 6L);
        LeaderEpochCheckpointFile checkpoint2 = new LeaderEpochCheckpointFile(new File(checkpointPath), null);
        LeaderEpochFileCache cache2 = new LeaderEpochFileCache(this.tp(), (Function0)(JFunction0.mcJ.sp & Serializable)() -> this.logEndOffset(), (LeaderEpochCheckpoint)checkpoint2);
        Seq seq = cache2.epochEntries();
        if (seq == null) {
            throw null;
        }
        Assert.assertEquals((long)1L, (long)seq.length());
        List list = cache2.epochEntries().toList();
        boolean bl = false;
        if (list == null) {
            throw null;
        }
        Assert.assertEquals((Object)new EpochEntry(2, 6L), (Object)LinearSeqOps.apply$((LinearSeqOps)list, (int)apply_n));
    }

    @Test
    public void shouldEnforceMonotonicallyIncreasingEpochs() {
        this.cache().assign(1, 5L);
        this.logEndOffset_$eq(6L);
        this.cache().assign(2, 6L);
        this.logEndOffset_$eq(7L);
        this.cache().assign(1, 7L);
        this.logEndOffset_$eq(8L);
        Assert.assertEquals((Object)new Some((Object)1), (Object)this.cache().latestEpoch());
        Assert.assertEquals((Object)new Tuple2.mcII.sp(1, 8), (Object)this.cache().endOffsetFor(1));
        Assert.assertEquals((Object)new Tuple2.mcIJ.sp(-1, -1L), (Object)this.cache().endOffsetFor(2));
        Assert.assertEquals((Object)new EpochEntry(1, 7L), (Object)this.cache().epochEntries().apply(0));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void shouldEnforceOffsetsIncreaseMonotonically() {
        void apply_n;
        this.cache().assign(2, 6L);
        this.cache().assign(3, 5L);
        List list = this.cache().epochEntries().toList();
        boolean bl = false;
        if (list == null) {
            throw null;
        }
        Assert.assertEquals((Object)new EpochEntry(3, 5L), (Object)LinearSeqOps.apply$((LinearSeqOps)list, (int)apply_n));
    }

    @Test
    public void shouldIncreaseAndTrackEpochsAsLeadersChangeManyTimes() {
        this.cache().assign(0, 0L);
        this.cache().assign(1, 0L);
        Assert.assertEquals((Object)new Some((Object)1), (Object)this.cache().latestEpoch());
        Assert.assertEquals((Object)new Tuple2.mcII.sp(1, 0), (Object)this.cache().endOffsetFor(1));
        Assert.assertEquals((Object)new Tuple2.mcII.sp(0, 0), (Object)this.cache().endOffsetFor(0));
        this.logEndOffset_$eq(5L);
        Assert.assertEquals((Object)new Tuple2.mcII.sp(1, 5), (Object)this.cache().endOffsetFor(1));
        Assert.assertEquals((Object)new Tuple2.mcII.sp(0, 0), (Object)this.cache().endOffsetFor(0));
        this.cache().assign(2, 5L);
        this.logEndOffset_$eq(10L);
        Assert.assertEquals((Object)new Tuple2.mcII.sp(2, 10), (Object)this.cache().endOffsetFor(2));
        Assert.assertEquals((Object)new Tuple2.mcII.sp(1, 5), (Object)this.cache().endOffsetFor(1));
        Assert.assertEquals((Object)new Tuple2.mcII.sp(0, 0), (Object)this.cache().endOffsetFor(0));
    }

    @Test
    public void shouldIncreaseAndTrackEpochsAsFollowerReceivesManyMessages() {
        this.cache().assign(0, 0L);
        this.logEndOffset_$eq(1L);
        this.cache().assign(0, 1L);
        this.logEndOffset_$eq(2L);
        this.cache().assign(0, 2L);
        this.logEndOffset_$eq(3L);
        Assert.assertEquals((Object)new Some((Object)0), (Object)this.cache().latestEpoch());
        Assert.assertEquals((Object)new Tuple2.mcIJ.sp(0, this.logEndOffset()), (Object)this.cache().endOffsetFor(0));
        this.cache().assign(1, 3L);
        this.logEndOffset_$eq(4L);
        this.cache().assign(1, 4L);
        this.logEndOffset_$eq(5L);
        this.cache().assign(1, 5L);
        this.logEndOffset_$eq(6L);
        Assert.assertEquals((Object)new Some((Object)1), (Object)this.cache().latestEpoch());
        Assert.assertEquals((Object)new Tuple2.mcIJ.sp(1, this.logEndOffset()), (Object)this.cache().endOffsetFor(1));
        this.cache().assign(2, 6L);
        this.logEndOffset_$eq(7L);
        this.cache().assign(2, 7L);
        this.logEndOffset_$eq(8L);
        this.cache().assign(2, 8L);
        this.logEndOffset_$eq(9L);
        Assert.assertEquals((Object)new Some((Object)2), (Object)this.cache().latestEpoch());
        Assert.assertEquals((Object)new Tuple2.mcIJ.sp(2, this.logEndOffset()), (Object)this.cache().endOffsetFor(2));
        Assert.assertEquals((Object)new Tuple2.mcII.sp(0, 3), (Object)this.cache().endOffsetFor(0));
        Assert.assertEquals((Object)new Tuple2.mcII.sp(1, 6), (Object)this.cache().endOffsetFor(1));
    }

    @Test
    public void shouldDropEntriesOnEpochBoundaryWhenRemovingLatestEntries() {
        this.cache().assign(2, 6L);
        this.cache().assign(3, 8L);
        this.cache().assign(4, 11L);
        this.cache().truncateFromEnd(8L);
        Assert.assertEquals((Object)IterableFactory.apply$((IterableFactory)ListBuffer$.MODULE$, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new EpochEntry[]{new EpochEntry(2, 6L)})), (Object)this.cache().epochEntries());
    }

    @Test
    public void shouldPreserveResetOffsetOnClearEarliestIfOneExists() {
        this.cache().assign(2, 6L);
        this.cache().assign(3, 8L);
        this.cache().assign(4, 11L);
        this.cache().truncateFromStart(8L);
        Assert.assertEquals((Object)IterableFactory.apply$((IterableFactory)ListBuffer$.MODULE$, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new EpochEntry[]{new EpochEntry(3, 8L), new EpochEntry(4, 11L)})), (Object)this.cache().epochEntries());
    }

    @Test
    public void shouldUpdateSavedOffsetWhenOffsetToClearToIsBetweenEpochs() {
        this.cache().assign(2, 6L);
        this.cache().assign(3, 8L);
        this.cache().assign(4, 11L);
        this.cache().truncateFromStart(9L);
        Assert.assertEquals((Object)IterableFactory.apply$((IterableFactory)ListBuffer$.MODULE$, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new EpochEntry[]{new EpochEntry(3, 9L), new EpochEntry(4, 11L)})), (Object)this.cache().epochEntries());
    }

    @Test
    public void shouldNotClearAnythingIfOffsetToEarly() {
        this.cache().assign(2, 6L);
        this.cache().assign(3, 8L);
        this.cache().assign(4, 11L);
        this.cache().truncateFromStart(1L);
        Assert.assertEquals((Object)IterableFactory.apply$((IterableFactory)ListBuffer$.MODULE$, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new EpochEntry[]{new EpochEntry(2, 6L), new EpochEntry(3, 8L), new EpochEntry(4, 11L)})), (Object)this.cache().epochEntries());
    }

    @Test
    public void shouldNotClearAnythingIfOffsetToFirstOffset() {
        this.cache().assign(2, 6L);
        this.cache().assign(3, 8L);
        this.cache().assign(4, 11L);
        this.cache().truncateFromStart(6L);
        Assert.assertEquals((Object)IterableFactory.apply$((IterableFactory)ListBuffer$.MODULE$, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new EpochEntry[]{new EpochEntry(2, 6L), new EpochEntry(3, 8L), new EpochEntry(4, 11L)})), (Object)this.cache().epochEntries());
    }

    @Test
    public void shouldRetainLatestEpochOnClearAllEarliest() {
        this.cache().assign(2, 6L);
        this.cache().assign(3, 8L);
        this.cache().assign(4, 11L);
        this.cache().truncateFromStart(11L);
        Assert.assertEquals((Object)IterableFactory.apply$((IterableFactory)ListBuffer$.MODULE$, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new EpochEntry[]{new EpochEntry(4, 11L)})), (Object)this.cache().epochEntries());
    }

    @Test
    public void shouldUpdateOffsetBetweenEpochBoundariesOnClearEarliest() {
        this.cache().assign(2, 6L);
        this.cache().assign(3, 8L);
        this.cache().assign(4, 11L);
        this.cache().truncateFromStart(9L);
        Assert.assertEquals((Object)IterableFactory.apply$((IterableFactory)ListBuffer$.MODULE$, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new EpochEntry[]{new EpochEntry(3, 9L), new EpochEntry(4, 11L)})), (Object)this.cache().epochEntries());
    }

    @Test
    public void shouldUpdateOffsetBetweenEpochBoundariesOnClearEarliest2() {
        this.cache().assign(0, 0L);
        this.cache().assign(1, 7L);
        this.cache().assign(2, 10L);
        this.cache().truncateFromStart(5L);
        Assert.assertEquals((Object)IterableFactory.apply$((IterableFactory)ListBuffer$.MODULE$, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new EpochEntry[]{new EpochEntry(0, 5L), new EpochEntry(1, 7L), new EpochEntry(2, 10L)})), (Object)this.cache().epochEntries());
    }

    @Test
    public void shouldRetainLatestEpochOnClearAllEarliestAndUpdateItsOffset() {
        this.cache().assign(2, 6L);
        this.cache().assign(3, 8L);
        this.cache().assign(4, 11L);
        this.cache().truncateFromStart(15L);
        Assert.assertEquals((Object)IterableFactory.apply$((IterableFactory)ListBuffer$.MODULE$, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new EpochEntry[]{new EpochEntry(4, 15L)})), (Object)this.cache().epochEntries());
    }

    @Test
    public void shouldDropEntriesBetweenEpochBoundaryWhenRemovingNewest() {
        this.cache().assign(2, 6L);
        this.cache().assign(3, 8L);
        this.cache().assign(4, 11L);
        this.cache().truncateFromEnd(9L);
        Assert.assertEquals((Object)new Some((Object)3), (Object)this.cache().latestEpoch());
        Assert.assertEquals((Object)IterableFactory.apply$((IterableFactory)ListBuffer$.MODULE$, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new EpochEntry[]{new EpochEntry(2, 6L), new EpochEntry(3, 8L)})), (Object)this.cache().epochEntries());
    }

    @Test
    public void shouldClearAllEntries() {
        this.cache().assign(2, 6L);
        this.cache().assign(3, 8L);
        this.cache().assign(4, 11L);
        this.cache().clearAndFlush();
        Seq seq = this.cache().epochEntries();
        if (seq == null) {
            throw null;
        }
        Assert.assertEquals((long)0L, (long)seq.length());
    }

    @Test
    public void shouldNotResetEpochHistoryHeadIfUndefinedPassed() {
        this.cache().assign(2, 6L);
        this.cache().assign(3, 8L);
        this.cache().assign(4, 11L);
        this.cache().truncateFromEnd(-1L);
        Seq seq = this.cache().epochEntries();
        if (seq == null) {
            throw null;
        }
        Assert.assertEquals((long)3L, (long)seq.length());
    }

    @Test
    public void shouldNotResetEpochHistoryTailIfUndefinedPassed() {
        this.cache().assign(2, 6L);
        this.cache().assign(3, 8L);
        this.cache().assign(4, 11L);
        this.cache().truncateFromEnd(-1L);
        Seq seq = this.cache().epochEntries();
        if (seq == null) {
            throw null;
        }
        Assert.assertEquals((long)3L, (long)seq.length());
    }

    @Test
    public void shouldFetchLatestEpochOfEmptyCache() {
        Assert.assertEquals((Object)None$.MODULE$, (Object)this.cache().latestEpoch());
    }

    @Test
    public void shouldFetchEndOffsetOfEmptyCache() {
        Assert.assertEquals((Object)new Tuple2.mcIJ.sp(-1, -1L), (Object)this.cache().endOffsetFor(7));
    }

    @Test
    public void shouldClearEarliestOnEmptyCache() {
        this.cache().truncateFromStart(7L);
    }

    @Test
    public void shouldClearLatestOnEmptyCache() {
        this.cache().truncateFromEnd(7L);
    }
}

