/*
 * Decompiled with CFR 0.152.
 */
package kafka.admin;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.Map;
import java.util.Properties;
import javax.management.InstanceAlreadyExistsException;
import kafka.admin.AclCommand;
import kafka.admin.AclCommand$;
import kafka.security.authorizer.AclAuthorizer;
import kafka.security.authorizer.AclAuthorizer$;
import kafka.security.authorizer.AclEntry$;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.server.QuorumTestHarness;
import kafka.utils.LogCaptureAppender;
import kafka.utils.LogCaptureAppender$;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.acl.AccessControlEntry;
import org.apache.kafka.common.acl.AccessControlEntryFilter;
import org.apache.kafka.common.acl.AclOperation;
import org.apache.kafka.common.acl.AclPermissionType;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.resource.PatternType;
import org.apache.kafka.common.resource.ResourcePattern;
import org.apache.kafka.common.resource.ResourceType;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.AppInfoParser;
import org.apache.kafka.common.utils.Exit;
import org.apache.kafka.common.utils.SecurityUtils;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.authorizer.Authorizer;
import org.apache.kafka.test.TestUtils;
import org.apache.log4j.Level;
import org.apache.log4j.spi.LoggingEvent;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;
import scala.Array$;
import scala.Console$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\r5a\u0001\u0002\"D\u0001!CQ!\u0016\u0001\u0005\u0002YCq!\u0017\u0001A\u0002\u0013\u0005!\fC\u0004m\u0001\u0001\u0007I\u0011A7\t\rQ\u0004\u0001\u0015)\u0003\\\u0011\u001d)\bA1A\u0005\nYDq!!\u0004\u0001A\u0003%q\u000fC\u0005\u0002\u0010\u0001\u0011\r\u0011\"\u0003\u0002\u0012!A\u00111\u0005\u0001!\u0002\u0013\t\u0019\u0002C\u0005\u0002&\u0001\u0011\r\u0011\"\u0003\u0002(!A\u00111\b\u0001!\u0002\u0013\tI\u0003C\u0005\u0002>\u0001\u0011\r\u0011\"\u0003\u0002@!A\u0011q\t\u0001!\u0002\u0013\t\t\u0005C\u0005\u0002J\u0001\u0011\r\u0011\"\u0003\u0002@!A\u00111\n\u0001!\u0002\u0013\t\t\u0005C\u0005\u0002N\u0001\u0011\r\u0011\"\u0003\u0002P!A\u0011Q\f\u0001!\u0002\u0013\t\t\u0006C\u0005\u0002`\u0001\u0011\r\u0011\"\u0003\u0002b!A\u0011Q\r\u0001!\u0002\u0013\t\u0019\u0007C\u0005\u0002h\u0001\u0011\r\u0011\"\u0003\u0002b!A\u0011\u0011\u000e\u0001!\u0002\u0013\t\u0019\u0007C\u0005\u0002l\u0001\u0011\r\u0011\"\u0003\u0002b!A\u0011Q\u000e\u0001!\u0002\u0013\t\u0019\u0007C\u0005\u0002p\u0001\u0011\r\u0011\"\u0003\u0002b!A\u0011\u0011\u000f\u0001!\u0002\u0013\t\u0019\u0007C\u0005\u0002t\u0001\u0011\r\u0011\"\u0003\u0002v!A\u0011\u0011\u0013\u0001!\u0002\u0013\t9\bC\u0005\u0002\u0014\u0002\u0011\r\u0011\"\u0003\u0002\u0016\"A\u0011Q\u0016\u0001!\u0002\u0013\t9\nC\u0004\u00020\u0002!I!!-\t\u0013\u0005\u001d\u0007!%A\u0005\n\u0005%\u0007\"CAp\u0001\t\u0007I\u0011BAq\u0011!\t\u0019\u000f\u0001Q\u0001\n\u0005M\u0006\"CAs\u0001\t\u0007I\u0011BAt\u0011!\ty\u000f\u0001Q\u0001\n\u0005%\bbCAy\u0001\u0001\u0007\t\u0019!C\u0005\u0003gD1B!\u0001\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0003\u0004!Y!q\u0001\u0001A\u0002\u0003\u0005\u000b\u0015BA{\u0011-\u0011I\u0001\u0001a\u0001\u0002\u0004%IAa\u0003\t\u0017\t5\u0001\u00011AA\u0002\u0013%!q\u0002\u0005\f\u0005'\u0001\u0001\u0019!A!B\u0013\tY\tC\u0006\u0003\u0016\u0001\u0001\r\u00111A\u0005\n\t-\u0001b\u0003B\f\u0001\u0001\u0007\t\u0019!C\u0005\u00053A1B!\b\u0001\u0001\u0004\u0005\t\u0015)\u0003\u0002\f\"9!q\u0004\u0001\u0005B\t\u0005\u0002b\u0002B\"\u0001\u0011\u0005#Q\t\u0005\b\u0005\u001f\u0002A\u0011\u0001B#\u0011\u001d\u0011I\u0006\u0001C\u0001\u0005\u000bBqA!\u0018\u0001\t\u0013\u0011y\u0006C\u0005\u0003x\u0001\t\n\u0011\"\u0003\u0003z!9!Q\u0010\u0001\u0005\n\t}\u0004b\u0002BD\u0001\u0011%!\u0011\u0012\u0005\b\u0005\u001f\u0003A\u0011\u0002BI\u0011\u001d\u0011\u0019\u000b\u0001C\u0001\u0005\u000bBqAa*\u0001\t\u0003\u0011)\u0005C\u0004\u0003,\u0002!\tA!\u0012\t\u000f\t=\u0006\u0001\"\u0003\u00032\"9!Q\u0017\u0001\u0005\u0002\t\u0015\u0003b\u0002B]\u0001\u0011\u0005!Q\t\u0005\b\u0005{\u0003A\u0011\u0002B`\u0011\u001d\u0011\u0019\r\u0001C\u0001\u0005\u000bBqAa2\u0001\t\u0003\u0011)\u0005C\u0004\u0003L\u0002!IA!4\t\u000f\tU\u0007\u0001\"\u0003\u0003X\"9!\u0011\u001e\u0001\u0005\n\t-\bb\u0002Bx\u0001\u0011%!\u0011\u001f\u0002\u000f\u0003\u000ed7i\\7nC:$G+Z:u\u0015\t!U)A\u0003bI6LgNC\u0001G\u0003\u0015Y\u0017MZ6b\u0007\u0001\u00192\u0001A%P!\tQU*D\u0001L\u0015\taU)\u0001\u0004tKJ4XM]\u0005\u0003\u001d.\u0013\u0011#U;peVlG+Z:u\u0011\u0006\u0014h.Z:t!\t\u00016+D\u0001R\u0015\t\u0011V)A\u0003vi&d7/\u0003\u0002U#\n9Aj\\4hS:<\u0017A\u0002\u001fj]&$h\bF\u0001X!\tA\u0006!D\u0001D\u0003\u001d\u0019XM\u001d<feN,\u0012a\u0017\t\u00049\u001aLgBA/d\u001d\tq\u0016-D\u0001`\u0015\t\u0001w)\u0001\u0004=e>|GOP\u0005\u0002E\u0006)1oY1mC&\u0011A-Z\u0001\ba\u0006\u001c7.Y4f\u0015\u0005\u0011\u0017BA4i\u0005\r\u0019V-\u001d\u0006\u0003I\u0016\u0004\"A\u00136\n\u0005-\\%aC&bM.\f7+\u001a:wKJ\f1b]3sm\u0016\u00148o\u0018\u0013fcR\u0011aN\u001d\t\u0003_Bl\u0011!Z\u0005\u0003c\u0016\u0014A!\u00168ji\"91oAA\u0001\u0002\u0004Y\u0016a\u0001=%c\u0005A1/\u001a:wKJ\u001c\b%A\u0005qe&t7-\u001b9bYV\tq\u000fE\u0002y\u0003\u0013i\u0011!\u001f\u0006\u0003un\fA!Y;uQ*\u0011A0`\u0001\tg\u0016\u001cWO]5us*\u0011ap`\u0001\u0007G>lWn\u001c8\u000b\u0007\u0019\u000b\tA\u0003\u0003\u0002\u0004\u0005\u0015\u0011AB1qC\u000eDWM\u0003\u0002\u0002\b\u0005\u0019qN]4\n\u0007\u0005-\u0011P\u0001\bLC\u001a\\\u0017\r\u0015:j]\u000eL\u0007/\u00197\u0002\u0015A\u0014\u0018N\\2ja\u0006d\u0007%A\u0003Vg\u0016\u00148/\u0006\u0002\u0002\u0014A)\u0011QCA\u0010o6\u0011\u0011q\u0003\u0006\u0005\u00033\tY\"A\u0005j[6,H/\u00192mK*\u0019\u0011QD3\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002\"\u0005]!aA*fi\u00061Qk]3sg\u0002\nQ\u0001S8tiN,\"!!\u000b\u0011\r\u0005U\u0011qDA\u0016!\u0011\ti#a\u000e\u000e\u0005\u0005=\"\u0002BA\u0019\u0003g\tA\u0001\\1oO*\u0011\u0011QG\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002:\u0005=\"AB*ue&tw-\u0001\u0004I_N$8\u000fI\u0001\u0011\u00032dwn\u001e%pgR\u001cu.\\7b]\u0012,\"!!\u0011\u0011\u000b=\f\u0019%a\u000b\n\u0007\u0005\u0015SMA\u0003BeJ\f\u00170A\tBY2|w\u000fS8ti\u000e{W.\\1oI\u0002\nq\u0002R3os\"{7\u000f^\"p[6\fg\u000eZ\u0001\u0011\t\u0016t\u0017\u0010S8ti\u000e{W.\\1oI\u0002\nqb\u00117vgR,'OU3t_V\u00148-Z\u000b\u0003\u0003#\u0002B!a\u0015\u0002Z5\u0011\u0011Q\u000b\u0006\u0004\u0003/j\u0018\u0001\u0003:fg>,(oY3\n\t\u0005m\u0013Q\u000b\u0002\u0010%\u0016\u001cx.\u001e:dKB\u000bG\u000f^3s]\u0006\u00012\t\\;ti\u0016\u0014(+Z:pkJ\u001cW\rI\u0001\u000f)>\u0004\u0018n\u0019*fg>,(oY3t+\t\t\u0019\u0007\u0005\u0004\u0002\u0016\u0005}\u0011\u0011K\u0001\u0010)>\u0004\u0018n\u0019*fg>,(oY3tA\u0005qqI]8vaJ+7o\\;sG\u0016\u001c\u0018aD$s_V\u0004(+Z:pkJ\u001cWm\u001d\u0011\u00021Q\u0013\u0018M\\:bGRLwN\\1m\u0013\u0012\u0014Vm]8ve\u000e,7/A\rUe\u0006t7/Y2uS>t\u0017\r\\%e%\u0016\u001cx.\u001e:dKN\u0004\u0013A\u0004+pW\u0016t'+Z:pkJ\u001cWm]\u0001\u0010)>\\WM\u001c*fg>,(oY3tA\u0005\t\"+Z:pkJ\u001cW\rV8D_6l\u0017M\u001c3\u0016\u0005\u0005]\u0004\u0003CA\u000b\u0003s\ni(a#\n\t\u0005m\u0014q\u0003\u0002\u0004\u001b\u0006\u0004\bCBA@\u0003\u000f\u000b\tF\u0004\u0003\u0002\u0002\u0006\r\u0005C\u00010f\u0013\r\t))Z\u0001\u0007!J,G-\u001a4\n\t\u0005\u0005\u0012\u0011\u0012\u0006\u0004\u0003\u000b+\u0007#B8\u0002D\u00055\u0005\u0003BA@\u0003\u001fKA!!\u000f\u0002\n\u0006\u0011\"+Z:pkJ\u001cW\rV8D_6l\u0017M\u001c3!\u0003Q\u0011Vm]8ve\u000e,Gk\\(qKJ\fG/[8ogV\u0011\u0011q\u0013\t\t\u0003+\tI(! \u0002\u001aB9q.a'\u0002 \u0006-\u0015bAAOK\n1A+\u001e9mKJ\u0002b!a \u0002\b\u0006\u0005\u0006\u0003BAR\u0003Sk!!!*\u000b\u0007\u0005\u001dV0A\u0002bG2LA!a+\u0002&\na\u0011i\u00197Pa\u0016\u0014\u0018\r^5p]\u0006)\"+Z:pkJ\u001cW\rV8Pa\u0016\u0014\u0018\r^5p]N\u0004\u0013A\u0006)s_\u0012,8-\u001a:SKN|WO]2f)>\f5\r\\:\u0015\t\u0005M\u0016Q\u0018\t\t\u0003+\tI(! \u00026B1\u0011qPAD\u0003o\u0003B!a)\u0002:&!\u00111XAS\u0005I\t5mY3tg\u000e{g\u000e\u001e:pY\u0016sGO]=\t\u0013\u0005}V\u0004%AA\u0002\u0005\u0005\u0017!E3oC\ndW-\u00133f[B|G/\u001a8dKB\u0019q.a1\n\u0007\u0005\u0015WMA\u0004C_>dW-\u00198\u0002AA\u0013x\u000eZ;dKJ\u0014Vm]8ve\u000e,Gk\\!dYN$C-\u001a4bk2$H%M\u000b\u0003\u0003\u0017TC!!1\u0002N.\u0012\u0011q\u001a\t\u0005\u0003#\fY.\u0004\u0002\u0002T*!\u0011Q[Al\u0003%)hn\u00195fG.,GMC\u0002\u0002Z\u0016\f!\"\u00198o_R\fG/[8o\u0013\u0011\ti.a5\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-\u0001\fD_:\u001cX/\\3s%\u0016\u001cx.\u001e:dKR{\u0017i\u00197t+\t\t\u0019,A\fD_:\u001cX/\\3s%\u0016\u001cx.\u001e:dKR{\u0017i\u00197tA\u0005\u00192)\u001c3U_J+7o\\;sG\u0016\u001cHk\\!dYV\u0011\u0011\u0011\u001e\t\t\u0003+\tI(a#\u0002lBA\u0011qPAw\u0003{\n),\u0003\u0003\u0002|\u0005%\u0015\u0001F\"nIR{'+Z:pkJ\u001cWm\u001d+p\u0003\u000ed\u0007%A\u0006ce>\\WM\u001d)s_B\u001cXCAA{!\u0011\t90!@\u000e\u0005\u0005e(\u0002BA~\u0003g\tA!\u001e;jY&!\u0011q`A}\u0005)\u0001&o\u001c9feRLWm]\u0001\u0010EJ|7.\u001a:Qe>\u00048o\u0018\u0013fcR\u0019aN!\u0002\t\u0011M$\u0013\u0011!a\u0001\u0003k\fAB\u0019:pW\u0016\u0014\bK]8qg\u0002\naA_6Be\u001e\u001cXCAAF\u0003)Q8.\u0011:hg~#S-\u001d\u000b\u0004]\nE\u0001\u0002C:(\u0003\u0003\u0005\r!a#\u0002\u000fi\\\u0017I]4tA\u0005I\u0011\rZ7j]\u0006\u0013xm]\u0001\u000eC\u0012l\u0017N\\!sON|F%Z9\u0015\u00079\u0014Y\u0002\u0003\u0005tU\u0005\u0005\t\u0019AAF\u0003)\tG-\\5o\u0003J<7\u000fI\u0001\u0006g\u0016$X\u000b\u001d\u000b\u0004]\n\r\u0002b\u0002B\u0013Y\u0001\u0007!qE\u0001\ti\u0016\u001cH/\u00138g_B!!\u0011\u0006B\u001c\u001b\t\u0011YC\u0003\u0003\u0003.\t=\u0012aA1qS*!!\u0011\u0007B\u001a\u0003\u001dQW\u000f]5uKJTAA!\u000e\u0002\u0006\u0005)!.\u001e8ji&!!\u0011\bB\u0016\u0005!!Vm\u001d;J]\u001a|\u0007f\u0001\u0017\u0003>A!!\u0011\u0006B \u0013\u0011\u0011\tEa\u000b\u0003\u0015\t+gm\u001c:f\u000b\u0006\u001c\u0007.\u0001\u0005uK\u0006\u0014Hi\\<o)\u0005q\u0007fA\u0017\u0003JA!!\u0011\u0006B&\u0013\u0011\u0011iEa\u000b\u0003\u0013\u00053G/\u001a:FC\u000eD\u0017\u0001\u0007;fgR\f5\r\\\"mS^KG\u000f[!vi\"|'/\u001b>fe\"\u001aaFa\u0015\u0011\t\t%\"QK\u0005\u0005\u0005/\u0012YC\u0001\u0003UKN$\u0018A\u0006;fgR\f5\r\\\"mS^KG\u000f[!e[&t\u0017\tU%)\u0007=\u0012\u0019&\u0001\u0007de\u0016\fG/Z*feZ,'\u000fF\u0002o\u0005CB\u0011Ba\u00191!\u0003\u0005\rA!\u001a\u0002\u001b\r|W.\\1oI\u000e{gNZ5h!\u0015y'q\rB6\u0013\r\u0011I'\u001a\u0002\u0007\u001fB$\u0018n\u001c8\u0011\t\t5$1O\u0007\u0003\u0005_RAA!\u001d\u00024\u0005\u0011\u0011n\\\u0005\u0005\u0005k\u0012yG\u0001\u0003GS2,\u0017AF2sK\u0006$XmU3sm\u0016\u0014H\u0005Z3gCVdG\u000fJ\u0019\u0016\u0005\tm$\u0006\u0002B3\u0003\u001b\f\u0001bY1mY6\u000b\u0017N\u001c\u000b\u0005\u0005\u0003\u0013\u0019\tE\u0004p\u00037\u000bi)!$\t\u000f\t\u0015%\u00071\u0001\u0002\f\u0006!\u0011M]4t\u0003)!Xm\u001d;BG2\u001cE.\u001b\u000b\u0004]\n-\u0005b\u0002BGg\u0001\u0007\u00111R\u0001\bG6$\u0017I]4t\u0003Q\t7o]3si>+H\u000f];u\u0007>tG/Y5ogRIaNa%\u0003\u0018\nm%q\u0014\u0005\b\u0005+#\u0004\u0019AAG\u0003\u0019\u0001(/\u001a4jq\"9!\u0011\u0014\u001bA\u0002\u0005u\u0014!\u0003:fg>,(oY3t\u0011\u001d\u0011i\n\u000ea\u0001\u0003\u0017\u000b1B]3t_V\u00148-Z\"nI\"9!\u0011\u0015\u001bA\u0002\u00055\u0015AB8viB,H/A\u0013uKN$\bK]8ek\u000e,'oQ8ogVlWM]\"mS^KG\u000f[!vi\"|'/\u001b>fe\"\u001aQGa\u0015\u0002GQ,7\u000f\u001e)s_\u0012,8-\u001a:D_:\u001cX/\\3s\u00072Lw+\u001b;i\u0003\u0012l\u0017N\\!Q\u0013\"\u001aaGa\u0015\u0002-Q,7\u000f^!dY\u000ec\u0017nV5uQ\u000ec\u0017.\u001a8u\u0013\u0012D3a\u000eB*\u0003]!Xm\u001d;Qe>$WoY3s\u0007>t7/^7fe\u000ec\u0017\u000eF\u0002o\u0005gCqA!$9\u0001\u0004\tY)A\u0015uKN$\u0018i\u00197t\u001f:\u0004&/\u001a4jq\u0016$'+Z:pkJ\u001cWm],ji\"\fU\u000f\u001e5pe&TXM\u001d\u0015\u0004s\tM\u0013a\n;fgR\f5\r\\:P]B\u0013XMZ5yK\u0012\u0014Vm]8ve\u000e,7oV5uQ\u0006#W.\u001b8B!&C3A\u000fB*\u0003m!Xm\u001d;BG2\u001cxJ\u001c)sK\u001aL\u00070\u001a3SKN|WO]2fgR\u0019aN!1\t\u000f\t55\b1\u0001\u0002\f\u0006iB/Z:u\u0013:4\u0018\r\\5e\u0003V$\bn\u001c:ju\u0016\u0014\bK]8qKJ$\u0018\u0010K\u0002=\u0005'\n\u0001\u0003^3tiB\u000bG\u000f^3s]RK\b/Z:)\u0007u\u0012\u0019&\u0001\u0006uKN$(+Z7pm\u0016$rA\u001cBh\u0005#\u0014\u0019\u000eC\u0004\u0003\u000ez\u0002\r!a#\t\u000f\tee\b1\u0001\u0002~!9!Q\u0014 A\u0002\u0005-\u0015aD4fi\u0006\u001bG\u000eV8D_6l\u0017M\u001c3\u0015\r\te'1\u001cBs!\u001dy\u00171TA[\u0003\u0017CqA!8@\u0001\u0004\u0011y.\u0001\bqKJl\u0017n]:j_:$\u0016\u0010]3\u0011\t\u0005\r&\u0011]\u0005\u0005\u0005G\f)KA\tBG2\u0004VM]7jgNLwN\u001c+za\u0016DqAa:@\u0001\u0004\ty*\u0001\u0006pa\u0016\u0014\u0018\r^5p]N\faaZ3u\u00076$G\u0003BAF\u0005[DqA!8A\u0001\u0004\u0011y.\u0001\bxSRD\u0017)\u001e;i_JL'0\u001a:\u0015\u0005\tMHc\u00018\u0003v\"9!q_!A\u0002\te\u0018!\u00014\u0011\r=\u0014YPa@o\u0013\r\u0011i0\u001a\u0002\n\rVt7\r^5p]F\u0002Ba!\u0001\u0004\n5\u001111\u0001\u0006\u0005\u0007\u000b\u00199!\u0001\u0006bkRDwN]5{KJT!\u0001T@\n\t\r-11\u0001\u0002\u000b\u0003V$\bn\u001c:ju\u0016\u0014\b")
public class AclCommandTest
extends QuorumTestHarness {
    private Seq<KafkaServer> servers = (Seq)package$.MODULE$.Seq().apply((Seq)Nil$.MODULE$);
    private final KafkaPrincipal principal = SecurityUtils.parseKafkaPrincipal((String)"User:test2");
    private final Set<KafkaPrincipal> Users = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new KafkaPrincipal[]{SecurityUtils.parseKafkaPrincipal((String)"User:CN=writeuser,OU=Unknown,O=Unknown,L=Unknown,ST=Unknown,C=Unknown"), this.principal(), SecurityUtils.parseKafkaPrincipal((String)"User:CN=\\#User with special chars in CN : (\\, \\+ \\\" \\\\ \\< \\> \\; ')")}));
    private final Set<String> Hosts = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"host1", "host2"}));
    private final String[] AllowHostCommand = new String[]{"--allow-host", "host1", "--allow-host", "host2"};
    private final String[] DenyHostCommand = new String[]{"--deny-host", "host1", "--deny-host", "host2"};
    private final ResourcePattern ClusterResource = new ResourcePattern(ResourceType.CLUSTER, "kafka-cluster", PatternType.LITERAL);
    private final Set<ResourcePattern> TopicResources = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ResourcePattern[]{new ResourcePattern(ResourceType.TOPIC, "test-1", PatternType.LITERAL), new ResourcePattern(ResourceType.TOPIC, "test-2", PatternType.LITERAL)}));
    private final Set<ResourcePattern> GroupResources = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ResourcePattern[]{new ResourcePattern(ResourceType.GROUP, "testGroup-1", PatternType.LITERAL), new ResourcePattern(ResourceType.GROUP, "testGroup-2", PatternType.LITERAL)}));
    private final Set<ResourcePattern> TransactionalIdResources = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ResourcePattern[]{new ResourcePattern(ResourceType.TRANSACTIONAL_ID, "t0", PatternType.LITERAL), new ResourcePattern(ResourceType.TRANSACTIONAL_ID, "t1", PatternType.LITERAL)}));
    private final Set<ResourcePattern> TokenResources = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ResourcePattern[]{new ResourcePattern(ResourceType.DELEGATION_TOKEN, "token1", PatternType.LITERAL), new ResourcePattern(ResourceType.DELEGATION_TOKEN, "token2", PatternType.LITERAL)}));
    private final scala.collection.immutable.Map<Set<ResourcePattern>, String[]> ResourceToCommand = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(this.TopicResources()), (Object)new String[]{"--topic", "test-1", "--topic", "test-2"}), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ResourcePattern[]{this.ClusterResource()}))), (Object)new String[]{"--cluster"}), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(this.GroupResources()), (Object)new String[]{"--group", "testGroup-1", "--group", "testGroup-2"}), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(this.TransactionalIdResources()), (Object)new String[]{"--transactional-id", "t0", "--transactional-id", "t1"}), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(this.TokenResources()), (Object)new String[]{"--delegation-token", "token1", "--delegation-token", "token2"})}));
    private final scala.collection.immutable.Map<Set<ResourcePattern>, Tuple2<Set<AclOperation>, String[]>> ResourceToOperations = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(this.TopicResources()), (Object)new Tuple2(Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AclOperation[]{AclOperation.READ, AclOperation.WRITE, AclOperation.CREATE, AclOperation.DESCRIBE, AclOperation.DELETE, AclOperation.DESCRIBE_CONFIGS, AclOperation.ALTER_CONFIGS, AclOperation.ALTER})), (Object)new String[]{"--operation", "Read", "--operation", "Write", "--operation", "Create", "--operation", "Describe", "--operation", "Delete", "--operation", "DescribeConfigs", "--operation", "AlterConfigs", "--operation", "Alter"})), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ResourcePattern[]{this.ClusterResource()}))), (Object)new Tuple2(Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AclOperation[]{AclOperation.CREATE, AclOperation.CLUSTER_ACTION, AclOperation.DESCRIBE_CONFIGS, AclOperation.ALTER_CONFIGS, AclOperation.IDEMPOTENT_WRITE, AclOperation.ALTER, AclOperation.DESCRIBE})), (Object)new String[]{"--operation", "Create", "--operation", "ClusterAction", "--operation", "DescribeConfigs", "--operation", "AlterConfigs", "--operation", "IdempotentWrite", "--operation", "Alter", "--operation", "Describe"})), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(this.GroupResources()), (Object)new Tuple2(Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AclOperation[]{AclOperation.READ, AclOperation.DESCRIBE, AclOperation.DELETE})), (Object)new String[]{"--operation", "Read", "--operation", "Describe", "--operation", "Delete"})), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(this.TransactionalIdResources()), (Object)new Tuple2(Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AclOperation[]{AclOperation.DESCRIBE, AclOperation.WRITE})), (Object)new String[]{"--operation", "Describe", "--operation", "Write"})), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(this.TokenResources()), (Object)new Tuple2(Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AclOperation[]{AclOperation.DESCRIBE})), (Object)new String[]{"--operation", "Describe"}))}));
    private final scala.collection.immutable.Map<Set<ResourcePattern>, Set<AccessControlEntry>> ConsumerResourceToAcls = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(this.TopicResources()), (Object)AclCommand$.MODULE$.getAcls(this.Users(), AclPermissionType.ALLOW, (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AclOperation[]{AclOperation.READ, AclOperation.DESCRIBE})), this.Hosts())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(this.GroupResources()), (Object)AclCommand$.MODULE$.getAcls(this.Users(), AclPermissionType.ALLOW, (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AclOperation[]{AclOperation.READ})), this.Hosts()))}));
    private final scala.collection.immutable.Map<String[], scala.collection.immutable.Map<Set<ResourcePattern>, Set<AccessControlEntry>>> CmdToResourcesToAcl = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new String[]{"--producer"}), this.ProducerResourceToAcls(this.ProducerResourceToAcls$default$1())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new String[]{"--producer", "--idempotent"}), this.ProducerResourceToAcls(true)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new String[]{"--consumer"}), this.ConsumerResourceToAcls()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new String[]{"--producer", "--consumer"}), (Object)this.ConsumerResourceToAcls().map((Function1 & Serializable)x0$1 -> {
        if (x0$1 == null) {
            throw new MatchError(null);
        }
        Set k = (Set)x0$1._1();
        Set v = (Set)x0$1._2();
        Tuple2 tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)k), (Object)v.$plus$plus((IterableOnce)this.ProducerResourceToAcls(false).getOrElse((Object)k, (Function0 & Serializable)() -> Predef$.MODULE$.Set().empty())));
        return tuple2;
    })), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new String[]{"--producer", "--idempotent", "--consumer"}), (Object)this.ConsumerResourceToAcls().map((Function1 & Serializable)x0$2 -> {
        if (x0$2 == null) {
            throw new MatchError(null);
        }
        Set k = (Set)x0$2._1();
        Set v = (Set)x0$2._2();
        Tuple2 tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)k), (Object)v.$plus$plus((IterableOnce)this.ProducerResourceToAcls(true).getOrElse((Object)k, (Function0 & Serializable)() -> Predef$.MODULE$.Set().empty())));
        return tuple2;
    }))}));
    private Properties brokerProps;
    private String[] zkArgs;
    private String[] adminArgs;

    public Seq<KafkaServer> servers() {
        return this.servers;
    }

    public void servers_$eq(Seq<KafkaServer> x$1) {
        this.servers = x$1;
    }

    private KafkaPrincipal principal() {
        return this.principal;
    }

    private Set<KafkaPrincipal> Users() {
        return this.Users;
    }

    private Set<String> Hosts() {
        return this.Hosts;
    }

    private String[] AllowHostCommand() {
        return this.AllowHostCommand;
    }

    private String[] DenyHostCommand() {
        return this.DenyHostCommand;
    }

    private ResourcePattern ClusterResource() {
        return this.ClusterResource;
    }

    private Set<ResourcePattern> TopicResources() {
        return this.TopicResources;
    }

    private Set<ResourcePattern> GroupResources() {
        return this.GroupResources;
    }

    private Set<ResourcePattern> TransactionalIdResources() {
        return this.TransactionalIdResources;
    }

    private Set<ResourcePattern> TokenResources() {
        return this.TokenResources;
    }

    private scala.collection.immutable.Map<Set<ResourcePattern>, String[]> ResourceToCommand() {
        return this.ResourceToCommand;
    }

    private scala.collection.immutable.Map<Set<ResourcePattern>, Tuple2<Set<AclOperation>, String[]>> ResourceToOperations() {
        return this.ResourceToOperations;
    }

    private scala.collection.immutable.Map<Set<ResourcePattern>, Set<AccessControlEntry>> ProducerResourceToAcls(boolean enableIdempotence) {
        return (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(this.TopicResources()), (Object)AclCommand$.MODULE$.getAcls(this.Users(), AclPermissionType.ALLOW, (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AclOperation[]{AclOperation.WRITE, AclOperation.DESCRIBE, AclOperation.CREATE})), this.Hosts())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(this.TransactionalIdResources()), (Object)AclCommand$.MODULE$.getAcls(this.Users(), AclPermissionType.ALLOW, (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AclOperation[]{AclOperation.WRITE, AclOperation.DESCRIBE})), this.Hosts())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ResourcePattern[]{this.ClusterResource()}))), (Object)AclCommand$.MODULE$.getAcls(this.Users(), AclPermissionType.ALLOW, (Set)((IterableOps)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Option[]{enableIdempotence ? new Some((Object)AclOperation.IDEMPOTENT_WRITE) : None$.MODULE$}))).flatten(Predef$.MODULE$.$conforms()), this.Hosts()))}));
    }

    private boolean ProducerResourceToAcls$default$1() {
        return false;
    }

    private scala.collection.immutable.Map<Set<ResourcePattern>, Set<AccessControlEntry>> ConsumerResourceToAcls() {
        return this.ConsumerResourceToAcls;
    }

    private scala.collection.immutable.Map<String[], scala.collection.immutable.Map<Set<ResourcePattern>, Set<AccessControlEntry>>> CmdToResourcesToAcl() {
        return this.CmdToResourcesToAcl;
    }

    private Properties brokerProps() {
        return this.brokerProps;
    }

    private void brokerProps_$eq(Properties x$1) {
        this.brokerProps = x$1;
    }

    private String[] zkArgs() {
        return this.zkArgs;
    }

    private void zkArgs_$eq(String[] x$1) {
        this.zkArgs = x$1;
    }

    private String[] adminArgs() {
        return this.adminArgs;
    }

    private void adminArgs_$eq(String[] x$1) {
        this.adminArgs = x$1;
    }

    @Override
    @BeforeEach
    public void setUp(TestInfo testInfo) {
        super.setUp(testInfo);
        this.brokerProps_$eq(TestUtils$.MODULE$.createBrokerConfig(0, this.zkConnect(), true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1));
        this.brokerProps().put(KafkaConfig$.MODULE$.AuthorizerClassNameProp(), AclAuthorizer.class.getName());
        this.brokerProps().put(AclAuthorizer$.MODULE$.SuperUsersProp(), "User:ANONYMOUS");
        this.zkArgs_$eq(new String[]{"--authorizer-properties", new StringBuilder(18).append("zookeeper.connect=").append(this.zkConnect()).toString()});
    }

    @Override
    @AfterEach
    public void tearDown() {
        TestUtils$.MODULE$.shutdownServers(this.servers());
        super.tearDown();
    }

    @Test
    public void testAclCliWithAuthorizer() {
        this.testAclCli(this.zkArgs());
    }

    @Test
    public void testAclCliWithAdminAPI() {
        this.createServer((Option<File>)None$.MODULE$);
        this.testAclCli(this.adminArgs());
    }

    /*
     * WARNING - void declaration
     */
    private void createServer(Option<File> commandConfig) {
        void createServer_time;
        void createServer_config;
        Time time;
        Object[] objectArray = new KafkaServer[1];
        Time time2 = time = Time.SYSTEM;
        time = null;
        Time time3 = time2;
        KafkaConfig kafkaConfig = KafkaConfig$.MODULE$.fromProps(this.brokerProps());
        TestUtils$ createServer_this = TestUtils$.MODULE$;
        None$ createServer_createServer_threadNamePrefix = None$.MODULE$;
        Object var7_6 = null;
        Object var4_5 = null;
        kafkaConfig = null;
        time3 = null;
        objectArray[0] = createServer_this.createServer((KafkaConfig)createServer_config, (Time)createServer_time, (Option<String>)createServer_createServer_threadNamePrefix, false);
        this.servers_$eq((Seq<KafkaServer>)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray))));
        ListenerName listenerName = ListenerName.forSecurityProtocol((SecurityProtocol)SecurityProtocol.PLAINTEXT);
        Object[] adminArgs = new String[]{"--bootstrap-server", TestUtils$.MODULE$.bootstrapServers(this.servers(), listenerName)};
        if (commandConfig.isDefined()) {
            adminArgs = (String[])ArrayOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.refArrayOps(adminArgs), (Object)new String[]{"--command-config", ((File)commandConfig.get()).getAbsolutePath()}, ClassTag$.MODULE$.apply(String.class));
        }
        this.adminArgs_$eq((String[])adminArgs);
    }

    private Option<File> createServer$default$1() {
        return None$.MODULE$;
    }

    private Tuple2<String, String> callMain(String[] args) {
        JFunction0.mcV.sp & Serializable grabConsoleOutputAndError_f = (JFunction0.mcV.sp & Serializable)() -> AclCommand$.MODULE$.main(args);
        ByteArrayOutputStream grabConsoleOutputAndError_out = new ByteArrayOutputStream();
        ByteArrayOutputStream grabConsoleOutputAndError_err = new ByteArrayOutputStream();
        try {
            Console$.MODULE$.withOut((OutputStream)grabConsoleOutputAndError_out, (Function0)((JFunction0.mcV.sp & Serializable)() -> TestUtils$.$anonfun$grabConsoleOutputAndError$1(grabConsoleOutputAndError_err, (Function0)grabConsoleOutputAndError_f)));
        }
        finally {
            Console$.MODULE$.out().flush();
            Console$.MODULE$.err().flush();
        }
        return new Tuple2((Object)grabConsoleOutputAndError_out.toString(), (Object)grabConsoleOutputAndError_err.toString());
    }

    private void testAclCli(String[] cmdArgs) {
        this.ResourceToCommand().withFilter((Function1 & Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)(bl = check$ifrefutable$1 != null))).foreach((Function1 & Serializable)x$7 -> {
            AclCommandTest.$anonfun$testAclCli$2(this, cmdArgs, x$7);
            return BoxedUnit.UNIT;
        });
    }

    private void assertOutputContains(String prefix, Set<ResourcePattern> resources, String[] resourceCmd, String output) {
        resources.foreach((Function1 & Serializable)resource -> {
            AclCommandTest.$anonfun$assertOutputContains$1(this, resourceCmd, prefix, output, resource);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testProducerConsumerCliWithAuthorizer() {
        this.testProducerConsumerCli(this.zkArgs());
    }

    @Test
    public void testProducerConsumerCliWithAdminAPI() {
        this.createServer((Option<File>)None$.MODULE$);
        this.testProducerConsumerCli(this.adminArgs());
    }

    @Test
    public void testAclCliWithClientId() {
        File file;
        File file2 = file = TestUtils.tempFile();
        file = null;
        File adminClientConfig = file2;
        PrintWriter pw = new PrintWriter(adminClientConfig);
        pw.println("client.id=my-client");
        pw.close();
        this.createServer((Option<File>)new Some((Object)adminClientConfig));
        LogCaptureAppender appender = LogCaptureAppender$.MODULE$.createAndRegister();
        Level previousLevel = LogCaptureAppender$.MODULE$.setClassLoggerLevel(AppInfoParser.class, Level.WARN);
        try {
            this.testAclCli(this.adminArgs());
        }
        finally {
            LogCaptureAppender$.MODULE$.setClassLoggerLevel(AppInfoParser.class, previousLevel);
            LogCaptureAppender$.MODULE$.unregister(appender);
        }
        Assertions.assertFalse((boolean)appender.getMessages().find((Function1 & Serializable)e -> BoxesRunTime.boxToBoolean((boolean)AclCommandTest.$anonfun$testAclCliWithClientId$1(e))).isDefined(), (String)"There should be no warnings about multiple registration of mbeans");
    }

    private void testProducerConsumerCli(String[] cmdArgs) {
        this.CmdToResourcesToAcl().withFilter((Function1 & Serializable)check$ifrefutable$2 -> BoxesRunTime.boxToBoolean((boolean)(bl = check$ifrefutable$2 != null))).foreach((Function1 & Serializable)x$12 -> {
            AclCommandTest.$anonfun$testProducerConsumerCli$2(this, cmdArgs, x$12);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testAclsOnPrefixedResourcesWithAuthorizer() {
        this.testAclsOnPrefixedResources(this.zkArgs());
    }

    @Test
    public void testAclsOnPrefixedResourcesWithAdminAPI() {
        this.createServer((Option<File>)None$.MODULE$);
        this.testAclsOnPrefixedResources(this.adminArgs());
    }

    /*
     * WARNING - void declaration
     */
    private void testAclsOnPrefixedResources(String[] cmdArgs) {
        void withAuthorizer_fromProps_doLog;
        KafkaConfig kafkaConfig;
        void withAuthorizer_fromProps_doLog2;
        KafkaConfig kafkaConfig2;
        String[] cmd = new String[]{"--allow-principal", this.principal().toString(), "--producer", "--topic", "Test-", "--resource-pattern-type", "Prefixed"};
        this.callMain((String[])ArrayOps$.MODULE$.$colon$plus$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.refArrayOps((Object[])cmdArgs), (Object)cmd, ClassTag$.MODULE$.apply(String.class))), (Object)"--add", ClassTag$.MODULE$.apply(String.class)));
        boolean bl = false;
        Properties withAuthorizer_fromProps_props = this.brokerProps();
        KafkaConfig kafkaConfig3 = kafkaConfig2 = new KafkaConfig((Map)withAuthorizer_fromProps_props, (boolean)withAuthorizer_fromProps_doLog2);
        Object var6_4 = null;
        kafkaConfig2 = null;
        KafkaConfig withAuthorizer_kafkaConfig = kafkaConfig3;
        try (AclAuthorizer withAuthorizer_authZ = new AclAuthorizer();){
            withAuthorizer_authZ.configure(withAuthorizer_kafkaConfig.originals());
            AclCommandTest.$anonfun$testAclsOnPrefixedResources$1(this, (Authorizer)withAuthorizer_authZ);
        }
        Object var3_6 = null;
        Object var4_7 = null;
        this.callMain((String[])ArrayOps$.MODULE$.$colon$plus$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.$colon$plus$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.refArrayOps((Object[])cmdArgs), (Object)cmd, ClassTag$.MODULE$.apply(String.class))), (Object)"--remove", ClassTag$.MODULE$.apply(String.class))), (Object)"--force", ClassTag$.MODULE$.apply(String.class)));
        boolean bl2 = false;
        Properties withAuthorizer_fromProps_props2 = this.brokerProps();
        KafkaConfig kafkaConfig4 = kafkaConfig = new KafkaConfig((Map)withAuthorizer_fromProps_props2, (boolean)withAuthorizer_fromProps_doLog);
        Object var12_10 = null;
        kafkaConfig = null;
        KafkaConfig withAuthorizer_kafkaConfig2 = kafkaConfig4;
        try (AclAuthorizer withAuthorizer_authZ = new AclAuthorizer();){
            withAuthorizer_authZ.configure(withAuthorizer_kafkaConfig2.originals());
            AclCommandTest.$anonfun$testAclsOnPrefixedResources$2((Authorizer)withAuthorizer_authZ);
        }
    }

    @Test
    public void testInvalidAuthorizerProperty() {
        String[] args = new String[]{"--authorizer-properties", new StringBuilder(18).append("zookeeper.connect ").append(this.zkConnect()).toString()};
        AclCommand.AuthorizerService aclCommandService = new AclCommand.AuthorizerService(AclAuthorizer.class.getName(), new AclCommand.AclCommandOptions(args));
        Assertions.assertThrows(IllegalArgumentException.class, () -> aclCommandService.listAcls());
    }

    @Test
    public void testPatternTypes() {
        Function2 & Serializable setExitProcedure_exitProcedure = (Function2 & Serializable)(status, x$13) -> AclCommandTest.$anonfun$testPatternTypes$1(BoxesRunTime.unboxToInt((Object)status), x$13);
        Exit.setExitProcedure((Exit.Procedure)new /* Unavailable Anonymous Inner Class!! */);
        Object var2_1 = null;
        try {
            ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])PatternType.values()), (Function1 & Serializable)patternType -> {
                AclCommandTest.$anonfun$testPatternTypes$3(this, patternType);
                return BoxedUnit.UNIT;
            });
        }
        finally {
            Exit.resetExitProcedure();
        }
    }

    /*
     * WARNING - void declaration
     */
    private void testRemove(String[] cmdArgs, Set<ResourcePattern> resources, String[] resourceCmd) {
        void var6_6;
        void var5_5;
        Tuple2<String, String> tuple2 = this.callMain((String[])ArrayOps$.MODULE$.$colon$plus$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.$colon$plus$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.refArrayOps((Object[])cmdArgs), (Object)resourceCmd, ClassTag$.MODULE$.apply(String.class))), (Object)"--remove", ClassTag$.MODULE$.apply(String.class))), (Object)"--force", ClassTag$.MODULE$.apply(String.class)));
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        String out = (String)tuple2._1();
        String err = (String)tuple2._2();
        Assertions.assertEquals((Object)"", (Object)var5_5);
        Assertions.assertEquals((Object)"", (Object)var6_6);
        resources.foreach((Function1 & Serializable)resource -> {
            AclCommandTest.$anonfun$testRemove$1(this, resource);
            return BoxedUnit.UNIT;
        });
    }

    private Tuple2<Set<AccessControlEntry>, String[]> getAclToCommand(AclPermissionType permissionType, Set<AclOperation> operations) {
        return new Tuple2((Object)AclCommand$.MODULE$.getAcls(this.Users(), permissionType, operations, this.Hosts()), (Object)this.getCmd(permissionType));
    }

    private String[] getCmd(AclPermissionType permissionType) {
        AclPermissionType aclPermissionType = permissionType;
        AclPermissionType aclPermissionType2 = AclPermissionType.ALLOW;
        String principalCmd = !(aclPermissionType != null ? !aclPermissionType.equals(aclPermissionType2) : aclPermissionType2 != null) ? "--allow-principal" : "--deny-principal";
        AclPermissionType aclPermissionType3 = permissionType;
        AclPermissionType aclPermissionType4 = AclPermissionType.ALLOW;
        String[] cmd2 = !(aclPermissionType3 != null ? !aclPermissionType3.equals(aclPermissionType4) : aclPermissionType4 != null) ? this.AllowHostCommand() : this.DenyHostCommand();
        return (String[])this.Users().foldLeft((Object)cmd2, (Function2 & Serializable)(cmd, user) -> (String[])ArrayOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.refArrayOps((Object[])cmd), (Object)new String[]{principalCmd, user.toString()}, ClassTag$.MODULE$.apply(String.class)));
    }

    /*
     * WARNING - void declaration
     */
    private void withAuthorizer(Function1<Authorizer, BoxedUnit> f) {
        void fromProps_doLog;
        KafkaConfig kafkaConfig;
        boolean bl = false;
        Properties fromProps_props = this.brokerProps();
        KafkaConfig kafkaConfig2 = kafkaConfig = new KafkaConfig((Map)fromProps_props, (boolean)fromProps_doLog);
        Object var5_3 = null;
        kafkaConfig = null;
        KafkaConfig kafkaConfig3 = kafkaConfig2;
        try (AclAuthorizer authZ = new AclAuthorizer();){
            authZ.configure(kafkaConfig3.originals());
            f.apply((Object)authZ);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void $anonfun$testAclCli$4(AclCommandTest $this, Set acls$1, ResourcePattern resource) {
        void withAuthorizer_fromProps_doLog;
        KafkaConfig kafkaConfig;
        boolean bl = false;
        Properties withAuthorizer_fromProps_props = $this.brokerProps();
        KafkaConfig kafkaConfig2 = kafkaConfig = new KafkaConfig((Map)withAuthorizer_fromProps_props, (boolean)withAuthorizer_fromProps_doLog);
        Object var6_4 = null;
        kafkaConfig = null;
        KafkaConfig withAuthorizer_kafkaConfig = kafkaConfig2;
        try (AclAuthorizer withAuthorizer_authZ = new AclAuthorizer();){
            withAuthorizer_authZ.configure(withAuthorizer_kafkaConfig.originals());
            TestUtils$.MODULE$.waitAndVerifyAcls((Set<AccessControlEntry>)acls$1, (Authorizer)withAuthorizer_authZ, resource, AccessControlEntryFilter.ANY);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void $anonfun$testAclCli$3(AclCommandTest $this, Set resources$1, String[] cmdArgs$1, String[] resourceCmd$1, AclPermissionType permissionType) {
        void var14_14;
        void var13_13;
        void var7_7;
        void var11_11;
        void var10_10;
        void var8_8;
        Tuple2 operationToCmd = (Tuple2)$this.ResourceToOperations().apply((Object)resources$1);
        Tuple2<Set<AccessControlEntry>, String[]> tuple2 = $this.getAclToCommand(permissionType, (Set<AclOperation>)((Set)operationToCmd._1()));
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        Set acls = (Set)tuple2._1();
        String[] cmd = (String[])tuple2._2();
        Tuple2<String, String> tuple22 = $this.callMain((String[])ArrayOps$.MODULE$.$colon$plus$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.refArrayOps((Object[])cmdArgs$1), (Object)var8_8, ClassTag$.MODULE$.apply(String.class))), (Object)resourceCmd$1, ClassTag$.MODULE$.apply(String.class))), operationToCmd._2(), ClassTag$.MODULE$.apply(String.class))), (Object)"--add", ClassTag$.MODULE$.apply(String.class)));
        if (tuple22 == null) {
            throw new MatchError(null);
        }
        String addOut = (String)tuple22._1();
        String addErr = (String)tuple22._2();
        $this.assertOutputContains("Adding ACLs", (Set<ResourcePattern>)resources$1, resourceCmd$1, (String)var10_10);
        $this.assertOutputContains("Current ACLs", (Set<ResourcePattern>)resources$1, resourceCmd$1, (String)var10_10);
        Assertions.assertEquals((Object)"", (Object)var11_11);
        resources$1.foreach(arg_0 -> AclCommandTest.$anonfun$testAclCli$4$adapted($this, (Set)var7_7, arg_0));
        Tuple2<String, String> tuple23 = $this.callMain((String[])ArrayOps$.MODULE$.$colon$plus$extension(Predef$.MODULE$.refArrayOps((Object[])cmdArgs$1), (Object)"--list", ClassTag$.MODULE$.apply(String.class)));
        if (tuple23 == null) {
            throw new MatchError(null);
        }
        String listOut = (String)tuple23._1();
        String listErr = (String)tuple23._2();
        $this.assertOutputContains("Current ACLs", (Set<ResourcePattern>)resources$1, resourceCmd$1, (String)var13_13);
        Assertions.assertEquals((Object)"", (Object)var14_14);
        $this.testRemove(cmdArgs$1, (Set<ResourcePattern>)resources$1, resourceCmd$1);
    }

    public static final /* synthetic */ void $anonfun$testAclCli$2(AclCommandTest $this, String[] cmdArgs$1, Tuple2 x$7) {
        if (x$7 != null) {
            Set resources = (Set)x$7._1();
            String[] resourceCmd = (String[])x$7._2();
            ((IterableOnceOps)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AclPermissionType[]{AclPermissionType.ALLOW, AclPermissionType.DENY}))).foreach((Function1 & Serializable)permissionType -> {
                AclCommandTest.$anonfun$testAclCli$3($this, resources, cmdArgs$1, resourceCmd, permissionType);
                return BoxedUnit.UNIT;
            });
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ boolean $anonfun$assertOutputContains$2(String x$8) {
        return !x$8.startsWith("--");
    }

    public static final /* synthetic */ void $anonfun$assertOutputContains$3(String prefix$1, String resourceType$1, String output$1, String name) {
        String expected = new StringBuilder(75).append(prefix$1).append(" for resource `ResourcePattern(resourceType=").append(resourceType$1).append(", name=").append(name).append(", patternType=LITERAL)`:").toString();
        Assertions.assertTrue((boolean)output$1.contains(expected), (String)new StringBuilder(26).append("Substring ").append(expected).append(" not in output:\n").append(output$1).toString());
    }

    public static final /* synthetic */ void $anonfun$assertOutputContains$1(AclCommandTest $this, String[] resourceCmd$2, String prefix$1, String output$1, ResourcePattern resource) {
        Object[] objectArray;
        String resourceType = resource.resourceType().toString();
        if (resource.equals($this.ClusterResource())) {
            String[] stringArray = new String[1];
            objectArray = stringArray;
            stringArray[0] = "kafka-cluster";
        } else {
            objectArray = (Object[])ArrayOps$.MODULE$.filter$extension(Predef$.MODULE$.refArrayOps((Object[])resourceCmd$2), (Function1 & Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)AclCommandTest.$anonfun$assertOutputContains$2(x$8)));
        }
        ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps(objectArray), (Function1 & Serializable)name -> {
            AclCommandTest.$anonfun$assertOutputContains$3(prefix$1, resourceType, output$1, name);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ boolean $anonfun$testAclCliWithClientId$1(LoggingEvent e) {
        Level level = e.getLevel();
        Level level2 = Level.WARN;
        if (!(level != null ? !level.equals(level2) : level2 != null) && e.getThrowableInformation() != null) {
            String string = e.getThrowableInformation().getThrowable().getClass().getName();
            String string2 = InstanceAlreadyExistsException.class.getName();
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void $anonfun$testProducerConsumerCli$6(AclCommandTest $this, Set acls$2, ResourcePattern resource) {
        void withAuthorizer_fromProps_doLog;
        KafkaConfig kafkaConfig;
        boolean bl = false;
        Properties withAuthorizer_fromProps_props = $this.brokerProps();
        KafkaConfig kafkaConfig2 = kafkaConfig = new KafkaConfig((Map)withAuthorizer_fromProps_props, (boolean)withAuthorizer_fromProps_doLog);
        Object var6_4 = null;
        kafkaConfig = null;
        KafkaConfig withAuthorizer_kafkaConfig = kafkaConfig2;
        try (AclAuthorizer withAuthorizer_authZ = new AclAuthorizer();){
            withAuthorizer_authZ.configure(withAuthorizer_kafkaConfig.originals());
            TestUtils$.MODULE$.waitAndVerifyAcls((Set<AccessControlEntry>)acls$2, (Authorizer)withAuthorizer_authZ, resource, AccessControlEntryFilter.ANY);
        }
    }

    public static final /* synthetic */ void $anonfun$testProducerConsumerCli$5(AclCommandTest $this, Tuple2 x$11) {
        if (x$11 != null) {
            Set resources = (Set)x$11._1();
            Set acls = (Set)x$11._2();
            resources.foreach((Function1 & Serializable)resource -> {
                AclCommandTest.$anonfun$testProducerConsumerCli$6($this, acls, resource);
                return BoxedUnit.UNIT;
            });
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ void $anonfun$testProducerConsumerCli$2(AclCommandTest $this, String[] cmdArgs$2, Tuple2 x$12) {
        if (x$12 != null) {
            String[] cmd = (String[])x$12._1();
            scala.collection.immutable.Map resourcesToAcls = (scala.collection.immutable.Map)x$12._2();
            Object[] resourceCommand = (String[])((IterableOnceOps)resourcesToAcls.keys().map($this.ResourceToCommand())).foldLeft(Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(String.class)), (Function2 & Serializable)(x$9, x$10) -> (String[])ArrayOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.refArrayOps((Object[])x$9), x$10, ClassTag$.MODULE$.apply(String.class)));
            $this.callMain((String[])ArrayOps$.MODULE$.$colon$plus$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.refArrayOps((Object[])cmdArgs$2), (Object)$this.getCmd(AclPermissionType.ALLOW), ClassTag$.MODULE$.apply(String.class))), (Object)resourceCommand, ClassTag$.MODULE$.apply(String.class))), (Object)cmd, ClassTag$.MODULE$.apply(String.class))), (Object)"--add", ClassTag$.MODULE$.apply(String.class)));
            resourcesToAcls.withFilter((Function1 & Serializable)check$ifrefutable$3 -> BoxesRunTime.boxToBoolean((boolean)(bl = check$ifrefutable$3 != null))).foreach((Function1 & Serializable)x$11 -> {
                AclCommandTest.$anonfun$testProducerConsumerCli$5($this, x$11);
                return BoxedUnit.UNIT;
            });
            $this.testRemove(cmdArgs$2, (Set<ResourcePattern>)((IterableOnceOps)resourcesToAcls.keys().flatten(Predef$.MODULE$.$conforms())).toSet(), (String[])ArrayOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.refArrayOps(resourceCommand), (Object)cmd, ClassTag$.MODULE$.apply(String.class)));
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ void $anonfun$testAclsOnPrefixedResources$1(AclCommandTest $this, Authorizer authorizer) {
        AccessControlEntry writeAcl = new AccessControlEntry($this.principal().toString(), AclEntry$.MODULE$.WildcardHost(), AclOperation.WRITE, AclPermissionType.ALLOW);
        AccessControlEntry describeAcl = new AccessControlEntry($this.principal().toString(), AclEntry$.MODULE$.WildcardHost(), AclOperation.DESCRIBE, AclPermissionType.ALLOW);
        AccessControlEntry createAcl = new AccessControlEntry($this.principal().toString(), AclEntry$.MODULE$.WildcardHost(), AclOperation.CREATE, AclPermissionType.ALLOW);
        TestUtils$.MODULE$.waitAndVerifyAcls((Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{writeAcl, describeAcl, createAcl}))), authorizer, new ResourcePattern(ResourceType.TOPIC, "Test-", PatternType.PREFIXED), AccessControlEntryFilter.ANY);
    }

    public static final /* synthetic */ void $anonfun$testAclsOnPrefixedResources$2(Authorizer authorizer) {
        TestUtils$.MODULE$.waitAndVerifyAcls((Set<AccessControlEntry>)Predef$.MODULE$.Set().empty(), authorizer, new ResourcePattern(ResourceType.CLUSTER, "kafka-cluster", PatternType.LITERAL), AccessControlEntryFilter.ANY);
        TestUtils$.MODULE$.waitAndVerifyAcls((Set<AccessControlEntry>)Predef$.MODULE$.Set().empty(), authorizer, new ResourcePattern(ResourceType.TOPIC, "Test-", PatternType.PREFIXED), AccessControlEntryFilter.ANY);
    }

    public static final /* synthetic */ Nothing$ $anonfun$testPatternTypes$1(int status, Option x$13) {
        if (status == 1) {
            throw new RuntimeException("Exiting command");
        }
        throw new AssertionError((Object)new StringBuilder(28).append("Unexpected exit with status ").append(status).toString());
    }

    private final void verifyPatternType$1(String[] cmd, boolean isValid) {
        if (isValid) {
            this.callMain(cmd);
            return;
        }
        Assertions.assertThrows(RuntimeException.class, () -> this.callMain(cmd));
    }

    public static final /* synthetic */ void $anonfun$testPatternTypes$3(AclCommandTest $this, PatternType patternType) {
        String[] addCmd = (String[])ArrayOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.refArrayOps((Object[])$this.zkArgs()), (Object)new String[]{"--allow-principal", $this.principal().toString(), "--producer", "--topic", "Test", "--add", "--resource-pattern-type", patternType.toString()}, ClassTag$.MODULE$.apply(String.class));
        $this.verifyPatternType$1(addCmd, patternType.isSpecific());
        String[] listCmd = (String[])ArrayOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.refArrayOps((Object[])$this.zkArgs()), (Object)new String[]{"--topic", "Test", "--list", "--resource-pattern-type", patternType.toString()}, ClassTag$.MODULE$.apply(String.class));
        $this.verifyPatternType$1(listCmd, !patternType.equals(PatternType.UNKNOWN));
        String[] removeCmd = (String[])ArrayOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.refArrayOps((Object[])$this.zkArgs()), (Object)new String[]{"--topic", "Test", "--force", "--remove", "--resource-pattern-type", patternType.toString()}, ClassTag$.MODULE$.apply(String.class));
        $this.verifyPatternType$1(removeCmd, !patternType.equals(PatternType.UNKNOWN));
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void $anonfun$testRemove$1(AclCommandTest $this, ResourcePattern resource) {
        void withAuthorizer_fromProps_doLog;
        KafkaConfig kafkaConfig;
        boolean bl = false;
        Properties withAuthorizer_fromProps_props = $this.brokerProps();
        KafkaConfig kafkaConfig2 = kafkaConfig = new KafkaConfig((Map)withAuthorizer_fromProps_props, (boolean)withAuthorizer_fromProps_doLog);
        Object var5_3 = null;
        kafkaConfig = null;
        KafkaConfig withAuthorizer_kafkaConfig = kafkaConfig2;
        try (AclAuthorizer withAuthorizer_authZ = new AclAuthorizer();){
            withAuthorizer_authZ.configure(withAuthorizer_kafkaConfig.originals());
            TestUtils$.MODULE$.waitAndVerifyAcls((Set<AccessControlEntry>)Predef$.MODULE$.Set().empty(), (Authorizer)withAuthorizer_authZ, resource, AccessControlEntryFilter.ANY);
        }
    }

    public static final /* synthetic */ Object $anonfun$testAclsOnPrefixedResources$1$adapted(AclCommandTest $this, Authorizer authorizer) {
        AclCommandTest.$anonfun$testAclsOnPrefixedResources$1($this, authorizer);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testAclsOnPrefixedResources$2$adapted(Authorizer authorizer) {
        AclCommandTest.$anonfun$testAclsOnPrefixedResources$2(authorizer);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testAclCli$5$adapted(Set acls$1, ResourcePattern resource$1, Authorizer authorizer) {
        TestUtils$.MODULE$.waitAndVerifyAcls((Set<AccessControlEntry>)acls$1, authorizer, resource$1, AccessControlEntryFilter.ANY);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testAclCli$4$adapted(AclCommandTest $this, Set acls$1, ResourcePattern resource) {
        AclCommandTest.$anonfun$testAclCli$4($this, acls$1, resource);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testProducerConsumerCli$7$adapted(Set acls$2, ResourcePattern resource$2, Authorizer authorizer) {
        TestUtils$.MODULE$.waitAndVerifyAcls((Set<AccessControlEntry>)acls$2, authorizer, resource$2, AccessControlEntryFilter.ANY);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testRemove$2$adapted(ResourcePattern resource$3, Authorizer authorizer) {
        TestUtils$.MODULE$.waitAndVerifyAcls((Set<AccessControlEntry>)Predef$.MODULE$.Set().empty(), authorizer, resource$3, AccessControlEntryFilter.ANY);
        return BoxedUnit.UNIT;
    }
}

