/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.File;
import java.io.Serializable;
import java.time.Duration;
import java.util.Collections;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import kafka.api.IntegrationTestHarness;
import kafka.cluster.Partition;
import kafka.controller.OfflineReplica$;
import kafka.controller.PartitionAndReplica;
import kafka.controller.ReplicaState;
import kafka.server.KafkaBroker;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.server.ReplicaFetcherThread;
import kafka.utils.CoreUtils$;
import kafka.utils.Logging;
import kafka.utils.TestUtils;
import kafka.utils.TestUtils$;
import kafka.utils.TestUtils$Checkpoint$;
import kafka.utils.TestUtils$Roll$;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.common.PartitionInfo;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.KafkaStorageException;
import org.apache.kafka.common.errors.NotLeaderOrFollowerException;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.Exit;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;
import org.slf4j.event.Level;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.ArrayOps$;
import scala.collection.Seq;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.RichInt$;
import scala.runtime.RichLong$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.VolatileObjectRef;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\u0005ub\u0001\u0002\r\u001a\u0001yAQ!\n\u0001\u0005\u0002\u0019Bq!\u000b\u0001C\u0002\u0013\u0005!\u0006\u0003\u00042\u0001\u0001\u0006Ia\u000b\u0005\be\u0001\u0011\r\u0011\"\u0001+\u0011\u0019\u0019\u0004\u0001)A\u0005W!9A\u0007\u0001b\u0001\n\u0003Q\u0003BB\u001b\u0001A\u0003%1\u0006C\u00047\u0001\t\u0007I\u0011B\u001c\t\r\u0001\u0003\u0001\u0015!\u00039\u0011\u001d\t\u0005A1A\u0005\n)BaA\u0011\u0001!\u0002\u0013Y\u0003bB\"\u0001\u0005\u0004%\tE\u000b\u0005\u0007\t\u0002\u0001\u000b\u0011B\u0016\t\u000b\u0015\u0003A\u0011\t$\t\u000bm\u0003A\u0011\u0001/\t\u000b\u0005\u0004A\u0011\u0001/\t\u000b\r\u0004A\u0011\u0001/\t\u000b\u0015\u0004A\u0011\u0001/\t\u000b\u001d\u0004A\u0011\u0001/\t\u000b%\u0004A\u0011\u0001/\t\u000b-\u0004A\u0011\u00017\t\r}\u0004A\u0011AA\u0001\u0011\u001d\t)\u0001\u0001C\u0005\u0003\u000f\u0011\u0011\u0003T8h\t&\u0014h)Y5mkJ,G+Z:u\u0015\tQ2$\u0001\u0004tKJ4XM\u001d\u0006\u00029\u0005)1.\u00194lC\u000e\u00011C\u0001\u0001 !\t\u00013%D\u0001\"\u0015\t\u00113$A\u0002ba&L!\u0001J\u0011\u0003-%sG/Z4sCRLwN\u001c+fgRD\u0015M\u001d8fgN\fa\u0001P5oSRtD#A\u0014\u0011\u0005!\u0002Q\"A\r\u0002\u001bA\u0014x\u000eZ;dKJ\u001cu.\u001e8u+\u0005Y\u0003C\u0001\u00170\u001b\u0005i#\"\u0001\u0018\u0002\u000bM\u001c\u0017\r\\1\n\u0005Aj#aA%oi\u0006q\u0001O]8ek\u000e,'oQ8v]R\u0004\u0013!D2p]N,X.\u001a:D_VtG/\u0001\bd_:\u001cX/\\3s\u0007>,h\u000e\u001e\u0011\u0002\u0017\t\u0014xn[3s\u0007>,h\u000e^\u0001\rEJ|7.\u001a:D_VtG\u000fI\u0001\u0006i>\u0004\u0018nY\u000b\u0002qA\u0011\u0011HP\u0007\u0002u)\u00111\bP\u0001\u0005Y\u0006twMC\u0001>\u0003\u0011Q\u0017M^1\n\u0005}R$AB*ue&tw-\u0001\u0004u_BL7\rI\u0001\ra\u0006\u0014H/\u001b;j_:tU/\\\u0001\u000ea\u0006\u0014H/\u001b;j_:tU/\u001c\u0011\u0002\u00171|w\rR5s\u0007>,h\u000e^\u0001\rY><G)\u001b:D_VtG\u000fI\u0001\u0006g\u0016$X\u000b\u001d\u000b\u0003\u000f*\u0003\"\u0001\f%\n\u0005%k#\u0001B+oSRDQa\u0013\bA\u00021\u000b\u0001\u0002^3ti&sgm\u001c\t\u0003\u001bVk\u0011A\u0014\u0006\u0003E=S!\u0001U)\u0002\u000f),\b/\u001b;fe*\u0011!kU\u0001\u0006UVt\u0017\u000e\u001e\u0006\u0002)\u0006\u0019qN]4\n\u0005Ys%\u0001\u0003+fgRLeNZ8)\u00059A\u0006CA'Z\u0013\tQfJ\u0001\u0006CK\u001a|'/Z#bG\"\fA\u0005^3tiB\u0013x\u000eZ;dK\u0016\u0013(o\u001c:Ge>lg)Y5mkJ,wJ\u001c'pOJ{G\u000e\u001c\u000b\u0002\u000f\"\u0012qB\u0018\t\u0003\u001b~K!\u0001\u0019(\u0003\tQ+7\u000f^\u0001\u001di\u0016\u001cH/S(Fq\u000e,\u0007\u000f^5p]\u0012+(/\u001b8h\u0019><'k\u001c7mQ\t\u0001b,A\u001dce>\\WM],ji\"|E\u000eZ%oi\u0016\u0014(I]8lKJ\u0004&o\u001c;pG>d7\u000b[8vY\u0012D\u0015\r\u001c;P]2{w\rR5s\r\u0006LG.\u001e:fQ\t\tb,A\u0014uKN$\bK]8ek\u000e,WI\u001d:pe\u001a\u0013x.\u001c$bS2,(/Z(o\u0007\",7m\u001b9pS:$\bF\u0001\n_\u0003}!Xm\u001d;J\u001f\u0016C8-\u001a9uS>tG)\u001e:j]\u001e\u001c\u0005.Z2la>Lg\u000e\u001e\u0015\u0003'y\u000bA\u0007^3tiJ+\u0007\u000f\\5dC\u001a+Go\u00195feRC'/Z1e\u0003\u001a$XM\u001d'pO\u0012K'OR1jYV\u0014Xm\u00148G_2dwn^3sQ\t!b,\u0001\u0016uKN$\bK]8ek\u000e,WI\u001d:peN4%o\\7M_\u001e$\u0015N\u001d$bS2,(/Z(o\u0019\u0016\fG-\u001a:\u0015\u0005\u001dk\u0007\"\u00028\u0016\u0001\u0004y\u0017a\u00034bS2,(/\u001a+za\u0016\u0004\"\u0001\u001d?\u000f\u0005ELhB\u0001:x\u001d\t\u0019h/D\u0001u\u0015\t)X$\u0001\u0004=e>|GOP\u0005\u00029%\u0011\u0001pG\u0001\u0006kRLGn]\u0005\u0003un\f\u0011\u0002V3tiV#\u0018\u000e\\:\u000b\u0005a\\\u0012BA?\u007f\u0005Eaun\u001a#je\u001a\u000b\u0017\u000e\\;sKRK\b/\u001a\u0006\u0003un\fQ\u0005^3tiB\u0013x\u000eZ;dK\u00063G/\u001a:M_\u001e$\u0015N\u001d$bS2,(/Z(o\u0019\u0016\fG-\u001a:\u0015\u0007\u001d\u000b\u0019\u0001C\u0003o-\u0001\u0007q.A\u000ftk\n\u001c8M]5cK\u0006sGmV1ji\u001a{'/Q:tS\u001etW.\u001a8u)\u00159\u0015\u0011BA\r\u0011\u00191t\u00031\u0001\u0002\fA!\u0011QBA\u000b\u001d\u0011\ty!!\u0005\u0011\u0005Ml\u0013bAA\n[\u00051\u0001K]3eK\u001aL1aPA\f\u0015\r\t\u0019\"\f\u0005\b\u000379\u0002\u0019AA\u000f\u0003!\u0019wN\\:v[\u0016\u0014\b\u0003CA\u0010\u0003[\t\t$!\r\u000e\u0005\u0005\u0005\"\u0002BA\u000e\u0003GQA!!\n\u0002(\u000591\r\\5f]R\u001c(b\u0001\u000f\u0002*)\u0019\u00111F*\u0002\r\u0005\u0004\u0018m\u00195f\u0013\u0011\ty#!\t\u0003\u001b-\u000bgm[1D_:\u001cX/\\3s!\u0015a\u00131GA\u001c\u0013\r\t)$\f\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u0004Y\u0005e\u0012bAA\u001e[\t!!)\u001f;f\u0001")
public class LogDirFailureTest
extends IntegrationTestHarness {
    private final int producerCount;
    private final int consumerCount;
    private final int brokerCount;
    private final String topic;
    private final int partitionNum;
    private final int logDirCount;

    public int producerCount() {
        return this.producerCount;
    }

    public int consumerCount() {
        return this.consumerCount;
    }

    @Override
    public int brokerCount() {
        return this.brokerCount;
    }

    private String topic() {
        return this.topic;
    }

    private int partitionNum() {
        return this.partitionNum;
    }

    @Override
    public int logDirCount() {
        return this.logDirCount;
    }

    @Override
    @BeforeEach
    public void setUp(TestInfo testInfo) {
        super.setUp(testInfo);
        this.createTopic(this.topic(), this.partitionNum(), this.brokerCount(), this.createTopic$default$4(), this.createTopic$default$5());
    }

    @Test
    public void testProduceErrorFromFailureOnLogRoll() {
        this.testProduceErrorsFromLogDirFailureOnLeader(TestUtils$Roll$.MODULE$);
    }

    @Test
    public void testIOExceptionDuringLogRoll() {
        this.testProduceAfterLogDirFailureOnLeader(TestUtils$Roll$.MODULE$);
    }

    @Test
    public void brokerWithOldInterBrokerProtocolShouldHaltOnLogDirFailure() {
        VolatileObjectRef statusCodeOption = VolatileObjectRef.create((Object)None$.MODULE$);
        Function2 & Serializable setHaltProcedure_haltProcedure = (Function2 & Serializable)(statusCode, x$1) -> LogDirFailureTest.$anonfun$brokerWithOldInterBrokerProtocolShouldHaltOnLogDirFailure$1(statusCodeOption, BoxesRunTime.unboxToInt((Object)statusCode), x$1);
        Exit.setHaltProcedure((Exit.Procedure)new /* Unavailable Anonymous Inner Class!! */);
        Object var13_2 = null;
        KafkaServer server = null;
        try {
            None$ none$;
            None$ none$2;
            None$ none$3;
            None$ none$4;
            int x$12 = this.brokerCount();
            String x$2 = this.zkConnect();
            boolean bl = true;
            boolean bl2 = true;
            int n = TestUtils$.MODULE$.RandomPort();
            None$ none$5 = none$4 = None$.MODULE$;
            none$4 = null;
            None$ x$7 = none$5;
            None$ none$6 = none$3 = None$.MODULE$;
            none$3 = null;
            None$ x$8 = none$6;
            None$ none$7 = none$2 = None$.MODULE$;
            none$2 = null;
            None$ x$9 = none$7;
            boolean bl3 = true;
            boolean bl4 = false;
            int n2 = TestUtils$.MODULE$.RandomPort();
            boolean bl5 = false;
            int n3 = TestUtils$.MODULE$.RandomPort();
            boolean bl6 = false;
            int n4 = TestUtils$.MODULE$.RandomPort();
            None$ none$8 = none$ = None$.MODULE$;
            none$ = null;
            None$ x$17 = none$8;
            boolean bl7 = false;
            int n5 = 1;
            short s = 1;
            Properties props = TestUtils$.MODULE$.createBrokerConfig(x$12, x$2, bl, bl2, n, (Option<SecurityProtocol>)x$7, (Option<File>)x$8, (Option<Properties>)x$9, bl3, bl4, n2, bl5, n3, bl6, n4, (Option<String>)x$17, 3, bl7, n5, s);
            props.put(KafkaConfig$.MODULE$.InterBrokerProtocolVersionProp(), "0.11.0");
            props.put(KafkaConfig$.MODULE$.LogMessageFormatVersionProp(), "0.11.0");
            KafkaConfig kafkaConfig = KafkaConfig$.MODULE$.fromProps(props);
            File logDir = new File((String)kafkaConfig.logDirs().head());
            CoreUtils$.MODULE$.swallow((Function0)(JFunction0.mcV.sp & Serializable)() -> Utils.delete((File)logDir), (Logging)this, Level.WARN);
            logDir.createNewFile();
            Assertions.assertTrue((boolean)logDir.isFile());
            server = TestUtils$.MODULE$.createServer(kafkaConfig, Time.SYSTEM);
            long l = 15000L;
            long l2 = 100L;
            long waitUntilTrue_startTime = System.currentTimeMillis();
            while (!((Option)statusCodeOption.elem).contains((Object)BoxesRunTime.boxToInteger((int)1))) {
                if (System.currentTimeMillis() > waitUntilTrue_startTime + l) {
                    Assertions.fail((String)"timed out waiting for broker to halt");
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(l), l2));
            }
        }
        catch (Throwable throwable) {
            Exit.resetHaltProcedure();
            if (server != null) {
                TestUtils$.MODULE$.shutdownServers((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new KafkaServer[]{server})));
            }
            throw throwable;
        }
        Exit.resetHaltProcedure();
        if (server != null) {
            TestUtils$.MODULE$.shutdownServers((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new KafkaServer[]{server})));
        }
    }

    @Test
    public void testProduceErrorFromFailureOnCheckpoint() {
        this.testProduceErrorsFromLogDirFailureOnLeader(TestUtils$Checkpoint$.MODULE$);
    }

    @Test
    public void testIOExceptionDuringCheckpoint() {
        this.testProduceAfterLogDirFailureOnLeader(TestUtils$Checkpoint$.MODULE$);
    }

    @Test
    public void testReplicaFetcherThreadAfterLogDirFailureOnFollower() {
        this.producerConfig().setProperty("retries", "0");
        this.producerConfig().setProperty("enable.idempotence", "false");
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        TopicPartition partition = new TopicPartition(this.topic(), 0);
        PartitionInfo partitionInfo = (PartitionInfo)CollectionConverters$.MODULE$.ListHasAsScala(producer.partitionsFor(this.topic())).asScala().find((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)LogDirFailureTest.$anonfun$testReplicaFetcherThreadAfterLogDirFailureOnFollower$1(x$2))).get();
        int leaderServerId = partitionInfo.leader().id();
        KafkaServer leaderServer = (KafkaServer)this.servers().find((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)LogDirFailureTest.$anonfun$testReplicaFetcherThreadAfterLogDirFailureOnFollower$2(leaderServerId, x$3))).get();
        int followerServerId = BoxesRunTime.unboxToInt((Object)ArrayOps$.MODULE$.find$extension(Predef$.MODULE$.intArrayOps((int[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])partitionInfo.replicas()), (Function1 & Serializable)x$4 -> BoxesRunTime.boxToInteger((int)x$4.id()), (ClassTag)ClassTag$.MODULE$.Int())), (Function1)(JFunction1.mcZI.sp & Serializable)x$5 -> x$5 != leaderServerId).get());
        KafkaServer followerServer = (KafkaServer)this.servers().find((Function1 & Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)LogDirFailureTest.$anonfun$testReplicaFetcherThreadAfterLogDirFailureOnFollower$5(followerServerId, x$6))).get();
        followerServer.replicaManager().markPartitionOffline(partition);
        int anotherPartitionWithTheSameLeader = BoxesRunTime.unboxToInt((Object)RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(1), this.partitionNum()).find((Function1)(JFunction1.mcZI.sp & Serializable)i -> leaderServer.replicaManager().onlinePartition(new TopicPartition(this.topic(), i)).flatMap((Function1 & Serializable)x$7 -> x$7.leaderLogIfLocal()).isDefined()).get());
        ProducerRecord record = new ProducerRecord(this.topic(), Predef$.MODULE$.int2Integer(anotherPartitionWithTheSameLeader), (Object)this.topic().getBytes(), (Object)"message".getBytes());
        producer.send(record).get();
        Assertions.assertEquals((int)this.brokerCount(), (int)((Partition)leaderServer.replicaManager().onlinePartition(new TopicPartition(this.topic(), anotherPartitionWithTheSameLeader)).get()).inSyncReplicaIds().size());
        followerServer.replicaManager().replicaFetcherManager().fetcherThreadMap().values().foreach((Function1 & Serializable)thread -> {
            LogDirFailureTest.$anonfun$testReplicaFetcherThreadAfterLogDirFailureOnFollower$8(thread);
            return BoxedUnit.UNIT;
        });
    }

    public void testProduceErrorsFromLogDirFailureOnLeader(TestUtils.LogDirFailureType failureType) {
        this.producerConfig().setProperty("retries", "0");
        this.producerConfig().setProperty("enable.idempotence", "false");
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        TopicPartition partition = new TopicPartition(this.topic(), 0);
        ProducerRecord record = new ProducerRecord(this.topic(), Predef$.MODULE$.int2Integer(0), (Object)"key".getBytes(), (Object)"value".getBytes());
        int leaderServerId = ((PartitionInfo)CollectionConverters$.MODULE$.ListHasAsScala(producer.partitionsFor(this.topic())).asScala().find((Function1 & Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)LogDirFailureTest.$anonfun$testProduceErrorsFromLogDirFailureOnLeader$1(x$8))).get()).leader().id();
        KafkaServer leaderServer = (KafkaServer)this.servers().find((Function1 & Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)LogDirFailureTest.$anonfun$testProduceErrorsFromLogDirFailureOnLeader$2(leaderServerId, x$9))).get();
        TestUtils$.MODULE$.causeLogDirFailure(failureType, (KafkaBroker)leaderServer, partition);
        ExecutionException e = (ExecutionException)Assertions.assertThrows(ExecutionException.class, () -> producer.send(record).get(6000L, TimeUnit.MILLISECONDS));
        Assertions.assertTrue((e.getCause() instanceof KafkaStorageException || e.getCause() instanceof NotLeaderOrFollowerException ? 1 : 0) != 0);
    }

    public void testProduceAfterLogDirFailureOnLeader(TestUtils.LogDirFailureType failureType) {
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        this.subscribeAndWaitForAssignment(this.topic(), consumer);
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        TopicPartition partition = new TopicPartition(this.topic(), 0);
        ProducerRecord record = new ProducerRecord(this.topic(), Predef$.MODULE$.int2Integer(0), (Object)"key".getBytes(), (Object)"value".getBytes());
        int leaderServerId = ((PartitionInfo)CollectionConverters$.MODULE$.ListHasAsScala(producer.partitionsFor(this.topic())).asScala().find((Function1 & Serializable)x$10 -> BoxesRunTime.boxToBoolean((boolean)LogDirFailureTest.$anonfun$testProduceAfterLogDirFailureOnLeader$1(x$10))).get()).leader().id();
        KafkaServer leaderServer = (KafkaServer)this.servers().find((Function1 & Serializable)x$11 -> BoxesRunTime.boxToBoolean((boolean)LogDirFailureTest.$anonfun$testProduceAfterLogDirFailureOnLeader$2(leaderServerId, x$11))).get();
        producer.send(record).get();
        TestUtils$.MODULE$.consumeRecords(consumer, 1, 15000L);
        TestUtils$.MODULE$.causeLogDirFailure(failureType, (KafkaBroker)leaderServer, partition);
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 6000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!LogDirFailureTest.$anonfun$testProduceAfterLogDirFailureOnLeader$3(this, producer, record, leaderServerId)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"Expected new leader for the partition");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), l));
        }
        producer.send(record).get(6000L, TimeUnit.MILLISECONDS);
        TestUtils$.MODULE$.pollUntilAtLeastNumRecords(consumer, 1, 15000L);
        Assertions.assertTrue((boolean)this.zkClient().getAllLogDirEventNotifications().isEmpty());
        Assertions.assertTrue((boolean)((KafkaServer)this.servers().find((Function1 & Serializable)x$13 -> BoxesRunTime.boxToBoolean((boolean)LogDirFailureTest.$anonfun$testProduceAfterLogDirFailureOnLeader$6(x$13))).get()).kafkaController().controllerContext().replicasInState(this.topic(), (ReplicaState)OfflineReplica$.MODULE$).contains((Object)new PartitionAndReplica(new TopicPartition(this.topic(), 0), leaderServerId)));
    }

    private void subscribeAndWaitForAssignment(String topic, KafkaConsumer<byte[], byte[]> consumer) {
        consumer.subscribe(Collections.singletonList(topic));
        long l = 15000L;
        long pollUntilTrue_waitUntilTrue_pause = 0L;
        long pollUntilTrue_waitUntilTrue_startTime = System.currentTimeMillis();
        while (true) {
            consumer.poll(Duration.ofMillis(100L));
            if (LogDirFailureTest.$anonfun$subscribeAndWaitForAssignment$1(consumer)) break;
            if (System.currentTimeMillis() > pollUntilTrue_waitUntilTrue_startTime + l) {
                Assertions.fail((String)"Expected non-empty assignment");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(l), pollUntilTrue_waitUntilTrue_pause));
        }
    }

    public static final /* synthetic */ Nothing$ $anonfun$brokerWithOldInterBrokerProtocolShouldHaltOnLogDirFailure$1(VolatileObjectRef statusCodeOption$1, int statusCode, Option x$1) {
        statusCodeOption$1.elem = new Some((Object)BoxesRunTime.boxToInteger((int)statusCode));
        throw new IllegalArgumentException();
    }

    public static final /* synthetic */ boolean $anonfun$brokerWithOldInterBrokerProtocolShouldHaltOnLogDirFailure$3(VolatileObjectRef statusCodeOption$1) {
        return ((Option)statusCodeOption$1.elem).contains((Object)BoxesRunTime.boxToInteger((int)1));
    }

    public static final /* synthetic */ String $anonfun$brokerWithOldInterBrokerProtocolShouldHaltOnLogDirFailure$4() {
        return "timed out waiting for broker to halt";
    }

    public static final /* synthetic */ boolean $anonfun$testReplicaFetcherThreadAfterLogDirFailureOnFollower$1(PartitionInfo x$2) {
        return x$2.partition() == 0;
    }

    public static final /* synthetic */ boolean $anonfun$testReplicaFetcherThreadAfterLogDirFailureOnFollower$2(int leaderServerId$1, KafkaServer x$3) {
        return x$3.config().brokerId() == leaderServerId$1;
    }

    public static final /* synthetic */ boolean $anonfun$testReplicaFetcherThreadAfterLogDirFailureOnFollower$5(int followerServerId$1, KafkaServer x$6) {
        return x$6.config().brokerId() == followerServerId$1;
    }

    public static final /* synthetic */ void $anonfun$testReplicaFetcherThreadAfterLogDirFailureOnFollower$8(ReplicaFetcherThread thread) {
        Assertions.assertFalse((boolean)thread.isShutdownComplete(), (String)"ReplicaFetcherThread should still be working if its partition count > 0");
    }

    public static final /* synthetic */ boolean $anonfun$testProduceErrorsFromLogDirFailureOnLeader$1(PartitionInfo x$8) {
        return x$8.partition() == 0;
    }

    public static final /* synthetic */ boolean $anonfun$testProduceErrorsFromLogDirFailureOnLeader$2(int leaderServerId$2, KafkaServer x$9) {
        return x$9.config().brokerId() == leaderServerId$2;
    }

    public static final /* synthetic */ boolean $anonfun$testProduceAfterLogDirFailureOnLeader$1(PartitionInfo x$10) {
        return x$10.partition() == 0;
    }

    public static final /* synthetic */ boolean $anonfun$testProduceAfterLogDirFailureOnLeader$2(int leaderServerId$3, KafkaServer x$11) {
        return x$11.config().brokerId() == leaderServerId$3;
    }

    public static final /* synthetic */ boolean $anonfun$testProduceAfterLogDirFailureOnLeader$4(PartitionInfo x$12) {
        return x$12.partition() == 0;
    }

    public static final /* synthetic */ boolean $anonfun$testProduceAfterLogDirFailureOnLeader$3(LogDirFailureTest $this, KafkaProducer producer$2, ProducerRecord record$2, int leaderServerId$3) {
        producer$2.send(record$2);
        return ((PartitionInfo)CollectionConverters$.MODULE$.ListHasAsScala(producer$2.partitionsFor($this.topic())).asScala().find((Function1 & Serializable)x$12 -> BoxesRunTime.boxToBoolean((boolean)LogDirFailureTest.$anonfun$testProduceAfterLogDirFailureOnLeader$4(x$12))).get()).leader().id() != leaderServerId$3;
    }

    public static final /* synthetic */ String $anonfun$testProduceAfterLogDirFailureOnLeader$5() {
        return "Expected new leader for the partition";
    }

    public static final /* synthetic */ boolean $anonfun$testProduceAfterLogDirFailureOnLeader$6(KafkaServer x$13) {
        return x$13.kafkaController().isActive();
    }

    public static final /* synthetic */ boolean $anonfun$subscribeAndWaitForAssignment$1(KafkaConsumer consumer$1) {
        return !consumer$1.assignment().isEmpty();
    }

    public static final /* synthetic */ String $anonfun$subscribeAndWaitForAssignment$2() {
        return "Expected non-empty assignment";
    }

    public LogDirFailureTest() {
        this.producerCount = 1;
        this.consumerCount = 1;
        this.brokerCount = 2;
        this.topic = "topic";
        this.partitionNum = 12;
        this.logDirCount = 3;
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.ReplicaHighWatermarkCheckpointIntervalMsProp(), "60000");
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.NumReplicaFetchersProp(), "1");
    }
}

