/*
 * Decompiled with CFR 0.152.
 */
package kafka.admin;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.concurrent.ExecutionException;
import kafka.admin.MetadataQuorumCommand$;
import kafka.test.ClusterInstance;
import kafka.test.annotation.ClusterTest;
import kafka.test.annotation.ClusterTestDefaults;
import kafka.test.annotation.ClusterTests;
import kafka.test.annotation.Type;
import kafka.test.junit.ClusterTestExtensions;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.extension.ExtendWith;
import scala.Console$;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.ArrayOps$;
import scala.collection.StringOps$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.util.matching.Regex;

@ExtendWith(value={ClusterTestExtensions.class})
@ClusterTestDefaults(clusterType=Type.KRAFT)
@Tag(value="integration")
@ScalaSignature(bytes="\u0006\u0005M4Aa\u0002\u0005\u0001\u001b!AA\u0003\u0001B\u0001B\u0003%Q\u0003C\u0003\u001c\u0001\u0011\u0005A\u0004C\u0003!\u0001\u0011\u0005\u0011\u0005C\u0003E\u0001\u0011\u0005\u0011\u0005C\u0003H\u0001\u0011\u0005\u0011\u0005C\u0003N\u0001\u0011\u0005\u0011EA\rNKR\fG-\u0019;b#V|'/^7D_6l\u0017M\u001c3UKN$(BA\u0005\u000b\u0003\u0015\tG-\\5o\u0015\u0005Y\u0011!B6bM.\f7\u0001A\n\u0003\u00019\u0001\"a\u0004\n\u000e\u0003AQ\u0011!E\u0001\u0006g\u000e\fG.Y\u0005\u0003'A\u0011a!\u00118z%\u00164\u0017aB2mkN$XM\u001d\t\u0003-ei\u0011a\u0006\u0006\u00031)\tA\u0001^3ti&\u0011!d\u0006\u0002\u0010\u00072,8\u000f^3s\u0013:\u001cH/\u00198dK\u00061A(\u001b8jiz\"\"!H\u0010\u0011\u0005y\u0001Q\"\u0001\u0005\t\u000bQ\u0011\u0001\u0019A\u000b\u0002OQ,7\u000f\u001e#fg\u000e\u0014\u0018NY3Rk>\u0014X/\u001c*fa2L7-\u0019;j_:\u001cVoY2fgN4W\u000f\u001c\u000b\u0002EA\u0011qbI\u0005\u0003IA\u0011A!\u00168ji\"\"1A\n\u0017.!\t9#&D\u0001)\u0015\tIs#\u0001\u0006b]:|G/\u0019;j_:L!a\u000b\u0015\u0003\u0019\rcWo\u001d;feR+7\u000f^:\u0002\u000bY\fG.^3-\r9Zt(\u0011\"DW\u001dy#g\r\u001d:ue\u0002\"a\n\u0019\n\u0005EB#aC\"mkN$XM\u001d+fgR\f1b\u00197vgR,'\u000fV=qK\u0012\nA'\u0003\u00026m\u0005A1iT0L%\u00063EK\u0003\u00028Q\u0005!A+\u001f9f\u0003\u001d\u0011'o\\6feNl\u0012aA\u0001\fG>tGO]8mY\u0016\u00148oK\u00040eqB\u0014HO\u001d%\u0003uJ!A\u0010\u001c\u0002\u000b-\u0013\u0016I\u0012+,\u000f=\u00124\u0007O\u001d;\u0001v\t!aK\u00040eqB\u0014H\u000f!,\u000f=\u00124\u0007\u000f!;s-:qF\r\u001f9\u0001jJ\u0014A\t;fgR$Um]2sS\n,\u0017+^8sk6\u001cF/\u0019;vgN+8mY3tg\u001a,H\u000e\u000b\u0003\u0005M12EF\u0002\u0018<\u007f\u0005\u00135)A\u0011uKN$xJ\u001c7z\u001f:,'I]8lKJ\fe\u000eZ(oK\u000e{g\u000e\u001e:pY2,'\u000f\u000b\u0003\u0006M1JEF\u0001&MW\u001dy#g\r\u001dLu-k\u0012!A\u0016\b_Ib\u0004h\u0013\u001eL\u0003i!Xm\u001d;EKN\u001c'/\u001b2f#V|'/^7J]j[Wj\u001c3fQ\u00191qFM(9s\u0011\n\u0001+\u0003\u0002Rm\u0005\u0011!l\u0013\u0015\u0005\u0001Mcs\f\u0005\u0002U;6\tQK\u0003\u0002W/\u0006\u0019\u0011\r]5\u000b\u0005aK\u0016a\u00026va&$XM\u001d\u0006\u00035n\u000bQA[;oSRT\u0011\u0001X\u0001\u0004_J<\u0017B\u00010V\u0005\r!\u0016mZ\u0011\u0002A\u0006Y\u0011N\u001c;fOJ\fG/[8oQ\u0011\u0001!M\r\u001f\u0011\u0005\u001d\u001a\u0017B\u00013)\u0005M\u0019E.^:uKJ$Vm\u001d;EK\u001a\fW\u000f\u001c;tQ\u0011\u0001a\r\f7\u0011\u0005\u001dTW\"\u00015\u000b\u0005%,\u0016!C3yi\u0016t7/[8o\u0013\tY\u0007N\u0001\u0006FqR,g\u000eZ,ji\"d\u0013!\\\u0012\u0002]B\u0011q.]\u0007\u0002a*\u0011!lF\u0005\u0003eB\u0014Qc\u00117vgR,'\u000fV3ti\u0016CH/\u001a8tS>t7\u000f")
public class MetadataQuorumCommandTest {
    private final ClusterInstance cluster;

    @ClusterTests(value={@ClusterTest(clusterType=Type.CO_KRAFT, brokers=3, controllers=3), @ClusterTest(clusterType=Type.KRAFT, brokers=3, controllers=3), @ClusterTest(clusterType=Type.CO_KRAFT, brokers=3, controllers=2), @ClusterTest(clusterType=Type.KRAFT, brokers=3, controllers=2), @ClusterTest(clusterType=Type.CO_KRAFT, brokers=2, controllers=3), @ClusterTest(clusterType=Type.KRAFT, brokers=2, controllers=3)})
    public void testDescribeQuorumReplicationSuccessful() {
        String string;
        this.cluster.waitForReadyBrokers();
        JFunction0.mcV.sp & Serializable grabConsoleOutput_f = (JFunction0.mcV.sp & Serializable)() -> MetadataQuorumCommand$.MODULE$.mainNoExit(new String[]{"--bootstrap-server", $this.cluster.bootstrapServers(), "describe", "--replication"});
        ByteArrayOutputStream grabConsoleOutput_out = new ByteArrayOutputStream();
        try {
            Console$.MODULE$.withOut((OutputStream)grabConsoleOutput_out, (Function0)grabConsoleOutput_f);
        }
        finally {
            Console$.MODULE$.out().flush();
        }
        String string2 = string = grabConsoleOutput_out.toString();
        Object var8_1 = null;
        Object var9_2 = null;
        string = null;
        String describeOutput = string2;
        Regex leaderPattern = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("\\d+\\s+\\d+\\s+\\d+\\s+\\d+\\s+[-]?\\d+\\s+Leader\\s+"));
        Regex followerPattern = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("\\d+\\s+\\d+\\s+\\d+\\s+\\d+\\s+[-]?\\d+\\s+Follower\\s+"));
        Regex observerPattern = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("\\d+\\s+\\d+\\s+\\d+\\s+\\d+\\s+[-]?\\d+\\s+Observer\\s+"));
        Object[] outputs = (String[])ArrayOps$.MODULE$.tail$extension(Predef$.MODULE$.refArrayOps((Object[])describeOutput.split("\n")));
        Type type = this.cluster.config().clusterType();
        Type type2 = Type.CO_KRAFT;
        if (!(type != null ? !((Object)((Object)type)).equals((Object)type2) : type2 != null)) {
            Assertions.assertEquals((int)Math.max(this.cluster.config().numControllers(), this.cluster.config().numBrokers()), (int)outputs.length);
        } else {
            Assertions.assertEquals((int)(this.cluster.config().numBrokers() + this.cluster.config().numControllers()), (int)outputs.length);
        }
        Assertions.assertTrue((boolean)leaderPattern.findFirstIn((CharSequence)ArrayOps$.MODULE$.head$extension(Predef$.MODULE$.refArrayOps(outputs))).nonEmpty());
        Assertions.assertEquals((int)1, (int)ArrayOps$.MODULE$.count$extension(Predef$.MODULE$.refArrayOps(outputs), (Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)MetadataQuorumCommandTest.$anonfun$testDescribeQuorumReplicationSuccessful$2(leaderPattern, x$1))));
        Assertions.assertEquals((int)(this.cluster.config().numControllers() - 1), (int)ArrayOps$.MODULE$.count$extension(Predef$.MODULE$.refArrayOps(outputs), (Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)MetadataQuorumCommandTest.$anonfun$testDescribeQuorumReplicationSuccessful$3(followerPattern, x$2))));
        Type type3 = this.cluster.config().clusterType();
        Type type4 = Type.CO_KRAFT;
        if (!(type3 != null ? !((Object)((Object)type3)).equals((Object)type4) : type4 != null)) {
            Assertions.assertEquals((int)Math.max(0, this.cluster.config().numBrokers() - this.cluster.config().numControllers()), (int)ArrayOps$.MODULE$.count$extension(Predef$.MODULE$.refArrayOps(outputs), (Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)MetadataQuorumCommandTest.$anonfun$testDescribeQuorumReplicationSuccessful$4(observerPattern, x$3))));
            return;
        }
        Assertions.assertEquals((int)this.cluster.config().numBrokers(), (int)ArrayOps$.MODULE$.count$extension(Predef$.MODULE$.refArrayOps(outputs), (Function1 & Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)MetadataQuorumCommandTest.$anonfun$testDescribeQuorumReplicationSuccessful$5(observerPattern, x$4))));
    }

    @ClusterTests(value={@ClusterTest(clusterType=Type.CO_KRAFT, brokers=3, controllers=3), @ClusterTest(clusterType=Type.KRAFT, brokers=3, controllers=3), @ClusterTest(clusterType=Type.CO_KRAFT, brokers=3, controllers=2), @ClusterTest(clusterType=Type.KRAFT, brokers=3, controllers=2), @ClusterTest(clusterType=Type.CO_KRAFT, brokers=2, controllers=3), @ClusterTest(clusterType=Type.KRAFT, brokers=2, controllers=3)})
    public void testDescribeQuorumStatusSuccessful() {
        this.cluster.waitForReadyBrokers();
        JFunction0.mcV.sp & Serializable grabConsoleOutput_f = (JFunction0.mcV.sp & Serializable)() -> MetadataQuorumCommand$.MODULE$.mainNoExit(new String[]{"--bootstrap-server", $this.cluster.bootstrapServers(), "describe", "--status"});
        ByteArrayOutputStream grabConsoleOutput_out = new ByteArrayOutputStream();
        try {
            Console$.MODULE$.withOut((OutputStream)grabConsoleOutput_out, (Function0)grabConsoleOutput_f);
        }
        finally {
            Console$.MODULE$.out().flush();
        }
        Object var3_1 = null;
        Object var4_2 = null;
        String[] outputs = grabConsoleOutput_out.toString().split("\n");
        Assertions.assertTrue((boolean)StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("ClusterId:\\s+\\S{22}")).findFirstIn((CharSequence)outputs[0]).nonEmpty());
        Assertions.assertTrue((boolean)StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("LeaderId:\\s+\\d+")).findFirstIn((CharSequence)outputs[1]).nonEmpty());
        Assertions.assertTrue((boolean)StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("LeaderEpoch:\\s+\\d+")).findFirstIn((CharSequence)outputs[2]).nonEmpty());
        Assertions.assertTrue((boolean)StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("HighWatermark:\\s+[-]?\\d+")).findFirstIn((CharSequence)outputs[3]).nonEmpty());
        Assertions.assertTrue((boolean)StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("MaxFollowerLag:\\s+\\d+")).findFirstIn((CharSequence)outputs[4]).nonEmpty());
        Assertions.assertTrue((boolean)StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("MaxFollowerLagTimeMs:\\s+[-]?\\d+")).findFirstIn((CharSequence)outputs[5]).nonEmpty());
        Assertions.assertTrue((boolean)StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("CurrentVoters:\\s+\\[\\d+(,\\d+)*\\]")).findFirstIn((CharSequence)outputs[6]).nonEmpty());
        Type type = this.cluster.config().clusterType();
        Type type2 = Type.CO_KRAFT;
        if (!(type != null ? !((Object)((Object)type)).equals((Object)type2) : type2 != null) && this.cluster.config().numBrokers() <= this.cluster.config().numControllers()) {
            Assertions.assertTrue((boolean)StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("CurrentObservers:\\s+\\[\\]")).findFirstIn((CharSequence)outputs[7]).nonEmpty());
            return;
        }
        Assertions.assertTrue((boolean)StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("CurrentObservers:\\s+\\[\\d+(,\\d+)*\\]")).findFirstIn((CharSequence)outputs[7]).nonEmpty());
    }

    @ClusterTests(value={@ClusterTest(clusterType=Type.CO_KRAFT, brokers=1, controllers=1), @ClusterTest(clusterType=Type.KRAFT, brokers=1, controllers=1)})
    public void testOnlyOneBrokerAndOneController() {
        String string;
        String string2;
        JFunction0.mcV.sp & Serializable grabConsoleOutput_f = (JFunction0.mcV.sp & Serializable)() -> MetadataQuorumCommand$.MODULE$.mainNoExit(new String[]{"--bootstrap-server", $this.cluster.bootstrapServers(), "describe", "--status"});
        ByteArrayOutputStream grabConsoleOutput_out = new ByteArrayOutputStream();
        try {
            Console$.MODULE$.withOut((OutputStream)grabConsoleOutput_out, (Function0)grabConsoleOutput_f);
        }
        finally {
            Console$.MODULE$.out().flush();
        }
        String string3 = string2 = grabConsoleOutput_out.toString();
        Object var3_1 = null;
        Object var4_2 = null;
        string2 = null;
        String statusOutput = string3;
        Assertions.assertEquals((Object)"MaxFollowerLag:         0", (Object)statusOutput.split("\n")[4]);
        Assertions.assertEquals((Object)"MaxFollowerLagTimeMs:   0", (Object)statusOutput.split("\n")[5]);
        JFunction0.mcV.sp & Serializable grabConsoleOutput_f2 = (JFunction0.mcV.sp & Serializable)() -> MetadataQuorumCommand$.MODULE$.mainNoExit(new String[]{"--bootstrap-server", $this.cluster.bootstrapServers(), "describe", "--replication"});
        ByteArrayOutputStream grabConsoleOutput_out2 = new ByteArrayOutputStream();
        try {
            Console$.MODULE$.withOut((OutputStream)grabConsoleOutput_out2, (Function0)grabConsoleOutput_f2);
        }
        finally {
            Console$.MODULE$.out().flush();
        }
        String string4 = string = grabConsoleOutput_out2.toString();
        Object var7_6 = null;
        Object var8_7 = null;
        string = null;
        String replicationOutput = string4;
        Assertions.assertEquals((Object)"0", (Object)replicationOutput.split("\n")[1].split("\\s+")[2]);
    }

    @ClusterTest(clusterType=Type.ZK, brokers=3)
    public void testDescribeQuorumInZkMode() {
        Assertions.assertTrue((boolean)(Assertions.assertThrows(ExecutionException.class, () -> MetadataQuorumCommand$.MODULE$.mainNoExit(new String[]{"--bootstrap-server", $this.cluster.bootstrapServers(), "describe", "--status"})).getCause() instanceof UnsupportedVersionException));
        Assertions.assertTrue((boolean)(Assertions.assertThrows(ExecutionException.class, () -> MetadataQuorumCommand$.MODULE$.mainNoExit(new String[]{"--bootstrap-server", $this.cluster.bootstrapServers(), "describe", "--replication"})).getCause() instanceof UnsupportedVersionException));
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeQuorumReplicationSuccessful$2(Regex leaderPattern$1, String x$1) {
        return leaderPattern$1.findFirstIn((CharSequence)x$1).nonEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeQuorumReplicationSuccessful$3(Regex followerPattern$1, String x$2) {
        return followerPattern$1.findFirstIn((CharSequence)x$2).nonEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeQuorumReplicationSuccessful$4(Regex observerPattern$1, String x$3) {
        return observerPattern$1.findFirstIn((CharSequence)x$3).nonEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeQuorumReplicationSuccessful$5(Regex observerPattern$1, String x$4) {
        return observerPattern$1.findFirstIn((CharSequence)x$4).nonEmpty();
    }

    public MetadataQuorumCommandTest(ClusterInstance cluster) {
        this.cluster = cluster;
    }
}

